#!/usr/bin/env python
# -*- coding:utf-8 -*-

#####################################################
#  BOTAN Image Creator(BIC) ver..1.0
#  Windows Console Program written in Python3
#  Released on Nobember 3, 2025
#  (c) 2025- JA3TDW/Fumio Asai All Rights Reserved.
#####################################################

import os
import sys
import time
import csv
import operator

execPath = os.getcwd()
inputCamFile = 'input.csv'
outputImage = execPath + '/output.img'
temp1CamFile =  execPath + '/temp1.csv'
temp2CamFile =  execPath + '/temp2.csv'
botanHeader = '94A662B29AB26094A662B2A0A86103F042CCFF'

print('\nBOTAN Image Creator(BIC) ver.1.0\n')
print('Input csv file: ' + inputCamFile)
print('Press Enter key if csv file name is OK')
targetCamFile = input('Enter input csv file name: ')
if targetCamFile == '':
    targetCamFile = execPath + '/'  + inputCamFile
else:
    targetCamFile = execPath + '/' + targetCamFile
if os.path.isfile(targetCamFile):
    pass
else:
    print('Could not open input csv file')
    print('May be not exist or wrong file name. Try again!')
    time.sleep(5)
    sys.exit()

imageNumber = input('\nEnter image number: ')
while len(imageNumber) != 2:
        print('Invalid image number. Try again!')
        imageNumber = input('Enter image number: ')

print('\nStart creating output.csv file...')
string = ''
jpgStart = 0
pngStart = 0
jpgEnd = 0
pngEnd = 0
with open(targetCamFile, 'r') as infile, open(temp1CamFile, 'w') as outfile:
    for line in infile:
        if  line[20:58] == botanHeader and line[58:60] == imageNumber:
            s = line[58:60] + ',' + line[60:64] + ',' + line[64:186] +'\n'
            string += s
    outfile.write(string)
if os.path.getsize(temp1CamFile) == 0:
    os.remove(temp1CamFile)
    print('Could not find CAM frame data')
    print('May be not exist or wrong image number...')
    time.sleep(5)
    sys.exit()

with open(temp1CamFile, 'r') as infile, open(temp2CamFile, 'w') as outfile:
    lines = infile.readlines()
    string = ''.join(set(lines))
    outfile.write(string)
    
outputCamFile = execPath + '/' + imageNumber + '_output.csv'
with open(temp2CamFile, 'r') as infile, open(outputCamFile, 'w') as outfile:
    input = csv.reader(infile)
    output = sorted(input, key = operator.itemgetter(1))
    data = csv.writer(outfile, lineterminator = '\n' )
    for r in output:
        data.writerow(r)

with open(outputCamFile, 'r') as f:
    lines = f.readlines()
lenFrames = len(lines)
firstFrame = lines[0]
lastFrame = lines[-1]
firstSeqNum = firstFrame[3:7]
lastSeqNum = lastFrame[3:7]

if 'FFD8' in firstFrame:
    jpgStart = 1
if '89504E470D0A1A0A' in firstFrame:
    pngStart = 1
if 'FFD9' in lastFrame:
    jpgEnd = 1
if '49454E44' in lastFrame:
    pngEnd = 1
if jpgStart == 1:
    print('Found jpeg start marker')
elif pngStart == 1:
    print('Found png start marker')
else:
    print('Could not find start marker')
if jpgEnd == 1:
    print('Found jpeg end marker')
elif pngEnd == 1:
    print('Found png end marker')
else:
    print('Could not find end marker')
print('Image number: ' + imageNumber)
print('Sequence numbers: ' + firstSeqNum + '-' + lastSeqNum)
print('Total frames: ' + str(lenFrames))

string = ''
with open(temp1CamFile, 'w') as f:
    for line in lines:
        s = line[3:7]  +'\n'
        string += s
    f.write(string)
string = ''
with open(temp2CamFile, 'w') as f:
    for i in range(int(lastSeqNum, 16) + 1):
        s =f'{i:04x}'.upper()
        string += s +'\n'
    f.write(string)

with open(temp1CamFile, 'r') as f:
    lines1 = f.read().splitlines()
with open(temp2CamFile, 'r') as f:
    lines2 = f.read().splitlines()
diff = list(set(lines1) ^ set(lines2))
diffSorted = sorted(diff)
print('Missing frames: ' + str(len(diffSorted)))
count = 0
for item in diffSorted:
    print(item, end=' ')
    count += 1
    if count == 10:
        print('\n', end='')
        count = 0

if os.path.isfile(temp1CamFile):
    os.remove(temp1CamFile)
if os.path.isfile(temp2CamFile):
    os.remove(temp2CamFile)

print('\nStart creating output image file...')
string = ''
with open(outputCamFile, 'r') as infile, open(outputImage, 'wb') as outfile:
    for line in infile:
        imageNumber = line[:2]
        s = line[8:].rstrip('\n')
        string += s
    bin =  bytes.fromhex(string)
    outfile.write(bin)

if jpgStart == 1:
    jpgImage = execPath + '/' + imageNumber + '_output.jpg'
    os.rename(outputImage, jpgImage)
    print('Created ' + imageNumber + ' jpeg image file')
elif pngStart == 1:
    pngImage = execPath + '/' + imageNumber + '_output.png'
    os.rename(outputImage, pngImage)
    print('Created ' + imageNumber + ' png image file')
else:
    print('Neither jpeg nor png start maker was found')
    print('Not created image file')
    os.remove(outputImage)
print('done')