/*
** Sound.c
**
** This file countains PSG/SCC emulation stuff for fMSX via the /dev/dsp
** device present in Linux and FreeBSD (and probably in other PC Unices
** using USS(/Lite) (formerly known as VoxWare) sound driver). Also very
** experimental support for Sun's /dev/audio is present.
**
** (C) Ville Hallik (ville@physic.ut.ee) 1996
**
** You can do almost anything you want with this file, provided that notice
** about original author still appears there and in case you make any
** modifications, PLEASE label it as modified version.
**
** Known problems:
** 1. The noise and envelope frequencies may be wrong - I dont have
**    real MSX handy to compare them.
** 2. The seventh bit of port 0xAA is not supported (it's almost impossible
**    to do with the method I use here), fortunately it's not used in most
**    cases.
** 3. Modifications of PSG registers are checked (theoretically ;) once
**    per every SOUND_BUFSIZE/SOUND_RATE seconds. It's about 11ms with the
**    values of 256bytes and 22050Hz, which should be satisfactory for most
**    cases.
** 4. Support for Sun's /dev/audio is crap, but it works somehow ;)
** 5. I don't know how realistic is the emulation of SCC chip.
**
** last modified on Sat Apr 22 1996
*/
#include "P6.h"

#ifndef SOUND
int InitSound(void);
void TrashSound(void);
void FlushSound(void);
void StopSound(void);
void ResumeSound(void);
void PSGOut(byte R,byte V);
//extern int UseSound; // deleted
int UseSound;	 // added       compile for disabling -DSOUND
int newUseSound; // added                    2004/4/24  Windy
#endif

#ifdef UNIX
#ifdef SOUND

#define FREQ 2052654284
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "Sound.h"


#ifdef SUN_AUDIO

  //#ifdef PAGESIZE
  //#undef PAGESIZE
  //#endif PAGESIZE

  //#include <sys/audioio.h>
  //#include <sys/conf.h>
  //#include <stropts.h>
  //#include <signal.h>

static unsigned char dsp_ulaw[256] = { 
    31,   31,   31,   32,   32,   32,   32,   33, 
    33,   33,   33,   34,   34,   34,   34,   35, 
    35,   35,   35,   36,   36,   36,   36,   37, 
    37,   37,   37,   38,   38,   38,   38,   39, 
    39,   39,   39,   40,   40,   40,   40,   41, 
    41,   41,   41,   42,   42,   42,   42,   43, 
    43,   43,   43,   44,   44,   44,   44,   45, 
    45,   45,   45,   46,   46,   46,   46,   47, 
    47,   47,   47,   48,   48,   49,   49,   50, 
    50,   51,   51,   52,   52,   53,   53,   54, 
    54,   55,   55,   56,   56,   57,   57,   58, 
    58,   59,   59,   60,   60,   61,   61,   62, 
    62,   63,   63,   64,   65,   66,   67,   68, 
    69,   70,   71,   72,   73,   74,   75,   76, 
    77,   78,   79,   81,   83,   85,   87,   89, 
    91,   93,   95,   99,  103,  107,  111,  119, 
   255,  247,  239,  235,  231,  227,  223,  221, 
   219,  217,  215,  213,  211,  209,  207,  206, 
   205,  204,  203,  202,  201,  200,  199,  198, 
   197,  196,  195,  194,  193,  192,  191,  191, 
   190,  190,  189,  189,  188,  188,  187,  187, 
   186,  186,  185,  185,  184,  184,  183,  183, 
   182,  182,  181,  181,  180,  180,  179,  179, 
   178,  178,  177,  177,  176,  176,  175,  175, 
   175,  175,  174,  174,  174,  174,  173,  173, 
   173,  173,  172,  172,  172,  172,  171,  171, 
   171,  171,  170,  170,  170,  170,  169,  169, 
   169,  169,  168,  168,  168,  168,  167,  167, 
   167,  167,  166,  166,  166,  166,  165,  165, 
   165,  165,  164,  164,  164,  164,  163,  163, 
   163,  163,  162,  162,  162,  162,  161,  161, 
   161,  161,  160,  160,  160,  160,  159,  159, 
};

  //#define AUDIO_CONV(A) (dsp_ulaw[0xFF&(128+(A))])

/*
** Size of audio buffer
*/
   //#define SOUND_BUFSIZE 256


/* Do not change this! It's not implemented. */
  //#define SOUND_RATE 8000

#else /* SUN_AUDIO */

#ifdef LINUX
#include <linux/soundcard.h>
#else
#include <machine/soundcard.h>		// modifed by windy 2002/4/13
#endif

#define AUDIO_CONV(A) (128+(A))

	 /*
	 ** Output rate (Hz)
	 */
	//#ifndef SOUND_RATE
	//#define SOUND_RATE 22050
	//#endif SOUND_RATE
	
	/*
	** Buffer size. SOUND_BUFSIZE should be equal to (or at least less than)
	** 2 ^ SOUND_BUFSIZE_BITS
	*/
	//#define SOUND_BUFSIZE 256
	//#define SOUND_BUFSIZE_BITS 8

	/*
	** Number of audio buffers to use. Must be at least 2, but bigger value
	** results in better behaviour on loaded systems (but output gets more
	** delayed)
	*/
	//#define SOUND_NUM_OF_BUFS 8

#endif SUN_AUDIO

pid_t soundchildpid=0;
int soundpipe[2];
int sounddev=-1;
int sound_rate=SOUND_RATE;
int UseSound=1;
int UseSCC=1;
int newUseSound;

unsigned char envforms[16][32] = {
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	  15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0 },
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 },
	{ 15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0,
	  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	  15, 14, 13, 12, 11, 10,  9,  8,  7,  6,  5,  4,  3,  2,  1,  0 },
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 }
};

void SoundMainLoop(void);

void TrashSound(void)
{
  int J;
  if(soundchildpid) { kill(soundchildpid,SIGKILL);wait(&J); }
  if(sounddev!=-1) close(sounddev);
}

int OpenSoundDev(void)
{
  int I,J,K;
  
#ifdef SUN_AUDIO

  if(Verbose) printf("  Opening /dev/audio...");
  if((sounddev=open("/dev/audio",O_WRONLY | O_NONBLOCK))==-1)
  { if(Verbose) puts("FAILED");return(0); }

  /*
  ** Sun's specific initialization should be here...
  ** We assume, that it's set to 8000kHz u-law mono right now.
  */

#else

  /*** At first, we need to open /dev/dsp: ***/
  if(Verbose) printf("  Opening /dev/dsp...");
  if((sounddev=open("/dev/dsp",O_WRONLY | O_NONBLOCK))==-1)
  { if(Verbose) puts("FAILED");return(0); }

  if(Verbose) printf("OK\n  Setting mode: 16bit...");

  J=AFMT_S16_LE;I=(ioctl(sounddev,SNDCTL_DSP_SETFMT,&J)<0);
  if(!I)
  {
    if(Verbose) printf("mono...");
    J=0;I|=(ioctl(sounddev,SNDCTL_DSP_STEREO,&J)<0);
  }
  if(I) { if(Verbose) puts("FAILED");return(0); }
  /*** Set sampling rate ***/
  if(!I)
  {
    if(Verbose) printf("OK\n  Setting sampling rate: %dHz...",sound_rate);
    I|=(ioctl(sounddev,SNDCTL_DSP_SPEED,&sound_rate)<0);
    if(Verbose) printf("(got %dHz)...",sound_rate);
  }
  if(I) { if(Verbose) puts("FAILED");return(0); }
  /*** Here we set the number of buffers to use **/
  if(!I)
  {

#if 1
    if(Verbose) printf("OK\n  Adjusting buffers: %d buffers %d bytes each...",
     SOUND_NUM_OF_BUFS, 1<<SOUND_BUFSIZE_BITS);
    J=K=SOUND_BUFSIZE_BITS|(SOUND_NUM_OF_BUFS<<16);
    I|=(ioctl(sounddev,SNDCTL_DSP_SETFRAGMENT,&J)<0);

    if((J & 0xffff)<16) J=(J& 0xffff0000) | (1<<(J&0xffff));
    K=(1<<SOUND_BUFSIZE_BITS)| (SOUND_NUM_OF_BUFS<<16);
    printf("J=%X K=%X \n",J,K);
    if( J != K ) {
      if(Verbose) printf("(got %d buffers %d bytes each)...",
       J>>16,1<<(J&0xFFFF));
//     if((J>>16) < SOUND_NUM_OF_BUFS) {I=-1; printf("line:%d",__LINE__);}
//     if((J&0xffff) !=(1<<SOUND_BUFSIZE_BITS)) {I=-1; printf("line %d",__LINE__); }
//     if((J&0xffff) !=(1<<8)) {I=-1; printf("line %d",__LINE__); }

      I=-1;
    }
#endif
  }
  if(I) { if(Verbose) puts("FAILED");return(0); }

#endif SUN_AUDIO

  if(Verbose) puts("OK");
  return(1);
}

int InitSound(void )
{

  if(!UseSound) return;

  if(Verbose) puts("Starting sound server:");

  UseSound=0;sounddev=-1;soundchildpid=0;

  if( !OpenSoundDev() ) return(0);

  if(Verbose) printf("  Opening pipe...");
  if(pipe(soundpipe)==-1) { if(Verbose) puts("FAILED");return(0); }
  if(Verbose) { printf("OK\n  Forking..."); fflush( stdout ); }

  switch(soundchildpid=fork())
  {
    case -1: if(Verbose) puts("FAILED");
             return(0);
    case 0:  close(soundpipe[1]);
             if( !(Verbose&32) ) Verbose=0;
             SoundMainLoop();
             break;
    default: if(Verbose) puts("OK");
             close(soundpipe[0]);
             fcntl( soundpipe[1], F_SETFL, O_NONBLOCK );
             close(sounddev);
  }
  UseSound=1;return(1);
}

void SoundOut(byte R,byte V)
{
  static unsigned char Buf[1024];
  static int Buffered = 0;

  if(UseSound) {
    if((R==0xFF)||(Buffered>=sizeof(Buf))) {
      write(soundpipe[1],Buf,Buffered);
      Buffered = 0;
    }
    if(R!=0xFF) {
      Buf[Buffered++]=R; Buf[Buffered++]=V;
    }
  }
}

void FlushSound(void)      { SoundOut(0xFF,0); }
void StopSound(void)       { if(UseSound) kill(soundchildpid,SIGUSR1); }
void ResumeSound(void)     { if(UseSound) kill(soundchildpid,SIGUSR2); }
void PSGOut(byte R,byte V) { if(R< 0xc0||R==0xFF) SoundOut(R,V); }
void SCCOut(byte R,byte V) { if(UseSCC&&R<0x90) SoundOut(R+0x10,V); }

void SoundSignal( int sig )
{
  static ok_to_continue=0;
  
  switch( sig ) {
  case SIGUSR1:
    /* Suspend execution, until SIGUSR2 catched */
#ifndef SUN_AUDIO
    ioctl( sounddev, SNDCTL_DSP_RESET );
#endif /* not SUN_AUDIO */
    close( sounddev );
    ok_to_continue=0;
    while( !ok_to_continue ) pause();
    if( Verbose ) puts( "Soundserver: Re-opening sound device:" );
    OpenSoundDev();
    if( Verbose ) fflush( stdout );
    signal( SIGUSR1, SoundSignal );
    break;
  case SIGUSR2:
    ok_to_continue=1;
    signal( SIGUSR2, SoundSignal );
    break;
  }
}

void SoundMainLoop( void )
{
  int incr0=0, incr1=0, incr2=0, increnv=0, incrnoise=0;
  int statenoise=0, noisegen=1;
  int counter0, counter1, counter2, countenv, countnoise;
  int r=0, v=0, i, j=0, rc, x;
  int vol0, vol1, vol2, volnoise, envelope = 15;
  int c0, c1, l0, l1, l2;
  unsigned char buf[2];
  signed short soundbuf[SOUND_BUFSIZE];
  unsigned char PSG[ 0xc0];
  pid_t parent;
  /* Variables for SCC emulation: */
  int SCCactive=0, SCCoutv=0;
  int SCCinc1=0, SCCinc2=0, SCCinc3=0, SCCinc4=0, SCCinc5=0;
  int SCCcnt1=0, SCCcnt2=0, SCCcnt3=0, SCCcnt4=0, SCCcnt5=0;
  int SCCvol1, SCCvol2, SCCvol3, SCCvol4, SCCvol5;
  unsigned char SCC[256];
  int written ,p;
	
  parent = getppid();
  signal( SIGUSR1, SoundSignal );
  signal( SIGUSR2, SoundSignal );
	
  for( i=0; i<16; ++i ) PSG[i] = 0;
  PSG[7] = 077;
  PSG[8] = 8;
  PSG[9] = 8;
  PSG[10] = 8;
  for( i=0; i<256; ++i ) SCC[i] = 0;
	
  fcntl( soundpipe[0], F_SETFL, O_NONBLOCK );

  ym2203_init();		// ym2203 init

  for( ;; ) 
   {
    /* check for parent's existence */
    if( parent != getppid() ) {
      fprintf( stderr, "Parent died\n" );
      exit( 1 );
      }
    /* Read from pipe: */
    for( ;; ) 
     {
      rc = read( soundpipe[0], buf, v < 0 ? 1 : 2 );
      if( rc == 0 ) break;
      if( rc < 0 ) {
        if( errno == EWOULDBLOCK ) {
          break;
        } else {
          perror( "read" );
          exit( 1 );
        }
      }
      if( v == -1 ) {
        v = buf[0];
      } else {
        r = buf[0];
        if( rc == 1 ) {
          v = -1;
          break;
        }
        v = buf[1];
      }
			
      if( r< 0xc0) 
		{
         //printf("r=%02X,v=%02X\n",r,v);		
        PSG[r] = v;
		ym2203_setreg(r,v);		// ym2203 setreg
      } 
     }

    if( sounddev == -1 ) {
      sleep(1);
      continue;
    }
	ym2203_makewave( soundbuf ,sizeof(soundbuf));	// ym2203 makewave

#ifdef SUN_AUDIO

    /*
    ** Flush output first, don't care about return status.
    ** After this write next buffer of audio data. This method
    ** produces a horrible click on each buffer :( Any ideas,
    ** how to fix this?
    */

    ioctl( sounddev, AUDIO_DRAIN );
    write( sounddev, soundbuf, SOUND_BUFSIZE );

#else

    /*
    ** We'll block here until next DMA buffer becomes free.
    ** It happens once per (1<<SOUND_BUFSIZE_BITS)/sound_rate seconds.
    */
#if 0
    {
     FILE *fp;
     fp=fopen("test.dat","a+");
     if( fp) 
        {
         if( fwrite(soundbuf, sizeof(soundbuf)/2,1,fp) !=1)
              printf("fwrite failed\n");
        }
     else
        {
         printf("open failed\n");
        }
     fclose(fp);
    }	
#endif

    p=0;
    do {
        written=write( sounddev, soundbuf+p, sizeof(soundbuf)/2-p /*SOUND_BUFSIZE*/ );
        if( written >0 )
            {
             p += written;
          //   printf("write() written=%d\n",written); 
            }
    	if( written <0 && errno!=0 && errno!= EAGAIN && errno!= EINTR)
            {
          //   printf("write() failed %d \n",errno);
             break;
            }
        if (p< written || ((written<0) && ((errno==0)||(errno==EAGAIN)) ) )
           {
		 // printf("sound: sleep & retrying... \n");
                 usleep(1);
             }

      }
   while( p < written ); 

#endif SUN_AUDIO

  }
}

#endif SOUND
#endif
