﻿Imports System.IO
Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports System.Threading

Public Class Form1
    Const NoTrial As Integer = 10   ' 試行回数
    Const NoClass As Integer = 5      ' クラス数
    Const NoGroup As Integer = 5    ' グループ数
    Const NoStep As Integer = 5      ' ステップ数
    Const Splitter As String = vbTab
    Dim PauseTime() As Boolean = {True, True, False, True, True, False, True, True, True, False}     ' チャットを行うタイミング
    Dim TrialCounter As Integer     ' 試行回数のカウンター
    Dim StepData(1, NoTrial - 1) As Integer     ' 0:ステップデータ 1:進度データ
    Dim ClassNO, GroupName As String    ' クラス番号とグループ名
    ' 通信用変数
    Dim ClSocket As Socket
    Dim ClStream As NetworkStream
    Dim ClReader As StreamReader
    Dim ClWriter As StreamWriter
    Dim ClThread As Thread
    Dim SysLog As ArrayList = New ArrayList()      ' System Log

    ' 代表者会議用デリゲート
    Delegate Sub RTBDelegate(ByVal s As String)
    ' ボタン設定用デリゲート
    Delegate Sub btnDelegate(ByVal btnObj As Button, ByVal OnOff As Boolean)
    ' メッセージボックス用デリゲート
    Delegate Function MsgDelegate(ByVal owner As IWin32Window, ByVal s As String, ByVal cptn As String, _
                                  ByVal btn As MessageBoxButtons, ByVal icn As MessageBoxIcon)
    ' データグリッドビュー用デリゲート
    Delegate Sub iDGVDelegate(ByVal iRow As Integer, ByVal jColumn As Integer, ByVal dgv As DataGridView, ByVal i As Integer)
    Delegate Sub DGVHeaderDelegate(ByVal iRow As Integer, ByVal dgv As DataGridView, ByVal s As String)
    Delegate Sub DGVMethodDelegate(ByVal sizemode As DataGridViewRowHeadersWidthSizeMode)
    ' Close デリゲート
    Delegate Sub CloseDelegate()

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        ' フォームの初期化
        Initialize_Form()
        ' サーバーへの接続
        Connect_Server()
    End Sub
    ' Delegate用プログラム
    ' RitchTextBoxに書き込む
    Public Sub Set_RTB(ByVal s As String)
        RichTextBox1.AppendText(s & vbCrLf)
    End Sub
    ' ボタンの設定
    Public Sub Set_Btn(ByVal btn As Button, ByVal OnOff As Boolean)
        btn.Enabled = OnOff
    End Sub
    ' データグリッドビュー用デリゲート
    Public Sub Set_iDGV(ByVal iRow As Integer, ByVal jColumn As Integer, ByVal dgv As DataGridView, ByVal i As Integer)
        dgv.Item(jColumn, iRow).Value = i
    End Sub
    Public Sub Set_DGVheader(ByVal iRow As Integer, ByVal dgv As DataGridView, ByVal s As String)
        dgv.Rows(iRow).HeaderCell.Value = s
    End Sub
    ' サーバーへの接続
    Private Sub Connect_Server()
        Dim tIPaddr As String = ""
        Dim SvHostEntry As IPHostEntry
        Dim SvAddress As IPAddress = Nothing
        Dim SvPort As Integer
        Dim SvEndPoint As EndPoint
        Dim i As Integer

        ' IPアドレスとポート番号をファイルから読み込む
        Get_IPPort(tIPaddr, SvPort)
        If SvPort = 0 Then
            End
        End If

        ' サーバーとの接続
        Try
            ClSocket = New Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp)
            SvHostEntry = Dns.GetHostEntry(tIPaddr)
            For i = 0 To SvHostEntry.AddressList.Length - 1
                If SvHostEntry.AddressList(i).AddressFamily = AddressFamily.InterNetwork Then
                    SvAddress = SvHostEntry.AddressList(i)
                    Exit For
                End If
            Next
            SvEndPoint = New IPEndPoint(SvAddress, SvPort)
            ClSocket.Connect(SvEndPoint)
            ClStream = New NetworkStream(ClSocket)
            ClReader = New StreamReader(ClStream, Encoding.UTF8)
            ClWriter = New StreamWriter(ClStream, Encoding.UTF8)
            ClWriter.NewLine = vbNewLine
            ClWriter.AutoFlush = True
            ' 交信用スレッドの起動
            ClThread = New Thread(AddressOf ClSessionThread)
            ClThread.IsBackground = True
            ClThread.Start()
        Catch ex As Exception
            MessageBox.Show(ex.Message, "サーバー接続エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Me.Close()
        End Try

    End Sub

    ' 交信用スレッド
    Sub ClSessionThread()
        Dim Buffer As String
        Dim EndCommand As Boolean

        Try
            Do
                Buffer = ClReader.ReadLine()
                If IsNothing(Buffer) Then
                    Exit Do
                End If
                ' 受信データ処理
                EndCommand = Handling_Command(Buffer)
            Loop Until EndCommand
            'Output_Syslog()
            ClSocket.Close()
        Catch ex As Exception
            Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() {Me, "通信システムエラー" & ex.Message, _
                            "System Error", MessageBoxButtons.OK, MessageBoxIcon.Error})
            ClSocket.Close()
            Me.Invoke(New CloseDelegate(AddressOf Me.Close))
        End Try
    End Sub
    ' ファイル名を生成
    Private Function Gen_FileName(ByVal t As String, ByVal clno As Integer) As String
        Dim NowDate As Date = Date.Now
        Dim s As String
        s = t & clno & "-" & String.Format("{0:0000}{1:00}{2:00}{3:00}{4:00}{5:00}", NowDate.Year, _
                                                   NowDate.Month, NowDate.Day, NowDate.Hour, NowDate.Minute, _
                                                    NowDate.Second) & ".csv"
        Gen_FileName = s
    End Function
    ' Syslog File 出力
    Private Sub Output_Syslog()
        Dim fName As String
        fName = Gen_FileName("SysLog", 99)
        Dim fs As FileStream = New FileStream(fName, FileMode.Create)
        Dim sw As StreamWriter = New StreamWriter(fs, Encoding.GetEncoding("shift_jis"))
        With SysLog
            For i = 0 To .Count - 1
                sw.WriteLine(.Item(i).ToString)
            Next
            sw.Close()
        End With
    End Sub
    ' サーバーからのコマンドを処理
    ' 終了コマンドが来ればTrueを返す
    Private Function Handling_Command(ByVal Buffer As String) As Boolean
        Dim cmd() As String
        'Log_SystemData("Rcv>" & Buffer)
        Handling_Command = False
        cmd = Buffer.Split(Splitter)
        Select Case cmd(0)
            Case "EERR"     ' エントリーエラー
                ' エントリーボタンをOnにし再入力メッセージの表示
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnEntry, True})
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "エントリー情報に誤りがあります。再入力してください。", _
                                "Entry Error", MessageBoxButtons.OK, MessageBoxIcon.Error})
            Case "EXSTART"  ' 実験開始
                ' ステップ入力ボタンをonにし，メッセージを表示
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnStep, True})
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "ただ今から実験を開始します。ステップ数を選択し，ステップ入力ボタンを押してください。", _
                                "実験開始", MessageBoxButtons.OK, MessageBoxIcon.Information})
            Case "EXEND"    ' 実験終了
                ' ステップ入力ボタンをOffにし，終了メッセージを表示
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnStep, False})
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "これで実験を終了します。お疲れ様でした。", "実験終了", _
                                MessageBoxButtons.OK, MessageBoxIcon.Information})
                Handling_Command = True
            Case "PRGRSS"    ' 進度情報を受信
                ' 受信した進度情報と累積進度を表示
                Set_ProgressTable(cmd(1))
                ' 受信確認メッセージを表示
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "第" & (TrialCounter + 1) & "回の進度は" & StepData(1, TrialCounter) & _
                                "でした。", "進度受信確認", MessageBoxButtons.OK, MessageBoxIcon.Information})
                '' ステップ入力ボタンをOn 3，6，10回目はOffのまま
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnStep, PauseTime(TrialCounter)})
                ' 試行回数のカウントアップ
                TrialCounter += 1
            Case "ALLDATA"  ' クラス内順位と進度
                ' 成績一覧表の表示
                Set_GradeTable(cmd)
                ' 受信確認メッセージを表示
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "第" & TrialCounter & "回の各グループの順位が出ました。成績一覧表で確認してください。", _
                                "順位受信確認", MessageBoxButtons.OK, MessageBoxIcon.Information})
            Case "CHTSTART" ' チャットの開始
                ' メッセージ送信ボタンをOn ステップ入力ボタンをOff
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnMessage, True})
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnStep, False})
                ' 受信確認メッセージを表示
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "話し合いの時間になりました。メッセージ入力欄にメッセージを入力し，メッセージ送信ボタンを押すとメッセージを送ることができます。", _
                                "話し合い開始", MessageBoxButtons.OK, MessageBoxIcon.Information})
                Me.Invoke(New RTBDelegate(AddressOf Set_RTB), "―――――話し合い開始―――――")
            Case "CHTEND"   ' チャットの終了
                ' ステップ入力ボタンをOn メッセージ送信ボタンをOff
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnStep, True})
                Me.Invoke(New btnDelegate(AddressOf Set_Btn), New Object() {btnMessage, False})
                ' 受信確認メッセージを表示
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "話し合いの時間が終わりました。", "話し合い終了", MessageBoxButtons.OK, MessageBoxIcon.Information})
                Me.Invoke(New RTBDelegate(AddressOf Set_RTB), "―――――話し合い終了―――――")
            Case "MSG"      ' チャットメッセージ
                Output_Message(cmd)
            Case Else       ' 不正なコマンド
                Me.Invoke(New MsgDelegate(AddressOf MessageBox.Show), New Object() _
                          {Me, "不正なコマンドを受信しました" & cmd(0), "システムエラー", MessageBoxButtons.OK, MessageBoxIcon.Error})
        End Select
    End Function
    ' チャットメッセージを表示
    Private Sub Output_Message(ByRef cmd() As String)
        Dim i As Integer
        Dim s As String
        s = ""
        For i = 4 To cmd.GetUpperBound(0)
            s &= cmd(i)
        Next
        Me.Invoke(New RTBDelegate(AddressOf Set_RTB), cmd(2) & "-" & cmd(3) & ">" & s)
    End Sub
    ' 成績一覧表を作成
    Private Sub Set_GradeTable(ByRef cmd() As String)
        Dim i As Integer
        If TrialCounter < NoTrial Then
            ' 順位を表示
            For i = 1 To NoGroup
                Me.Invoke(New iDGVDelegate(AddressOf Set_iDGV), New Object() {0, i - 1, DataGridView2, Integer.Parse(cmd(i * 2 - 1))})
            Next
        Else
            ' 順位と累積進度を表示
            Me.Invoke(New DGVHeaderDelegate(AddressOf Set_DGVheader), New Object() {1, DataGridView2, "累積進度"})
            For i = 1 To NoGroup
                Me.Invoke(New iDGVDelegate(AddressOf Set_iDGV), New Object() {0, i - 1, DataGridView2, Integer.Parse(cmd(i * 2 - 1))})
                Me.Invoke(New iDGVDelegate(AddressOf Set_iDGV), New Object() {1, i - 1, DataGridView2, Integer.Parse(cmd(i * 2))})
            Next
            Me.Invoke(New DGVMethodDelegate(AddressOf DataGridView2.AutoResizeRowHeadersWidth), DataGridViewRowHeadersWidthSizeMode.AutoSizeToAllHeaders)
        End If
    End Sub
    ' 進度情報を進度表に表示
    Private Sub Set_ProgressTable(ByVal Prg As String)
        Dim i, total As Integer
        StepData(1, TrialCounter) = Integer.Parse(Prg)
        ' 累積進度を計算
        total = 0
        For i = 0 To TrialCounter
            total += StepData(1, i)
        Next
        Me.Invoke(New iDGVDelegate(AddressOf Set_iDGV), New Object() {0, TrialCounter, DataGridView1, StepData(0, TrialCounter)})
        Me.Invoke(New iDGVDelegate(AddressOf Set_iDGV), New Object() {1, TrialCounter, DataGridView1, StepData(1, TrialCounter)})
        Me.Invoke(New iDGVDelegate(AddressOf Set_iDGV), New Object() {2, TrialCounter, DataGridView1, total})
    End Sub
    Private Sub ClEndSession()
        If Not IsNothing(ClSocket) Then
            ClSocket.Close()
        End If
    End Sub
    ' IPアドレスとポート番号をファイルから読み込む
    Private Sub Get_IPPort(ByRef tIPaddr As String, ByRef tPortNo As Integer)
        Dim FPath As String = "IPPort.txt"
        Dim FRead As StreamReader
        Dim buffer, cmd() As String
        Dim i As Integer = 0
        FRead = Nothing
        tIPaddr = ""
        tPortNo = 0
        Try
            FRead = New StreamReader(FPath)
            buffer = FRead.ReadLine
            Do Until buffer Is Nothing Or i >= 2
                cmd = buffer.Split("=")
                If cmd.Length = 2 Then
                    If String.Compare(cmd(0), "IPAddress") = 0 Then
                        tIPaddr = cmd(1)
                        i = i + 1
                    ElseIf String.Compare(cmd(0), "PortNo") = 0 Then
                        tPortNo = Integer.Parse(cmd(1))
                        i = i + 1
                    End If
                End If
                buffer = FRead.ReadLine
            Loop
        Catch ex As FileNotFoundException
            MessageBox.Show("ファイルが見つかりません", "ファイルエラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
        Catch ex As UnauthorizedAccessException
            MessageBox.Show("ファイルのアクセス権がありません", "ファイルエラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
        Catch ex As IOException
            MessageBox.Show(ex.Message, "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
        Finally
            If FRead IsNot Nothing Then
                FRead.Close()
            End If
        End Try
    End Sub
    ' フォームの初期化
    Private Sub Initialize_Form()
        Dim i, j As Integer
        ' クラス選択リストの初期化
        numClass.Maximum = 5
        numClass.Minimum = 0
        numClass.Value = 0
        numClass.ReadOnly = True
        ' グループ選択リストの初期化
        For i = Strings.Asc("A") To Strings.Asc("E")
            domGroup.Items.Add(Strings.Chr(i))
        Next
        domGroup.ReadOnly = True
        ' ステップ選択リストの初期化
        numStep.Maximum = 5
        numStep.Minimum = 1
        numStep.Value = 1
        numStep.ReadOnly = True
        ' 進度表の初期化
        DataGridView1.ColumnCount = NoTrial
        DataGridView1.RowCount = 3
        DataGridView1.AutoSize = True
        For i = 1 To NoTrial
            DataGridView1.Columns(i - 1).HeaderText = "第" & i & "回"
            DataGridView1.AutoResizeColumn(i - 1)
        Next
        DataGridView1.Rows(0).HeaderCell.Value = "入力ステップ"
        DataGridView1.Rows(1).HeaderCell.Value = "進度"
        DataGridView1.Rows(2).HeaderCell.Value = "累積進度"
        DataGridView1.AutoResizeRowHeadersWidth(DataGridViewRowHeadersWidthSizeMode.AutoSizeToAllHeaders)
        ' 成績一覧表
        DataGridView2.ColumnCount = NoGroup
        DataGridView2.RowCount = 2
        j = Strings.Asc("A")
        For i = j To Strings.Asc("E")
            DataGridView2.Columns(i - j).HeaderText = "グループ" & Strings.Chr(i)
            DataGridView2.AutoResizeColumn(i - j)
        Next
        DataGridView2.Rows(0).HeaderCell.Value = "順位"
        DataGridView2.Rows(1).HeaderCell.Value = "　　　　"
        DataGridView2.AutoResizeRowHeadersWidth(DataGridViewRowHeadersWidthSizeMode.AutoSizeToAllHeaders)
        btnEntry.Enabled = True
        btnStep.Enabled = False
        btnMessage.Enabled = False
        TrialCounter = 0
    End Sub
    ' エントリーボタンの処理
    Private Sub btnEntry_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEntry.Click
        ClassNO = numClass.Value
        GroupName = domGroup.SelectedItem
        ' クラス番号とグループ名をチェック
        If ClassNO = "0" Then
            btnEntry.Enabled = True
            MessageBox.Show(Me, "クラス番号を選択してください。", "クラス番号エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        If GroupName = "" Then
            btnEntry.Enabled = True
            MessageBox.Show("グループ名を選択してください。", "グループ名エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        Try
            ' クラス番号とグループ名を送信し，エントリーボタンをOff
            ClWriter.WriteLine("ENTRY" & Splitter & ClassNO & Splitter & GroupName)
            Log_SystemData("Send>" & "ENTRY" & Splitter & ClassNO & Splitter & GroupName)
            btnEntry.Enabled = False
        Catch ex As Exception
            MessageBox.Show("システムエラー" & ex.Message, "Entry System Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
    ' ステップ入力ボタンの処理
    Private Sub btnStep_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStep.Click
        Dim InputStep As String
        InputStep = numStep.Value
        If InputStep = "" Then
            btnStep.Enabled = True
            MessageBox.Show(Me, "ステップを選択してください。", "ステップ入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        Try
            ' クラス番号，グループ名，ステップ番号を送信し，ステップ入力ボタンをOff
            ClWriter.WriteLine("STEP" & Splitter & ClassNO & Splitter & GroupName & Splitter & InputStep)
            Log_SystemData("Send>" & "STEP" & Splitter & ClassNO & Splitter & GroupName & Splitter & InputStep)
            ' 入力ステップを保存
            StepData(0, TrialCounter) = Integer.Parse(InputStep)
            btnStep.Enabled = False
        Catch ex As Exception
            MessageBox.Show(Me, "システムエラー" & ex.Message, "Step Input System Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
    ' メッセージ送信ボタンの処理
    Private Sub btnMessage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMessage.Click
        Dim msgText As String
        msgText = TextBox1.Text
        ' 入力メッセージの有無をチェック
        If msgText = "" Then
            btnMessage.Enabled = True
            MessageBox.Show(Me, "メッセージを入力してください。", "メッセージ入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Exit Sub
        End If
        Try
            ' クラス番号，グループ名，ステップ番号を送信し，ステップ入力ボタンをOff
            ClWriter.WriteLine("MSG" & Splitter & TrialCounter & Splitter & _
                               ClassNO & Splitter & GroupName & Splitter & msgText)
            Log_SystemData("Send>" & "MSG" & Splitter & TrialCounter & Splitter & _
                               ClassNO & Splitter & GroupName & Splitter & msgText)
            TextBox1.Text = ""
        Catch ex As Exception
            MessageBox.Show(Me, "システムエラー" & ex.Message, "Send Message System Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
    ' Syslog Data 登録
    Sub Log_SystemData(ByVal s As String)
        Dim NowDate As Date = Date.Now
        SyncLock SysLog.SyncRoot
            SysLog.Add(String.Format("{0:00}:{1:00}:{2:00} ", _
                                     NowDate.Hour, NowDate.Minute, NowDate.Second) & " " & s)
        End SyncLock
    End Sub
End Class
