﻿Imports System.IO
Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports System.Threading
Module Module1
    Public ClientList As ArrayList = New ArrayList()    ' 接続クライアントのクラスリスト
    Delegate Sub DisplayDlgt(ByVal s As String)     ' リストボックスへの表示用デリゲート
    Delegate Function MsgDlgt(ByVal owner As IWin32Window, ByVal s As String, ByVal cptn As String, ByVal btn As MessageBoxButtons, ByVal icn As MessageBoxIcon)
End Module
Public Class Form1
    Private Sub Form1_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        Dim LThread As Thread
        ' クライアントとの接続を行うスレッドを起動
        LThread = New Thread(AddressOf ListenThread)
        LThread.IsBackground = True
        LThread.Start()
    End Sub
    ' クライアントとの接続を行うスレッド
    Private Sub ListenThread()
        Dim ListenSocket As Socket  ' 待機ソケット
        Dim ComSocket As Socket     ' 通信ソケット
        Dim SvAddress As IPAddress  ' IPアドレス
        Dim SvPort As Integer = 50000       ' ポート番号
        Dim SvEndPoint As EndPoint
        Dim SvComm As ServerCommClass       ' サーバーの送受信を行うクラスでクライアント毎に作成

        Try
            ' 待機ソケット作成
            ListenSocket = New Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp)
            SvAddress = IPAddress.Any       '全てのネットワークインターフェースで待機
            SvEndPoint = New IPEndPoint(SvAddress, SvPort)  ' IPアドレスとポート番号からEndPointを作成
            ListenSocket.Bind(SvEndPoint)       ' ソケットとEndPointを関連付ける
            ListenSocket.Listen(10)         '待機を開始 接続待ちは最大10
            Do
                ' クライアントからの接続要求を受付け，新しいソケットを作成する
                ComSocket = ListenSocket.Accept
                ' 通信用のクラスを作成
                SvComm = New ServerCommClass(ComSocket, Me)
            Loop
        Catch ex As Exception
            Me.Invoke(New MsgDlgt(AddressOf MessageBox.Show), New Object() {Me, ex.Message, "接続スレッドエラー", MessageBoxButtons.OK, MessageBoxIcon.Error})
        End Try
    End Sub
    Public Sub Display(ByVal s As String)
        ListBox1.Items.Add(s)
    End Sub
End Class
' Serverの通信処理を行うクラス
Public Class ServerCommClass
    Dim ClsSocket As Socket
    Dim MainForm As Form1
    Dim ClsStream As NetworkStream
    Dim ClsReader As StreamReader
    Dim ClsWriter As StreamWriter
    Dim ClientName As String

    Public Sub New(ByVal ComSocket As Socket, ByVal MForm As Form1)
        Dim Receive As Thread
        ClsSocket = ComSocket   ' 通信用ソケットをクラス変数に保存
        MainForm = MForm        ' Form1をクラス変数に保存
        ' 送受信のための
        ClsStream = New NetworkStream(ClsSocket)
        ClsReader = New StreamReader(ClsStream, Encoding.UTF8)
        ClsWriter = New StreamWriter(ClsStream, Encoding.UTF8)
        ClsWriter.AutoFlush = True
        ClsWriter.NewLine = vbNewLine
        ' 自分自身をクライアントリストに追加
        SyncLock ClientList.SyncRoot
            ClientList.Add(Me)
        End SyncLock
        ' クライアントのハンドル名をIPアドレスとクライアントの番号から作成
        ClientName = String.Format("{0}:{1}", CType(ClsSocket.RemoteEndPoint, IPEndPoint).Address, ClientList.Count)
        ' 受信処理用スレッドを起動
        Receive = New Thread(AddressOf ReceiveThread)
        Receive.IsBackground = True
        Receive.Start()
    End Sub
    ' 受信スレッド
    Private Sub ReceiveThread()
        Dim ReadData, WriteData As String
        Try
            Do
                ReadData = ClsReader.ReadLine   'データを受信
                If IsNothing(ReadData) Then     'データがなければ，クライアントからの切断
                    Exit Do
                End If
                WriteData = ClientName & ">>" & ReadData
                SyncLock ClientList.SyncRoot    ' 全クライアントへメッセージを送信
                    For Each tmp As ServerCommClass In ClientList
                        tmp.Send(WriteData)
                    Next
                End SyncLock
                MainForm.Invoke(New DisplayDlgt(AddressOf MainForm.Display), WriteData)
            Loop
            ' クライアントの切断処理
            CloseClient()
        Catch ex As Exception
            MainForm.Invoke(New MsgDlgt(AddressOf MessageBox.Show), New Object() {MainForm, ex.Message, "受信スレッドエラー", MessageBoxButtons.OK, MessageBoxIcon.Error})
        End Try
    End Sub
    ' データ送信
    Public Sub Send(ByVal s As String)
        ClsWriter.WriteLine(s)
    End Sub
    Private Sub CloseClient()

        ' クライアントリストから削除
        SyncLock ClientList.SyncRoot
            ClientList.Remove(Me)
        End SyncLock
        ' ソケットのシャットダウン
        ClsSocket.Shutdown(SocketShutdown.Send)
        ClsSocket.Close()
    End Sub
End Class
