//	macttf2be  ver.0.00
//	ttf(mac) file => ttf(unicode),bmf file
#include	<Be.h>

typedef struct{
	uint32	tag,sum,off,len;
}TBLHD;

uint32	bmp2bmf(uchar *bmp,uchar w,uchar h,char hbx,char hby,char ha,char va,uchar *bmf);
bool	search_tbl(FILE *fp,uint32 tblname,uchar *s);
uint32	set_tbl(TBLHD *t,uchar *dt,uint32 len);
uint32	sumB32(uint32 *p,int len);
void	quit(char *p);

uint32	top=-1;
uint32	wpos=0;
char	ifn[256],ofn[256];
bool	bef=false;

main(int ac,char **ag)
{
	int	agn=1;
	while((ac>agn)&&(ag[agn][0]=='-')){
		if(!strcmp(ag[agn],"-be"))bef=true;
		agn++;
	}
	if(ac<agn+2)quit("macttf2be  ver.0.00\nusage:\tmacttf2be [-be] macttf outputname");
	strcpy(ifn,ag[agn++]);
	strcpy(ofn,ag[agn++]);

	uchar	s[256];
	FILE	*ifp,*ofp;
//fopen(input)
	if((ifp=fopen(ifn,"rb"))==NULL)quit("cannot open inp-file");
//search top
	int	bl=0;
	fseek(ifp,0,0);
	while(top==0xffffffff){
		if(!fread(s,256,1,ifp))quit("file is not macttf");
		for(int i=0;i<256;i+=4)if(*(uint32*)(s+i)=='eurt'){top=bl*256+i;break;}
		bl++;
	}
//printf("top=%08x\n",top);
//init buf
	uchar	rbuf[0x400000],wbuf[0x400000];
	for(int i=0;i<0x400000;i++)wbuf[i]=0;
//
	TBLHD	tbl[20];
	uint32	tblname,tbls;
	uint32	len;
//prepare header
	tbls=0;
	if(!bef){
		if(search_tbl(ifp,'bdat',s))tbl[tbls++].tag='EBDT';
		if(search_tbl(ifp,'bloc',s))tbl[tbls++].tag='EBLC';
	}
	tbl[tbls++].tag='OS/2';
	tbl[tbls++].tag='cmap';
	if(search_tbl(ifp,'gasp',s))tbl[tbls++].tag='gasp';
	tbl[tbls++].tag='glyf';
	tbl[tbls++].tag='head';
	tbl[tbls++].tag='hhea';
	tbl[tbls++].tag='hmtx';
	tbl[tbls++].tag='loca';
	tbl[tbls++].tag='maxp';
	tbl[tbls++].tag='name';
	tbl[tbls++].tag='post';
	if(search_tbl(ifp,'vhea',s))tbl[tbls++].tag='vhea';
	if(search_tbl(ifp,'vmtx',s))tbl[tbls++].tag='vmtx';
//fopen(output)
printf("open for output(ttf)\n");
	char	otfn[256];
	sprintf(otfn,"%s.ttf",ofn);
	if((ofp=fopen(otfn,"wb"))==NULL)quit("cannot open out-file(ttf)");
	wpos=12+16*tbls;
	fseek(ofp,wpos,0);

	for(int i=0;i<tbls;i++)switch((int)(tbl[i].tag)){
		case 'head':{
printf("head\n");
			if(!search_tbl(ifp,'head',s))quit("not found table[head]");
			len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
			fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
			fread(rbuf,len,1,ifp);
			*(uint32*)(rbuf+8)=0;									//checkSumAdjustment
			len=set_tbl(&tbl[i],rbuf,len);
			fwrite(rbuf,len,1,ofp);
		}break;
		case 'name':{
printf("name\n");
			if(!search_tbl(ifp,'name',s))quit("not found table[name]");
			len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
			fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
			fread(rbuf,len,1,ifp);
//			*(uint16*)(rbuf)=B_HOST_TO_BENDIAN_INT16(0);			//formatSelector
			len=set_tbl(&tbl[i],rbuf,len);
			fwrite(rbuf,len,1,ofp);
/*
int	nc=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+2));
int	oo=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+4));
for(int j=0;j<nc;j++){
printf("%04x %04x %04x %04x ["
,B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+0))
,B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+2))
,B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+4))
,B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+6))
);
int	l=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+8));
int	o=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+10));
for(int k=0;k<l;k++)printf("%c",*(rbuf+oo+o+k));printf("]\n");
}
*/
		}break;
		case 'cmap':{
printf("cmap\n");
			if(!search_tbl(ifp,'cmap',s))quit("not found table[cmap]");
			len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
			fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
			uint	cml=len;
			uchar	*cm=new uchar[cml];
			fread(rbuf,len,1,ifp);
			uint32	toff,tlen=0;
			uint16	tc=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+2));
			for(int j=0;j<tc;j++){
				uint16	pid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+4+j*8));
				uint16	eid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*8));
				if((pid==0)&&(eid==3)){
					toff=B_BENDIAN_TO_HOST_INT32(*(uint32*)(rbuf+8+j*8));
					tlen=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+toff+2));
					break;
				}
			}
			if(tlen==0)quit("not support cmap format");
			*(uint16*)cm=B_HOST_TO_BENDIAN_INT16(0);			//version
			*(uint16*)(cm+2)=B_HOST_TO_BENDIAN_INT16(1);		//tables=1
			*(uint16*)(cm+4)=B_HOST_TO_BENDIAN_INT16(3);		//tbl-1 P-ID=3
			*(uint16*)(cm+6)=B_HOST_TO_BENDIAN_INT16(1);		//      E-ID=1(unicode)
			*(uint32*)(cm+8)=B_HOST_TO_BENDIAN_INT32(12);		//  	offset
			memcpy((void*)(cm+12),(void*)(rbuf+toff),tlen);
			cml=12+tlen;
			cml=set_tbl(&tbl[i],cm,cml);
			fwrite(cm,1,cml,ofp);
			delete	cm;
		}break;
		case 'EBDT':{
printf("EBDT\n");
			if(!search_tbl(ifp,'bdat',s))quit("not found table[bdat]");
			len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
			fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
			fread(rbuf,len,1,ifp);
			len=set_tbl(&tbl[i],rbuf,len);
			fwrite(rbuf,len,1,ofp);
		}break;
		case 'EBLC':{
printf("EBLC\n");
			if(!search_tbl(ifp,'bloc',s))quit("not found table[bloc]");
			len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
			fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
			fread(rbuf,len,1,ifp);
			len=set_tbl(&tbl[i],rbuf,len);
			fwrite(rbuf,len,1,ofp);
		}break;
		case 'OS/2':{
printf("OS/2\n");
			if(search_tbl(ifp,'OS/2',s)){
				len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
				fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
				fread(rbuf,len,1,ifp);
				len=set_tbl(&tbl[i],rbuf,len);
				fwrite(rbuf,len,1,ofp);
			}else{		//toriaezu
				*(uint16*)(s)=B_HOST_TO_BENDIAN_INT16(0x0001);			//version
				*(uint16*)(s+2)=B_HOST_TO_BENDIAN_INT16(500);			//xAvgCharWidth
				*(uint16*)(s+4)=B_HOST_TO_BENDIAN_INT16(500);			//usWeightClass
				*(uint16*)(s+6)=B_HOST_TO_BENDIAN_INT16(5);				//usWidthClass
				*(uint16*)(s+8)=B_HOST_TO_BENDIAN_INT16(4);				//fsType
				*(uint16*)(s+10)=B_HOST_TO_BENDIAN_INT16(500);			//ySubscriptXSize
				*(uint16*)(s+12)=B_HOST_TO_BENDIAN_INT16(500);			//ySubscriptYSize
				*(uint16*)(s+14)=B_HOST_TO_BENDIAN_INT16(0);			//ySubscriptXOffset
				*(uint16*)(s+16)=B_HOST_TO_BENDIAN_INT16(360);			//ySubscriptYOffset
				*(uint16*)(s+18)=B_HOST_TO_BENDIAN_INT16(500);			//ySuperscriptXSize
				*(uint16*)(s+20)=B_HOST_TO_BENDIAN_INT16(500);			//ySuperscriptYSize
				*(uint16*)(s+22)=B_HOST_TO_BENDIAN_INT16(0);			//ySuperscriptXOffset
				*(uint16*)(s+24)=B_HOST_TO_BENDIAN_INT16(430);			//ySuperscriptYOffset
				*(uint16*)(s+26)=B_HOST_TO_BENDIAN_INT16(50);			//yStrikeoutSize
				*(uint16*)(s+28)=B_HOST_TO_BENDIAN_INT16(400);			//yStrikeoutPosition
				*(uint16*)(s+30)=B_HOST_TO_BENDIAN_INT16(0);			//sFamilyClass
				*(uchar*)(s+32)=0x00;				//panose(FamilyKind)
				*(uchar*)(s+33)=0x00;				//panose(SerifStyle)
				*(uchar*)(s+34)=0x00;				//panose(Weight)
				*(uchar*)(s+35)=0x00;				//panose(Proportion)
				*(uchar*)(s+36)=0x00;				//panose(Contrast)
				*(uchar*)(s+37)=0x00;				//panose(StrokeVariation)
				*(uchar*)(s+38)=0x00;				//panose(ArmStyle)
				*(uchar*)(s+39)=0x00;				//panose(Letterform)
				*(uchar*)(s+40)=0x00;				//panose(Midline)
				*(uchar*)(s+41)=0x00;				//panose(X-height)
				*(uint32*)(s+42)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange1
				*(uint32*)(s+46)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange2
				*(uint32*)(s+50)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange3
				*(uint32*)(s+54)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange4
				*(uint32*)(s+58)=B_HOST_TO_BENDIAN_INT32(0);		//achVendID
				*(uint16*)(s+62)=B_HOST_TO_BENDIAN_INT16(0);			//fsSelection
				*(uint16*)(s+64)=B_HOST_TO_BENDIAN_INT16(0x0001);		//usFirstCharIndex
				*(uint16*)(s+66)=B_HOST_TO_BENDIAN_INT16(0xfffe);		//usLastCharIndex
				*(uint16*)(s+68)=B_HOST_TO_BENDIAN_INT16(860);			//sTypoAscender
				*(uint16*)(s+70)=B_HOST_TO_BENDIAN_INT16(-140);			//sTypoDescender
				*(uint16*)(s+72)=B_HOST_TO_BENDIAN_INT16(0);			//sTypoLineGap
				*(uint16*)(s+74)=B_HOST_TO_BENDIAN_INT16(860);			//usWinAscent
				*(uint16*)(s+76)=B_HOST_TO_BENDIAN_INT16(140);			//usWinDescent
				*(uint32*)(s+78)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulCodePageRange1
				*(uint32*)(s+82)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulCodePageRange2
				len=set_tbl(&tbl[i],s,86);
				fwrite(s,len,1,ofp);
			}
		}break;
		default:{	//copy
printf("copytbl[%c%c%c%c]\n",tbl[i].tag>>24,tbl[i].tag>>16,tbl[i].tag>>8,tbl[i].tag>>0);
			if(!search_tbl(ifp,tbl[i].tag,s))quit("not found table");
			len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
			fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
			fread(rbuf,len,1,ifp);
			len=set_tbl(&tbl[i],rbuf,len);
			fwrite(rbuf,len,1,ofp);
		}
	}
//fclose
	fclose(ifp);
//header
printf("create table-index\n");
	uint16	hdl=12+16*tbls;
	uchar	*hd=new uchar[hdl];
	uint16	es,sr;
	es=0;	sr=1;
	while(sr*2<=tbls){sr*=2;es++;}
	sr*=16;
	*(uint32*)(hd)=B_HOST_TO_BENDIAN_INT32(0x10000);			//sfntVersion
	*(uint16*)(hd+4)=B_HOST_TO_BENDIAN_INT16(tbls);				//numTables
	*(uint16*)(hd+6)=B_HOST_TO_BENDIAN_INT16(sr);				//searchRange
	*(uint16*)(hd+8)=B_HOST_TO_BENDIAN_INT16(es);				//entrySelector
	*(uint16*)(hd+10)=B_HOST_TO_BENDIAN_INT16(tbls*16-sr);		//rangeShift
	uint32	*hdp=(uint32*)(hd+12);
	uint32	off=hdl;
	uint32	sump;
	for(int i=0;i<tbls;i++){
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tbl[i].tag);
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tbl[i].sum);
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tbl[i].off);
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tbl[i].len);
		if(tbl[i].tag=='head')sump=tbl[i].off+8;
	}
	fseek(ofp,0,0);
	fwrite(hd,1,hdl,ofp);
//total-sum
printf("sum\n");
	uint32	sum=0;
	while((uchar*)hdp>=hd)sum+=B_BENDIAN_TO_HOST_INT32(*(hdp--));
	for(int i=0;i<tbls;i++)sum+=tbl[i].sum;
	sum=0xb1b0afba-sum;
	fseek(ofp,sump,0);
	*(uint32*)s=B_HOST_TO_BENDIAN_INT32(sum);	//sum adj. in 'head'
	fwrite(s,1,4,ofp);
	delete	hd;
//fclose
	fclose(ofp);

printf("set MIME\n");
	BFile	wf(otfn,B_WRITE_ONLY);
	BAppFileInfo	wfi(&wf);
	wfi.SetType("application/x-truetype");


//////////////////////////////////////////////////
if(bef){
printf("create bmf\n");

//fopen(input)
	if((ifp=fopen(ifn,"rb"))==NULL)quit("cannot open inp-file");
	for(int i=0;i<0x400000;i++)wbuf[i]=0;
//
	uint16	chrs=0;
	uint16	gno[65536];
	for(int i=0;i<65536;i++)gno[i]=0;
	char	cr[256],ff[256],fs[256];	//copyright,fontfamily,fontsubfamily
//read name
	if(!search_tbl(ifp,'name',s))quit("not found table[name]");
	len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
	fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
	fread(rbuf,len,1,ifp);
	int	nc=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+2));
	int	oo=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+4));
	*cr=*ff=*fs=0;
	for(int j=0;j<nc;j++){
	uint16	pid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+0));
	uint16	eid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+2));
	uint16	lid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+4));
	uint16	nid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+6));
	uint16	l=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+8));
	uint16	o=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*12+10));
	char	os[256],ns[256];
	strncpy(os,(char*)rbuf+oo+o,l);os[l]=0;
	if((pid==0x0001)&&(eid==0x0000)&&(lid==0x0000)){
		if(nid==0x0000)strcpy(cr,os);
		if(nid==0x0001)strcpy(ff,os);
		if(nid==0x0002)strcpy(fs,os);
	}
	if((pid==0x0001)&&(eid==0x0001)&&(lid==0x000b)){
		int32	stt,ol,nl;
		ol=strlen(os);	nl=255;
		convert_to_utf8(B_SJIS_CONVERSION,os,&ol,ns,&nl,&stt);ns[nl]=0;
//printf("%04x-%04x-%04x-%04x [%s]\n",pid,eid,lid,nid,ns);
//		if(nid==0x0000)strcpy(cr,ns);
		if(nid==0x0001)strcpy(ff,ns);
		if(nid==0x0002)strcpy(fs,ns);
if(stt)printf("textconv_err : stt=%x\n",stt);
	}
}
//read cmap
	if(!search_tbl(ifp,'cmap',s))quit("not found table[cmap]");
	len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
	fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
	fread(rbuf,len,1,ifp);
	uint32	toff,tlen=0;
	uint16	tc=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+2));
	for(int j=0;j<tc;j++){
		uint16	pid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+4+j*8));
		uint16	eid=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+6+j*8));
		if((pid==0)&&(eid==3)){
			toff=B_BENDIAN_TO_HOST_INT32(*(uint32*)(rbuf+8+j*8));
			tlen=B_BENDIAN_TO_HOST_INT16(*(uint16*)(rbuf+toff+2));
			break;
		}
	}
	if(tlen==0)quit("not support cmap format");
	uchar	*p=rbuf+toff;
	uint16	sc2=B_BENDIAN_TO_HOST_INT16(*(uint16*)(p+6));		//segCountX2
	uint16	*ecp=(uint16*)(p+14);								//endCode
	uint16	*scp=(uint16*)(p+16+sc2);							//startCode
	uint16	*idp=(uint16*)(p+16+sc2*2);							//idDelta
	uint16	*irp=(uint16*)(p+16+sc2*3);							//idRangeOffset
	while(*scp!=0xffff){
		uint16	sc=B_BENDIAN_TO_HOST_INT16(*scp);
		uint16	ec=B_BENDIAN_TO_HOST_INT16(*ecp);
		for(uint16 c=sc;c<=ec;c++){
			uint16	cc;
			if(*irp){
				cc=B_BENDIAN_TO_HOST_INT16(*(irp+(B_BENDIAN_TO_HOST_INT16(*irp)/2)+(c-B_BENDIAN_TO_HOST_INT16(*scp))))+(int16)B_BENDIAN_TO_HOST_INT16(*idp);
			}else{
				cc=c+(int16)B_BENDIAN_TO_HOST_INT16(*idp);
			}
			gno[c]=cc;
//printf("c=%04x g=%04x\n",c,gno[c]); 
			chrs++;
		}
		scp++;ecp++;idp++;irp++;
	}
//prepare bmf
	uint16	ltc;
	for(ltc=1;ltc<chrs;ltc<<=1);
//read bloc
	if(!search_tbl(ifp,'bloc',s))quit("not found table[bloc]");
	uchar	*bloc=rbuf;
	len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
	fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
	fread(bloc,len,1,ifp);
//read bdat
	if(!search_tbl(ifp,'bdat',s))quit("not found table[bdat]");
	uchar	*bdat=rbuf+len;
	len=B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+12));
	fseek(ifp,top+B_BENDIAN_TO_HOST_INT32(*(uint32*)(s+8)),0);
	fread(bdat,len,1,ifp);

	uint32	sizes=B_BENDIAN_TO_HOST_INT32(*(uint32*)(bloc+4));
	for(int i=0;i<sizes;i++){
		uchar	*p=bloc+B_BENDIAN_TO_HOST_INT32(*(uint32*)(bloc+8+48*i));	//sub table
		uint32	tc=B_BENDIAN_TO_HOST_INT32(*(uint32*)(bloc+8+48*i+8));		//table count
		uchar	pt=*(bloc+8+i*48+45);		//ppemY
//fopen(output)
printf("open for output(bmf-%dpt)\n",pt);
		sprintf(otfn,"%s_%d",ofn,pt);
		if((ofp=fopen(otfn,"wb"))==NULL)quit("cannot open out-file(bmf)");
//header
		uchar	*hd=wbuf;
		uint32	hdl=0x0026+strlen(ff)+strlen(fs);
		for(int j=0;j<hdl;j++)hd[j]=0;
		*(uint32*)(hd+0x00)=B_HOST_TO_BENDIAN_INT32(0x7c42653b);
		*(uint32*)(hd+0x04)=B_HOST_TO_BENDIAN_INT32(hdl);
		*(uint16*)(hd+0x08)=B_HOST_TO_BENDIAN_INT16(strlen(ff));
		*(uint16*)(hd+0x0a)=B_HOST_TO_BENDIAN_INT16(strlen(fs));
		*(uint16*)(hd+0x16)=B_HOST_TO_BENDIAN_INT16(ltc-1);
		*(uint16*)(hd+0x18)=B_HOST_TO_BENDIAN_INT16((uint16)pt);
		*(uint16*)(hd+0x1a)=B_HOST_TO_BENDIAN_INT16(0x300);
		strcpy((char*)hd+0x0024,ff);
		strcpy((char*)hd+0x0025+strlen(ff),fs);
		fwrite(hd,1,hdl,ofp);
//prepare locate-table
		uchar	*lt=wbuf+hdl;
		uint32	ltl=ltc*8;
		for(int j=0;j<ltc;j++){
			*(uint32*)(lt+j*8)=-1;
			*(uint32*)(lt+j*8+4)=0;
		}
//bitmap-data
		uchar	*bd=wbuf+hdl+ltl;
		uint32	bdl=0;
		for(uint16 c=0;c<0xffff;c++){
			if(gno[c]==0)continue;
			for(int j=0;j<tc;j++){
				uint16	fg=B_BENDIAN_TO_HOST_INT16(*(uint16*)(p+j*8));
				uint16	lg=B_BENDIAN_TO_HOST_INT16(*(uint16*)(p+j*8+2));
				if((fg>gno[c])||(lg<gno[c]))continue;
				uchar	*pp=p+B_BENDIAN_TO_HOST_INT32(*(uint32*)(p+j*8+4));
				uint16	idf=B_BENDIAN_TO_HOST_INT16(*(uint16*)(pp));
				uint16	imf=B_BENDIAN_TO_HOST_INT16(*(uint16*)(pp+2));
//loca
				uint16	lp=(c<<3)^(c>>2);
				lp&=ltc-1;
				while(*(uint32*)(lt+lp*8)!=-1)lp=(lp+1)&(ltc-1);
				*(uint32*)(lt+lp*8)=B_HOST_TO_BENDIAN_INT32(hdl+ltl+bdl);
				*(uint16*)(lt+lp*8+4)=B_HOST_TO_BENDIAN_INT16(c);
//bitmap
				uchar	w,h,hbx,hby,ha,vbx,vby,va;
				if((idf==2)&&(imf==5)){
					uint32	bml=B_BENDIAN_TO_HOST_INT32(*(uint32*)(pp+8));
					uchar	*ppp=bdat+B_BENDIAN_TO_HOST_INT32(*(uint32*)(pp+4))+(gno[c]-fg)*bml;
					pp+=12;
					h=*(pp++);	w=*(pp++);
					hbx=*(pp++);	hby=*(pp++);	ha=*(pp++);
					vbx=*(pp++);	vby=*(pp++);	va=*(pp++);
					uint32	l=bmp2bmf(ppp,w,h,hbx,hby,ha,va,bd+bdl);
					bdl+=l;
				}else if((idf==1)&&(imf==7)){
					pp=bdat+B_BENDIAN_TO_HOST_INT32(*(uint32*)(pp+4))+B_BENDIAN_TO_HOST_INT32(*(uint32*)(pp+8+(gno[c]-fg)*4));
					uchar	*ppp=pp+8;
					h=*(pp++);	w=*(pp++);
					hbx=*(pp++);	hby=*(pp++);	ha=*(pp++);
					vbx=*(pp++);	vby=*(pp++);	va=*(pp++);
					uint32	l=bmp2bmf(ppp,w,h,hbx,hby,ha,va,bd+bdl);
					bdl+=l;
				}else{
printf("not supported bitmap format %02x-%02x\n",idf,imf);
//printf("pt=%d c=%04x g=%04x fmt=%d,%d\n",pt,c,gno[c],idf,imf);
				}
			}
		}
		fwrite(lt,1,ltl,ofp);
		fwrite(bd,1,bdl,ofp);
		fwrite(cr,1,strlen(cr),ofp);		//add copyright
//fclose
		fclose(ofp);
printf("set MIME\n");
		BFile	wf(otfn,B_WRITE_ONLY);
		BAppFileInfo	wfi(&wf);
		wfi.SetType("application/x-vnd.Be-bitmap-font");
	}
}
//////////////////////////////
	fclose(ifp);

	quit("");
}

uint32 bmp2bmf(uchar *bmp,uchar w,uchar h,char hbx,char hby,char ha,char va,uchar *bmf)
{
	uint32	len=0x18;
	bmf[0x00]=0x49;	bmf[0x01]=0x96;	bmf[0x02]=0xb4;	bmf[0x03]=0x38;
	bmf[0x04]=0x49;	bmf[0x05]=0x96;	bmf[0x06]=0xb4;	bmf[0x07]=0x40;
	*(float*)(bmf+0x10)=B_HOST_TO_BENDIAN_FLOAT((float)ha);
	*(float*)(bmf+0x14)=B_HOST_TO_BENDIAN_FLOAT((float)va);
	int16	l,t,r,b;
	l=t=9999;	r=b=-9999;
	for(int y=0;y<h;y++)for(int x=0;x<w;x++){
		if(bmp[(w*y+x)/8]&(0x80>>((w*y+x)&7))){
			if(x<l)l=x;
			if(x>r)r=x;
			if(y<t)t=y;
			if(y>b)b=y;
		}
	}
	if(l>r){	//space
		*(uint16*)(bmf+0x08)=0;
		*(uint16*)(bmf+0x0a)=0;
		*(uint16*)(bmf+0x0c)=-1;
		*(uint16*)(bmf+0x0e)=-1;
	}else{			//non-space
		*(uint16*)(bmf+0x08)=B_HOST_TO_BENDIAN_INT16(l+hbx);
		*(uint16*)(bmf+0x0a)=B_HOST_TO_BENDIAN_INT16(t-hby);
		*(uint16*)(bmf+0x0c)=B_HOST_TO_BENDIAN_INT16(r+hbx);
		*(uint16*)(bmf+0x0e)=B_HOST_TO_BENDIAN_INT16(b-hby);
//printf("%d %d %d %d\n",l+hbx,t-hby,r+hbx,b-hby);
		for(int iy=t;iy<=b;iy++)for(int ix=l;ix<=r;ix+=2){
			bmf[len]=(bmp[(w*iy+ix)/8]&(0x80>>((w*iy+ix)&7)))?0x70:0x00;
			if(ix<r)bmf[len]|=(bmp[(w*iy+ix+1)/8]&(0x80>>((w*iy+ix+1)&7)))?0x07:0x00;
			len++;
		}
	}
	return(len);
}

bool search_tbl(FILE *fp,uint32 tblname,uchar *s)
{
	bool	f=false;
	fseek(fp,top,0);
	fread(s,1,12,fp);
	int		tbls=B_BENDIAN_TO_HOST_INT16(*(uint16*)(s+5));
	for(int i=0;i<tbls;i++){
		fread(s,1,16,fp);
		if(B_BENDIAN_TO_HOST_INT32(*(uint32*)s)==tblname){f=true;break;}
	}
//if(!f)printf("not found\n");
	return(f);
}

uint32 set_tbl(TBLHD *t,uchar *dt,uint32 len)
{
	while(len&3)dt[len++]=0;
	t->sum=sumB32((uint32*)dt,len);		//sum
	t->off=wpos;						//offset
	t->len=len;							//length
	wpos+=len;
	return(len);
}

uint32 sumB32(uint32 *p,int len)
{
	uint32	sum=0;
	len=len/4;
	while(len--)sum+=B_BENDIAN_TO_HOST_INT32(*(p++));
	return(sum);
}

void quit(char *p)
{
	if(*p)printf("error : %s\n",p);
	else printf("complete\n");
	exit(0);
}
