//beersaver ver.0.01

#include "beersaver.h"

main()
{
	printf("%s\n",CREDITS_SSNAME);
	printf("%s\n",CREDITS_VERSION);
	printf("%s\n",CREDITS_AUTHOR);
}

extern "C" _EXPORT BScreenSaver *instantiate_screen_saver(BMessage *msg,image_id id)
{
	return(new beersaver(msg,id));
}

beersaver::beersaver(BMessage *archive,image_id image):BScreenSaver(archive,image)
{
	maze=NULL;
	df=false;
	job=0;
	if(archive->FindInt32("param",&param)!=B_OK)param=50;
	if(archive->FindInt32("speed",&speed)!=B_OK)speed=1000;
}

beersaver::~beersaver()
{
	if(maze)delete maze;
}

void beersaver::StartConfig(BView *view)
{
	configview	*cv=new configview(view->Bounds(),"config");
	view->AddChild(cv);
}

status_t beersaver::SaveState(BMessage *into)const
{
	into->AddInt32("param",param);
	into->AddInt32("speed",speed);
	return(B_OK);
}

status_t beersaver::StartSaver(BView *view,bool preview)
{
	SetTickSize(speed);
	return(B_OK);
}

void beersaver::Draw(BView *view,int32 frame)
{
	if(job==0)initmaze(view);
	if(job<0)fadeout(view);
	if(job==1)move(view);
	if((df)&&(maze)){view->DrawBitmap(maze);df=false;}
}

void beersaver::initmaze(BView *v)
{
	srand(time(NULL));
	int	w=v->Bounds().IntegerWidth();
	int	h=v->Bounds().IntegerHeight();
	if((w&1)==0)w++;	if((h&1)==0)h++;
	if(maze){delete maze;maze=NULL;}
	maze=new BBitmap(BRect(0,0,w,h),B_RGB_32_BIT);
	memset(maze->Bits(),0,maze->BitsLength());
	int	c=(w-3)*(h-3)/4;
	uint32	*p=(uint32*)(maze->Bits());
	int		dy=maze->BytesPerRow()/4;
	int	x,y;
	for(y=0;y<h;y++)for(x=0;x<w;x++){
		*(p+dy*y+x)=((x==0)||(x==w-1)||(y==0)||(y==h-1))?0x00cccccc:0x01aaaa88;
	}
	int16 *st=new int16[2*c];
	int	sp=0;
	x=2;y=2;c--;
	st[sp++]=x;st[sp++]=y;
	*(p+dy*y+x)=0x00000000;
	while(c){
		char	f=0;
		if(*(p+dy*(y-2)+x)&0x01000000)f|=1;
		if(*(p+dy*y+(x+2))&0x01000000)f|=2;
		if(*(p+dy*(y+2)+x)&0x01000000)f|=4;
		if(*(p+dy*y+(x-2))&0x01000000)f|=8;
		if(f){
			char	r;
			while(1){
				r=1<<(rand()&3);
				if(r&f)break;
			}
			int	xx=0,yy=0;
			if(r==1)yy=-1;
			if(r==2)xx=1;
			if(r==4)yy=1;
			if(r==8)xx=-1;
			x+=xx;y+=yy;*(p+dy*y+x)=0x00000000;
			x+=xx;y+=yy;*(p+dy*y+x)=0x00000000;
			st[sp++]=x;st[sp++]=y;
			c--;
		}else{
if(sp<2)return;
			if(rand()%100<param){
				y=st[--sp];x=st[--sp];
			}else{
				int	rr=(rand()%sp)|1;
				y=st[rr];st[rr]=st[--sp];rr--;x=st[rr];st[rr]=st[--sp];
			}
		}
	}
	delete st;
	gx[0]=2;	gy[0]=2;
	gx[1]=w-3;	gy[1]=h-3;
	gx[2]=2;	gy[2]=h-3;
	gx[3]=w-3;	gy[3]=2;

	job=1;
	for(int i=0;i<4;i++){
		mp[i].f=15^(1<<i);
		mp[i].s=i;mp[i].d=i;
		mp[i].x=gx[i];mp[i].y=gy[i];
		*(p+dy*mp[i].y+mp[i].x)=0x00ff0000|(0x10000000<<i);
	}
	df=true;
}

void beersaver::move(BView *v)
{
	uint32	c[4];
	c[0]=0xc00000;c[1]=0xc000c0;c[2]=0x00c000;c[3]=0x0000c0;
	uint32	*p=(uint32*)(maze->Bits());
	int		dy=maze->BytesPerRow()/4;
	for(int i=0;i<4;i++){
		uint32	f=0x10000000<<i;
		if(mp[i].d<0)continue;
		mp[i].d=(mp[i].d+3)&3;
		while(1){
			int	xx=0,yy=0;
			if(mp[i].d==0)yy=-1;
			if(mp[i].d==1)xx=1;
			if(mp[i].d==2)yy=1;
			if(mp[i].d==3)xx=-1;
			uint32	cc=*(p+dy*(mp[i].y+yy)+(mp[i].x+xx));
			if(cc&0x01000000){
				mp[i].d=(mp[i].d+1)&3;
			}else{
				BRect	dr(xx<0?mp[i].x-2:mp[i].x,yy<0?mp[i].y-2:mp[i].y,xx>0?mp[i].x+2:mp[i].x,yy>0?mp[i].y+2:mp[i].y);
				if(cc&f){
					*(p+dy*mp[i].y+mp[i].x)^=(c[i]|f);
					mp[i].x+=xx;mp[i].y+=yy;
					*(p+dy*mp[i].y+mp[i].x)^=(c[i]|f);
					mp[i].x+=xx;mp[i].y+=yy;
				}else{
					mp[i].x+=xx;mp[i].y+=yy;
					*(p+dy*mp[i].y+mp[i].x)^=(c[i]|f);
					mp[i].x+=xx;mp[i].y+=yy;
					*(p+dy*mp[i].y+mp[i].x)^=(c[i]|f);
				}
				v->DrawBitmap(maze,dr,dr);
				break;
			}
		}
	}
	for(int i=0;i<4;i++){
		if(mp[i].d<0)continue;
		uint32	f=0x10000000<<i;
		for(int j=0;j<4;j++){
			if(!(mp[i].f&(1<<j)))continue;
			if((mp[i].x!=gx[j])||(mp[i].y!=gy[j]))continue;
			for(int	k=maze->BitsLength()/4-1;k>=0;k--){	//bugfix
				if(*(p+k)&f){*(p+k)^=(0x00000000|f);*(p+k)|=0x3f3f3f;}
			}
			mp[i].d=-1;mp[i].f=0;	//
			df=true;
		}
	}
	if((mp[0].f|mp[1].f|mp[2].f|mp[3].f)==0)job=-2;
}

void beersaver::fadeout(BView *v)
{
	bool	f=true;
	uint32	*p=(uint32*)(maze->Bits());
	for(int	k=maze->BitsLength()/4-1;k>=0;k--){			//bugfix
		uint32	d=*(p+k);
		uchar	a=d>>24;
		if(((job==-2)&&(a))||((job==-1)&&(a==0))){
			uchar	r,g,b;
			r=d>>16;	r=(r>5)?r-5:0;
			g=d>>8;		g=(g>5)?g-5:0;
			b=d;		b=(b>5)?b-5:0;
			d=(r<<16)|(g<<8)|b;
			if(d)f=false;
			*(p+k)=(a<<24)|d;
		}
	}
	if(f)job++;
	df=true;
}

configview::configview(BRect frame,const char *name):BView(frame,name,B_FOLLOW_ALL,B_WILL_DRAW)
{
}

void configview::AttachedToWindow()
{
	ParamSlider=new BSlider(BRect(10,120,230,170),"param","Parameter",new BMessage('para'),0,100,B_TRIANGLE_THUMB);
	ParamSlider->SetHashMarks(B_HASH_MARKS_BOTTOM);
	ParamSlider->SetLimitLabels("Simple","Complex");
	ParamSlider->SetValue(param);
	ParamSlider->SetHashMarkCount(5);
	ParamSlider->SetTarget(this);
	AddChild(ParamSlider);

	SpeedSlider=new BSlider(BRect(10,190,230,240),"speed","Speed",new BMessage('sped'),1000,10000,B_TRIANGLE_THUMB);
	SpeedSlider->SetHashMarks(B_HASH_MARKS_BOTTOM);
	SpeedSlider->SetLimitLabels("Fast","Slow");
	SpeedSlider->SetValue(speed);
	SpeedSlider->SetHashMarkCount(5);
	SpeedSlider->SetTarget(this);
	AddChild(SpeedSlider);
}

void configview::MessageReceived(BMessage *msg)
{
	switch(msg->what){
		case 'para':{
			param=ParamSlider->Value();
		}break;
		case 'sped':{
			speed=SpeedSlider->Value();
		}break;
		default:{
			BView::MessageReceived(msg);
		}break;
	}
}

void configview::Draw(BRect r)
{
	SetLowColor(216,216,216);
	FillRect(Bounds(),B_SOLID_LOW);
	SetFontSize(20);
	DrawString(CREDITS_SSNAME,BPoint(30,30));
	SetFontSize(10);
	DrawString(CREDITS_VERSION,BPoint(35,50));
	DrawString(CREDITS_AUTHOR,BPoint(30,70));
}
