// annsViewFrame.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "annsViewFrame.h"
#include "FileView.h"
#include "annsView.h"
#include "annsViewEx.h"
#include "annsGView.h"
#include "imm.h"
#include "Dwmapi.h"

#pragma comment(lib, "dwmapi.lib")

// CannsViewFrame

IMPLEMENT_DYNCREATE(CannsViewFrame, CFrameWnd)

CannsViewFrame::CannsViewFrame()
{
	m_pwndFile = NULL;
	m_Exist = true;
#ifdef _VIEW_EX
	m_pwndView = new CannsViewEx;
#else
	m_pwndView = new CannsView;
#endif // _VIEW_EX

	m_ViewNo = -1;
	m_bGmode = false;
	m_pwndGView = new CannsGView;

	m_pScrollBar = new CScrollBar;

}

CannsViewFrame::~CannsViewFrame()
{
	delete m_pwndView;
	if (!m_bGmode) {
		delete m_pwndGView;
	}
	m_Exist = false;
	m_pwndFile->m_pViewFrame[m_ViewNo] = NULL;

	delete m_pScrollBar;

}


BEGIN_MESSAGE_MAP(CannsViewFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_DESTROY()

	ON_WM_MOUSEWHEEL()
	ON_COMMAND(ID_ANNSVIEW_EXIT, &CannsViewFrame::OnAnnsviewExit)
	ON_WM_INITMENUPOPUP()
	ON_WM_SETFOCUS()
	ON_WM_VSCROLL()
	ON_WM_INITMENU()
END_MESSAGE_MAP()


// CannsViewFrame bZ[W nh

// 摜EBhETCYɍ킹ďk
void CannsViewFrame::AdjustSize(void)
{

	if (m_pFmParam->m_bViewAdjustSize) {
		RECT rcc;

		GetClientRect(&rcc);

		int wxw = rcc.right - rcc.left;
		int wyw = rcc.bottom - rcc.top;

		if (m_pwndGView->m_Xw > wxw || m_pwndGView->m_Yw > wyw) {
			int mx = wxw * GMAG_REF / m_pwndGView->m_Xw;
			int my = wyw * GMAG_REF / m_pwndGView->m_Yw;

			if (m_pwndGView->m_nRad == 1 || m_pwndGView->m_nRad == 3) {
				my = wxw * GMAG_REF / m_pwndGView->m_Xw;
				mx = wyw * GMAG_REF / m_pwndGView->m_Yw;

			}
			if (mx == 0) mx = GMAG_REF;
			m_pwndGView->m_nMulti = mx;
			if (my < mx) {
				if (my == 0) my = GMAG_REF;
				m_pwndGView->m_nMulti = my;
			}

			m_pwndGView->m_nowXw = m_pwndGView->m_Xw * m_pwndGView->m_nMulti / GMAG_REF;
			m_pwndGView->m_nowYw = m_pwndGView->m_Yw * m_pwndGView->m_nMulti / GMAG_REF;

		}

	}

}


int CannsViewFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB


	m_pwndView->m_pFmParam = m_pFmParam;
	m_pwndView->m_pViewFrame = this;

	m_pwndGView->m_pFmParam = m_pFmParam;
	m_pwndGView->m_pViewFrame = this;

	CWinApp *pApp = AfxGetApp();

	RECT rc;
	CString sSection, sEntry, tmp;

	tmp = _T("%s_TEXT");
	if ( m_bGmode ) {
		tmp = _T("%s_GRAPHIC");
	}
	sSection.Format(tmp, INISECTION_ANNSVIEW);
	sEntry = INIENTRY_WINDOW_TOP;
	rc.top = pApp->GetProfileInt(sSection, sEntry, 0);
	sEntry = INIENTRY_WINDOW_LEFT;
	rc.left = pApp->GetProfileInt(sSection, sEntry, 0);
	sEntry = INIENTRY_WINDOW_RIGHT;
	rc.right = pApp->GetProfileInt(sSection, sEntry, 640);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	rc.bottom = pApp->GetProfileInt(sSection, sEntry, 480);

	/*
	WINDOWPLACEMENT wndPlace;
	wndPlace.length = sizeof(WINDOWPLACEMENT);

	EnumDisplayMonitors(NULL, NULL, m_pFmParam->MonitorEnumProc, 0);

	int n = m_pFmParam->m_nMonitor;

	bool bok = false;


	int x = rc.left + 10;
	int y = rc.top + 10;

	for (int i = 0; i < n; i++) {
		if (x > m_pFmParam->m_rcMonitor[i].left && y > m_pFmParam->m_rcMonitor[i].top) {
			bok = true;
			break;
		}

	}

	if (bok == false) {
		rc.top = 0;
		rc.left = 0;
		rc.right = 480;
		rc.bottom = 640;
	}

	if ( !m_bGmode ) {
		if (!m_pwndView->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
				rc, this, 1, NULL))
		{
			TRACE0("annsView EBhE쐬ł܂łB\n");
			return -1;
		}


		wndPlace.rcNormalPosition.top = rc.top;
		wndPlace.rcNormalPosition.bottom = rc.bottom;
		wndPlace.rcNormalPosition.left = rc.left;
		wndPlace.rcNormalPosition.right = rc.right;

		SetWindowPlacement(&wndPlace);
	}
	else {

		if (!m_pwndGView->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
			rc, this, 1, NULL))
		{
			TRACE0("annsView EBhE쐬ł܂łB\n");
			return -1;
		}

//		GetWindowPlacement(&wndPlace);

		wndPlace.rcNormalPosition.top = rc.top;
		wndPlace.rcNormalPosition.bottom = rc.bottom;
		wndPlace.rcNormalPosition.left = rc.left;
		wndPlace.rcNormalPosition.right = rc.right;

		SetWindowPlacement(&wndPlace);

		bool r = m_pwndGView->InitializeData();
		if (!r) {
			DestroyWindow();
			return -1;
		}
		CMenu* pMenu = GetMenu();

		pMenu->CheckMenuItem(ID_KEY_CTRL_F, MF_UNCHECKED);
		if (m_pFmParam->m_bViewAdjustSize) {
			pMenu->CheckMenuItem(ID_KEY_CTRL_F, MF_CHECKED);
		}


	}

	*/

	int vxs = GetSystemMetrics(SM_XVIRTUALSCREEN);
	int vys = GetSystemMetrics(SM_YVIRTUALSCREEN);
	int vxe = vxs + GetSystemMetrics(SM_CXVIRTUALSCREEN);
	int vye = vys + GetSystemMetrics(SM_CYVIRTUALSCREEN);


	if ((rc.right - 50) < vxs || (rc.left + 20) > vxe || (rc.top + 10) < vys || rc.top > vye) {
		int xw = rc.right - rc.left;
		int yw = rc.bottom - rc.top;

		rc.top = 10;
		rc.left = 10;
		rc.right = rc.left + xw;
		rc.bottom = rc.top + yw;

	}


	if (!m_bGmode) {
		m_pScrollBar->Create(SBS_VERT | WS_CHILD, CRect(0, 0, 0, 0), this, 110);

		if (!m_pwndView->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
			rc, this, 1, NULL))
		{
			TRACE0("annsView EBhE쐬ł܂łB\n");
			return -1;
		}

//		rc.right -= SCROLLBARHEIGHT;


		MoveWindow(&rc);



	}
	else {

		if (!m_pwndGView->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
			rc, this, 1, NULL))
		{
			TRACE0("annsView EBhE쐬ł܂łB\n");
			return -1;
		}

		MoveWindow(&rc);

#ifndef _WINVER_XP
		bool r = m_pwndGView->InitializeData();
		if (!r) {
			DestroyWindow();
			return -1;
		}
#endif

		CMenu* pMenu = GetMenu();

		pMenu->CheckMenuItem(ID_KEY_CTRL_F, MF_UNCHECKED);
		if (m_pFmParam->m_bViewAdjustSize) {
			pMenu->CheckMenuItem(ID_KEY_CTRL_F, MF_CHECKED);
		}

		pMenu->CheckMenuItem(ID_KEY_CTRL_A, MF_UNCHECKED);
		if (m_pFmParam->m_bAutoOrientation) {
			pMenu->CheckMenuItem(ID_KEY_CTRL_A, MF_CHECKED);
		}

	}


	HICON hIcon=AfxGetApp()->LoadIcon(IDR_ANNSVIEWFRAME);
	SetIcon(hIcon,FALSE);



	DrawFileName();

	SetFocus();


	return 0;
}

void CannsViewFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CRect rc, viewrc;

	GetWindowRect(&rc);

	bool bresize = false;
	int xw = 320;
	int yw = 240;

	if ( cx < xw ) {
		rc.right = rc.left + xw;
		bresize = true;

	}

	if (cy < yw) {
		rc.bottom = rc.top + yw;
		bresize = true;
	}

	if (bresize) {
		MoveWindow(rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top);
	}

	m_pwndGView->m_bEnableRect = false;

	GetClientRect(&rc);

	CFont font, font2;
	CString cs;
	CSize size;
	CClientDC dc(this);
	CFont* pOldFont;
	int fw, fh;
//	TEXTMETRIC tm;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	pOldFont = dc.SelectObject(&font);

//	GetTextMetrics(dc, &tm);
//	fh = tm.tmHeight;
//	fw = tm.tmAveCharWidth + 1;

	CString ss;
	ss = "M";
	size = dc.GetTextExtent(ss);
	fw = size.cx;
	fh = size.cy;

	dc.SelectObject(pOldFont);

	viewrc = rc;
//	viewrc.right;

	if ( !m_bGmode ) {
		viewrc.top += (fh + 2);
		viewrc.right -= SCROLLBARHEIGHT;

		m_pwndView->MoveWindow(&viewrc);

//		GetWindowRect(&rc);
		GetClientRect(&rc);
//		ScreenToClient(&rc);
		rc.left = rc.right - SCROLLBARHEIGHT;
		rc.top += (fh + 2);
		m_pScrollBar->MoveWindow(&rc);
		m_pScrollBar->ShowScrollBar();


	} else {

#ifndef _WINVER_XP
		if (m_pwndGView->m_gImage == NULL && !(m_pwndGView->m_gTarget)) return;
#endif

//		if (m_pwndGView->m_gImage == NULL) return;
//		m_pwndGView->InitScrollBar();
//		m_pwndGView->CreateDrawData();
		m_pwndGView->MoveWindow(&viewrc);

#ifndef _WINVER_XP
		m_pwndGView->ResizeViewD2D();
#endif

		AdjustSize();
		//		m_pwndGView->InitializeData();
		Invalidate();
	}

}

void CannsViewFrame::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: ɃbZ[W nh R[hǉ܂B
	// `惁bZ[W CFrameWnd::OnPaint() ĂяoȂłB

	if ( !m_bGmode ) {

		CFont font;
		CFont* pOldFont;
		int fw, fh;
//		TEXTMETRIC tm;

		font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
		pOldFont = dc.SelectObject(&font);
//		GetTextMetrics(dc, &tm);
//		fh = tm.tmHeight;
//		fw = tm.tmAveCharWidth + 1;

		CString ss;
		ss = "M";
		CSize size = dc.GetTextExtent(ss);
		fw = size.cx;
		fh = size.cy;

		CString s, form;
		CSize sizew;


		COLORREF colguide = m_pFmParam->m_colViewGuide;
		COLORREF coldata = m_pFmParam->m_colViewGuideData;

		dc.SetBkColor(m_pFmParam->m_colViewBack);

		int x, y;
		x = 0;
		y = 0;
		s = _T("[");
		dc.SetTextColor(colguide);
		dc.TextOut(x, y, s);

		sizew = dc.GetTextExtent(s);
		x += sizew.cx;
		form = _T("%6d");
		int dn = 1;
		if ( m_pwndView->m_FileSize == 0 ) dn = 0;

		s.Format(form, m_pwndView->m_FirstLine + dn);
		dc.SetTextColor(coldata);
		dc.TextOut(x, y, s);

		sizew = dc.GetTextExtent(s);
		x += sizew.cx;
		s = _T("/");
		dc.SetTextColor(colguide);
		dc.TextOut(x, y, s);

		sizew = dc.GetTextExtent(s);
		x += sizew.cx;
		form = _T("%6d");
		s.Format(form, m_pwndView->m_MaxLine);
		dc.SetTextColor(coldata);
		dc.TextOut(x, y, s);

		sizew = dc.GetTextExtent(s);
		x += sizew.cx;
		s = _T("] : ");
		dc.SetTextColor(colguide);
		dc.TextOut(x, y, s);

		sizew = dc.GetTextExtent(s);
		x += sizew.cx;
		s = m_pwndView->m_sFileName;
		dc.SetTextColor(coldata);
		dc.TextOut(x, y, s);


		dc.SelectObject(pOldFont);
	}

}

BOOL CannsViewFrame::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	// uV̍쐬

	CBrush *cb;

	if (m_bGmode) {
		if (m_pwndGView->m_nBackColor == 1) {
			cb = new CBrush(RGB(128, 128, 128));
		}
		if (m_pwndGView->m_nBackColor == 2) {
			cb = new CBrush(RGB(255, 255, 255));
		}
		if (m_pwndGView->m_nBackColor == 3) {
			cb = new CBrush(RGB(0, 0, 0));
		}
		if (m_pwndGView->m_nBackColor == 0) {
			cb = new CBrush(m_pFmParam->m_colViewBack);
		}

	}
	else {
		cb = new CBrush(m_pFmParam->m_colViewBack);
	}

	
	// VuVw(̃uV̕ۑ)
    CBrush* pOldBrush = pDC->SelectObject(cb);

    // hԂ̈擾
    CRect rect;
    GetClientRect(&rect);

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colFrame);
	CPen* pOldPen = pDC->SelectObject(&pen);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	CFont* pOldFont = pDC->SelectObject(&font);

	CString cs;
	cs = "W";
	CSize size = pDC->GetTextExtent(cs);

	int fw, fh;
	fw = size.cx;
	fh = size.cy + 1;




	if (!m_bGmode) {
		// hԂ
		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);
		pDC->MoveTo(2, fh);
		pDC->LineTo(rect.right - 2, fh);
	}

	// uVɖ߂
    pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldFont);
	delete cb;


	return TRUE;

//	return CFrameWnd::OnEraseBkgnd(pDC);
}

BOOL CannsViewFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	// r[ɍŏɃR}h@^܂B
	if ( !m_bGmode ) {
		if (m_pwndView->OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
			return TRUE;
	} else {
		if (m_pwndGView->OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
			return TRUE;
	}

	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CannsViewFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( !m_bGmode ) {
		m_pwndView->OnKeyDown(nChar, nRepCnt, nFlags);
	} else {
		m_pwndGView->OnKeyDown(nChar, nRepCnt, nFlags);
	}

//	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}



void CannsViewFrame::DrawLineNumber(void)
{
	CClientDC dc(this);

	CFont font;
	CFont* pOldFont;
	int fw, fh;
//	TEXTMETRIC tm;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	pOldFont = dc.SelectObject(&font);
//	GetTextMetrics(dc, &tm);
//	fh = tm.tmHeight;
//	fw = tm.tmAveCharWidth + 1;

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);
	fw = size.cx;
	fh = size.cy;

	CString s, form;
	CSize sizew;


	COLORREF colguide = m_pFmParam->m_colViewGuide;
	COLORREF coldata = m_pFmParam->m_colViewGuideData;

	dc.SetBkColor(m_pFmParam->m_colViewBack);

	int x, y;
	x = 0;
	y = 0;
	s = _T("[");
//	dc.SetTextColor(colguide);
//	dc.TextOut(x, y, s);

	sizew = dc.GetTextExtent(s);
	x += sizew.cx;
	form = _T("%6d");
	s.Format(form, m_pwndView->m_FirstLine + 1);
	dc.SetTextColor(coldata);
	dc.TextOut(x, y, s);

	sizew = dc.GetTextExtent(s);
	x += sizew.cx;
	s = _T("/");
//	dc.SetTextColor(colguide);
//	dc.TextOut(x, y, s);

	sizew = dc.GetTextExtent(s);
	x += sizew.cx;
	form = _T("%6d");
	s.Format(form, m_pwndView->m_MaxLine);
	dc.SetTextColor(coldata);
	dc.TextOut(x, y, s);

	dc.SelectObject(pOldFont);

}

void CannsViewFrame::DrawFileName(void)
{

	CString s = _T("");
	CMenu* pMenu = GetMenu();

	if ( !m_bGmode ) {
		pMenu->CheckMenuItem(ID_KEY_3, MF_UNCHECKED);
		pMenu->CheckMenuItem(ID_KEY_4, MF_UNCHECKED);
		pMenu->CheckMenuItem(ID_KEY_5, MF_UNCHECKED);
		pMenu->CheckMenuItem(ID_KEY_6, MF_UNCHECKED);
		pMenu->CheckMenuItem(ID_KEY_7, MF_UNCHECKED);
		pMenu->CheckMenuItem(ID_KEY_8, MF_UNCHECKED);

		CString tmp, sBOM;
		sBOM = _T("");
		if (m_pwndView->m_bBOM) sBOM = _T("/wB");

		switch( m_pwndView->m_CharCode ) {

			case CC_SJIS:
				tmp = _T("[ Shift_JIS ] ");
				pMenu->CheckMenuItem(ID_KEY_3, MF_CHECKED);
			break;

			case CC_JIS:
				tmp = _T("[ JIS ] ");
				pMenu->CheckMenuItem(ID_KEY_4, MF_CHECKED);
			break;

			case CC_EUC:
				tmp = _T("[ EUC-JP ] ");
				pMenu->CheckMenuItem(ID_KEY_5, MF_CHECKED);
			break;

			case CC_UNICODE:
				tmp.Format(_T("[ Unicode%s ] "), sBOM);
				pMenu->CheckMenuItem(ID_KEY_6, MF_CHECKED);
			break;

			case CC_UTF7:
				tmp = _T("[ UTF-7 ] ");
				pMenu->CheckMenuItem(ID_KEY_7, MF_CHECKED);
			break;

			case CC_UTF8:
				tmp.Format(_T("[ UTF-8%s ] "), sBOM);
				pMenu->CheckMenuItem(ID_KEY_8, MF_CHECKED);
			break;

		}

		tmp += m_pwndView->m_sFullFileName;
		s = tmp;

	} else {
		CString ch = STR_YEN;
		CString fn = m_pwndGView->m_sFileName;
		int n = fn.ReverseFind(ch.GetAt(0));
		int len = fn.GetLength();
		len = len - n - 1;
		int xw = m_pwndGView->m_Xw;
		int yw = m_pwndGView->m_Yw;

		if ( n != -1 ) {
			s = fn.Right(len);
		}
		CString s2, s3;

		if (m_pFmParam->m_bFindSPI && m_pFmParam->m_bAtypeSPI) {
			s3.Format(_T("[%d/%d]"), m_pwndGView->m_nPdfPageNow + 1, m_pwndGView->m_nPdfPage);
		}

		if ( m_pwndGView->m_nMulti != GMAG_REF) {
			s2.Format(_T("[ %d%% ] %s %s"), m_pwndGView->m_nMulti / GMAG100, s3, s);
			s = s2;
		}

		s2.Format(_T("%s(%dx%d%s)"), s, xw, yw, m_pwndGView->m_sColorBits);
		s = s2;

	}


	SetWindowText(s);
}

void CannsViewFrame::OnDestroy()
{
	CFrameWnd::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry, tmp;
	CRect rc;
	GetWindowRect(&rc);


/*

HRESULT hr = DwmGetWindowAttribute(m_hWnd, DWMWA_EXTENDED_FRAME_BOUNDS, &rc, sizeof(CRect));
if (SUCCEEDED(hr)) {
}
else {
//G[
GetWindowRect(&rc);
}

WINDOWPLACEMENT wndPlace;
wndPlace.length = sizeof(WINDOWPLACEMENT);
GetWindowPlacement(&wndPlace);

rc.top = wndPlace.rcNormalPosition.top;
rc.bottom = wndPlace.rcNormalPosition.bottom;
rc.left = wndPlace.rcNormalPosition.left;
rc.right = wndPlace.rcNormalPosition.right;
*/

	tmp = _T("%s_TEXT");
	if ( m_bGmode ) {
		tmp = _T("%s_GRAPHIC");
	}
	sSection.Format(tmp, INISECTION_ANNSVIEW);
	sEntry = INIENTRY_WINDOW_TOP;
	pApp->WriteProfileInt(sSection, sEntry, rc.top);
	sEntry = INIENTRY_WINDOW_LEFT;
	pApp->WriteProfileInt(sSection, sEntry, rc.left);
	sEntry = INIENTRY_WINDOW_RIGHT;
	pApp->WriteProfileInt(sSection, sEntry, rc.right);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	pApp->WriteProfileInt(sSection, sEntry, rc.bottom);
}

BOOL CannsViewFrame::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if ( !m_bGmode ) {
		return m_pwndView->OnMouseWheel(nFlags, zDelta, pt);
	} else {
		return m_pwndGView->OnMouseWheel(nFlags, zDelta, pt);
	}

//	return CFrameWnd::OnMouseWheel(nFlags, zDelta, pt);
}

void CannsViewFrame::OnAnnsviewExit()
{
	// TODO: ɃR}h nh R[hǉ܂B
/*
	if ( !m_bGmode ) {
		m_pwndView->CmdKeyQuit();
	} else {
		m_pwndGView->CmdKeyQuit();
	}
*/
	DestroyWindow();
}

void CannsViewFrame::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
{
	CFrameWnd::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);

	// TODO: ɃbZ[W nh R[hǉ܂B

	CMenu* pMenu = GetMenu();
	if ( !m_bGmode ) {
		if ( m_pwndView->m_nFindLineNo == -1 ) {
			pMenu->EnableMenuItem(ID_KEY_V, MF_GRAYED);
			pMenu->EnableMenuItem(ID_KEY_T, MF_GRAYED);
		}
		if ( !(m_pwndView->m_bSelected) ) {
			pMenu->EnableMenuItem(ID_CTRL_KEY_C, MF_GRAYED);
			pMenu->EnableMenuItem(ID_SHIFT_KEY_C, MF_GRAYED);
		}
	} else {
		if (!(m_pwndGView->m_bEnableRect)) {
			pMenu->EnableMenuItem(ID_KEY_CTRL_T, MF_GRAYED);
		}
		if (!IsClipboardFormatAvailable(CF_BITMAP)) {
			pMenu->EnableMenuItem(ID_CTRL_KEY_V, MF_GRAYED);
		}

	}


}



void CannsViewFrame::OnSetFocus(CWnd* pOldWnd)
{
	CFrameWnd::OnSetFocus(pOldWnd);

	// TODO: ɃbZ[W nh[ R[hǉ܂B
	HIMC hIMC = ::ImmGetContext(m_hWnd);
	if (hIMC)
	{
		if (::ImmGetOpenStatus(hIMC))
		{
			::ImmSetOpenStatus(hIMC, FALSE);
			//			TRACE( _T("Disable IME\n") );
		}
		::ImmReleaseContext(m_hWnd, hIMC);
	}


}


void CannsViewFrame::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_TRACKPOS;

	m_pScrollBar->GetScrollInfo(&info);
	nPos = info.nTrackPos;

	switch (nSBCode) {
	case SB_LINEUP:	// XN[{bNX̏NbNꍇ
		m_pwndView->CmdKeyUp();
		break;

	case SB_LINEDOWN:	// XN[{bNX̉NbNꍇ
		m_pwndView->CmdKeyDown();
		break;

	case SB_PAGEUP:		// XN[{bNX̏㑤NbNꍇi܂PageUpL[j
		m_pwndView->CmdKeyPageUp();
		break;

	case SB_PAGEDOWN:		// XN[{bNX̉NbNꍇi܂PageDownL[j
		m_pwndView->CmdKeyPageDown();
		break;

	case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
		break;

	case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
		if (m_pwndView->m_FirstLine != nPos) {
			m_pwndView->m_FirstLine = nPos;
			m_pwndView->Invalidate();
		}
		break;
	}
		
		
//		CFrameWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}


void CannsViewFrame::OnInitMenu(CMenu* pMenu)
{
	CFrameWnd::OnInitMenu(pMenu);

	// TODO: ɃbZ[W nh[ R[hǉ܂B

/*
	if (!m_bGmode) {
		pMenu->RemoveMenu(2, MF_BYPOSITION | MF_GRAYED);

	}
	else {
		pMenu->RemoveMenu(3, MF_BYPOSITION | MF_GRAYED);

	}


	DrawMenuBar();
*/

}


void CannsViewFrame::OnUpdateFrameMenu(HMENU hMenuAlt)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB

	/*
	CMenu* pMenu = GetMenu();
	if (!m_bGmode) {
		pMenu->RemoveMenu(2, MF_BYPOSITION | MF_GRAYED);

	}
	else {
		pMenu->RemoveMenu(3, MF_BYPOSITION | MF_GRAYED);

	}


	DrawMenuBar();

	CFrameWnd::OnUpdateFrameMenu(hMenuAlt);
	*/

}
