// annsView.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "annsViewEx.h"
#include "annsViewFrame.h"
#include "FileView.h"
#include "FindStringDialog.h"
#include "Langage.h"

#include <mbstring.h>

// CannsViewEx

IMPLEMENT_DYNAMIC(CannsViewEx, CWnd)

CannsViewEx::CannsViewEx()
{
//	m_pScrollBar = new CScrollBar;

	m_pstLineData = new struct line_data[MAX_LINE];
	m_nMaxLine = 0;

	m_pLinePoint = new UINT[MAX_LINE];
	m_pCharLine = new UINT[MAX_LINE];
	m_pUTF7LineFlag = new int[MAX_LINE];

	m_pcFileBuffer = NULL;
	m_pcCodeData = NULL;
	m_pcFile = NULL;
	m_pFile = NULL;

	m_sFullFileName = _T("");
	m_sFileName= _T("");
	m_ScrollBarHeight = SCROLLBARHEIGHT;

	m_CurrentPage = 0;
	m_PageLineNum = 0;
	m_MaxLine = 0;
	m_FirstLine = 0;
	m_LineCharNum = 0;
	m_OfsetLeft = 5;
	m_CharCode = CC_SJIS;
	m_Endian = false;
//	m_bUnicode = false;
	m_bHexMode = false;

	m_nFindStartLine = 0;
	m_nFindLineNo = -1;
	m_nFindCharNo = -1;
	m_sFindString = _T("");
	m_wSizeX = 0;

	m_bNowSelect = false;
	m_bSelected = false;

#ifndef _WINVER_XP

	g_pDWriteFactory = NULL;
	g_pD2DFactory = NULL;
	g_pTextFormat = NULL;

	g_pRenderTarget = NULL;
	g_pBackBrush = NULL;
	g_pTextBrush = NULL;
	g_pSelBackBrush = NULL;
	g_pSelTextBrush = NULL;
	g_pEnterBrush = NULL;

#endif


}

CannsViewEx::~CannsViewEx()
{
	delete[]m_pstLineData;

	delete []m_pUTF7LineFlag;
	delete []m_pCharLine;
	delete []m_pLinePoint;
//	delete m_pScrollBar;
	if ( m_pcFileBuffer != NULL ) delete []m_pcFileBuffer;
	if ( m_pFile != NULL ) delete m_pFile;
	if (m_pcCodeData != NULL) delete[]m_pcCodeData;

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		DiscardD2d1Resources();
#endif

	}

}

static BOOL CheckTitleannsFMtextExeEx(LPTSTR lpszTitle)
{
	BOOL bResult = FALSE;

	if (lpszTitle)
	{
		CString st;
		st.Format(_T("%s"), lpszTitle);
		int n = st.Find(_T(" - annsFMtext"));
		if (n > 0) {
			bResult = TRUE;

		}
	}

	return bResult;
}


// NŁA\Ă邷ׂĂannsFMTextExe񋓂B
BOOL CALLBACK EnumWindProcannsFMtextExeEx(HWND hWnd, LPARAM lParam)

{
	HWND FAR* lpHwnd;

	lpHwnd = (HWND FAR*)lParam;
	BOOL r = TRUE;


	int nNeedLength = GetWindowTextLength(hWnd);
	if (nNeedLength > 7 && nNeedLength < MAX_PATH + 7)
	{
		if (IsWindow(hWnd) && !IsIconic(hWnd) && IsWindowVisible(hWnd))
		{
			nNeedLength += 8;
			LPTSTR lpBuffer = new TCHAR[nNeedLength];
			ZeroMemory(lpBuffer, nNeedLength * sizeof(TCHAR));
			if (GetWindowText(hWnd, lpBuffer, nNeedLength))
			{
				if (CheckTitleannsFMtextExeEx(lpBuffer))
				{
					*lpHwnd = hWnd;
					r = FALSE;
				}
			}
			delete[] lpBuffer;
		}
	}

	return r;
}



BEGIN_MESSAGE_MAP(CannsViewEx, CWnd)
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_MOUSEWHEEL()
	ON_COMMAND(ID_KEY_3, &CannsViewEx::OnMenuKey3)
	ON_COMMAND(ID_KEY_4, &CannsViewEx::OnMenuKey4)
	ON_COMMAND(ID_KEY_5, &CannsViewEx::OnMenuKey5)
	ON_COMMAND(ID_KEY_6, &CannsViewEx::OnMenuKey6)
	ON_COMMAND(ID_KEY_7, &CannsViewEx::OnMenuKey7)
	ON_COMMAND(ID_KEY_8, &CannsViewEx::OnMenuKey8)
	ON_COMMAND(ID_KEY_A, &CannsViewEx::OnMenuKeyA)
	ON_COMMAND(ID_KEY_F, &CannsViewEx::OnKeyF)
	ON_COMMAND(ID_KEY_V, &CannsViewEx::OnKeyV)
	ON_COMMAND(ID_KEY_T, &CannsViewEx::OnKeyT)
	ON_COMMAND(ID_KEY_E, &CannsViewEx::OnMenuKeyE)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_CTRL_KEY_C, &CannsViewEx::OnMenuCtrlKeyC)
	ON_COMMAND(ID_SHIFT_KEY_C, &CannsViewEx::OnMenuShiftKeyC)
//	ON_WM_MBUTTONDBLCLK()
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_FILE_PRINT, &CannsViewEx::OnFilePrint)

	ON_COMMAND(ID_VIEW_CTRL_KEY_A, &CannsViewEx::OnMenuViewCtrlKeyA)
	ON_COMMAND(ID_KEY_CTRL_V, &CannsViewEx::OnKeyCtrlV)

END_MESSAGE_MAP()



// CannsViewEx bZ[W nh

#ifndef _WINVER_XP

void CannsViewEx::CreateD2d1Resources()
{
	CreateDeviceIndependentResources();
	CreateTextFormat();
	CreateDeviceResources();
}

void CannsViewEx::DiscardD2d1Resources()
{
	DiscardDeviceIndependentResources();
	DiscardTextFormat();
	DiscardDeviceResources();

}

HRESULT CannsViewEx::CreateDeviceIndependentResources()
{
	HRESULT result = S_OK;

	D2D1CreateFactory(
		D2D1_FACTORY_TYPE_SINGLE_THREADED,
		&g_pD2DFactory);

	DWriteCreateFactory(
		DWRITE_FACTORY_TYPE_SHARED,
		__uuidof(g_pDWriteFactory),
		(IUnknown **)(&g_pDWriteFactory));


	return result;
}

void CannsViewEx::DiscardDeviceIndependentResources()
{

	if (g_pDWriteFactory != NULL) {
		g_pDWriteFactory->Release();
		g_pDWriteFactory = NULL;

	}

	if (g_pD2DFactory != NULL) {
		g_pD2DFactory->Release();
		g_pD2DFactory = NULL;

	}


}

void CannsViewEx::CreateTextFormat()
{

	if (g_pDWriteFactory == NULL) return;

	CClientDC dc(AfxGetMainWnd());
	int logpix = dc.GetDeviceCaps(LOGPIXELSY);

	CString fontname = m_pFmParam->m_logfontView.lfFaceName;
	int nPoint = -::MulDiv(m_pFmParam->m_logfontView.lfHeight, 72, logpix);

	FLOAT fs = logpix * (FLOAT)nPoint / 72;
	int ifs = (INT)(fs + 1.99) / 2;
	FLOAT dip = (FLOAT)(ifs * 2);

	int it = m_pFmParam->m_logfontView.lfItalic;

	DWRITE_FONT_STYLE st = DWRITE_FONT_STYLE_NORMAL;
	if (it != 0) st = DWRITE_FONT_STYLE_ITALIC;

	g_pDWriteFactory->CreateTextFormat(
		//		L"Verdana",
		fontname,
		NULL,
//		DWRITE_FONT_WEIGHT_NORMAL,
//		DWRITE_FONT_STYLE_NORMAL,
		(DWRITE_FONT_WEIGHT)(m_pFmParam->m_logfontView.lfWeight), // DWRITE_FONT_WEIGHT_NORMAL,
		st, // DWRITE_FONT_STYLE_NORMAL,
		DWRITE_FONT_STRETCH_NORMAL,
		//		50,	// tHgTCY
		dip,
		L"", //locale
		&g_pTextFormat);

	g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_LEADING);
	// g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_CENTER);
//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_NEAR);
//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_CENTER);

	m_FontY = (int)(g_pTextFormat->GetFontSize());

	CFont font;
	CFont* pOldFont;


	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);

	m_FontX = size.cx;
	m_FontY = size.cy + m_pFmParam->m_nViewLineSpace;

	dc.SelectObject(pOldFont);

}

void CannsViewEx::DiscardTextFormat()
{
	if (g_pTextFormat == NULL) return;

	g_pTextFormat->Release();
	g_pTextFormat = NULL;

}


HRESULT CannsViewEx::CreateDeviceResources(void)
{
	HRESULT hr = S_OK;

	if (g_pRenderTarget != NULL) {
		return hr;
	}

	RECT rc;
	GetClientRect(&rc);

	D2D1_SIZE_U size = D2D1::SizeU(
		rc.right - rc.left,
		rc.bottom - rc.top
		);

	// Create a Direct2D render target.
	g_pD2DFactory->CreateHwndRenderTarget(
		D2D1::RenderTargetProperties(),
		D2D1::HwndRenderTargetProperties(m_hWnd, size),
		&g_pRenderTarget
		);

	COLORREF colText = m_pFmParam->m_colViewText;
	COLORREF colBack = m_pFmParam->m_colViewBack;
	COLORREF colSelText = m_pFmParam->m_colViewFindString;
	COLORREF colSelBack = m_pFmParam->m_colViewFindStringBack;

	// Create a back brush.
	BYTE r, g, b;
	r = colBack & 0xff;
	g = (colBack >> 8) & 0xff;
	b = (colBack >> 16) & 0xff;

	UINT32 rgb;
	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pBackBrush
		);


	m_D2DcolBack = rgb;

	r = colText & 0xff;
	g = (colText >> 8) & 0xff;
	b = (colText >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pTextBrush);

	r = colSelText & 0xff;
	g = (colSelText >> 8) & 0xff;
	b = (colSelText >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pSelTextBrush);

	r = colSelBack & 0xff;
	g = (colSelBack >> 8) & 0xff;
	b = (colSelBack >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pSelBackBrush);

	r = m_pFmParam->m_colViewRetMark & 0xff;
	g = (m_pFmParam->m_colViewRetMark >> 8) & 0xff;
	b = (m_pFmParam->m_colViewRetMark >> 16) & 0xff;

	//	r = g = b = 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pEnterBrush);

	return hr;
}

void CannsViewEx::DiscardDeviceResources()
{
	if (g_pRenderTarget != NULL) {
		g_pRenderTarget->Release();
		g_pRenderTarget = NULL;

	}

	if (g_pBackBrush != NULL) {
		g_pBackBrush->Release();
		g_pBackBrush = NULL;
	}

	if (g_pTextBrush != NULL) {
		g_pTextBrush->Release();
		g_pTextBrush = NULL;
	}

	if (g_pSelBackBrush != NULL) {
		g_pSelBackBrush->Release();
		g_pSelBackBrush = NULL;

	}

	if (g_pSelTextBrush != NULL) {
		g_pSelTextBrush->Release();
		g_pSelTextBrush = NULL;

	}

	if (g_pEnterBrush != NULL) {
		g_pEnterBrush->Release();
		g_pEnterBrush = NULL;
	}

}

void CannsViewEx::d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = CA2W(strA);

	int len = sText.GetLength();
	int glen = strA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontY);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontX), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
//		D2D1::RectF(fX, fY, (FLOAT)rc.right, fY + lh),
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontX), fY + lh),
		brush
		);

}

void CannsViewEx::d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = strW;

	CStringA sA;
	sA = CW2A(strW);

	int len = sText.GetLength();
	int glen = sA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontY);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + (glen * m_FontX), fY + lh), backbrush);
//	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, (FLOAT)(rc.right), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontX), fY + lh),
//		D2D1::RectF(fX, fY, (FLOAT)rc.right, fY + lh),
		brush
		);

}

void CannsViewEx::d2d1DrawCrLf(int xr, int y)
{

	int x0, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;

	int fw = m_FontX;
	int fh = m_FontY;

	FLOAT st = 1.4F;

	xd = 7;
	yd = 7;
	x0 = fw + (fw / 3);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 6 / xd;
	x3 = x0 * 8 / xd;
	y0 = fh * 1 / yd;
	y1 = fh * 2 / yd;
	y2 = fh * 3 / yd + 1;
	y3 = fh * 4 / yd;
	y4 = fh * 5 / yd;
	y5 = fh * 6 / yd;

	g_Point0.x = (FLOAT)(xr + x2);
	g_Point0.y = (FLOAT)(y + y0);
	g_Point1.x = (FLOAT)(xr + x3);
	g_Point1.y = (FLOAT)(y + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// ㍶E()


	g_Point0.x = (FLOAT)(xr + x3);
	g_Point0.y = (FLOAT)(y + y4);
//	g_Point0.y = (FLOAT)(y + y3);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// Eォ牺(c)


	g_Point1.x = (FLOAT)(xr + x1);
	g_Point1.y = (FLOAT)(y + y4);
//	g_Point1.y = (FLOAT)(y + y3);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// E獶()


	g_Point0.x = (FLOAT)(xr + x1);
	g_Point0.y = (FLOAT)(y + y5);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// 牺(c)


	g_Point1.x = (FLOAT)xr;
	g_Point1.y = (FLOAT)(y + y3);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// ΂ߍ(΂)


	g_Point0.x = (FLOAT)(xr + x1);
	g_Point0.y = (FLOAT)(y + y1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// ΂߉E(΂)


	g_Point1.x = (FLOAT)(xr + x1);
	g_Point1.y = (FLOAT)(y + y2);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// ォ牺(c)


	g_Point0.x = (FLOAT)(xr + x2);
	g_Point0.y = (FLOAT)(y + y2);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// 璆E()



	g_Point1.x = (FLOAT)(xr + x2);
	g_Point1.y = (FLOAT)(y + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// E(n_)(c)


}

void CannsViewEx::d2d1DrawCr(int xr, int y)
{

	int x0, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;

	int fw = m_FontX;
	int fh = m_FontY;
	int xof = xr - 2;
	int yof = y;
	FLOAT st = 1.4F;

	xd = 7;
	yd = 7;
	x0 = fw + (fw / 2);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 5 / xd;
	x3 = x0 * 7 / xd;
	y0 = fh * 1 / yd;
	y1 = fh * 2 / yd;
	y2 = fh * 3 / yd + 1;
	y3 = fh * 4 / yd;
	y4 = fh * 5 / yd;
	y5 = fh * 6 / yd;


	g_Point0.x = (FLOAT)(xof + x2 - 1);
	g_Point0.y = (FLOAT)(yof + y4 - 1);
	g_Point1.x = (FLOAT)(xof + x1 - 1);
	g_Point1.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x1);
	g_Point0.y = (FLOAT)(yof + y5);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof);
	g_Point1.y = (FLOAT)(yof + y3);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x1);
	g_Point0.y = (FLOAT)(yof + y1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x1 - 1);
	g_Point1.y = (FLOAT)(yof + y2);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x2 - 1);
	g_Point0.y = (FLOAT)(yof + y2);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x2 - 1);
	g_Point1.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);


}

void CannsViewEx::d2d1DrawLf(int xr, int y)
{

	int x0, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;

	int fw = m_FontX;
	int fh = m_FontY;

	int xof = xr - fw;
	int yof = y + (fh / 8);

	FLOAT st = 1.4F;


	xd = 8;
	yd = 8;
	x0 = fw + (fw / 2);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 5 / xd;
	x3 = x0 * 7 / xd;
	y0 = fh * 1 / yd;
	y1 = fh * 2 / yd;
	y2 = fh * 3 / yd + 1;
	y3 = fh * 4 / yd;
	y4 = fh * 5 / yd;
	y5 = fh * 6 / yd;

	g_Point0.x = (FLOAT)(xof + x2 + 1);
	g_Point0.y = (FLOAT)(yof + y0);
	g_Point1.x = (FLOAT)(xof + x3);
	g_Point1.y = (FLOAT)(yof + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x3);
	g_Point0.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x3 + 2);
	g_Point1.y = (FLOAT)(yof + y4 - 4);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x3 - 1);
	g_Point0.y = (FLOAT)(yof + y4);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x2 - 2);
	g_Point1.y = (FLOAT)(yof + y4 - 4);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);


	g_Point0.x = (FLOAT)(xof + x2 + 1);
	g_Point0.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x2 + 1);
	g_Point1.y = (FLOAT)(yof + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

}


// ϊUnicodef[^(m_pcCodeData)擪mFāApZ̃EBhɂȂ
// es̐擪ʒu߂(݂̃^uݒl)
// 擪ʒuƉsʒu(m_pcCodeData̐擪WORDlʒu=)Asf[^(m_pstLineData)ɕۑ
// EBhE܂łɉsȂꍇ́A-1

void CannsViewEx::DetectLineData(void)
{
	WORD *pCodeData;
	struct line_data *pstLineData;

	pCodeData = (WORD*)m_pcCodeData;
	pstLineData = m_pstLineData;

	CRect rc;
	GetClientRect(&rc);

	int nWndWidth;
	int nBytePos;	// s擪̔pʒu
	int ntab = m_pFmParam->m_ViewTabNum;
	int nt = ntab;

	nWndWidth = rc.right - rc.left;
	int nWndWidthChar = nWndWidth / m_FontX;	// pZEBhE
	nBytePos = 0;

	int n = 0;	// CodeDataǂݍ݈ʒuJE^
	WORD wd = pCodeData[n];

	int cn = 0;	// LineData݈ʒu(ݍs)JE^
	pstLineData[cn].start = n;
	pstLineData[cn].entpos = -1;

	bool bLineEnd = false;	// s[H
	while (wd != 0) {	// f[^I[=NULL


		nBytePos++;
		if (wd > 0x7f) {
			nBytePos++;
		}

		if (wd == 0x09) {	// Tab
			while (nt > 0) {
				nBytePos++;
				nt--;
			}

			nt = ntab;

		}


		if (nBytePos > nWndWidthChar) {	// pZEBhE[z
			bLineEnd = true;
		}
		else {
			if (wd == 0x0d) {	// s
				pstLineData[cn].entpos = nBytePos;

				WORD wd1 = pCodeData[n + 1];
				if (wd1 == 0x0a) {
					n++;
				}
				bLineEnd = true;
			}

		}

		if (bLineEnd) {
			pstLineData[cn].num = n;

			n++;
			cn++;
			pstLineData[cn].start = n;
			pstLineData[cn].num = 0;
			pstLineData[cn].entpos = -1;

			nt = ntab;
			nBytePos = 0;
		}

		wd = pCodeData[n];

		if (wd == 0) {	// f[^I
			pstLineData[cn].num = n;
			m_nMaxLine = cn;
			break;
		}
	}


}


void CannsViewEx::DrawHexModeDirectWrite(void)
{
	CClientDC dc(this);

	//	if ( m_FileSize == 0 ) return;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "A";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	//	COLORREF colview = m_pFmParam->m_colViewText;

	//	dc.SetBkColor(m_colBack);

	//	CPen pen(PS_SOLID, 0, m_pFmParam->m_colViewRetMark);
	//	CPen* pOldPen = dc.SelectObject(&pen);

	int x, y;
	UINT line = 0;
	unsigned char *cc, *cc2;

	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];

	CStringA s, sLine, form, s0, s8, s07, s8f, s16b;
	int nAdd = 0;
	int adstep = 16;
	//	m_MaxLineHexMode = (UINT)(m_FileSize / adstep) + 1;
	ULONGLONG nData = 0;

	form = "%08x  %-24s- %-24s |  %-16s  |";

	x = m_OfsetLeft;
	y = 0;

	//	dc.SetTextColor(colview);

	g_pRenderTarget->BeginDraw();

	g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolBack));

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLineHexMode) break;

		//		cc = m_pcFile + m_pLinePoint[line];
		cc = m_pcFile + (line * adstep);
		cc2 = cc;
		int nl = adstep;
		memcpy(cbuf, "                ", nl);
		cbuf[nl] = 0;

		nAdd = line * adstep;
		nData = line * adstep;

		s07 = "";
		for (int i = 0; i < 8; i++) {
			if (nData == m_FileSize) break;
			s0.Format("%02x ", (int)*cc2);
			s07 += s0;
			cbuf[i] = *cc2;
			if (*cc2 < 0x20) cbuf[i] = '.';
			cc2++;
			nData++;
		}

		cc2 = cc + 8;
		s8f = _T("");
		for (int i = 8; i < 16; i++) {
			if (nData == m_FileSize) break;
			s8.Format("%02x ", (int)*cc2);
			s8f += s8;
			cbuf[i] = *cc2;
			int cn = (int)*cc2;
			if (cn < 0x20) {
				cbuf[i] = '.';
			}
			cc2++;
			nData++;
		}

		if (m_FileSize < 17L) {
			nl = (int)m_FileSize;
		}

		cbuf[nl] = 0;
		s16b.Format("%s", cbuf);
		sLine.Format(form, nAdd, s07, s8f, s16b);

		//		TextOutA(dc.m_hDC, x, y, (LPCSTR)sLine, sLine.GetLength());

		d2d1DrawTextA(x, y, sLine, g_pTextBrush, g_pBackBrush);

		nAdd += adstep;
		//		cc += adstep;
		y += fh;

	}

	g_pRenderTarget->EndDraw();

	//	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = (int)(m_MaxLineHexMode / m_PageLineNum);
	if (maxpage > 0) {
		//		m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
}


void CannsViewEx::OnPaintDirectWrite()
{
	CPaintDC dc(this); // device context for painting
					   // TODO: ɃbZ[W nh R[hǉ܂B
					   // `惁bZ[W CWnd::OnPaint() ĂяoȂłB


	if (m_bHexMode) {
		DrawHexModeDirectWrite();
		return;
	}

	g_pRenderTarget->BeginDraw();

	g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolBack));


	CRect rc;
	GetClientRect(&rc);
	m_nClientYw = rc.bottom;

	m_saSelectStr = "";
	m_sSelectStr = _T("");
	CStringA saSelLine;
	CString sSelLine;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;
	m_FontX = fw;
	m_FontY = fh;

	CString s, form;
	CSize sizew;


	int x, y, xr;

	UINT line = 0;
	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE + 10];


	x = m_OfsetLeft;
	y = 0;
	xr = 0;

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A, sA3, sA4;
	CStringA sSP = "  ";
	sA2.Format("%c", 0x09);

	CString sW, sW2, sW3;
	CString sSPW = _T("  ");
	sW2.Format(_T("%c"), 0x09);

	while (ntab != 0) {
		sSP += " ";
		sSPW += _T(" ");
		ntab--;
	}

	CString sAll;
	sAll.Format(_T("%s"), m_pcCodeData);

	d2d1DrawTextW(0, 0, sAll, g_pTextBrush, g_pBackBrush);

/*

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLine) break;


			xr = x + (linea * fw) + fw / 2;

			if (bCrLf) {

				d2d1DrawCrLf(xr, y);


			}
			else {
				if (bLf) {

					d2d1DrawLf(xr, y);


				}

			}
			if (bCr) {

				d2d1DrawCr(xr, y);


			}


			y += fh;

	}

*/


	g_pRenderTarget->EndDraw();

	dc.SelectObject(pOldFont);

	int maxpage;
	maxpage = m_MaxLine / m_PageLineNum;
	if (maxpage > 0) {
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
	delete[]wcbuf;



}

#endif

BOOL CannsViewEx::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (!(m_pFmParam->m_bViewDirectWrite)) {
		m_colBack = m_pFmParam->m_colViewBack;

		// uV̍쐬
		CBrush brush(m_colBack);
		// VuVw(̃uV̕ۑ)
		CBrush* pOldBrush = pDC->SelectObject(&brush);


		// hԂ̈擾
		CRect rect;
		GetClientRect(&rect);

		// hԂ
		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

		// uVɖ߂
		pDC->SelectObject(pOldBrush);

	}

	return TRUE;

//	return CWnd::OnEraseBkgnd(pDC);
}

void CannsViewEx::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	short shift = GetKeyState(VK_SHIFT);
	short ctrl = GetKeyState(VK_CONTROL);

	UINT cmdno;
	if ( shift < 0 ) {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x300;
		} else {
			cmdno = nChar + 0x100;
		}
	} else {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x200;
		} else {
			cmdno = nChar;
		}
	}

	RunKeyCmd(cmdno);

//	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CannsViewEx::OnPaint()
{

	if (m_FileSize == 0) return;

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		OnPaintDirectWrite();
#endif

		return;
	}

	if (m_bHexMode) {
		DrawHexMode();
		return;
	}

	CPaintDC dc(this); // device context for painting
					   // TODO: ɃbZ[W nh R[hǉ܂B
					   // `惁bZ[W CWnd::OnPaint() ĂяoȂłB

	CRect rc;
	GetClientRect(&rc);
	m_nClientYw = rc.bottom;

	m_saSelectStr = "";
	m_sSelectStr = _T("");
	CStringA saSelLine;
	CString sSelLine;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "W";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;
	m_FontX = fw;
	m_FontY = fh;

	CString s, form;
	CSize sizew;


	COLORREF colview = m_pFmParam->m_colViewText;
	COLORREF colFindStr = m_pFmParam->m_colViewFindString;
	COLORREF colFindStrBack = m_pFmParam->m_colViewFindStringBack;

	//	dc.SetBkColor(m_pFmParam->m_colBack);

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colViewRetMark);
	CPen* pOldPen = dc.SelectObject(&pen);

	int x0, x, y, xr, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;
	UINT line = 0;
	wchar_t* pc;
	unsigned char *cc, *cc2, *ccs;
	unsigned char c0, c1, ctmp;

	//	UINT jcode, sjcode;
	int clen;
	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE + 10];

	unsigned char *dbuf;

	x = m_OfsetLeft;
	y = 0;
	xr = 0;
	xd = 10;
	yd = 10;
	x0 = fw + (fw / 2);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 5 / xd;
	x3 = x0 * 7 / xd;
	y0 = fh * 3 / yd;
	y1 = fh * 4 / yd;
	y2 = fh * 5 / yd + 1;
	y3 = fh * 6 / yd;
	y4 = fh * 7 / yd;
	y5 = fh * 8 / yd;

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A, sA3, sA4;
	CStringA sSP = "  ";
	sA2.Format("%c", 0x09);

	CString sW, sW2, sW3;
	CString sSPW = _T("  ");
	sW2.Format(_T("%c"), 0x09);

	while (ntab != 0) {
		sSP += " ";
		sSPW += _T(" ");
		ntab--;
	}

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLine) break;
		dc.SetTextColor(colview);
		dc.SetBkColor(m_colBack);

		if (m_CharCode == CC_UNICODE) {

			cc2 = m_pcFile + m_pLinePoint[line];
			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			int orglen = sl;

			memcpy(cbuf, cc2, sl);
			cbuf[sl] = 0;
			cbuf[sl + 1] = 0;

			sl -= 2;
			c0 = cbuf[sl];
			c1 = cbuf[sl + 1];

			if (m_Endian) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}

			bool bCrLf = false;
			bool bCr = false;
			bool bLf = false;

			if ((sl >= 0) && (c0 == 0x0a) && (c1 == 0)) {
				//				cbuf[sl] = 0;
				//				cbuf[sl + 1] = 0;
				sl -= 2;
				c0 = cbuf[sl];
				c1 = cbuf[sl + 1];

				if (m_Endian) {
					ctmp = c0;
					c0 = c1;
					c1 = ctmp;
				}
				if ((sl >= 0) && (c0 == 0x0d) && (c1 == 0)) {
					//					cbuf[sl] = 0;
					//					cbuf[sl + 1] = 0;
					bCrLf = true;
				}
				else {
					bLf = true;
				}
			}
			else {
				if ((sl >= 0) && (c0 == 0x0d) && (c1 == 0)) {
					//					cbuf[sl] = 0;
					//					cbuf[sl + 1] = 0;
					//					bCrLf = true;
					bCr = true;
				}
			}

			dbuf = new unsigned char[orglen * m_pFmParam->m_ViewTabNum + 2];
//			ReplaceTab(cbuf, dbuf, orglen);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete[]dbuf;

			int lw = sW.GetLength();
			CString stW = sW;
			//			stW.Replace(_T("\r\n"), _T("  "));
			int sr = stW.Replace(_T("\r\n"), _T("  "));
			if (sr == 0) {
				sr = stW.Replace(_T("\r"), _T(" "));
				if (sr == 0) {
					sr = stW.Replace(_T("\n"), _T(" "));
				}
			}

			int linea = m_nLineA;


			pc = (wchar_t*)(m_pcFile + m_pLinePoint[line]);
			xr = x;
			//			if ( m_pCharLine[line] != 0 ) {
			dc.TextOut(x, y, stW, lw);
			size = dc.GetTextExtent(sW);
			int linelen = size.cx;

			if (line == m_nFindLineNo) {	// v
				sW3 = sW.Left(m_nFindCharNo);
				size = dc.GetTextExtent(sW3);	// v̕\Jnʒu
				sW3 = sW.Mid(m_nFindCharNo, m_sFindString.GetLength());
				dc.SetTextColor(colFindStr);
				dc.SetBkColor(colFindStrBack);
				dc.TextOut(x + size.cx, y, sW3, sW3.GetLength());

			}

			cc = m_pcFile + m_pLinePoint[line];
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;
				int dXs = m_nSelStartCs;
				int dXe = m_nSelEndCe;

				int nXs = m_nSelStartNs;
				int nXe = m_nSelEndNe;

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;
					dXs = m_nSelEndCs;
					dXe = m_nSelStartCe;

					nXs = m_nSelEndNs;
					nXe = m_nSelStartNe;
				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndCs;
						dXe = m_nSelStartCe;

						nXs = m_nSelEndNs;
						nXe = m_nSelStartNe;
					}
				}

				if (line == sy) {
					ccs = cc;
					ccs += dXs;

					int dlen = dXs;
					memcpy(cbuf, cc, dlen);
					cbuf[dlen] = 0;
					cbuf[dlen + 1] = 0;

					size.cx = 0;
					size.cy = 0;
					if (dlen > 0) {
						dbuf = new unsigned char[dlen * m_pFmParam->m_ViewTabNum + 2];
//						ReplaceTab(cbuf, dbuf, dlen);
						sW.Format(_T("%s"), (wchar_t*)dbuf);
						delete[]dbuf;
						size = dc.GetTextExtent(sW);
					}


					int len = dXe + 1;

					if (ey > sy) {
						len = m_pLinePoint[line + 1] - m_pLinePoint[line];
					}

					memcpy(cbuf, cc, len);


					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}

						}

					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
//					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;

					CString sW2;
					sW2 = sW;

					int la = sW.GetLength();
					int l = nXe - nXs + 1;
					if (ey > sy) {
						l = la - nXs + 1;
					}

					sW = sW2.Mid(nXs, l);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOut(dc.m_hDC, x + size.cx, y, sW, sW.GetLength());
				}

				if ((line > sy) && (line < ey)) {
					ccs = cc;
					int len = m_pLinePoint[line + 1] - m_pLinePoint[line];

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}
						}
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
//					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOut(dc.m_hDC, x, y, sW, sW.GetLength());
				}

				if ((line == ey) && (sy != ey)) {
					ccs = cc;
					int len = dXe + 1;

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}
						}
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
//					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;


					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOut(dc.m_hDC, x, y, sW, sW.GetLength());

				}


			}

			xr = x + (linea * fw) + fw / 2;
			//			}
			if (bCrLf) {
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
			}
			else {
				if (bLf) {
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
				}

			}
			if (bCr) {
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
			}


			y += fh;
		}


	}

	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = m_MaxLine / m_PageLineNum;
	if (maxpage > 0) {
		//		m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
	delete[]wcbuf;
}



void CannsViewEx::CheckAutoCharCode(void)
{
}


int CannsViewEx::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB

	m_pFile = new CFile(m_sFullFileName, CFile::modeRead | CFile::shareDenyNone);
	m_pFile->GetStatus(m_FileStatus);
	m_FileSize = m_FileStatus.m_size;

	m_ReadFileSize = 0x4000000;	// 64MB(1000~65000s)܂
	UINT rsize;

	if ( m_FileSize < (ULONGLONG)m_ReadFileSize ) m_ReadFileSize = (UINT)m_FileSize;

	m_wCodePage = 932;
	m_CharCode = CC_SJIS;
	if ( m_FileSize > 0 ) {
		m_pcFileBuffer = new unsigned char[m_ReadFileSize];
		m_pcCodeData = new unsigned char[m_ReadFileSize * 2];
		DWORD dwSize = m_ReadFileSize * 2 + 2;
		ZeroMemory(m_pcCodeData, dwSize);

		// t@Cǂݍ
		rsize = m_pFile->Read(m_pcFileBuffer, m_ReadFileSize);
		m_pFile->Close();
		CLangage lg;

		//t@C̐擪1MBǂݍŁAR[hy[W߂
		char* szBuff = new char[1024 * 1024 + 2];
		if (szBuff)
		{
			ZeroMemory(szBuff, 1024 * 1024 + 2);
			CFile file;
			if (file.Open(m_sFullFileName, CFile::modeRead, NULL, NULL))
			{
				UINT nLen = file.Read(szBuff, 1024 * 1024);
				lg.DetectInputCodepageJPN(szBuff, nLen, 0, &m_wCodePage);
			}
			delete szBuff;
		}
		m_pcFile = m_pcFileBuffer;

		if (m_wCodePage == 1200) {
			m_CharCode = CC_UNICODE;
		}
		if (m_wCodePage == 1201) {
			m_CharCode = CC_UNICODE;
		}
		if (m_wCodePage == 65000) {
			m_CharCode = CC_UTF7;
		}
		if (m_wCodePage == 65001) {
			m_CharCode = CC_UTF8;
		}
		if (m_wCodePage == 51932) {
			m_CharCode = CC_EUC;
		}
		if (m_wCodePage == 50220 || m_wCodePage == 50221 || m_wCodePage == 50222 || m_wCodePage == 20932) {
			m_CharCode = CC_JIS;
		}

		UINT nDest, nSrc;
		nSrc = m_ReadFileSize;
		nDest = dwSize;
		HRESULT hr;
		hr = lg.ConvertStringToUnicode(m_wCodePage, (CHAR*)m_pcFileBuffer, &nSrc, (WCHAR*)m_pcCodeData, &nDest);


	}

	m_MaxLineHexMode = (UINT)(m_FileSize / 16) + 1;

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		CreateD2d1Resources();
#endif

	}


	return 0;
}

void CannsViewEx::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B

	CRect rc;
	GetClientRect(&rc);

	CFont font;
	CFont* pOldFont;
	int fw, fh;
//	CClientDC dc = CClientDC(this);
	CDC* dc = GetDC();

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc->SelectObject(&font);

	CString ss;
	ss = _T("A");
	CSize size = dc->GetTextExtent( ss );
	dc->SelectObject(pOldFont);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	int w;
//	w = rc.Width() - m_ScrollBarHeight;
	w = rc.Width();
	m_LineCharNum = w / fw - 3;	// 1s̕\(pZ)
//	m_LineCharNum = w / fw - 4;	// 1s̕\(pZ)
	m_PageLineNum = rc.Height() / fh;	// 1y[W̕\s


	if ( m_LineCharNum < 2 ) return;
	if ( m_PageLineNum < 1 ) return;

//	if ( m_wSizeX != cx ) {
//		m_FirstLine = 0;
//		m_wSizeX = cx;
//	}

	bool fmode = false;
	ULONGLONG ullByte = 0;
	ULONGLONG ullFstByte = 0;

	if ( m_wSizeX != cx ) {

		int fln = m_nFindLineNo;
		int fcn = m_nFindCharNo;
		int fstln = m_FirstLine;
		bool bFst = false;

		if ( m_nFindLineNo != -1 ) {

			for ( UINT i = 0; i < m_MaxLine; i++ ) {
				if ( !bFst ) {
					if ( i == fstln ) {
						ullFstByte += fcn;
						bFst = true;
					} else {
						ullFstByte += m_pCharLine[i];
					}
				}

				if ( i == fln ) {
					ullByte += fcn;
					fmode = true;
					break;
				}
				ullByte += m_pCharLine[i];
			}
		}
	}

	CalcLinePoint();

	if ( m_wSizeX != cx ) {
		if ( fmode ) {
			ULONGLONG ullTb = 0;
			ULONGLONG ullFstTb = 0;
			UINT ul;
			bool bFst = false;
			for ( UINT i = 0; i < m_MaxLine; i++ ) {
				ul = m_pCharLine[i];
				if ( !bFst ) {
					if ( (ullFstTb + ul) > ullFstByte ) {
						m_FirstLine = i;
						bFst = true;
					} else {
						ullFstTb += m_pCharLine[i];
					}
				}

				if ( (ullTb + ul) > ullByte ) {
					m_nFindLineNo = i;
					m_nFindCharNo = (int)(ullByte - ullTb);
					break;
				}
				ullTb += m_pCharLine[i];
			}
		}
		m_wSizeX = cx;
	}

//	m_nFindLineNo = -1;
//	m_nFindCharNo = -1;
//	m_sFindString = _T("");

	UINT last = m_MaxLine - m_PageLineNum;

	if (m_FirstLine > last) {
		m_FirstLine = last;
	}

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		DiscardDeviceResources();
		CreateDeviceResources();
#endif

	}

//	GetWindowRect(&rc);
//	ScreenToClient(&rc);
//	rc.left = rc.right - m_ScrollBarHeight;
//	m_pScrollBar->MoveWindow(&rc);

	SetScrollData();

	ReleaseDC(dc);
}

void CannsViewEx::SetScrollData(void)
{
	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_PAGE | SIF_RANGE;
	info.nMin = 0;    
	info.nMax = m_MaxLine - 1;
	info.nPage = m_PageLineNum;
	info.nPos = 0;
	info.nTrackPos = m_pFmParam->m_ViewDeltaLine;

//	m_pScrollBar->SetScrollInfo(&info);

	m_pViewFrame->m_pScrollBar->SetScrollInfo(&info);

	if ( m_MaxLine < (UINT)m_PageLineNum ) {
//		m_pScrollBar->EnableScrollBar(ESB_DISABLE_BOTH);
		m_pViewFrame->m_pScrollBar->EnableScrollBar(ESB_DISABLE_BOTH);
	}
//	m_pScrollBar->ShowScrollBar();
	m_pViewFrame->m_pScrollBar->ShowScrollBar();
}

// ǂݍ񂾃eLXgt@C̕R[h`FbN
void CannsViewEx::CheckCharCode(void)
{
}


// L[R}hs	nCmdNo = R}hNo.
// L[JX^}CYyуR}h}NpɁAR}hNo.őSẴR}hs
void CannsViewEx::RunKeyCmd(UINT uCmdNo)
{
	switch ( uCmdNo ) {

		case 0x08: // "Backspace"
//			CmdKeyBackspace();
			break;

		case 0x09: // "Tab"
			if ( m_bHexMode  ) {
				m_bHexMode = false;
				m_MaxLine = m_MaxLineNormalMode;
			} else {
				m_bHexMode = true;
				m_MaxLine = m_MaxLineHexMode;
			}
			m_FirstLine = 0;
			Invalidate();
			break;

		case 0x0d: // "Enter"
			CmdKeyEnter();
			break;

		case 0x1b: // "Esc"
			CmdKeyQuit();
			break;

		case 0x20: // Space
			CmdKeySpace();
			break;

		case 0x21: // PageUp
			CmdKeyPageUp();
			break;

		case 0x22: // PageDown
			CmdKeyPageDown();
			break;


		case 0x23: // "End"
			CmdKeyEnd();
			break;

		case 0x24: // "Home"
			CmdKeyHome();
			break;

		case 0x25: // ""
			CmdKeyLeft();
			break;

		case 0x26: // ""
			CmdKeyUp();
			break;

		case 0x27: // ""
			CmdKeyRight();
			break;

		case 0x28: // ""
			CmdKeyDown();
			break;

		case 0x30: // "0"
		case 0x31: // "1"
		case 0x32: // "2"
		case 0x33: // "3"
		case 0x34: // "4"
		case 0x35: // "5"
		case 0x36: // "6"
		case 0x37: // "7"
		case 0x38: // "8"
		case 0x39: // "9"
			CmdKeyNumber(uCmdNo);
			break;

		case 0x41: // "A"
			OnMenuKeyA();
			break;

		case 0x45: // "E"
			CmdKeyShiftEnter();
//			CmdKeyNumber(0x35);
			break;

		case 0x46: // "F"
			CmdKeyFind();
			break;

		case 0x4a: // "J"
			CmdKeyNumber(0x34);
			break;

		case 0x50: // "P"
			OnFilePrint();
			SetFocus();
			break;

		case 0x51: // "Q"
			CmdKeyQuit();
			break;

		case 0x53: // "S"
			CmdKeyNumber(0x33);
			break;

		case 0x54: // "T"
			CmdKeyFindPrev();
			break;

		case 0x55: // "U"
			CmdKeyNumber(0x36);
			break;

		case 0x56: // "V"
			CmdKeyFindNext();
			break;

		case 0x60: // "0" eL[
		case 0x61: // "1"
		case 0x62: // "2"
		case 0x63: // "3"
		case 0x64: // "4"
		case 0x65: // "5"
		case 0x66: // "6"
		case 0x67: // "7"
		case 0x68: // "8"
		case 0x69: // "9"
			break;

		case 0x72: // "F3"
			CmdKeyFindNext();
			break;


		// Shift+
		case 0x108: // "Backspace"
			break;

		case 0x10d: // "Enter"
			CmdKeyShiftEnter();
			break;

		case 0x121: // PageUp
			break;

		case 0x122: // PageDown
			break;


		case 0x125: // ""
			break;

		case 0x126: // ""
			break;

		case 0x127: // ""
			break;

		case 0x128: // ""
			break;

		case 0x130: // "0"
			break;
		case 0x131: // "1"
			break;
		case 0x132: // "2"
			break;
		case 0x133: // "3"
			break;
		case 0x134: // "4"
			break;
		case 0x135: // "5"
			break;
		case 0x136: // "6"
			break;
		case 0x137: // "7"
			break;
		case 0x138: // "8"
			break;
		case 0x139: // "9"
			break;

		case 0x160: // "0" eL[
			break;
		case 0x161: // "1"
			break;
		case 0x162: // "2"
			break;
		case 0x163: // "3"
			break;
		case 0x164: // "4"
			break;
		case 0x165: // "5"
			break;
		case 0x166: // "6"
			break;
		case 0x167: // "7"
			break;
		case 0x168: // "8"
			break;
		case 0x169: // "9"
			break;

		// Ctrl+
		case 0x208: // "Backspace"
			break;

		case 0x20d: // "Enter"
			break;

		case 0x221: // PageUp
			CmdKeyPageUp(false);
			break;

		case 0x222: // PageDown
			CmdKeyPageDown(false);
			break;


		case 0x225: // ""
			CmdKeyPageUp(false);
			break;

		case 0x226: // ""
			break;

		case 0x227: // ""
			CmdKeyPageDown(false);
			break;

		case 0x228: // ""
			break;

		case 0x230: // "0"
			break;
		case 0x231: // "1"
			break;
		case 0x232: // "2"
			break;
		case 0x233: // "3"
			break;
		case 0x234: // "4"
			break;
		case 0x235: // "5"
			break;
		case 0x236: // "6"
			break;
		case 0x237: // "7"
			break;
		case 0x238: // "8"
			break;
		case 0x239: // "9"
			break;

		case 0x260: // "0" eL[
			break;
		case 0x261: // "1"
			break;
		case 0x262: // "2"
			break;
		case 0x263: // "3"
			break;
		case 0x264: // "4"
			break;
		case 0x265: // "5"
			break;
		case 0x266: // "6"
			break;
		case 0x267: // "7"
			break;
		case 0x268: // "8"
			break;
		case 0x269: // "9"
			break;

		case 0x241: // "A"
			CmdKeyCtrlA();
			break;

		case 0x243: // "C"
			CmdKeyCtrlC();
			break;

		case 0x246: // "F"
			CmdKeyFind();
			break;

		case 0x256: // "V"
			CmdKeyCtrlVRunannsView();
			break;

	}
}

void CannsViewEx::CmdKeyCtrlVRunannsView()
{
	HWND hwnd = 0;

	EnumWindows((WNDENUMPROC)&EnumWindProcannsFMtextExeEx, (LPARAM)&hwnd);

	if (hwnd != 0) {

		int nNeedLength = ::GetWindowTextLength(hwnd);
		nNeedLength += 8;

		LPTSTR lpBuffer = new TCHAR[nNeedLength];
		ZeroMemory(lpBuffer, nNeedLength * sizeof(TCHAR));
		if (::GetWindowText(hwnd, lpBuffer, nNeedLength))
		{
			CString sTitle;
			sTitle.Format(_T("%s"), lpBuffer);
			int n = sTitle.Find(m_sFullFileName);
			if (n >= 0)
				::SetForegroundWindow(hwnd);
			else
				m_pViewFrame->m_pwndFile->RunannsFMtextExe(m_sFullFileName);
		}
		delete[] lpBuffer;

	}


}

// es̃obt@ł̊JnʒuEBhEvZ
void CannsViewEx::CalcLinePoint(void)
{
}

// L[R}h ==================================

// Cmd No 0x0d
void CannsViewEx::CmdKeyEnter(void)
{
	CmdKeyQuit();
}

// Cmd No 0x20
void CannsViewEx::CmdKeySpace(void)
{
}

// Cmd No 0x21
void CannsViewEx::CmdKeyPageUp(bool bHalf)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta = m_PageLineNum / 2;

	if (!bHalf) delta = m_PageLineNum - 1;

	int next = m_FirstLine - delta;

	if ( next < 0 ) delta = m_FirstLine;
	m_FirstLine -= delta;
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x22
void CannsViewEx::CmdKeyPageDown(bool bHalf)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta = m_PageLineNum / 2;

	if (!bHalf) delta = m_PageLineNum - 1;

	UINT next = m_FirstLine + delta;
	UINT last = m_MaxLine - m_PageLineNum;

	if ( next > last ) delta = last - m_FirstLine;
	m_FirstLine += delta;
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x23
void CannsViewEx::CmdKeyEnd(void)
{
	if ( m_FileSize == 0 ) return;
	int line = m_MaxLine - m_PageLineNum;
	if ( line < 0 ) return;
	m_FirstLine = line;
	Invalidate();
}
// Cmd No 0x24
void CannsViewEx::CmdKeyHome(void)
{
	if ( m_FileSize == 0 ) return;
	m_FirstLine = 0;
	Invalidate();
}


// Cmd No 0x25
void CannsViewEx::CmdKeyLeft(void)
{
	CmdKeyPageUp();
}

// Cmd No 0x27
void CannsViewEx::CmdKeyRight(void)
{
	CmdKeyPageDown();
}

// Cmd No 0x26
void CannsViewEx::CmdKeyUp(void)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta;
	delta = m_pFmParam->m_ViewDeltaLine;
	if ( m_FirstLine < delta ) {
		delta = m_FirstLine;
	}
	m_FirstLine -= delta; 
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x27
void CannsViewEx::CmdKeyDown(void)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta;
	delta = m_pFmParam->m_ViewDeltaLine;
	UINT last = m_FirstLine + delta + m_PageLineNum;
	if ( last > m_MaxLine ) {
		m_FirstLine = m_MaxLine  - m_PageLineNum;
	} else m_FirstLine += delta; 
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x30 - 0x39
void CannsViewEx::CmdKeyNumber(UINT uCmdNo)
{
	if ( m_FileSize == 0 ) return;

	m_nFindLineNo = -1;
	m_nFindCharNo = -1;

	switch( uCmdNo ) {
		case 0x30:
		break;
		case 0x31:
		break;
		case 0x32:
		break;

		case 0x33:
			m_CharCode = CC_SJIS;
		break;

		case 0x34:
			m_CharCode = CC_JIS;
		break;

		case 0x35:
			m_CharCode = CC_EUC;
		break;

		case 0x36:
			m_CharCode = CC_UNICODE;
		break;

		case 0x37:
			m_CharCode = CC_UTF7;
		break;

		case 0x38:
			m_CharCode = CC_UTF8;
		break;

		case 0x39:
		break;
	}
	m_MaxLine = m_MaxLineNormalMode;
	CalcLinePoint();
	Invalidate();
	m_pViewFrame->DrawFileName();

//	CRect rc;
//	GetWindowRect(&rc);
//	ScreenToClient(&rc);
//	rc.left = rc.right - m_ScrollBarHeight;
//	m_pScrollBar->MoveWindow(&rc);
	SetScrollData();
}

// Cmd No 0x46
void CannsViewEx::CmdKeyFind(void)
{
	CFindStringDialog dlg(this);

	dlg.m_pFmParam = m_pFmParam;

	int ret = dlg.DoModal();

	if ( ret == IDOK ) {

		m_sFindString = dlg.m_sFindEdit;

		m_nFindLineNo = -1;
		m_nFindStartLine = 0;
		int mode = 0;

		if ( dlg.m_bUpSerchCheck ) {
			mode = -1;
			m_nFindStartLine = m_MaxLine;
		}

		m_bCase = dlg.m_bCapsCheck;
		bool br = FindString(mode, m_bCase);

		if ( br ) {
			int nfl = m_nFindLineNo - 3;
			if ( nfl < 0 ) m_FirstLine = 0;
			else {
				if ( m_MaxLine > (UINT)m_PageLineNum ) m_FirstLine = nfl;
			}
			Invalidate();
		} else {
			CString s;
			s = _T("w肳ꂽ͌܂ł");
			MessageBox(s, _T("̌"));
		}
	}
}

// Cmd No 0x51
void CannsViewEx::CmdKeyQuit(void)
{
	m_pViewFrame->DestroyWindow();
}

// Cmd No 0x54
void CannsViewEx::CmdKeyFindPrev(void)
{
	if ( m_nFindLineNo == -1 ) return;

	bool br = FindString(-2, m_bCase);

	if ( br ) {
		int nfl = m_nFindLineNo - 3;
		if ( nfl < 0 ) m_FirstLine = 0;
		else {
			if ( m_MaxLine > (UINT)m_PageLineNum ) m_FirstLine = nfl;
		}
		Invalidate();
	} else {
		CString s;
		s = _T("w肳ꂽ͌܂ł");
		MessageBox(s, _T("̌"));
	}
}

// Cmd No 0x56
void CannsViewEx::CmdKeyFindNext(void)
{
	if ( m_nFindLineNo == -1 ) return;

	bool br = FindString(1, m_bCase);

	if ( br ) {
		int nfl = m_nFindLineNo - 3;
		if ( nfl < 0 ) m_FirstLine = 0;
		else {
			if ( m_MaxLine > (UINT)m_PageLineNum ) m_FirstLine = nfl;
		}
		Invalidate();
	} else {
		CString s;
		s = _T("w肳ꂽ͌܂ł");
		MessageBox(s, _T("̌"));
	}
}

// Cmd No 0x10d Shift Enter
void CannsViewEx::CmdKeyShiftEnter(void)
{
	CString cpath, fname, cfname, tmp, sEditor;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = m_pFmParam->m_pw64FindData[m_pViewFrame->m_pwndFile->m_CurrentFileNo].name;

	tmp = _T("open");
	cfname = _T("\"");
	cfname += cpath;
	cfname += fname;
	cfname += _T("\"");
	
//	sEditor = m_pFmParam->m_sToolEditor;
	sEditor = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolEditor);

	ShellExecute(m_pViewFrame->m_pwndFile->m_hWnd, tmp, sEditor, cfname, cpath, SW_SHOW);
	CmdKeyQuit();

}

void CannsViewEx::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B


//	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}



BOOL CannsViewEx::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( zDelta > 0 ) CmdKeyUp();
	else CmdKeyDown();

	return 0;

//	return CWnd::OnMouseWheel(nFlags, zDelta, pt);
}

void CannsViewEx::OnMenuKey3()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x33);
}

void CannsViewEx::OnMenuKey4()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x34);
}

void CannsViewEx::OnMenuKey5()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x35);
}

void CannsViewEx::OnMenuKey6()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x36);
}

void CannsViewEx::OnMenuKey7()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x37);
}

void CannsViewEx::OnMenuKey8()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x38);
}

void CannsViewEx::OnMenuKeyA()
{
	// TODO: ɃR}h nh R[hǉ܂B

	if ( m_FileSize == 0 ) return;

	m_CurrentPage = 0;
	m_PageLineNum = 0;
	m_MaxLine = 0;
	m_MaxLineNormalMode = 0;
	m_FirstLine = 0;
	m_LineCharNum = 0;
	m_OfsetLeft = 5;
	m_CharCode = CC_SJIS;
	m_Endian = false;

	CRect rc;
	GetClientRect(&rc);

	CFont font;
	CFont* pOldFont;
	int fw, fh;
//	CClientDC dc = CClientDC(this);
	CDC* dc = GetDC();

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc->SelectObject(&font);

	CString ss;
	ss = _T("A");
	CSize size = dc->GetTextExtent( ss );
	dc->SelectObject(pOldFont);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	int w;
//	w = rc.Width() - m_ScrollBarHeight;
	w = rc.Width();
	m_LineCharNum =  w / fw - 3;	// 1s̕\(pZ)
	m_PageLineNum = rc.Height() / fh;	// 1y[W̕\s

	CheckAutoCharCode();

	CmdKeyNumber(0);

	SetScrollData();

	ReleaseDC(dc);
}

void CannsViewEx::DrawHexMode(void)
{
	CClientDC dc(this);

	//	if ( m_FileSize == 0 ) return;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "W";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	COLORREF colview = m_pFmParam->m_colViewText;

	dc.SetBkColor(m_colBack);

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colViewRetMark);
	CPen* pOldPen = dc.SelectObject(&pen);

	int x, y;
	UINT line = 0;
	unsigned char *cc, *cc2;

	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];

	CStringA s, sLine, form, s0, s8, s07, s8f, s16b;
	int nAdd = 0;
	int adstep = 16;
	//	m_MaxLineHexMode = (UINT)(m_FileSize / adstep) + 1;
	ULONGLONG nData = 0;

	form = "%08x  %-24s- %-24s |  %-16s  |";

	x = m_OfsetLeft;
	y = 0;

	dc.SetTextColor(colview);

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLineHexMode) break;

		//		cc = m_pcFile + m_pLinePoint[line];
		cc = m_pcFile + (line * adstep);
		cc2 = cc;
		int nl = adstep;
		memcpy(cbuf, "                ", nl);
		cbuf[nl] = 0;

		nAdd = line * adstep;
		nData = line * adstep;

		s07 = "";
		for (int i = 0; i < 8; i++) {
			if (nData == m_FileSize) break;
			s0.Format("%02x ", (int)*cc2);
			s07 += s0;
			cbuf[i] = *cc2;
			if (*cc2 < 0x20) cbuf[i] = '.';
			cc2++;
			nData++;
		}

		cc2 = cc + 8;
		s8f = _T("");
		for (int i = 8; i < 16; i++) {
			if (nData == m_FileSize) break;
			s8.Format("%02x ", (int)*cc2);
			s8f += s8;
			cbuf[i] = *cc2;
			int cn = (int)*cc2;
			if (cn < 0x20) {
				cbuf[i] = '.';
			}
			cc2++;
			nData++;
		}

		if (m_FileSize < 17L) {
			nl = (int)m_FileSize;
		}

		cbuf[nl] = 0;
		s16b.Format("%s", cbuf);
		sLine.Format(form, nAdd, s07, s8f, s16b);

		TextOutA(dc.m_hDC, x, y, (LPCSTR)sLine, sLine.GetLength());
		nAdd += adstep;
		//		cc += adstep;
		y += fh;

	}

	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = (int)(m_MaxLineHexMode / m_PageLineNum);
	if (maxpage > 0) {
		//		m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
}

// t}`oCg
// sSrc : 镶(s)
// sFindStr : 镶
// nStart : Jnʒu(s̐擪ɌČ) -1̏ꍇ͍s̍Ōォ
// ߂l : ꍇA擪̕ʒu  Ȃꍇ-1
int CannsViewEx::FindStrReversA(CStringA sSrc, CStringA sFindStr, int nStart)
{
	int ret = -1;	// Ȃꍇ-1Ԃ
	CStringA ssr, ssr2;
	int start = nStart;
	int fslen = sFindStr.GetLength() - 1;


	if ( nStart == 0 ) return ret;	// Jnʒus̐擪Ȃ-1Ԃ
	int slen = sSrc.GetLength();
	if ( slen == 0 ) return ret;	// ̒0Ȃ-1Ԃ
	if ( nStart == -1 ) start = slen;

	ssr = sSrc.Left(start + fslen);	// ʒuO̕𒊏o
	int nf = ssr.Find(sFindStr);
	if ( nf < 0 ) return ret;	// ܂܂ĂȂ-1Ԃ

	ret = nf;	// ̂Ŗ߂l͂̎_Ő擪̌vʒu

	int nf2 = nf + 1;	// vʒu̎̕Č


	while ( nf2 < slen ) {
		int nf3 = ssr.Find(sFindStr, nf2);
		if ( nf3 < 0 ) break;	// Ȃbreak
		ret = nf3;
		nf2 = nf3 + 1;
	
	}

	return ret;

}

// tCh
// sSrc : 镶(s)
// sFindStr : 镶
// nStart : Jnʒu(s̐擪ɌČ) -1̏ꍇ͍s̍Ōォ
// ߂l : ꍇA擪̕ʒu  Ȃꍇ-1
int CannsViewEx::FindStrReversW(CString sSrc, CString sFindStr, int nStart)
{
	int ret = -1;	// Ȃꍇ-1Ԃ
	CString ssr, ssr2;
	int start = nStart;
	int fslen = sFindStr.GetLength() - 1;


	if ( nStart == 0 ) return ret;	// Jnʒus̐擪Ȃ-1Ԃ
	int slen = sSrc.GetLength();
	if ( slen == 0 ) return ret;	// ̒0Ȃ-1Ԃ
	if ( nStart == -1 ) start = slen;

	ssr = sSrc.Left(start + fslen);	// ʒuO̕𒊏o
	int nf = ssr.Find(sFindStr);
	if ( nf < 0 ) return ret;	// ܂܂ĂȂ-1Ԃ

	ret = nf;	// ̂Ŗ߂l͂̎_Ő擪̌vʒu

	int nf2 = nf + 1;	// vʒu̎̕Č


	while ( nf2 < slen ) {
		int nf3 = ssr.Find(sFindStr, nf2);
		if ( nf3 < 0 ) break;	// Ȃbreak
		ret = nf3;
		nf2 = nf3 + 1;
	
	}

	return ret;

}

// ̌
// fmode -2:݈ʒu  -1:  0:  1:݈ʒu牺
// nocaps true:啶ʂ
// 񂪌ꍇtrueԂ
bool CannsViewEx::FindString(int fmode, bool nocaps)
{
	CClientDC dc(this);

	if ( m_FileSize == 0 ) return false;

	if ( m_bHexMode ) {
		return false;
	}
//	UINT line = 0;
	unsigned char *cc, *cc2;
	unsigned char c0, ctmp;

	UINT jcode, sjcode;
	int clen;
	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE];

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A;
	CStringA sSP = "  ";
	sA2.Format("%c", 0x09);

	CString sFind1, sFind2;
	CString sW, sW2;
	CString sSPW = _T("  ");
	sW2.Format(_T("%c"), 0x09);

	while ( ntab != 0 ) {
		sSP += " ";
		sSPW += _T(" ");
		ntab--;
	}

	int nStartLine;
	int nStep;
	int nEndLine;
	int nStartCharNo;

	if ( fmode == 0 ) {	// 
		nStartLine = 0;	// Jns
		nEndLine = m_MaxLine;	// Is(ŏIs+1)
		nStep = 1;	// s
		nStartCharNo = 0;	// Jnʒu(Jns̐擪̕) Ȃ̂0
	}
	if ( fmode == 1 ) {	// ݈ʒu牺
		nStep = 1;	// s
		nStartLine = m_nFindLineNo;
		nEndLine = m_MaxLine;	// Is(ŏIs+1)
		nStartCharNo = m_nFindCharNo + 1;	// Jnʒu(Jns̐擪̕) ݈ʒu+1
	}
	if ( fmode == -1 ) {	// 
		nStartLine = m_MaxLine - 1;
		nStep = -1;	// s
		nEndLine = -1;	//  Is(擪s-1)
		nStartCharNo = -1;	// Jnʒu(Jns̐擪̕)
							// Ȃ̂ł̍s̍ŏIʒu(FindStrReversŕ̒ݒ)
	}
	if ( fmode == -2 ) {	// ݈ʒu
		nStartLine = m_nFindLineNo;
		nStep = -1;	// s
		nEndLine = -1;	//  Is(擪s-1)
		nStartCharNo = m_nFindCharNo;	// Jnʒu(Jns̐擪̕) ݈ʒu
	}


	bool bFind = false;


	for ( int i = nStartLine; i != nEndLine; i += nStep ) {

		if ( fmode == 1 ) {	// ݈ʒu牺
			if ( i != nStartLine ) nStartCharNo = 0;	// JnsȊO͍s̐擪
		}
		if ( fmode == -2 ) {	// ݈ʒu
			if ( i != nStartLine ) nStartCharNo = -1;	// JnsȊO͍s̍ŏIʒu
		}


		if ( m_CharCode == CC_UNICODE ) {

			cc2 = m_pcFile + m_pLinePoint[i];
			int sl = m_pLinePoint[i + 1] - m_pLinePoint[i];
			memcpy(cbuf, cc2, sl);
			cbuf[sl] = 0;
			cbuf[sl + 1] = 0;

			unsigned char *dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
//			ReplaceTab(cbuf, dbuf, sl);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete []dbuf;

			sl = sW.GetLength();

			if ( m_pCharLine[i] != 0 ) {

				sFind1 = m_sFindString;
				if ( !nocaps ) {
					sFind1.MakeUpper();
					sW.MakeUpper();
				}

				int nf;
				if ( fmode < 0 ) {
					nf = FindStrReversW(sW, sFind1, nStartCharNo);
				} else {
					nf = sW.Find(sFind1, nStartCharNo);
				}
				if ( nf < 0 ) continue;


				m_nFindLineNo = i;
				m_nFindCharNo = nf;
				bFind = true;
				break;


			}
		}


	}

	delete []cbuf;
	delete []wcbuf;

	return bFind;
}


void CannsViewEx::OnKeyF()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyFind();
}

void CannsViewEx::OnKeyV()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyFindNext();
}

void CannsViewEx::OnKeyT()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyFindPrev();
}

void CannsViewEx::OnMenuKeyE()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftEnter();
}

void CannsViewEx::CmdKeyCtrlA(void)
{
	int nf = m_FirstLine;
	m_FirstLine = 0;
	int last = m_MaxLine - m_PageLineNum;
	if (last < 0) last = 0;

	m_bNowSelect = true;

	Invalidate();


	m_ptSel.x = 0;
	m_ptSel.y = 0;

	GetSelectPoint(m_ptSel);

	m_nSelStartCs = m_nSelCharBs;
	m_nSelStartCe = m_nSelCharBe;
	m_nSelStartY = m_FirstLine + (m_ptSel.y / m_FontY);

	m_nSelStartNs = m_nSelCharCs;
	m_nSelStartNe = m_nSelCharCe;

	m_nSelStartNsT = m_nSelCharCsT;
	m_nSelStartNeT = m_nSelCharCeT;

	m_nSelStartDs = m_nSelCharDs;

	m_nUTF7WcFlagCs = m_nUTF7WcFlag;


	m_FirstLine = last;

	Invalidate();

	CRect rc;
	GetClientRect(&rc);

	m_ptSel.x = rc.right;
	m_ptSel.y = rc.bottom;

 	GetSelectPoint(m_ptSel);


	m_nSelEndCs = m_nSelCharBs;
	m_nSelEndCe = m_nSelCharBe;
	m_nSelEndY = m_FirstLine + (m_ptSel.y / m_FontY);

	m_nSelEndNs = m_nSelCharCs;
	m_nSelEndNe = m_nSelCharCe;

	m_nSelEndNsT = m_nSelCharCsT;
	m_nSelEndNeT = m_nSelCharCeT;

	m_nSelStartDe = m_nSelCharDs;

	m_nUTF7WcFlagCe = m_nUTF7WcFlag;

	if ((UINT)m_nSelEndY > (m_MaxLineNormalMode - 1)) m_nSelEndY = m_MaxLineNormalMode - 1;

	m_bNowSelect = false;
	m_bSelected = true;

	Invalidate();

	m_FirstLine = nf;
	Invalidate();

}

void CannsViewEx::CmdKeyCtrlC(bool clear)
{
	// TODO: ɃR}h nh R[hǉ܂B

	if (!m_bSelected) return;

	unsigned char *ccs = m_pcFile;

	int sy = m_pLinePoint[m_nSelStartY];
	int ey = m_pLinePoint[m_nSelEndY];

	int st = m_nSelStartCs;
	int en = m_nSelEndCe;

	if ( sy > ey ) {
		sy = m_pLinePoint[m_nSelEndY];
		ey = m_pLinePoint[m_nSelStartY];
		st = m_nSelEndCs;
		en = m_nSelStartCe;
	}
	if ( sy == ey ) {
		if ( st> en ) {
			st = m_nSelEndCs;
			en = m_nSelStartCe;
		}
	}

	int bs = sy + st;
	int be = ey + en;

	int len = be - bs + 1;
	ccs = &m_pcFile[bs];

	unsigned char *cbuf;
	cbuf = new unsigned char[len + 3];
	CStringA sA;

	memcpy(cbuf, ccs, len);
	cbuf[len] = 0;
	cbuf[len+1] = 0;
	sA.Format("%s", cbuf);
	CString sW;
	sW = CA2W(sA);

	if ( m_CharCode == CC_UNICODE ) {
		sW.Format(_T("%s"), (wchar_t*)cbuf);
	}


	wchar_t* wcbuf;
	wcbuf = new wchar_t[m_ReadFileSize];

	if (m_CharCode == CC_JIS) {
		bs = st;
		be = en;
		int bst = bs - 1;
		bool bwc = false;
		unsigned char uc;
		len = en - st;

		while (bst >= 0) {
			uc = m_pcFile[bst];
			if (uc == 0x1b) {
				uc = m_pcFile[bst + 1];
				if (uc == 0x24) {
					bwc = true;
				}
				break;
			}
			bst--;

		}
		bst = bs;
		int blen = len;
		int cn = 0;
		UINT jcode, sjcode;

		while (blen > 0) {
			uc = m_pcFile[bst];
			if (uc == 0x1b) {
				bst++;
				blen--;
				uc = m_pcFile[bst];
				if (uc == 0x24) {
					bwc = true;
				}
				else {
					bwc = false;
				}
				bst++;
				blen--;
				bst++;
				blen--;

			}
			if (bwc) {
				jcode = ((UINT)m_pcFile[bst] * 0x100);
				bst++;
				jcode += (UINT)m_pcFile[bst];
				sjcode = _mbcjistojms(jcode);
				cbuf[cn] = (unsigned char)((sjcode & 0xff00) / 0x100);
				cn++;
				cbuf[cn] = (unsigned char)(sjcode & 0xff);
				blen--;

			}
			else {
				cbuf[cn] = m_pcFile[bst];
			}
			bst++;
			cn++;
			blen--;
		}
		cbuf[cn] = '\0';
		sW = CA2W((LPCSTR)cbuf);
//		sW.Format(_T("%s"), cbuf);

	}

	delete[]wcbuf;

	delete[]cbuf;

	CString sW2;
	sW2 = _T("");

	DWORD nLen = 0;
	unsigned char *obuf;

	sA = "";

	if ( !clear ) {
		HGLOBAL hGlobal;

		if ( OpenClipboard() ) {

			hGlobal = GetClipboardData( CF_TEXT );
			if ( hGlobal != NULL ) {

//				LPTSTR pMem;
//				pMem = (LPTSTR)GlobalLock( hGlobal );
				unsigned char *pMem;
				pMem = (unsigned char*)GlobalLock( hGlobal );

				if ( pMem != NULL ) {
		 
					nLen = GlobalSize( hGlobal );
//					*(pMem + nLen) = 0x00;

					if ( nLen != 0 ) {
						obuf = new unsigned char[nLen+1];
//						memcpy(obuf, pMem, nLen);
						memcpy(obuf, pMem, nLen);
						obuf[nLen] = 0;
						sA.Format("%s", obuf);
						delete []obuf;
					}

					GlobalUnlock( hGlobal );
				 
				}
			}
			CloseClipboard();
		}
	}

	sW2 = CA2W(sA);
	sW2 += sW;
	sW = sW2;
	int sof = sizeof(wchar_t);
	int hsize = sW.GetLength() * sof;

	wchar_t *cwbuf, *pcb;
	cwbuf = new wchar_t[hsize + 2];
	pcb = cwbuf;

	memcpy(pcb, sW.GetBuffer(), hsize);
	pcb[hsize] = 0;
	pcb[hsize+1] = 0;

	HGLOBAL hg = (HGLOBAL)::GlobalAlloc(GHND | GMEM_SHARE, hsize + 2);
	if (hg == NULL) {
		delete []cwbuf;
        return;
	}

	PTSTR ptStr = (PTSTR)GlobalLock(hg);

	::memcpy(ptStr, cwbuf, hsize + 1);

	delete []cwbuf;

	GlobalUnlock(hg);


	if( !OpenClipboard() ) {
		return;
	}

	EmptyClipboard();
	SetClipboardData(CF_UNICODETEXT, hg);
	CloseClipboard();
}


void CannsViewEx::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_bHexMode) {
		return;
	}

	SetCapture();
	m_ptSel.x = point.x;
	m_ptSel.y = point.y;

	GetSelectPoint(point);

	m_nSelStartCs = m_nSelCharBs;
	m_nSelStartCe = m_nSelCharBe;
	m_nSelStartY = m_FirstLine + (point.y / m_FontY);

	m_nSelStartNs = m_nSelCharCs;
	m_nSelStartNe = m_nSelCharCe;

	m_nSelStartNsT = m_nSelCharCsT;
	m_nSelStartNeT = m_nSelCharCeT;
	
	m_nSelStartDs = m_nSelCharDs;

	m_nUTF7WcFlagCs = m_nUTF7WcFlag;

	if ( (UINT)m_nSelStartY > (m_MaxLineNormalMode - 1) ) m_nSelStartY = m_MaxLineNormalMode - 1;

	m_bNowSelect = true;


	CWnd::OnLButtonDown(nFlags, point);
}

void CannsViewEx::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_bHexMode) {
		return;
	}

	if ( m_bNowSelect ) {

		GetSelectPoint(point);

		int py = point.y;
		if ( py < 0 ) {
			py = 0;
		}

		m_bNowSelect = false;

		m_nSelEndCs = m_nSelCharBs;
		m_nSelEndCe = m_nSelCharBe;
		m_nSelEndY = m_FirstLine + (py / m_FontY);

		m_nSelEndNs = m_nSelCharCs;
		m_nSelEndNe = m_nSelCharCe;

		m_nSelEndNsT = m_nSelCharCsT;
		m_nSelEndNeT = m_nSelCharCeT;

		m_nSelStartDe = m_nSelCharDs;

		m_nUTF7WcFlagCe = m_nUTF7WcFlag;

		if ( (UINT)m_nSelEndY > (m_MaxLineNormalMode - 1) ) m_nSelEndY = m_MaxLineNormalMode - 1;

		if ( (m_ptSel.x == point.x) && (m_nSelStartY == m_nSelEndY) ) {
			m_bSelected = false;
		} else {
			m_bSelected = true;
		}
		ReleaseCapture();
		Invalidate();
	}

	CWnd::OnLButtonUp(nFlags, point);
}

void CannsViewEx::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_bHexMode) {
		return;
	}

	if ( m_bNowSelect ) {

		GetSelectPoint(point);

		int py = point.y;
		if ( py < 0 ) {
			py = 0;
		}
		int x = (point.x - m_OfsetLeft) / m_FontX;
		int y = m_FirstLine + (py / m_FontY);
		int yl = py / m_FontY;

		if ( (UINT)y > (m_MaxLineNormalMode - 1) ) y = m_MaxLineNormalMode - 1;

		if ( (UINT)yl > (m_MaxLineNormalMode - 1) ) yl = m_MaxLineNormalMode - 1;

		int yp = point.y;

		if ( m_MaxLine > (UINT)m_PageLineNum ) {
			if ( yp > m_nClientYw ) {
				UINT delta = 1;
				UINT last = m_FirstLine + delta + m_PageLineNum;
				if ( last > m_MaxLine ) {
					m_FirstLine = m_MaxLine  - m_PageLineNum;
				} else m_FirstLine += delta; 

			}

			if ( yp < 0 ) {
				UINT delta;
				delta = m_pFmParam->m_ViewDeltaLine;
				if ( m_FirstLine < delta ) {
					delta = m_FirstLine;
				}
				m_FirstLine -= delta; 
			}
//			Invalidate(FALSE);
		}

		m_nSelEndCs = m_nSelCharBs;
		m_nSelEndCe = m_nSelCharBe;

		m_nSelEndNs = m_nSelCharCs;
		m_nSelEndNe = m_nSelCharCe;

		m_nSelEndNsT = m_nSelCharCsT;
		m_nSelEndNeT = m_nSelCharCeT;

		m_nSelStartDe = m_nSelCharDs;

//		if ( (m_nSelStartCs != x) || (m_nSelStartY != y) ) {
			m_bSelected = true;

			m_nSelEndY = y;

			Invalidate();
//		}

	}

	CWnd::OnMouseMove(nFlags, point);
}

// NbNꂽʒuAobt@̕ʒu𓾂
// point:}EXŃNbNꂽʒu
// ߂l int NbNꂽʒũobt@̐擪̃oCg
void CannsViewEx::GetSelectPoint(CPoint point)
{

	int py = point.y;
	if ( py < 0 ) py = 0;

	int y = py / m_FontY;
	int nLine = m_FirstLine + y;	// NbNꂽs
	if ( (UINT)nLine > (m_MaxLineNormalMode - 1) ) nLine = m_MaxLineNormalMode - 1;

	int x = (point.x - m_OfsetLeft) / m_FontX;	// NbNꂽs̐擪̔pZʒu

	int nbufPos = m_pLinePoint[nLine];	// ݍs̃obt@ł̐擪oCgʒu

	unsigned char* pc;
	pc = &m_pcFile[nbufPos];

	int nc = 0;	// Tab܂ލs̐擪̕
//	int bc = 0;	// oCg(obt@̍s̐擪̃oCg)

	unsigned char c0, c1, ctmp;
	int ntab = m_pFmParam->m_ViewTabNum;
	int xMax = m_pLinePoint[nLine + 1] - m_pLinePoint[nLine];


	if ( m_CharCode == CC_SJIS || m_CharCode == CC_JIS || m_CharCode == CC_EUC ) {

		unsigned char* bp;
		bp = pc;
		m_nSelCharBs = 0;
		m_nSelCharBe = 0;
		m_nSelCharCs = 0;
		m_nSelCharCe = 0;
		m_nSelCharCsT = 0;
		m_nSelCharCeT = 0;
		bool fst = true;
		int ed = x;
		int tb = ntab;
		int dnc = 0;	// pZ̕\ʒu(Tab܂ލs̐擪̕\ʒu)
		int tdnc = 0;	// pZ̕\ʒu(Tab->SPϊȂ̍s̐擪̕\ʒu)

		unsigned char *dbuf = new unsigned char[MAXCHAR_LINE];

		for ( int n = 0; n < xMax; n++ ) {
			c0 = *bp;

			tb--;
			if ( c0 < 0x80 ) {
				m_nSelCharBe = n;
				if ( fst ) {
					m_nSelCharBs = n;
					m_nSelCharCs = dnc;
					m_nSelCharCe = dnc;

					m_nSelCharCsT = tdnc;
					m_nSelCharCeT = tdnc;
					if ( c0 == 0x09 ) {
						dnc += tb;
						tb = ntab;
						m_nSelCharCe = dnc;
					}
					if ( c0 == 0x0d ) {
						c0 = *(bp + 1);
						if ( c0 == 0x0a ) {
							bp++;
							n++;
							dnc++;
							tdnc++;
							m_nSelCharBe = n;
							m_nSelCharCe = dnc;
							m_nSelCharCeT = tdnc;
						}
					}
				} else {
					m_nSelCharBe = n;
					m_nSelCharCe = dnc;
					m_nSelCharCeT = tdnc;
					fst = true;
				}

			} else {
				if ( fst ) {
					m_nSelCharBs = n;
					m_nSelCharCs = dnc;
					m_nSelCharCsT = tdnc;
					fst = false;
				} else {
					m_nSelCharBe = n;
					m_nSelCharCe = dnc;
					m_nSelCharCeT = tdnc;
					fst = true;
				}

			}
			if ( tb == 0 ) tb = ntab;
			dnc++;
			tdnc++;
			if ( dnc > ed && fst ) break;

			bp++;
		}
		delete []dbuf;
	}
	
	if ( m_CharCode == CC_UNICODE ) {

		unsigned char* bp;
		bp = pc;
		m_nSelCharBs = 0;
		m_nSelCharBe = 0;
		int ed = x;
		int tb = ntab;
		int dnc = 0;	// pZ̕\ʒu(Tab܂ލs̐擪̕\ʒu)
		int nc = 0;


		for ( int n = 0; n < xMax; n += 2 ) {
			c0 = *bp;
			bp++;
			c1 = *bp;
			bp++;
			if ( m_Endian ) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}

			m_nSelCharBs = n;
			m_nSelCharBe = n + 1;

			m_nSelCharCs = nc;
			m_nSelCharCe = nc;

			tb--;
			if ( tb == 0 ) tb = ntab;

			if ( (c1 == 0) && (c0 < 0x80) ) {
				if ( c0 == 0x09 ) {
					dnc += tb;
					nc += tb;
					tb = ntab;
					m_nSelCharCe = nc;
				}
				dnc++;

				ctmp = c0;
				if ( c0 == 0x0d ) {
					ctmp = *bp;
					if ( m_Endian ) ctmp = *(bp + 1);
					if ( ctmp == 0x0a ) {
						m_nSelCharBe += 2;
						dnc++;
						bp += 2;
						nc++;
						m_nSelCharCe = nc;
					}
				} else {
				}
			} else {
				dnc += 2;
				tb--;
				if ( tb == 0 ) tb = ntab;
			}

			nc++;

			if ( dnc > ed ) {
				break;
			}
		}

	}

	return;
}




void CannsViewEx::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( m_bSelected ) {
		CMenu pRmenu;
		pRmenu.CreatePopupMenu();
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_CTRL_KEY_C ,_T("Rs[(&C)"));
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_SHIFT_KEY_C ,_T("ǉRs[(&A)"));
	/*
		if ( m_bLongNameMode) pRmenu.CheckMenuItem(ID_LONG_NAME_MODE, MF_CHECKED);
		else pRmenu.CheckMenuItem(ID_LONG_NAME_MODE, MF_UNCHECKED);

		CString fname;
		fname =  m_pFmParam->m_pw64FindData[m_pFileView->m_CurrentFileNo].name;
		if ( fname == _T("..") ) {
			pRmenu.EnableMenuItem(ID_KEY_N, MF_GRAYED);
			pRmenu.EnableMenuItem(ID_CTRL_KEY_T, MF_GRAYED);
		}
	*/
		ClientToScreen(&point);
		pRmenu.TrackPopupMenu(
			TPM_LEFTALIGN  |	//NbNXWj[̍ӂɂ
			TPM_RIGHTBUTTON,	//ENbNŃj[I\Ƃ
			point.x,point.y,	//j[̕\ʒu
			this            	//̃j[LEBhE
		);
		pRmenu.DestroyMenu();
	}

	CWnd::OnRButtonDown(nFlags, point);
}

void CannsViewEx::OnMenuCtrlKeyC()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyCtrlC();
}

void CannsViewEx::OnMenuShiftKeyC()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyCtrlC(false);
}

//void CannsViewEx::OnMButtonDblClk(UINT nFlags, CPoint point)
//{
//	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
//
//	CWnd::OnMButtonDblClk(nFlags, point);
//}

void CannsViewEx::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CmdKeyQuit();

//	CWnd::OnLButtonDblClk(nFlags, point);
}


void CannsViewEx::OnFilePrint()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CPrintInfo printInfo;
	ASSERT(printInfo.m_pPD != NULL);    // must be set
	CWinApp* pApp = AfxGetApp();
	if (pApp->DoPrintDialog(printInfo.m_pPD) != IDOK) return;       // do not print
  
	CDC dcPrint;
	dcPrint.Attach(printInfo.m_pPD->m_pd.hDC);  // attach printer dc
	dcPrint.m_bPrinting = TRUE;
  
	// Get the application title
	CString strTitle;
	strTitle.LoadString(AFX_IDS_APP_TITLE);
  
	// Initialise print document details
	DOCINFO di;
	::ZeroMemory (&di, sizeof(DOCINFO));
	di.cbSize = sizeof(DOCINFO);
	di.lpszDocName = strTitle;
  
	BOOL bPrinting = dcPrint.StartDoc(&di);
	BOOL bPage = TRUE;
/*
	CClientDC dc = CClientDC(this);
	int dx = dc.GetDeviceCaps(LOGPIXELSX);

	int px = dcPrint.GetDeviceCaps(LOGPIXELSX);

	int ratio = px / dx + 1;
*/
	int nPage = 0;

	while (bPrinting && bPage) {
		dcPrint.StartPage();
      // ̈ʒu1y[W̏o͂邽߂̃R[h
      // ׂẴy[Wo͂ bPage = FALSE ŏI

//		CString s;
//		s.Format(_T("[ %s ]"), _T(""));
//		dcPrint.TextOut(300, 200, s);

		bool ret = PrintOnePage(&dcPrint, nPage);
		if ( !ret ) bPage = false;
/*
		//p̃TCYisNZj߂
		int width = dcPrint.GetDeviceCaps(PHYSICALWIDTH);
		int height = dcPrint.GetDeviceCaps(PHYSICALHEIGHT);

		//ItZbg}CiX
		width = width - dcPrint.GetDeviceCaps(PHYSICALOFFSETX) * 2;
		height = height - dcPrint.GetDeviceCaps(PHYSICALOFFSETY) * 2;
*/

		nPage++;
		bPrinting = (BOOL)dcPrint.EndPage();
	}

	if (bPrinting) dcPrint.EndDoc();
	else dcPrint.AbortDoc();
  
	dcPrint.Detach();   // will be cleaned up by CPrintInfo destructor
}


// nPage : y[W 0`
bool CannsViewEx::PrintOnePage(CDC *dc, int nPage)
{

/*
	CString sss;
	sss.Format(_T("[ %s ]"), m_sFileName);
	dc->TextOut(300, 200, sss);
	return;
*/
	bool ret = true;

	if ( m_FileSize == 0 ) return false;
/*
	if ( m_bHexMode ) {
		DrawHexMode();
		return;
	}
*/
	CRect rc;
	GetClientRect(&rc);
	m_nClientYw = rc.bottom;

	int nWidthView = rc.right - rc.left;

//	CClientDC cdc = CClientDC(this);
	CDC* cdc = GetDC();
	int dx = cdc->GetDeviceCaps(LOGPIXELSX);
	int px = dc->GetDeviceCaps(LOGPIXELSX);

	// ̈̕ƍ
	int width = dc->GetDeviceCaps(PHYSICALWIDTH);
	int height = dc->GetDeviceCaps(PHYSICALHEIGHT);

	//ItZbg}CiX
//	width = width - (dc->GetDeviceCaps(PHYSICALOFFSETX) * 2);
	height = height - (dc->GetDeviceCaps(PHYSICALOFFSETY) * 2);

	int nwRatio = (width * 95) / nWidthView / 100;


	CFont font;
	CFont* pOldFont;
	int fw, fh;

	LOGFONT pfont;
	pfont = m_pFmParam->m_logfontView;
//	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	LONG h = pfont.lfHeight;
	LONG pfh = h * nwRatio;
	CString ss;
	ss.Format(_T("%s"), pfont.lfFaceName);
	if (  ss == _T("FixedSys") ) {
		pfh = -16 * nwRatio;
		pfont.lfWidth = 0;
	}
	pfont.lfHeight = pfh;
	font.CreateFontIndirect(&pfont);
	pOldFont = dc->SelectObject(&font);

	ss = "W";
	CSize size = dc->GetTextExtent( ss );

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;
	m_FontX = fw;
	m_FontY = fh;

	CString s, form;
	CSize sizew;

	int nPageLine = height / (20 - pfh);

/*
	COLORREF colview = m_pFmParam->m_colViewText;
	COLORREF colFindStr = m_pFmParam->m_colViewFindString;
	COLORREF colFindStrBack = m_pFmParam->m_colViewFindStringBack;

*/
	int x, y;
	UINT line = 0;
	unsigned char *cc;

	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE + 10];

	unsigned char *dbuf;
	unsigned char *cc2, c0, c1, ctmp;

	x = fw * 6;
	y = fh * 5;

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A, sA3, sA4;
	CString sW, sW2, sW3;

	int nFirstLine = nPage * nPageLine;

	for ( int i = 0; i < nPageLine; i++ ) {
		line = nFirstLine + i;
		if ( line == m_MaxLine ) {
			ret = false;
			break;
		}

		if ( m_CharCode == CC_UNICODE ) {

			cc2 = m_pcFile + m_pLinePoint[line];
			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			int orglen = sl;

			memcpy(cbuf, cc2, sl);
			cbuf[sl] = 0;
			cbuf[sl + 1] = 0;
			sl -= 2;
			c0 = cbuf[sl];
			c1 = cbuf[sl + 1];

			if ( m_Endian ) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}

			bool bCrLf = false;

			if ( (sl >= 0) && (c0 == 0x0a) && (c1 == 0) ) {
				cbuf[sl] = 0;
				cbuf[sl + 1] = 0;
				sl -= 2;
				c0 = cbuf[sl];
				c1 = cbuf[sl + 1];

				if ( m_Endian ) {
					ctmp = c0;
					c0 = c1;
					c1 = ctmp;
				}
				if ( (sl >= 0) && (c0 == 0x0d) && (c1 == 0) ) {
					cbuf[sl] = 0;
					cbuf[sl + 1] = 0;
					bCrLf = true;
				}
			} else {
				if ( (sl >= 0) && (c0 == 0x0d) && (c1 == 0) ) {
					cbuf[sl] = 0;
					cbuf[sl + 1] = 0;
					bCrLf = true;
				}
			}

			memcpy(cbuf, cc2, orglen);
			dbuf = new unsigned char[orglen * m_pFmParam->m_ViewTabNum + 1];
//			ReplaceTab(cbuf, dbuf, orglen);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete []dbuf;

			int lw = sW.GetLength();

			dc->TextOut(x, y, sW, lw);

			y += fh;
		}

	}

	delete []cbuf;
	delete []wcbuf;

	ReleaseDC(cdc);

	return ret;
}


void CannsViewEx::OnMenuViewCtrlKeyA()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlA();
}

void CannsViewEx::OnKeyCtrlV()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	m_pViewFrame->m_pwndFile->RunannsFMtextExe(m_sFullFileName);

}
