#pragma once

#include "FmParam.h"
#include "wincodec.h"
// #include "d2d1helper.h"

#define CC_SJIS	0
#define CC_JIS	1
#define CC_EUC	2
#define CC_UNICODE	3
#define CC_UTF7	4
#define CC_UTF8	5


#define MAX_LINE 0x2ffff

class CannsViewFrame;

// CannsView

class CannsView : public CWnd
{
	DECLARE_DYNAMIC(CannsView)

public:
	CannsView();
	virtual ~CannsView();

protected:
	DECLARE_MESSAGE_MAP()

public:

#ifndef _WINVER_XP
	ID2D1Factory *g_pD2DFactory;
	IDWriteFactory *g_pDWriteFactory;
	ID2D1HwndRenderTarget *g_pRenderTarget;
	IDWriteTextFormat *g_pTextFormat;
	ID2D1SolidColorBrush *g_pBackBrush;
	ID2D1SolidColorBrush *g_pTextBrush;
	ID2D1SolidColorBrush *g_pSelTextBrush;
	ID2D1SolidColorBrush *g_pSelBackBrush;

	ID2D1SolidColorBrush *g_pEnterBrush;
	D2D1_POINT_2F g_Point0;
	D2D1_POINT_2F g_Point1;
#endif

	UINT32 m_D2DcolBack;

#ifndef _WINVER_XP
	void d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush);
	void d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush);
	void d2d1DrawCrLf(int xr, int y);
	void d2d1DrawCr(int xr, int y);
	void d2d1DrawLf(int xr, int y);

	void CreateD2d1Resources();
	void DiscardD2d1Resources();

	HRESULT CreateDeviceIndependentResources();
	void DiscardDeviceIndependentResources();
	HRESULT CreateDeviceResources(void);
	void DiscardDeviceResources();
	void CreateTextFormat();
	void DiscardTextFormat();

	void OnPaintDirectWrite();
	void DrawHexModeDirectWrite(void);
#endif


public:
	CannsViewFrame* m_pViewFrame;	// eFrame
//	CScrollBar* m_pScrollBar;

	CFmParam* m_pFmParam;
	CString m_sFileName;	// ݕ\Ăt@C̃t@C
	CString m_sFullFileName;	// ݕ\Ăt@C̃tpX܂ރt@C

	CFile* m_pFile;	// t@CNX
	unsigned char* m_pcFileBuffer;	// t@Cǂݍݗpobt@
	unsigned char* m_pcFile;	// t@Cǂݍݗpobt@|C^


	ULONGLONG m_FileSize;	// \t@C̃TCY
	CFileStatus m_FileStatus;
	UINT* m_pLinePoint;	// es̊Jnʒu(m_pcFileobt@byteʒu)
	UINT* m_pCharLine;	// es̕(m_pLinePoint炱̕1s̕\)
	int* m_pUTF7LineFlag;	// UTF-7̊es̐擪oCg̏
							// -1:ASCII  0:2byte1bayte  1:2byte2byte
	UINT m_ReadFileSize;	// ǂݍ񂾃t@C̃TCY(؂̂Ăꂽꍇ܂ߍŏĨTCY)
	UINT m_OrgReadFileSize;	// ǂݍ񂾃t@Č̃TCY(UnicodeŐ؂̂ĂO)

	bool m_Endian;	// UnicodeEndian ture:Big Endian  false:Little Endian
	bool m_bBOM;	// Unicode / UTF-8 BOM

	int m_FontX;	// tHg̕
	int m_FontY;	// tHg̍

	CPoint m_ptSel;	// IJnNbNʒu
	int m_nSelStartY;	// IJns
	int m_nSelEndY;		// IIs

	int m_nSelStartCs;	// IJnʒu擪ʒu(obt@̍s擪̃oCg)
	int m_nSelEndCs;	// IIʒu擪ʒu(obt@̍s擪̃oCg)
	int m_nSelStartCe;	// IJnʒuIʒu(obt@̍s擪̃oCg)
	int m_nSelEndCe;	// IIʒuIʒu(obt@̍s擪̃oCg)

	int m_nSelStartNs;	// IJnʒu̍s̐擪̕Jnʒu(^u->SPϊ)
	int m_nSelEndNs;	// IIʒu̍s̐擪̕Iʒu(^u->SPϊ)
	int m_nSelStartNe;	// IJnʒu̍s̐擪̕Jnʒu(^u->SPϊ)
	int m_nSelEndNe;	// IIʒu̍s̐擪̕Iʒu(^u->SPϊ)

	int m_nSelStartNsT;	// IJnʒu̍s̐擪̕Jnʒu(^u->SPϊȂ)
	int m_nSelEndNsT;	// IIʒu̍s̐擪̕Iʒu(^u->SPϊȂ)
	int m_nSelStartNeT;	// IJnʒu̍s̐擪̕Jnʒu(^u->SPϊȂ)
	int m_nSelEndNeT;	// IIʒu̍s̐擪̕Iʒu(^u->SPϊȂ)

	int m_nSelStartDs;	// IJnʒu̍s̐擪̔pZʒu(^u->SPϊ)
	int m_nSelStartDe;	// IIʒu̍s̐擪̔pZʒu(^u->SPϊ)

	int m_nUTF7WcFlagCs;	// IJnʒu̕tO
	int m_nUTF7WcFlagCe;	// IIʒu̕tO

	bool m_bNowSelect;	// true:I
	bool m_bSelected;	// true:Iς ]\

	int m_nSelCharBs;	// GetSelectPoint()Ŏgp }EXʒú̕Aobt@ł̊Jnʒu(0`
	int m_nSelCharBe;	// GetSelectPoint()Ŏgp }EXʒú̕Aobt@ł̏Iʒu(0`
	// Shift JIS pȂ Bs = n, Be = n  SpȂ Bs = n, Be = n+1

	int m_nSelCharDs;	// GetSelectPoint()Ŏgp }EXʒú̕Aʏł̔pZJnʒu(0`
	int m_nSelCharDe;	// GetSelectPoint()Ŏgp }EXʒú̕Aʏł̔pZIʒu(0`

	int m_nSelCharCs;	// GetSelectPoint()Ŏgp }EXʒú̕AJnʒu̍s擪̕(0`
	int m_nSelCharCe;	// GetSelectPoint()Ŏgp }EXʒú̕AIʒu̍s擪̕(0`
	int m_nSelCharCsT;	// GetSelectPoint()Ŏgp }EXʒú̕A^u->Xy[XϊȂ̊Jnʒu̍s擪̕(0`
	int m_nSelCharCeT;	// GetSelectPoint()Ŏgp }EXʒú̕A^u->Xy[XϊȂ̏Iʒu̍s擪̕(0`

	int m_nUTF7WcFlag;	// GetSelectPoint()Ŏgp m_nSelCharBs  0:2byte1byte  1:2byte2byte -1:ASCII

	CStringA m_saSelectStr;	// I𕶎 SJIS
	CString m_sSelectStr;	// I𕶎 UNICODE

	int m_CurrentPage;	// ݂̕\y[W
	int m_ScrollBarHeight;	// XN[o[̍(ł͏cXN[o[Ȃ̂Ŏۂ͕)
	int m_LineCharNum;	// 1s̕\(pZ)
	int m_PageLineNum;	// 1y[W̕\s
	int m_OfsetLeft;	// \JnXʒuItZbg
	int m_CharCode;	// R[h  0:SJIS  1:JIS  2:EUC  3:Unicode  4:UTF-7  5:UTF-8
//	bool m_bUnicode;	// ʂUnicodȅꍇtrue
	int m_wSizeX;	// EBhẺ

	UINT m_MaxLine;	// ݕ\Ăt@C̍ős(݂̃EBhE)
	UINT m_MaxLineNormalMode;	// ʏ탂[h̍ős
	UINT m_MaxLineHexMode;	// 16i\[h̍ős

	UINT m_FirstLine;	// ݕ\Ăŏ̍s
//	UINT m_LastLine;	// ݕ\ĂŌ̍s
//	UINT m_CurrentDisplayPoint;	// ݂̕\Jn|Cg(m_pcFileobt@byteʒu)

	bool m_bHexMode;	// true:16i\[h

	int m_nFindStartLine;	// Jnsԍ
	int m_nFindLineNo;	// v̂sԍ  :-1
	int m_nFindCharNo;	// vs̈v̐擪̕(R[h)  :-1
	CString m_sFindString;	// 镶
	bool m_bCase;	//true: ő啶ʂ
//	ULONGLONG m_ullFindBytePos;	// t@C̐擪́Ǎ݂voCgʒu

	int m_nLineA;	// ReplaceTab() 1s̔pZ̕JEgB(UNICODEEnter\ʒuo)
	
	int m_nClientYw;	// `̈̍

	COLORREF m_colBack;	// wiF

	int ChangeLineJIStoSJIS(int nLine, unsigned char *dbuf);
	int ChangeLineEUCtoSJIS(int nLine, unsigned char *dbuf);
	int ChangeLineUTF8toWC(int nLine, wchar_t *wdbuf);
	int ChangeLineUTF7toWC(int nLine, wchar_t *wdbuf);

	bool CheckJISCode(int line);
	void ReplaceTab(unsigned char *strA, unsigned char *cbuf, int len);

	void SetScrollData(void);
	void CheckCharCode(void);
	void RunKeyCmd(UINT uCmdNo);
	void CalcLinePoint(void);

	void CmdKeyEnter(void);
	void CmdKeySpace(void);
	void CmdKeyEnd(void);
	void CmdKeyHome(void);
	void CmdKeyLeft(void);
	void CmdKeyRight(void);
	void CmdKeyUp(void);
	void CmdKeyDown(void);
	void CmdKeyPageUp(bool bHalf = true);
	void CmdKeyPageDown(bool bHalf = true);
	void CmdKeyNumber(UINT uCmdNo);
	void CmdKeyFind(void);
	void CmdKeyFindPrev(void);
	void CmdKeyFindNext(void);
	void CmdKeyQuit(void);
	
	void CmdKeyShiftEnter(void);

	void CmdKeyCtrlA(void);
	void CmdKeyCtrlC(bool clear = true);
	void CmdKeyCtrlVRunannsView();

	void CheckAutoCharCode(void);

	void DrawHexMode(void);
	int FindStrReversA(CStringA sSrc, CStringA sFindStr, int nStart);
	int FindStrReversW(CString sSrc, CString sFindStr, int nStart);

	bool FindString(int fmode, bool nocaps = false);

	void GetSelectPoint(CPoint point);
	bool PrintOnePage(CDC *dc, int nPage);

//	HRESULT GetWICFactory(IWICImagingFactory** factory);

	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnMenuKey3();
	afx_msg void OnMenuKey4();
	afx_msg void OnMenuKey5();
	afx_msg void OnMenuKey6();
	afx_msg void OnMenuKey7();
	afx_msg void OnMenuKey8();
	afx_msg void OnMenuKeyA();
	afx_msg void OnKeyF();
	afx_msg void OnKeyV();
	afx_msg void OnKeyT();
	afx_msg void OnMenuKeyE();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMenuCtrlKeyC();
	afx_msg void OnMenuShiftKeyC();
//	afx_msg void OnMButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);

	afx_msg void OnFilePrint();

	afx_msg void OnMenuViewCtrlKeyA();
	afx_msg void OnKeyCtrlV();
};


