// annsView.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "annsView.h"
#include "annsViewFrame.h"
#include "FileView.h"
#include "FindStringDialog.h"
#include "Langage.h"

#include <mbstring.h>

// CannsView

IMPLEMENT_DYNAMIC(CannsView, CWnd)

CannsView::CannsView()
{
//	m_pScrollBar = new CScrollBar;
	m_pLinePoint = new UINT[MAX_LINE];
	m_pCharLine = new UINT[MAX_LINE];
	m_pUTF7LineFlag = new int[MAX_LINE];

	m_pcFileBuffer = NULL;
	m_pcFile = NULL;
	m_pFile = NULL;

	m_sFullFileName = _T("");
	m_sFileName= _T("");
	m_ScrollBarHeight = SCROLLBARHEIGHT;

	m_CurrentPage = 0;
	m_PageLineNum = 0;
	m_MaxLine = 0;
	m_FirstLine = 0;
	m_LineCharNum = 0;
	m_OfsetLeft = 5;
	m_CharCode = CC_SJIS;
	m_Endian = false;
//	m_bUnicode = false;
	m_bHexMode = false;

	m_nFindStartLine = 0;
	m_nFindLineNo = -1;
	m_nFindCharNo = -1;
	m_sFindString = _T("");
	m_wSizeX = 0;

	m_bNowSelect = false;
	m_bSelected = false;

#ifndef _WINVER_XP

	g_pDWriteFactory = NULL;
	g_pD2DFactory = NULL;
	g_pTextFormat = NULL;

	g_pRenderTarget = NULL;
	g_pBackBrush = NULL;
	g_pTextBrush = NULL;
	g_pSelBackBrush = NULL;
	g_pSelTextBrush = NULL;
	g_pEnterBrush = NULL;

#endif


}

CannsView::~CannsView()
{


	delete []m_pUTF7LineFlag;
	delete []m_pCharLine;
	delete []m_pLinePoint;
//	delete m_pScrollBar;
	if ( m_pcFileBuffer != NULL ) delete []m_pcFileBuffer;
	if ( m_pFile != NULL ) delete m_pFile;

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		DiscardD2d1Resources();
#endif

	}

}

static BOOL CheckTitleannsFMtextExe(LPTSTR lpszTitle)
{
	BOOL bResult = FALSE;

	if (lpszTitle)
	{
		CString st;
		st.Format(_T("%s"), lpszTitle);
		int n = st.Find(_T(" - annsFMtext"));
		if (n > 0) {
			bResult = TRUE;

		}
	}

	return bResult;
}


// NŁA\Ă邷ׂĂannsFMTextExe񋓂B
BOOL CALLBACK EnumWindProcannsFMtextExe(HWND hWnd, LPARAM lParam)

{
	HWND FAR* lpHwnd;

	lpHwnd = (HWND FAR*)lParam;
	BOOL r = TRUE;


	int nNeedLength = GetWindowTextLength(hWnd);
	if (nNeedLength > 7 && nNeedLength < MAX_PATH + 7)
	{
		if (IsWindow(hWnd) && !IsIconic(hWnd) && IsWindowVisible(hWnd))
		{
			nNeedLength += 8;
			LPTSTR lpBuffer = new TCHAR[nNeedLength];
			ZeroMemory(lpBuffer, nNeedLength * sizeof(TCHAR));
			if (GetWindowText(hWnd, lpBuffer, nNeedLength))
			{
				if (CheckTitleannsFMtextExe(lpBuffer))
				{
					*lpHwnd = hWnd;
					r = FALSE;
				}
			}
			delete[] lpBuffer;
		}
	}

	return r;
}


BEGIN_MESSAGE_MAP(CannsView, CWnd)
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_MOUSEWHEEL()
	ON_COMMAND(ID_KEY_3, &CannsView::OnMenuKey3)
	ON_COMMAND(ID_KEY_4, &CannsView::OnMenuKey4)
	ON_COMMAND(ID_KEY_5, &CannsView::OnMenuKey5)
	ON_COMMAND(ID_KEY_6, &CannsView::OnMenuKey6)
	ON_COMMAND(ID_KEY_7, &CannsView::OnMenuKey7)
	ON_COMMAND(ID_KEY_8, &CannsView::OnMenuKey8)
	ON_COMMAND(ID_KEY_A, &CannsView::OnMenuKeyA)
	ON_COMMAND(ID_KEY_F, &CannsView::OnKeyF)
	ON_COMMAND(ID_KEY_V, &CannsView::OnKeyV)
	ON_COMMAND(ID_KEY_T, &CannsView::OnKeyT)
	ON_COMMAND(ID_KEY_E, &CannsView::OnMenuKeyE)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_CTRL_KEY_C, &CannsView::OnMenuCtrlKeyC)
	ON_COMMAND(ID_SHIFT_KEY_C, &CannsView::OnMenuShiftKeyC)
//	ON_WM_MBUTTONDBLCLK()
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_FILE_PRINT, &CannsView::OnFilePrint)

	ON_COMMAND(ID_VIEW_CTRL_KEY_A, &CannsView::OnMenuViewCtrlKeyA)
	ON_COMMAND(ID_KEY_CTRL_V, &CannsView::OnKeyCtrlV)
END_MESSAGE_MAP()



// CannsView bZ[W nh

#ifndef _WINVER_XP

void CannsView::CreateD2d1Resources()
{
	CreateDeviceIndependentResources();
	CreateTextFormat();
	CreateDeviceResources();
}

void CannsView::DiscardD2d1Resources()
{
	DiscardDeviceIndependentResources();
	DiscardTextFormat();
	DiscardDeviceResources();

}

HRESULT CannsView::CreateDeviceIndependentResources()
{
	HRESULT result = S_OK;

	D2D1CreateFactory(
		D2D1_FACTORY_TYPE_SINGLE_THREADED,
		&g_pD2DFactory);

	DWriteCreateFactory(
		DWRITE_FACTORY_TYPE_SHARED,
		__uuidof(g_pDWriteFactory),
		(IUnknown **)(&g_pDWriteFactory));


	return result;
}

void CannsView::DiscardDeviceIndependentResources()
{

	if (g_pDWriteFactory != NULL) {
		g_pDWriteFactory->Release();
		g_pDWriteFactory = NULL;

	}

	if (g_pD2DFactory != NULL) {
		g_pD2DFactory->Release();
		g_pD2DFactory = NULL;

	}


}

void CannsView::CreateTextFormat()
{

	if (g_pDWriteFactory == NULL) return;

	CClientDC dc(AfxGetMainWnd());
	int logpix = dc.GetDeviceCaps(LOGPIXELSY);

	CString fontname = m_pFmParam->m_logfontView.lfFaceName;
	int nPoint = -::MulDiv(m_pFmParam->m_logfontView.lfHeight, 72, logpix);

	FLOAT fs = logpix * (FLOAT)nPoint / 72;
	int ifs = (INT)(fs + 1.99) / 2;
	FLOAT dip = (FLOAT)(ifs * 2);

	int it = m_pFmParam->m_logfontView.lfItalic;

	DWRITE_FONT_STYLE st = DWRITE_FONT_STYLE_NORMAL;
	if (it != 0) st = DWRITE_FONT_STYLE_ITALIC;

	g_pDWriteFactory->CreateTextFormat(
		//		L"Verdana",
		fontname,
		NULL,
//		DWRITE_FONT_WEIGHT_NORMAL,
//		DWRITE_FONT_STYLE_NORMAL,
		(DWRITE_FONT_WEIGHT)(m_pFmParam->m_logfontView.lfWeight), // DWRITE_FONT_WEIGHT_NORMAL,
		st, // DWRITE_FONT_STYLE_NORMAL,
		DWRITE_FONT_STRETCH_NORMAL,
		//		50,	// tHgTCY
		dip,
		L"", //locale
		&g_pTextFormat);

	g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_LEADING);
	// g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_CENTER);
//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_NEAR);
//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_CENTER);

	m_FontY = (int)(g_pTextFormat->GetFontSize());

	CFont font;
	CFont* pOldFont;


	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);

	m_FontX = size.cx;
	m_FontY = size.cy + m_pFmParam->m_nViewLineSpace;

	dc.SelectObject(pOldFont);

}

void CannsView::DiscardTextFormat()
{
	if (g_pTextFormat == NULL) return;

	g_pTextFormat->Release();
	g_pTextFormat = NULL;

}


HRESULT CannsView::CreateDeviceResources(void)
{
	HRESULT hr = S_OK;

	if (g_pRenderTarget != NULL) {
		return hr;
	}

	RECT rc;
	GetClientRect(&rc);

	D2D1_SIZE_U size = D2D1::SizeU(
		rc.right - rc.left,
		rc.bottom - rc.top
		);

	// Create a Direct2D render target.
	g_pD2DFactory->CreateHwndRenderTarget(
		D2D1::RenderTargetProperties(),
		D2D1::HwndRenderTargetProperties(m_hWnd, size),
		&g_pRenderTarget
		);

	COLORREF colText = m_pFmParam->m_colViewText;
	COLORREF colBack = m_pFmParam->m_colViewBack;
	COLORREF colSelText = m_pFmParam->m_colViewFindString;
	COLORREF colSelBack = m_pFmParam->m_colViewFindStringBack;

	// Create a back brush.
	BYTE r, g, b;
	r = colBack & 0xff;
	g = (colBack >> 8) & 0xff;
	b = (colBack >> 16) & 0xff;

	UINT32 rgb;
	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pBackBrush
		);


	m_D2DcolBack = rgb;

	r = colText & 0xff;
	g = (colText >> 8) & 0xff;
	b = (colText >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pTextBrush);

	r = colSelText & 0xff;
	g = (colSelText >> 8) & 0xff;
	b = (colSelText >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pSelTextBrush);

	r = colSelBack & 0xff;
	g = (colSelBack >> 8) & 0xff;
	b = (colSelBack >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pSelBackBrush);

	r = m_pFmParam->m_colViewRetMark & 0xff;
	g = (m_pFmParam->m_colViewRetMark >> 8) & 0xff;
	b = (m_pFmParam->m_colViewRetMark >> 16) & 0xff;

	//	r = g = b = 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pEnterBrush);

	return hr;
}

void CannsView::DiscardDeviceResources()
{
	if (g_pRenderTarget != NULL) {
		g_pRenderTarget->Release();
		g_pRenderTarget = NULL;

	}

	if (g_pBackBrush != NULL) {
		g_pBackBrush->Release();
		g_pBackBrush = NULL;
	}

	if (g_pTextBrush != NULL) {
		g_pTextBrush->Release();
		g_pTextBrush = NULL;
	}

	if (g_pSelBackBrush != NULL) {
		g_pSelBackBrush->Release();
		g_pSelBackBrush = NULL;

	}

	if (g_pSelTextBrush != NULL) {
		g_pSelTextBrush->Release();
		g_pSelTextBrush = NULL;

	}

	if (g_pEnterBrush != NULL) {
		g_pEnterBrush->Release();
		g_pEnterBrush = NULL;
	}

}

void CannsView::d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = CA2W(strA);

	int len = sText.GetLength();
	int glen = strA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontY);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontX), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
//		D2D1::RectF(fX, fY, (FLOAT)rc.right, fY + lh),
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontX), fY + lh),
		brush
		);

}

void CannsView::d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = strW;

	CStringA sA;
	sA = CW2A(strW);

	int len = sText.GetLength();
	int glen = sA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontY);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + (glen * m_FontX), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontX), fY + lh),
		brush
		);

}

void CannsView::d2d1DrawCrLf(int xr, int y)
{

	int x0, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;

	int fw = m_FontX;
	int fh = m_FontY;

	FLOAT st = 1.4F;

	xd = 7;
	yd = 7;
	x0 = fw + (fw / 3);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 6 / xd;
	x3 = x0 * 8 / xd;
	y0 = fh * 1 / yd;
	y1 = fh * 2 / yd;
	y2 = fh * 3 / yd + 1;
	y3 = fh * 4 / yd;
	y4 = fh * 5 / yd;
	y5 = fh * 6 / yd;

	g_Point0.x = (FLOAT)(xr + x2);
	g_Point0.y = (FLOAT)(y + y0);
	g_Point1.x = (FLOAT)(xr + x3);
	g_Point1.y = (FLOAT)(y + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// ㍶E()


	g_Point0.x = (FLOAT)(xr + x3);
	g_Point0.y = (FLOAT)(y + y4);
//	g_Point0.y = (FLOAT)(y + y3);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// Eォ牺(c)


	g_Point1.x = (FLOAT)(xr + x1);
	g_Point1.y = (FLOAT)(y + y4);
//	g_Point1.y = (FLOAT)(y + y3);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// E獶()


	g_Point0.x = (FLOAT)(xr + x1);
	g_Point0.y = (FLOAT)(y + y5);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// 牺(c)


	g_Point1.x = (FLOAT)xr;
	g_Point1.y = (FLOAT)(y + y3);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// ΂ߍ(΂)


	g_Point0.x = (FLOAT)(xr + x1);
	g_Point0.y = (FLOAT)(y + y1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// ΂߉E(΂)


	g_Point1.x = (FLOAT)(xr + x1);
	g_Point1.y = (FLOAT)(y + y2);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// ォ牺(c)


	g_Point0.x = (FLOAT)(xr + x2);
	g_Point0.y = (FLOAT)(y + y2);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);	// 璆E()



	g_Point1.x = (FLOAT)(xr + x2);
	g_Point1.y = (FLOAT)(y + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);	// E(n_)(c)


}

void CannsView::d2d1DrawCr(int xr, int y)
{

	int x0, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;

	int fw = m_FontX;
	int fh = m_FontY;
	int xof = xr - 2;
	int yof = y;
	FLOAT st = 1.4F;

	xd = 7;
	yd = 7;
	x0 = fw + (fw / 2);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 5 / xd;
	x3 = x0 * 7 / xd;
	y0 = fh * 1 / yd;
	y1 = fh * 2 / yd;
	y2 = fh * 3 / yd + 1;
	y3 = fh * 4 / yd;
	y4 = fh * 5 / yd;
	y5 = fh * 6 / yd;


	g_Point0.x = (FLOAT)(xof + x2 - 1);
	g_Point0.y = (FLOAT)(yof + y4 - 1);
	g_Point1.x = (FLOAT)(xof + x1 - 1);
	g_Point1.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x1);
	g_Point0.y = (FLOAT)(yof + y5);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof);
	g_Point1.y = (FLOAT)(yof + y3);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x1);
	g_Point0.y = (FLOAT)(yof + y1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x1 - 1);
	g_Point1.y = (FLOAT)(yof + y2);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x2 - 1);
	g_Point0.y = (FLOAT)(yof + y2);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x2 - 1);
	g_Point1.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);


}

void CannsView::d2d1DrawLf(int xr, int y)
{

	int x0, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;

	int fw = m_FontX;
	int fh = m_FontY;

	int xof = xr - fw;
	int yof = y + (fh / 8);

	FLOAT st = 1.4F;


	xd = 8;
	yd = 8;
	x0 = fw + (fw / 2);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 5 / xd;
	x3 = x0 * 7 / xd;
	y0 = fh * 1 / yd;
	y1 = fh * 2 / yd;
	y2 = fh * 3 / yd + 1;
	y3 = fh * 4 / yd;
	y4 = fh * 5 / yd;
	y5 = fh * 6 / yd;

	g_Point0.x = (FLOAT)(xof + x2 + 1);
	g_Point0.y = (FLOAT)(yof + y0);
	g_Point1.x = (FLOAT)(xof + x3);
	g_Point1.y = (FLOAT)(yof + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x3);
	g_Point0.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x3 + 2);
	g_Point1.y = (FLOAT)(yof + y4 - 4);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

	g_Point0.x = (FLOAT)(xof + x3 - 1);
	g_Point0.y = (FLOAT)(yof + y4);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x2 - 2);
	g_Point1.y = (FLOAT)(yof + y4 - 4);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);


	g_Point0.x = (FLOAT)(xof + x2 + 1);
	g_Point0.y = (FLOAT)(yof + y4 - 1);
	g_pRenderTarget->DrawLine(g_Point1, g_Point0, g_pEnterBrush, st);

	g_Point1.x = (FLOAT)(xof + x2 + 1);
	g_Point1.y = (FLOAT)(yof + y0);
	g_pRenderTarget->DrawLine(g_Point0, g_Point1, g_pEnterBrush, st);

}


void CannsView::DrawHexModeDirectWrite(void)
{
	CClientDC dc(this);

	//	if ( m_FileSize == 0 ) return;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "A";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	//	COLORREF colview = m_pFmParam->m_colViewText;

	//	dc.SetBkColor(m_colBack);

	//	CPen pen(PS_SOLID, 0, m_pFmParam->m_colViewRetMark);
	//	CPen* pOldPen = dc.SelectObject(&pen);

	int x, y;
	UINT line = 0;
	unsigned char *cc, *cc2;

	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];

	CStringA s, sLine, form, s0, s8, s07, s8f, s16b;
	int nAdd = 0;
	int adstep = 16;
	//	m_MaxLineHexMode = (UINT)(m_FileSize / adstep) + 1;
	ULONGLONG nData = 0;

	form = "%08x  %-24s- %-24s |  %-16s  |";

	x = m_OfsetLeft;
	y = 0;

	//	dc.SetTextColor(colview);

	g_pRenderTarget->BeginDraw();

	g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolBack));

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLineHexMode) break;

		//		cc = m_pcFile + m_pLinePoint[line];
		cc = m_pcFile + (line * adstep);
		cc2 = cc;
		int nl = adstep;
		memcpy(cbuf, "                ", nl);
		cbuf[nl] = 0;

		nAdd = line * adstep;
		nData = line * adstep;

		s07 = "";
		for (int i = 0; i < 8; i++) {
			if (nData == m_FileSize) break;
			s0.Format("%02x ", (int)*cc2);
			s07 += s0;
			cbuf[i] = *cc2;
			if (*cc2 < 0x20) cbuf[i] = '.';
			cc2++;
			nData++;
		}

		cc2 = cc + 8;
		s8f = _T("");
		for (int i = 8; i < 16; i++) {
			if (nData == m_FileSize) break;
			s8.Format("%02x ", (int)*cc2);
			s8f += s8;
			cbuf[i] = *cc2;
			int cn = (int)*cc2;
			if (cn < 0x20) {
				cbuf[i] = '.';
			}
			cc2++;
			nData++;
		}

		if (m_FileSize < 17L) {
			nl = (int)m_FileSize;
		}

		cbuf[nl] = 0;
		s16b.Format("%s", cbuf);
		sLine.Format(form, nAdd, s07, s8f, s16b);

		//		TextOutA(dc.m_hDC, x, y, (LPCSTR)sLine, sLine.GetLength());

		d2d1DrawTextA(x, y, sLine, g_pTextBrush, g_pBackBrush);

		nAdd += adstep;
		//		cc += adstep;
		y += fh;

	}

	g_pRenderTarget->EndDraw();

	//	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = (int)(m_MaxLineHexMode / m_PageLineNum);
	if (maxpage > 0) {
		//		m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
}


void CannsView::OnPaintDirectWrite()
{
	CPaintDC dc(this); // device context for painting
					   // TODO: ɃbZ[W nh R[hǉ܂B
					   // `惁bZ[W CWnd::OnPaint() ĂяoȂłB

					   /*
					   if ( m_FileSize == 0 ) return;

					   if ( m_bHexMode ) {
					   DrawHexMode();
					   return;
					   }
					   */

	if (m_bHexMode) {
		DrawHexModeDirectWrite();
		return;
	}

	g_pRenderTarget->BeginDraw();

	g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolBack));

	//	m_pScrollBar->ShowScrollBar();

	CRect rc;
	GetClientRect(&rc);
	m_nClientYw = rc.bottom;

	m_saSelectStr = "";
	m_sSelectStr = _T("");
	CStringA saSelLine;
	CString sSelLine;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc.SelectObject(&font);

	//	int fw, fh;
	//	TEXTMETRIC tm;

	//	dc.GetTextMetrics(&tm);
	//	fw = m_FontX = tm.tmAveCharWidth;

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;
	m_FontX = fw;
	m_FontY = fh;

	CString s, form;
	CSize sizew;


	//	COLORREF colview = m_pFmParam->m_colViewText;
	//	COLORREF colFindStr = m_pFmParam->m_colViewFindString;
	//	COLORREF colFindStrBack = m_pFmParam->m_colViewFindStringBack;

	//	dc.SetBkColor(m_pFmParam->m_colBack);

	//	CPen pen(PS_SOLID, 0, m_pFmParam->m_colViewRetMark);
	//	CPen* pOldPen = dc.SelectObject(&pen);

	int x, y, xr;

	//	int x0, x, y, xr, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;
	UINT line = 0;
	wchar_t* pc;
	unsigned char *cc, *cc2, *ccs;
	unsigned char c0, c1, ctmp;

	//	UINT jcode, sjcode;
	int clen;
	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE + 10];

	unsigned char *dbuf;

	x = m_OfsetLeft;
	y = 0;
	xr = 0;

	/*
	xd = 10;
	yd = 10;
	x0 = fw + (fw / 2);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 5 / xd;
	x3 = x0 * 7 / xd;
	y0 = fh * 3 / yd;
	y1 = fh * 4 / yd;
	y2 = fh * 5 / yd + 1;
	y3 = fh * 6 / yd;
	y4 = fh * 7 / yd;
	y5 = fh * 8 / yd;
	*/

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A, sA3, sA4;
	CStringA sSP = "  ";
	sA2.Format("%c", 0x09);

	CString sW, sW2, sW3;
	CString sSPW = _T("  ");
	sW2.Format(_T("%c"), 0x09);

	while (ntab != 0) {
		sSP += " ";
		sSPW += _T(" ");
		ntab--;
	}

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLine) break;
		//		dc.SetTextColor(colview);
		//		dc.SetBkColor(m_colBack);

		if (m_CharCode == CC_SJIS) {
			cc = m_pcFile + m_pLinePoint[line];
			xr = x;
			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			memcpy(cbuf, cc, sl);
			cbuf[sl] = 0;
			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete[]dbuf;
			sl = sA.GetLength();

			CStringA sAorg = sA;
			CStringA stA = sA;

			//				stA.Replace("@", "NcdQ?k~");
			//				stA.Replace("@", "k");


			int sr = stA.Replace("\r\n", "@");
			if (sr == 0) {
				sr = stA.Replace("\r", " ");
				if (sr == 0) {
					sr = stA.Replace("\n", " ");
				}
			}
			int al = stA.GetLength();



			//				TextOutA(dc.m_hDC, x, y, (LPCSTR)stA, al);

			d2d1DrawTextA(x, y, stA, g_pTextBrush, g_pBackBrush);

			if (line == m_nFindLineNo) {	// v
				sFind1A = sA.Left(m_nFindCharNo);
				sFind2A = CW2A(m_sFindString);
				sW = CA2W(sFind1A);
				size = dc.GetTextExtent(sW);	// v̕\Jnʒu
				sFind1A = sA.Mid(m_nFindCharNo, sFind2A.GetLength());
				//					dc.SetTextColor(colFindStr);
				//					dc.SetBkColor(colFindStrBack);
				//					TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sFind1A, sFind1A.GetLength());

				d2d1DrawTextA(x + size.cx, y, sFind1A, g_pSelTextBrush, g_pSelBackBrush);

			}
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;
				int dXs = m_nSelStartCs;
				int dXe = m_nSelEndCe;

				int nXs = m_nSelStartNs;
				int nXe = m_nSelEndNe;

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;
					dXs = m_nSelEndCs;
					dXe = m_nSelStartCe;

					nXs = m_nSelEndNs;
					nXe = m_nSelStartNe;
				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndCs;
						dXe = m_nSelStartCe;

						nXs = m_nSelEndNs;
						nXe = m_nSelStartNe;
					}
				}


				if (line == sy) {
					ccs = cc;
					ccs += dXs;


					size.cx = 0;
					size.cy = 0;
					int len = dXs;
					if (len != 0) {
						memcpy(cbuf, cc, len);
						cbuf[len] = 0;

						dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
						ReplaceTab(cbuf, dbuf, len);
						sA.Format("%s", dbuf);
						delete[]dbuf;

						sW = CA2W(sA);
						size = dc.GetTextExtent(sW);

						int lx = sA.GetLength();
						size.cx = lx * m_FontX;

					}


					len = dXe + 1;
					if (ey > sy) {
						len = m_pLinePoint[line + 1] - m_pLinePoint[line];
					}
					memcpy(cbuf, cc, len);
					cbuf[len] = 0;
					if (len > 0) {
						if (cbuf[len - 1] == 0x0a) {
							cbuf[len - 1] = 0x20;
							if (cbuf[len - 2] == 0x0d && len > 1) cbuf[len - 2] = 0x20;
						}
						if (cbuf[len - 1] == 0x0d) cbuf[len - 1] = 0x20;
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sA.Format("%s", dbuf);
					delete[]dbuf;

					CStringA sA2;
					sA2 = sA;

					int la = sA.GetLength();
					int l = nXe - nXs + 1;
					if (ey > sy) {
						l = la - nXs + 1;
					}

					sA = sA2.Mid(nXs, l);


					len = sA.GetLength();
					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sA, len);

					d2d1DrawTextA(x + size.cx, y, sA, g_pSelTextBrush, g_pSelBackBrush);

				}

				if ((line > sy) && (line < ey)) {
					ccs = cc;
					int len = m_pLinePoint[line + 1] - m_pLinePoint[line];

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					if (len > 0) {
						if (cbuf[len - 1] == 0x0a) {
							cbuf[len - 1] = 0x20;
							if (cbuf[len - 2] == 0x0d && len > 1) cbuf[len - 2] = 0x20;
						}
						if (cbuf[len - 1] == 0x0d) cbuf[len - 1] = 0x20;
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sA.Format("%s", dbuf);
					delete[]dbuf;

					len = sA.GetLength();
					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOutA(dc.m_hDC, x, y, (LPCSTR)sA, len);

					d2d1DrawTextA(x, y, sA, g_pSelTextBrush, g_pSelBackBrush);

				}

				if ((line == ey) && (sy != ey)) {
					ccs = cc;
					int len = dXe + 1;

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					if (cbuf[len - 1] == 0x0a) {
						cbuf[len - 1] = 0x20;
						if (cbuf[len - 2] == 0x0d) cbuf[len - 2] = 0x20;
					}
					if (cbuf[len - 1] == 0x0d) cbuf[len - 1] = 0x20;

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sA.Format("%s", dbuf);
					delete[]dbuf;

					len = sA.GetLength();
					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOutA(dc.m_hDC, x, y, (LPCSTR)sA, len);

					d2d1DrawTextA(x, y, sA, g_pSelTextBrush, g_pSelBackBrush);

				}


			}
			sA = sAorg;
			sA.Replace("\r", "");
			sA.Replace("\n", "");
			int sla = sA.GetLength();
			xr = x + (sla * fw) + fw / 2;

			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {
				d2d1DrawCrLf(xr, y);

				/*
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
				*/
			}
			else {
				if (c1 == 0x0a) {

					d2d1DrawLf(xr, y);

					/*
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1 , y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1 , y + y4 - 1);
					dc.LineTo(xof + x2 + 1 , y + y0);
					*/

				}

			}
			if (c1 == 0x0d) {

				d2d1DrawCr(xr, y);

				/*
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
				*/

			}

			y += fh;
		}

		if (m_CharCode == CC_UNICODE) {

			cc2 = m_pcFile + m_pLinePoint[line];
			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			int orglen = sl;

			memcpy(cbuf, cc2, sl);
			cbuf[sl] = 0;
			cbuf[sl + 1] = 0;

			sl -= 2;
			c0 = cbuf[sl];
			c1 = cbuf[sl + 1];

			if (m_Endian) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}

			bool bCrLf = false;
			bool bCr = false;
			bool bLf = false;

			if ((sl >= 0) && (c0 == 0x0a) && (c1 == 0)) {
				//				cbuf[sl] = 0;
				//				cbuf[sl + 1] = 0;
				sl -= 2;
				c0 = cbuf[sl];
				c1 = cbuf[sl + 1];

				if (m_Endian) {
					ctmp = c0;
					c0 = c1;
					c1 = ctmp;
				}
				if ((sl >= 0) && (c0 == 0x0d) && (c1 == 0)) {
					//					cbuf[sl] = 0;
					//					cbuf[sl + 1] = 0;
					bCrLf = true;
				}
				else {
					bLf = true;
				}
			}
			else {
				if ((sl >= 0) && (c0 == 0x0d) && (c1 == 0)) {
					//					cbuf[sl] = 0;
					//					cbuf[sl + 1] = 0;
					//					bCrLf = true;
					bCr = true;
				}
			}

			dbuf = new unsigned char[orglen * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, orglen);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete[]dbuf;

			int lw = sW.GetLength();
			CString stW = sW;
			//			stW.Replace(_T("\r\n"), _T("  "));
			int sr = stW.Replace(_T("\r\n"), _T("  "));
			if (sr == 0) {
				sr = stW.Replace(_T("\r"), _T(" "));
				if (sr == 0) {
					sr = stW.Replace(_T("\n"), _T(" "));
				}
			}

			int linea = m_nLineA;


			pc = (wchar_t*)(m_pcFile + m_pLinePoint[line]);
			xr = x;
			//			if ( m_pCharLine[line] != 0 ) {

			//			dc.TextOut(x, y, stW, lw);

			d2d1DrawTextW(x, y, stW, g_pTextBrush, g_pBackBrush);

			size = dc.GetTextExtent(sW);
			int linelen = size.cx;

			if (line == m_nFindLineNo) {	// v
				sW3 = sW.Left(m_nFindCharNo);
				size = dc.GetTextExtent(sW3);	// v̕\Jnʒu
				sW3 = sW.Mid(m_nFindCharNo, m_sFindString.GetLength());
				//					dc.SetTextColor(colFindStr);
				//					dc.SetBkColor(colFindStrBack);

				//					dc.TextOut(x + size.cx, y, sW3, sW3.GetLength());

				d2d1DrawTextW(x + size.cx, y, sW3, g_pSelTextBrush, g_pSelBackBrush);

			}

			cc = m_pcFile + m_pLinePoint[line];
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;
				int dXs = m_nSelStartCs;
				int dXe = m_nSelEndCe;

				int nXs = m_nSelStartNs;
				int nXe = m_nSelEndNe;

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;
					dXs = m_nSelEndCs;
					dXe = m_nSelStartCe;

					nXs = m_nSelEndNs;
					nXe = m_nSelStartNe;
				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndCs;
						dXe = m_nSelStartCe;

						nXs = m_nSelEndNs;
						nXe = m_nSelStartNe;
					}
				}

				if (line == sy) {
					ccs = cc;
					ccs += dXs;

					int dlen = dXs;
					memcpy(cbuf, cc, dlen);
					cbuf[dlen] = 0;
					cbuf[dlen + 1] = 0;

					size.cx = 0;
					size.cy = 0;
					if (dlen > 0) {
						dbuf = new unsigned char[dlen * m_pFmParam->m_ViewTabNum + 2];
						ReplaceTab(cbuf, dbuf, dlen);
						sW.Format(_T("%s"), (wchar_t*)dbuf);
						delete[]dbuf;
						size = dc.GetTextExtent(sW);


						CStringA sa;
						sa = CW2A(sW);
						int lx = sa.GetLength();
						size.cx = lx * m_FontX;
					}


					int len = dXe + 1;

					if (ey > sy) {
						len = m_pLinePoint[line + 1] - m_pLinePoint[line];
					}

					memcpy(cbuf, cc, len);


					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}

						}

					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;

					CString sW2;
					sW2 = sW;

					int la = sW.GetLength();
					int l = nXe - nXs + 1;
					if (ey > sy) {
						l = la - nXs + 1;
					}

					sW = sW2.Mid(nXs, l);

					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOut(dc.m_hDC, x + size.cx, y, sW, sW.GetLength());

					d2d1DrawTextW(x + size.cx, y, sW, g_pSelTextBrush, g_pSelBackBrush);

				}

				if ((line > sy) && (line < ey)) {
					ccs = cc;
					int len = m_pLinePoint[line + 1] - m_pLinePoint[line];

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}
						}
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;

					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOut(dc.m_hDC, x, y, sW, sW.GetLength());

					d2d1DrawTextW(x, y, sW, g_pSelTextBrush, g_pSelBackBrush);
				}

				if ((line == ey) && (sy != ey)) {
					ccs = cc;
					int len = dXe + 1;

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}
						}
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;


					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOut(dc.m_hDC, x, y, sW, sW.GetLength());

					d2d1DrawTextW(x, y, sW, g_pSelTextBrush, g_pSelBackBrush);

				}


			}

			xr = x + (linea * fw) + fw / 2;
			//			}
			if (bCrLf) {

				d2d1DrawCrLf(xr, y);

				/*
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
				*/

			}
			else {
				if (bLf) {

					d2d1DrawLf(xr, y);

					/*
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
					*/

				}

			}
			if (bCr) {

				d2d1DrawCr(xr, y);

				/*
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
				*/

			}


			y += fh;
		}

		if (m_CharCode == CC_JIS) {

			int sl = 0;

			xr = x;

			int blen = ChangeLineJIStoSJIS(line, cbuf);

			sA.Format("%s", cbuf);

			sl = sA.GetLength();
			CStringA sAorg = sA;

			saSelLine = sA;

			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete[]dbuf;

			sA.Replace("\r", " ");
			sA.Replace("\n", " ");
			/*
			int sr = sA.Replace("\r\n", "@");
			if (sr == 0) {
			sr = sA.Replace("\r", " ");
			if (sr == 0) {
			sr = sA.Replace("\n", " ");
			}
			}
			*/

			sl = sA.GetLength();

			//			TextOutA(dc.m_hDC, x, y, sA, sl);

			d2d1DrawTextA(x, y, sA, g_pTextBrush, g_pBackBrush);

			int dXs = 0;
			int dXe = 0;
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;
				dXs = m_nSelStartNs;
				dXe = m_nSelEndNe;

				int nXs = m_nSelStartNsT;
				int nXe = m_nSelEndNeT;

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;
					dXs = m_nSelEndNs;
					dXe = m_nSelStartNe;

					nXs = m_nSelEndNsT;
					nXe = m_nSelStartNeT;
				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

					}
					if (nXs > nXe) {
						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;
					}
				}


				if (line == sy) {
					int dl = dXe - dXs + 1;
					if (ey > sy) dl = sA.GetLength() - dXs + 1;
					sA3 = sA.Mid(dXs, dl);

					int tdl = nXe - nXs + 1;
					if (ey > sy) tdl = saSelLine.GetLength() - nXs + 1;
					m_saSelectStr += saSelLine.Mid(nXs, tdl);

					int dsl = sA3.GetLength();

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					//					dc.SetTextColor(colFindStr);
					//					dc.SetBkColor(colFindStrBack);

					//					TextOutA(dc.m_hDC, x + (dXs * m_FontX), y, sA3, dsl);

					d2d1DrawTextA(x + (dXs * m_FontX), y, sA3, g_pSelTextBrush, g_pSelBackBrush);

				}

				if ((line > sy) && (line < ey)) {
					sA3 = sA;

					m_saSelectStr += saSelLine;

					int dsl = sA3.GetLength();

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					//					dc.SetTextColor(colFindStr);
					//					dc.SetBkColor(colFindStrBack);

					//					TextOutA(dc.m_hDC, x , y, sA3, dsl);

					d2d1DrawTextA(x, y, sA3, g_pSelTextBrush, g_pSelBackBrush);

				}

				if (line == ey && sy != ey) {
					int dl = dXe + 1;
					sA3 = sA.Left(dl);

					int tdl = nXe + 1;
					m_saSelectStr += saSelLine.Left(tdl);

					int dsl = sA3.GetLength();

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					//					dc.SetTextColor(colFindStr);
					//					dc.SetBkColor(colFindStrBack);

					//					TextOutA(dc.m_hDC, x , y, sA3, dsl);

					d2d1DrawTextA(x, y, sA3, g_pSelTextBrush, g_pSelBackBrush);
				}
			}


			if (line == m_nFindLineNo) {	// v
				sFind1A = sA.Left(m_nFindCharNo);
				sFind2A = CW2A(m_sFindString);
				sW = CA2W(sFind1A);
				size = dc.GetTextExtent(sW);	// v̕\Jnʒu
				sFind1A = sA.Mid(m_nFindCharNo, sFind2A.GetLength());
				//				dc.SetTextColor(colFindStr);
				//				dc.SetBkColor(colFindStrBack);

				//				TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sFind1A, sFind1A.GetLength());

				d2d1DrawTextA(x + size.cx, y, sFind1A, g_pSelTextBrush, g_pSelBackBrush);

			}

			sA = sAorg;
			sA.Replace("\r", "");
			sA.Replace("\n", "");
			int sla = sA.GetLength();

			xr = x + (sla * fw) + fw / 2;
			//			xr = x + (sl * fw) + fw / 2;

			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {

				d2d1DrawCrLf(xr, y);

				/*
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
				*/

			}
			else {
				if (c1 == 0x0a) {

					d2d1DrawLf(xr, y);

					/*
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
					*/

				}

			}
			if (c1 == 0x0d) {

				d2d1DrawCr(xr, y);

				/*
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
				*/


			}


			y += fh;
		}

		if (m_CharCode == CC_EUC) {

			cc = m_pcFile + m_pLinePoint[line];
			xr = x;
			clen = m_pCharLine[line];
			//			if ( clen != 0 ) {

			int blen = ChangeLineEUCtoSJIS(line, cbuf);

			sA.Format("%s", cbuf);

			int sl = sA.GetLength();

			saSelLine = sA;
			CStringA sAorg;

			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete[]dbuf;

			sA.Replace("\r", " ");
			sA.Replace("\n", " ");

			sAorg = sA;

			/*
			int sr = sA.Replace("\r\n", "@");
			if (sr == 0) {
			sr = sA.Replace("\r", " ");
			if (sr == 0) {
			sr = sA.Replace("\n", " ");
			}
			}
			*/

			sl = sA.GetLength();

			//				TextOutA(dc.m_hDC, x, y, sA, sl);

			d2d1DrawTextA(x, y, sA, g_pTextBrush, g_pBackBrush);

			int dXs = 0;
			int dXe = 0;
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;

				dXs = m_nSelStartNs;
				dXe = m_nSelEndNe;

				int nXs = m_nSelStartNsT;
				int nXe = m_nSelEndNeT;

				/*
				dXs = m_nSelStartCs;
				dXe = m_nSelEndCe;

				int nXs = m_nSelStartNs;
				int nXe = m_nSelEndNe;
				*/

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;

					dXs = m_nSelEndNs;
					dXe = m_nSelStartNe;

					nXs = m_nSelEndNsT;
					nXe = m_nSelStartNeT;

					/*
					dXs = m_nSelEndCs;
					dXe = m_nSelStartCe;

					nXs = m_nSelEndNs;
					nXe = m_nSelStartNe;
					*/

				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;

						/*
						dXs = m_nSelEndCs;
						dXe = m_nSelStartCe;

						nXs = m_nSelEndNs;
						nXe = m_nSelStartNe;
						*/

					}
				}


				if (line == sy) {
					int dl = dXe - dXs + 1;
					if (ey > sy) dl = sA.GetLength() - dXs + 1;
					sA3 = sA.Mid(dXs, dl);
					int dsl = sA3.GetLength();

					int tdl = nXe - nXs + 1;
					if (ey > sy) tdl = saSelLine.GetLength() - nXs + 1;
					m_saSelectStr += saSelLine.Mid(nXs, tdl);

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOutA(dc.m_hDC, x + (dXs * m_FontX), y, sA3, dsl);

					d2d1DrawTextA(x + (dXs * m_FontX), y, sA3, g_pSelTextBrush, g_pSelBackBrush);

				}

				if ((line > sy) && (line < ey)) {
					sA3 = sA;
					int dsl = sA3.GetLength();

					m_saSelectStr += saSelLine;

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);
					TextOutA(dc.m_hDC, x, y, sA3, dsl);
				}

				if (line == ey && sy != ey) {
					int dl = dXe + 1;
					sA3 = sA.Left(dl);
					int dsl = sA3.GetLength();

					int tdl = nXe + 1;
					m_saSelectStr += saSelLine.Left(tdl);

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					//						dc.SetTextColor(colFindStr);
					//						dc.SetBkColor(colFindStrBack);

					//						TextOutA(dc.m_hDC, x , y, sA3, dsl);

					d2d1DrawTextA(x, y, sA3, g_pSelTextBrush, g_pSelBackBrush);

				}
			}



			if (line == m_nFindLineNo) {	// v
				sFind1A = sA.Left(m_nFindCharNo);
				sFind2A = CW2A(m_sFindString);
				sW = CA2W(sFind1A);
				size = dc.GetTextExtent(sW);	// v̕\Jnʒu
				sFind1A = sA.Mid(m_nFindCharNo, sFind2A.GetLength());
				//					dc.SetTextColor(colFindStr);
				//					dc.SetBkColor(colFindStrBack);

				//					TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sFind1A, sFind1A.GetLength());

				d2d1DrawTextA(x + size.cx, y, sFind1A, g_pSelTextBrush, g_pSelBackBrush);

			}
//			sAorg.Replace("\r", "");
//			sAorg.Replace("\n", "");
//			int sla = sAorg.GetLength();
			sl -= 2;
			xr = x + (sl * fw) + fw / 2;
//			xr = x + (sla * fw) + fw / 2;
			//			}
			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {

				d2d1DrawCrLf(xr, y);

				/*
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
				*/
			}
			else {
				if (c1 == 0x0a) {

					d2d1DrawLf(xr, y);

					/*
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
					*/

				}

			}
			if (c1 == 0x0d) {

				d2d1DrawCr(xr, y);

				/*
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
				*/

			}


			y += fh;
		}

		if (m_CharCode == CC_UTF8) {

			CString sWt;
			xr = x;
			int clen = m_pCharLine[line];
			if (clen >= 0) {

				int ib = ChangeLineUTF8toWC(line, wcbuf);

				sSelLine.Format(_T("%s"), wcbuf);

				int tlen = ib * 2;

				dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 2];
				ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
				sW.Format(_T("%s"), (wchar_t*)dbuf);
				delete[]dbuf;

				int sl = sWt.GetLength();
				clen = sl;

				sWt = sW;
				//				sWt.Replace(_T("\r\n"), _T("@"));
				/*
				int sr = sWt.Replace(_T("\r\n"), _T("  "));
				if (sr == 0) {
				sr = sWt.Replace(_T("\r"), _T(" "));
				if (sr == 0) {
				sr = sWt.Replace(_T("\n"), _T(" "));
				}
				}
				*/
				sWt.Replace(_T("\r"), _T(" "));
				sWt.Replace(_T("\n"), _T(" "));

				int al = sWt.GetLength();


				//				dc.TextOut(x, y, sWt, al);

				d2d1DrawTextW(x, y, sWt, g_pTextBrush, g_pBackBrush);



				int dXs = 0;
				int dXe = 0;
				if (m_bSelected) {
					UINT sy = m_nSelStartY;
					UINT ey = m_nSelEndY;
					dXs = m_nSelStartNs;
					dXe = m_nSelEndNe;

					int nXs = m_nSelStartNsT;
					int nXe = m_nSelEndNeT;

					int nDs = m_nSelStartDs;


					if (ey < sy) {
						sy = m_nSelEndY;
						ey = m_nSelStartY;
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;
						nDs = m_nSelStartDe;
					}

					if (sy == ey) {
						if (dXs > dXe) {
							dXs = m_nSelEndNs;
							dXe = m_nSelStartNe;

						}
						if (nXs > nXe) {
							nXs = m_nSelEndNsT;
							nXe = m_nSelStartNeT;
							nDs = m_nSelStartDe;
						}
					}

					CString sW3;

					if (line == sy) {
						int dl = dXe - dXs + 1;
						if (ey > sy) dl = sW.GetLength() - dXs + 1;
						sW3 = sW.Mid(dXs, dl);
						//						sW3.Replace(_T("\r\n"), _T("@"));
						/*
						sr = sW3.Replace(_T("\r\n"), _T("  "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\r"), _T(" "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\n"), _T(" "));
						}
						}
						*/
						sW3.Replace(_T("\r"), _T(" "));
						sW3.Replace(_T("\n"), _T(" "));

						int dsl = sW3.GetLength();

						int tdl = nXe - nXs + 1;
						if (ey > sy) tdl = sSelLine.GetLength() - nXs + 1;
						m_sSelectStr += sSelLine.Mid(nXs, tdl);

						int dx = nDs;

						//						dc.SetTextColor(colFindStr);
						//						dc.SetBkColor(colFindStrBack);

						//						TextOut(dc.m_hDC, x + (dx * m_FontX), y, sW3, dsl);

						d2d1DrawTextW(x + (dx * m_FontX), y, sW3, g_pSelTextBrush, g_pSelBackBrush);

					}

					if ((line > sy) && (line < ey)) {
						sW3 = sW;
						//						sW3.Replace(_T("\r\n"), _T("@"));
						/*
						sr = sW3.Replace(_T("\r\n"), _T("  "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\r"), _T(" "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\n"), _T(" "));
						}
						}
						*/
						sW3.Replace(_T("\r"), _T(" "));
						sW3.Replace(_T("\n"), _T(" "));

						int dsl = sW3.GetLength();

						m_sSelectStr += sSelLine;

						//						dc.SetTextColor(colFindStr);
						//						dc.SetBkColor(colFindStrBack);

						//						TextOut(dc.m_hDC, x , y, sW3, dsl);

						d2d1DrawTextW(x, y, sW3, g_pSelTextBrush, g_pSelBackBrush);

					}

					if (line == ey && sy != ey) {
						int dl = dXe + 1;
						sW3 = sW.Left(dl);
						//						sW3.Replace(_T("\r\n"), _T("@"));
						/*
						sr = sW3.Replace(_T("\r\n"), _T("  "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\r"), _T(" "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\n"), _T(" "));
						}
						}
						*/
						sW3.Replace(_T("\r"), _T(" "));
						sW3.Replace(_T("\n"), _T(" "));

						int dsl = sW3.GetLength();

						int tdl = nXe + 1;
						m_sSelectStr += sSelLine.Left(tdl);

						//						dc.SetTextColor(colFindStr);
						//					dc.SetBkColor(colFindStrBack);

						//						TextOut(dc.m_hDC, x , y, sW3, dsl);

						d2d1DrawTextW(x, y, sW3, g_pSelTextBrush, g_pSelBackBrush);

					}
				}

				if (line == m_nFindLineNo) {	// v
					sW3 = sW.Left(m_nFindCharNo);
					size = dc.GetTextExtent(sW3);	// v̕\Jnʒu
					sW3 = sW.Mid(m_nFindCharNo, m_sFindString.GetLength());
					//					dc.SetTextColor(colFindStr);
					//					dc.SetBkColor(colFindStrBack);

					//					dc.TextOut(x + size.cx, y, sW3, sW3.GetLength());

					d2d1DrawTextW(x + size.cx, y, sW3, g_pSelTextBrush, g_pSelBackBrush);


				}

			}

			sWt = sW;
			//			sWt.Replace(_T("\r\n"), _T(""));

			sWt.Replace(_T("\r"), _T(""));
			sWt.Replace(_T("\n"), _T(""));

			size = dc.GetTextExtent(sWt);
			xr = size.cx + fw;


			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {

				d2d1DrawCrLf(xr, y);

				/*
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
				*/

			}
			else {
				if (c1 == 0x0a) {

					d2d1DrawLf(xr, y);

					/*
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
					*/

				}

			}
			if (c1 == 0x0d) {

				d2d1DrawCr(xr, y);

				/*
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
				*/

			}


			y += fh;
		}

		if (m_CharCode == CC_UTF7) {

			CString sWt;
			xr = x;
			int clen = m_pCharLine[line];
			if (clen >= 0) {

				int ib = ChangeLineUTF7toWC(line, wcbuf);

				sSelLine.Format(_T("%s"), wcbuf);

				int tlen = ib * 2;
				//				int tlen = clen * 2;
				dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 2];
				ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
				sW.Format(_T("%s"), (wchar_t*)dbuf);
				delete[]dbuf;

				int sl = sW.GetLength();
				clen = sl;

				sWt = sW;
				//				sWt.Replace(_T("\r\n"), _T("@"));
				int sr = sWt.Replace(_T("\r\n"), _T("  "));
				if (sr == 0) {
					sr = sWt.Replace(_T("\r"), _T(" "));
					if (sr == 0) {
						sr = sWt.Replace(_T("\n"), _T(" "));
					}
				}

				int al = sWt.GetLength();

				//				dc.TextOut(x, y, sWt, al);

				d2d1DrawTextW(x, y, sWt, g_pTextBrush, g_pBackBrush);

				int dXs = 0;
				int dXe = 0;
				if (m_bSelected) {
					UINT sy = m_nSelStartY;
					UINT ey = m_nSelEndY;
					dXs = m_nSelStartNs;
					dXe = m_nSelEndNe;

					int nXs = m_nSelStartNsT;
					int nXe = m_nSelEndNeT;

					int nDs = m_nSelStartDs;

					if (ey < sy) {
						sy = m_nSelEndY;
						ey = m_nSelStartY;
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;

						nDs = m_nSelStartDe;
					}

					if (sy == ey) {
						if (dXs > dXe) {
							dXs = m_nSelEndNs;
							dXe = m_nSelStartNe;

						}
						if (nXs > nXe) {
							nXs = m_nSelEndNsT;
							nXe = m_nSelStartNeT;
							nDs = m_nSelStartDe;
						}
					}

					CString sW3;

					if (line == sy) {
						int dl = dXe - dXs + 1;
						if (ey > sy) dl = sW.GetLength() - dXs + 1;
						sW3 = sW.Mid(dXs, dl);
						sW3.Replace(_T("\r\n"), _T("@"));
						int dsl = sW3.GetLength();

						int tdl = nXe - nXs + 1;
						if (ey > sy) tdl = sSelLine.GetLength() - nXs + 1;
						m_sSelectStr += sSelLine.Mid(nXs, tdl);

						int dx = nDs;

						//						dc.SetTextColor(colFindStr);
						//						dc.SetBkColor(colFindStrBack);

						//						TextOut(dc.m_hDC, x + (dx * m_FontX), y, sW3, dsl);

						d2d1DrawTextW(x + (dx * m_FontX), y, sW3, g_pSelTextBrush, g_pSelBackBrush);

					}

					if ((line > sy) && (line < ey)) {
						sW3 = sW;
						sW3.Replace(_T("\r\n"), _T("@"));
						int dsl = sW3.GetLength();

						m_sSelectStr += sSelLine;

						//						dc.SetTextColor(colFindStr);
						//						dc.SetBkColor(colFindStrBack);

						//						TextOut(dc.m_hDC, x , y, sW3, dsl);

						d2d1DrawTextW(x, y, sW3, g_pSelTextBrush, g_pSelBackBrush);

					}

					if (line == ey && sy != ey) {
						int dl = dXe + 1;
						sW3 = sW.Left(dl);
						sW3.Replace(_T("\r\n"), _T("@"));
						int dsl = sW3.GetLength();

						int tdl = nXe + 1;
						m_sSelectStr += sSelLine.Left(tdl);

						//						dc.SetTextColor(colFindStr);
						//						dc.SetBkColor(colFindStrBack);

						//						TextOut(dc.m_hDC, x , y, sW3, dsl);

						d2d1DrawTextW(x, y, sW3, g_pSelTextBrush, g_pSelBackBrush);

					}
				}

				if (line == m_nFindLineNo) {	// v
					sW3 = sW.Left(m_nFindCharNo);
					size = dc.GetTextExtent(sW3);	// v̕\Jnʒu
					sW3 = sW.Mid(m_nFindCharNo, m_sFindString.GetLength());
					//					dc.SetTextColor(colFindStr);
					//					dc.SetBkColor(colFindStrBack);

					//					dc.TextOut(x + size.cx, y, sW3, sW3.GetLength());

					d2d1DrawTextW(x + size.cx, y, sW3, g_pSelTextBrush, g_pSelBackBrush);


				}

			}

			sWt = sW;
			//			sWt.Replace(_T("\r\n"), _T(""));
			sWt.Replace(_T("\r"), _T(""));
			sWt.Replace(_T("\n"), _T(""));
			size = dc.GetTextExtent(sWt);
			xr = size.cx + fw;


			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {

				d2d1DrawCrLf(xr, y);

				/*
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
				*/

			}
			else {
				if (c1 == 0x0a) {

					d2d1DrawLf(xr, y);

					/*
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
					*/

				}

			}
			if (c1 == 0x0d) {

				d2d1DrawCr(xr, y);

				/*
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
				*/

			}


			y += fh;


		}

	}

	g_pRenderTarget->EndDraw();

	//	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	//	SetScrollData();
	int maxpage;
	maxpage = m_MaxLine / m_PageLineNum;
	if (maxpage > 0) {
		//		m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
	delete[]wcbuf;



}

#endif

BOOL CannsView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (!(m_pFmParam->m_bViewDirectWrite)) {
		m_colBack = m_pFmParam->m_colViewBack;

		// uV̍쐬
		CBrush brush(m_colBack);
		// VuVw(̃uV̕ۑ)
		CBrush* pOldBrush = pDC->SelectObject(&brush);

//		CRect src;
//		m_pScrollBar->GetWindowRect(&src);

		// hԂ̈擾
		CRect rect;
		GetClientRect(&rect);
//		rect.right -= (src.right - src.left);

		// hԂ
		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

		// uVɖ߂
		pDC->SelectObject(pOldBrush);

	}
	/*
	m_colBack = m_pFmParam->m_colViewBack;

	// uV̍쐬
	CBrush brush(m_colBack);
    // VuVw(̃uV̕ۑ)
    CBrush* pOldBrush = pDC->SelectObject(&brush);

	CRect src;
	m_pScrollBar->GetWindowRect(&src);

    // hԂ̈擾
    CRect rect;
    GetClientRect(&rect);
	rect.right -= (src.right - src.left);

	// hԂ
    pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

	// uVɖ߂
    pDC->SelectObject(pOldBrush);
	*/

	return TRUE;

//	return CWnd::OnEraseBkgnd(pDC);
}

void CannsView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	short shift = GetKeyState(VK_SHIFT);
	short ctrl = GetKeyState(VK_CONTROL);

	UINT cmdno;
	if ( shift < 0 ) {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x300;
		} else {
			cmdno = nChar + 0x100;
		}
	} else {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x200;
		} else {
			cmdno = nChar;
		}
	}

	RunKeyCmd(cmdno);

//	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

// JISR[hŁAlines̐擪1byte2byte𒲂ׂ
// ߂l true:2byte  false:1byte
bool CannsView::CheckJISCode(int line)
{
	bool bwc = false;
	bool bend = false;
	unsigned char *cp;

	while ( !bend ) {
		if ( line == 0 ) break;

		cp = m_pcFile + m_pLinePoint[line - 1];
		int max = m_pLinePoint[line] - m_pLinePoint[line - 1];

		for ( int i = 0; i < max; i++ )  {
			unsigned char uc = *cp;

			if ( uc == 0x0a ) {
				bend = true;
				bwc = false;
			}

			if ( uc == 0x1b ) {
				cp++;
				i++;
				uc = *cp;
				if ( uc == 0x24 ) {
					bwc = true;
				}
				if ( uc == 0x28 ) {
					bwc = false;
				}
				cp++;
				i++;
				bend = true;

			}
			cp++;

		}
		line --;
	}

	return bwc;
}

void CannsView::ReplaceTab(unsigned char *strA, unsigned char *cbuf, int len)
{

	int ntab = m_pFmParam->m_ViewTabNum;
	int n = len;


	int ns = 0;
	int nd = 0;
	int tb = ntab;

	if ( m_CharCode == CC_SJIS || m_CharCode == CC_JIS || m_CharCode == CC_EUC ) {

		while ( n > 0 ) {
			unsigned char cs;
			cs = strA[ns];

			if ( cs < 0x80 ) {
				if ( cs == 0x09 ) {
					for ( int i = 0; i < tb; i++ ) {
						cbuf[nd] = ' ';
						nd++;
					}
					tb = ntab;
				} else {
					cbuf[nd] = cs;
					tb--;
					if ( tb == 0 ) tb = ntab;
					nd++;
				}
				ns++;
				n--;

			}else {
				cbuf[nd] = cs;
				ns++;
				nd++;
				n--;
				tb--;
				if ( tb == 0 ) tb = ntab;

				cs = strA[ns];
				cbuf[nd] = cs;
				ns++;
				nd++;
				n--;
				tb--;
				if ( tb == 0 ) tb = ntab;
			}

		}
		cbuf[nd] = 0;

	}

	if ( m_CharCode == CC_UNICODE || m_CharCode == CC_UTF8 || m_CharCode == CC_UTF7 ) {

		m_nLineA = 0;

		while ( n > 0 ) {
			unsigned char cs, cn;
			cs = strA[ns];
			ns++;
			cn = strA[ns];
			ns++;

			if ( cn == 0 ) {	// p

				if ( cs == 0x09 ) {
					for ( int i = 0; i < tb; i++ ) {
						cbuf[nd] = 0x20;
						nd++;
						cbuf[nd] = 0;
						nd++;
						m_nLineA++;
					}
					tb = ntab;
				} else {
					cbuf[nd] = cs;
					nd++;
					cbuf[nd] = cn;
					nd++;

					tb--;
					if ( tb == 0 ) tb = ntab;

					if ( cs != 0x0d && cs != 0x0a ) m_nLineA++;
				}

			}else {
				m_nLineA += 2;

				cbuf[nd] = cs;
				nd++;
				cbuf[nd] = cn;
				nd++;

				tb--;
				if ( tb == 0 ) tb = ntab;
				tb--;
				if ( tb == 0 ) tb = ntab;

			}
			n -= 2;

		}
		cbuf[nd] = 0;
		nd++;
		cbuf[nd] = 0;

	}

}

int CannsView::ChangeLineJIStoSJIS(int nLine, unsigned char *dbuf)
{
	int line = nLine;
	UINT jcode, sjcode;
	int ib = 0;

	unsigned char *cc = m_pcFile + m_pLinePoint[line];
	int clen = m_pCharLine[line];

	if ( clen != 0 ) {
		bool wc = false;
		if ( *cc == 0x1b ) {
			if ( *(cc + 1) == 0x24 ) wc = true;
		} else {
			wc = CheckJISCode(line);
		}

		while ( clen != 0 ) {

			if ( *cc == 0x1b ) {
				cc++;
				if ( *cc == 0x28 ) wc = false;
				else wc = true;
				cc += 2;
				continue;
			}


			if ( wc ) {	// 2byte
				jcode = ((UINT)(*cc) * 0x100);
				cc++;
				jcode += (UINT)(*cc);
				cc++;
				sjcode = _mbcjistojms(jcode);
				dbuf[ib] = (unsigned char)((sjcode & 0xff00) / 0x100);
				ib++;
				dbuf[ib] = (unsigned char)(sjcode & 0xff);
				ib++;

			} else {
				dbuf[ib] = *cc;
				cc++;
				ib++;
			}

			clen--;

		}
	}

	if (*cc == 0x1b) {
		cc++;
		if (*cc == 0x28) {
			cc += 2;
			if (*cc == 0x0d) {
				dbuf[ib] = *cc;
				ib++;
				cc++;
				if (*cc == 0x0a) {
					dbuf[ib] = *cc;
					ib++;
				}
			}
			else {
				if (*cc == 0x0a) {
					dbuf[ib] = *cc;
					ib++;
				}
			}

		}

	}
	else {
		if (*cc == 0x0d) {
			dbuf[ib] = *cc;
			ib++;
			cc++;
			if (*cc == 0x0a) {
				dbuf[ib] = *cc;
				ib++;
			}
		}
		else {
			if (*cc == 0x0a) {
				dbuf[ib] = *cc;
				ib++;
			}
		}
	}


	dbuf[ib] = 0;

	return ib;

}

int CannsView::ChangeLineEUCtoSJIS(int nLine, unsigned char *dbuf)
{

	int line = nLine;
	UINT jcode, sjcode;
	int ib = 0;
	unsigned char ctmp;

	unsigned char *cc = m_pcFile + m_pLinePoint[line];

	int clen = m_pCharLine[line];

	if ( clen >= 0 ) {

		UINT sy = m_nSelStartY;
		UINT ey = m_nSelEndY;
		int dXs = m_nSelStartCs;
		int dXe = m_nSelEndCe;

		while ( clen != 0 ) {
			bool wc = false;
			if ( *cc == 0x8e ) {
				cc++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				clen--;
				continue;
			}

			
			if ( *cc == 0x8f ) {
				cc++;
				wc = true;
			}

			if ( (*cc >= 0xa0) && (*cc <= 0xff) ) {
				wc = true;
			}


			if ( wc ) {	// 2byte
				ctmp = *cc & 0x7f;
				jcode = ((UINT)ctmp * 0x100);
				cc++;
				ctmp = *cc & 0x7f;
				jcode += (UINT)ctmp;
				cc++;
				sjcode = _mbcjistojms(jcode);
				dbuf[ib] = (unsigned char)((sjcode & 0xff00) / 0x100);
				ib++;
				dbuf[ib] = (unsigned char)(sjcode & 0xff);
				ib++;

			} else {
				dbuf[ib] = *cc;
				cc++;
				ib++;
			}

			clen--;

		}

	}

	if (*cc == 0x0d) {
		dbuf[ib] = *cc;
		cc++;
		ib++;
	}
	if (*cc == 0x0a) {
		dbuf[ib] = *cc;
		ib++;
	}

	dbuf[ib] = 0;

	return ib;

}


int CannsView::ChangeLineUTF8toWC(int nLine, wchar_t *wdbuf)
{

	int line = nLine;
	unsigned char *cc = m_pcFile + m_pLinePoint[line];
	int clen = m_pCharLine[line];
	int ib = 0;
	unsigned char c0;
	unsigned char *dbuf = new unsigned char[MAXCHAR_LINE];

//	if ( clen != 0 ) {


		while ( clen > 0 ) {

			c0 = *cc;
			dbuf[ib] = c0;

			if ( (c0 >= 0xc0) && (c0 <= 0xdf)) {	// 2byte
				cc++;
				ib++;
				dbuf[ib] = *cc;
			}

			if ( (c0 >= 0xe0) && (c0 <= 0xef)) {	// 3byte
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;

			}

			if ( (c0 >= 0xf0) && (c0 <= 0xf7)) {	// 4byte
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;

			}

			if ( (c0 >= 0xf8) && (c0 <= 0xfb)) {	// 5byte
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;

			}

			if ( (c0 >= 0xfc) && (c0 <= 0xfd)) {	// 6byte
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;
				cc++;
				ib++;
				dbuf[ib] = *cc;

			}
			cc++;
			ib++;

			clen--;
		}

		c0 = *cc;
		if ( c0 == 0x0d ) {
			dbuf[ib] = c0;
			cc++;
			ib++;
			/*
			c0 = *cc;
			if ( c0 == 0x0a ) {
				dbuf[ib] = c0;
				cc++;
				ib++;
			}
			*/
		}
		c0 = *cc;
		if (c0 == 0x0a) {
			dbuf[ib] = c0;
			cc++;
			ib++;
		}

//	}

	dbuf[ib] = 0;

	clen = MultiByteToWideChar(CP_UTF8, 0, (LPCSTR)dbuf, ib, wdbuf, 0);
	MultiByteToWideChar(CP_UTF8, 0, (LPCSTR)dbuf, ib, wdbuf, MAXCHAR_LINE);
	wdbuf[clen] = _T('\0');

	delete []dbuf;

	return clen;

}

int CannsView::ChangeLineUTF7toWC(int nLine, wchar_t *wdbuf)
{

	int line = nLine;
	int n = 5;
	int ib = n;
	unsigned char c0;
	unsigned char *dbuf = new unsigned char[MAXCHAR_LINE + 10];
	int nof = 0;

	unsigned char *cc = m_pcFile + m_pLinePoint[line];
	int clen = m_pLinePoint[line + 1] - m_pLinePoint[line];

	wdbuf[0] = 0;
	int len = 0;

	if ( clen != 0 ) {
		bool wc = false;
		while ( clen != 0 ) {	// dbuf[5]֓꒼
			c0 = *cc;
			dbuf[ib] = c0;
			cc++;
			ib++;

			clen--;
		}

		dbuf[ib] = 0;

//		clen = m_pLinePoint[line + 1] - m_pLinePoint[line];
//		clen = m_pCharLine[line];

		if ( m_pUTF7LineFlag[line] == 0 ) {	// s̐擪2byte1byteڂ̏ꍇA擪"+"ǉ
			if ( dbuf[5] != '-' ) {
				dbuf[4] = '+';
				n = 4;
				nof = 0;
			}
		}

		if ( m_pUTF7LineFlag[line] > 0 ) {	// s̐擪2byte2byteڂ̏ꍇA1byteڂcbuf̐擪ɓāA擪"+"ǉ
			cc = m_pcFile + m_pLinePoint[line];
			cc--;
			dbuf[4] = *cc;
			cc--;
			dbuf[3] = *cc;
			cc--;
			dbuf[2] = *cc;
			cc--;
			dbuf[1] = *cc;
			dbuf[0] = '+';
			n = 0;
			nof = 1;
		}


		len = ib - n;
		clen = MultiByteToWideChar(CP_UTF7, 0, (LPCSTR)&dbuf[n], len, wdbuf, 0);
		MultiByteToWideChar(CP_UTF7, 0, (LPCSTR)&dbuf[n], len, wdbuf, MAXCHAR_LINE);
		wdbuf[clen] = _T('\0');

	}

	delete []dbuf;

	CString sw;
	sw.Format(_T("%s"), wdbuf);

	if (m_pUTF7LineFlag[line] > 0) {	// s̐擪2byte2byteڂ̏ꍇ
		int len = (sw.GetLength() - 1) * 2;
		memcpy(wdbuf, sw.GetBuffer() + 1, len);
		clen--;
		wdbuf[clen] = _T('\0');
	}

	return clen;
}

void CannsView::OnPaint()
{

	if (m_FileSize == 0) return;

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		OnPaintDirectWrite();
#endif

		return;
	}

	if (m_bHexMode) {
		DrawHexMode();
		return;
	}

	CPaintDC dc(this); // device context for painting
					   // TODO: ɃbZ[W nh R[hǉ܂B
					   // `惁bZ[W CWnd::OnPaint() ĂяoȂłB

	CRect rc;
	GetClientRect(&rc);
	m_nClientYw = rc.bottom;

	m_saSelectStr = "";
	m_sSelectStr = _T("");
	CStringA saSelLine;
	CString sSelLine;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "W";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;
	m_FontX = fw;
	m_FontY = fh;

	CString s, form;
	CSize sizew;


	COLORREF colview = m_pFmParam->m_colViewText;
	COLORREF colFindStr = m_pFmParam->m_colViewFindString;
	COLORREF colFindStrBack = m_pFmParam->m_colViewFindStringBack;

	//	dc.SetBkColor(m_pFmParam->m_colBack);

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colViewRetMark);
	CPen* pOldPen = dc.SelectObject(&pen);

	int x0, x, y, xr, x1, x2, x3, xd, y0, y1, y2, y3, y4, y5, yd;
	UINT line = 0;
	wchar_t* pc;
	unsigned char *cc, *cc2, *ccs;
	unsigned char c0, c1, ctmp;

	//	UINT jcode, sjcode;
	int clen;
	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE + 10];

	unsigned char *dbuf;

	x = m_OfsetLeft;
	y = 0;
	xr = 0;
	xd = 10;
	yd = 10;
	x0 = fw + (fw / 2);
	x1 = x0 * 3 / xd + 1;
	x2 = x0 * 5 / xd;
	x3 = x0 * 7 / xd;
	y0 = fh * 3 / yd;
	y1 = fh * 4 / yd;
	y2 = fh * 5 / yd + 1;
	y3 = fh * 6 / yd;
	y4 = fh * 7 / yd;
	y5 = fh * 8 / yd;

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A, sA3, sA4;
	CStringA sSP = "  ";
	sA2.Format("%c", 0x09);

	CString sW, sW2, sW3;
	CString sSPW = _T("  ");
	sW2.Format(_T("%c"), 0x09);

	while (ntab != 0) {
		sSP += " ";
		sSPW += _T(" ");
		ntab--;
	}

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLine) break;
		dc.SetTextColor(colview);
		dc.SetBkColor(m_colBack);

		if (m_CharCode == CC_SJIS) {
			cc = m_pcFile + m_pLinePoint[line];
			xr = x;
			//			if ( m_pCharLine[line] != 0 ) {
			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			memcpy(cbuf, cc, sl);
			cbuf[sl] = 0;
			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete[]dbuf;
			sl = sA.GetLength();
			//				int orglen = sl;
			CStringA sAorg = sA;
			//				if ( sl > 1 ) {
			//					if ( sA.GetAt(sl - 1) == 0x0a ) sl--;
			//					if ( sA.GetAt(sl - 1) == 0x0d ) sl--;
			//				}

			CStringA stA = sA;

			//				stA.Replace("@", "NcdQ?k~");
			//				stA.Replace("@", "k");


			int sr = stA.Replace("\r\n", "@");
			if (sr == 0) {
				sr = stA.Replace("\r", " ");
				if (sr == 0) {
					sr = stA.Replace("\n", " ");
				}
			}
			int al = stA.GetLength();



			TextOutA(dc.m_hDC, x, y, (LPCSTR)stA, al);

			if (line == m_nFindLineNo) {	// v
				sFind1A = sA.Left(m_nFindCharNo);
				sFind2A = CW2A(m_sFindString);
				sW = CA2W(sFind1A);
				size = dc.GetTextExtent(sW);	// v̕\Jnʒu
				sFind1A = sA.Mid(m_nFindCharNo, sFind2A.GetLength());
				dc.SetTextColor(colFindStr);
				dc.SetBkColor(colFindStrBack);
				TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sFind1A, sFind1A.GetLength());

			}
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;
				int dXs = m_nSelStartCs;
				int dXe = m_nSelEndCe;

				int nXs = m_nSelStartNs;
				int nXe = m_nSelEndNe;

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;
					dXs = m_nSelEndCs;
					dXe = m_nSelStartCe;

					nXs = m_nSelEndNs;
					nXe = m_nSelStartNe;
				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndCs;
						dXe = m_nSelStartCe;

						nXs = m_nSelEndNs;
						nXe = m_nSelStartNe;
					}
				}


				if (line == sy) {
					ccs = cc;
					ccs += dXs;


					size.cx = 0;
					size.cy = 0;
					int len = dXs;
					if (len != 0) {
						memcpy(cbuf, cc, len);
						cbuf[len] = 0;

						dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
						ReplaceTab(cbuf, dbuf, len);
						sA.Format("%s", dbuf);
						delete[]dbuf;

						sW = CA2W(sA);
						size = dc.GetTextExtent(sW);
					}


					len = dXe + 1;
					if (ey > sy) {
						len = m_pLinePoint[line + 1] - m_pLinePoint[line];
					}
					memcpy(cbuf, cc, len);
					cbuf[len] = 0;
					if (len > 0) {
						if (cbuf[len - 1] == 0x0a) {
							cbuf[len - 1] = 0x20;
							if (cbuf[len - 2] == 0x0d && len > 1) cbuf[len - 2] = 0x20;
						}
						if (cbuf[len - 1] == 0x0d) cbuf[len - 1] = 0x20;
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sA.Format("%s", dbuf);
					delete[]dbuf;

					CStringA sA2;
					sA2 = sA;

					int la = sA.GetLength();
					int l = nXe - nXs + 1;
					if (ey > sy) {
						l = la - nXs + 1;
					}

					sA = sA2.Mid(nXs, l);


					len = sA.GetLength();
					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sA, len);
				}

				if ((line > sy) && (line < ey)) {
					ccs = cc;
					int len = m_pLinePoint[line + 1] - m_pLinePoint[line];

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					if (len > 0) {
						if (cbuf[len - 1] == 0x0a) {
							cbuf[len - 1] = 0x20;
							if (cbuf[len - 2] == 0x0d && len > 1) cbuf[len - 2] = 0x20;
						}
						if (cbuf[len - 1] == 0x0d) cbuf[len - 1] = 0x20;
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sA.Format("%s", dbuf);
					delete[]dbuf;

					len = sA.GetLength();
					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOutA(dc.m_hDC, x, y, (LPCSTR)sA, len);
				}

				if ((line == ey) && (sy != ey)) {
					ccs = cc;
					int len = dXe + 1;

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					if (cbuf[len - 1] == 0x0a) {
						cbuf[len - 1] = 0x20;
						if (cbuf[len - 2] == 0x0d) cbuf[len - 2] = 0x20;
					}
					if (cbuf[len - 1] == 0x0d) cbuf[len - 1] = 0x20;

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sA.Format("%s", dbuf);
					delete[]dbuf;

					len = sA.GetLength();
					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOutA(dc.m_hDC, x, y, (LPCSTR)sA, len);

				}


			}
			sA = sAorg;
			sA.Replace("\r", "");
			sA.Replace("\n", "");
			int sla = sA.GetLength();
			xr = x + (sla * fw) + fw / 2;

			//				xr = x + (sl * fw) + fw / 2;
			//			}
			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
			}
			else {
				if (c1 == 0x0a) {
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
				}

			}
			if (c1 == 0x0d) {
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
			}

			y += fh;
		}

		if (m_CharCode == CC_UNICODE) {

			cc2 = m_pcFile + m_pLinePoint[line];
			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			int orglen = sl;

			memcpy(cbuf, cc2, sl);
			cbuf[sl] = 0;
			cbuf[sl + 1] = 0;

			sl -= 2;
			c0 = cbuf[sl];
			c1 = cbuf[sl + 1];

			if (m_Endian) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}

			bool bCrLf = false;
			bool bCr = false;
			bool bLf = false;

			if ((sl >= 0) && (c0 == 0x0a) && (c1 == 0)) {
				//				cbuf[sl] = 0;
				//				cbuf[sl + 1] = 0;
				sl -= 2;
				c0 = cbuf[sl];
				c1 = cbuf[sl + 1];

				if (m_Endian) {
					ctmp = c0;
					c0 = c1;
					c1 = ctmp;
				}
				if ((sl >= 0) && (c0 == 0x0d) && (c1 == 0)) {
					//					cbuf[sl] = 0;
					//					cbuf[sl + 1] = 0;
					bCrLf = true;
				}
				else {
					bLf = true;
				}
			}
			else {
				if ((sl >= 0) && (c0 == 0x0d) && (c1 == 0)) {
					//					cbuf[sl] = 0;
					//					cbuf[sl + 1] = 0;
					//					bCrLf = true;
					bCr = true;
				}
			}

			dbuf = new unsigned char[orglen * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, orglen);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete[]dbuf;

			int lw = sW.GetLength();
			CString stW = sW;
			//			stW.Replace(_T("\r\n"), _T("  "));
			int sr = stW.Replace(_T("\r\n"), _T("  "));
			if (sr == 0) {
				sr = stW.Replace(_T("\r"), _T(" "));
				if (sr == 0) {
					sr = stW.Replace(_T("\n"), _T(" "));
				}
			}

			int linea = m_nLineA;


			pc = (wchar_t*)(m_pcFile + m_pLinePoint[line]);
			xr = x;
			//			if ( m_pCharLine[line] != 0 ) {
			dc.TextOut(x, y, stW, lw);
			size = dc.GetTextExtent(sW);
			int linelen = size.cx;

			if (line == m_nFindLineNo) {	// v
				sW3 = sW.Left(m_nFindCharNo);
				size = dc.GetTextExtent(sW3);	// v̕\Jnʒu
				sW3 = sW.Mid(m_nFindCharNo, m_sFindString.GetLength());
				dc.SetTextColor(colFindStr);
				dc.SetBkColor(colFindStrBack);
				dc.TextOut(x + size.cx, y, sW3, sW3.GetLength());

			}

			cc = m_pcFile + m_pLinePoint[line];
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;
				int dXs = m_nSelStartCs;
				int dXe = m_nSelEndCe;

				int nXs = m_nSelStartNs;
				int nXe = m_nSelEndNe;

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;
					dXs = m_nSelEndCs;
					dXe = m_nSelStartCe;

					nXs = m_nSelEndNs;
					nXe = m_nSelStartNe;
				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndCs;
						dXe = m_nSelStartCe;

						nXs = m_nSelEndNs;
						nXe = m_nSelStartNe;
					}
				}

				if (line == sy) {
					ccs = cc;
					ccs += dXs;

					int dlen = dXs;
					memcpy(cbuf, cc, dlen);
					cbuf[dlen] = 0;
					cbuf[dlen + 1] = 0;

					size.cx = 0;
					size.cy = 0;
					if (dlen > 0) {
						dbuf = new unsigned char[dlen * m_pFmParam->m_ViewTabNum + 2];
						ReplaceTab(cbuf, dbuf, dlen);
						sW.Format(_T("%s"), (wchar_t*)dbuf);
						delete[]dbuf;
						size = dc.GetTextExtent(sW);
					}


					int len = dXe + 1;

					if (ey > sy) {
						len = m_pLinePoint[line + 1] - m_pLinePoint[line];
					}

					memcpy(cbuf, cc, len);


					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}

						}

					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;

					CString sW2;
					sW2 = sW;

					int la = sW.GetLength();
					int l = nXe - nXs + 1;
					if (ey > sy) {
						l = la - nXs + 1;
					}

					sW = sW2.Mid(nXs, l);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOut(dc.m_hDC, x + size.cx, y, sW, sW.GetLength());
				}

				if ((line > sy) && (line < ey)) {
					ccs = cc;
					int len = m_pLinePoint[line + 1] - m_pLinePoint[line];

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}
						}
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOut(dc.m_hDC, x, y, sW, sW.GetLength());
				}

				if ((line == ey) && (sy != ey)) {
					ccs = cc;
					int len = dXe + 1;

					memcpy(cbuf, ccs, len);
					cbuf[len] = 0;
					cbuf[len + 1] = 0;

					c0 = cbuf[len - 2];
					c1 = cbuf[len - 1];

					if (m_Endian) {
						ctmp = c0;
						c0 = c1;
						c1 = ctmp;
					}

					if ((len > 0) && (c0 == 0x0a) && (c1 == 0)) {
						if (m_Endian) {
							cbuf[len - 1] = 0x20;
						}
						else {
							cbuf[len - 2] = 0x20;
						}

						c0 = cbuf[len - 4];
						c1 = cbuf[len - 3];

						if (m_Endian) {
							ctmp = c0;
							c0 = c1;
							c1 = ctmp;
						}
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 3] = 0x20;
							}
							else {
								cbuf[len - 4] = 0x20;
							}
						}
					}
					else {
						if ((len > 0) && (c0 == 0x0d) && (c1 == 0)) {
							if (m_Endian) {
								cbuf[len - 1] = 0x20;
							}
							else {
								cbuf[len - 2] = 0x20;
							}
						}
					}

					dbuf = new unsigned char[len * m_pFmParam->m_ViewTabNum + 2];
					ReplaceTab(cbuf, dbuf, len);
					sW.Format(_T("%s"), (wchar_t*)dbuf);
					delete[]dbuf;


					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);

					TextOut(dc.m_hDC, x, y, sW, sW.GetLength());

				}


			}

			xr = x + (linea * fw) + fw / 2;
			//			}
			if (bCrLf) {
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
			}
			else {
				if (bLf) {
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
				}

			}
			if (bCr) {
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
			}


			y += fh;
		}

		if (m_CharCode == CC_JIS) {

			int sl = 0;

			xr = x;

			int blen = ChangeLineJIStoSJIS(line, cbuf);

			sA.Format("%s", cbuf);

			sl = sA.GetLength();
			CStringA sAorg = sA;

			saSelLine = sA;

			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete[]dbuf;

			sA.Replace("\r", " ");
			sA.Replace("\n", " ");
			/*
			int sr = sA.Replace("\r\n", "@");
			if (sr == 0) {
			sr = sA.Replace("\r", " ");
			if (sr == 0) {
			sr = sA.Replace("\n", " ");
			}
			}
			*/

			sl = sA.GetLength();
			TextOutA(dc.m_hDC, x, y, sA, sl);


			int dXs = 0;
			int dXe = 0;
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;
				dXs = m_nSelStartNs;
				dXe = m_nSelEndNe;

				int nXs = m_nSelStartNsT;
				int nXe = m_nSelEndNeT;

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;
					dXs = m_nSelEndNs;
					dXe = m_nSelStartNe;

					nXs = m_nSelEndNsT;
					nXe = m_nSelStartNeT;
				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

					}
					if (nXs > nXe) {
						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;
					}
				}


				if (line == sy) {
					int dl = dXe - dXs + 1;
					if (ey > sy) dl = sA.GetLength() - dXs + 1;
					sA3 = sA.Mid(dXs, dl);

					int tdl = nXe - nXs + 1;
					if (ey > sy) tdl = saSelLine.GetLength() - nXs + 1;
					m_saSelectStr += saSelLine.Mid(nXs, tdl);

					int dsl = sA3.GetLength();

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					TextOutA(dc.m_hDC, x + (dXs * m_FontX), y, sA3, dsl);
				}

				if ((line > sy) && (line < ey)) {
					sA3 = sA;

					m_saSelectStr += saSelLine;

					int dsl = sA3.GetLength();

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					TextOutA(dc.m_hDC, x, y, sA3, dsl);
				}

				if (line == ey && sy != ey) {
					int dl = dXe + 1;
					sA3 = sA.Left(dl);

					int tdl = nXe + 1;
					m_saSelectStr += saSelLine.Left(tdl);

					int dsl = sA3.GetLength();

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					TextOutA(dc.m_hDC, x, y, sA3, dsl);
				}
			}


			if (line == m_nFindLineNo) {	// v
				sFind1A = sA.Left(m_nFindCharNo);
				sFind2A = CW2A(m_sFindString);
				sW = CA2W(sFind1A);
				size = dc.GetTextExtent(sW);	// v̕\Jnʒu
				sFind1A = sA.Mid(m_nFindCharNo, sFind2A.GetLength());
				dc.SetTextColor(colFindStr);
				dc.SetBkColor(colFindStrBack);
				TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sFind1A, sFind1A.GetLength());
			}

			sA = sAorg;
			sA.Replace("\r", "");
			sA.Replace("\n", "");
			int sla = sA.GetLength();

			xr = x + (sla * fw) + fw / 2;
			//			xr = x + (sl * fw) + fw / 2;

			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
			}
			else {
				if (c1 == 0x0a) {
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
				}

			}
			if (c1 == 0x0d) {
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
			}


			y += fh;
		}

		if (m_CharCode == CC_EUC) {

			cc = m_pcFile + m_pLinePoint[line];
			xr = x;
			clen = m_pCharLine[line];
			//			if ( clen != 0 ) {

			int blen = ChangeLineEUCtoSJIS(line, cbuf);

			sA.Format("%s", cbuf);

			int sl = sA.GetLength();

			saSelLine = sA;
			CStringA sAorg = sA;

			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 2];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete[]dbuf;

			sA.Replace("\r", " ");
			sA.Replace("\n", " ");
			/*
			int sr = sA.Replace("\r\n", "@");
			if (sr == 0) {
			sr = sA.Replace("\r", " ");
			if (sr == 0) {
			sr = sA.Replace("\n", " ");
			}
			}
			*/

			sl = sA.GetLength();
			TextOutA(dc.m_hDC, x, y, sA, sl);

			int dXs = 0;
			int dXe = 0;
			if (m_bSelected) {
				UINT sy = m_nSelStartY;
				UINT ey = m_nSelEndY;

				dXs = m_nSelStartNs;
				dXe = m_nSelEndNe;

				int nXs = m_nSelStartNsT;
				int nXe = m_nSelEndNeT;

				/*
				dXs = m_nSelStartCs;
				dXe = m_nSelEndCe;

				int nXs = m_nSelStartNs;
				int nXe = m_nSelEndNe;
				*/

				if (ey < sy) {
					sy = m_nSelEndY;
					ey = m_nSelStartY;

					dXs = m_nSelEndNs;
					dXe = m_nSelStartNe;

					nXs = m_nSelEndNsT;
					nXe = m_nSelStartNeT;

					/*
					dXs = m_nSelEndCs;
					dXe = m_nSelStartCe;

					nXs = m_nSelEndNs;
					nXe = m_nSelStartNe;
					*/

				}

				if (sy == ey) {
					if (dXs > dXe) {
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;

						/*
						dXs = m_nSelEndCs;
						dXe = m_nSelStartCe;

						nXs = m_nSelEndNs;
						nXe = m_nSelStartNe;
						*/

					}
				}


				if (line == sy) {
					int dl = dXe - dXs + 1;
					if (ey > sy) dl = sA.GetLength() - dXs + 1;
					sA3 = sA.Mid(dXs, dl);
					int dsl = sA3.GetLength();

					int tdl = nXe - nXs + 1;
					if (ey > sy) tdl = saSelLine.GetLength() - nXs + 1;
					m_saSelectStr += saSelLine.Mid(nXs, tdl);

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					TextOutA(dc.m_hDC, x + (dXs * m_FontX), y, sA3, dsl);
				}

				if ((line > sy) && (line < ey)) {
					sA3 = sA;
					int dsl = sA3.GetLength();

					m_saSelectStr += saSelLine;

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					TextOutA(dc.m_hDC, x, y, sA3, dsl);
				}

				if (line == ey && sy != ey) {
					int dl = dXe + 1;
					sA3 = sA.Left(dl);
					int dsl = sA3.GetLength();

					int tdl = nXe + 1;
					m_saSelectStr += saSelLine.Left(tdl);

					int al = sA3.GetLength() - 1;
					if (sA3.GetAt(al) == 0x0a) sA3.SetAt(al, 0x20);

					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					TextOutA(dc.m_hDC, x, y, sA3, dsl);
				}
			}



			if (line == m_nFindLineNo) {	// v
				sFind1A = sA.Left(m_nFindCharNo);
				sFind2A = CW2A(m_sFindString);
				sW = CA2W(sFind1A);
				size = dc.GetTextExtent(sW);	// v̕\Jnʒu
				sFind1A = sA.Mid(m_nFindCharNo, sFind2A.GetLength());
				dc.SetTextColor(colFindStr);
				dc.SetBkColor(colFindStrBack);
				TextOutA(dc.m_hDC, x + size.cx, y, (LPCSTR)sFind1A, sFind1A.GetLength());

			}
			sAorg.Replace("\r", "");
			sAorg.Replace("\n", "");
			int sla = sAorg.GetLength();
			//				xr = x + (sl * fw) + fw / 2;
			xr = x + (sla * fw) + fw / 2;
			//			}
			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
			}
			else {
				if (c1 == 0x0a) {
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
				}

			}
			if (c1 == 0x0d) {
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
			}


			y += fh;
		}

		if (m_CharCode == CC_UTF8) {

			CString sWt;
			xr = x;
			int clen = m_pCharLine[line];
			if (clen >= 0) {

				int ib = ChangeLineUTF8toWC(line, wcbuf);

				sSelLine.Format(_T("%s"), wcbuf);

				int tlen = ib * 2;

				dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 2];
				ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
				sW.Format(_T("%s"), (wchar_t*)dbuf);
				delete[]dbuf;

				int sl = sWt.GetLength();
				clen = sl;

				sWt = sW;
				//				sWt.Replace(_T("\r\n"), _T("@"));
				/*
				int sr = sWt.Replace(_T("\r\n"), _T("  "));
				if (sr == 0) {
				sr = sWt.Replace(_T("\r"), _T(" "));
				if (sr == 0) {
				sr = sWt.Replace(_T("\n"), _T(" "));
				}
				}
				*/
				sWt.Replace(_T("\r"), _T(" "));
				sWt.Replace(_T("\n"), _T(" "));

				int al = sWt.GetLength();


				dc.TextOut(x, y, sWt, al);


				int dXs = 0;
				int dXe = 0;
				if (m_bSelected) {
					UINT sy = m_nSelStartY;
					UINT ey = m_nSelEndY;
					dXs = m_nSelStartNs;
					dXe = m_nSelEndNe;

					int nXs = m_nSelStartNsT;
					int nXe = m_nSelEndNeT;

					int nDs = m_nSelStartDs;


					if (ey < sy) {
						sy = m_nSelEndY;
						ey = m_nSelStartY;
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;
						nDs = m_nSelStartDe;
					}

					if (sy == ey) {
						if (dXs > dXe) {
							dXs = m_nSelEndNs;
							dXe = m_nSelStartNe;

						}
						if (nXs > nXe) {
							nXs = m_nSelEndNsT;
							nXe = m_nSelStartNeT;
							nDs = m_nSelStartDe;
						}
					}

					CString sW3;

					if (line == sy) {
						int dl = dXe - dXs + 1;
						if (ey > sy) dl = sW.GetLength() - dXs + 1;
						sW3 = sW.Mid(dXs, dl);
						//						sW3.Replace(_T("\r\n"), _T("@"));
						/*
						sr = sW3.Replace(_T("\r\n"), _T("  "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\r"), _T(" "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\n"), _T(" "));
						}
						}
						*/
						sW3.Replace(_T("\r"), _T(" "));
						sW3.Replace(_T("\n"), _T(" "));

						int dsl = sW3.GetLength();

						int tdl = nXe - nXs + 1;
						if (ey > sy) tdl = sSelLine.GetLength() - nXs + 1;
						m_sSelectStr += sSelLine.Mid(nXs, tdl);

						int dx = nDs;

						dc.SetTextColor(colFindStr);
						dc.SetBkColor(colFindStrBack);
						TextOut(dc.m_hDC, x + (dx * m_FontX), y, sW3, dsl);
					}

					if ((line > sy) && (line < ey)) {
						sW3 = sW;
						//						sW3.Replace(_T("\r\n"), _T("@"));
						/*
						sr = sW3.Replace(_T("\r\n"), _T("  "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\r"), _T(" "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\n"), _T(" "));
						}
						}
						*/
						sW3.Replace(_T("\r"), _T(" "));
						sW3.Replace(_T("\n"), _T(" "));

						int dsl = sW3.GetLength();

						m_sSelectStr += sSelLine;

						dc.SetTextColor(colFindStr);
						dc.SetBkColor(colFindStrBack);
						TextOut(dc.m_hDC, x, y, sW3, dsl);
					}

					if (line == ey && sy != ey) {
						int dl = dXe + 1;
						sW3 = sW.Left(dl);
						//						sW3.Replace(_T("\r\n"), _T("@"));
						/*
						sr = sW3.Replace(_T("\r\n"), _T("  "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\r"), _T(" "));
						if (sr == 0) {
						sr = sW3.Replace(_T("\n"), _T(" "));
						}
						}
						*/
						sW3.Replace(_T("\r"), _T(" "));
						sW3.Replace(_T("\n"), _T(" "));

						int dsl = sW3.GetLength();

						int tdl = nXe + 1;
						m_sSelectStr += sSelLine.Left(tdl);

						dc.SetTextColor(colFindStr);
						dc.SetBkColor(colFindStrBack);
						TextOut(dc.m_hDC, x, y, sW3, dsl);
					}
				}

				if (line == m_nFindLineNo) {	// v
					sW3 = sW.Left(m_nFindCharNo);
					size = dc.GetTextExtent(sW3);	// v̕\Jnʒu
					sW3 = sW.Mid(m_nFindCharNo, m_sFindString.GetLength());
					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					dc.TextOut(x + size.cx, y, sW3, sW3.GetLength());

				}

			}

			sWt = sW;
			//			sWt.Replace(_T("\r\n"), _T(""));

			sWt.Replace(_T("\r"), _T(""));
			sWt.Replace(_T("\n"), _T(""));

			size = dc.GetTextExtent(sWt);
			xr = size.cx + fw;


			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
			}
			else {
				if (c1 == 0x0a) {
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
				}

			}
			if (c1 == 0x0d) {
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
			}


			y += fh;
		}

		if (m_CharCode == CC_UTF7) {

			CString sWt;
			xr = x;
			int clen = m_pCharLine[line];
			if (clen >= 0) {

				int ib = ChangeLineUTF7toWC(line, wcbuf);

				sSelLine.Format(_T("%s"), wcbuf);

				int tlen = ib * 2;
				//				int tlen = clen * 2;
				dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 2];
				ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
				sW.Format(_T("%s"), (wchar_t*)dbuf);
				delete[]dbuf;

				int sl = sW.GetLength();
				clen = sl;

				sWt = sW;
				//				sWt.Replace(_T("\r\n"), _T("@"));
				int sr = sWt.Replace(_T("\r\n"), _T("  "));
				if (sr == 0) {
					sr = sWt.Replace(_T("\r"), _T(" "));
					if (sr == 0) {
						sr = sWt.Replace(_T("\n"), _T(" "));
					}
				}

				int al = sWt.GetLength();

				dc.TextOut(x, y, sWt, al);

				int dXs = 0;
				int dXe = 0;
				if (m_bSelected) {
					UINT sy = m_nSelStartY;
					UINT ey = m_nSelEndY;
					dXs = m_nSelStartNs;
					dXe = m_nSelEndNe;

					int nXs = m_nSelStartNsT;
					int nXe = m_nSelEndNeT;

					int nDs = m_nSelStartDs;

					if (ey < sy) {
						sy = m_nSelEndY;
						ey = m_nSelStartY;
						dXs = m_nSelEndNs;
						dXe = m_nSelStartNe;

						nXs = m_nSelEndNsT;
						nXe = m_nSelStartNeT;

						nDs = m_nSelStartDe;
					}

					if (sy == ey) {
						if (dXs > dXe) {
							dXs = m_nSelEndNs;
							dXe = m_nSelStartNe;

						}
						if (nXs > nXe) {
							nXs = m_nSelEndNsT;
							nXe = m_nSelStartNeT;
							nDs = m_nSelStartDe;
						}
					}

					CString sW3;

					if (line == sy) {
						int dl = dXe - dXs + 1;
						if (ey > sy) dl = sW.GetLength() - dXs + 1;
						sW3 = sW.Mid(dXs, dl);
						sW3.Replace(_T("\r\n"), _T("@"));
						int dsl = sW3.GetLength();

						int tdl = nXe - nXs + 1;
						if (ey > sy) tdl = sSelLine.GetLength() - nXs + 1;
						m_sSelectStr += sSelLine.Mid(nXs, tdl);

						int dx = nDs;

						dc.SetTextColor(colFindStr);
						dc.SetBkColor(colFindStrBack);
						TextOut(dc.m_hDC, x + (dx * m_FontX), y, sW3, dsl);
					}

					if ((line > sy) && (line < ey)) {
						sW3 = sW;
						sW3.Replace(_T("\r\n"), _T("@"));
						int dsl = sW3.GetLength();

						m_sSelectStr += sSelLine;

						dc.SetTextColor(colFindStr);
						dc.SetBkColor(colFindStrBack);
						TextOut(dc.m_hDC, x, y, sW3, dsl);
					}

					if (line == ey && sy != ey) {
						int dl = dXe + 1;
						sW3 = sW.Left(dl);
						sW3.Replace(_T("\r\n"), _T("@"));
						int dsl = sW3.GetLength();

						int tdl = nXe + 1;
						m_sSelectStr += sSelLine.Left(tdl);

						dc.SetTextColor(colFindStr);
						dc.SetBkColor(colFindStrBack);
						TextOut(dc.m_hDC, x, y, sW3, dsl);
					}
				}

				if (line == m_nFindLineNo) {	// v
					sW3 = sW.Left(m_nFindCharNo);
					size = dc.GetTextExtent(sW3);	// v̕\Jnʒu
					sW3 = sW.Mid(m_nFindCharNo, m_sFindString.GetLength());
					dc.SetTextColor(colFindStr);
					dc.SetBkColor(colFindStrBack);
					dc.TextOut(x + size.cx, y, sW3, sW3.GetLength());

				}

			}

			sWt = sW;
			//			sWt.Replace(_T("\r\n"), _T(""));
			sWt.Replace(_T("\r"), _T(""));
			sWt.Replace(_T("\n"), _T(""));
			size = dc.GetTextExtent(sWt);
			xr = size.cx + fw;


			cc = m_pcFile + m_pLinePoint[line + 1] - 2;
			c0 = *cc;
			cc++;
			c1 = *cc;
			if ((c1 == 0x0a) && (c0 == 0x0d)) {
				dc.MoveTo(xr + x2, y + y0);
				dc.LineTo(xr + x3, y + y0);
				dc.LineTo(xr + x3, y + y4);
				dc.LineTo(xr + x1, y + y4);
				dc.LineTo(xr + x1, y + y5);
				dc.LineTo(xr, y + y3);
				dc.LineTo(xr + x1, y + y1);
				dc.LineTo(xr + x1, y + y2);
				dc.LineTo(xr + x2, y + y2);
				dc.LineTo(xr + x2, y + y0);
			}
			else {
				if (c1 == 0x0a) {
					int xof = xr - fw;
					dc.MoveTo(xof + x2 + 1, y + y0);
					dc.LineTo(xof + x3, y + y0);
					dc.LineTo(xof + x3, y + y4 - 1);

					dc.LineTo(xof + x3 + 2, y + y4 - 4);
					dc.LineTo(xof + x3 - 1, y + y4);
					dc.LineTo(xof + x2 - 2, y + y4 - 4);


					dc.LineTo(xof + x2 + 1, y + y4 - 1);
					dc.LineTo(xof + x2 + 1, y + y0);
				}

			}
			if (c1 == 0x0d) {
				int xof = xr - 2;
				int yof = y - 2;
				dc.MoveTo(xof + x2 - 1, yof + y4);
				dc.LineTo(xof + x1 - 1, yof + y4);
				dc.LineTo(xof + x1, yof + y5);
				dc.LineTo(xof, yof + y3);
				dc.LineTo(xof + x1, yof + y1);
				dc.LineTo(xof + x1 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y2);
				dc.LineTo(xof + x2 - 1, yof + y4);
			}


			y += fh;


		}

	}

	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = m_MaxLine / m_PageLineNum;
	if (maxpage > 0) {
		//		m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
	delete[]wcbuf;
}



void CannsView::CheckAutoCharCode(void)
{
	unsigned char uc[3];
	uc[0] = m_pcFileBuffer[0];
	uc[1] = m_pcFileBuffer[1];
	uc[2] = m_pcFileBuffer[2];

	m_OrgReadFileSize = m_ReadFileSize;
	m_pcFile = m_pcFileBuffer;
	m_bBOM = false;

	// Unicodẽ`FbN  擪"BOM = 0xff/0xfe܂0xfe/0xff"ꍇUnicode
	if ( (m_ReadFileSize > 1) && (uc[0] == 0xff) && (uc[1] == 0xfe) ) {
		m_CharCode = CC_UNICODE;
//		m_bUnicode = true;
		m_Endian = false;	// Little Endian
//		m_pFile->Read(uc, 2);
		m_ReadFileSize -= 2;
		m_pcFile += 2;
		m_bBOM = true;
	}
	if ( (m_ReadFileSize > 1) && (uc[0] == 0xfe) && (uc[1] == 0xff) ) {
		m_CharCode = CC_UNICODE;
//		m_bUnicode = true;
		m_Endian = true;	// Big Endian
//		m_pFile->Read(uc, 2);
		m_ReadFileSize -= 2;
		m_pcFile += 2;
		m_bBOM = true;
	}

	// UTF-8̃`FbN  擪"BOM = 0xef/0xbb/0xbf"ꍇUTF-8
	if ( (m_ReadFileSize > 2) && (uc[0] == 0xef) && (uc[1] == 0xbb) && (uc[2] == 0xbf) ) {
		m_CharCode = CC_UTF8;
		m_ReadFileSize -= 3;
		m_pcFile += 3;
		m_bBOM = true;
	}

	if ( m_pFmParam->m_ViewCharCode == -1 ) CheckCharCode();
	else m_CharCode = m_pFmParam->m_ViewCharCode;
}


int CannsView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB

//	m_pScrollBar->Create(SBS_VERT | WS_CHILD, CRect(0, 0, 0, 0), this, 110);

	m_pFile = new CFile(m_sFullFileName, CFile::modeRead | CFile::shareDenyNone);
	m_pFile->GetStatus(m_FileStatus);
	m_FileSize = m_FileStatus.m_size;

	m_ReadFileSize = 0x4000000;	// 64MB(1000~65000s)܂
	UINT rsize;

	if ( m_FileSize < (ULONGLONG)m_ReadFileSize ) m_ReadFileSize = (UINT)m_FileSize;

	WORD wCodePage = 932;
	m_CharCode = CC_SJIS;
	if ( m_FileSize > 0 ) {
		m_pcFileBuffer = new unsigned char[m_ReadFileSize];

		rsize = m_pFile->Read(m_pcFileBuffer, m_ReadFileSize);
		m_pFile->Close();

		if (m_pFmParam->m_ViewCharCode == -1) {
			//t@C̐擪1MBǂݍŁAR[hy[W߂
			char* szBuff = new char[1024 * 1024 + 2];
			if (szBuff)
			{
				ZeroMemory(szBuff, 1024 * 1024 + 2);
				CFile file;
				if (file.Open(m_sFullFileName, CFile::modeRead, NULL, NULL))
				{
					UINT nLen = file.Read(szBuff, 1024 * 1024);
					CLangage lg;
					lg.DetectInputCodepageJPN(szBuff, nLen, 0, &wCodePage);
				}
				delete szBuff;
			}
			m_pcFile = m_pcFileBuffer;
			m_bBOM = false;


			if (wCodePage == 1200) {
				m_CharCode = CC_UNICODE;
				m_Endian = false;	// Little Endian
				m_ReadFileSize -= 2;
				m_pcFile += 2;
				m_bBOM = true;
			}
			if (wCodePage == 1201) {
				m_CharCode = CC_UNICODE;
				m_Endian = true;	// Big Endian
				m_ReadFileSize -= 2;
				m_pcFile += 2;
				m_bBOM = true;
			}
			if (wCodePage == 65000) {
				m_CharCode = CC_UTF7;
			}
			if (wCodePage == 65001) {
				m_CharCode = CC_UTF8;
				m_ReadFileSize -= 3;
				m_pcFile += 3;
				m_bBOM = true;
			}

			if (wCodePage == 51932) {
				m_CharCode = CC_EUC;
			}
			if (wCodePage == 50220 || wCodePage == 50221 || wCodePage == 50222 || wCodePage == 20932) {
				m_CharCode = CC_JIS;
			}

		}
		else {
			CheckAutoCharCode();
		}



	}
	m_MaxLineHexMode = (UINT)(m_FileSize / 16) + 1;

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		CreateD2d1Resources();
#endif

	}


	return 0;
}

void CannsView::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B

	CRect rc;
	GetClientRect(&rc);

	CFont font;
	CFont* pOldFont;
	int fw, fh;
//	CClientDC dc = CClientDC(this);
	CDC* dc = GetDC();

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc->SelectObject(&font);

	CString ss;
	ss = _T("A");
	CSize size = dc->GetTextExtent( ss );
	dc->SelectObject(pOldFont);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	int w;
//	w = rc.Width() - m_ScrollBarHeight;
	w = rc.Width();
	m_LineCharNum = w / fw - 3;	// 1s̕\(pZ)
//	m_LineCharNum = w / fw - 4;	// 1s̕\(pZ)
	m_PageLineNum = rc.Height() / fh;	// 1y[W̕\s


	if ( m_LineCharNum < 2 ) return;
	if ( m_PageLineNum < 1 ) return;

//	if ( m_wSizeX != cx ) {
//		m_FirstLine = 0;
//		m_wSizeX = cx;
//	}

	bool fmode = false;
	ULONGLONG ullByte = 0;
	ULONGLONG ullFstByte = 0;

	if ( m_wSizeX != cx ) {

		int fln = m_nFindLineNo;
		int fcn = m_nFindCharNo;
		int fstln = m_FirstLine;
		bool bFst = false;

		if ( m_nFindLineNo != -1 ) {

			for ( UINT i = 0; i < m_MaxLine; i++ ) {
				if ( !bFst ) {
					if ( i == fstln ) {
						ullFstByte += fcn;
						bFst = true;
					} else {
						ullFstByte += m_pCharLine[i];
					}
				}

				if ( i == fln ) {
					ullByte += fcn;
					fmode = true;
					break;
				}
				ullByte += m_pCharLine[i];
			}
		}
	}

	CalcLinePoint();

	if ( m_wSizeX != cx ) {
		if ( fmode ) {
			ULONGLONG ullTb = 0;
			ULONGLONG ullFstTb = 0;
			UINT ul;
			bool bFst = false;
			for ( UINT i = 0; i < m_MaxLine; i++ ) {
				ul = m_pCharLine[i];
				if ( !bFst ) {
					if ( (ullFstTb + ul) > ullFstByte ) {
						m_FirstLine = i;
						bFst = true;
					} else {
						ullFstTb += m_pCharLine[i];
					}
				}

				if ( (ullTb + ul) > ullByte ) {
					m_nFindLineNo = i;
					m_nFindCharNo = (int)(ullByte - ullTb);
					break;
				}
				ullTb += m_pCharLine[i];
			}
		}
		m_wSizeX = cx;
	}

//	m_nFindLineNo = -1;
//	m_nFindCharNo = -1;
//	m_sFindString = _T("");

	UINT last = m_MaxLine - m_PageLineNum;

	if (m_FirstLine > last) {
		m_FirstLine = last;
	}

	if (m_pFmParam->m_bViewDirectWrite) {

#ifndef _WINVER_XP
		DiscardDeviceResources();
		CreateDeviceResources();
#endif

	}

//	GetWindowRect(&rc);
//	ScreenToClient(&rc);
//	rc.left = rc.right - m_ScrollBarHeight;
//	m_pScrollBar->MoveWindow(&rc);

	SetScrollData();

	ReleaseDC(dc);
}

void CannsView::SetScrollData(void)
{
	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_PAGE | SIF_RANGE;
	info.nMin = 0;    
	info.nMax = m_MaxLine - 1;
	info.nPage = m_PageLineNum;
	info.nPos = 0;
	info.nTrackPos = m_pFmParam->m_ViewDeltaLine;

//	m_pScrollBar->SetScrollInfo(&info);

	m_pViewFrame->m_pScrollBar->SetScrollInfo(&info);

	if ( m_MaxLine < (UINT)m_PageLineNum ) {
//		m_pScrollBar->EnableScrollBar(ESB_DISABLE_BOTH);
		m_pViewFrame->m_pScrollBar->EnableScrollBar(ESB_DISABLE_BOTH);
	}
//	m_pScrollBar->ShowScrollBar();
	m_pViewFrame->m_pScrollBar->ShowScrollBar();
}

// ǂݍ񂾃eLXgt@C̕R[h`FbN
void CannsView::CheckCharCode(void)
{
	if ( m_CharCode == CC_UNICODE ) return;

	int len = 10000;
	int cEUC = 0;
	int cSJIS = 0;
	int cASCII = 0;
	int cUTF8 = 0;
	int cUTF7P = 0;
	int cUTF7M = 0;
	int max;

	bool bUTF7 = true;

	unsigned char *cc, *cc2;
	unsigned char c;


	if ( m_FileSize < (ULONGLONG)len ) len = (int)m_FileSize;
	max = len;
	cc = m_pcFile;

	while ( len != 0 ) {
		if ( *cc == 0x1b ) {	// 0x1b/0x28 or 0x1b/0x24 JIS
			if ( (*(cc + 1) == 0x28) || (*(cc + 1) == 0x24) ) {
				m_CharCode = CC_JIS;
				return;
			}
		}
		if ( *cc < 0x80 ) {
			cASCII++;

		}
		if ( *cc == 0x8E ) {
			c = *(cc + 1);
			if ( (c >= 0xa0) && (c <= 0xff) ) cEUC++;
		}
		if ( *cc == 0x8F ) {
			c = *(cc + 1);
			if ( (c >= 0xa0) && (c <= 0xff) ) cEUC++;
		}
		if ( (*cc >= 0xa0) && (*cc < 0xe0) ) {	// EUC̑oCg 0xa0`0xcf܂
			cEUC++;
		}
		if ( (*cc >= 0x80) && (*cc < 0xa0) ) {	// SJIS̑oCg
			cSJIS++;
		}


		if ( (*cc >= 0xc0) && (*cc <= 0xdf) ) {	// UTF-8̑oCg
			cc2 = cc;
//			cc2++;
//			if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
				cUTF8++;
//			}
		}

		if ( (*cc >= 0xe0) && (*cc <= 0xef) ) {
			cc2 = cc;
			cc2++;
			if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
				cc2++;
				cUTF8++;
				if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
					cUTF8++;
				}
			}
		}

		if ( (*cc >= 0xf0) && (*cc <= 0xf7) ) {
			cc2 = cc;
			cc2++;
			if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
				cc2++;
				if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
					cc2++;
					cUTF8++;
					if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
						cUTF8++;
					}
				}
			}
		}
		if ( (*cc >= 0xf8) && (*cc <= 0xfb) ) {
			cc2 = cc;
			cc2++;
			if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
				cc2++;
				if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
					cc2++;
					if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
						cc2++;
						if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
							cUTF8++;
						}
					}
				}
			}
		}
		if ( (*cc >= 0xfc) && (*cc <= 0xfd) ) {
			cc2 = cc;
			cc2++;
			if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
				cc2++;
				if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
					cc2++;
					if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
						cc2++;
						if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
							cc2++;
							if ( (*cc2 >= 0x80) && (*cc2 <= 0xbf) ) {
								cUTF8++;
							}
						}
					}
				}
			}
		}
		if ( *cc == 0x2b ) {
			cUTF7P++;
		}
		if ( *cc == 0x2d ) {
			cUTF7M++;
		}
		if ( *cc > 0x7f ) {
			bUTF7 = false;
		}

		cc++;
		len--;
	}
	if ( m_CharCode != CC_JIS ) {
		if ( cUTF8 >= cSJIS && cUTF8 != 0 ) {
			m_CharCode = CC_UTF8;
		}

		if ( cEUC > cSJIS && cEUC != 0 ) {
			m_CharCode = CC_EUC;
		}

		if ( (cUTF7P > 3 ) && (cUTF7M > 3) && bUTF7) {
			if ( cUTF7M == cUTF7P ) {
				m_CharCode = CC_UTF7;
			}
		} else {

			if ( cASCII == max ) 
				m_CharCode = CC_SJIS;
		}
	}
}


// L[R}hs	nCmdNo = R}hNo.
// L[JX^}CYyуR}h}NpɁAR}hNo.őSẴR}hs
void CannsView::RunKeyCmd(UINT uCmdNo)
{
	switch ( uCmdNo ) {

		case 0x08: // "Backspace"
//			CmdKeyBackspace();
			break;

		case 0x09: // "Tab"
			if ( m_bHexMode  ) {
				m_bHexMode = false;
				m_MaxLine = m_MaxLineNormalMode;
			} else {
				m_bHexMode = true;
				m_MaxLine = m_MaxLineHexMode;
			}
			m_FirstLine = 0;
			Invalidate();
			break;

		case 0x0d: // "Enter"
			CmdKeyEnter();
			break;

		case 0x1b: // "Esc"
			CmdKeyQuit();
			break;

		case 0x20: // Space
			CmdKeySpace();
			break;

		case 0x21: // PageUp
			CmdKeyPageUp();
			break;

		case 0x22: // PageDown
			CmdKeyPageDown();
			break;


		case 0x23: // "End"
			CmdKeyEnd();
			break;

		case 0x24: // "Home"
			CmdKeyHome();
			break;

		case 0x25: // ""
			CmdKeyLeft();
			break;

		case 0x26: // ""
			CmdKeyUp();
			break;

		case 0x27: // ""
			CmdKeyRight();
			break;

		case 0x28: // ""
			CmdKeyDown();
			break;

		case 0x30: // "0"
		case 0x31: // "1"
		case 0x32: // "2"
		case 0x33: // "3"
		case 0x34: // "4"
		case 0x35: // "5"
		case 0x36: // "6"
		case 0x37: // "7"
		case 0x38: // "8"
		case 0x39: // "9"
			CmdKeyNumber(uCmdNo);
			break;

		case 0x41: // "A"
			OnMenuKeyA();
			break;

		case 0x45: // "E"
			CmdKeyShiftEnter();
//			CmdKeyNumber(0x35);
			break;

		case 0x46: // "F"
			CmdKeyFind();
			break;

		case 0x4a: // "J"
			CmdKeyNumber(0x34);
			break;

		case 0x50: // "P"
			OnFilePrint();
			SetFocus();
			break;

		case 0x51: // "Q"
			CmdKeyQuit();
			break;

		case 0x53: // "S"
			CmdKeyNumber(0x33);
			break;

		case 0x54: // "T"
			CmdKeyFindPrev();
			break;

		case 0x55: // "U"
			CmdKeyNumber(0x36);
			break;

		case 0x56: // "V"
			CmdKeyFindNext();
			break;

		case 0x60: // "0" eL[
		case 0x61: // "1"
		case 0x62: // "2"
		case 0x63: // "3"
		case 0x64: // "4"
		case 0x65: // "5"
		case 0x66: // "6"
		case 0x67: // "7"
		case 0x68: // "8"
		case 0x69: // "9"
			break;

		case 0x72: // "F3"
			CmdKeyFindNext();
			break;


		// Shift+
		case 0x108: // "Backspace"
			break;

		case 0x10d: // "Enter"
			CmdKeyShiftEnter();
			break;

		case 0x121: // PageUp
			break;

		case 0x122: // PageDown
			break;


		case 0x125: // ""
			break;

		case 0x126: // ""
			break;

		case 0x127: // ""
			break;

		case 0x128: // ""
			break;

		case 0x130: // "0"
			break;
		case 0x131: // "1"
			break;
		case 0x132: // "2"
			break;
		case 0x133: // "3"
			break;
		case 0x134: // "4"
			break;
		case 0x135: // "5"
			break;
		case 0x136: // "6"
			break;
		case 0x137: // "7"
			break;
		case 0x138: // "8"
			break;
		case 0x139: // "9"
			break;

		case 0x160: // "0" eL[
			break;
		case 0x161: // "1"
			break;
		case 0x162: // "2"
			break;
		case 0x163: // "3"
			break;
		case 0x164: // "4"
			break;
		case 0x165: // "5"
			break;
		case 0x166: // "6"
			break;
		case 0x167: // "7"
			break;
		case 0x168: // "8"
			break;
		case 0x169: // "9"
			break;

		// Ctrl+
		case 0x208: // "Backspace"
			break;

		case 0x20d: // "Enter"
			break;

		case 0x221: // PageUp
			CmdKeyPageUp(false);
			break;

		case 0x222: // PageDown
			CmdKeyPageDown(false);
			break;


		case 0x225: // ""
			CmdKeyPageUp(false);
			break;

		case 0x226: // ""
			break;

		case 0x227: // ""
			CmdKeyPageDown(false);
			break;

		case 0x228: // ""
			break;

		case 0x230: // "0"
			break;
		case 0x231: // "1"
			break;
		case 0x232: // "2"
			break;
		case 0x233: // "3"
			break;
		case 0x234: // "4"
			break;
		case 0x235: // "5"
			break;
		case 0x236: // "6"
			break;
		case 0x237: // "7"
			break;
		case 0x238: // "8"
			break;
		case 0x239: // "9"
			break;

		case 0x260: // "0" eL[
			break;
		case 0x261: // "1"
			break;
		case 0x262: // "2"
			break;
		case 0x263: // "3"
			break;
		case 0x264: // "4"
			break;
		case 0x265: // "5"
			break;
		case 0x266: // "6"
			break;
		case 0x267: // "7"
			break;
		case 0x268: // "8"
			break;
		case 0x269: // "9"
			break;

		case 0x241: // "A"
			CmdKeyCtrlA();
			break;

		case 0x243: // "C"
			CmdKeyCtrlC();
			break;

		case 0x246: // "F"
			CmdKeyFind();
			break;

		case 0x256: // "V"
			CmdKeyCtrlVRunannsView();
			break;

	}
}

void CannsView::CmdKeyCtrlVRunannsView()
{
	HWND hwnd = 0;

	EnumWindows((WNDENUMPROC)&EnumWindProcannsFMtextExe, (LPARAM)&hwnd);

	if (hwnd != 0) {

		
		int nNeedLength = ::GetWindowTextLength(hwnd);
		nNeedLength += 8;


		LPTSTR lpBuffer = new TCHAR[nNeedLength];

		ZeroMemory(lpBuffer, nNeedLength * sizeof(TCHAR));
		if (::GetWindowText(hwnd, lpBuffer, nNeedLength))
		{
			CString sTitle;
			sTitle.Format(_T("%s"), lpBuffer);
			int n = sTitle.Find(m_sFullFileName);
			if (n >= 0) {
				::SetForegroundWindow(hwnd);
			}
			else {
				m_pViewFrame->m_pwndFile->RunannsFMtextExe(m_sFullFileName);
			}
		}

		delete[] lpBuffer;

		

	} else {
		m_pViewFrame->m_pwndFile->RunannsFMtextExe(m_sFullFileName);
	}


}

// es̃obt@ł̊JnʒuEBhEvZ
void CannsView::CalcLinePoint(void)
{
	if ( m_FileSize == 0 ) return;

	unsigned char* pc;
	pc = m_pcFile;
	bool end = false;
	bool cset = true;
	UINT tcount = 0;
	int ct = 0;	// pZ̕
	UINT line = 0;	// s
	UINT num = 0;	// 
	unsigned char c0, c1, ce;
	int ntab = m_pFmParam->m_ViewTabNum - 1;

//	m_nFindLineNo = -1;
//	m_nFindCharNo = -1;

	if ( m_CharCode == CC_SJIS ) {

		int tb = ntab;
		while( !end ) {

			if ( cset ) {
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
				line++;
				ct = 0;
				num = 0;
				cset = false;
				tb = ntab;
			}

			c0 = *pc;

			num++;
			pc++;
			tcount++;
			ct++;

			if ( c0 < 0x80 ) {	// 1byte
				if ( c0 == 0x09 ) {
					ct += tb;
					tb = ntab;
				} else {
					if ( c0 == 0x0d ) {
						c1 = *pc;
						if ( c1 != 0x0a ) {
							cset = true;
						}
						num--;
						ct--;
					} else {
						if ( c0 == 0x0a ) {
							cset = true;
							num--;
							ct--;
						} else {
							tb--;
							if ( tb < 0 ) tb = ntab;
						}
					}
				}

			} else {
				if ( (c0 < 0xa0) || (c0 > 0xdf) ) {	// 2byte

					tcount++;
					ct++;
					pc++;
					num++;
					tb -- ;
					if ( tb < 0 ) tb = ntab;
					tb -- ;
					if ( tb < 0 ) tb = ntab;
				}

			}

			if ( ct > m_LineCharNum ) cset = true;

			if ( (tcount >= m_ReadFileSize) || (line == MAX_LINE - 1 ) ) {
				end = true;
//				if ( !cset ) {
					if ( line != 0 ) {
						m_pCharLine[line - 1] = num;
					}
					m_pLinePoint[line] = tcount;
//				}
			}
		}
		m_MaxLineNormalMode = line;
	}
	if ( m_CharCode == CC_UNICODE ) {
		char ctmp;
		int tb = ntab;

		while( !end ) {

			if ( cset ) {
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
				line++;
				ct = 0;
				num = 0;
				cset = false;
				tb = ntab;
			}

			c0 = *pc;
			pc++;
			c1 = *pc;
			pc++;
			if ( m_Endian ) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}
			num++;


			if ( (c1 == 0) && (c0 == 0x0a) ) {
				cset = true;
				num--;
			}
			if ( (c1 == 0) && (c0 == 0x0d) ) {
				c0 = *pc;
				c1 = *(pc + 1);
				if ( m_Endian ) {
					ctmp = c0;
					c0 = c1;
					c1 = ctmp;
				}
				if ( (c1 == 0) && (c0 != 0x0a) ) cset = true;
				num--;
			}
			if ( (c1 == 0) && (c0 < 0x80) ) {
				ct++;
				if ( c0 == 0x09 ) {
					ct += tb;
					tb = ntab;
				} else {
					tb--;
					if ( tb < 0 ) tb = ntab;
				}
			} else {
				ct += 2;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
			}

			if ( ct > m_LineCharNum ) cset = true;

			tcount += 2;
			if ( (tcount >= m_ReadFileSize) || (line == MAX_LINE - 1 ) ) {
				end = true;
//				if ( !cset ) {
					if ( line != 0 ) {
						m_pCharLine[line - 1] = num;
					}
					m_pLinePoint[line] = tcount;
//				}
			}
		}
		m_MaxLineNormalMode = line;
	}
/*
[ JISR[h GXP[vV[PX ]

3		؂ւ	V[PX
V[PX	R[h		R[h(16i)
------------------------------------------
[ESC] ( B	ASCII			0x1b 0x28 0x42
[ESC] ( J	JIS[}		0x1b 0x28 0x4a
[ESC] $ @	JIS-1978		0x1b 0x24 0x40
[ESC] $ B	JIS-1983		0x1b 0x24 0x42
*/

	if ( m_CharCode == CC_JIS ) {
		bool wc = false;	// false:1byteR[h   true:2byteR[h

		int tb = ntab;
		while( !end ) {


			if ( cset ) {
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
				line++;
				ct = 0;
				num = 0;
				cset = false;
				tb = ntab;
			}

			c0 = *pc;

			num++;
			pc++;
			tcount++;
			ct++;

			if ( c0 == 0x1b ) {
				ce = *pc;
				pc++;
				pc++;
				tcount++;
				tcount++;
				if ( ce == 0x28 ) wc = false;
				else wc = true;
				num--;
				ct--;
				continue;
			}

			if ( wc ) {	// 2byte
				pc++;
				ct++;
				tcount++;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
			} else {
				if ( c0 == 0x0d ) {
					c1 = *pc;
					if ( c1 == 0x0a ) {
						pc++;
						tcount++;
					}
					cset = true;
					num--;
					ct--;
				}
				else {
					if (c0 == 0x0a) {
						cset = true;
						num--;
						ct--;
					}
				}
				if (c0 == 0x09) {
					ct += tb;
					tb = ntab;
				}
				else {
					tb--;
					if (tb < 0) tb = ntab;
				}

			}

			if ( ct > m_LineCharNum ) cset = true;

			if ( (tcount >= m_ReadFileSize) || (line == MAX_LINE - 1 ) ) {
				end = true;
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
			}
		}
		m_MaxLineNormalMode = line;
	}

/*
EUC
Zbg  	1oCg  	2oCg  	3oCg  	{EUC̏ꍇ
G0		0x21`0x7E 	- 			- 			ASCII
G1		0xA0`0xFF 	0xA0`0xFF 	- 			JIS X 0208-1990iVJISj
G2		0x8E 		0xA0`0xFF 	- 			JIS X 0201Jii1oCgj
G3		0x8F 		0xA0`0xFF 	0xA0`0xFF 	JIS X 0212-1990i⏕j
*/

	if ( m_CharCode == CC_EUC ) {

		int tb = ntab;
		while( !end ) {

			if ( cset ) {
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
				line++;
				ct = 0;
				num = 0;
				cset = false;
				tb = ntab;
			}

			c0 = *pc;

			num++;
			pc++;
			tcount++;
			ct++;

			if ( c0 == 0x8e ) {	// 2byteR[h
				pc++;
				tcount++;
				ct++;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
				continue;
			}

			if ( c0 == 0x8f ) {	// 3byteR[h
				pc++;
				pc++;
				tcount++;
				tcount++;
				ct++;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
				continue;
			}

			if ( (c0 >= 0xa0) && (c0 <= 0xff)) {	// 2byte
				pc++;
				tcount++;
				ct++;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
			} else {
				if ( c0 == 0x0d ) {
					c1 = *pc;
					if ( c1 != 0x0a ) {
						cset = true;
					}
					num--;
					ct--;
				}
				if ( c0 == 0x0a ) {
					cset = true;
					num--;
					ct--;
				}
				if ( c0 == 0x09 ) {
					ct += tb;
					tb = ntab;
				} else {
					tb--;
					if ( tb < 0 ) tb = ntab;
				}

			}

			if ( ct > m_LineCharNum ) cset = true;

			if ( (tcount >= m_ReadFileSize) || (line == MAX_LINE - 1 ) ) {
				end = true;
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
			}
		}
		m_MaxLineNormalMode = line;
	}

/*

UTF-8

(00-7f)
(c0-df)(80-bf)
(e0-ef)(80-bf)(80-bf)
(f0-f7)(80-bf)(80-bf)(80-bf)
(f8-fb)(80-bf)(80-bf)(80-bf)(80-bf)
(fc-fd)(80-bf)(80-bf)(80-bf)(80-bf)(80-bf)

*/

	if ( m_CharCode == CC_UTF8 ) {

		int tb = ntab;
		while( !end ) {

			if ( cset ) {
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
				line++;
				ct = 0;
				num = 0;
				cset = false;
				tb = ntab;
			}

			c0 = *pc;

			num++;
			pc++;
			tcount++;
			ct++;

			if ( (c0 >= 0xc0) && (c0 <= 0xdf)) {	// 2byte
				pc++;
				tcount++;
				ct++;
				if ( ct > m_LineCharNum ) cset = true;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
				continue;
			}

			if ( (c0 >= 0xe0) && (c0 <= 0xef)) {	// 3byte
				pc += 2;
				tcount += 2;
				ct++;
				if ( ct > m_LineCharNum ) cset = true;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
				continue;
			}
			if ( (c0 >= 0xf0) && (c0 <= 0xf7)) {	// 4byte
				pc += 3;
				tcount += 3;
				ct++;
				if ( ct > m_LineCharNum ) cset = true;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
				continue;
			}

			if ( (c0 >= 0xf8) && (c0 <= 0xfb)) {	// 5byte
				pc += 4;
				tcount += 4;
				ct++;
				if ( ct > m_LineCharNum ) cset = true;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
				continue;
			}

			if ( (c0 >= 0xfc) && (c0 <= 0xfd)) {	// 6byte
				pc += 5;
				tcount += 5;
				ct++;
				if ( ct > m_LineCharNum ) cset = true;
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
				continue;
			}


			if (c0 == 0x09) {
				ct += tb;
				tb = ntab;
			}
			else {
				if (c0 == 0x0d) {
					c1 = *pc;
					if (c1 != 0x0a) {
						cset = true;
					}
					num--;
					ct--;
				}
				else {
					if (c0 == 0x0a) {
						cset = true;
						num--;
						ct--;
					}
					else {
						tb--;
						if (tb < 0) tb = ntab;
					}
				}
			}


			/*
			if ( c0 == 0x0d ) {
				c1 = *pc;
				if ( c1 != 0x0a ) {
					cset = true;
				}
				num--;
				ct--;
			}
			if ( c0 == 0x0a ) {
				cset = true;
				num--;
				ct--;
			}
			if ( c0 == 0x09 ) {
				ct += tb;
				tb = ntab;
			} else {
				tb--;
				if ( tb < 0 ) tb = ntab;
			}
			*/

			if ( ct > m_LineCharNum ) cset = true;

			if ( (tcount >= m_ReadFileSize) || (line == MAX_LINE - 1 ) ) {
				end = true;
				if ( line != 0 ) {
					m_pCharLine[line - 1] = num;
				}
				m_pLinePoint[line] = tcount;
			}
		}
		m_MaxLineNormalMode = line;
	}

// UTF7
	if ( m_CharCode == CC_UTF7 ) {
		bool wc = false;
		int wnum = 0;
		int LineFlag = -1;
		int tb = ntab;

		while( !end ) {

			if ( cset ) {
				if ( line != 0 ) {
					int n = wnum / 2;
					num = num + n;
					m_pCharLine[line - 1] = num;
				}
				m_pUTF7LineFlag[line] = LineFlag;
				m_pLinePoint[line] = tcount;
				line++;
				ct = 0;
				num = 0;
				wnum = 0;
				cset = false;
				tb = ntab;
			}

			c0 = *pc;

			pc++;
			tcount++;

			if ( !wc && (c0 == 0x2b) ) {	// '+'
				if ( *(pc +1) != 0x2d ) {
					LineFlag = 0;
					wc = true;
					continue;
				}
			}
			if ( c0 == 0x2d ) {	// '-'
				LineFlag = -1;
				wc = false;
				continue;
			}

			if ( wc ) {	// 2byte
				if ( LineFlag == 0 ) LineFlag = 1;
				else LineFlag = 0;

				pc++;
				tcount++;

				if ( *pc != 0x2d ) {
					pc++;
					tcount++;
					if ( *pc != 0x2d ) {
						pc++;
						tcount++;
						wnum += 3;
						ct += 3;
					} else {
						wnum += 2;
						ct += 2;
					}
				} else {
					wnum++;
					ct++;
				}
				tb--;
				if ( tb < 0 ) tb = ntab;
				tb--;
				if ( tb < 0 ) tb = ntab;
			} else {
				num++;
				if ( c0 == 0x0d ) {
					c1 = *pc;
					if ( c1 != 0x0a ) {
						cset = true;
					}
					num--;
				}
				if ( c0 == 0x0a ) {
					cset = true;
					num--;
				}
				if ( c0 == 0x09 ) {
					ct += tb;
					tb = ntab;
				} else {
					tb--;
					if ( tb < 0 ) tb = ntab;
				}
				ct++;

			}

			if ( ct > m_LineCharNum ) {
				cset = true;
			}

			if ( (tcount >= m_ReadFileSize) || (line == MAX_LINE - 1 ) ) {
				end = true;
				if ( line != 0 ) {
					int n = wnum / 2;
//					int n2 = wnum % 2;
					num = num + n;
					m_pCharLine[line - 1] = num;
				}
				m_pUTF7LineFlag[line] = LineFlag;
				m_pLinePoint[line] = tcount;
			}
		}
		m_MaxLineNormalMode = line;
	}
	m_MaxLine = m_MaxLineNormalMode;
	m_pLinePoint[line] = m_ReadFileSize;

}

// L[R}h ==================================

// Cmd No 0x0d
void CannsView::CmdKeyEnter(void)
{
	CmdKeyQuit();
}

// Cmd No 0x20
void CannsView::CmdKeySpace(void)
{
}

// Cmd No 0x21
void CannsView::CmdKeyPageUp(bool bHalf)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta = m_PageLineNum / 2;

	if (!bHalf) delta = m_PageLineNum - 1;

	int next = m_FirstLine - delta;

	if ( next < 0 ) delta = m_FirstLine;
	m_FirstLine -= delta;
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x22
void CannsView::CmdKeyPageDown(bool bHalf)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta = m_PageLineNum / 2;

	if (!bHalf) delta = m_PageLineNum - 1;

	UINT next = m_FirstLine + delta;
	UINT last = m_MaxLine - m_PageLineNum;

	if ( next > last ) delta = last - m_FirstLine;
	m_FirstLine += delta;
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x23
void CannsView::CmdKeyEnd(void)
{
	if ( m_FileSize == 0 ) return;
	int line = m_MaxLine - m_PageLineNum;
	if ( line < 0 ) return;
	m_FirstLine = line;
	Invalidate();
}
// Cmd No 0x24
void CannsView::CmdKeyHome(void)
{
	if ( m_FileSize == 0 ) return;
	m_FirstLine = 0;
	Invalidate();
}


// Cmd No 0x25
void CannsView::CmdKeyLeft(void)
{
	CmdKeyPageUp();
}

// Cmd No 0x27
void CannsView::CmdKeyRight(void)
{
	CmdKeyPageDown();
}

// Cmd No 0x26
void CannsView::CmdKeyUp(void)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta;
	delta = m_pFmParam->m_ViewDeltaLine;
	if ( m_FirstLine < delta ) {
		delta = m_FirstLine;
	}
	m_FirstLine -= delta; 
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x27
void CannsView::CmdKeyDown(void)
{
	if ( m_FileSize == 0 ) return;

	if ( m_MaxLine <= (UINT)m_PageLineNum ) return;
	UINT delta;
	delta = m_pFmParam->m_ViewDeltaLine;
	UINT last = m_FirstLine + delta + m_PageLineNum;
	if ( last > m_MaxLine ) {
		m_FirstLine = m_MaxLine  - m_PageLineNum;
	} else m_FirstLine += delta; 
	if ( delta != 0 ) Invalidate();
}

// Cmd No 0x30 - 0x39
void CannsView::CmdKeyNumber(UINT uCmdNo)
{
	if ( m_FileSize == 0 ) return;

	m_nFindLineNo = -1;
	m_nFindCharNo = -1;

	switch( uCmdNo ) {
		case 0x30:
		break;
		case 0x31:
		break;
		case 0x32:
		break;

		case 0x33:
			m_CharCode = CC_SJIS;
		break;

		case 0x34:
			m_CharCode = CC_JIS;
		break;

		case 0x35:
			m_CharCode = CC_EUC;
		break;

		case 0x36:
			m_CharCode = CC_UNICODE;
		break;

		case 0x37:
			m_CharCode = CC_UTF7;
		break;

		case 0x38:
			m_CharCode = CC_UTF8;
		break;

		case 0x39:
		break;
	}
	m_MaxLine = m_MaxLineNormalMode;
	CalcLinePoint();
	Invalidate();
	m_pViewFrame->DrawFileName();

//	CRect rc;
//	GetWindowRect(&rc);
//	ScreenToClient(&rc);
//	rc.left = rc.right - m_ScrollBarHeight;
//	m_pScrollBar->MoveWindow(&rc);
	SetScrollData();
}

// Cmd No 0x46
void CannsView::CmdKeyFind(void)
{
	CFindStringDialog dlg(this);

	dlg.m_pFmParam = m_pFmParam;

	int ret = dlg.DoModal();

	if ( ret == IDOK ) {

		m_sFindString = dlg.m_sFindEdit;

		m_nFindLineNo = -1;
		m_nFindStartLine = 0;
		int mode = 0;

		if ( dlg.m_bUpSerchCheck ) {
			mode = -1;
			m_nFindStartLine = m_MaxLine;
		}

		m_bCase = dlg.m_bCapsCheck;
		bool br = FindString(mode, m_bCase);

		if ( br ) {
			int nfl = m_nFindLineNo - 3;
			if ( nfl < 0 ) m_FirstLine = 0;
			else {
				if ( m_MaxLine > (UINT)m_PageLineNum ) m_FirstLine = nfl;
			}
			Invalidate();
		} else {
			CString s;
			s = _T("w肳ꂽ͌܂ł");
			MessageBox(s, _T("̌"));
		}
	}
}

// Cmd No 0x51
void CannsView::CmdKeyQuit(void)
{
	m_pViewFrame->DestroyWindow();
}

// Cmd No 0x54
void CannsView::CmdKeyFindPrev(void)
{
	if ( m_nFindLineNo == -1 ) return;

	bool br = FindString(-2, m_bCase);

	if ( br ) {
		int nfl = m_nFindLineNo - 3;
		if ( nfl < 0 ) m_FirstLine = 0;
		else {
			if ( m_MaxLine > (UINT)m_PageLineNum ) m_FirstLine = nfl;
		}
		Invalidate();
	} else {
		CString s;
		s = _T("w肳ꂽ͌܂ł");
		MessageBox(s, _T("̌"));
	}
}

// Cmd No 0x56
void CannsView::CmdKeyFindNext(void)
{
	if ( m_nFindLineNo == -1 ) return;

	bool br = FindString(1, m_bCase);

	if ( br ) {
		int nfl = m_nFindLineNo - 3;
		if ( nfl < 0 ) m_FirstLine = 0;
		else {
			if ( m_MaxLine > (UINT)m_PageLineNum ) m_FirstLine = nfl;
		}
		Invalidate();
	} else {
		CString s;
		s = _T("w肳ꂽ͌܂ł");
		MessageBox(s, _T("̌"));
	}
}

// Cmd No 0x10d Shift Enter
void CannsView::CmdKeyShiftEnter(void)
{
	CString cpath, fname, cfname, tmp, sEditor;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = m_pFmParam->m_pw64FindData[m_pViewFrame->m_pwndFile->m_CurrentFileNo].name;

	tmp = _T("open");
	cfname = _T("\"");
	cfname += cpath;
	cfname += fname;
	cfname += _T("\"");
	
//	sEditor = m_pFmParam->m_sToolEditor;
	sEditor = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolEditor);

	ShellExecute(m_pViewFrame->m_pwndFile->m_hWnd, tmp, sEditor, cfname, cpath, SW_SHOW);
	CmdKeyQuit();

}

void CannsView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	/*

	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_TRACKPOS;

//	m_pScrollBar->GetScrollInfo(&info);
	nPos = info.nTrackPos;

	switch(nSBCode) {
		case SB_LINEUP:	// XN[{bNX̏NbNꍇ
			CmdKeyUp();
			break;

		case SB_LINEDOWN:	// XN[{bNX̉NbNꍇ
			CmdKeyDown();
			break;

		case SB_PAGEUP:		// XN[{bNX̏㑤NbNꍇi܂PageUpL[j
			CmdKeyPageUp();
			break;

		case SB_PAGEDOWN:		// XN[{bNX̉NbNꍇi܂PageDownL[j
			CmdKeyPageDown();
			break;

		case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
			break;

		case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
			if ( m_FirstLine != nPos ) {
				m_FirstLine = nPos;
				Invalidate();
			}
			break;

	}
	*/

//	CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}



BOOL CannsView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( zDelta > 0 ) CmdKeyUp();
	else CmdKeyDown();

	return 0;

//	return CWnd::OnMouseWheel(nFlags, zDelta, pt);
}

void CannsView::OnMenuKey3()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x33);
}

void CannsView::OnMenuKey4()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x34);
}

void CannsView::OnMenuKey5()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x35);
}

void CannsView::OnMenuKey6()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x36);
}

void CannsView::OnMenuKey7()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x37);
}

void CannsView::OnMenuKey8()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyNumber(0x38);
}

void CannsView::OnMenuKeyA()
{
	// TODO: ɃR}h nh R[hǉ܂B

	if ( m_FileSize == 0 ) return;

	m_CurrentPage = 0;
	m_PageLineNum = 0;
	m_MaxLine = 0;
	m_MaxLineNormalMode = 0;
	m_FirstLine = 0;
	m_LineCharNum = 0;
	m_OfsetLeft = 5;
	m_CharCode = CC_SJIS;
	m_Endian = false;

	CRect rc;
	GetClientRect(&rc);

	CFont font;
	CFont* pOldFont;
	int fw, fh;
//	CClientDC dc = CClientDC(this);
	CDC* dc = GetDC();

	font.CreateFontIndirect(&(m_pFmParam->m_logfontView));
	pOldFont = dc->SelectObject(&font);

	CString ss;
	ss = _T("A");
	CSize size = dc->GetTextExtent( ss );
	dc->SelectObject(pOldFont);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	int w;
//	w = rc.Width() - m_ScrollBarHeight;
	w = rc.Width();
	m_LineCharNum =  w / fw - 3;	// 1s̕\(pZ)
	m_PageLineNum = rc.Height() / fh;	// 1y[W̕\s

	CheckAutoCharCode();

	CmdKeyNumber(0);

	SetScrollData();

	ReleaseDC(dc);
}

void CannsView::DrawHexMode(void)
{
	CClientDC dc(this);

	//	if ( m_FileSize == 0 ) return;

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	pOldFont = dc.SelectObject(&font);

	CString ss;
	ss = "W";
	CSize size = dc.GetTextExtent(ss);

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;

	COLORREF colview = m_pFmParam->m_colViewText;

	dc.SetBkColor(m_colBack);

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colViewRetMark);
	CPen* pOldPen = dc.SelectObject(&pen);

	int x, y;
	UINT line = 0;
	unsigned char *cc, *cc2;

	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];

	CStringA s, sLine, form, s0, s8, s07, s8f, s16b;
	int nAdd = 0;
	int adstep = 16;
	//	m_MaxLineHexMode = (UINT)(m_FileSize / adstep) + 1;
	ULONGLONG nData = 0;

	form = "%08x  %-24s- %-24s |  %-16s  |";

	x = m_OfsetLeft;
	y = 0;

	dc.SetTextColor(colview);

	for (int i = 0; i < m_PageLineNum; i++) {
		line = m_FirstLine + i;
		if (line == m_MaxLineHexMode) break;

		//		cc = m_pcFile + m_pLinePoint[line];
		cc = m_pcFile + (line * adstep);
		cc2 = cc;
		int nl = adstep;
		memcpy(cbuf, "                ", nl);
		cbuf[nl] = 0;

		nAdd = line * adstep;
		nData = line * adstep;

		s07 = "";
		for (int i = 0; i < 8; i++) {
			if (nData == m_FileSize) break;
			s0.Format("%02x ", (int)*cc2);
			s07 += s0;
			cbuf[i] = *cc2;
			if (*cc2 < 0x20) cbuf[i] = '.';
			cc2++;
			nData++;
		}

		cc2 = cc + 8;
		s8f = _T("");
		for (int i = 8; i < 16; i++) {
			if (nData == m_FileSize) break;
			s8.Format("%02x ", (int)*cc2);
			s8f += s8;
			cbuf[i] = *cc2;
			int cn = (int)*cc2;
			if (cn < 0x20) {
				cbuf[i] = '.';
			}
			cc2++;
			nData++;
		}

		if (m_FileSize < 17L) {
			nl = (int)m_FileSize;
		}

		cbuf[nl] = 0;
		s16b.Format("%s", cbuf);
		sLine.Format(form, nAdd, s07, s8f, s16b);

		TextOutA(dc.m_hDC, x, y, (LPCSTR)sLine, sLine.GetLength());
		nAdd += adstep;
		//		cc += adstep;
		y += fh;

	}

	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = (int)(m_MaxLineHexMode / m_PageLineNum);
	if (maxpage > 0) {
		//		m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->m_pScrollBar->SetScrollPos(m_FirstLine);
		m_pViewFrame->DrawLineNumber();
	}
	delete[]cbuf;
}

// t}`oCg
// sSrc : 镶(s)
// sFindStr : 镶
// nStart : Jnʒu(s̐擪ɌČ) -1̏ꍇ͍s̍Ōォ
// ߂l : ꍇA擪̕ʒu  Ȃꍇ-1
int CannsView::FindStrReversA(CStringA sSrc, CStringA sFindStr, int nStart)
{
	int ret = -1;	// Ȃꍇ-1Ԃ
	CStringA ssr, ssr2;
	int start = nStart;
	int fslen = sFindStr.GetLength() - 1;


	if ( nStart == 0 ) return ret;	// Jnʒus̐擪Ȃ-1Ԃ
	int slen = sSrc.GetLength();
	if ( slen == 0 ) return ret;	// ̒0Ȃ-1Ԃ
	if ( nStart == -1 ) start = slen;

	ssr = sSrc.Left(start + fslen);	// ʒuO̕𒊏o
	int nf = ssr.Find(sFindStr);
	if ( nf < 0 ) return ret;	// ܂܂ĂȂ-1Ԃ

	ret = nf;	// ̂Ŗ߂l͂̎_Ő擪̌vʒu

	int nf2 = nf + 1;	// vʒu̎̕Č


	while ( nf2 < slen ) {
		int nf3 = ssr.Find(sFindStr, nf2);
		if ( nf3 < 0 ) break;	// Ȃbreak
		ret = nf3;
		nf2 = nf3 + 1;
	
	}

	return ret;

}

// tCh
// sSrc : 镶(s)
// sFindStr : 镶
// nStart : Jnʒu(s̐擪ɌČ) -1̏ꍇ͍s̍Ōォ
// ߂l : ꍇA擪̕ʒu  Ȃꍇ-1
int CannsView::FindStrReversW(CString sSrc, CString sFindStr, int nStart)
{
	int ret = -1;	// Ȃꍇ-1Ԃ
	CString ssr, ssr2;
	int start = nStart;
	int fslen = sFindStr.GetLength() - 1;


	if ( nStart == 0 ) return ret;	// Jnʒus̐擪Ȃ-1Ԃ
	int slen = sSrc.GetLength();
	if ( slen == 0 ) return ret;	// ̒0Ȃ-1Ԃ
	if ( nStart == -1 ) start = slen;

	ssr = sSrc.Left(start + fslen);	// ʒuO̕𒊏o
	int nf = ssr.Find(sFindStr);
	if ( nf < 0 ) return ret;	// ܂܂ĂȂ-1Ԃ

	ret = nf;	// ̂Ŗ߂l͂̎_Ő擪̌vʒu

	int nf2 = nf + 1;	// vʒu̎̕Č


	while ( nf2 < slen ) {
		int nf3 = ssr.Find(sFindStr, nf2);
		if ( nf3 < 0 ) break;	// Ȃbreak
		ret = nf3;
		nf2 = nf3 + 1;
	
	}

	return ret;

}

// ̌
// fmode -2:݈ʒu  -1:  0:  1:݈ʒu牺
// nocaps true:啶ʂ
// 񂪌ꍇtrueԂ
bool CannsView::FindString(int fmode, bool nocaps)
{
	CClientDC dc(this);

	if ( m_FileSize == 0 ) return false;

	if ( m_bHexMode ) {
		return false;
	}
//	UINT line = 0;
	unsigned char *cc, *cc2;
	unsigned char c0, ctmp;

	UINT jcode, sjcode;
	int clen;
	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE];

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A;
	CStringA sSP = "  ";
	sA2.Format("%c", 0x09);

	CString sFind1, sFind2;
	CString sW, sW2;
	CString sSPW = _T("  ");
	sW2.Format(_T("%c"), 0x09);

	while ( ntab != 0 ) {
		sSP += " ";
		sSPW += _T(" ");
		ntab--;
	}

	int nStartLine;
	int nStep;
	int nEndLine;
	int nStartCharNo;

	if ( fmode == 0 ) {	// 
		nStartLine = 0;	// Jns
		nEndLine = m_MaxLine;	// Is(ŏIs+1)
		nStep = 1;	// s
		nStartCharNo = 0;	// Jnʒu(Jns̐擪̕) Ȃ̂0
	}
	if ( fmode == 1 ) {	// ݈ʒu牺
		nStep = 1;	// s
		nStartLine = m_nFindLineNo;
		nEndLine = m_MaxLine;	// Is(ŏIs+1)
		nStartCharNo = m_nFindCharNo + 1;	// Jnʒu(Jns̐擪̕) ݈ʒu+1
	}
	if ( fmode == -1 ) {	// 
		nStartLine = m_MaxLine - 1;
		nStep = -1;	// s
		nEndLine = -1;	//  Is(擪s-1)
		nStartCharNo = -1;	// Jnʒu(Jns̐擪̕)
							// Ȃ̂ł̍s̍ŏIʒu(FindStrReversŕ̒ݒ)
	}
	if ( fmode == -2 ) {	// ݈ʒu
		nStartLine = m_nFindLineNo;
		nStep = -1;	// s
		nEndLine = -1;	//  Is(擪s-1)
		nStartCharNo = m_nFindCharNo;	// Jnʒu(Jns̐擪̕) ݈ʒu
	}


	bool bFind = false;


	for ( int i = nStartLine; i != nEndLine; i += nStep ) {

		if ( fmode == 1 ) {	// ݈ʒu牺
			if ( i != nStartLine ) nStartCharNo = 0;	// JnsȊO͍s̐擪
		}
		if ( fmode == -2 ) {	// ݈ʒu
			if ( i != nStartLine ) nStartCharNo = -1;	// JnsȊO͍s̍ŏIʒu
		}

		if ( m_CharCode == CC_SJIS ) {
			cc = m_pcFile + m_pLinePoint[i];

			if ( m_pCharLine[i] != 0 ) {
				int sl = m_pLinePoint[i + 1] - m_pLinePoint[i];
				memcpy(cbuf, cc, sl);
				cbuf[sl] = 0;
				unsigned char *dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
				ReplaceTab(cbuf, dbuf, sl);
				sA.Format("%s", dbuf);
				delete []dbuf;

				sl = sA.GetLength();
				if ( sA.GetAt(sl - 1) == 0x0a ) sl--;
				if ( sA.GetAt(sl - 1) == 0x0d ) sl--;

				sFind1A = CT2A(m_sFindString);
				if ( !nocaps ) {
					sFind1A.MakeUpper();
					sA.MakeUpper();
				}

				int nf;
				if ( fmode < 0 ) {
					nf = FindStrReversA(sA, sFind1A, nStartCharNo);
				} else {
					nf = sA.Find(sFind1A, nStartCharNo);
				}
				if ( nf < 0 ) continue;


				m_nFindLineNo = i;
				m_nFindCharNo = nf;
				bFind = true;
				break;
			}

		}

		if ( m_CharCode == CC_UNICODE ) {

			cc2 = m_pcFile + m_pLinePoint[i];
			int sl = m_pLinePoint[i + 1] - m_pLinePoint[i];
			memcpy(cbuf, cc2, sl);
			cbuf[sl] = 0;
			cbuf[sl + 1] = 0;

			unsigned char *dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
			ReplaceTab(cbuf, dbuf, sl);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete []dbuf;

			sl = sW.GetLength();

			if ( m_pCharLine[i] != 0 ) {

				sFind1 = m_sFindString;
				if ( !nocaps ) {
					sFind1.MakeUpper();
					sW.MakeUpper();
				}

				int nf;
				if ( fmode < 0 ) {
					nf = FindStrReversW(sW, sFind1, nStartCharNo);
				} else {
					nf = sW.Find(sFind1, nStartCharNo);
				}
				if ( nf < 0 ) continue;


				m_nFindLineNo = i;
				m_nFindCharNo = nf;
				bFind = true;
				break;


			}
		}

		if ( m_CharCode == CC_JIS ) {

			cc = m_pcFile + m_pLinePoint[i];
			clen = m_pCharLine[i];

			if ( clen != 0 ) {
				int ib = 0;
				bool wc = false;
				while ( clen != 0 ) {
					if ( *cc == 0x1b ) {
						cc++;
						if ( *cc == 0x28 ) wc = false;
						else wc = true;
						cc += 2;
						continue;
					}

					if ( wc ) {	// 2byte
						jcode = ((UINT)(*cc) * 0x100);
						cc++;
						jcode += (UINT)(*cc);
						cc++;
						sjcode = _mbcjistojms(jcode);
						cbuf[ib] = (unsigned char)((sjcode & 0xff00) / 0x100);
						ib++;
						cbuf[ib] = (unsigned char)(sjcode & 0xff);
						ib++;

					} else {
						cbuf[ib] = *cc;
						cc++;
						ib++;
					}

					clen--;

				}
				cbuf[ib] = 0;
				sA.Format("%s", cbuf);

				int sl = sA.GetLength();

				unsigned char *dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
				ReplaceTab(cbuf, dbuf, sl);
				sA.Format("%s", dbuf);
				delete []dbuf;

				sl = sA.GetLength();
				if ( sA.GetAt(sl - 1) == 0x0a ) sl--;
				if ( sA.GetAt(sl - 1) == 0x0d ) sl--;

				sFind1A = CW2A(m_sFindString);
				if ( !nocaps ) {
					sFind1A.MakeUpper();
					sA.MakeUpper();
				}

				int nf;
				if ( fmode < 0 ) {
					nf = FindStrReversA(sA, sFind1A, nStartCharNo);
				} else {
					nf = sA.Find(sFind1A, nStartCharNo);
				}
				if ( nf < 0 ) continue;


				m_nFindLineNo = i;
				m_nFindCharNo = nf;
				bFind = true;
				break;

			}
		}

		if ( m_CharCode == CC_EUC ) {

			cc = m_pcFile + m_pLinePoint[i];
			clen = m_pCharLine[i];
			if ( clen != 0 ) {
				int ib = 0;
				while ( clen != 0 ) {
					bool wc = false;
					if ( *cc == 0x8e ) {
						cc++;
						cbuf[ib] = *cc;
						cc++;
						continue;
					}
					if ( *cc == 0x8f ) {
						cc++;
						wc = true;
					}
					if ( (*cc >= 0xa0) && (*cc <= 0xff) ) {
						wc = true;
					}

					if ( wc ) {	// 2byte
						ctmp = *cc & 0x7f;
						jcode = ((UINT)ctmp * 0x100);
						cc++;
						ctmp = *cc & 0x7f;
						jcode += (UINT)ctmp;
						cc++;
						sjcode = _mbcjistojms(jcode);
						cbuf[ib] = (unsigned char)((sjcode & 0xff00) / 0x100);
						ib++;
						cbuf[ib] = (unsigned char)(sjcode & 0xff);
						ib++;

					} else {
						cbuf[ib] = *cc;
						cc++;
						ib++;
					}

					clen--;

				}
				cbuf[ib] = 0;
				sA.Format("%s", cbuf);
//				sA.Replace(sA2, sSP);

				int sl = sA.GetLength();
				unsigned char *dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
				ReplaceTab(cbuf, dbuf, sl);
				sA.Format("%s", dbuf);
				delete []dbuf;

				sl = sA.GetLength();
				if ( sA.GetAt(sl - 1) == 0x0a ) sl--;
				if ( sA.GetAt(sl - 1) == 0x0d ) sl--;

				sFind1A = CW2A(m_sFindString);
				if ( !nocaps ) {
					sFind1A.MakeUpper();
					sA.MakeUpper();
				}

				int nf;
				if ( fmode < 0 ) {
					nf = FindStrReversA(sA, sFind1A, nStartCharNo);
				} else {
					nf = sA.Find(sFind1A, nStartCharNo);
				}
				if ( nf < 0 ) continue;


				m_nFindLineNo = i;
				m_nFindCharNo = nf;
				bFind = true;
				break;

			}
		}

		if ( m_CharCode == CC_UTF8 ) {

			cc = m_pcFile + m_pLinePoint[i];
			clen = m_pCharLine[i];
			if ( clen != 0 ) {
				int ib = 0;
				int len = 0;
				int ntab = 0;
				while ( clen != 0 ) {
					c0 = *cc;
					cbuf[ib] = c0;
					if ( c0 == 0x09 ) ntab++;
					len++;
					if ( (c0 >= 0xc0) && (c0 <= 0xdf)) {	// 2byte
						cc++;
						ib++;
						cbuf[ib] = *cc;
						len++;
					}

					if ( (c0 >= 0xe0) && (c0 <= 0xef)) {	// 3byte
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						len++;
					}
					if ( (c0 >= 0xf0) && (c0 <= 0xf7)) {	// 4byte
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						len++;
					}

					if ( (c0 >= 0xf8) && (c0 <= 0xfb)) {	// 5byte
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						len++;
					}

					if ( (c0 >= 0xfc) && (c0 <= 0xfd)) {	// 6byte
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						cc++;
						ib++;
						cbuf[ib] = *cc;
						len++;
					}

					cc++;
					ib++;

					clen--;
				}

				cbuf[ib] = 0;

				clen = MultiByteToWideChar(CP_UTF8, 0, (LPCSTR)cbuf, ib, wcbuf, 0);
				MultiByteToWideChar(CP_UTF8, 0, (LPCSTR)cbuf, ib, wcbuf, MAXCHAR_LINE);
				wcbuf[clen] = _T('\0');

				sW.Format(_T("%s"), wcbuf);
//				sW.Replace(sW2, sSPW);

				int tlen = sW.GetLength() * 2;
				unsigned char *dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 1];
				ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
				sW.Format(_T("%s"), (wchar_t*)dbuf);
				delete []dbuf;

				int sl = sW.GetLength();

				if ( m_pCharLine[i] != 0 ) {
					sFind1 = m_sFindString;
					if ( !nocaps ) {
						sFind1.MakeUpper();
						sW.MakeUpper();
					}

					int nf;
					if ( fmode < 0 ) {
						nf = FindStrReversW(sW, sFind1, nStartCharNo);
					} else {
						nf = sW.Find(sFind1, nStartCharNo);
					}
					if ( nf < 0 ) continue;


					m_nFindLineNo = i;
					m_nFindCharNo = nf;
					bFind = true;
					break;
				}

			}
		}

		if ( m_CharCode == CC_UTF7 ) {
			cc = m_pcFile + m_pLinePoint[i];
			clen = m_pLinePoint[i + 1] - m_pLinePoint[i];
			if ( clen != 0 ) {
				bool wc = false;
				int n = 5;
				int ib = n;
				int nof = 0;
				while ( clen != 0 ) {	// cbuf[5]֓꒼
					c0 = *cc;
					cbuf[ib] = c0;
					cc++;
					ib++;

					clen--;
				}

				cbuf[ib] = 0;

				clen = m_pCharLine[i];

				if ( m_pUTF7LineFlag[i] == 0 ) {	// s̐擪2byte1byteڂ̏ꍇA擪"+"ǉ
					if ( cbuf[5] != '-' ) {
						cbuf[4] = '+';
						n = 4;
						nof = 0;
					}
				}

				if ( m_pUTF7LineFlag[i] > 0 ) {	// s̐擪2byte2byteڂ̏ꍇA1byteڂcbuf̐擪ɓāA擪"+"ǉ
					cc = m_pcFile + m_pLinePoint[i];
					cc--;
					cbuf[4] = *cc;
					cc--;
					cbuf[3] = *cc;
					cc--;
					cbuf[2] = *cc;
					cc--;
					cbuf[1] = *cc;
					cbuf[0] = '+';
					n = 0;
					nof = 1;
					clen++;

				}


				MultiByteToWideChar(CP_UTF7, 0, (LPCSTR)&cbuf[n], (ib - n), wcbuf, MAXCHAR_LINE);
				wcbuf[clen + nof] = 0;

				sW.Format(_T("%s"), wcbuf);
//				sW.Replace(sW2, sSPW);

				int tlen = sW.GetLength() * 2;
				unsigned char *dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 1];
				ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
				sW.Format(_T("%s"), (wchar_t*)dbuf);
				delete []dbuf;

				int sl = sW.GetLength();
			
				if ( m_pCharLine[i] != 0 ) {
					sFind1 = m_sFindString;
					if ( !nocaps ) {
						sFind1.MakeUpper();
						sW.MakeUpper();
					}

					int nf;
					if ( fmode < 0 ) {
						nf = FindStrReversW(sW, sFind1, nStartCharNo);
					} else {
						nf = sW.Find(sFind1, nStartCharNo);
					}
					if ( nf < 0 ) continue;


					m_nFindLineNo = i;
					m_nFindCharNo = nf;
					bFind = true;
					break;
				}

			}
		}

	}

	delete []cbuf;
	delete []wcbuf;

	return bFind;
}


void CannsView::OnKeyF()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyFind();
}

void CannsView::OnKeyV()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyFindNext();
}

void CannsView::OnKeyT()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyFindPrev();
}

void CannsView::OnMenuKeyE()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftEnter();
}

void CannsView::CmdKeyCtrlA(void)
{
	int nf = m_FirstLine;
	m_FirstLine = 0;
	int last = m_MaxLine - m_PageLineNum;
	if (last < 0) last = 0;

	m_bNowSelect = true;

	Invalidate();


	m_ptSel.x = 0;
	m_ptSel.y = 0;

	GetSelectPoint(m_ptSel);

	m_nSelStartCs = m_nSelCharBs;
	m_nSelStartCe = m_nSelCharBe;
	m_nSelStartY = m_FirstLine + (m_ptSel.y / m_FontY);

	m_nSelStartNs = m_nSelCharCs;
	m_nSelStartNe = m_nSelCharCe;

	m_nSelStartNsT = m_nSelCharCsT;
	m_nSelStartNeT = m_nSelCharCeT;

	m_nSelStartDs = m_nSelCharDs;

	m_nUTF7WcFlagCs = m_nUTF7WcFlag;


	m_FirstLine = last;

	Invalidate();

	CRect rc;
	GetClientRect(&rc);

	m_ptSel.x = rc.right;
	m_ptSel.y = rc.bottom;

 	GetSelectPoint(m_ptSel);


	m_nSelEndCs = m_nSelCharBs;
	m_nSelEndCe = m_nSelCharBe;
	m_nSelEndY = m_FirstLine + (m_ptSel.y / m_FontY);

	m_nSelEndNs = m_nSelCharCs;
	m_nSelEndNe = m_nSelCharCe;

	m_nSelEndNsT = m_nSelCharCsT;
	m_nSelEndNeT = m_nSelCharCeT;

	m_nSelStartDe = m_nSelCharDs;

	m_nUTF7WcFlagCe = m_nUTF7WcFlag;

	if ((UINT)m_nSelEndY > (m_MaxLineNormalMode - 1)) m_nSelEndY = m_MaxLineNormalMode - 1;

	m_bNowSelect = false;
	m_bSelected = true;

	Invalidate();

	m_FirstLine = nf;
	Invalidate();

}

void CannsView::CmdKeyCtrlC(bool clear)
{
	// TODO: ɃR}h nh R[hǉ܂B

	if (!m_bSelected) return;

	unsigned char *ccs = m_pcFile;

	int sy = m_pLinePoint[m_nSelStartY];
	int ey = m_pLinePoint[m_nSelEndY];

	int st = m_nSelStartCs;
	int en = m_nSelEndCe;

	if ( sy > ey ) {
		sy = m_pLinePoint[m_nSelEndY];
		ey = m_pLinePoint[m_nSelStartY];
		st = m_nSelEndCs;
		en = m_nSelStartCe;
	}
	if ( sy == ey ) {
		if ( st> en ) {
			st = m_nSelEndCs;
			en = m_nSelStartCe;
		}
	}

	int bs = sy + st;
	int be = ey + en;

	int len = be - bs + 1;
	ccs = &m_pcFile[bs];

	unsigned char *cbuf;
	cbuf = new unsigned char[len + 3];
	CStringA sA;

	memcpy(cbuf, ccs, len);
	cbuf[len] = 0;
	cbuf[len+1] = 0;
	sA.Format("%s", cbuf);
	CString sW;
	sW = CA2W(sA);

	if ( m_CharCode == CC_UNICODE ) {
		sW.Format(_T("%s"), (wchar_t*)cbuf);
	}


	wchar_t* wcbuf;
	wcbuf = new wchar_t[m_ReadFileSize];

	if (m_CharCode == CC_JIS) {
		bs = st;
		be = en;
		int bst = bs - 1;
		bool bwc = false;
		unsigned char uc;
		len = en - st;

		while (bst >= 0) {
			uc = m_pcFile[bst];
			if (uc == 0x1b) {
				uc = m_pcFile[bst + 1];
				if (uc == 0x24) {
					bwc = true;
				}
				break;
			}
			bst--;

		}
		bst = bs;
		int blen = len;
		int cn = 0;
		UINT jcode, sjcode;

		while (blen > 0) {
			uc = m_pcFile[bst];
			if (uc == 0x1b) {
				bst++;
				blen--;
				uc = m_pcFile[bst];
				if (uc == 0x24) {
					bwc = true;
				}
				else {
					bwc = false;
				}
				bst++;
				blen--;
				bst++;
				blen--;

			}
			if (bwc) {
				jcode = ((UINT)m_pcFile[bst] * 0x100);
				bst++;
				jcode += (UINT)m_pcFile[bst];
				sjcode = _mbcjistojms(jcode);
				cbuf[cn] = (unsigned char)((sjcode & 0xff00) / 0x100);
				cn++;
				cbuf[cn] = (unsigned char)(sjcode & 0xff);
				blen--;

			}
			else {
				cbuf[cn] = m_pcFile[bst];
			}
			bst++;
			cn++;
			blen--;
		}
		cbuf[cn] = '\0';
		sW = CA2W((LPCSTR)cbuf);
//		sW.Format(_T("%s"), cbuf);

	}

	if (m_CharCode == CC_EUC) {
		bs = st;
		be = en;
		int bst = bs - 1;
		bool bwc = false;
		unsigned char uc;
		int ib = 0;
		UINT jcode, sjcode;

		unsigned char *ccs2 = &m_pcFile[bs];
		int clen = be - bs + 1;
		len = clen;
		delete[]cbuf;
		cbuf = new unsigned char[len + 6];

		while (len != 0) {
			bool wc = false;
			if (*ccs2 == 0x8e) {
				ccs2++;
				cbuf[ib] = *ccs2;
				ccs2++;
				len--;
				continue;
			}


			if (*ccs2 == 0x8f) {
				ccs2++;
				wc = true;
				len--;
			}

			if ((*ccs2 >= 0xa0) && (*ccs2 <= 0xff)) {
				wc = true;
			}


			if (wc) {	// 2byte
				uc = *ccs2 & 0x7f;
				jcode = ((UINT)uc * 0x100);
				ccs2++;
				uc = *ccs2 & 0x7f;
				jcode += (UINT)uc;
				ccs2++;
				sjcode = _mbcjistojms(jcode);
				cbuf[ib] = (unsigned char)((sjcode & 0xff00) / 0x100);
				ib++;
				cbuf[ib] = (unsigned char)(sjcode & 0xff);
				ib++;
				len--;

			}
			else {
				cbuf[ib] = *ccs2;
				ccs2++;
				ib++;
			}

			len--;

		}
		cbuf[clen] = '\0';

		CStringA sA;
		sA.Format("%s", cbuf);
		sW = CA2W((LPCSTR)cbuf);

//		sW = CA2W(m_saSelectStr);
	}

	if ( m_CharCode == CC_UTF8 ) {
		int clen = MultiByteToWideChar(CP_UTF8, 0, (LPCSTR)cbuf, len + 1, wcbuf, 0);
		MultiByteToWideChar(CP_UTF8, 0, (LPCSTR)cbuf, len + 1, wcbuf, m_ReadFileSize);
		wcbuf[clen] = _T('\0');
		sW.Format(_T("%s"), (wchar_t*)wcbuf);
	}

	if ( m_CharCode == CC_UTF7 ) {

//		sW = m_sSelectStr;


		unsigned char *ccs2 = &m_pcFile[bs];
		len = be - bs + 1;
		delete[]cbuf;
		cbuf = new unsigned char[len + 6];

		int cn = 0;
		if (m_nUTF7WcFlagCs == 0) {
			if (*ccs2 != '+') {
				cbuf[cn] = '+';
				cn++;
			}
		}
		else {
			if (m_nUTF7WcFlagCs == 1) {
				cbuf[cn] = '+';
				cn++;
				cbuf[cn] = *(ccs2 - 1);
				cn++;
				cbuf[cn] = *(ccs2 - 2);
				cn++;
				cbuf[cn] = *(ccs2 - 3);
				cn++;
			}
		}
		memcpy(&cbuf[cn], ccs2, len);
		len += cn;
		cbuf[len] = 0;
		cbuf[len + 1] = 0;


		int clen = MultiByteToWideChar(CP_UTF7, 0, (LPCSTR)cbuf, len + 1, wcbuf, 0);
		MultiByteToWideChar(CP_UTF7, 0, (LPCSTR)cbuf, len + 1, wcbuf, m_ReadFileSize);
		wcbuf[clen] = _T('\0');
		int of = 0;
		if (m_nUTF7WcFlagCs == 1) of = 1;
		sW.Format(_T("%s"), (wchar_t*)&wcbuf[of]);

	}
	delete[]wcbuf;

	delete[]cbuf;

	CString sW2;
	sW2 = _T("");

	DWORD nLen = 0;
	unsigned char *obuf;

	sA = "";

	if ( !clear ) {
		HGLOBAL hGlobal;

		if ( OpenClipboard() ) {

			hGlobal = GetClipboardData( CF_TEXT );
			if ( hGlobal != NULL ) {

//				LPTSTR pMem;
//				pMem = (LPTSTR)GlobalLock( hGlobal );
				unsigned char *pMem;
				pMem = (unsigned char*)GlobalLock( hGlobal );

				if ( pMem != NULL ) {
		 
					nLen = GlobalSize( hGlobal );
//					*(pMem + nLen) = 0x00;

					if ( nLen != 0 ) {
						obuf = new unsigned char[nLen+1];
//						memcpy(obuf, pMem, nLen);
						memcpy(obuf, pMem, nLen);
						obuf[nLen] = 0;
						sA.Format("%s", obuf);
						delete []obuf;
					}

					GlobalUnlock( hGlobal );
				 
				}
			}
			CloseClipboard();
		}
	}

	sW2 = CA2W(sA);
	sW2 += sW;
	sW = sW2;
	int sof = sizeof(wchar_t);
	int hsize = sW.GetLength() * sof;

	wchar_t *cwbuf, *pcb;
	cwbuf = new wchar_t[hsize + 2];
	pcb = cwbuf;

	memcpy(pcb, sW.GetBuffer(), hsize);
	pcb[hsize] = 0;
	pcb[hsize+1] = 0;

	HGLOBAL hg = (HGLOBAL)::GlobalAlloc(GHND | GMEM_SHARE, hsize + 2);
	if (hg == NULL) {
		delete []cwbuf;
        return;
	}

	PTSTR ptStr = (PTSTR)GlobalLock(hg);

	::memcpy(ptStr, cwbuf, hsize + 1);

	delete []cwbuf;

	GlobalUnlock(hg);


	if( !OpenClipboard() ) {
		return;
	}

	EmptyClipboard();
	SetClipboardData(CF_UNICODETEXT, hg);
	CloseClipboard();
}


void CannsView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_bHexMode) {
		return;
	}

	SetCapture();
	m_ptSel.x = point.x;
	m_ptSel.y = point.y;

	GetSelectPoint(point);

	m_nSelStartCs = m_nSelCharBs;
	m_nSelStartCe = m_nSelCharBe;
	m_nSelStartY = m_FirstLine + (point.y / m_FontY);

	m_nSelStartNs = m_nSelCharCs;
	m_nSelStartNe = m_nSelCharCe;

	m_nSelStartNsT = m_nSelCharCsT;
	m_nSelStartNeT = m_nSelCharCeT;
	
	m_nSelStartDs = m_nSelCharDs;

	m_nUTF7WcFlagCs = m_nUTF7WcFlag;

	if ( (UINT)m_nSelStartY > (m_MaxLineNormalMode - 1) ) m_nSelStartY = m_MaxLineNormalMode - 1;

	m_bNowSelect = true;


	CWnd::OnLButtonDown(nFlags, point);
}

void CannsView::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_bHexMode) {
		return;
	}

	if ( m_bNowSelect ) {

		GetSelectPoint(point);

		int py = point.y;
		if ( py < 0 ) {
			py = 0;
		}

		m_bNowSelect = false;

		m_nSelEndCs = m_nSelCharBs;
		m_nSelEndCe = m_nSelCharBe;
		m_nSelEndY = m_FirstLine + (py / m_FontY);

		m_nSelEndNs = m_nSelCharCs;
		m_nSelEndNe = m_nSelCharCe;

		m_nSelEndNsT = m_nSelCharCsT;
		m_nSelEndNeT = m_nSelCharCeT;

		m_nSelStartDe = m_nSelCharDs;

		m_nUTF7WcFlagCe = m_nUTF7WcFlag;

		if ( (UINT)m_nSelEndY > (m_MaxLineNormalMode - 1) ) m_nSelEndY = m_MaxLineNormalMode - 1;

		if ( (m_ptSel.x == point.x) && (m_nSelStartY == m_nSelEndY) ) {
			m_bSelected = false;
		} else {
			m_bSelected = true;
		}
		ReleaseCapture();
		Invalidate();
	}

	CWnd::OnLButtonUp(nFlags, point);
}

void CannsView::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_bHexMode) {
		return;
	}

	if ( m_bNowSelect ) {

		GetSelectPoint(point);

		int py = point.y;
		if ( py < 0 ) {
			py = 0;
		}
		int x = (point.x - m_OfsetLeft) / m_FontX;
		int y = m_FirstLine + (py / m_FontY);
		int yl = py / m_FontY;

		if ( (UINT)y > (m_MaxLineNormalMode - 1) ) y = m_MaxLineNormalMode - 1;

		if ( (UINT)yl > (m_MaxLineNormalMode - 1) ) yl = m_MaxLineNormalMode - 1;

		int yp = point.y;

		if ( m_MaxLine > (UINT)m_PageLineNum ) {
			if ( yp > m_nClientYw ) {
				UINT delta = 1;
				UINT last = m_FirstLine + delta + m_PageLineNum;
				if ( last > m_MaxLine ) {
					m_FirstLine = m_MaxLine  - m_PageLineNum;
				} else m_FirstLine += delta; 

			}

			if ( yp < 0 ) {
				UINT delta;
				delta = m_pFmParam->m_ViewDeltaLine;
				if ( m_FirstLine < delta ) {
					delta = m_FirstLine;
				}
				m_FirstLine -= delta; 
			}
//			Invalidate(FALSE);
		}

		m_nSelEndCs = m_nSelCharBs;
		m_nSelEndCe = m_nSelCharBe;

		m_nSelEndNs = m_nSelCharCs;
		m_nSelEndNe = m_nSelCharCe;

		m_nSelEndNsT = m_nSelCharCsT;
		m_nSelEndNeT = m_nSelCharCeT;

		m_nSelStartDe = m_nSelCharDs;

//		if ( (m_nSelStartCs != x) || (m_nSelStartY != y) ) {
			m_bSelected = true;

			m_nSelEndY = y;

			Invalidate();
//		}

	}

	CWnd::OnMouseMove(nFlags, point);
}

// NbNꂽʒuAobt@̕ʒu𓾂
// point:}EXŃNbNꂽʒu
// ߂l int NbNꂽʒũobt@̐擪̃oCg
void CannsView::GetSelectPoint(CPoint point)
{

	int py = point.y;
	if ( py < 0 ) py = 0;

	int y = py / m_FontY;
	int nLine = m_FirstLine + y;	// NbNꂽs
	if ( (UINT)nLine > (m_MaxLineNormalMode - 1) ) nLine = m_MaxLineNormalMode - 1;

	int x = (point.x - m_OfsetLeft) / m_FontX;	// NbNꂽs̐擪̔pZʒu

	int nbufPos = m_pLinePoint[nLine];	// ݍs̃obt@ł̐擪oCgʒu

	unsigned char* pc;
	pc = &m_pcFile[nbufPos];

	int nc = 0;	// Tab܂ލs̐擪̕
//	int bc = 0;	// oCg(obt@̍s̐擪̃oCg)

	unsigned char c0, c1, ctmp;
	int ntab = m_pFmParam->m_ViewTabNum;
	int xMax = m_pLinePoint[nLine + 1] - m_pLinePoint[nLine];


	if ( m_CharCode == CC_SJIS || m_CharCode == CC_JIS || m_CharCode == CC_EUC ) {

		unsigned char* bp;
		bp = pc;
		m_nSelCharBs = 0;
		m_nSelCharBe = 0;
		m_nSelCharCs = 0;
		m_nSelCharCe = 0;
		m_nSelCharCsT = 0;
		m_nSelCharCeT = 0;
		bool fst = true;
		int ed = x;
		int tb = ntab;
		int dnc = 0;	// pZ̕\ʒu(Tab܂ލs̐擪̕\ʒu)
		int tdnc = 0;	// pZ̕\ʒu(Tab->SPϊȂ̍s̐擪̕\ʒu)

		unsigned char *dbuf = new unsigned char[MAXCHAR_LINE];
		if ( m_CharCode == CC_JIS ) {

			xMax = ChangeLineJIStoSJIS(nLine, dbuf);
			bp = dbuf;
		}

		if ( m_CharCode == CC_EUC ) {

			xMax = ChangeLineEUCtoSJIS(nLine, dbuf);
			bp = dbuf;
		}


		for ( int n = 0; n < xMax; n++ ) {
			c0 = *bp;

			tb--;
			if ( c0 < 0x80 ) {
				m_nSelCharBe = n;
				if ( fst ) {
					m_nSelCharBs = n;
					m_nSelCharCs = dnc;
					m_nSelCharCe = dnc;

					m_nSelCharCsT = tdnc;
					m_nSelCharCeT = tdnc;
					if ( c0 == 0x09 ) {
						dnc += tb;
						tb = ntab;
						m_nSelCharCe = dnc;
					}
					if ( c0 == 0x0d ) {
						c0 = *(bp + 1);
						if ( c0 == 0x0a ) {
							bp++;
							n++;
							dnc++;
							tdnc++;
							m_nSelCharBe = n;
							m_nSelCharCe = dnc;
							m_nSelCharCeT = tdnc;
						}
					}
				} else {
					m_nSelCharBe = n;
					m_nSelCharCe = dnc;
					m_nSelCharCeT = tdnc;
					fst = true;
				}

			} else {
				if ( fst ) {
					m_nSelCharBs = n;
					m_nSelCharCs = dnc;
					m_nSelCharCsT = tdnc;
					fst = false;
				} else {
					m_nSelCharBe = n;
					m_nSelCharCe = dnc;
					m_nSelCharCeT = tdnc;
					fst = true;
				}

			}
			if ( tb == 0 ) tb = ntab;
			dnc++;
			tdnc++;
			if ( dnc > ed && fst ) break;

			bp++;
		}
		delete []dbuf;
	}
	
	if (m_CharCode == CC_JIS) {
		xMax = m_pLinePoint[nLine + 1] - m_pLinePoint[nLine];
		int bs = nbufPos;	// NbNꂽs̃obt@̐擪ʒu
		int cx = x;	// NbNꂽs̐擪̔pZʒu
		int lmax = xMax;
		int tb = ntab;

		bool bwc = false;
		unsigned char uc;
		int bst = bs - 1;

		while (bst >= 0) {
			uc = m_pcFile[bst];
			if (uc == 0x1b) {
				uc = m_pcFile[bst + 1];
				if (uc == 0x24) {
					bwc = true;
				}
				break;
			}
			bst--;

		}

		m_nSelCharBs = bs;
		m_nSelCharBe = bs;
		int nx = 0;// pZʒu

		while (lmax != 0) {
			tb--;
			m_nSelCharBs = bs;
			uc = m_pcFile[bs];

			if (uc == 0x1b) {
				uc = m_pcFile[bs + 1];

				if (uc == 0x24) {	// 2byte
					bwc = true;

				}
				else // 1byte
				{
					bwc = false;
				}
				bs += 3;
				lmax -= 3;
				nx++;
				continue;

			}
			if (bwc) {
				bs++;
				nx++;
				m_nSelCharBe = bs;
				tb--;
				lmax--;
			}
			else {
				if (c0 == 0x09) {
					nx += tb;
					tb = ntab;
				}
				m_nSelCharBe = bs;
			}
			bs++;
			nx++;
			lmax--;

			if (nx > cx) break;
			if (tb == 0) tb = ntab;

		}
	}
	if (m_CharCode == CC_EUC) {
		unsigned char* bp;
		bp = pc;
		m_nSelCharBs = 0;
		m_nSelCharBe = 0;
		int ed = x;
		int tb = ntab - 1;
		int dnc = 0;	// pZ̕\ʒu(Tab܂ލs̐擪̕\ʒu)
		int nc = 0;
		int bn = nbufPos;	// f[^ł̃NbNʒũoCg

		int clen = xMax;

		while (clen > 0) {
			m_nSelCharBs = bn;
			bool wc = false;
			if (*bp == 0x8e) {
				bn++;
				bp++;
				clen--;

			}

			if (*bp == 0x8f) {
				wc = true;
				bn++;
				bp++;
				clen--;

			}

			if ((*bp >= 0xa0) && (*bp <= 0xff)) {
				wc = true;
			}

			if (*bp == 0x09) {
				ed -= tb;
				tb = 0;
			}

			if (wc) {	// 2byte
				bn++;
				bp++;
				clen--;
				ed--;
				tb--;
			}
			else {
				if (*bp == 0x0d) {
					if (*(bp + 1) == 0x0a) {
						bn++;
						bp++;
						clen--;
					}
				}
			}

			m_nSelCharBe = bn;
			bn++;
			bp++;

			clen--;
			ed--;
			if (ed < 0) break;

			tb--;
			if (tb < 0) tb = ntab - 1;

		}

	}

	if ( m_CharCode == CC_UNICODE ) {

		unsigned char* bp;
		bp = pc;
		m_nSelCharBs = 0;
		m_nSelCharBe = 0;
		int ed = x;
		int tb = ntab;
		int dnc = 0;	// pZ̕\ʒu(Tab܂ލs̐擪̕\ʒu)
		int nc = 0;


		for ( int n = 0; n < xMax; n += 2 ) {
			c0 = *bp;
			bp++;
			c1 = *bp;
			bp++;
			if ( m_Endian ) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}

			m_nSelCharBs = n;
			m_nSelCharBe = n + 1;

			m_nSelCharCs = nc;
			m_nSelCharCe = nc;

			tb--;
			if ( tb == 0 ) tb = ntab;

			if ( (c1 == 0) && (c0 < 0x80) ) {
				if ( c0 == 0x09 ) {
					dnc += tb;
					nc += tb;
					tb = ntab;
					m_nSelCharCe = nc;
				}
				dnc++;

				ctmp = c0;
				if ( c0 == 0x0d ) {
					ctmp = *bp;
					if ( m_Endian ) ctmp = *(bp + 1);
					if ( ctmp == 0x0a ) {
						m_nSelCharBe += 2;
						dnc++;
						bp += 2;
						nc++;
						m_nSelCharCe = nc;
					}
				} else {
/*
					if ( (ctmp == 0x0a) && (n > 1)) {
						ctmp = *(bp - 4);
						if ( m_Endian ) ctmp = *(bp - 3);
						if ( ctmp == 0x0d ) {
							m_nSelCharBs -= 2;
						}
					}
*/
				}
			} else {
				dnc += 2;
				tb--;
				if ( tb == 0 ) tb = ntab;
			}

			nc++;

			if ( dnc > ed ) {
				break;
			}
		}

	}


	if ( m_CharCode == CC_UTF8 ) {
		unsigned char* bp;
		bp = pc;
		m_nSelCharBs = 0;
		m_nSelCharBe = 0;
		int ed = x;
		int nc = 0;
		int nn = 0;
		int tb = ntab;

		int tnc = 0;

		for ( int n = 0; n < xMax; n++ ) {
			c0 = *bp;

			if ( nc > ed ) {
				break;
			}

			m_nSelCharCs = nn;
			m_nSelCharCe = nn;

			m_nSelCharCsT = tnc;
			m_nSelCharCeT = tnc;

			m_nSelCharDs = nc;

			tnc++;
			nn++;

			bool bwc = false;

			if ( (c0 >= 0xc0) && (c0 <= 0xdf)) {	// 2byte
				m_nSelCharBs = n;
				m_nSelCharBe = n + 1;
				n++;
				bp += 2;
				nc += 2;
				bwc = true;
			}
			if ( (c0 >= 0xe0) && (c0 <= 0xef)) {	// 3byte
				m_nSelCharBs = n;
				m_nSelCharBe = n + 2;
				n += 2;
				bp += 3;
				nc += 2;
				bwc = true;
			}
			if ( (c0 >= 0xf0) && (c0 <= 0xf7)) {	// 4byte
				m_nSelCharBs = n;
				m_nSelCharBe = n + 3;
				n += 3;
				bp += 4;
				nc += 2;
				bwc = true;
			}
			if ( (c0 >= 0xf8) && (c0 <= 0xfb)) {	// 5byte
				m_nSelCharBs = n;
				m_nSelCharBe = n + 4;
				n += 4;
				bp += 5;
				nc += 2;
				bwc = true;
			}
			if ( (c0 >= 0xfc) && (c0 <= 0xfd)) {	// 6byte
				m_nSelCharBs = n;
				m_nSelCharBe = n + 5;
				n += 5;
				bp += 6;
				nc += 2;
				bwc = true;
			}

			if (!bwc) {
				// 1byteASCII(G0)
				m_nSelCharBs = n;
				m_nSelCharBe = n;
				nc++;

				if (c0 == 0x0d) {
					ctmp = *(bp + 1);
					if (ctmp == 0x0a) {
						n++;
						m_nSelCharBe = n;
						m_nSelCharCe++;
						m_nSelCharCeT++;
						bp++;
						nc++;
					}
				}


				bp++;

			}
			else {
				tb--;
				if (tb == 0) tb = ntab;
			}

			tb--;
			if (tb == 0) tb = ntab;
			if (c0 == 0x09) {
				nc += tb;
				m_nSelCharCe += tb;
				nn += tb;
				tb = ntab;
			}

		}
	}


	if ( m_CharCode == CC_UTF7 ) {

		int ntab = m_pFmParam->m_ViewTabNum;

		unsigned char* bp;
		bp = &m_pcFile[nbufPos];

		m_nSelCharBs = 0;
		m_nSelCharBe = 0;

		m_nSelCharCs = 0;
		m_nSelCharCe = 0;

		m_nSelCharCsT = 0;
		m_nSelCharCeT = 0;

		m_nSelCharDs = 0;
		m_nSelCharDe = 0;

		int ed = x;
		int tb = ntab - 1;
		int dnc = 0;	// pZ̕\ʒu(Tab܂ލs̐擪̕\ʒu)
		int nc = 0;
		int tnc = 0;
		int bn = 0;

		int nLineFlag = m_pUTF7LineFlag[nLine];
		m_nUTF7WcFlag = nLineFlag;

		for (int n = 0; n < xMax; n++) {

			m_nSelCharBs = bn;
			m_nSelCharBe = bn;

			m_nSelCharCs = nc;
			m_nSelCharCe = nc;

			m_nSelCharCsT = tnc;
			m_nSelCharCeT = tnc;

			m_nSelCharDs = dnc;
			m_nSelCharDe = dnc;

//			tb--;
//			if (tb == 0) tb = ntab;

			c0 = *bp;
			m_nUTF7WcFlag = nLineFlag;

			if (nLineFlag >= 0) {	// 2oCg

				if (nLineFlag == 1) {	// 2oCg2oCg
					n++;
					if (n >= xMax) break;
					bn++;
					bp++;
					m_nSelCharBe = bn;

					if (*bp != 0x2d) {
						n++;
						if (n >= xMax) break;
						bn++;
						bp++;
						m_nSelCharBe = bn;
					}
					tb -= 2;
					if (tb < 0) tb = ntab - 1;

					nLineFlag = 0;
				}
				else {
					if (c0 == 0x2d) {	// '-'Ȃȍ~ASCII
						nLineFlag = -1;
						nc--;
						tnc--;
						dnc--;

					}
					else {
						nLineFlag = 0;
						n++;
						if (n >= xMax) break;
						bn++;
						bp++;
						m_nSelCharBe = bn;

						if (*bp != 0x2d) {
							n++;
							if (n > xMax) break;
							bn++;
							bp++;
							c0 = *bp;
							if (c0 == 0x2d) {	// '-'Ȃȍ~ASCII
								nLineFlag = -1;
							}
							else {
								m_nSelCharBe = bn;
							}
						}
						dnc++;
						m_nSelCharDe = dnc;
						tb -= 2;
						if (tb < 0) tb = ntab - 1;

					}
				}

			}
			else {

				if (c0 == 0x2b) {	// '+'Ȃȍ~2oCg
					c0 = *(bp + 1);
					if (c0 == 0x2d) {	// "+-"'+'
						bn++;
						m_nSelCharBe = bn;
						bp++;
						tb--;
						if (tb < 0) tb = ntab - 1;

					}
					else {
						nLineFlag = 0;
						nc--;
						tnc--;
						dnc--;
					}

				}
				else {
					if (c0 == 0x09) {
						dnc += tb;
						nc += tb;
						tb = ntab - 1;
						m_nSelCharCe = nc;
					}
					else {
						tb--;
						if (tb < 0) tb = ntab - 1;
					}

					if (c0 == 0x0d) {
						c0 = *(bp + 1);
						if (c0 == 0x0a) {
							bn++;
							m_nSelCharBe = bn;
							bp++;
							dnc++;
							m_nSelCharDe = dnc;
							nc++;
							m_nSelCharCe = nc;
							n++;
							if (n > xMax) break;
						}
					}

				}


			}

			bn++;
			nc++;
			tnc++;
			bp++;
			dnc++;

			if (dnc > ed) {
				break;
			}
		}
			
	}

	return;
}




void CannsView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( m_bSelected ) {
		CMenu pRmenu;
		pRmenu.CreatePopupMenu();
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_CTRL_KEY_C ,_T("Rs[(&C)"));
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_SHIFT_KEY_C ,_T("ǉRs[(&A)"));
	/*
		if ( m_bLongNameMode) pRmenu.CheckMenuItem(ID_LONG_NAME_MODE, MF_CHECKED);
		else pRmenu.CheckMenuItem(ID_LONG_NAME_MODE, MF_UNCHECKED);

		CString fname;
		fname =  m_pFmParam->m_pw64FindData[m_pFileView->m_CurrentFileNo].name;
		if ( fname == _T("..") ) {
			pRmenu.EnableMenuItem(ID_KEY_N, MF_GRAYED);
			pRmenu.EnableMenuItem(ID_CTRL_KEY_T, MF_GRAYED);
		}
	*/
		ClientToScreen(&point);
		pRmenu.TrackPopupMenu(
			TPM_LEFTALIGN  |	//NbNXWj[̍ӂɂ
			TPM_RIGHTBUTTON,	//ENbNŃj[I\Ƃ
			point.x,point.y,	//j[̕\ʒu
			this            	//̃j[LEBhE
		);
		pRmenu.DestroyMenu();
	}

	CWnd::OnRButtonDown(nFlags, point);
}

void CannsView::OnMenuCtrlKeyC()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyCtrlC();
}

void CannsView::OnMenuShiftKeyC()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyCtrlC(false);
}

//void CannsView::OnMButtonDblClk(UINT nFlags, CPoint point)
//{
//	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
//
//	CWnd::OnMButtonDblClk(nFlags, point);
//}

void CannsView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CmdKeyQuit();

//	CWnd::OnLButtonDblClk(nFlags, point);
}


void CannsView::OnFilePrint()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CPrintInfo printInfo;
	ASSERT(printInfo.m_pPD != NULL);    // must be set
	CWinApp* pApp = AfxGetApp();
	if (pApp->DoPrintDialog(printInfo.m_pPD) != IDOK) return;       // do not print
  
	CDC dcPrint;
	dcPrint.Attach(printInfo.m_pPD->m_pd.hDC);  // attach printer dc
	dcPrint.m_bPrinting = TRUE;
  
	// Get the application title
	CString strTitle;
	strTitle.LoadString(AFX_IDS_APP_TITLE);
  
	// Initialise print document details
	DOCINFO di;
	::ZeroMemory (&di, sizeof(DOCINFO));
	di.cbSize = sizeof(DOCINFO);
	di.lpszDocName = strTitle;
  
	BOOL bPrinting = dcPrint.StartDoc(&di);
	BOOL bPage = TRUE;
/*
	CClientDC dc = CClientDC(this);
	int dx = dc.GetDeviceCaps(LOGPIXELSX);

	int px = dcPrint.GetDeviceCaps(LOGPIXELSX);

	int ratio = px / dx + 1;
*/
	int nPage = 0;

	while (bPrinting && bPage) {
		dcPrint.StartPage();
      // ̈ʒu1y[W̏o͂邽߂̃R[h
      // ׂẴy[Wo͂ bPage = FALSE ŏI

//		CString s;
//		s.Format(_T("[ %s ]"), _T(""));
//		dcPrint.TextOut(300, 200, s);

		bool ret = PrintOnePage(&dcPrint, nPage);
		if ( !ret ) bPage = false;
/*
		//p̃TCYisNZj߂
		int width = dcPrint.GetDeviceCaps(PHYSICALWIDTH);
		int height = dcPrint.GetDeviceCaps(PHYSICALHEIGHT);

		//ItZbg}CiX
		width = width - dcPrint.GetDeviceCaps(PHYSICALOFFSETX) * 2;
		height = height - dcPrint.GetDeviceCaps(PHYSICALOFFSETY) * 2;
*/

		nPage++;
		bPrinting = (BOOL)dcPrint.EndPage();
	}

	if (bPrinting) dcPrint.EndDoc();
	else dcPrint.AbortDoc();
  
	dcPrint.Detach();   // will be cleaned up by CPrintInfo destructor
}


// nPage : y[W 0`
bool CannsView::PrintOnePage(CDC *dc, int nPage)
{

/*
	CString sss;
	sss.Format(_T("[ %s ]"), m_sFileName);
	dc->TextOut(300, 200, sss);
	return;
*/
	bool ret = true;

	if ( m_FileSize == 0 ) return false;
/*
	if ( m_bHexMode ) {
		DrawHexMode();
		return;
	}
*/
	CRect rc;
	GetClientRect(&rc);
	m_nClientYw = rc.bottom;

	int nWidthView = rc.right - rc.left;

//	CClientDC cdc = CClientDC(this);
	CDC* cdc = GetDC();
	int dx = cdc->GetDeviceCaps(LOGPIXELSX);
	int px = dc->GetDeviceCaps(LOGPIXELSX);

	// ̈̕ƍ
	int width = dc->GetDeviceCaps(PHYSICALWIDTH);
	int height = dc->GetDeviceCaps(PHYSICALHEIGHT);

	//ItZbg}CiX
//	width = width - (dc->GetDeviceCaps(PHYSICALOFFSETX) * 2);
	height = height - (dc->GetDeviceCaps(PHYSICALOFFSETY) * 2);

	int nwRatio = (width * 95) / nWidthView / 100;


	CFont font;
	CFont* pOldFont;
	int fw, fh;

	LOGFONT pfont;
	pfont = m_pFmParam->m_logfontView;
//	font.CreateFontIndirect(&(m_pFmParam->m_logfontViewGuide));
	LONG h = pfont.lfHeight;
	LONG pfh = h * nwRatio;
	CString ss;
	ss.Format(_T("%s"), pfont.lfFaceName);
	if (  ss == _T("FixedSys") ) {
		pfh = -16 * nwRatio;
		pfont.lfWidth = 0;
	}
	pfont.lfHeight = pfh;
	font.CreateFontIndirect(&pfont);
	pOldFont = dc->SelectObject(&font);

	ss = "W";
	CSize size = dc->GetTextExtent( ss );

	fw = size.cx;
	fh = size.cy + m_pFmParam->m_nViewLineSpace;
	m_FontX = fw;
	m_FontY = fh;

	CString s, form;
	CSize sizew;

	int nPageLine = height / (20 - pfh);

/*
	COLORREF colview = m_pFmParam->m_colViewText;
	COLORREF colFindStr = m_pFmParam->m_colViewFindString;
	COLORREF colFindStrBack = m_pFmParam->m_colViewFindStringBack;

*/
	int x, y;
	UINT line = 0;
	unsigned char *cc;

	unsigned char *cbuf;
	cbuf = new unsigned char[MAXCHAR_LINE];
	wchar_t* wcbuf;
	wcbuf = new wchar_t[MAXCHAR_LINE + 10];

	unsigned char *dbuf;
	unsigned char *cc2, c0, c1, ctmp;

	x = fw * 6;
	y = fh * 5;

	int ntab = m_pFmParam->m_ViewTabNum - 2;
	CStringA sA, sA2, sFind1A, sFind2A, sA3, sA4;
	CString sW, sW2, sW3;

	int nFirstLine = nPage * nPageLine;
/*
	int last = m_MaxLine - nPageLine;
	if ( last < 0 ) last = 0;
	if ( nFirstLine > last ) {
		nFirstLine = last;
	}
*/
	for ( int i = 0; i < nPageLine; i++ ) {
		line = nFirstLine + i;
		if ( line == m_MaxLine ) {
			ret = false;
			break;
		}
//		dc->SetTextColor(colview);
//		dc->SetBkColor(m_pFmParam->m_colBack);

		if ( m_CharCode == CC_SJIS ) {
			cc = m_pcFile + m_pLinePoint[line];

			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			memcpy(cbuf, cc, sl);
			cbuf[sl] = 0;
			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete []dbuf;

			sW = CA2W(sA);

			dc->TextOut(x, y, sW);

			y += fh;
		}

		if ( m_CharCode == CC_UNICODE ) {

			cc2 = m_pcFile + m_pLinePoint[line];
			int sl = m_pLinePoint[line + 1] - m_pLinePoint[line];
			int orglen = sl;

			memcpy(cbuf, cc2, sl);
			cbuf[sl] = 0;
			cbuf[sl + 1] = 0;
			sl -= 2;
			c0 = cbuf[sl];
			c1 = cbuf[sl + 1];

			if ( m_Endian ) {
				ctmp = c0;
				c0 = c1;
				c1 = ctmp;
			}

			bool bCrLf = false;

			if ( (sl >= 0) && (c0 == 0x0a) && (c1 == 0) ) {
				cbuf[sl] = 0;
				cbuf[sl + 1] = 0;
				sl -= 2;
				c0 = cbuf[sl];
				c1 = cbuf[sl + 1];

				if ( m_Endian ) {
					ctmp = c0;
					c0 = c1;
					c1 = ctmp;
				}
				if ( (sl >= 0) && (c0 == 0x0d) && (c1 == 0) ) {
					cbuf[sl] = 0;
					cbuf[sl + 1] = 0;
					bCrLf = true;
				}
			} else {
				if ( (sl >= 0) && (c0 == 0x0d) && (c1 == 0) ) {
					cbuf[sl] = 0;
					cbuf[sl + 1] = 0;
					bCrLf = true;
				}
			}

			memcpy(cbuf, cc2, orglen);
			dbuf = new unsigned char[orglen * m_pFmParam->m_ViewTabNum + 1];
			ReplaceTab(cbuf, dbuf, orglen);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete []dbuf;

			int lw = sW.GetLength();

			dc->TextOut(x, y, sW, lw);

			y += fh;
		}

		if ( m_CharCode == CC_JIS ) {

			int sl = 0;

			int blen = ChangeLineJIStoSJIS(line, cbuf);

			sA.Format("%s", cbuf);

			sl = sA.GetLength();

			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete []dbuf;

			sW = CA2W(sA);

			dc->TextOut(x, y, sW);

			y += fh;
		}


		if ( m_CharCode == CC_EUC ) {

			int blen = ChangeLineEUCtoSJIS(line, cbuf);

			sA.Format("%s", cbuf);

			int sl =sA.GetLength();

			dbuf = new unsigned char[sl * m_pFmParam->m_ViewTabNum + 1];
			ReplaceTab(cbuf, dbuf, sl);
			sA.Format("%s", dbuf);
			delete []dbuf;

			sW = CA2W(sA);

			dc->TextOut(x, y, sW);

			y += fh;
		}

		if ( m_CharCode == CC_UTF8 ) {


			int ib = ChangeLineUTF8toWC(line, wcbuf);

			int tlen = ib * 2;

			dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 1];
			ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete []dbuf;

			int sl = sW.GetLength();

			dc->TextOut(x, y, sW);

			y += fh;
		}

		if ( m_CharCode == CC_UTF7 ) {

			int ib = ChangeLineUTF7toWC(line, wcbuf);

			int tlen = ib * 2;

			dbuf = new unsigned char[tlen * m_pFmParam->m_ViewTabNum + 1];
			ReplaceTab((unsigned char*)wcbuf, dbuf, tlen);
			sW.Format(_T("%s"), (wchar_t*)dbuf);
			delete []dbuf;

			dc->TextOut(x, y, sW);

			y += fh;


		}

	}

	delete []cbuf;
	delete []wcbuf;

	ReleaseDC(cdc);

	return ret;
}

/*
HRESULT CannsView::GetWICFactory(IWICImagingFactory** factory)
{
   static ComPtr<IWICImagingFactory> m_pWICFactory;
   HRESULT hr = S_OK;

   if (nullptr == m_pWICFactory)
   {
      hr = CoCreateInstance(
            CLSID_WICImagingFactory, nullptr,
            CLSCTX_INPROC_SERVER, IID_PPV_ARGS(&m_pWICFactory) );
   }

   if (SUCCEEDED(hr))
   {
      hr = AssignToOutputPointer(factory, m_pWICFactory);
   }

   return hr;
}
*/


void CannsView::OnMenuViewCtrlKeyA()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlA();
}


void CannsView::OnKeyCtrlV()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	m_pViewFrame->m_pwndFile->RunannsFMtextExe(m_sFullFileName);
}
