// annsTreeView.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "annsTreeView.h"
#include "FmParam.h"
#include "DriveTabWnd.h"
#include "TreeData.h"
#include "TreeFrameWindow.h"
#include "MakeDirDialog.h"
#include "SelectDriveDialog.h"

#include "io.h"

// #include "nvdaController.h"

#define MAX_DIR_NUM	32000	// ő\tH_(WJ܂)
#define TMP_DIR_NUM	3000	// 1tH_̍őǂݍ݃tH_

// CannsTreeView

IMPLEMENT_DYNCREATE(CannsTreeView, CScrollView)

CannsTreeView::CannsTreeView()
{

//	m_ptdRootData = new _treedata[MAX_DIR_NUM];
//	m_ptdTempData = new _treedata[TMP_DIR_NUM];
	m_ptdRootData = new CTreeData[MAX_DIR_NUM];
	m_ptdTempData = new CTreeData[TMP_DIR_NUM];

	m_pnPrevDrawLine = new int[MAX_DIR_NUM];
	m_pnDrawLine = new int[MAX_DIR_NUM];

	m_nMaxDirNum = 0;
	m_nMaxNum = 0;
	m_nDrawStartLineNum = 0;
	m_nPageLineNum = 2;
	m_nCurLine = 0;
	m_FontH = 19;
}

CannsTreeView::~CannsTreeView()
{

	delete []m_ptdRootData;
	delete []m_ptdTempData;
	delete []m_pnPrevDrawLine;
	delete []m_pnDrawLine;
}


BEGIN_MESSAGE_MAP(CannsTreeView, CScrollView)
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_SIZE()
	ON_COMMAND(ID_TREE_EXIT, &CannsTreeView::OnTreeExit)
	ON_WM_MOUSEWHEEL()
	ON_WM_VSCROLL()
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()


void CannsTreeView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CFont font;
	CClientDC dc(this);
	CFont* pOldFont;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontTree));
	pOldFont = dc.SelectObject(&font);
	CString cs;
	cs = "W";
	CSize size = dc.GetTextExtent(cs);
	m_FontW = size.cx;
	m_FontH = size.cy + 1;
	dc.SelectObject(pOldFont);

	CRect rc;
	GetClientRect(rc);
	int wh = rc.bottom - rc.top - m_FontH + 1;

	m_nPageLineNum = wh / m_FontH;

	m_nMaxDrive = m_pDriveTabWnd->m_MaxTab;
	for ( int i = 0; i < m_nMaxDrive; i++ ) {

		m_ptdRootData[i].sDirName = m_pDriveTabWnd->m_pDriveList[i].Left(3);
		m_ptdRootData[i].sFullDirName = m_pDriveTabWnd->m_pDriveList[i].Left(3);
		m_ptdRootData[i].bEnable = true;
	}

	m_nMaxNum = m_nMaxDrive;
	m_nCurrentDriveNo =  m_pDriveTabWnd->m_CurrentTabNo;

	CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	CString scp[50];
	int ncp[50];
	int n;
	int m = 0;
	CString stmp, stmp2;
	stmp = cpath;

	for ( n = 0; n < MAX_HIERAR; n++ ) {
		int lp = stmp.Find(_T('\\')) + 1;
		if ( lp == 0 ) break;
		scp[n] = stmp.Left(lp - 1);
		stmp2 = stmp.Mid(lp);
		stmp = stmp2;
		ncp[n] = m + lp;
		m = ncp[n];
	}

//	n--;

	if ( n != 0 ) m_ptdRootData[m_nCurrentDriveNo].nStat = 1;


	int start = m_nCurrentDriveNo + 1;
	int end = m_nMaxNum - start;

	for ( int i = 0; i < n; i++ ) {
		CString path;
		path = cpath.Left(ncp[i]);

		int rn = ReadTreeData(path, m_ptdTempData, i + 1);
		if ( rn != 0 ) {
			m_ptdRootData[m_nCurrentDriveNo].nSubDir = rn;
			int st = m_nMaxNum - 1;
			int dt = st + rn;
			for ( int k = 0; k < end; k++ ) {
				m_ptdRootData[dt].Copy(m_ptdRootData[st]);
				st--;
				dt--;
			}
			dt = start;
			m_ptdRootData[start - 1].nStat = 1;
			for ( int k = 0; k < rn; k++ ) {
				m_ptdRootData[dt].Copy(m_ptdTempData[k]);
				if (m_ptdRootData[dt].sFullDirName == cpath) {
					m_ptdRootData[dt].nStat = 1;
					m_ptdRootData[dt].nSubDir = rn;
				}
				dt++;
				if ( scp[i + 1] == m_ptdTempData[k].sDirName ) {
					start = dt;
				}
			}
			m_nMaxNum += rn;
			end = m_nMaxNum - start;
		}
	}

	m_nMaxDirNum = m_nMaxNum;
	m_nCurLine = start - 1;

	int pmax = m_nDrawStartLineNum + m_nPageLineNum - 1;
	if ( m_nCurLine > pmax ) {
		m_nDrawStartLineNum = m_nCurLine - (m_nPageLineNum / 2);
		if ( m_nDrawStartLineNum < 0 ) m_nDrawStartLineNum = 0;
		if ( (m_nDrawStartLineNum + m_nPageLineNum) > m_nMaxNum ) m_nDrawStartLineNum = m_nMaxNum - m_nPageLineNum - 1;
	}


	SetScrollData();

	CPoint pt;
	pt.x = 0;
	pt.y = m_nDrawStartLineNum * m_FontH;
	ScrollToPosition(pt);

}

void CannsTreeView::SetScrollData(void)
{
	CSize sizeTotal, sizePage, sizeLine;
	// TODO: ̃r[̃TCY̍vvZ܂B
	sizeTotal.cx = 100;
	sizeTotal.cy = m_nMaxNum * m_FontH;
	sizePage.cy = (m_nPageLineNum * m_FontH) / 2;
	sizeLine.cy = m_FontH;
	SetScrollSizes(MM_TEXT, sizeTotal, sizePage, sizeLine);
}

// CannsTreeView `

void CannsTreeView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB

	CFont font;
	CFont* pOldFont;
	int fw, fh;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontTree));
	pOldFont = pDC->SelectObject(&font);
	fh = m_FontH;
	fw = m_FontW;

	CString s, form;
	CSize sizew;

	pDC->SetBkColor(m_pFmParam->m_colBack);

	int x, y;
	x = fw;
	y = 0;
	int startLine = 0;
	int max = m_nMaxDirNum;
	int nPrevDirNum;	// O̕\c[f[^ԍ
	int nDrawLine = 0;	// \s

	for ( int i = startLine; i < max; i++ ) {
		COLORREF coldata = m_pFmParam->m_colListDir;
		int at = m_ptdRootData[i].nAttri;
		if ( at & _A_RDONLY ) coldata = m_pFmParam->m_colListReadonly;
		if ( at & _A_HIDDEN ) coldata = m_pFmParam->m_colListHide;
		if ( at & _A_SYSTEM ) coldata = m_pFmParam->m_colListSystem;
		if ( i == m_nCurLine ) {
			pDC->SetBkColor(coldata);
			pDC->SetTextColor(m_pFmParam->m_colBack);
//			if ( m_pFmParam->m_bToolUseNVDA && m_pFmParam->m_bEnableNVDA ) {
//				m_pFmParam->m_pnvdaController_speakText(m_ptdRootData[m_nCurLine].sFullDirName);
			if ( m_pFmParam->m_nVoiceGuide != 0 ) {
				m_pFmParam->VoiceGuideOut(m_ptdRootData[m_nCurLine].sFullDirName);
			}
		} else {
			pDC->SetBkColor(m_pFmParam->m_colBack);
			pDC->SetTextColor(coldata);
		}
		CString s, s2, ssig;
		int n = 0;
		int hi = m_ptdRootData[i].nHierar;
		int xs = hi * fw * 2;
		int stat = m_ptdRootData[i].nStat;

		ssig = _T("+ ");
		if ( stat == 1 ) ssig = _T("- ");
		if ( stat == 2 ) ssig = _T("/ ");
		s2 = _T("%s%s");
		s.Format(s2, ssig, m_ptdRootData[i].sDirName);
		m_pnDrawLine[i] = -1;
		if ( m_ptdRootData[i].bEnable ) {
			pDC->TextOut(x + xs, y, s);
			y += m_FontH;
			m_pnDrawLine[i] = nDrawLine;
			nDrawLine++;
			if ( i > 0 ) {
				m_pnPrevDrawLine[i] = nPrevDirNum;
			}
			nPrevDirNum = i;
		}

	}

	pDC->SelectObject(pOldFont);

}


// CannsTreeView ff

#ifdef _DEBUG
void CannsTreeView::AssertValid() const
{
	CScrollView::AssertValid();
}

#ifndef _WIN32_WCE
void CannsTreeView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif
#endif //_DEBUG


// CannsTreeView bZ[W nh

BOOL CannsTreeView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	// uV̍쐬
	CBrush brush(m_pFmParam->m_colBack);
    // VuVw(̃uV̕ۑ)
    CBrush* pOldBrush = pDC->SelectObject(&brush);

    // hԂ̈擾
    CRect rect;
    GetClientRect(&rect);

	// hԂ
    pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

	// uVɖ߂
    pDC->SelectObject(pOldBrush);

	return TRUE;

//	return CScrollView::OnEraseBkgnd(pDC);
}

void CannsTreeView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	short shift = GetKeyState(VK_SHIFT);
	short ctrl = GetKeyState(VK_CONTROL);

	UINT cmdno;
	if ( shift < 0 ) {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x300;
		} else {
			cmdno = nChar + 0x100;
		}
	} else {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x200;
		} else {
			cmdno = nChar;
		}
	}

	RunKeyCmd(cmdno);

//	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CannsTreeView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	int pos = point.y / m_FontH;
	int cp = pos + m_nDrawStartLineNum + 1;

	int n = 0;
	while (1) {
		if (m_ptdRootData[n].bEnable) {
			cp--;
			if (cp == 0) break;
		}
		n++;
		if (n >= m_nMaxDirNum) break;
	}

	m_nCurLine = n;

	if ( m_nCurLine >= m_nMaxDirNum ) m_nCurLine = m_nMaxDirNum - 1;
	Invalidate();

	CScrollView::OnLButtonDown(nFlags, point);
}

// L[R}hs	nCmdNo = R}hNo.
// L[JX^}CYyуR}h}NpɁAR}hNo.őSẴR}hs
void CannsTreeView::RunKeyCmd(UINT uCmdNo)
{
	switch ( uCmdNo ) {

		case 0x08: // "Backspace"
			break;

		case 0x0d: // "Enter"
			CmdKeyEnter();
			break;

		case 0x1b: // "Esc"
			m_pTreeFrameWindow->m_pwndParent->SetFocus();
			m_pTreeFrameWindow->DestroyWindow();
//			CmdKeyEsc();
			break;

		case 0x20: // Space
			break;

		case 0x21: // PageUp
			CmdKeyPageUp();
			break;

		case 0x22: // PageDown
			CmdKeyPageDown();
			break;


		case 0x24: // "Home"
			break;

		case 0x25: // ""
			CmdKeyLeft();
			break;

		case 0x26: // ""
			CmdKeyUp();
			break;

		case 0x27: // ""
			CmdKeyRight();
			break;

		case 0x28: // ""
			CmdKeyDown();
			break;

		case 0x2d: // "Insert"
			break;

		case 0x2e: // "Delete"
			break;

		case 0x30: // "0"
		case 0x31: // "1"
		case 0x32: // "2"
		case 0x33: // "3"
		case 0x34: // "4"
		case 0x35: // "5"
		case 0x36: // "6"
		case 0x37: // "7"
		case 0x38: // "8"
		case 0x39: // "9"
//			CmdKeyNumber(uCmdNo - 0x30);
			break;

		case 0x41: // "A"
		case 0x42: // "B"
		case 0x43: // "C"
		case 0x44: // "D"
		case 0x45: // "E"
		case 0x46: // "F"
		case 0x47: // "G"
		case 0x48: // "H"
		case 0x49: // "I"
		case 0x4a: // "J"
			break;

		case 0x4b: // "K"
			CmdKeyKMakeDir();
			break;

		case 0x4c: // "L"
			CmdKeyLChangeDrive();
			break;


		case 0x4d: // "M"
		case 0x4e: // "N"
		case 0x4f: // "O"
		case 0x50: // "P"
		case 0x51: // "Q"
		case 0x52: // "R"
		case 0x53: // "S"
		case 0x54: // "T"
		case 0x55: // "U"
		case 0x56: // "V"
		case 0x57: // "W"
		case 0x58: // "X"
		case 0x59: // "Y"
		case 0x5a: // "Z"
//			CmdKeyAlpha(uCmdNo - 0x41);
			break;

		case 0x60: // "0" eL[
		case 0x61: // "1"
		case 0x62: // "2"
		case 0x63: // "3"
		case 0x64: // "4"
		case 0x65: // "5"
		case 0x66: // "6"
		case 0x67: // "7"
		case 0x68: // "8"
		case 0x69: // "9"
//			CmdKeyNumber(uCmdNo - 0x60);
			break;


		// Shift+
		case 0x108: // "Backspace"
			break;

		case 0x10d: // "Enter"
//			CmdKeyShiftEnter();
			break;

		case 0x121: // PageUp
			break;

		case 0x122: // PageDown
			break;


		case 0x125: // ""
			break;

		case 0x126: // ""
			break;

		case 0x127: // ""
			break;

		case 0x128: // ""
			break;

		case 0x130: // "0"
		case 0x131: // "1"
		case 0x132: // "2"
		case 0x133: // "3"
		case 0x134: // "4"
		case 0x135: // "5"
		case 0x136: // "6"
		case 0x137: // "7"
		case 0x138: // "8"
		case 0x139: // "9"
//			CmdKeyNumber(uCmdNo - 0x130 + 36);
			break;

		case 0x160: // "0" eL[
		case 0x161: // "1"
		case 0x162: // "2"
		case 0x163: // "3"
		case 0x164: // "4"
		case 0x165: // "5"
		case 0x166: // "6"
		case 0x167: // "7"
		case 0x168: // "8"
		case 0x169: // "9"
//			CmdKeyNumber(uCmdNo - 0x160 + 36);
			break;

		case 0x141: // "A"
		case 0x142: // "B"
		case 0x143: // "C"
		case 0x144: // "D"
		case 0x145: // "E"
		case 0x146: // "F"
		case 0x147: // "G"
		case 0x148: // "H"
		case 0x149: // "I"
		case 0x14a: // "J"
		case 0x14b: // "K"
		case 0x14c: // "L"
		case 0x14d: // "M"
		case 0x14e: // "N"
		case 0x14f: // "O"
		case 0x150: // "P"
		case 0x151: // "Q"
		case 0x152: // "R"
		case 0x153: // "S"
		case 0x154: // "T"
		case 0x155: // "U"
		case 0x156: // "V"
		case 0x157: // "W"
		case 0x158: // "X"
		case 0x159: // "Y"
		case 0x15a: // "Z"
//			CmdKeyAlpha(uCmdNo - 0x141 + 36);
			break;

		// Ctrl+
		case 0x208: // "Backspace"
			break;

		case 0x20d: // "Enter"
			break;

		case 0x221: // PageUp
			break;

		case 0x222: // PageDown
			break;


		case 0x225: // ""
			break;

		case 0x226: // ""
			break;

		case 0x227: // ""
			break;

		case 0x228: // ""
			break;

		case 0x230: // "0"
		case 0x231: // "1"
		case 0x232: // "2"
		case 0x233: // "3"
		case 0x234: // "4"
		case 0x235: // "5"
		case 0x236: // "6"
		case 0x237: // "7"
		case 0x238: // "8"
		case 0x239: // "9"
//			CmdKeyNumber(uCmdNo - 0x230 + 72);
			break;

		case 0x260: // "0" eL[
		case 0x261: // "1"
		case 0x262: // "2"
		case 0x263: // "3"
		case 0x264: // "4"
		case 0x265: // "5"
		case 0x266: // "6"
		case 0x267: // "7"
		case 0x268: // "8"
		case 0x269: // "9"
//			CmdKeyNumber(uCmdNo - 0x260 + 72);
			break;

		case 0x241: // "A"
		case 0x242: // "B"
		case 0x243: // "C"
		case 0x244: // "D"
		case 0x245: // "E"
		case 0x246: // "F"
		case 0x247: // "G"
		case 0x248: // "H"
		case 0x249: // "I"
		case 0x24a: // "J"
		case 0x24b: // "K"
		case 0x24c: // "L"
		case 0x24d: // "M"
		case 0x24e: // "N"
		case 0x24f: // "O"
		case 0x250: // "P"
		case 0x251: // "Q"
		case 0x252: // "R"
		case 0x253: // "S"
		case 0x254: // "T"
		case 0x255: // "U"
		case 0x256: // "V"
		case 0x257: // "W"
		case 0x258: // "X"
		case 0x259: // "Y"
		case 0x25a: // "Z"
//			CmdKeyAlpha(uCmdNo - 0x241 + 72);
			break;

	}
}


void CannsTreeView::OnSize(UINT nType, int cx, int cy)
{
	CScrollView::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B

	CRect rc;
	GetClientRect(rc);
	int wh = rc.bottom - rc.top - m_FontH + 1;

	m_nPageLineNum = wh / m_FontH;


	SetScrollData();
}

// tH_f[^̓ǂݍ
// path:ǂݍރtH_̃pX([gpX܂)
// treeData:ǂݍރc[f[^NX̃|C^
// \̂̓ǂݍ݊Jnʒu
int CannsTreeView::ReadTreeData(CString path, CTreeData *treeData, int nHierar, int start)
{
	int n = 0;

	CString fpath;
	fpath = path + _T("*.*");

	struct _wfinddata64_t c_file;
	intptr_t hFile;
	CString fn, mydir, parentdir;
	int at;

	CTreeData *tdSystem = new CTreeData[TMP_DIR_NUM];
	CTreeData *tdHidden = new CTreeData[TMP_DIR_NUM];
	CTreeData *tdReadonly = new CTreeData[TMP_DIR_NUM];
	CTreeData *tdNormal = new CTreeData[TMP_DIR_NUM];

	int nSys= 0;
	int nHid= 0;
	int nRdo= 0;
	int nNor= 0;

	mydir = _T(".");
	parentdir = _T("..");

	if( (hFile = _wfindfirst64( fpath, &c_file )) != -1L ) {
		at = c_file.attrib;
		fn = c_file.name;

		if ( (at & _A_SUBDIR) != 0 ) {
			if ( fn != mydir && fn != parentdir) {
				if ( (at & _A_SYSTEM) != 0 ) {
					tdSystem[nSys].sDirName = fn;
					tdSystem[nSys].sFullDirName = path + fn + STR_YEN;
					tdSystem[nSys].nAttri = at;
					tdSystem[nSys].nHierar = nHierar;
					tdSystem[nSys].nStat = 0;
					tdSystem[nSys].nSubDir = -1;
					tdSystem[nSys].bEnable = true;
					nSys++;
				} else {
					if ( (at & _A_HIDDEN) != 0 ) {
						tdHidden[nHid].sDirName = fn;
						tdHidden[nHid].sFullDirName = path + fn + STR_YEN;
						tdHidden[nHid].nAttri = at;
						tdHidden[nHid].nHierar = nHierar;
						tdHidden[nHid].nStat = 0;
						tdHidden[nHid].nSubDir = -1;
						tdSystem[nHid].bEnable = true;
						nHid++;
					} else {
						if ( (at & _A_RDONLY) != 0 ) {
							tdReadonly[nRdo].sDirName = fn;
							tdReadonly[nRdo].sFullDirName = path + fn + STR_YEN;
							tdReadonly[nRdo].nAttri = at;
							tdReadonly[nRdo].nHierar = nHierar;
							tdReadonly[nRdo].nStat = 0;
							tdReadonly[nRdo].nSubDir = -1;
							tdReadonly[nRdo].bEnable = true;
							nRdo++;
						} else {
							tdNormal[nNor].sDirName = fn;
							tdNormal[nNor].sFullDirName = path + fn + STR_YEN;
							tdNormal[nNor].nAttri = at;
							tdNormal[nNor].nHierar = nHierar;
							tdNormal[nNor].nStat = 0;
							tdNormal[nNor].nSubDir = -1;
							tdNormal[nNor].bEnable = true;
							nNor++;
						}
					}
				}
			}
		}


		while( _wfindnext64( hFile, &c_file ) == 0 ) {
			at = c_file.attrib;
			fn = c_file.name;

			if ( (at & _A_SUBDIR) != 0 ) {
				if (fn != mydir && fn != parentdir ) {
					if ( (at & _A_SYSTEM) != 0 ) {
						tdSystem[nSys].sDirName = fn;
						tdSystem[nSys].sFullDirName = path + fn + STR_YEN;
						tdSystem[nSys].nAttri = at;
						tdSystem[nSys].nHierar = nHierar;
						tdSystem[nSys].nStat = 0;
						tdSystem[nSys].nSubDir = -1;
						tdSystem[nSys].bEnable = true;
						nSys++;
					} else {
						if ( (at & _A_HIDDEN) != 0 ) {
							tdHidden[nHid].sDirName = fn;
							tdHidden[nHid].sFullDirName = path + fn + STR_YEN;
							tdHidden[nHid].nAttri = at;
							tdHidden[nHid].nHierar = nHierar;
							tdHidden[nHid].nStat = 0;
							tdHidden[nHid].nSubDir = -1;
							tdHidden[nHid].bEnable = true;
							nHid++;
						} else {
							if ( (at & _A_RDONLY) != 0 ) {
								tdReadonly[nRdo].sDirName = fn;
								tdReadonly[nRdo].sFullDirName = path + fn + STR_YEN;
								tdReadonly[nRdo].nAttri = at;
								tdReadonly[nRdo].nHierar = nHierar;
								tdReadonly[nRdo].nStat = 0;
								tdReadonly[nRdo].nSubDir = -1;
								tdReadonly[nRdo].bEnable = true;
								nRdo++;
							} else {
								tdNormal[nNor].sDirName = fn;
								tdNormal[nNor].sFullDirName = path + fn + STR_YEN;
								tdNormal[nNor].nAttri = at;
								tdNormal[nNor].nHierar = nHierar;
								tdNormal[nNor].nStat = 0;
								tdNormal[nNor].nSubDir = -1;
								tdNormal[nNor].bEnable = true;
								nNor++;
							}
						}
					}
				}
			}

		}
		_findclose( hFile );
	}

	SortTreeData(tdSystem, 0, nSys - 1);
	SortTreeData(tdHidden, 0, nHid - 1);
	SortTreeData(tdReadonly, 0, nRdo - 1);
	SortTreeData(tdNormal, 0, nNor - 1);

	int tn= 0;

	for ( n = 0; n < nSys; n++ ) {
		treeData[tn].Copy(tdSystem[n]);

		tn++;
	}

	for ( n = 0; n < nHid; n++ ) {
		treeData[tn].Copy(tdHidden[n]);

		tn++;
	}

	for ( n = 0; n < nRdo; n++ ) {
		treeData[tn].Copy(tdReadonly[n]);

		tn++;
	}

	for ( n = 0; n < nNor; n++ ) {
		treeData[tn].Copy(tdNormal[n]);
		tn++;
	}

	delete []tdSystem;
	delete []tdHidden;
	delete []tdReadonly;
	delete []tdNormal;

	return tn;
}

void CannsTreeView::SortTreeData(CTreeData* tdata, int start, int end)
{
	int i = start;
	int j = end;
	int npivot = start + ((j - i) / 2);
	int ret = 0;

	if ( i >= j ) return;

	CTreeData tmptdata;
	CTreeData pivotdata;

	pivotdata.Copy(tdata[npivot]);

	while(1) {
		while( 1 ) {
			ret = CompareName(tdata[i].sDirName, pivotdata.sDirName);
			if ( ret < 0 ) i++;
			else break;
		}
		while( 1 ) {
			ret = CompareName(tdata[j].sDirName, pivotdata.sDirName);
			if ( ret > 0 ) j--;
			else break;
		}
		if (i >= j) {
			break;
		}
		tmptdata.Copy(tdata[i]);
		tdata[i].Copy(tdata[j]);
		tdata[j].Copy(tmptdata);

		i++;
		j--;
	}
	if (start < (i - 1) ) SortTreeData(tdata, start, i - 1);
	if ((j + 1) < end) SortTreeData(tdata, j + 1, end);

	return;
}

int CannsTreeView::CompareName(CString sTreedata, CString sPivotdata)
{
	CString name1, name2;
	int r;

	name1 = sTreedata;
	name2 = sPivotdata;

	m_pFmParam->ChangeAsciiStrings(&name1, &name2);

	CStringA nameA1, nameA2;
	nameA1 = CW2A(name1);
	nameA2 = CW2A(name2);


//	if ( m_SortNoCase ) {
		r = nameA1.CompareNoCase(nameA2);
//	} else {
//		r = nameA1.Compare(nameA2);
//	}

	return r;
}


// L[R}h ==================================

// Cmd No 0x0d
void CannsTreeView::CmdKeyEnter(void)
{
	CString path;
	path = m_ptdRootData[m_nCurLine].sFullDirName;

	m_pFmParam->m_sSelectedTreePath = path;
	if ( m_pTreeFrameWindow->m_pwndParent != NULL ) {
		m_pTreeFrameWindow->m_pwndParent->PostMessageW( WM_COMMAND, ID_TREE_MESSAGE, 0);

	}
	if ( m_pTreeFrameWindow->m_bExit ) OnTreeExit();
}

void CannsTreeView::OnTreeExit()
{
	// TODO: ɃR}h nh R[hǉ܂B
		m_pTreeFrameWindow->DestroyWindow();
}

void CannsTreeView::CmdKeyLeft(void)
{
	int stat = 	m_ptdRootData[m_nCurLine].nStat;
	int nchi = m_ptdRootData[m_nCurLine].nHierar;
	if ( stat != 1 ) {
		if ( m_nCurLine == 0 ) return;

		int n = m_nCurLine - 1;

		while (1) {
			int nhi = m_ptdRootData[n].nHierar;
			if ( nhi < nchi ) break;
			n--;
			if ( n == 0 ) break;
		}
		m_nCurLine = n;
	} else {

		m_ptdRootData[m_nCurLine].nStat = 0;

		int n = m_nCurLine + 1;
		int ct = 0;

		while (1) {
			int nhi = m_ptdRootData[n].nHierar;
			if ( nhi <= nchi ) break;

			int ne = m_ptdRootData[n].bEnable;
			if ( ne ) {
				m_ptdRootData[n].bEnable = false;
				ct++;
			}
			n++;
		}

		m_nMaxNum -= ct;
	}

	if ((m_nDrawStartLineNum + m_nPageLineNum) > m_nMaxNum) {
		m_nDrawStartLineNum = m_nMaxNum - m_nPageLineNum;
		if (m_nDrawStartLineNum < 0) m_nDrawStartLineNum = 0;
	}

	Invalidate();
	SetScrollData();
	CPoint pt;
	pt.x = 0;
	pt.y = m_nDrawStartLineNum * m_FontH;
	ScrollToPosition(pt);

}

void CannsTreeView::CmdKeyUp(void)
{
	// TODO: ɃR}h nh R[hǉ܂B

	int n = m_nCurLine;
	int be = false;

	while ( !be ) {
		n--;
		be = m_ptdRootData[n].bEnable;
		if ( n < 0 ) {
			n = m_nCurLine;
			break;
		}
	}

	m_nCurLine = n;

	if ( m_nCurLine < 0 ) m_nCurLine = 0;

	if ( m_pnDrawLine[m_nCurLine] < m_nDrawStartLineNum ) {
		m_nDrawStartLineNum--;
		if ( m_nDrawStartLineNum < 0 ) m_nDrawStartLineNum = 0;
		CPoint pt;
		pt.x = 0;
		pt.y = m_nDrawStartLineNum * m_FontH;
		ScrollToPosition(pt);
	}

	Invalidate();

}

void CannsTreeView::CmdKeyRight(void)
{
	int stat = 	m_ptdRootData[m_nCurLine].nStat;
	if ( stat != 0 ) {
		return;
	}

	int nDir = 	m_ptdRootData[m_nCurLine].nSubDir;
	if ( nDir != -1 ) {

		m_ptdRootData[m_nCurLine].nStat = 1;

		int n = m_nCurLine + 1;
		int ct = 0;	// \LɂtH_
		int nCurrentHierar = m_ptdRootData[m_nCurLine].nHierar;	// J(Jg)tH_̊Kw

		while (1) {
			int nhi = m_ptdRootData[n].nHierar;	// 蒆tH_̊Kw
			if ( nhi <= nCurrentHierar ) break;	// 蒆tH_̊KwJtH_󂢂ȂI

			int nst = m_ptdRootData[n].nStat;	// 蒆̃tH_̃Xe[^X
			m_ptdRootData[n].bEnable = true;
			ct++;
			n++;

			if ( nst == 0 ) {	// Ă
				while (1) {
					int nhi2 = m_ptdRootData[n].nHierar;	// ݂̃tH_̊Kw
					if ( nhi2 <= nCurrentHierar ) break;	// 蒆tH_̊KwJtH_󂢂ȂI
					if ( nhi2 <= nhi ) break;
					n++;
				}
			}

		}

		m_nMaxNum += ct;

		Invalidate();
		SetScrollData();
		return;
	}

	CString path;
	path = m_ptdRootData[m_nCurLine].sFullDirName;
	int hi = m_ptdRootData[m_nCurLine].nHierar;
	int rn = ReadTreeData(path, m_ptdTempData, hi + 1);

	if ( rn == 0 ) {
		m_ptdRootData[m_nCurLine].nStat = 2;
		Invalidate();
		return;
	}

	int st = m_nMaxDirNum - 1;
	int dt = st + rn;
	int start = m_nCurLine + 1;
	int end = m_nMaxDirNum - start;

	for ( int k = 0; k < end; k++ ) {
		m_ptdRootData[dt].Copy(m_ptdRootData[st]);

		st--;
		dt--;
	}

	dt = start;
	for ( int k = 0; k < rn; k++ ) {
		m_ptdRootData[dt].Copy(m_ptdTempData[k]);
		dt++;
	}
	m_nMaxNum += rn;
	m_nMaxDirNum += rn;
	m_ptdRootData[m_nCurLine].nStat = 1;
	m_ptdRootData[m_nCurLine].nSubDir = rn;
	Invalidate();
	SetScrollData();
}

void CannsTreeView::CmdKeyDown(void)
{
	// TODO: ɃR}h nh R[hǉ܂B

	int n = m_nCurLine;
	int be = false;

	while ( !be ) {
		n++;
		be = m_ptdRootData[n].bEnable;
		if ( n == m_nMaxDirNum ) {
			n = m_nCurLine;
			break;
		}
	}

	m_nCurLine = n;

	if ( m_nCurLine >= m_nMaxDirNum ) m_nCurLine = m_nMaxDirNum - 1;

	int pmax = m_nDrawStartLineNum + m_nPageLineNum;
	if ( m_pnDrawLine[m_nCurLine] > pmax ) {
		m_nDrawStartLineNum++;
		pmax = m_nDrawStartLineNum + m_nPageLineNum;
		if ( pmax > m_nMaxNum ) m_nDrawStartLineNum = m_nMaxNum - m_nPageLineNum;
		CPoint pt;
		pt.x = 0;
		pt.y = m_nDrawStartLineNum * m_FontH;
		ScrollToPosition(pt);
	}

	Invalidate();


}

void CannsTreeView::CmdKeyPageUp(void)
{
	// TODO: ɃR}h nh R[hǉ܂B

	int n = m_nDrawStartLineNum;
	int pw = m_nPageLineNum / 2;
	bool be;
	int cl = m_nCurLine;

	if (m_nMaxNum <= m_nPageLineNum) {
		cl -= pw;
		if (cl < 0) cl = 0;
	}
	else {
		while (pw != 0) {
			n--;
			if (n < 0) {
				n = 0;
				break;
			}
			be = m_ptdRootData[n].bEnable;
			if (be) {
				pw--;
			}
		}
		cl = m_nCurLine - (m_nDrawStartLineNum - n);
		if (cl <= 0 || n == 0) cl = 0;

	}



	m_nCurLine = cl;
	m_nDrawStartLineNum = n;

	CPoint pt;

	Invalidate();

	pt.x = 0;
	pt.y = m_nDrawStartLineNum * m_FontH;
	ScrollToPosition(pt);

}

void CannsTreeView::CmdKeyPageDown(void)
{
	// TODO: ɃR}h nh R[hǉ܂B

	int n = m_nDrawStartLineNum;
	int pw = m_nPageLineNum / 2;
	bool be;

	int cl = m_nCurLine;

	if (m_nMaxNum <= m_nPageLineNum) {
		while (pw != 0) {
			n++;
			if (n == m_nMaxNum) {
				cl = m_nMaxDirNum - 1;
				break;
			}

			cl++;
			if (cl >= m_nMaxDirNum) cl = m_nMaxDirNum - 1;

			be = m_ptdRootData[n].bEnable;
			if (be) {
				pw--;
			}
		}
		n = m_nDrawStartLineNum;
	}
	else {
		while (pw != 0) {
			n++;
			if (n >= m_nMaxNum) {
				cl = m_nMaxDirNum - 1;
				n = m_nDrawStartLineNum;
				break;
			}

			cl++;
			if (cl >= m_nMaxDirNum) cl = m_nMaxDirNum - 1;

			be = m_ptdRootData[n].bEnable;
			if (be) {
				pw--;
			}
		}

	}

	m_nCurLine = cl;
	m_nDrawStartLineNum = n;


	CPoint pt;

	Invalidate();

	pt.x = 0;
	pt.y = m_nDrawStartLineNum * m_FontH;
	ScrollToPosition(pt);

}


// Cmd No 0x4b
void CannsTreeView::CmdKeyKMakeDir(void)
{
	CMakeDirDialog dlg;
	dlg.m_pFmParam = m_pFmParam;

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	dlg.m_sCurDir = cpath;

	INT_PTR id = dlg.DoModal();

	if ( id == IDOK ) {
		CString path;
		path = m_ptdRootData[m_nCurLine].sFullDirName;
		path += dlg.m_Path;
		m_pFmParam->MakeFullPath(path);
		path = m_pFmParam->m_FullPath;
		bool r = m_pFmParam->MakeDirectory(path);
		if ( r ) {
			CString fext;
			fext = _T(".hid");
			m_pFmParam->ReadHistoryFile(fext, NULL);
			m_pFmParam->WriteHistoryFile(fext, path);

			int nsdir = m_ptdRootData[m_nCurLine].nSubDir;
			if (nsdir < 0) {	// JgtH_̃TutH_ǂݍ
				m_ptdRootData[m_nCurLine].nStat = 0;
				CmdKeyRight();
			}
			else {
				int end = m_nCurLine + 1;
				int start = m_nMaxDirNum;

				for (int n = start; n > end; n--) {
					m_ptdRootData[n].Copy(m_ptdRootData[n - 1]);
				}

				cpath = m_ptdRootData[m_nCurLine].sFullDirName;
				int rn = ReadTreeData(cpath, m_ptdTempData, m_ptdRootData[m_nCurLine].nHierar + 1);

				int dt = end;
				for (int n = 0; n < rn; n++) {
					m_ptdRootData[dt].Copy(m_ptdTempData[n]);
					dt++;

				}

				m_nMaxNum++;
				m_nMaxDirNum++;
				m_ptdRootData[m_nCurLine].nSubDir++;
				m_ptdRootData[m_nCurLine].nStat = 1;

			}



			int n = m_ptdRootData[m_nCurLine].nSubDir;
			int nc = m_nCurLine + 1;
			path += _T("\\");
			while ( n > 0 ) {
				CString spath = m_ptdRootData[nc].sFullDirName;
				if ( spath == path ) {
					int ns = nc - m_nCurLine;
					m_nCurLine = nc;
					int pmax = m_nDrawStartLineNum + m_nPageLineNum;
					if (m_nCurLine > pmax) {
						m_nDrawStartLineNum += ns;
						CPoint pt;
						pt.x = 0;
						pt.y = m_nDrawStartLineNum * m_FontH;
						ScrollToPosition(pt);
					}
					break;
				}
				n--;
				nc++;
			}

			Invalidate();

			return;

		}
	}

}
// Cmd No 0x4b
void CannsTreeView::CmdKeyLChangeDrive(void)
{
	CSelectDriveDialog dlg;

	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	INT_PTR id = dlg.DoModal();

	if ( id == IDOK ) {
		CString sd;
		sd = dlg.m_sDriveName.Left(3);

		int i = 0;
		while ( 1 ) {
			int h = m_ptdRootData[i].nHierar;
			if ( h == 0 ) {
				CString st;
				st = m_ptdRootData[i].sFullDirName.Left(3);
				if ( sd == st ) {
					break;
				}
			}
			i++;
		}
		m_nCurLine = i;
		m_nDrawStartLineNum = m_pnDrawLine[i] - (m_nPageLineNum / 2);
		if ( m_nDrawStartLineNum < 0 ) m_nDrawStartLineNum = 0;

		Invalidate();

		CmdKeyRight();

		CPoint pt;
		pt.x = 0;
		pt.y = m_nDrawStartLineNum * m_FontH;
		ScrollToPosition(pt);
		
	}
}



BOOL CannsTreeView::MouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	if ( zDelta < 0 ) CmdKeyDown();
	else CmdKeyUp();

	return TRUE;

	return CScrollView::OnMouseWheel(nFlags, zDelta, pt);
}

void CannsTreeView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CPoint pt;

	switch(nSBCode) {
		case SB_LINEUP:	// XN[{bNX̏NbNꍇ
			m_nDrawStartLineNum--;
			if ( m_nDrawStartLineNum < 0 ) m_nDrawStartLineNum = 0;

			if ( m_nCurLine >= (m_nDrawStartLineNum + m_nPageLineNum) ) m_nCurLine = m_nDrawStartLineNum + m_nPageLineNum - 1;
			if ( m_nCurLine >= m_nMaxNum ) m_nCurLine = m_nMaxNum - 1;

			Invalidate();

			pt.y = m_nDrawStartLineNum * m_FontH;
			ScrollToPosition(pt);

			break;

		case SB_LINEDOWN:	// XN[{bNX̉NbNꍇ
			m_nDrawStartLineNum++;
			if ( m_nDrawStartLineNum > (m_nMaxNum - m_nPageLineNum) ) m_nDrawStartLineNum = m_nMaxNum - m_nPageLineNum;

			if ( m_nCurLine < m_nDrawStartLineNum ) m_nCurLine = m_nDrawStartLineNum;

			Invalidate();

			pt.y = m_nDrawStartLineNum * m_FontH;
			ScrollToPosition(pt);

			break;

		case SB_PAGEUP:		// XN[{bNX̏㑤NbNꍇi܂PageUpL[j
			CmdKeyPageUp();
			break;

		case SB_PAGEDOWN:		// XN[{bNX̉NbNꍇi܂PageDownL[j
			CmdKeyPageDown();
			break;

		case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
			break;

		case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
			m_nDrawStartLineNum = nPos / m_FontH;
			if ( m_nCurLine < m_nDrawStartLineNum ) m_nCurLine = m_nDrawStartLineNum;
			if ( m_nCurLine >= (m_nDrawStartLineNum + m_nPageLineNum) ) m_nCurLine = m_nDrawStartLineNum + m_nPageLineNum - 1;
			if ( m_nCurLine >= m_nMaxNum ) m_nCurLine = m_nMaxNum - 1;

			Invalidate();

			pt.y = m_nDrawStartLineNum * m_FontH;
			ScrollToPosition(pt);
			break;

	}

//	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CannsTreeView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CmdKeyEnter();

//	CScrollView::OnLButtonDblClk(nFlags, point);
}


BOOL CannsTreeView::OnScrollBy(CSize sizeScroll, BOOL bDoScroll)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB

	return FALSE;


//	return CScrollView::OnScrollBy(sizeScroll, bDoScroll);
}


BOOL CannsTreeView::OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB


	return CScrollView::OnScroll(nScrollCode, nPos, bDoScroll);
}
