#pragma once


class CannsViewFrame;

#include "FmParam.h"
#include <gdiplus.h>
#include "spi.h"

#include <d2d1.h>               // Direct2D
#include <d2d1helper.h>         // Direct2D
#include <atlbase.h>            // Direct2D ATLˑ
#include <wincodec.h>           // WIC
#include <wincodecsdk.h>        // WIC


using namespace Gdiplus;

#define DELTA_MULTI 1500	// \{l
#define GMAG_REF 10000	// \{l
#define GMAG_FREF 10000.0F	// \{l(float)
#define GMAG100 100	// 100%\{

#define XMIN 400
#define YMIN 160


#define ID_SAVE_FILETIME_CHECK 500;
#define ID_SAVE_QUALITY_TEXT 501;
#define ID_SAVE_QUALITY_EDITBOX 502;

// CannsGView r[

class CannsGView : public CScrollView
{
	DECLARE_DYNCREATE(CannsGView)

protected:

public:
	CannsGView();           // IŎgp protected RXgN^
	virtual ~CannsGView();

//	BOOL GetEncoderClsid(const WCHAR* format, CLSID* pClsid);
//	bool SaveJpeg(LPCTSTR lpszFile, ULONG nQuality = 80);

	void RunKeyCmd(UINT uCmdNo);

	void Resize(bool flg);

	void CmdKeyEnter(void);
	void CmdKeySpace(void);

	bool RedrawGdi(int nFileNo, CString sFullname);

	void CmdKeyLeft(void);
	void CmdKeyRight(void);
	void CmdKeyUp(void);
	void CmdKeyDown(void);
	void CmdKeyPageUp(void);
	void CmdKeyPageDown(void);
	void CmdKeyNumber(UINT uCmdNo);
	void CmdKeyQuit(void);
	void CmdKeyExif(void);

	void CmdKeyColon(void);
	void CmdKeySemiColon(void);
	void CmdKeyComma(void);
	void CmdKeyPeriod(void);
	void CmdKeyMaximum(void);

	void CmdKeyShiftLeft(void);
	void CmdKeyShiftRight(void);
	void CmdKeyShiftUp(void);
	void CmdKeyShiftDown(void);
	void CmdKeyShiftExif(void);

	void CmdKeyAutoOrientation(void);
	void CmdKeyAdjustSize(void);
	bool CmdKeyCtrlRResize(void);
	bool CmdKeyCtrlSSave(void);
	void CmdKeyCtrlTTrimming(void);

	IStream* getFileIStream(CString lpszPath);
	void GetColorBits(void);

	bool GetPictureSPI(void);
	bool GetArcFileSPI(void);

	CannsViewFrame* m_pViewFrame;	// eFrame

	CFmParam* m_pFmParam;
	CString m_sFileName;	// `悷t@C̃tpX
//	double m_Multi;	// `{
	int m_nMulti;	// A^C̕`{ 100%:IWi
	int m_nMultiNow;	// (k{ł͂Ȃ)̊gk`{

	GdiplusStartupInput m_gdiSI;
	ULONG_PTR           m_gdiToken;
	int m_Xw;	// 摜̉TCY
	int m_Yw;	// 摜̏cTCY

//    Image* m_gImage;
    Gdiplus::Bitmap* m_gImage;

//	bool m_bRedrawInit;	// ĕ`揉

	int m_nowXw;	// ݂̕\TCY
	int m_nowYw;	// ݂̕\cTCY

	CString m_sColorBits;	// 摜̐F

	REAL m_resH;	// 𑜓x
	REAL m_resV;	// 𑜓x

	CLSID	 encoderClsid;
//Pp[^w肵Ȃꍇ͂
	EncoderParameters encoderParameters;
//̃p[^w肷ꍇ͂
//	EncoderParameters* encoderParameters = (EncoderParameters*)malloc(sizeof(EncoderParameters) + 4 * sizeof(EncoderParameter));
// ULONG	 colordepth;
// ULONG	 quality;
// ULONG	 transformation;
// Status	 stat;

	bool m_bHVsizeFixed;	// gkcŒ


	LPBITMAPINFO		m_phBInfo;
	LPBYTE				m_phBm;

	HLOCAL m_hBInfo;
	HLOCAL m_hBm;
	HLOCAL m_hFInfo;

	LPSpiArcFileInfo m_pSpiArcFileInfo;

	char m_cArcFile[MAX_PATH];
	HANDLE m_hArcFilePage;
	HANDLE *m_phArcFilePage;

	int m_nPdfPage;	// axpdf.spiœWJPDFt@C̑y[W
	int m_nPdfPageNow;	// axpdf.spiœWJPDFt@Čݕ\Ăy[W

	bool m_bDragging;	// }EXhbO
	CPoint m_cpStartDrag;	// hbOJnʒu
	CPoint m_cpEndDrag;	// hbOIʒu
	bool m_bEnableRect;	// IL

	bool m_bMaximum;	// true : ő剻
	CRect m_rectOrgWindowSize;	// ő剻ÕEBhETCY

#ifndef _WINVER_XP

	CComPtr<ID2D1Factory>           m_gFactory;
	CComPtr<ID2D1HwndRenderTarget>  m_gTarget;
	CComPtr<ID2D1Bitmap>            m_gBitmap;

	CComPtr<IWICImagingFactory>     m_gImagingFactory;
	CComPtr<IWICBitmapDecoder>		m_gDecoder;
	CComPtr<IWICBitmapFrameDecode>	m_gFrameDec;

	CComPtr<ID2D1Bitmap>			m_d2dBitmap;
	CComPtr<ID2D1RenderTarget>		m_wicRenderTarget;
	CComPtr<IWICBitmap>				m_wicBitmap;

	CComPtr<IWICBitmap>				m_wicHbBitmap;

#endif



	WICRect m_wrectClip;	// g~OTCY


	int m_nRad;	// v̕\px 0:0x 1:90x 2:180x 3:270x
	FLOAT m_fFlipH;	// ]  1.0:ʏ  -1.0:]
	FLOAT m_fFlipV;	// ]  1.0:ʏ  -1.0:]

	int m_nBackColor;

	CString m_sSaveFilename;
	RECT m_rectTriming;


	CRect m_rectSelect;

	CString m_sOrgFileName;

	bool m_bRunCmd;
	bool m_bAlphaFormat;

	CString m_sDelFileName;
	CString m_sRenFileName;
	bool m_bSetSameTime;

	int m_nExifOrientation;	// Exif ]	3:v180x  6:v270x  8:v90x


#ifndef _WINVER_XP

	bool CreateWicD2DData(void);

	void discardResource();
	void ResizeViewD2D(void);
	bool CreateDrawData();
	bool CreateDrawDataFromHBitmap(HBITMAP hBitmap);
	bool CreateWicBitmap(UINT xw, UINT yw);

	void WICBitmapCopyToClipboard();
	void WICBitmapPasteFromClipboard(bool bAlpha = true);

	bool InitializeData();
	void SetScaleRotationTarget(void);
	void DrawCheckPattern(float xs, float ys, float xe, float ye);

#endif

	void InitScrollBar(void);




protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual void OnInitialUpdate();     // \z 1 
	bool GetArcFileSPIPage(int nPage);

	void FreeSPI(void);


	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnMenuKeyZoomup();
	afx_msg void OnMenuKeyZoomdown();
	afx_msg void OnMenuKeyUp();
	afx_msg void OnMenuKeyDown();
	afx_msg void OnMenuKeySpace();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);

	afx_msg void OnMenuKeyPeriod();
	afx_msg void OnMenuKeyComma();
	afx_msg void OnMenuFileSaveAs();
	afx_msg void OnMenuKeyCtrlR();
	afx_msg void OnFilePrint();
protected:
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
public:
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnMenuKeyCtrlT();
	afx_msg void OnMenuCtrlKeyC();
	afx_msg void OnMenuCtrlKeyV();
	afx_msg void OnMenuKeyCtrlB();
	afx_msg void OnMenuKeyColon();
	afx_msg void OnMenuKeySemicolon();
	afx_msg void OnCtrlKeyU();
	afx_msg void OnMenuCtrlKeyF();
	afx_msg void OnMenuCtrlKeyA();
	afx_msg void OnMenuKeyE();
	afx_msg void OnMenuKeyShiftE();
//	afx_msg void OnMouseHWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnKeyMenuW();


	int m_nFlip;	// ]  0:ʏ  1:E]

	BOOL GetEncoderClsid(const WCHAR* format, CLSID* pClsid);
	bool SaveJpeg(LPCTSTR lpszFile, ULONG nQuality = 80);
	void CmdKeyCtrlCCopyToClipboard(void);
	void CmdKeyCtrlVPaste(bool bAlpha = true);

	virtual BOOL OnScrollBy(CSize sizeScroll, BOOL bDoScroll = TRUE);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
};


