// annsGView.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "annsGView.h"
#include "annsViewFrame.h"
#include "FileView.h"
#include "SetGSize.h"
#include "FileSaveJpeg.h"
#include "SetExifProgram.h"

#include <windows.h>
#include <gdiplus.h>
#include <olectl.h>
// #include <fstream>
#include <string.h>

#include "io.h"
#include "shellapi.h"

#include <vector>

using namespace Gdiplus;


// CannsGView

IMPLEMENT_DYNCREATE(CannsGView, CScrollView)

CannsGView::CannsGView()
{

	m_sFileName = _T("");
	m_nMulti = GMAG_REF;
	m_nMultiNow = GMAG_REF;
	m_gImage = NULL;
	m_sColorBits = _T("");
	m_nowXw = 640;
	m_nowYw = 480;

	m_bHVsizeFixed = true;

	m_phBInfo = NULL;
	m_phBm = NULL;

	m_pSpiArcFileInfo = NULL;

	m_hArcFilePage = NULL;
	m_phArcFilePage = NULL;

	m_nPdfPage = 0;
	m_nPdfPageNow = 0;

	m_bDragging = false;	// }EXhbO
	m_cpStartDrag.x = 0;	// hbOJnʒu
	m_cpStartDrag.y = 0;	// hbOJnʒu
	m_cpEndDrag.x = 0;	// hbOIʒu
	m_cpEndDrag.y = 0;	// hbOIʒu
	m_bEnableRect = false;

#ifndef _WINVER_XP
	m_gTarget = NULL;
#endif


	m_sSaveFilename = _T("");

	m_fFlipH = 1.0;
	m_fFlipV = 1.0;

	m_bRunCmd = false;
	m_bAlphaFormat = false;

	m_hBInfo = NULL;
	m_hBm = NULL;
	m_hFInfo = NULL;
	m_nRad = 0;

	m_nBackColor = 0;

	m_nExifOrientation = 0;	// Exif ]	3:v180x  6:v270x  8:v90x

	m_bMaximum = false;

}

CannsGView::~CannsGView()
{


//	if ( m_gImage != NULL && !m_pFmParam->m_bAtypeSPI ) delete m_gImage;
	if (m_gImage != NULL) {
		FreeSPI();
		delete m_gImage;
		GdiplusShutdown(m_gdiToken);
	}

#ifndef _WINVER_XP

	if (m_gImagingFactory != NULL) {
		m_gImagingFactory.Release();
		m_gFactory.Release();
		m_gImagingFactory = NULL;
		m_gFactory = NULL;
		GdiplusShutdown(m_gdiToken);
	}

	if (m_gTarget) {
		discardResource();

		m_gDecoder.Release();
		m_gFrameDec.Release();

		m_d2dBitmap.Release();
		m_wicRenderTarget.Release();
		m_wicBitmap.Release();

		m_gTarget = NULL;
		m_gBitmap = NULL;

		m_gDecoder = NULL;
		m_gFrameDec = NULL;

		m_d2dBitmap = NULL;
		m_wicRenderTarget = NULL;
		m_wicBitmap = NULL;

		m_wicHbBitmap = NULL;

//		CoUninitialize();

	}
#endif

}


BEGIN_MESSAGE_MAP(CannsGView, CScrollView)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_KEY_ZOOMUP, &CannsGView::OnMenuKeyZoomup)
	ON_COMMAND(ID_KEY_ZOOMDOWN, &CannsGView::OnMenuKeyZoomdown)
	ON_COMMAND(ID_KEY_UP, &CannsGView::OnMenuKeyUp)
	ON_COMMAND(ID_KEY_DOWN, &CannsGView::OnMenuKeyDown)
	ON_COMMAND(ID_KEY_SPACE, &CannsGView::OnMenuKeySpace)
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_KEY_PERIOD, &CannsGView::OnMenuKeyPeriod)
	ON_COMMAND(ID_KEY_COMMA, &CannsGView::OnMenuKeyComma)
	ON_COMMAND(ID_FILE_SAVE_AS, &CannsGView::OnMenuFileSaveAs)
	ON_COMMAND(ID_KEY_CTRL_R, &CannsGView::OnMenuKeyCtrlR)
	ON_COMMAND(ID_FILE_PRINT, &CannsGView::OnFilePrint)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_KEY_CTRL_T, &CannsGView::OnMenuKeyCtrlT)
	ON_COMMAND(ID_CTRL_KEY_C, &CannsGView::OnMenuCtrlKeyC)
	ON_COMMAND(ID_CTRL_KEY_V, &CannsGView::OnMenuCtrlKeyV)
	ON_COMMAND(ID_KEY_CTRL_B, &CannsGView::OnMenuKeyCtrlB)
	ON_COMMAND(ID_KEY_COLON, &CannsGView::OnMenuKeyColon)
	ON_COMMAND(ID_KEY_SEMICOLON, &CannsGView::OnMenuKeySemicolon)
	ON_COMMAND(ID_CTRL_KEY_U, &CannsGView::OnCtrlKeyU)
	ON_COMMAND(ID_KEY_CTRL_F, &CannsGView::OnMenuCtrlKeyF)
	ON_COMMAND(ID_KEY_CTRL_A, &CannsGView::OnMenuCtrlKeyA)
	ON_COMMAND(ID_GVIEW_KEY_E, &CannsGView::OnMenuKeyE)
	ON_COMMAND(ID_GVIEW_KEY_SHIFT_E, &CannsGView::OnMenuKeyShiftE)
//	ON_WM_MOUSEHWHEEL()
	ON_WM_MOUSEWHEEL()
	ON_COMMAND(ID_KEY_W, &CannsGView::OnKeyMenuW)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
END_MESSAGE_MAP()



/* 摜ǂݍ񂾃ubNIStream쐬 */
IStream* CannsGView::getFileIStream(CString lpszPath) {

	HANDLE hFile;
	HGLOBAL hBuf;
	LPVOID lpBuf;

	IStream * isFile;

	DWORD dwFileSize, dwLoadSize;

	/* 摜t@CI[v */
	hFile = CreateFile(lpszPath, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	/* t@CTCY擾 */
	dwFileSize = GetFileSize(hFile, NULL);

	/* 摜t@Cf[^i[pubNm */
	hBuf = GlobalAlloc(GMEM_MOVEABLE, dwFileSize);

	/* ubNbNAhX擾 */
	lpBuf = GlobalLock(hBuf);

	/* 摜t@C̃f[^ubNɓǂݍ */
	ReadFile(hFile, lpBuf, GetFileSize(hFile, NULL), &dwLoadSize, NULL);

	CloseHandle(hFile);

	/* ubÑbN */
	GlobalUnlock(hBuf);

	/* ubNIStream쐬 */
	CreateStreamOnHGlobal(hBuf, TRUE, &isFile);

	/* IStreamԂ */
	return isFile;

}


bool CannsGView::GetPictureSPI(void)
{
	bool r = true;

	CString	sFindName = m_pFmParam->m_sFindFileSPI;


	if ( !sFindName.IsEmpty() ) {
//		HINSTANCE hInstance = LoadLibrary(sFindName);

		DWORD flag = 0xa00;
		SetDllDirectory(_T(""));
		HINSTANCE hInstance = LoadLibraryEx(sFindName, 0, flag);

		if ( hInstance )
		{
			SpiFuncGetPicture pSpiFuncGetPicture;
			pSpiFuncGetPicture = (SpiFuncGetPicture)GetProcAddress(hInstance, "GetPicture");

			if ( pSpiFuncGetPicture ) {
				CStringA sfA;
				sfA = CW2A(m_sFileName);
				FARPROC lpPrgressCallback = NULL;
				long nCallbackData = 0;

				FreeSPI();

				int ir = pSpiFuncGetPicture((LPSTR)sfA.GetBuffer(), 0, 0, &(m_hBInfo), &(m_hBm), lpPrgressCallback, nCallbackData);
				if ( ir == 0 ) {
					m_phBInfo = (LPBITMAPINFO)::LocalLock(m_hBInfo);
					m_phBm = (LPBYTE)::LocalLock(m_hBm);
				} else {
					ir = pSpiFuncGetPicture((LPSTR)sfA.GetBuffer(), 128, 0, &(m_hBInfo), &(m_hBm), lpPrgressCallback, nCallbackData);
					if ( ir == 0 || ir == 2 ) {
						m_phBInfo = (LPBITMAPINFO)::LocalLock(m_hBInfo);
						m_phBm = (LPBYTE)::LocalLock(m_hBm);
					} else r = false;
				}
			} else r = false;

			FreeLibrary( hInstance );
		} else r = false;
	} else r = false;


	return r;
}

void CannsGView::FreeSPI(void)
{
	if (m_hBInfo != NULL) {
		::LocalUnlock(m_hBInfo);
		::LocalFree(m_hBInfo);
		m_hBInfo = NULL;
	}
	if (m_hBm != NULL) {
		::LocalUnlock(m_hBm);
		::LocalFree(m_hBm);
		m_hBm = NULL;
	}
	if (m_hFInfo != NULL) {
		::LocalUnlock(m_hFInfo);
		::LocalFree(m_hFInfo);
		m_hFInfo = NULL;
	}
	if (m_hArcFilePage != NULL) {
		::LocalUnlock(m_hArcFilePage);
//		::LocalFree(m_hArcFilePage);
		m_hArcFilePage = NULL;
	}


}


bool CannsGView::GetArcFileSPI(void)
{
	bool r = true;

	CString	sFindName = m_pFmParam->m_sFindFileSPI;

	if ( !sFindName.IsEmpty() ) {
//		HINSTANCE hInstance = LoadLibrary( sFindName );

		DWORD flag = 0xa00;
		SetDllDirectory(_T(""));
		HINSTANCE hInstance = LoadLibraryEx(sFindName, 0, flag);

		if ( hInstance )
		{
			SpiFuncGetArchiveInfo pSpiFuncGetArchiveInfo;
			pSpiFuncGetArchiveInfo = (SpiFuncGetArchiveInfo)GetProcAddress(hInstance, "GetArchiveInfo");

			if ( pSpiFuncGetArchiveInfo ) {
				CStringA sfA;
				sfA = CW2A(m_sFileName);


				FreeSPI();

				int ir = pSpiFuncGetArchiveInfo((LPSTR)sfA.GetBuffer(), 0, 0, &(m_hFInfo));
				if ( ir == 0 ) {
					m_pSpiArcFileInfo = (LPSpiArcFileInfo)::LocalLock(m_hFInfo);

					m_nPdfPage = 0;
					m_nPdfPageNow = 0;
					while ( m_pSpiArcFileInfo[m_nPdfPage].method[0] != 0 ) {
						m_nPdfPage++;
					}


				} else {
					r = false;
				}
			} else r = false;

			FreeLibrary( hInstance );
		} else r = false;
	} else r = false;


	return r;
}

bool CannsGView::GetArcFileSPIPage(int nPage)
{
	bool r = true;

	CString	sFindName = m_pFmParam->m_sFindFileSPI;

	if ( !sFindName.IsEmpty() ) {
//		HINSTANCE hInstance = LoadLibrary( sFindName );

		DWORD flag = 0xa00;
		SetDllDirectory(_T(""));
		HINSTANCE hInstance = LoadLibraryEx(sFindName, 0, flag);

		if ( hInstance )
		{
			SpiFuncGetFile pSpiFuncGetFile;
			pSpiFuncGetFile = (SpiFuncGetFile)GetProcAddress(hInstance, "GetFile");

			if ( pSpiFuncGetFile ) {

				if ( m_phArcFilePage != NULL ) {
					::LocalUnlock(m_phArcFilePage);
					m_phArcFilePage = NULL;
				}

				int ir = pSpiFuncGetFile((LPSTR)CW2A(m_sFileName), m_pSpiArcFileInfo[nPage].position, (LPSTR)&m_hArcFilePage, 0x100, NULL, NULL);
				if ( ir == 0 ) {

					m_phArcFilePage = (HANDLE*)::LocalLock(m_hArcFilePage);
				} else r = false;

			}
			FreeLibrary( hInstance );
		}
	}

	return r;
}

#ifndef _WINVER_XP

bool CannsGView::CreateWicD2DData(void)
{

//	if (m_gTarget) {

		discardResource();

		// WICC[WOt@Ng[쐬
		if (FAILED(CoCreateInstance(
			CLSID_WICImagingFactory,
			NULL,
			CLSCTX_INPROC_SERVER,
			IID_IWICImagingFactory,
			reinterpret_cast<void **>(&m_gImagingFactory)
			))
			)
		{
			MessageBox(_T("ImagingFactory쐬Ɏs"), _T("WICG["));
			return false;
		}

		// D2Dt@Ng[쐬
		HRESULT hr = D2D1CreateFactory(D2D1_FACTORY_TYPE_SINGLE_THREADED, &m_gFactory);
		if (FAILED(hr))
		{
			MessageBox(_T("D2Dt@Ng쐬Ɏs"), _T("WICG["));
			return false;
		}

//	}

//		HRESULT hr;
		// _[^[Qbg̍쐬
		RECT rect;
		GetClientRect(&rect);
		
		auto render_target_properties = D2D1::RenderTargetProperties(); // 
		render_target_properties.type = D2D1_RENDER_TARGET_TYPE_SOFTWARE; // 

		hr = m_gFactory->CreateHwndRenderTarget(
			render_target_properties, // 
//			D2D1::RenderTargetProperties(),
			D2D1::HwndRenderTargetProperties(
			//			hWnd,
			this->m_hWnd,
			D2D1::Size(
			static_cast<UINT>(rect.right - rect.left),
			static_cast<UINT>(rect.bottom - rect.top)
			)
			),
			&m_gTarget
			);

		if (FAILED(hr))
		{
			MessageBox(_T("_[^[Qbg쐬Ɏs"), _T("WICG["));
			return false;
		}


		// 摜t@C̓Ǎ
		// t@CfR[_쐬
		//		CComPtr<IWICBitmapDecoder> dec;
		hr = m_gImagingFactory->CreateDecoderFromFilename(
			m_sFileName,
			NULL,
			GENERIC_READ,
			WICDecodeMetadataCacheOnLoad,
			&m_gDecoder);
		if (FAILED(hr))
		{
			MessageBox(_T("fR[_[쐬Ɏs"), _T("WICG["));
			return false;
		}
		// t[擾
//		CComPtr<IWICBitmapFrameDecode> frame;
		hr = m_gDecoder->GetFrame(0, &m_gFrameDec);
		if (FAILED(hr))
		{
			MessageBox(_T("t[擾Ɏs"), _T("WICG["));
			return false;
		}
		// Ro[^Direct2DptH[}bgɕϊ
		CComPtr<IWICFormatConverter> converter;
		hr = m_gImagingFactory->CreateFormatConverter(&converter);
		if (FAILED(hr))
		{
			MessageBox(_T("Direct2DtH[}bgϊɎs"), _T("WICG["));
			return false;
		}
		hr = converter->Initialize(
			m_gFrameDec,
			GUID_WICPixelFormat32bppPBGRA,
			WICBitmapDitherTypeNone,
			NULL,
			0.f,
			WICBitmapPaletteTypeMedianCut);
		if (FAILED(hr))
		{
			MessageBox(_T("Direct2DtH[}bgϊɎs"), _T("WICG["));
			return false;
		}
		// Direct2Dprbg}bv쐬
		UINT32 max = m_gTarget->GetMaximumBitmapSize();
		CString smes;

		hr = m_gTarget->CreateBitmapFromWicBitmap(converter, NULL, &m_gBitmap);
		if (FAILED(hr))
		{

			smes.Format(_T("Direct2Drbg}bv쐬Ɏs܂B\n̊ŕ\łӂ̍őTCY%dłB"), max);
			MessageBox(smes, _T("WICG["));
			return false;
		}


		return true;

}

bool CannsGView::CreateWicBitmap(UINT xw, UINT yw)
{
	if (m_wicHbBitmap) return true;

	if (m_gTarget == NULL && m_gImage != NULL) return true;

	if (m_wicBitmap) {
		m_wicBitmap.Release();
		m_wicBitmap = NULL;
	}
	if (m_wicRenderTarget) {
		m_wicRenderTarget.Release();
		m_wicRenderTarget = NULL;
	}
	if (m_d2dBitmap) {
		m_d2dBitmap.Release();
		m_d2dBitmap = NULL;
	}

	HRESULT hr;


	// Ro[^Direct2DptH[}bgɕϊ
	CComPtr<IWICFormatConverter> converter;
	hr = m_gImagingFactory->CreateFormatConverter(&converter);
	if (FAILED(hr))
	{
		MessageBox(_T("Direct2DtH[}bgϊɎs"), _T("WICG["));
		return false;
	}

	hr = converter->Initialize(
		m_gFrameDec,
		GUID_WICPixelFormat32bppPBGRA,
		WICBitmapDitherTypeNone,
		NULL,
		0.f,
		WICBitmapPaletteTypeMedianCut);

	if (FAILED(hr))
	{
		MessageBox(_T("Direct2DtH[}bgϊɎs"), _T("WICG["));
		return false;
	}



	// WICrbg}bv쐬
	hr = m_gImagingFactory->CreateBitmap(
		static_cast<unsigned int>(xw), static_cast<unsigned int>(yw),
		GUID_WICPixelFormat32bppPBGRA,
		WICBitmapCacheOnLoad, &m_wicBitmap);

	if (FAILED(hr))
	{
		MessageBox(_T("Direct2DtH[}bgϊɎs"), _T("WICG["));
		return false;
	}

	hr = m_gFactory->CreateWicBitmapRenderTarget(
		m_wicBitmap, D2D1::RenderTargetProperties(), &m_wicRenderTarget);

	if (FAILED(hr))
	{
		MessageBox(_T("Direct2DtH[}bgϊɎs"), _T("WICG["));
		return false;
	}

	// Direct2Dprbg}bv쐬
//	hr = m_wicRenderTarget->CreateBitmapFromWicBitmap(m_wicBitmap, NULL, &m_d2dBitmap);
	hr = m_wicRenderTarget->CreateBitmapFromWicBitmap(converter, NULL, &m_d2dBitmap);

	if (FAILED(hr))
	{
		MessageBox(_T("Direct2DtH[}bgϊɎs"), _T("WICG["));
		return false;
	}

	return true;
}


void CannsGView::discardResource()
{
	if (m_gImagingFactory) {
		m_gImagingFactory.Release();
		m_gImagingFactory = NULL;
	}

	if (m_gTarget) {
		m_gTarget.Release();
		m_gTarget = NULL;
	}

	if (m_gFactory) {
		m_gFactory.Release();
		m_gFactory = NULL;
	}

	if (m_gDecoder) {
		m_gDecoder.Release();
		m_gDecoder = NULL;
	}

	if (m_gFrameDec) {
		m_gFrameDec.Release();
		m_gFrameDec = NULL;
	}

	if (m_gBitmap) {
		m_gBitmap.Release();
		m_gBitmap = NULL;
	}

	if (m_wicBitmap) {
		m_wicBitmap.Release();
		m_wicBitmap = NULL;
	}

	if (m_wicHbBitmap) {
		m_wicHbBitmap.Release();
		m_wicHbBitmap = NULL;
	}


	if (m_wicRenderTarget) {
		m_wicRenderTarget.Release();
		m_wicRenderTarget = NULL;
	}

	if (m_d2dBitmap) {
		m_d2dBitmap.Release();
		m_d2dBitmap = NULL;
	}

}

void CannsGView::ResizeViewD2D(void)
{
	RECT rect;
	//	m_pViewFrame->GetClientRect(&rect);
	//	MoveWindow(&rect);

	if (m_gTarget)
	{
		
		GetClientRect(&rect);
		m_gTarget->Resize(
			D2D1::Size(
			static_cast<UINT>(rect.right - rect.left),
			static_cast<UINT>(rect.bottom - rect.top)
			)
			);
		
	}
}

bool CannsGView::CreateDrawDataFromHBitmap(HBITMAP hBitmap)
{
	discardResource();



	//			CComPtr<IWICImagingFactory>     gImagingFactory;
	//			CComPtr<ID2D1Factory>           gFactory;
	//			CComPtr<IWICBitmap>		wicBitmap;


	// WICC[WOt@Ng[쐬
	if (FAILED(CoCreateInstance(
		CLSID_WICImagingFactory,
		NULL,
		CLSCTX_INPROC_SERVER,
		IID_IWICImagingFactory,
		reinterpret_cast<void **>(&m_gImagingFactory)
		))
		)
	{
		MessageBox(_T("ImagingFactory쐬Ɏs"), _T("WICG["));
		return false;
	}

	// D2Dt@Ng[쐬
	HRESULT hr = D2D1CreateFactory(D2D1_FACTORY_TYPE_SINGLE_THREADED, &m_gFactory);
	if (FAILED(hr))
	{
		MessageBox(_T("D2Dt@Ng쐬Ɏs"), _T("D2DG["));
		return false;
	}

	// _[^[Qbg̍쐬
	RECT rect;
	GetClientRect(&rect);
	hr = m_gFactory->CreateHwndRenderTarget(
		D2D1::RenderTargetProperties(),
		D2D1::HwndRenderTargetProperties(
			//			hWnd,
			this->m_hWnd,
			D2D1::Size(
				static_cast<UINT>(rect.right - rect.left),
				static_cast<UINT>(rect.bottom - rect.top)
				)
			),
		&m_gTarget
		);

	if (FAILED(hr))
	{
		MessageBox(_T("_[^[Qbg쐬Ɏs"), _T("WICG["));
		return false;
	}

	bool bAlpha = m_bAlphaFormat;
//	bool bAlpha = true;


//	Gdiplus::Bitmap* gImage = new Gdiplus::Bitmap(hBitmap, NULL);


	if (bAlpha) {
	hr = m_gImagingFactory->CreateBitmapFromHBITMAP(hBitmap, NULL, WICBitmapUseAlpha, &m_wicHbBitmap);
	}
	else {
	hr = m_gImagingFactory->CreateBitmapFromHBITMAP(hBitmap, NULL, WICBitmapIgnoreAlpha, &m_wicHbBitmap);
	}

	if (FAILED(hr))
	{
		MessageBox(_T("rbg}bv쐬Ɏs"), _T("WICG["));
		return false;
	}

	m_wicBitmap = m_wicHbBitmap;

	/*
	CComPtr<IWICBitmapDecoder> dec;
	m_gImagingFactory->CreateDecoder(
	GUID_ContainerFormatBmp,
	NULL,
	&dec);


	// t[擾
	CComPtr<IWICBitmapFrameDecode> frame;
	dec->GetFrame(0, &frame);

	//			CComPtr<IWICBitmapSource> pwicSource = nullptr;
	//			m_gFrameDec->QueryInterface(IID_PPV_ARGS(&pwicSource));

	*/

	// Ro[^Direct2DptH[}bgɕϊ
	CComPtr<IWICFormatConverter> converter;
	m_gImagingFactory->CreateFormatConverter(&converter);
	converter->Initialize(
	m_wicHbBitmap,
	GUID_WICPixelFormat32bppPBGRA,
	WICBitmapDitherTypeNone,
	NULL,
	0.f,
	WICBitmapPaletteTypeMedianCut);
	

	// Direct2Dprbg}bv쐬
//	hr = m_gTarget->CreateBitmapFromWicBitmap(m_wicHbBitmap, NULL, &m_gBitmap);
	hr = m_gTarget->CreateBitmapFromWicBitmap(converter, NULL, &m_gBitmap);
	//			hr = m_gTarget->CreateBitmapFromWicBitmap(pwicSource, NULL, &m_gBitmap);
	if (FAILED(hr))
	{
		MessageBox(_T("Direct2Drbg}bv쐬Ɏs"), _T("WICG["));
		return false;
	}

	if (m_gBitmap == NULL) {
		MessageBox(_T("Direct2Drbg}bv쐬(from HBitmap)Ɏs"), _T("WICG["));
		return false;

	}

	GetColorBits();

	return true;
}



bool CannsGView::CreateDrawData(void)
{

	bool r = true;

	m_nRad = 0;
//	m_nMulti = 100;

	m_Xw = 640;
	m_Yw = 480;

	if (m_pFmParam->m_bFindSPI) {
		if (!m_pFmParam->m_bAtypeSPI) {
			bool rr = GetPictureSPI();
			if (rr) m_gImage = new Gdiplus::Bitmap((BITMAPINFO *)m_phBInfo, m_phBm);
		}
		else {
			bool rr = GetArcFileSPI();
			if (rr) {
				GetArcFileSPIPage(m_nPdfPageNow);
				IStream *is = NULL;
				CreateStreamOnHGlobal(m_phArcFilePage, TRUE, &is);
				m_gImage = new Gdiplus::Bitmap(is);
				is->Release();
			}
		}
		if (m_gImage) {


			Gdiplus::Color col = (255, 255, 255);
			HBITMAP hBitmap;
			m_gImage->GetHBITMAP(col, &hBitmap);

			GetColorBits();
			bool rr = CreateDrawDataFromHBitmap(hBitmap);
			DeleteObject(hBitmap);

			if (rr) {
//				FreeSPI();
//				m_nPdfPage = 0;
				m_nPdfPageNow = 0;
				delete m_gImage;
				m_gImage = NULL;
				//			m_pFmParam->m_bFindSPI = false;

				//			GetColorBits();

				m_rectTriming.left = 0;
				m_rectTriming.right = 0;
				m_rectTriming.top = 0;
				m_rectTriming.bottom = 0;

				m_Xw = (int)m_gBitmap->GetSize().width;
				m_Yw = (int)m_gBitmap->GetSize().height;

				m_gTarget->Resize(D2D1::Size(static_cast<UINT>(m_Xw), static_cast<UINT>(m_Yw)));

//				m_nRad = 0;

				m_nowXw = m_Xw * m_nMulti / GMAG_REF;
				m_nowYw = m_Yw * m_nMulti / GMAG_REF;


				m_pViewFrame->AdjustSize();

				InitScrollBar();

//				ResizeViewD2D();
				m_pViewFrame->DrawFileName();
				Invalidate();
				UpdateWindow();

				m_sOrgFileName = m_sFileName;


			}
			else {
				r = false;
			}

		}
	}
	else {
		if (m_gImage != NULL) {
			FreeSPI();
			m_nPdfPage = 0;
			m_nPdfPageNow = 0;
			delete m_gImage;
			m_gImage = NULL;
			m_pFmParam->m_bFindSPI = false;
		}

		m_rectTriming.left = 0;
		m_rectTriming.right = 0;
		m_rectTriming.top = 0;
		m_rectTriming.bottom = 0;

		r = CreateWicD2DData();
		if (!r) return false;

		m_Xw = (int)m_gBitmap->GetSize().width;
		m_Yw = (int)m_gBitmap->GetSize().height;

		m_gTarget->Resize(D2D1::Size(static_cast<UINT>(m_Xw), static_cast<UINT>(m_Yw)));


		bool rr = CreateWicBitmap(m_Xw, m_Yw);
		if (!rr) {
			return false;
		}

//		m_nRad = 0;

		m_nowXw = m_Xw * m_nMulti / GMAG_REF;
		m_nowYw = m_Yw * m_nMulti / GMAG_REF;

		ResizeViewD2D();

		m_pViewFrame->AdjustSize();

		GetColorBits();

		InitScrollBar();

		Invalidate();
//			UpdateWindow();


		m_pViewFrame->DrawFileName();

		m_sOrgFileName = m_sFileName;

		Bitmap bmp(m_sFileName);
		/*
		const UINT cbBuf = bmp.GetPropertyItemSize(PropertyTagExifDTOrig);

		PropertyItem* const pItem = static_cast<PropertyItem*>(_alloca(cbBuf));
		bmp.GetPropertyItem(PropertyTagExifDTOrig, cbBuf, pItem);
		CStringA sExif;
		if (cbBuf) {
		sExif = static_cast<const char*>(pItem->value);

		}
		*/

		const UINT cbBuf2 = bmp.GetPropertyItemSize(PropertyTagOrientation);

		PropertyItem* const pItem2 = static_cast<PropertyItem*>(_alloca(cbBuf2));
		bmp.GetPropertyItem(PropertyTagOrientation, cbBuf2, pItem2);
		short *og;
		m_nExifOrientation = 0;
		if (cbBuf2) {
			og = (short *)pItem2->value;
			m_nExifOrientation = *og;

		}

		if (m_pFmParam->m_bAutoOrientation) {

			Invalidate();


			CSize sizeTotal;
			sizeTotal.cx = m_nowXw;
			sizeTotal.cy = m_nowYw;

			if (m_nExifOrientation == 3) {	// v180x
				CmdKeyPeriod();
				CmdKeyPeriod();
			}
			if (m_nExifOrientation == 6) {	// v270x
				CmdKeyPeriod();
				sizeTotal.cx = m_nowYw;
				sizeTotal.cy = m_nowXw;
			}
			if (m_nExifOrientation == 8) {	// v90x
				CmdKeyComma();
				sizeTotal.cx = m_nowYw;
				sizeTotal.cy = m_nowXw;
			}

			SetScrollSizes(MM_TEXT, sizeTotal);

			SetScrollPos(SB_HORZ, 0);
			SetScrollPos(SB_VERT, 0);

		}

	}

	return r;
}

bool CannsGView::InitializeData(void)
{

	if (m_pFmParam->m_nOSversion < 7) {
		return true;
	}

	GdiplusStartup(&m_gdiToken, &m_gdiSI, NULL);

	//	CoInitialize(NULL);

	if (FAILED(CoCreateInstance(
		CLSID_WICImagingFactory,
		NULL,
		CLSCTX_INPROC_SERVER,
		IID_IWICImagingFactory,
		reinterpret_cast<void **>(&m_gImagingFactory)
		))
		)
	{
		MessageBox(_T("ImagingFactory쐬Ɏs"), _T("D2DG["));
		//		return -1;
	}
	HRESULT hr = D2D1CreateFactory(D2D1_FACTORY_TYPE_SINGLE_THREADED, &m_gFactory);
	if (FAILED(hr))
	{
		MessageBox(_T("D2Dt@Ng쐬Ɏs"), _T("D2DG["));
		//		return -1;
	}
	m_nBackColor = m_pFmParam->m_nViewBackColor;

	bool r = CreateDrawData();

	Invalidate();
	UpdateWindow();

	return r;

}

#endif

void CannsGView::InitScrollBar(void)
{


	CSize sizeTotal;
	sizeTotal.cx = m_nowXw;
	sizeTotal.cy = m_nowYw;

	SetScrollSizes(MM_TEXT, sizeTotal);

	SetScrollPos(SB_HORZ, 0);
	SetScrollPos(SB_VERT, 0);
}


void CannsGView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	if (m_pFmParam->m_nOSversion < 7) {
		GdiplusStartup(&m_gdiToken, &m_gdiSI, NULL);

//		m_pFmParam->m_hBInfo = NULL;
//		m_pFmParam->m_hBm = NULL;
//		m_pFmParam->m_hFInfo = NULL;

		m_nRad = 0;
		m_nFlip = 0;

		if (m_pFmParam->m_bFindSPI) {
			if (!m_pFmParam->m_bAtypeSPI) {
				bool r = GetPictureSPI();
				if (r) m_gImage = new Gdiplus::Bitmap((BITMAPINFO *)m_phBInfo, m_phBm);
				else m_gImage = NULL;
			}
			else {
				bool r = GetArcFileSPI();
				if (r) {
					GetArcFileSPIPage(m_nPdfPageNow);
					IStream *is = NULL;
					CreateStreamOnHGlobal(m_phArcFilePage, TRUE, &is);
					m_gImage = new Gdiplus::Bitmap(is);
					is->Release();
				}
				else m_gImage = NULL;
			}
		}
		else {
			/* 摜t@CǂݍIStream쐬 */
			IStream * is = getFileIStream(m_sFileName);

			/* IStreamBitmap쐬 */
			m_gImage = new Gdiplus::Bitmap(is);

			/* IStream */
			is->Release();
		}

		if (m_gImage) {

			m_sOrgFileName = m_sFileName;

			m_Xw = m_gImage->GetWidth();
			m_Yw = m_gImage->GetHeight();

			m_nowXw = m_Xw;
			m_nowYw = m_Yw;

			//	m_bRedrawInit = true;

			GetColorBits();

			//		m_pViewFrame->ResizeGViewFrame(m_nowXw, m_nowYw, true);

			m_pViewFrame->AdjustSize();
			InitScrollBar();
			m_nBackColor = m_pFmParam->m_nViewBackColor;

			m_resH = m_gImage->GetHorizontalResolution();
			m_resV = m_gImage->GetVerticalResolution();

			const UINT cbBuf2 = m_gImage->GetPropertyItemSize(PropertyTagOrientation);

			PropertyItem* const pItem2 = static_cast<PropertyItem*>(_alloca(cbBuf2));
			m_gImage->GetPropertyItem(PropertyTagOrientation, cbBuf2, pItem2);
			short *og;
			m_nExifOrientation = 0;
			if (cbBuf2) {
				og = (short *)pItem2->value;
				m_nExifOrientation = *og;

			}
			if (m_pFmParam->m_bAutoOrientation) {

				Invalidate();


				CSize sizeTotal;
				sizeTotal.cx = m_nowXw;
				sizeTotal.cy = m_nowYw;

				if (m_nExifOrientation == 3) {	// v180x
					CmdKeyPeriod();
					CmdKeyPeriod();
				}
				if (m_nExifOrientation == 6) {	// v270x
					CmdKeyPeriod();
					sizeTotal.cx = m_nowYw;
					sizeTotal.cy = m_nowXw;
				}
				if (m_nExifOrientation == 8) {	// v90x
					CmdKeyComma();
					sizeTotal.cx = m_nowYw;
					sizeTotal.cy = m_nowXw;
				}

				SetScrollSizes(MM_TEXT, sizeTotal);

				SetScrollPos(SB_HORZ, 0);
				SetScrollPos(SB_VERT, 0);

			}


		}


	}



}

void CannsGView::GetColorBits(void)
{
	m_sColorBits = _T("");

	if (m_gImage) {
//		m_bAlphaFormat = false;

		PixelFormat pf = m_gImage->GetPixelFormat();

		switch (pf) {
		case PixelFormat1bppIndexed:
			m_sColorBits = _T("x1bppIndexed");
			break;

		case PixelFormat4bppIndexed:
			m_sColorBits = _T("x4bppIndexed");
			break;

		case PixelFormat8bppIndexed:
			m_sColorBits = _T("x8bppIndexed");
			break;

		case PixelFormat16bppGrayScale:
			m_sColorBits = _T("x16bppGrayScale");
			break;

		case PixelFormat16bppRGB555:
			m_sColorBits = _T("x16bppRGB555");
			break;

		case PixelFormat16bppRGB565:
			m_sColorBits = _T("x16bppRGB565");
			break;

		case PixelFormat16bppARGB1555:
			m_sColorBits = _T("x16bppARGB1555");
			m_bAlphaFormat = true;
			break;

		case PixelFormat24bppRGB:
			m_sColorBits = _T("x24bppRGB");
			break;

		case PixelFormat32bppRGB:
			m_sColorBits = _T("x32bppRGB");
			break;

		case PixelFormat32bppARGB:
			m_sColorBits = _T("x32bppARGB");
			m_bAlphaFormat = true;
			break;

		case PixelFormat32bppPARGB:
			m_sColorBits = _T("x32bppPARGB");
			m_bAlphaFormat = true;
			break;

		case PixelFormat48bppRGB:
			m_sColorBits = _T("x48bppRGB");
			break;

		case PixelFormat64bppARGB:
			m_sColorBits = _T("x48bppARGB");
			m_bAlphaFormat = true;
			break;

		case PixelFormat64bppPARGB:
			m_sColorBits = _T("x64bppPARGB");
			m_bAlphaFormat = true;
			break;

			//		case PixelFormatMAX :
			//			m_sColorBits = _T("Full");
			//			break;
		}

		return;

	}

#ifndef _WINVER_XP

	if (m_gTarget) {
//		m_bAlphaFormat = true;
		WICPixelFormatGUID pf;

		if (m_gFrameDec) {
			m_gFrameDec->GetPixelFormat(&pf);
		}
		if (m_wicHbBitmap) {
			m_wicHbBitmap->GetPixelFormat(&pf);
		}

		m_sColorBits = _T("Unknown");

		// Indexed Pixel Formats
		if (pf == GUID_WICPixelFormat1bppIndexed) m_sColorBits = _T("x1bppIndexed");
		if (pf == GUID_WICPixelFormat2bppIndexed) m_sColorBits = _T("x2bppIndexed");
		if (pf == GUID_WICPixelFormat4bppIndexed) m_sColorBits = _T("x4bppIndexed");
		if (pf == GUID_WICPixelFormat8bppIndexed) m_sColorBits = _T("8bppIndexed");

		// Packed Bit Pixel Formats
		if (pf == GUID_WICPixelFormat16bppBGR555) m_sColorBits = _T("x16bppBGR555");
		if (pf == GUID_WICPixelFormat16bppBGR565) m_sColorBits = _T("x16bppBGR565");
//		if (pf == GUID_WICPixelFormat16bppBGRA555) m_sColorBits = _T("x16bppBGRA555");
		if (pf == GUID_WICPixelFormat32bppBGR101010) m_sColorBits = _T("x32bppBGR101010");
		if (pf == GUID_WICPixelFormat32bppRGBA1010102) m_sColorBits = _T("x32bppRGBA1010102");
		if (pf == GUID_WICPixelFormat32bppRGBA1010102XR) m_sColorBits = _T("x32bppRGBA1010102XR");

		// Grayscale Pixel Formats
		if (pf == GUID_WICPixelFormatBlackWhite) m_sColorBits = _T("xBlackWhite");
		if (pf == GUID_WICPixelFormat2bppGray) m_sColorBits = _T("x2bppGray");
		if (pf == GUID_WICPixelFormat4bppGray) m_sColorBits = _T("x4bppGray");
		if (pf == GUID_WICPixelFormat8bppGray) m_sColorBits = _T("x8bppGray");
		if (pf == GUID_WICPixelFormat16bppGray) m_sColorBits = _T("x16bppGray");
		if (pf == GUID_WICPixelFormat16bppGrayFixedPoint) m_sColorBits = _T("x16bppGrayFixedPoint");
		if (pf == GUID_WICPixelFormat16bppGrayHalf) m_sColorBits = _T("x16bppGrayHalf");
		if (pf == GUID_WICPixelFormat32bppGrayFloat) m_sColorBits = _T("x32bppGrayFloat");
		if (pf == GUID_WICPixelFormat32bppGrayFixedPoint) m_sColorBits = _T("x32bppGrayFixedPoint");

		// RGB/BGR Pixel formats
		if (pf == GUID_WICPixelFormat24bppRGB) m_sColorBits = _T("x24bppRGB");
		if (pf == GUID_WICPixelFormat24bppBGR) m_sColorBits = _T("x24bppBGR");
		if (pf == GUID_WICPixelFormat32bppBGR) m_sColorBits = _T("x32bppBGR");
		if (pf == GUID_WICPixelFormat32bppRGBA) m_sColorBits = _T("x32bppRGBA");
		if (pf == GUID_WICPixelFormat32bppBGRA) m_sColorBits = _T("x32bppBGRA");
		if (pf == GUID_WICPixelFormat32bppRGBE) m_sColorBits = _T("x32bppRGBE");
		if (pf == GUID_WICPixelFormat32bppPRGBA) m_sColorBits = _T("x32bppPRGBA");
		if (pf == GUID_WICPixelFormat32bppPBGRA) m_sColorBits = _T("x32bppPBGRA");
		if (pf == GUID_WICPixelFormat48bppRGB) m_sColorBits = _T("x48bppRGB");
		if (pf == GUID_WICPixelFormat48bppBGR) m_sColorBits = _T("x48bppBGR");
		if (pf == GUID_WICPixelFormat48bppRGBFixedPoint) m_sColorBits = _T("x48bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat48bppBGRFixedPoint) m_sColorBits = _T("x48bppBGRFixedPoint");
		if (pf == GUID_WICPixelFormat48bppRGBHalf) m_sColorBits = _T("x48bppRGBHalf");
		if (pf == GUID_WICPixelFormat64bppRGBA) m_sColorBits = _T("x64bppRGBA");
		if (pf == GUID_WICPixelFormat64bppBGRA) m_sColorBits = _T("x64bppBGRA");
		if (pf == GUID_WICPixelFormat64bppPRGBA) m_sColorBits = _T("x64bppPRGBA");
		if (pf == GUID_WICPixelFormat64bppPBGRA) m_sColorBits = _T("x64bppPBGRA");
		if (pf == GUID_WICPixelFormat64bppRGBFixedPoint) m_sColorBits = _T("x64bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat64bppRGBAFixedPoint) m_sColorBits = _T("x64bppRGBAFixedPoint");
		if (pf == GUID_WICPixelFormat64bppBGRAFixedPoint) m_sColorBits = _T("x64bppBGRAFixedPoint");
		if (pf == GUID_WICPixelFormat64bppRGBHalf) m_sColorBits = _T("x64bppRGBHalf");
		if (pf == GUID_WICPixelFormat64bppRGBAHalf) m_sColorBits = _T("x64bppRGBAHalf");
		if (pf == GUID_WICPixelFormat96bppRGBFixedPoint) m_sColorBits = _T("x96bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat128bppRGBFloat) m_sColorBits = _T("x128bppRGBFloat");
		if (pf == GUID_WICPixelFormat128bppRGBAFloat) m_sColorBits = _T("x128bppRGBAFloat");
		if (pf == GUID_WICPixelFormat128bppPRGBAFloat) m_sColorBits = _T("x128bppPRGBAFloat");
		if (pf == GUID_WICPixelFormat128bppRGBFixedPoint) m_sColorBits = _T("x128bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat128bppRGBAFixedPoint) m_sColorBits = _T("x128bppRGBAFixedPoint");

		// CMYK Pixel Formats
		if (pf == GUID_WICPixelFormat32bppCMYK) m_sColorBits = _T("x32bppCMYK");
		if (pf == GUID_WICPixelFormat64bppCMYK) m_sColorBits = _T("x64bppCMYK");
		if (pf == GUID_WICPixelFormat40bppCMYKAlpha) m_sColorBits = _T("x40bppCMYKAlpha");
		if (pf == GUID_WICPixelFormat80bppCMYKAlpha) m_sColorBits = _T("x80bppCMYKAlpha");

		//n-channel Pixel Formats
		if (pf == GUID_WICPixelFormat24bpp3Channels) m_sColorBits = _T("x24bpp3Channels");
		if (pf == GUID_WICPixelFormat48bpp3Channels) m_sColorBits = _T("x48bpp3Channels");
		if (pf == GUID_WICPixelFormat32bpp3ChannelsAlpha) m_sColorBits = _T("x32bpp3ChannelsAlpha");
		if (pf == GUID_WICPixelFormat64bpp3ChannelsAlpha) m_sColorBits = _T("x64bpp3ChannelsAlpha");
		if (pf == GUID_WICPixelFormat32bpp4Channels) m_sColorBits = _T("x32bpp4Channels");
		if (pf == GUID_WICPixelFormat64bpp4Channels) m_sColorBits = _T("x64bpp4Channels");
		if (pf == GUID_WICPixelFormat40bpp4ChannelsAlpha) m_sColorBits = _T("x40bpp4ChannelsAlpha");
		if (pf == GUID_WICPixelFormat80bpp4ChannelsAlpha) m_sColorBits = _T("x80bpp4ChannelsAlpha");
		if (pf == GUID_WICPixelFormat40bpp5Channels) m_sColorBits = _T("x40bpp5Channels");
		if (pf == GUID_WICPixelFormat80bpp5Channels) m_sColorBits = _T("x80bpp5Channels");
		if (pf == GUID_WICPixelFormat48bpp5ChannelsAlpha) m_sColorBits = _T("x48bpp5ChannelsAlpha");
		if (pf == GUID_WICPixelFormat96bpp5ChannelsAlpha) m_sColorBits = _T("x96bpp5ChannelsAlpha");
		if (pf == GUID_WICPixelFormat48bpp6Channels) m_sColorBits = _T("x48bpp6Channels");
		if (pf == GUID_WICPixelFormat96bpp6Channels) m_sColorBits = _T("x96bpp6Channels");
		if (pf == GUID_WICPixelFormat56bpp6ChannelsAlpha) m_sColorBits = _T("x56bpp6ChannelsAlpha");
		if (pf == GUID_WICPixelFormat112bpp6ChannelsAlpha) m_sColorBits = _T("x112bpp6ChannelsAlpha");
		if (pf == GUID_WICPixelFormat56bpp7Channels) m_sColorBits = _T("x56bpp7Channels");
		if (pf == GUID_WICPixelFormat112bpp7Channels) m_sColorBits = _T("x112bpp7Channels");
		if (pf == GUID_WICPixelFormat64bpp7ChannelsAlpha) m_sColorBits = _T("x64bpp7ChannelsAlpha");
		if (pf == GUID_WICPixelFormat128bpp7ChannelsAlpha) m_sColorBits = _T("x128bpp7ChannelsAlpha");
		if (pf == GUID_WICPixelFormat64bpp8Channels) m_sColorBits = _T("x64bpp8Channels");
		if (pf == GUID_WICPixelFormat128bpp8Channels) m_sColorBits = _T("x128bpp8Channels");
		if (pf == GUID_WICPixelFormat72bpp8ChannelsAlpha) m_sColorBits = _T("x72bpp8ChannelsAlpha");
		if (pf == GUID_WICPixelFormat144bpp8ChannelsAlpha) m_sColorBits = _T("x144bpp8ChannelsAlpha");
		
		// Alpha Only Pixel Formats
		if (pf == GUID_WICPixelFormat8bppAlpha) m_sColorBits = _T("x8bppAlpha");

		// YfCbCr Pixel Formats
//		if (pf == GUID_WICPixelFormat8bppY) m_sColorBits = _T("x8bppY");
//		if (pf == GUID_WICPixelFormat8bppCb) m_sColorBits = _T("x8bppCb");
//		if (pf == GUID_WICPixelFormat8bppCr) m_sColorBits = _T("x8bppCr");
//		if (pf == GUID_WICPixelFormat16bppCbCr) m_sColorBits = _T("x16bppCbCr");

		// BMP Native Codec
		if (pf == GUID_WICPixelFormat1bppIndexed) m_sColorBits = _T("x1bppIndexed");
		if (pf == GUID_WICPixelFormat4bppIndexed) m_sColorBits = _T("x4bppIndexed");
		if (pf == GUID_WICPixelFormat8bppIndexed) m_sColorBits = _T("x8bppIndexed");
		if (pf == GUID_WICPixelFormat16bppBGR555) m_sColorBits = _T("x16bppBGR555");
		if (pf == GUID_WICPixelFormat16bppBGR565) m_sColorBits = _T("x16bppBGR565");
		if (pf == GUID_WICPixelFormat24bppBGR) m_sColorBits = _T("x24bppBGR");
		if (pf == GUID_WICPixelFormat32bppBGR) m_sColorBits = _T("x32bppBGR");
		if (pf == GUID_WICPixelFormat32bppBGRA) m_sColorBits = _T("x32bppBGRA");
		if (pf == GUID_WICPixelFormat64bppRGBAFixedPoint) m_sColorBits = _T("x64bppRGBAFixedPoint");

		// GIF Native Codec
		if (pf == GUID_WICPixelFormat8bppIndexed) m_sColorBits = _T("x8bppIndexed");

		// ICO Native Codec
		if (pf == GUID_WICPixelFormat32bppBGRA) m_sColorBits = _T("x32bppBGRA");


		// JPEG Native Codec
		if (pf == GUID_WICPixelFormat8bppGray) m_sColorBits = _T("x8bppGray");
		if (pf == GUID_WICPixelFormat24bppBGR) m_sColorBits = _T("x24bppBGR");
		if (pf == GUID_WICPixelFormat32bppCMYK) m_sColorBits = _T("x32bppCMYK");

		// PNG Native Codec
		if (pf == GUID_WICPixelFormat1bppIndexed) m_sColorBits = _T("x1bppIndexed");
		if (pf == GUID_WICPixelFormat2bppIndexed) m_sColorBits = _T("x2bppIndexed");
		if (pf == GUID_WICPixelFormat4bppIndexed) m_sColorBits = _T("x4bppIndexed");
		if (pf == GUID_WICPixelFormat8bppIndexed) m_sColorBits = _T("x8bppIndexed");
		if (pf == GUID_WICPixelFormatBlackWhite) m_sColorBits = _T("xBlackWhite");
		if (pf == GUID_WICPixelFormat2bppGray) m_sColorBits = _T("x2bppGray");
		if (pf == GUID_WICPixelFormat4bppGray) m_sColorBits = _T("x4bppGray");
		if (pf == GUID_WICPixelFormat8bppGray) m_sColorBits = _T("x8bppGray");
		if (pf == GUID_WICPixelFormat16bppGray) m_sColorBits = _T("x16bppGray");
		if (pf == GUID_WICPixelFormat24bppBGR) m_sColorBits = _T("x24bppBGR");
		if (pf == GUID_WICPixelFormat32bppBGRA) m_sColorBits = _T("x32bppBGRA");
		if (pf == GUID_WICPixelFormat48bppRGB) m_sColorBits = _T("x48bppRGB");
		if (pf == GUID_WICPixelFormat64bppRGBA) m_sColorBits = _T("x64bppRGBA");


		// TIFF Native Codec
		if (pf == GUID_WICPixelFormat1bppIndexed) m_sColorBits = _T("x1bppIndexed");
		if (pf == GUID_WICPixelFormat2bppIndexed) m_sColorBits = _T("x2bppIndexed");
		if (pf == GUID_WICPixelFormat4bppIndexed) m_sColorBits = _T("x4bppIndexed");
		if (pf == GUID_WICPixelFormat8bppIndexed) m_sColorBits = _T("x8bppIndexed");
		if (pf == GUID_WICPixelFormatBlackWhite) m_sColorBits = _T("xBlackWhite");
		if (pf == GUID_WICPixelFormat2bppGray) m_sColorBits = _T("x2bppGray");
		if (pf == GUID_WICPixelFormat4bppGray) m_sColorBits = _T("x4bppGray");
		if (pf == GUID_WICPixelFormat8bppGray) m_sColorBits = _T("x8bppGray");
		if (pf == GUID_WICPixelFormat16bppGray) m_sColorBits = _T("x16bppGray");
		if (pf == GUID_WICPixelFormat32bppGrayFloat) m_sColorBits = _T("x32bppGrayFloat");
		if (pf == GUID_WICPixelFormat24bppBGR) m_sColorBits = _T("x24bppBGR");
		if (pf == GUID_WICPixelFormat32bppBGRA) m_sColorBits = _T("x32bppBGRA");
		if (pf == GUID_WICPixelFormat32bppPBGRA) m_sColorBits = _T("x32bppPBGRA");
		if (pf == GUID_WICPixelFormat48bppRGB) m_sColorBits = _T("x48bppRGB");
		if (pf == GUID_WICPixelFormat32bppCMYK) m_sColorBits = _T("x32bppCMYK");
		if (pf == GUID_WICPixelFormat40bppCMYKAlpha) m_sColorBits = _T("x40bppCMYKAlpha");
		if (pf == GUID_WICPixelFormat64bppRGBA) m_sColorBits = _T("x64bppRGBA");
		if (pf == GUID_WICPixelFormat64bppPRGBA) m_sColorBits = _T("x64bppPRGBA");
		if (pf == GUID_WICPixelFormat64bppCMYK) m_sColorBits = _T("x64bppCMYK");
		if (pf == GUID_WICPixelFormat80bppCMYKAlpha) m_sColorBits = _T("x80bppCMYKAlpha");
//		if (pf == GUID_WICPixelFormat96bppRGBFloat) m_sColorBits = _T("x96bppRGBFloat");
		if (pf == GUID_WICPixelFormat128bppRGBAFloat) m_sColorBits = _T("x128bppRGBAFloat");
		if (pf == GUID_WICPixelFormat128bppPRGBAFloat) m_sColorBits = _T("x128bppPRGBAFloat");


		// JPEG-XR Native Codec
		if (pf == GUID_WICPixelFormatBlackWhite) m_sColorBits = _T("xBlackWhite");
		if (pf == GUID_WICPixelFormat8bppGray) m_sColorBits = _T("x8bppGray");
		if (pf == GUID_WICPixelFormat16bppBGR555) m_sColorBits = _T("x16bppBGR555");
		if (pf == GUID_WICPixelFormat16bppGray) m_sColorBits = _T("x16bppGray");
		if (pf == GUID_WICPixelFormat24bppBGR) m_sColorBits = _T("x24bppBGR");
		if (pf == GUID_WICPixelFormat24bppRGB) m_sColorBits = _T("x24bppRGB");
		if (pf == GUID_WICPixelFormat32bppBGR) m_sColorBits = _T("x32bppBGR");
		if (pf == GUID_WICPixelFormat32bppBGRA) m_sColorBits = _T("x32bppBGRA");
		if (pf == GUID_WICPixelFormat48bppRGBFixedPoint) m_sColorBits = _T("x48bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat16bppGrayFixedPoint) m_sColorBits = _T("x16bppGrayFixedPoint");
		if (pf == GUID_WICPixelFormat32bppBGR101010) m_sColorBits = _T("x32bppBGR101010");
		if (pf == GUID_WICPixelFormat48bppRGB) m_sColorBits = _T("x48bppRGB");
		if (pf == GUID_WICPixelFormat64bppRGBA) m_sColorBits = _T("x64bppRGBA");
		if (pf == GUID_WICPixelFormat96bppRGBFixedPoint) m_sColorBits = _T("x96bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat128bppRGBFloat) m_sColorBits = _T("x128bppRGBFloat");
		if (pf == GUID_WICPixelFormat32bppCMYK) m_sColorBits = _T("x32bppCMYK");
		if (pf == GUID_WICPixelFormat64bppRGBAFixedPoint) m_sColorBits = _T("x64bppRGBAFixedPoint");
		if (pf == GUID_WICPixelFormat128bppRGBAFixedPoint) m_sColorBits = _T("x128bppRGBAFixedPoint");
		if (pf == GUID_WICPixelFormat64bppCMYK) m_sColorBits = _T("x64bppCMYK");
		if (pf == GUID_WICPixelFormat24bpp3Channels) m_sColorBits = _T("x24bpp3Channels");
		if (pf == GUID_WICPixelFormat32bpp4Channels) m_sColorBits = _T("x32bpp4Channels");
		if (pf == GUID_WICPixelFormat40bpp5Channels) m_sColorBits = _T("x40bpp5Channels");
		if (pf == GUID_WICPixelFormat48bpp6Channels) m_sColorBits = _T("x48bpp6Channels");
		if (pf == GUID_WICPixelFormat56bpp7Channels) m_sColorBits = _T("x56bpp7Channels");
		if (pf == GUID_WICPixelFormat64bpp8Channels) m_sColorBits = _T("x64bpp8Channels");
		if (pf == GUID_WICPixelFormat48bpp3Channels) m_sColorBits = _T("x48bpp3Channels");
		if (pf == GUID_WICPixelFormat64bpp4Channels) m_sColorBits = _T("x64bpp4Channels");
		if (pf == GUID_WICPixelFormat80bpp5Channels) m_sColorBits = _T("x80bpp5Channels");
		if (pf == GUID_WICPixelFormat96bpp6Channels) m_sColorBits = _T("x96bpp6Channels");
		if (pf == GUID_WICPixelFormat112bpp7Channels) m_sColorBits = _T("x112bpp7Channels");
		if (pf == GUID_WICPixelFormat128bpp8Channels) m_sColorBits = _T("x128bpp8Channels");
		if (pf == GUID_WICPixelFormat40bppCMYKAlpha) m_sColorBits = _T("x40bppCMYKAlpha");
		if (pf == GUID_WICPixelFormat80bppCMYKAlpha) m_sColorBits = _T("x80bppCMYKAlpha");
		if (pf == GUID_WICPixelFormat32bpp3ChannelsAlpha) m_sColorBits = _T("x32bpp3ChannelsAlpha");
		if (pf == GUID_WICPixelFormat64bpp7ChannelsAlpha) m_sColorBits = _T("x64bpp7ChannelsAlpha");
		if (pf == GUID_WICPixelFormat72bpp8ChannelsAlpha) m_sColorBits = _T("x72bpp8ChannelsAlpha");
		if (pf == GUID_WICPixelFormat64bpp3ChannelsAlpha) m_sColorBits = _T("x64bpp3ChannelsAlpha");
		if (pf == GUID_WICPixelFormat80bpp4ChannelsAlpha) m_sColorBits = _T("x80bpp4ChannelsAlpha");
		if (pf == GUID_WICPixelFormat96bpp5ChannelsAlpha) m_sColorBits = _T("x96bpp5ChannelsAlpha");
		if (pf == GUID_WICPixelFormat112bpp6ChannelsAlpha) m_sColorBits = _T("x112bpp6ChannelsAlpha");
		if (pf == GUID_WICPixelFormat128bpp7ChannelsAlpha) m_sColorBits = _T("x128bpp7ChannelsAlpha");
		if (pf == GUID_WICPixelFormat144bpp8ChannelsAlpha) m_sColorBits = _T("x144bpp8ChannelsAlpha");
		if (pf == GUID_WICPixelFormat64bppRGBAHalf) m_sColorBits = _T("x64bppRGBAHalf");
		if (pf == GUID_WICPixelFormat48bppRGBHalf) m_sColorBits = _T("x48bppRGBHalf");
		if (pf == GUID_WICPixelFormat32bppRGBE) m_sColorBits = _T("x32bppRGBE");
		if (pf == GUID_WICPixelFormat16bppGrayHalf) m_sColorBits = _T("x16bppGrayHalf");
		if (pf == GUID_WICPixelFormat32bppGrayFixedPoint) m_sColorBits = _T("x32bppGrayFixedPoint");
		if (pf == GUID_WICPixelFormat64bppRGBFixedPoint) m_sColorBits = _T("x64bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat128bppRGBFixedPoint) m_sColorBits = _T("x128bppRGBFixedPoint");
		if (pf == GUID_WICPixelFormat64bppRGBHalf) m_sColorBits = _T("x64bppRGBHalf");

		// DDS Native Codec
		if (pf == GUID_WICPixelFormat32bppBGRA) m_sColorBits = _T("x32bppBGRA");




	}
#endif

}

#ifndef _WINVER_XP

void CannsGView::SetScaleRotationTarget(void)
{

	if (m_gTarget) {

		float cx = 0.0;
		float cy = 0.0;
		D2D1::Matrix3x2F matrix, matrix0, matrix1, matrix2;

		float mm = (float)m_nMulti;
		float fsH = mm * m_fFlipH / GMAG_FREF;
		float fsV = mm * m_fFlipV / GMAG_FREF;
//		float fsH = (float)m_nowXw / (float)m_Xw;
//		float fsV = (float)m_nowYw / (float)m_Yw;

//		m_fFlipH = -1.0;
//		m_fFlipV = -1.0;
		float fxt = 0;
		float fyt = 0;

		switch (m_nRad) {
		case 0:
			m_gTarget->SetTransform(D2D1::Matrix3x2F::Identity());
			matrix0 = D2D1::Matrix3x2F::Scale(fsH, fsV, D2D1::Point2F(cx, cy));
			if (m_fFlipH < 0) {
				fxt = (float)m_nowXw;
			}
			if (m_fFlipV < 0) {
				fyt = (float)m_nowYw;
			}
			matrix2 = D2D1::Matrix3x2F::Translation(fxt, fyt);
			matrix = matrix0 * matrix2;
			m_gTarget->SetTransform(matrix);

			if (m_wicRenderTarget != NULL) {
				m_wicRenderTarget->SetTransform(D2D1::Matrix3x2F::Identity());
				m_wicRenderTarget->SetTransform(matrix0);

			}
			break;
		case 1:
			matrix0 = D2D1::Matrix3x2F::Scale(fsH, fsV, D2D1::Point2F(cx, cy));
			matrix1 = D2D1::Matrix3x2F::Rotation(90.0, D2D1::Point2F(cx, cy));

			fxt = (float)m_Xw;
			if (m_fFlipH < 0) {
				fxt = 0;
			}
			if (m_fFlipV < 0) {
				fyt = -(float)m_Yw;
			}
			matrix2 = D2D1::Matrix3x2F::Translation(fxt, fyt);

//			matrix2 = D2D1::Matrix3x2F::Translation((float)m_Xw, 0);
			matrix = matrix1 * matrix2 * matrix0;
			m_gTarget->SetTransform(matrix);

			if (m_wicRenderTarget != NULL) {
				m_wicRenderTarget->SetTransform(matrix);

			}
			break;
		case 2:
			matrix0 = D2D1::Matrix3x2F::Scale(fsH, fsV, D2D1::Point2F(cx, cy));
			matrix1 = D2D1::Matrix3x2F::Rotation(180.0, D2D1::Point2F(cx, cy));

			fxt = (float)m_Xw;
			fyt = (float)m_Yw;

			if (m_fFlipH < 0) {
				fxt = 0;
			}
			if (m_fFlipV < 0) {
				fyt = 0;
			}
			matrix2 = D2D1::Matrix3x2F::Translation(fxt, fyt);

//			matrix2 = D2D1::Matrix3x2F::Translation((float)m_Xw, (float)m_Yw);
			matrix = matrix1 * matrix2 * matrix0;
			m_gTarget->SetTransform(matrix);

			if (m_wicRenderTarget != NULL) {
				m_wicRenderTarget->SetTransform(matrix);

			}
			break;
		case 3:
			matrix0 = D2D1::Matrix3x2F::Scale(fsH, fsV, D2D1::Point2F(cx, cy));
			matrix1 = D2D1::Matrix3x2F::Rotation(-90.0, D2D1::Point2F(cx, cy));

			fyt = (float)m_Yw;

			if (m_fFlipH < 0) {
				fxt = -(float)m_Xw;
			}
			if (m_fFlipV < 0) {
				fyt = 0;
			}
			matrix2 = D2D1::Matrix3x2F::Translation(fxt, fyt);

//			matrix2 = D2D1::Matrix3x2F::Translation(0, (float)m_Yw);
			matrix = matrix1 * matrix2 * matrix0;
			m_gTarget->SetTransform(matrix);

			if (m_wicRenderTarget != NULL) {
				m_wicRenderTarget->SetTransform(matrix);

			}
			break;
		}
	}
}


void CannsGView::DrawCheckPattern(float xs, float ys, float xe, float ye)
{

	if (m_nBackColor != 0) return;

	ID2D1SolidColorBrush* pBlackBrush = NULL;
	//	ID2D1LinearGradientBrush* pGradientBrush = NULL;

	m_gTarget->CreateSolidColorBrush(D2D1::ColorF(0.5F, 0.5F, 0.5F, 1.0F), &pBlackBrush);

	float cw = 10.0F * (GMAG_FREF / (float)m_nMulti);
	//	float cw = 10.0F;

	float xmax = xe * (GMAG_FREF / (float)m_nMulti);
	float ymax = ye * (GMAG_FREF / (float)m_nMulti);


	float x, y, left, top, right, bottom, xs1, ys1;
	float w = 0.0;

	xs1 = xs * (GMAG_FREF / (float)m_nMulti);
	ys1 = ys * (GMAG_FREF / (float)m_nMulti);


	for (y = ys1; y < ymax; y += cw) {
		for (x = xs1; x < xmax; x += (2 * cw)) {

			left = x + w;
			top = y;
			right = x + w + cw;
			bottom = y + cw;

			if (left > xmax) left = xmax - 1;
			if (right > xmax) right = xmax - 1;
			if (bottom > ymax) bottom = ymax - 1;

			D2D1_RECT_F rect = D2D1::RectF(left, top, right, bottom);
			m_gTarget->FillRectangle(&rect, pBlackBrush);


		}
		if (w == 0.0) w = cw;
		else w = 0.0;
	}



	if (pBlackBrush != NULL)
	{
		pBlackBrush->Release();
		pBlackBrush = NULL;
	}
}

#endif

// CannsGView `

void CannsGView::OnDraw(CDC* pDC)
{
//	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB

//	if ( m_gImage == NULL ) return;

	if (m_pFmParam->m_nOSversion > 6) {

#ifndef _WINVER_XP
		float x = 0;
		float y = 0;

		RECT rect;
		GetClientRect(&rect);
		int     width = rect.right - rect.left;
		int     height = rect.bottom - rect.top;

		if (m_gTarget) {
			//				PAINTSTRUCT ps;
			//				HDC hdc;
			//				hdc = BeginPaint(hWnd, &ps);    // ̈L̈ɂ
			//				EndPaint(hWnd, &ps);

			if (!(m_gTarget->CheckWindowState() & D2D1_WINDOW_STATE_OCCLUDED))
			{
				m_gTarget->BeginDraw();
				if (m_nBackColor == 3) {
					m_gTarget->Clear(D2D1::ColorF(D2D1::ColorF::Black));
				}
				else {
					if (m_nBackColor == 2) {
						m_gTarget->Clear(D2D1::ColorF(D2D1::ColorF::WhiteSmoke));
					}
					else {
						if (m_nBackColor == 1) {
							m_gTarget->Clear(D2D1::ColorF(D2D1::ColorF::Gray));
						}
						else {
							UINT32 cf = (m_pFmParam->m_colViewBack & 0xff0000) >> 16;
							cf += (m_pFmParam->m_colViewBack & 0x00ff00);
							cf += (m_pFmParam->m_colViewBack & 0x0000ff) << 16;
							m_gTarget->Clear(D2D1::ColorF(cf));

						}
					}
				}

				float fm = GMAG_FREF / (float)m_nMulti;
				float xpos = (float)GetScrollPos(SB_HORZ) * fm;
				float ypos = (float)GetScrollPos(SB_VERT) * fm;

				float xof = (float)((width - m_nowXw) / 2 * GMAG_REF / m_nMulti * (int)m_fFlipH);
				float yof = (float)((height - m_nowYw) / 2 * GMAG_REF / m_nMulti * (int)m_fFlipV);

				float cxs = 0.0F;
				float cys = 0.0F;
				float cxe = (float)(width);
				float cye = (float)(height);

				if (m_nRad == 0) {
					if (width > m_nowXw) {
						x += xof;
					}
					if (height > m_nowYw) {
						y += yof;
					}
					x -= xpos;
					y -= ypos;

				}

				if (m_nRad == 1) {
					if (width > m_nowXw) {
						y -= xof;
					}
					if (height > m_nowYw) {
						x += yof;
					}
					y += xpos;
					x -= ypos;

					cys -= (float)(width - m_nowXw);
					cye = (float)(m_nowXw);
					cxe = (float)height;
				}

				if (m_nRad == 2) {
					if (width > m_nowXw) {
						x -= xof;
					}
					if (height > m_nowYw) {
						y -= yof;
					}
					x += xpos;
					y += ypos;

					cxs -= (float)(width - m_nowXw);
					cys -= (float)(height - m_nowYw);
					cxe = (float)(m_nowXw);
					cye = (float)(m_nowYw);
				}

				if (m_nRad == 3) {
					if (width > m_nowXw) {
						y += xof;
					}
					if (height > m_nowYw) {
						x -= yof;
					}
					y -= xpos;
					x += ypos;

					cxs -= (float)(height - m_nowYw);
					cxe = (float)m_nowYw;
					cye = (float)width;
				}

				float fxw = m_gBitmap->GetSize().width;
				float fyw = m_gBitmap->GetSize().height;



				SetScaleRotationTarget();

				//			DrawCheckPattern(cxs, cys, cxe, cye);

				m_gTarget->DrawBitmap(m_gBitmap, D2D1::Rect<float>(x, y, x + fxw, y + fyw));

				// foCXXg̏ꍇ
				if (m_gTarget->EndDraw() == D2DERR_RECREATE_TARGET)
				{
					//				discardResource();
				}

				if (m_wicRenderTarget != NULL) {
					m_wicRenderTarget->BeginDraw();
					m_wicRenderTarget->DrawBitmap(m_d2dBitmap, D2D1::Rect<float>(0, 0, fxw, fyw));
					m_wicRenderTarget->EndDraw();

				}

			}
		}
		else {

			if (m_gImage == NULL) return;

			Gdiplus::Graphics graphics(pDC->m_hDC);

			if (m_nBackColor == 0) {
				graphics.Clear(m_pFmParam->m_colViewBack | 0xff000000);
			}

			if (m_nBackColor == 1) {
				graphics.Clear(Gdiplus::Color(128, 128, 128));
			}

			if (m_nBackColor == 2) {
				graphics.Clear(Gdiplus::Color(0, 0, 0));
			}

			if (m_nBackColor == 3) {
				graphics.Clear(Gdiplus::Color(255, 255, 255));
			}

			int xw = m_Xw * m_nMulti / GMAG_REF;
			int yw = m_Yw * m_nMulti / GMAG_REF;

			int xs = 0;
			int ys = 0;
			CRect rc;
			GetClientRect(&rc);
			int w = rc.right;
			int h = rc.bottom;

			if (xw < w) {
				xs = (w - xw) / 2;
			}
			if (yw < h) {
				ys = (h - yw) / 2;
			}

			graphics.DrawImage(m_gImage, xs, ys, xw, yw);
		}

		m_pViewFrame->DrawFileName();

		if (m_bEnableRect) {
			CRect rcDragRect;
			rcDragRect.top = m_cpStartDrag.y;
			rcDragRect.bottom = m_cpEndDrag.y;

			rcDragRect.left = m_cpStartDrag.x;
			rcDragRect.right = m_cpEndDrag.x;

			if (rcDragRect.top > rcDragRect.bottom) {
				rcDragRect.top = m_cpEndDrag.y;
				rcDragRect.bottom = m_cpStartDrag.y;
			}

			if (rcDragRect.left > rcDragRect.right) {
				rcDragRect.left = m_cpEndDrag.x;
				rcDragRect.right = m_cpStartDrag.x;
			}

			int xs = 0;
			int ys = 0;


			if (width > m_nowXw) {
				xs = (width - m_nowXw) / 2;
			}
			if (height > m_nowYw) {
				ys = (height - m_nowYw) / 2;
			}

			int xe = xs + m_nowXw;
			int ye = ys + m_nowYw;

			if (rcDragRect.left < xs) {
				rcDragRect.left = xs;
			}

			if (rcDragRect.left > xe) {
				rcDragRect.left = xe;
			}

			if (rcDragRect.right < xs) {
				rcDragRect.right = xs;
			}

			if (rcDragRect.right > xe) {
				rcDragRect.right = xe;
			}


			if (rcDragRect.top < ys) {
				rcDragRect.top = ys;
			}

			if (rcDragRect.top > ye) {
				rcDragRect.top = ye;
			}

			if (rcDragRect.bottom < ys) {
				rcDragRect.bottom = ys;
			}

			if (rcDragRect.bottom > ye) {
				rcDragRect.bottom = ye;
			}

			m_rectSelect = rcDragRect;
			m_rectSelect.top -= ys;
			m_rectSelect.bottom -= ys;
			m_rectSelect.left -= xs;
			m_rectSelect.right -= xs;

			int rx = rcDragRect.right - rcDragRect.left;
			int ry = rcDragRect.bottom - rcDragRect.top;



			rx = rx * GMAG_REF / m_nMulti;
			ry = ry * GMAG_REF / m_nMulti;

			CString sForm;
			sForm.Format(_T("%dx%d"), rx, ry);
			pDC->SetBkColor(m_pFmParam->m_colBack);
			pDC->SetTextColor(m_pFmParam->m_colListNormal);

			int rsx = rcDragRect.left;
			int rsy = rcDragRect.top;

			pDC->TextOutW(rsx, rsy, sForm);

			pDC->DrawFocusRect(&rcDragRect);
		}
#endif

	}
	else {
		if (m_gImage == NULL) return;
		Gdiplus::Graphics graphics(pDC->m_hDC);


		if (m_nBackColor == 0) {
			graphics.Clear(m_pFmParam->m_colViewBack | 0xff000000);
		}

		if (m_nBackColor == 1) {
			graphics.Clear(Gdiplus::Color(128, 128, 128));
		}

		if (m_nBackColor == 2) {
			graphics.Clear(Gdiplus::Color(255, 255, 255));
		}

		if (m_nBackColor == 3) {
			graphics.Clear(Gdiplus::Color(0, 0, 0));
		}

		int xw = m_Xw * m_nMulti / GMAG_REF;
		int yw = m_Yw * m_nMulti / GMAG_REF;

		int xs = 0;
		int ys = 0;
		CRect rc;
		GetClientRect(&rc);
		int w = rc.right;
		int h = rc.bottom;

		if (xw < w) {
			xs = (w - xw) / 2;
		}
		if (yw < h) {
			ys = (h - yw) / 2;
		}


		graphics.DrawImage(m_gImage, xs, ys, xw, yw);
		m_pViewFrame->DrawFileName();

		if (m_bEnableRect) {

			int sx = GetScrollPos(SB_HORZ);
			int sy = GetScrollPos(SB_VERT);

			CRect rcDragRect;
			rcDragRect.top = m_cpStartDrag.y - sy;
			rcDragRect.bottom = m_cpEndDrag.y - sy;

			rcDragRect.left = m_cpStartDrag.x - sx;
			rcDragRect.right = m_cpEndDrag.x - sx;

			if (rcDragRect.top > rcDragRect.bottom) {
				rcDragRect.top = m_cpEndDrag.y - sy;
				rcDragRect.bottom = m_cpStartDrag.y - sy;
			}

			if (rcDragRect.left > rcDragRect.right) {
				rcDragRect.left = m_cpEndDrag.x - sx;
				rcDragRect.right = m_cpStartDrag.x - sx;
			}

			int xs = 0;
			int ys = 0;


			if (w > m_nowXw) {
				xs = (w - m_nowXw) / 2;
			}
			if (h > m_nowYw) {
				ys = (h - m_nowYw) / 2;
			}

			int xe = xs + m_nowXw;
			int ye = ys + m_nowYw;

			if (rcDragRect.left < xs) {
				rcDragRect.left = xs;
			}

			if (rcDragRect.left > xe) {
				rcDragRect.left = xe;
			}

			if (rcDragRect.right < xs) {
				rcDragRect.right = xs;
			}

			if (rcDragRect.right > xe) {
				rcDragRect.right = xe;
			}


			if (rcDragRect.top < ys) {
				rcDragRect.top = ys;
			}

			if (rcDragRect.top > ye) {
				rcDragRect.top = ye;
			}

			if (rcDragRect.bottom < ys) {
				rcDragRect.bottom = ys;
			}

			if (rcDragRect.bottom > ye) {
				rcDragRect.bottom = ye;
			}


			m_rectSelect = rcDragRect;
			m_rectSelect.top -= ys;
			m_rectSelect.bottom -= ys;
			m_rectSelect.left -= xs;
			m_rectSelect.right -= xs;

			m_rectSelect.top += sy;
			m_rectSelect.bottom += sy;
			m_rectSelect.left += sx;
			m_rectSelect.right += sx;

			int rx = rcDragRect.right - rcDragRect.left;
			int ry = rcDragRect.bottom - rcDragRect.top;

			rx = rx * GMAG_REF / m_nMulti;
			ry = ry * GMAG_REF / m_nMulti;

			CString sForm;
			sForm.Format(_T("%dx%d"), rx, ry);
			pDC->SetBkColor(m_pFmParam->m_colBack);
			pDC->SetTextColor(m_pFmParam->m_colListNormal);

			int rsx = rcDragRect.left;
			int rsy = rcDragRect.top;

			pDC->TextOutW(rsx, rsy, sForm);


			pDC->DrawFocusRect(&rcDragRect);




		}

	}

}


// CannsGView bZ[W nh



void CannsGView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	short shift = GetKeyState(VK_SHIFT);
	short ctrl = GetKeyState(VK_CONTROL);

	UINT cmdno;
	if ( shift < 0 ) {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x300;
		} else {
			cmdno = nChar + 0x100;
		}
	} else {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x200;
		} else {
			cmdno = nChar;
		}
	}

	RunKeyCmd(cmdno);

//	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

// L[R}hs	nCmdNo = R}hNo.
// L[JX^}CYyуR}h}NpɁAR}hNo.őSẴR}hs
void CannsGView::RunKeyCmd(UINT uCmdNo)
{
	m_bDragging = false;

	if (m_bRunCmd) return;

	m_bRunCmd = true;

	bool r = false;
	CFileStatus fStatus, rStatus, st;


	switch ( uCmdNo ) {

		case 0x08: // "Backspace"
//			CmdKeyBackspace();
			break;

		case 0x0d: // "Enter"
			CmdKeyEnter();
			break;

		case 0x1b: // "Esc"
			CmdKeyQuit();
			break;

		case 0x20: // Space
			CmdKeySpace();
			UpdateWindow();

			break;

		case 0x21: // PageUp
			CmdKeyPageUp();
			UpdateWindow();
			break;

		case 0x22: // PageDown
			CmdKeyPageDown();
			UpdateWindow();
			break;


		case 0x24: // "Home"
//			CmdKeyHome();
			break;

		case 0x25: // ""
			CmdKeyLeft();
			UpdateWindow();
			break;

		case 0x26: // ""
			CmdKeyUp();
			UpdateWindow();
			break;

		case 0x27: // ""
			CmdKeyRight();
			UpdateWindow();
			break;

		case 0x28: // ""
			CmdKeyDown();
			UpdateWindow();
			break;

		case 0x30: // "0"
		case 0x31: // "1"
		case 0x32: // "2"
		case 0x33: // "3"
		case 0x34: // "4"
		case 0x35: // "5"
		case 0x36: // "6"
		case 0x37: // "7"
		case 0x38: // "8"
		case 0x39: // "9"
//			CmdKeyNumber(uCmdNo);
			break;

		case 0x45: // "E"
			CmdKeyExif();
			break;

		case 0x50: // "P"
			OnFilePrint();
			break;

		case 0x51: // "Q"
			CmdKeyQuit();
			break;

		case 0x57: // "W"
			CmdKeyMaximum();
			break;

		case 0x60: // "0" eL[
		case 0x61: // "1"
		case 0x62: // "2"
		case 0x63: // "3"
		case 0x64: // "4"
		case 0x65: // "5"
		case 0x66: // "6"
		case 0x67: // "7"
		case 0x68: // "8"
		case 0x69: // "9"
			break;

		case 0xba: // ":"
			CmdKeyColon();
			break;

		case 0xbb: // ";"
			CmdKeySemiColon();
			break;

		case 0xbc: // ","
			CmdKeyComma();
			break;

		case 0xbe: // "."
			CmdKeyPeriod();
			break;

		case 0xdb: // "["
			Resize(false);
			break;

		case 0xdd: // "]"
			Resize(true);
			break;

		// Shift+
		case 0x108: // "Backspace"
			break;

		case 0x10d: // "Enter"
//			CmdKeyShiftEnter();
			break;

		case 0x121: // PageUp
			break;

		case 0x122: // PageDown
			break;


		case 0x125: // ""
			CmdKeyShiftLeft();
			break;

		case 0x126: // ""
			CmdKeyShiftUp();
			break;

		case 0x127: // ""
			CmdKeyShiftRight();
			break;

		case 0x128: // ""
			CmdKeyShiftDown();
			break;

		case 0x130: // "0"
			break;
		case 0x131: // "1"
			break;
		case 0x132: // "2"
			break;
		case 0x133: // "3"
			break;
		case 0x134: // "4"
			break;
		case 0x135: // "5"
			break;
		case 0x136: // "6"
			break;
		case 0x137: // "7"
			break;
		case 0x138: // "8"
			break;
		case 0x139: // "9"
			break;

		case 0x145: // "E"
			CmdKeyShiftExif();
			break;

		case 0x160: // "0" eL[
			break;
		case 0x161: // "1"
			break;
		case 0x162: // "2"
			break;
		case 0x163: // "3"
			break;
		case 0x164: // "4"
			break;
		case 0x165: // "5"
			break;
		case 0x166: // "6"
			break;
		case 0x167: // "7"
			break;
		case 0x168: // "8"
			break;
		case 0x169: // "9"
			break;

		// Ctrl+
		case 0x208: // "Backspace"
			break;

		case 0x20d: // "Enter"
			break;

		case 0x221: // PageUp
			break;

		case 0x222: // PageDown
			break;


		case 0x225: // ""
			break;

		case 0x226: // ""
			break;

		case 0x227: // ""
			break;

		case 0x228: // ""
			break;

		case 0x230: // "0"
			break;
		case 0x231: // "1"
			break;
		case 0x232: // "2"
			break;
		case 0x233: // "3"
			break;
		case 0x234: // "4"
			break;
		case 0x235: // "5"
			break;
		case 0x236: // "6"
			break;
		case 0x237: // "7"
			break;
		case 0x238: // "8"
			break;
		case 0x239: // "9"
			break;

		case 0x242: // "B"
			OnMenuKeyCtrlB();
			break;

		case 0x243: // "C"
			CmdKeyCtrlCCopyToClipboard();
			break;

		case 0x246: // "F"
			CmdKeyAdjustSize();
			break;

		case 0x252: // "R"
			CmdKeyCtrlRResize();
			break;

		case 0x253: // "S"
			CmdKeyCtrlSSave();
			break;

		case 0x254: // "T"
			CmdKeyCtrlTTrimming();
			break;

		case 0x255: // "U"
			CmdKeyCtrlVPaste(false);
			break;

		case 0x256: // "V"
			CmdKeyCtrlVPaste();
			break;

		case 0x260: // "0" eL[
			break;
		case 0x261: // "1"
			break;
		case 0x262: // "2"
			break;
		case 0x263: // "3"
			break;
		case 0x264: // "4"
			break;
		case 0x265: // "5"
			break;
		case 0x266: // "6"
			break;
		case 0x267: // "7"
			break;
		case 0x268: // "8"
			break;
		case 0x269: // "9"
			break;

	}


	m_bRunCmd = false;
	m_bDragging = false;

}

void CannsGView::Resize(bool flg)
{
//	if ( m_gImage == NULL ) return;
	if ((m_gImage == NULL) 

#ifndef _WINVER_XP
		&& !m_gTarget
#endif
		)

		return;

	//	double d;
	int d, dm, id;

	d = 0;
	id = m_nMulti;
	dm = m_nMulti;

	if ( flg ) {

		d = m_nMulti + DELTA_MULTI;

		if ( d < (GMAG_REF * 3 + 1)  ) dm = d;


	} else {

		d = m_nMulti - DELTA_MULTI;

		if (d > (DELTA_MULTI - 1)) {
			int xw = m_Xw * m_nMulti / GMAG_REF;
			int yw = m_Yw * m_nMulti / GMAG_REF;

			if (xw > 20 && yw > 20) {
				dm = d;
			}
		}
	}

	m_nMulti = dm;
	m_nMultiNow = dm;

	m_bEnableRect = false;


	if (id != m_nMulti) {
		m_nowXw = m_Xw * m_nMulti / GMAG_REF;
		m_nowYw = m_Yw * m_nMulti / GMAG_REF;

		if (m_pFmParam->m_nOSversion > 6) {

#ifndef _WINVER_XP
			CreateWicBitmap(m_nowXw, m_nowYw);
#endif

		}

		m_pViewFrame->DrawFileName();

		Invalidate();
		InitScrollBar();

//		m_pViewFrame->ResizeGViewFrame(m_nowXw, m_nowYw, true);

	}
}



// L[R}h ==================================

// Cmd No 0x0d
void CannsGView::CmdKeyEnter(void)
{
	CmdKeyQuit();
}

// Cmd No 0x20
void CannsGView::CmdKeySpace(void)
{
	int cfn = m_pViewFrame->m_pwndFile->m_CurrentFileNo;
	if ( m_pFmParam->m_pMark[cfn] ) {
		m_pViewFrame->m_pwndFile->DrawMark(false);
		m_pFmParam->m_TagFileNum--;
		m_pFmParam->m_TagFileSize -= m_pFmParam->m_pw64FindData[cfn].size;
	} else {
		m_pViewFrame->m_pwndFile->DrawMark(true);
		m_pFmParam->m_TagFileNum++;
		m_pFmParam->m_TagFileSize += m_pFmParam->m_pw64FindData[cfn].size;
	}
	m_pFmParam->m_pMark[cfn] = !(m_pFmParam->m_pMark[cfn]);
	CmdKeyDown();
}

// Cmd No 0x21
void CannsGView::CmdKeyPageUp(void)
{
	if ( !m_pFmParam->m_bFindSPI ) return;
	if ( !m_pFmParam->m_bAtypeSPI ) return;


	int n = m_nPdfPageNow;
	n--;

	if ( n < 0 ) return;

	m_nPdfPageNow = n;

	bool r = GetArcFileSPIPage(n);

	IStream *is = NULL;
	CreateStreamOnHGlobal(m_phArcFilePage, TRUE, &is);
	if ( m_gImage ) delete m_gImage;
	m_gImage = new Gdiplus::Bitmap(is);
	is->Release();

	if (m_pFmParam->m_nOSversion > 6) {

#ifndef _WINVER_XP
		if (m_gImage) {
			Gdiplus::Color col = (255, 255, 255);
			HBITMAP hBitmap;
			m_gImage->GetHBITMAP(col, &hBitmap);

			GetColorBits();
			bool rr = CreateDrawDataFromHBitmap(hBitmap);
			DeleteObject(hBitmap);

			if (rr) {
				delete m_gImage;
				m_gImage = NULL;

				m_Xw = (int)m_gBitmap->GetSize().width;
				m_Yw = (int)m_gBitmap->GetSize().height;

				m_gTarget->Resize(D2D1::Size(static_cast<UINT>(m_Xw), static_cast<UINT>(m_Yw)));

				m_nRad = 0;
				m_bEnableRect = false;

				m_nowXw = m_Xw * m_nMulti / GMAG_REF;
				m_nowYw = m_Yw * m_nMulti / GMAG_REF;

				InitScrollBar();

				ResizeViewD2D();
				Invalidate();
				m_pViewFrame->m_pwndFile->DrawCursor();
				m_pViewFrame->DrawFileName();
				UpdateWindow();

			}
			else {
				m_pViewFrame->DestroyWindow();
			}
		}

#endif

	}
	else {
		m_nRad = 0;
		m_nFlip = 0;

		if (m_gImage) {
			m_Xw = m_gImage->GetWidth();
			m_Yw = m_gImage->GetHeight();


			m_nowXw = m_Xw * m_nMulti / GMAG_REF;
			m_nowYw = m_Yw * m_nMulti / GMAG_REF;

			InitScrollBar();

			m_bEnableRect = false;
			GetColorBits();

			m_pViewFrame->m_pwndFile->DrawCursor();
			m_pViewFrame->DrawFileName();

			Invalidate();
		}

	}

}

// Cmd No 0x22
void CannsGView::CmdKeyPageDown(void)
{
	if ( !m_pFmParam->m_bFindSPI ) return;
	if ( !m_pFmParam->m_bAtypeSPI ) return;


	int n = m_nPdfPageNow;
	n++;

	if ( n >= m_nPdfPage ) return;

	m_nPdfPageNow = n;

	bool r = GetArcFileSPIPage(n);

//	if ( m_gImage ) delete m_gImage;
	IStream *is = NULL;
	CreateStreamOnHGlobal(m_phArcFilePage, TRUE, &is);
	if ( m_gImage ) delete m_gImage;
	m_gImage = new Gdiplus::Bitmap(is);
	is->Release();

	if (m_pFmParam->m_nOSversion > 6) {

#ifndef _WINVER_XP
		if (m_gImage) {
			Gdiplus::Color col = (255, 255, 255);
			HBITMAP hBitmap;
			m_gImage->GetHBITMAP(col, &hBitmap);

			GetColorBits();
			bool rr = CreateDrawDataFromHBitmap(hBitmap);
			DeleteObject(hBitmap);

			if (rr) {
				delete m_gImage;
				m_gImage = NULL;

				m_Xw = (int)m_gBitmap->GetSize().width;
				m_Yw = (int)m_gBitmap->GetSize().height;

				m_gTarget->Resize(D2D1::Size(static_cast<UINT>(m_Xw), static_cast<UINT>(m_Yw)));

				m_nRad = 0;
				m_bEnableRect = false;

				m_nowXw = m_Xw * m_nMulti / GMAG_REF;
				m_nowYw = m_Yw * m_nMulti / GMAG_REF;

				InitScrollBar();

				ResizeViewD2D();
				Invalidate();
				m_pViewFrame->m_pwndFile->DrawCursor();
				m_pViewFrame->DrawFileName();
				UpdateWindow();

			}
			else {
				m_pViewFrame->DestroyWindow();
			}
		}

#endif

	}
	else {
		m_nRad = 0;
		m_nFlip = 0;

		if (m_gImage) {
			m_Xw = m_gImage->GetWidth();
			m_Yw = m_gImage->GetHeight();


			m_nowXw = m_Xw * m_nMulti / GMAG_REF;
			m_nowYw = m_Yw * m_nMulti / GMAG_REF;

			InitScrollBar();

			m_bEnableRect = false;
			GetColorBits();

			m_pViewFrame->m_pwndFile->DrawCursor();
			m_pViewFrame->DrawFileName();

			Invalidate();
		}

	}


}

bool CannsGView::RedrawGdi(int nFileNo, CString sFullname)
{
	bool bRet = false;

	m_pViewFrame->m_pwndFile->DrawCursor(false);

	m_nRad = 0;
	m_nFlip = 0;

	m_pViewFrame->m_pwndFile->m_CurrentFileNo = nFileNo;
	int npage = nFileNo / m_pViewFrame->m_pwndFile->m_PageFileNum;
	if (m_pViewFrame->m_pwndFile->m_CurrentPage != nFileNo) m_pViewFrame->m_pwndFile->m_CurrentPage = npage;
	m_pViewFrame->m_pwndFile->Invalidate();

	m_sFileName = sFullname;

	if (m_pFmParam->m_bFindSPI) {
		if (!m_pFmParam->m_bAtypeSPI) {
			bool r = GetPictureSPI();
			if (r) {
				if (m_gImage) delete m_gImage;
				m_gImage = new Gdiplus::Bitmap((BITMAPINFO *)m_phBInfo, m_phBm);
			}
			else m_gImage = NULL;
		}
		else {
			bool r = GetArcFileSPI();
			if (r) {
				GetArcFileSPIPage(m_nPdfPageNow);
				IStream *is = NULL;
				CreateStreamOnHGlobal(m_phArcFilePage, TRUE, &is);
				if (m_gImage != NULL) delete m_gImage;
				m_gImage = new Gdiplus::Bitmap(is);
				is->Release();
			}
			else m_gImage = NULL;
		}
	}
	else {
		if (m_gImage) delete m_gImage;

		/* 摜t@CǂݍIStream쐬 */
		IStream * is = getFileIStream(m_sFileName);

		/* IStreamBitmap쐬 */
		m_gImage = new Gdiplus::Bitmap(is);

		/* IStream */
		is->Release();
	}


	if (m_gImage) {
		m_nMulti = m_nMultiNow;

		m_sOrgFileName = m_sFileName;

		m_Xw = m_gImage->GetWidth();
		m_Yw = m_gImage->GetHeight();


		m_nowXw = m_Xw * m_nMulti / GMAG_REF;
		m_nowYw = m_Yw * m_nMulti / GMAG_REF;


		m_bEnableRect = false;
		GetColorBits();

		m_pViewFrame->AdjustSize();
		InitScrollBar();

		m_pViewFrame->m_pwndFile->DrawCursor();
		m_pViewFrame->DrawFileName();

		Invalidate();
		UpdateWindow();

		bRet = true;
	}

	return bRet;
}

// Cmd No 0x25
void CannsGView::CmdKeyLeft(void)
{

	int pmax = (m_pViewFrame->m_pwndFile->m_CurrentPage + 1) * m_pViewFrame->m_pwndFile->m_PageFileNum - 1;
	int cn = m_pViewFrame->m_pwndFile->m_CurrentFileNo;
	int n = cn - m_pViewFrame->m_pwndFile->m_MaxLine;

	if (n < 0) return;

	int at = m_pFmParam->m_pw64FindData[n].attrib;
	if ((at & _A_SUBDIR) != 0) return;

	CString fname = m_pFmParam->m_pw64FindData[n].name;
	CString fullname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fullname += fname;

	bool bfs = m_pFmParam->m_bFindSPI;
	bool bas = m_pFmParam->m_bAtypeSPI;

	m_pFmParam->m_bFindSPI = false;
	m_pFmParam->m_bAtypeSPI = false;

	bool bFind = false;
	if (m_pViewFrame->m_pwndFile->CheckGraphExt(fname)) {
		bFind = true;
	}
	else {
		if (m_pFmParam->m_bToolUseSPI) {
			bFind = m_pFmParam->SearchSPI(fullname);
		}
	}


	if (bFind) {
		if (m_pFmParam->m_nOSversion > 6) {
			m_nMulti = m_nMultiNow;

			m_bEnableRect = false;

			m_pViewFrame->m_pwndFile->DrawCursor(false);

			m_pViewFrame->m_pwndFile->m_CurrentFileNo = n;
			int npage = n / m_pViewFrame->m_pwndFile->m_PageFileNum;
			if (m_pViewFrame->m_pwndFile->m_CurrentPage != n) m_pViewFrame->m_pwndFile->m_CurrentPage = npage;
			m_pViewFrame->m_pwndFile->Invalidate();
			m_pViewFrame->m_pwndFile->UpdateWindow();


			m_sFileName = fullname;


#ifndef _WINVER_XP
			bool r = CreateDrawData();
			if (!r) {
				m_pViewFrame->DestroyWindow();

			}

			ResizeViewD2D();

#endif

			m_pViewFrame->AdjustSize();

			Invalidate();
		}
		else {
			RedrawGdi(n, fullname);
		}
	}
	else {
		m_pFmParam->m_bFindSPI = bfs;
		m_pFmParam->m_bAtypeSPI = bas;

	}

}


// Cmd No 0x27
void CannsGView::CmdKeyRight(void)
{

	
	int pmax = (m_pViewFrame->m_pwndFile->m_CurrentPage + 1) * m_pViewFrame->m_pwndFile->m_PageFileNum - 1;
	int cn = m_pViewFrame->m_pwndFile->m_CurrentFileNo;
	int n = cn + m_pViewFrame->m_pwndFile->m_MaxLine;

	if (n >= m_pFmParam->m_FileNum) return;

	int at = m_pFmParam->m_pw64FindData[n].attrib;
	if ((at & _A_SUBDIR) != 0) return;

	CString fname = m_pFmParam->m_pw64FindData[n].name;
	CString fullname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fullname += fname;

	bool bfs = m_pFmParam->m_bFindSPI;
	bool bas = m_pFmParam->m_bAtypeSPI;

	m_pFmParam->m_bFindSPI = false;
	m_pFmParam->m_bAtypeSPI = false;

	bool bFind = false;
	if (m_pViewFrame->m_pwndFile->CheckGraphExt(fname)) {
		bFind = true;
	}
	else {
		if (m_pFmParam->m_bToolUseSPI) {
			bFind = m_pFmParam->SearchSPI(fullname);
		}
	}


	if (bFind) {
		if (m_pFmParam->m_nOSversion > 6) {
			m_nMulti = m_nMultiNow;

			m_bEnableRect = false;

			m_pViewFrame->m_pwndFile->DrawCursor(false);

			m_pViewFrame->m_pwndFile->m_CurrentFileNo = n;
			int npage = n / m_pViewFrame->m_pwndFile->m_PageFileNum;
			if (m_pViewFrame->m_pwndFile->m_CurrentPage != n) m_pViewFrame->m_pwndFile->m_CurrentPage = npage;
			m_pViewFrame->m_pwndFile->Invalidate();
			m_pViewFrame->m_pwndFile->UpdateWindow();


			m_sFileName = fullname;


#ifndef _WINVER_XP
			bool r = CreateDrawData();
			if (!r) {
				m_pViewFrame->DestroyWindow();

			}

			ResizeViewD2D();
#endif

			m_pViewFrame->AdjustSize();

			Invalidate();
		}
		else {
			RedrawGdi(n, fullname);

		}
	}
	else {
		m_pFmParam->m_bFindSPI = bfs;
		m_pFmParam->m_bAtypeSPI = bas;

	}


}

// Cmd No 0x26
void CannsGView::CmdKeyUp(void)
{
	CString fullname, fname;
	int n = m_pViewFrame->m_pwndFile->m_CurrentFileNo;

	bool bfs = m_pFmParam->m_bFindSPI;
	bool bas = m_pFmParam->m_bAtypeSPI;

	m_pFmParam->m_bFindSPI = false;
	m_pFmParam->m_bAtypeSPI = false;

	for ( int i = n - 1; i > 0; i-- ) {
		fname = m_pFmParam->m_pw64FindData[i].name;
		fullname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		fullname += fname;

		bool bFind = false;
		if ( m_pViewFrame->m_pwndFile->CheckGraphExt(fname) ) {
			bFind = true;
		} else {
			if ( m_pFmParam->m_bToolUseSPI ) {
				bFind = m_pFmParam->SearchSPI( fullname );
			}
		}

		if ( bFind ) {

			if (m_pFmParam->m_nOSversion > 6) {
				m_nMulti = m_nMultiNow;

				m_bEnableRect = false;

				m_pViewFrame->m_pwndFile->DrawCursor(false);

				m_pViewFrame->m_pwndFile->m_CurrentFileNo = i;
				int npage = i / m_pViewFrame->m_pwndFile->m_PageFileNum;
				if (m_pViewFrame->m_pwndFile->m_CurrentPage != i) m_pViewFrame->m_pwndFile->m_CurrentPage = npage;
				m_pViewFrame->m_pwndFile->Invalidate();
				m_pViewFrame->m_pwndFile->UpdateWindow();

				m_sFileName = fullname;


#ifndef _WINVER_XP
				bool r = CreateDrawData();
				if (!r) {
					m_pViewFrame->DestroyWindow();
					break;

				}
				ResizeViewD2D();
#endif

				m_pViewFrame->AdjustSize();


				Invalidate();
				break;

			}
			else {

				if (RedrawGdi(i, fullname)) break;

			}

		}
		else {
			if (m_pFmParam->m_nOSversion > 6) {
				m_pFmParam->m_bFindSPI = bfs;
				m_pFmParam->m_bAtypeSPI = bas;
			}

		}
	}
}

// Cmd No 0x27
void CannsGView::CmdKeyDown(void)
{
	CString fullname, fname;
	int n, fmax;
	n = m_pViewFrame->m_pwndFile->m_CurrentFileNo;
	fmax = m_pFmParam->m_FileNum;

	bool bfs = m_pFmParam->m_bFindSPI;
	bool bas = m_pFmParam->m_bAtypeSPI;

	m_pFmParam->m_bFindSPI = false;
	m_pFmParam->m_bAtypeSPI = false;

	for ( int i = n + 1; i < fmax; i++ ) {
		fname = m_pFmParam->m_pw64FindData[i].name;
		fullname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		fullname += fname;

		bool bFind = false;
		if ( m_pViewFrame->m_pwndFile->CheckGraphExt(fname) ) {
			bFind = true;
		} else {
			if ( m_pFmParam->m_bToolUseSPI ) {
				bFind = m_pFmParam->SearchSPI( fullname );
			}
		}

		if ( bFind ) {
			if (m_pFmParam->m_nOSversion > 6) {
				m_bEnableRect = false;

				m_nMulti = m_nMultiNow;

				m_pViewFrame->m_pwndFile->DrawCursor(false);

				m_pViewFrame->m_pwndFile->m_CurrentFileNo = i;
				int npage = i / m_pViewFrame->m_pwndFile->m_PageFileNum;
				if (m_pViewFrame->m_pwndFile->m_CurrentPage != i) m_pViewFrame->m_pwndFile->m_CurrentPage = npage;
				m_pViewFrame->m_pwndFile->Invalidate();
				m_pViewFrame->m_pwndFile->UpdateWindow();

				m_sFileName = fullname;

#ifndef _WINVER_XP
				bool r = CreateDrawData();
				if (!r) {
					m_pViewFrame->DestroyWindow();
					break;

				}
				ResizeViewD2D();
#endif

				m_pViewFrame->AdjustSize();

				Invalidate();

				break;

			}
			else {
				if (RedrawGdi(i, fullname)) break;


			}

		}
		else {
			if (m_pFmParam->m_nOSversion > 6) {
				m_pFmParam->m_bFindSPI = bfs;
				m_pFmParam->m_bAtypeSPI = bas;
			}

		}
	}
}

// Cmd No 0x30 - 0x39
void CannsGView::CmdKeyNumber(UINT uCmdNo)
{
}

// Cmd No 0x45
void CannsGView::CmdKeyExif(void)
{
	CString tmp, s, path;
	tmp = _T("open");

	path = m_pFmParam->GetExePath(_T(""));

	s.Format(m_pFmParam->m_sViewExifParam, m_sFileName);
	ShellExecute(this->m_hWnd, tmp, m_pFmParam->m_sViewExifCmd, s, path, SW_SHOW);

	//	m_pViewFrame->DestroyWindow();
}

// Cmd No 0x51
void CannsGView::CmdKeyQuit(void)
{
	if (m_bMaximum) {
		CmdKeyMaximum();
	}
	else {
		m_pViewFrame->DestroyWindow();
	}


}

// Cmd No 0x57
void CannsGView::CmdKeyMaximum(void)
{
	if (m_bMaximum) {

		LONG lStyle;

		lStyle = GetWindowLong(m_pViewFrame->m_hWnd, GWL_STYLE);
		lStyle |= WS_OVERLAPPEDWINDOW;
		lStyle |= WS_BORDER;
		lStyle |= WS_THICKFRAME;

		lStyle = SetWindowLong(m_pViewFrame->m_hWnd, GWL_STYLE, lStyle);
		m_pViewFrame->SetWindowPos(&CWnd::wndTop, 0, 0, 0, 0,
			(SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED));

		m_pViewFrame->SetMenuBarVisibility(AFX_MBV_KEEPVISIBLE);

		m_pViewFrame->ShowWindow(SW_RESTORE);

		m_bMaximum = false;
		m_pViewFrame->MoveWindow(&m_rectOrgWindowSize);

	}
	else {
		m_pViewFrame->GetWindowRect(&m_rectOrgWindowSize);
		

		LONG lStyle;

		lStyle = GetWindowLong(m_pViewFrame->m_hWnd, GWL_STYLE);
		lStyle &= ~WS_OVERLAPPEDWINDOW;
		lStyle &= ~WS_BORDER;
		lStyle &= ~WS_THICKFRAME;

		lStyle = SetWindowLong(m_pViewFrame->m_hWnd, GWL_STYLE, lStyle);
		m_pViewFrame->SetWindowPos(&CWnd::wndTop, 0, 0, 0, 0, 
			(SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_FRAMECHANGED));

		m_pViewFrame->SetMenuBarVisibility(AFX_MBV_DISPLAYONFOCUS);

		m_bMaximum = true;

		m_pViewFrame->ShowWindow(SW_SHOWMAXIMIZED);

//		CRect rc;
//		m_pViewFrame->GetWindowRect(&rc);

//		rc.top -= 2;
//		rc.left -= 2;
//		rc.right += 2;
//		rc.bottom += 2;

//		m_pViewFrame->MoveWindow(&rc);

	}

}

// Cmd No 0xba
void CannsGView::CmdKeyColon(void)
{
	m_bEnableRect = false;

	if (m_pFmParam->m_nOSversion > 6) {
		if (m_gImage) {
			m_gImage->RotateFlip(RotateNoneFlipX);
		}

		if (m_fFlipH < 0) m_fFlipH = 1.0;
		else m_fFlipH = -1.0;

	}
	else {
		if (m_gImage) {
			m_gImage->RotateFlip(RotateNoneFlipX);

			if ((m_nFlip & 1) == 0) {
				m_nFlip += 1;
			}
			else {
				m_nFlip -= 1;
			}
		}

	}

	Invalidate();
}

// Cmd No 0xbb
void CannsGView::CmdKeySemiColon(void)
{
	m_bEnableRect = false;

	if (m_pFmParam->m_nOSversion > 6) {
		if (m_gImage) {
			m_gImage->RotateFlip(RotateNoneFlipY);
		}

		if (m_fFlipV < 0) m_fFlipV = 1.0;
		else m_fFlipV = -1.0;
	}
	else {
		if (m_gImage) {
			m_gImage->RotateFlip(RotateNoneFlipY);

			m_nRad++;
			if (m_nRad > 3) {
				m_nRad = 0;
			}

			m_nRad++;
			if (m_nRad > 3) {
				m_nRad = 0;
			}

			if ((m_nFlip & 1) == 0) {
				m_nFlip += 1;
			}
			else {
				m_nFlip -= 1;
			}
		}

	}

	Invalidate();
}


// Cmd No 0xbc
void CannsGView::CmdKeyComma(void)
{
	m_bEnableRect = false;

	if (m_pFmParam->m_nOSversion > 6) {
		if (m_gImage) {
			m_gImage->RotateFlip(Rotate270FlipNone);
		}

		int n = m_Xw;
		m_Xw = m_Yw;
		m_Yw = n;


		n = m_nowXw;
		m_nowXw = m_nowYw;
		m_nowYw = n;

#ifndef _WINVER_XP
		if (m_gTarget) {
			m_nRad--;
			if (m_nRad < 0) m_nRad = 3;
		}


		CreateWicBitmap(m_nowXw, m_nowYw);
#endif


	}
	else {
		if (m_gImage) {
			m_gImage->RotateFlip(Rotate270FlipNone);

			m_nRad++;
			if (m_nRad > 3) {
				m_nRad = 0;
			}

			m_nRad++;
			if (m_nRad > 3) {
				m_nRad = 0;
			}

			m_nRad++;
			if (m_nRad > 3) {
				m_nRad = 0;
			}

			int n = m_Xw;
			m_Xw = m_Yw;
			m_Yw = n;


			n = m_nowXw;
			m_nowXw = m_nowYw;
			m_nowYw = n;

		}

	}

	InitScrollBar();

	Invalidate();
}

// Cmd No 0xbe
void CannsGView::CmdKeyPeriod(void)
{
	if (m_pFmParam->m_nOSversion > 6) {
		if (m_gImage) {
			m_gImage->RotateFlip(Rotate90FlipNone);
		}

		int n = m_Xw;
		m_Xw = m_Yw;
		m_Yw = n;

		n = m_nowXw;
		m_nowXw = m_nowYw;
		m_nowYw = n;

#ifndef _WINVER_XP
		if (m_gTarget) {
			m_nRad++;
			if (m_nRad > 3) m_nRad = 0;
		}

		CreateWicBitmap(m_nowXw, m_nowYw);
#endif

	}
	else {
		if (m_gImage) {
			m_gImage->RotateFlip(Rotate90FlipNone);

			m_nRad++;
			if (m_nRad > 3) {
				m_nRad = 0;
			}

			int n = m_Xw;
			m_Xw = m_Yw;
			m_Yw = n;

			n = m_nowXw;
			m_nowXw = m_nowYw;
			m_nowYw = n;


		}

	}

	InitScrollBar();

	m_bEnableRect = false;
	Invalidate();
}

// Cmd No 0x125
void CannsGView::CmdKeyShiftLeft(void)
{
	int pos = GetScrollPos(SB_HORZ);
	pos -= 100;

	if (pos < 0) pos = 0;

	SetScrollPos(SB_HORZ, pos);
	m_bEnableRect = false;
	Invalidate();
}

// Cmd No 0x126
void CannsGView::CmdKeyShiftUp(void)
{
	int pos = GetScrollPos(SB_VERT);
	pos -= 100;

	if (pos < 0) pos = 0;

	SetScrollPos(SB_VERT, pos);
	m_bEnableRect = false;
	Invalidate();
}

// Cmd No 0x127
void CannsGView::CmdKeyShiftRight(void)
{
	int pos = GetScrollPos(SB_HORZ);
	pos += 100;
	SetScrollPos(SB_HORZ, pos);

	m_bEnableRect = false;
	Invalidate();
}

// Cmd No 0x128
void CannsGView::CmdKeyShiftDown(void)
{
	int pos = GetScrollPos(SB_VERT);
	pos += 100;
	SetScrollPos(SB_VERT, pos);

	m_bEnableRect = false;
	Invalidate();
}

// Cmd No x145
void CannsGView::CmdKeyShiftExif(void)
{
	CSetExifProgram cdlg;

	cdlg.m_sExeFileEdit = m_pFmParam->m_sViewExifCmd;
	cdlg.m_sParamEdit = m_pFmParam->m_sViewExifParam;

	int id = cdlg.DoModal();

	if (id == IDOK) {

		m_pFmParam->m_sViewExifCmd = cdlg.m_sExeFileEdit;
		m_pFmParam->m_sViewExifParam = cdlg.m_sParamEdit;

		CWinApp *pApp = AfxGetApp();
		CString sSection, sEntry;

		sSection = INISECTION_ANNSVIEW;
		sEntry = INIENTRY_ANNSVIEW_EXIF_CMD;
		pApp->WriteProfileString(sSection, sEntry, cdlg.m_sExeFileEdit);

		sEntry = INIENTRY_ANNSVIEW_EXIF_PARAM;
		CString s = cdlg.m_sParamEdit;
		s.Replace(_T("\""), _T("\"\""));
		pApp->WriteProfileString(sSection, sEntry, s);


	}

	SetFocus();

}

// Cmd No 0x241
void CannsGView::CmdKeyAutoOrientation(void)
{
	CMenu* pMenu = m_pViewFrame->GetMenu();

	if (m_pFmParam->m_bAutoOrientation) {
		m_pFmParam->m_bAutoOrientation = false;
		pMenu->CheckMenuItem(ID_KEY_CTRL_A, MF_UNCHECKED);
	}
	else {
		m_pFmParam->m_bAutoOrientation = true;
		pMenu->CheckMenuItem(ID_KEY_CTRL_A, MF_CHECKED);
	}

#ifndef _WINVER_XP
	CreateDrawData();
#endif

	Invalidate();

	UpdateWindow();

}


// Cmd No 0x246
void CannsGView::CmdKeyAdjustSize(void)
{
	CMenu* pMenu = m_pViewFrame->GetMenu();
	
	if (m_pFmParam->m_bViewAdjustSize) {
		m_pFmParam->m_bViewAdjustSize = false;
		pMenu->CheckMenuItem(ID_KEY_CTRL_F, MF_UNCHECKED);
		m_nowXw = m_Xw;
		m_nowYw = m_Yw;
	}
	else {
		m_pFmParam->m_bViewAdjustSize = true;
		pMenu->CheckMenuItem(ID_KEY_CTRL_F, MF_CHECKED);
	}
	m_bEnableRect = false;
	m_nMulti = GMAG_REF;
	m_nMultiNow = GMAG_REF;
	m_nRad = 0;

	m_pViewFrame->AdjustSize();
	InitScrollBar();

#ifndef _WINVER_XP
	ResizeViewD2D();
#endif

	Invalidate();

}


// Cmd No 0x252
bool CannsGView::CmdKeyCtrlRResize(void)
{
	bool r = true;

	CSetGSize dlg;
	dlg.m_bEqCheck = true;

	if (m_pFmParam->m_nOSversion > 6) {
		dlg.m_nOrgSizeX = m_Xw * m_nMulti / GMAG_REF;
		dlg.m_nOrgSizeY = m_Yw * m_nMulti / GMAG_REF;

		//	int mul = m_nMulti;

		int rn = dlg.DoModal();

		if (rn == IDOK) {

			m_nMulti = GMAG_REF;
			m_nMultiNow = GMAG_REF;

			int xw = dlg.m_nHEdit;
			int yw = dlg.m_nVEdit;

			if (xw == 0 || yw == 0) {
				xw = m_Xw;
				yw = m_Yw;
			}

#ifndef _WINVER_XP

			if (m_gTarget) {

				m_gBitmap = NULL;

				// Ro[^Direct2DptH[}bgɕϊ

				HRESULT hr;

				CComPtr<IWICFormatConverter> converter;
				hr = m_gImagingFactory->CreateFormatConverter(&converter);
				if (FAILED(hr))
				{
					MessageBox(_T("Direct2DtH[}bgϊɎs(CreateFormatConverter)"), _T("D2DG["));
					return false;
				}


				CComPtr<IWICBitmapSource> bs;

				if (m_gFrameDec) bs = m_gFrameDec;
				else bs = m_wicHbBitmap;


				CComPtr<IWICBitmapScaler> scaler;

				int sxw = xw;
				int syw = yw;

				if (m_nRad == 1 || m_nRad == 3) {
					sxw = yw;
					syw = xw;
				}
				m_gTarget->Resize(D2D1::Size(static_cast<UINT>(sxw), static_cast<UINT>(syw)));


				m_gImagingFactory->CreateBitmapScaler(&scaler);

				hr = scaler->Initialize(
					bs, sxw, syw, WICBitmapInterpolationModeCubic);
				if (FAILED(hr))
				{
					MessageBox(_T("Direct2DtH[}bgϊɎs(Scaler Initialize)"), _T("D2DG["));
					return false;
				}

				hr = converter->Initialize(
					scaler, GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone,
					nullptr, 0.f, WICBitmapPaletteTypeMedianCut);

				if (FAILED(hr))
				{
					MessageBox(_T("Direct2DtH[}bgϊɎs(Converter Initialize)"), _T("D2DG["));
					return false;
				}


				CComPtr<IWICBitmapFlipRotator> rotator;
				m_gImagingFactory->CreateBitmapFlipRotator(&rotator);

				if (m_nRad == 0) {
					rotator->Initialize(bs, WICBitmapTransformRotate0);
				}
				if (m_nRad == 1) {
					rotator->Initialize(bs, WICBitmapTransformRotate90);
				}
				if (m_nRad == 2) {
					rotator->Initialize(bs, WICBitmapTransformRotate180);
				}
				if (m_nRad == 3) {
					rotator->Initialize(bs, WICBitmapTransformRotate270);
				}

				hr = converter->Initialize(
					rotator, GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone,
					nullptr, 0.f, WICBitmapPaletteTypeMedianCut);

				// Direct2Dprbg}bv쐬
				hr = m_gTarget->CreateBitmapFromWicBitmap(converter, NULL, &m_gBitmap);
				if (FAILED(hr))
				{
					MessageBox(_T("Direct2Drbg}bv쐬Ɏs"), _T("D2DG["));
					return false;
				}


				bool r = CreateWicBitmap(xw, yw);
				if (!r) {
					return false;
				}

				m_Xw = xw;
				m_Yw = yw;

				m_nowXw = m_Xw * m_nMulti / GMAG_REF;
				m_nowYw = m_Yw * m_nMulti / GMAG_REF;

				ResizeViewD2D();

				m_pViewFrame->AdjustSize();

				GetColorBits();

				InitScrollBar();

				Invalidate();

				m_bEnableRect = false;

			}
#endif


		}
	}
	else {
		dlg.m_nOrgSizeX = m_nowXw;
		dlg.m_nOrgSizeY = m_nowYw;

		int rn = dlg.DoModal();

		if (rn == IDOK) {

			int xw = dlg.m_nHEdit;
			int yw = dlg.m_nVEdit;

			// ꂩ쐬摜p Bitmap IuWFNg쐬
			Bitmap* pBitmap = new Bitmap(xw, yw);

			// Bitmap IuWFNg Graphics IuWFNg쐬
			// ō쐬 Bitmap IuWFNgɕ`悵AۑB
			Graphics* pGrfx = Graphics::FromImage(pBitmap);

			// ^[QbgƂȂ` Rect IuWFNgŕ\Ă
			Gdiplus::Rect rectDist(0, 0, xw, yw);

			// 摜̑Ŝ rectDist ŕ\`̈֎ʑB
			// "摜̑S" ͑3`6ŕ\ĂB摜̈ꕔNbvȂ
			// ŃNbv̈w肷B
			pGrfx->DrawImage(
				m_gImage,
				rectDist,
				0, 0, m_gImage->GetWidth(), m_gImage->GetHeight(),
				UnitPixel);

			PixelFormat format = PixelFormatDontCare;
			m_gImage = pBitmap->Clone(rectDist, format);

			m_Xw = xw;
			m_Yw = yw;

			m_nowXw = m_Xw;
			m_nowYw = m_Yw;

			InitScrollBar();

			m_nMulti = GMAG_REF;

			m_bEnableRect = false;
			m_pViewFrame->AdjustSize();
			InitScrollBar();
			Invalidate();

		}

	}

	SetFocus();

	return r;
}


// Cmd No 0x253
bool CannsGView::CmdKeyCtrlSSave(void)
{
	bool r = false;

	if (m_pFmParam->m_nOSversion > 6) {

		CString savefname = m_sFileName;
		if (m_sSaveFilename != _T("")) {
			savefname = m_sSaveFilename;
		}


#ifndef _WINVER_XP
		if (m_gTarget) {

			DWORD id = ID_SAVE_FILETIME_CHECK;
			DWORD id2 = ID_SAVE_QUALITY_EDITBOX;
			DWORD id3 = ID_SAVE_QUALITY_TEXT;

			CString sQuality;
			CWinApp *pApp = AfxGetApp();
			CString sSection, sEntry;
			sSection = INISECTION_ANNSVIEW;
			sEntry = INIENTRY_ANNSVIEW_JPEG_QUALITY;
			int	n = pApp->GetProfileInt(sSection, sEntry, 80);
			sQuality.Format(_T("%d"), n);

			BOOL bSametime;
			sEntry = INIENTRY_ANNSVIEW_SAVE_FILETIME;
			n = pApp->GetProfileInt(sSection, sEntry, 0);
			bSametime = (n != 0);

			//			CString	filter(_T("摜t@C (*.jpg;*.bmp;*.tif;*.png;*.gif;*.wmp)|*.jpg;*.bmp;*.tif;*.png;*.gif;*.wmp||"));
			CString	filter(_T("摜t@C (*.jpg;*.jpeg;*.jpe;*.jfif;*.bmp;*.tif;*.tiff;*.png;*.gif;*.wmp)|*.jpg;*.jpeg;*.jpe;*.jfif;*.bmp;*.tif;*.tiff;*.png;*.gif;*.wmp||"));

			CFileSaveJpeg selDlg(FALSE, NULL, savefname, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter, this);

			selDlg.m_sEdit = sQuality;
			selDlg.m_bSameTime = bSametime;

			//			bool r = false;
			if (selDlg.DoModal() == IDOK)
			{

				sQuality = selDlg.m_sEdit;

				int qr = _ttoi(sQuality);
				if (qr > 100 || qr < 0) {
					qr = 80;
				}

				sEntry = INIENTRY_ANNSVIEW_JPEG_QUALITY;
				pApp->WriteProfileInt(sSection, sEntry, qr);


				selDlg.GetCheckButtonState(id, bSametime);
				sEntry = INIENTRY_ANNSVIEW_SAVE_FILETIME;
				pApp->WriteProfileInt(sSection, sEntry, bSametime);

				CString fname = selDlg.GetPathName();

				int n = fname.ReverseFind(_T('.'));

				CString fn, s, sext, sform, ffname;
				if (n > 0) {
					fn = fname.Left(n);
					s = fname.Mid(n);
				}
				else {
					fn = fname;
					s = _T(".png");
				}
				s.MakeLower();


				GUID containerFormat = GUID_ContainerFormatJpeg;
				FLOAT quality = 0.8F;

				bool bExt = false;

				if (s == _T(".jpg") || s == _T(".jpeg") || s == _T(".jpe") || s == _T(".jfif")) {
					containerFormat = GUID_ContainerFormatJpeg;
					bExt = true;
					//					CSaveJpegDialog dlg;
					//					int rid = dlg.DoModal();
					//					if (rid != IDOK) return false;

					//					int qr = dlg.m_nQuality;
					quality = (FLOAT)(qr / 100.0);
				}

				if (s == _T(".tif") || s == _T(".tiff")) {
					containerFormat = GUID_ContainerFormatTiff;
					bExt = true;
				}

				if (s == _T(".png")) {
					containerFormat = GUID_ContainerFormatPng;
					bExt = true;
				}

				//				if (s == _T(".ico")) {
				//					containerFormat = GUID_ContainerFormatIco;
				//					bExt = true;
				//				}

				if (s == _T(".gif")) {
					containerFormat = GUID_ContainerFormatGif;
					bExt = true;
				}

				if (s == _T(".wmp")) {
					containerFormat = GUID_ContainerFormatWmp;
					bExt = true;
				}

				if (s == _T(".bmp")) {
					containerFormat = GUID_ContainerFormatBmp;
					bExt = true;
				}

				if (!bExt) {
					containerFormat = GUID_ContainerFormatPng;
					fname += _T(".png");
				}

				CComPtr<IWICBitmapEncoder> encoder;
				m_gImagingFactory->CreateEncoder(containerFormat, nullptr, &encoder);

				ffname = fname;

				fname += _T("~tmpannsFM");


				IPropertyBag2 *pPropertybag = NULL;


				CComPtr<IWICStream> stream;

				// GR[_[p̃Xg[쐬
				m_gImagingFactory->CreateStream(&stream);
				// o̓t@C̃pXgpăXg[
				stream->InitializeFromFilename(fname, GENERIC_WRITE);
				// 摜t@Cɏނ߂̃GR[_[쐬
				encoder->Initialize(stream, WICBitmapEncoderNoCache);

				CComPtr<IWICMetadataBlockWriter> blockWriter;
				CComPtr<IWICMetadataBlockReader> blockReader;

				unsigned int frameCount;


				CComPtr<IWICBitmapDecoder> dec;
				dec = m_gDecoder;
				if (dec == NULL) {
					m_gImagingFactory->CreateDecoder(
						GUID_ContainerFormatBmp,
						NULL,
						&dec);
				}

				// t[擾
				CComPtr<IWICBitmapFrameDecode> frame;
				frame = m_gFrameDec;
				if (frame == NULL) {
					dec->GetFrame(0, &frame);
				}

				//				m_gDecoder->GetFrameCount(&frameCount);
				dec->GetFrameCount(&frameCount);

				for (unsigned int i = 0; i < frameCount; i++)
				{
					// t[ϐ
					CComPtr<IWICBitmapFrameDecode> frameDecode;
					CComPtr<IWICBitmapFrameEncode> frameEncode;

					// 摜̃t[擾э쐬
					dec->GetFrame(i, &frameDecode);
					//					m_gDecoder->GetFrame(i, &frameDecode);
					//					encoder->CreateNewFrame(&frameEncode, nullptr);
					encoder->CreateNewFrame(&frameEncode, &pPropertybag);

					if (containerFormat == GUID_ContainerFormatJpeg) {
						// ō:1.0 :0.8 :0.6 :0.3
						//						FLOAT quality = 1.0;
						PROPBAG2 option = { 0 };
						option.pstrName = L"ImageQuality";
						VARIANT varValue;
						VariantInit(&varValue);
						varValue.vt = VT_R4;
						varValue.fltVal = quality;
						HRESULT hr = pPropertybag->Write(1, &option, &varValue);
						if (SUCCEEDED(hr))
						{
							hr = frameEncode->Initialize(pPropertybag);
						}
					}
					else {
						// GR[_[
						frameEncode->Initialize(NULL);
					}



					UINT width, height;

					width = m_Xw;
					height = m_Yw;

					// TCY擾ѐݒ肷
					if (i == 0)
					{
						m_wicBitmap->GetSize(&width, &height);
					}
					else
					{
						frameDecode->GetSize(&width, &height);
					}
					frameEncode->SetSize(width, height);

					WICPixelFormatGUID pixelFormat;

					// sNZ`ݒ肷
					frameDecode->GetPixelFormat(&pixelFormat);
					frameEncode->SetPixelFormat(&pixelFormat);

					bool formatsEqual = false;
					GUID srcFormat;
					GUID destFormat;

					dec->GetContainerFormat(&srcFormat);
					//					m_gDecoder->GetContainerFormat(&srcFormat);
					encoder->GetContainerFormat(&destFormat);
					formatsEqual = (srcFormat == destFormat) ? true : false;

					if (formatsEqual)
					{
						// ^f[^ ubN [_[/C^[gpă^f[^Rs[
						frameDecode->QueryInterface(&blockReader);
						frameEncode->QueryInterface(&blockWriter);

						if (nullptr != blockReader && nullptr != blockWriter)
						{
							blockWriter->InitializeFromBlockReader(blockReader);
						}
					}

					if (i == 0)
					{
						// XVꂽrbg}bvo͂ɃRs[
						if (m_wicBitmap != NULL) {
							frameEncode->WriteSource(m_wicBitmap, nullptr);

						}
						else {
							frameEncode->WriteSource(m_wicHbBitmap, nullptr);
						}
					}
					else
					{
						// ̉摜o͂ɃRs[
						frameEncode->WriteSource(static_cast<IWICBitmapSource*> (frameDecode), nullptr);
					}

					// t[R~bg
					frameEncode->Commit();

					frameEncode.Release();
					frameEncode = NULL;
					frameDecode.Release();
					frameDecode = NULL;
					blockWriter.Release();
					blockWriter = NULL;
					blockReader.Release();
					blockReader = NULL;
				}

				encoder->Commit();

				encoder.Release();
				encoder = NULL;
				stream.Release();
				stream = NULL;
				dec.Release();
				dec = NULL;
				frame.Release();
				frame = NULL;


				r = true;

				discardResource();

				CFileStatus rStatus;
				if (CFile::GetStatus(ffname, rStatus)) {	// t@C݂
					CFile::Remove(ffname);
				}
				CFile::Rename(fname, ffname);

				m_pViewFrame->DrawFileName();
				m_sFileName = ffname;

				if (bSametime) {
					CFileStatus fStatus, st;

					CFile::GetStatus(m_sOrgFileName, fStatus);
					CFile::GetStatus(ffname, st);

					st.m_atime = fStatus.m_atime;
					st.m_ctime = fStatus.m_ctime;
					st.m_mtime = fStatus.m_mtime;

					CFile::SetStatus(ffname, st);

				}

			}

		}

		m_pViewFrame->DrawFileName();

		m_bEnableRect = false;
		if (r) r = CreateDrawData();
#endif

	}
	else {
		CString savefname = m_sFileName;
		//	if (m_sSaveFilename != _T("")) {
		//		savefname = m_sSaveFilename;
		//	}

		//			CString	filter(_T("摜t@C (*.jpg;*.bmp;*.tif;*.png;*.gif;*.wmp)|*.jpg;*.bmp;*.tif;*.png;*.gif;*.wmp||"));
		CString	filter(_T("摜t@C (*.jpg;*.jpeg;*.jpe;*.jfif;*.bmp;*.tif;*.tiff;*.png;*.gif;*.wmp)|*.jpg;*.jpeg;*.jpe;*.jfif;*.bmp;*.tif;*.tiff;*.png;*.gif;*.wmp||"));

		//	CFileSaveJpeg selDlg(FALSE, NULL, savefname, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter, this);
		CFileDialog selDlg(FALSE, NULL, savefname, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter, this);



		if (selDlg.DoModal() == IDOK)
		{

			CWinApp *pApp = AfxGetApp();
			CString sSection, sEntry;
			sSection = INISECTION_ANNSVIEW;
			sEntry = INIENTRY_ANNSVIEW_JPEG_QUALITY;
			int	qr = pApp->GetProfileInt(sSection, sEntry, 80);

			BOOL bSametime;
			sEntry = INIENTRY_ANNSVIEW_SAVE_FILETIME;
			int n = pApp->GetProfileInt(sSection, sEntry, 0);
			bSametime = (n != 0);

			if (qr > 100 || qr < 0) {
				qr = 80;
			}

			CString fname = selDlg.GetPathName();

			n = fname.ReverseFind(_T('.'));


			CString fn, s, sext, sform;
			fn = fname.Left(n);
			s = fname.Mid(n);
			s.MakeLower();

			if (n < 0) {
				s = _T(".png");
				fn = fname;
			}

			sext = _T(".png");
			sform = _T("image/png");

			if (s == _T(".bmp")) {
				sext = _T(".bmp");
				sform = _T("image/bmp");
			}

			if (s == _T(".jpg")) {
				sext = _T(".jpg");
				sform = _T("");
			}

			if (s == _T(".jpeg")) {
				sext = _T(".jpeg");
				sform = _T("");
			}

			if (s == _T(".tif") || s == _T(".tiff")) {
				sext = _T(".tiff");
				sform = _T("image/tiff");
			}

			if (s == _T(".gif")) {
				sext = _T(".gif");
				sform = _T("image/gif");
			}
			if (s == _T(".png")) {
				sform = _T("image/png");
			}


			m_sFileName = fn + sext;
			s = m_sFileName;

			if (sform == _T("")) {

				ULONG quality = qr;

				SaveJpeg(s, quality);
			}
			else {
				CLSID clsid;
				if (!GetEncoderClsid(sform, &clsid))
				{
					return false;
				}
				m_gImage->Save(s, &clsid);
			}
			r = true;
			m_pViewFrame->DrawFileName();

			if (bSametime) {
				CFileStatus fStatus, st;

				CFile::GetStatus(m_sOrgFileName, fStatus);
				CFile::GetStatus(s, st);

				st.m_atime = fStatus.m_atime;
				st.m_ctime = fStatus.m_ctime;
				st.m_mtime = fStatus.m_mtime;

				CFile::SetStatus(s, st);

			}
		}
		m_bEnableRect = false;

	}


	return r;
}


// Cmd No 0x254
void CannsGView::CmdKeyCtrlTTrimming(void)
{

	if ( !m_bEnableRect ) return;


	if (m_pFmParam->m_nOSversion > 6) {
		RECT rect;
		GetClientRect(&rect);
		int width = rect.right - rect.left;
		int height = rect.bottom - rect.top;
		int xof = (width - m_nowXw) / 2 * GMAG_REF / m_nMulti;
		int yof = (height - m_nowYw) / 2 * GMAG_REF / m_nMulti;

		CPoint start, end;


		start.x = m_rectSelect.left;
		start.y = m_rectSelect.top;
		end.x = m_rectSelect.right;
		end.y = m_rectSelect.bottom;



		start.x = start.x * GMAG_REF / m_nMulti;
		start.y = start.y * GMAG_REF / m_nMulti;

		end.x = end.x * GMAG_REF / m_nMulti;
		end.y = end.y * GMAG_REF / m_nMulti;

		int xw = end.x - start.x;
		int yw = end.y - start.y;


#ifndef _WINVER_XP
		if (m_gTarget) {

			m_gTarget->Resize(D2D1::Size(static_cast<UINT>(xw), static_cast<UINT>(yw)));

			WICRect wr;

			int dx = m_rectTriming.left;
			int dy = m_rectTriming.top;

			int rsX = start.x;
			int rsY = start.y;
			int rsXw = xw;
			int rsYw = yw;


			if (m_nRad == 1) {
				rsX = start.y;
				rsY = m_nowXw - (start.x + xw);
				rsXw = yw;
				rsYw = xw;
			}

			if (m_nRad == 2) {
				rsX = m_nowXw - (start.x + xw);
				rsY = m_nowYw - (start.y + yw);
				rsXw = xw;
				rsYw = yw;
			}

			if (m_nRad == 3) {
				rsX = m_nowYw - (start.y + yw);
				rsY = start.x;
				rsXw = yw;
				rsYw = xw;
			}

			if (m_nRad == 0 || m_nRad == 2) {
				if (width > m_nowXw) {
					//				rsX += xof;
				}
				if (height > m_nowYw) {
					//				rsY += yof;
				}
			}

			if (m_nRad == 1 || m_nRad == 3) {
				if (width > m_nowXw) {
					//				rsX += xof;
				}
				if (height > m_nowYw) {
					//				rsY += yof;
				}
			}

			wr.X = rsX + dx;
			wr.Y = rsY + dy;
			wr.Width = rsXw;
			wr.Height = rsYw;

			m_rectTriming.top = wr.Y;
			//		m_rectTriming.bottom = wr.Y + wr.Height;
			m_rectTriming.left = wr.X;
			//		m_rectTriming.right = wr.X + wr.Width;


			// Ro[^Direct2DptH[}bgɕϊ
			CComPtr<IWICFormatConverter> converter;
			HRESULT hr = m_gImagingFactory->CreateFormatConverter(&converter);
			if (FAILED(hr))
			{
				MessageBox(_T("Direct2DtH[}bgϊɎs(CreateFormatConverter)"), _T("D2DG["));
				return;
			}

			CComPtr<IWICBitmapSource> bs;
			//		CComPtr<IWICBitmapFrameDecode> fd;

			if (m_gFrameDec) bs = m_gFrameDec;
			else {
				bs = m_wicHbBitmap;
			}

			CComPtr<IWICBitmapClipper> clipper;

			m_gImagingFactory->CreateBitmapClipper(&clipper);


			m_wrectClip = wr;

			hr = clipper->Initialize(bs, &wr);
			if (FAILED(hr))
			{
				MessageBox(_T("Direct2DtH[}bgϊɎs(Clipper Initialize)"), _T("D2DG["));
				return;
			}

			hr = converter->Initialize(
				clipper, GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone,
				nullptr, 0.f, WICBitmapPaletteTypeMedianCut);

			if (FAILED(hr))
			{
				MessageBox(_T("Direct2DtH[}bgϊɎs(Converter Initialize)"), _T("D2DG["));
				return;
			}


			CComPtr<IWICBitmapFlipRotator> rotator;
			m_gImagingFactory->CreateBitmapFlipRotator(&rotator);

			if (m_nRad == 0) {
				rotator->Initialize(bs, WICBitmapTransformRotate0);
			}
			if (m_nRad == 1) {
				rotator->Initialize(bs, WICBitmapTransformRotate90);
			}
			if (m_nRad == 2) {
				rotator->Initialize(bs, WICBitmapTransformRotate180);
			}
			if (m_nRad == 3) {
				rotator->Initialize(bs, WICBitmapTransformRotate270);
			}

			hr = converter->Initialize(
				rotator, GUID_WICPixelFormat32bppPBGRA, WICBitmapDitherTypeNone,
				nullptr, 0.f, WICBitmapPaletteTypeMedianCut);


			if (m_gBitmap) {
				m_gBitmap.Release();
				m_gBitmap = NULL;
			}

			// Direct2Dprbg}bv쐬
			hr = m_gTarget->CreateBitmapFromWicBitmap(converter, NULL, &m_gBitmap);
			if (FAILED(hr))
			{
				MessageBox(_T("Direct2Drbg}bv쐬Ɏs"), _T("D2DG["));
				return;
			}


			if (m_wicBitmap) {
				m_wicBitmap.Release();
				m_wicBitmap = NULL;
			}
			if (m_wicRenderTarget) {
				m_wicRenderTarget.Release();
				m_wicRenderTarget = NULL;
			}


			if (m_d2dBitmap) {
				m_d2dBitmap.Release();
				m_d2dBitmap = NULL;
			}



			// WICrbg}bv쐬
			m_gImagingFactory->CreateBitmap(
				static_cast<unsigned int>(xw), static_cast<unsigned int>(yw),
				GUID_WICPixelFormat32bppPBGRA,
				WICBitmapCacheOnLoad, &m_wicBitmap);


			m_gFactory->CreateWicBitmapRenderTarget(
				m_wicBitmap, D2D1::RenderTargetProperties(), &m_wicRenderTarget);



			// Direct2Dprbg}bv쐬
			m_wicRenderTarget->CreateBitmapFromWicBitmap(converter, NULL, &m_d2dBitmap);



		}

		m_nMulti = GMAG_REF;
		m_nMultiNow = GMAG_REF;

		m_Xw = xw;
		m_Yw = yw;

		InitScrollBar();

		m_nowXw = m_Xw;
		m_nowYw = m_Yw;

		m_bEnableRect = false;

		ResizeViewD2D();

		m_pViewFrame->AdjustSize();

		GetColorBits();

		InitScrollBar();

		Invalidate();
#endif


	}
	else {
		CPoint start, end;

		start.x = m_rectSelect.left;
		start.y = m_rectSelect.top;
		end.x = m_rectSelect.right;
		end.y = m_rectSelect.bottom;

		/*
		start =  m_cpStartDrag;
		end =  m_cpEndDrag;

		if ( start.y > end.y ) {
		start.y = m_cpEndDrag.y;
		end.y = m_cpStartDrag.y;
		}

		if ( start.x > end.x ) {
		start.x = m_cpEndDrag.x;
		end.x = m_cpStartDrag.x;
		}
		*/

		start.x = start.x * GMAG_REF / m_nMulti;
		start.y = start.y * GMAG_REF / m_nMulti;

		end.x = end.x * GMAG_REF / m_nMulti;
		end.y = end.y * GMAG_REF / m_nMulti;

		int xw = end.x - start.x;
		int yw = end.y - start.y;

		// ꂩ쐬摜p Bitmap IuWFNg쐬
		Bitmap* pBitmap = new Bitmap(xw, yw);

		// Bitmap IuWFNg Graphics IuWFNg쐬
		// ō쐬 Bitmap IuWFNgɕ`悵AۑB
		Graphics* pGrfx = Graphics::FromImage(pBitmap);

		// ^[QbgƂȂ` Rect IuWFNgŕ\Ă
		Gdiplus::Rect rectDist(0, 0, xw, yw);

		// 摜̑Ŝ rectDist ŕ\`̈֎ʑB
		// "摜̑S" ͑3`6ŕ\ĂB摜̈ꕔNbvȂ
		// ŃNbv̈w肷B
		pGrfx->DrawImage(
			m_gImage,
			rectDist,
			start.x, start.y, xw, yw,
			UnitPixel);

		PixelFormat format = PixelFormatDontCare;
		m_gImage = pBitmap->Clone(rectDist, format);

		m_nMulti = GMAG_REF;
		m_nMultiNow = GMAG_REF;

		m_Xw = xw;
		m_Yw = yw;


		m_nowXw = m_Xw;
		m_nowYw = m_Yw;

		m_pViewFrame->AdjustSize();
		InitScrollBar();
		Invalidate();

		m_bEnableRect = false;


		HBITMAP hBitmap = NULL;
		if (m_gImage->GetHBITMAP(Gdiplus::Color(255, 0, 0, 0), &hBitmap) == Gdiplus::Ok)
		{
			DIBSECTION ds;
			GetObject(hBitmap, sizeof(ds), &ds);
			ds.dsBmih.biCompression = BI_RGB; // change compression from 
											  //		BI_BITFIELDS to BI_RGB
											  // Convert the DIB to a device dependent bitmap(i.e., DDB)
			CDC *cDC = GetDC();
			HBITMAP hDDB = CreateDIBitmap(cDC->m_hDC, &ds.dsBmih, CBM_INIT,
				ds.dsBm.bmBits, (BITMAPINFO*)&ds.dsBmih, DIB_RGB_COLORS);
			ReleaseDC(cDC);
			// Open the clipboard
			OpenClipboard();
			EmptyClipboard();
			// Place the handle to the DDB on the clipboard
			SetClipboardData(CF_BITMAP, hDDB);
			// Do not delete the hDDB handle, the clipboard owns it
			CloseClipboard();
		}
		DeleteObject(hBitmap);

	}


}

void CannsGView::OnMenuKeyZoomup()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Resize(true);
}

void CannsGView::OnMenuKeyZoomdown()
{
	// TODO: ɃR}h nh R[hǉ܂B
	Resize(false);
}

void CannsGView::OnMenuKeyUp()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyUp();
}

void CannsGView::OnMenuKeyDown()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyDown();
}

void CannsGView::OnMenuKeySpace()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeySpace();
}

BOOL CannsGView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	// uV̍쐬
	CBrush brush(m_pFmParam->m_colBack);
    // VuVw(̃uV̕ۑ)
    CBrush* pOldBrush = pDC->SelectObject(&brush);

    // hԂ̈擾
    CRect rect;
    GetClientRect(&rect);

	// hԂ
    pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

	// uVɖ߂
    pDC->SelectObject(pOldBrush);

	return TRUE;

//	return CWnd::OnEraseBkgnd(pDC);
}

void CannsGView::OnMenuKeyPeriod()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyPeriod();
}

void CannsGView::OnMenuKeyComma()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyComma();
}




void CannsGView::OnMenuFileSaveAs()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyCtrlSSave();
}

void CannsGView::OnMenuKeyCtrlR()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlRResize();
}



void CannsGView::OnFilePrint()
{
	// TODO: ɃR}h nh R[hǉ܂B

	if (m_pFmParam->m_nOSversion > 6) {
#ifndef _WINVER_XP
		CComPtr<IWICBitmapSource> pwicSource = nullptr;

		if (m_wicHbBitmap) {
			m_wicHbBitmap->QueryInterface(IID_PPV_ARGS(&pwicSource));

		}
		else {
			m_wicBitmap->QueryInterface(IID_PPV_ARGS(&pwicSource));
		}

		UINT width = 0, height = 0;
		pwicSource->GetSize(&width, &height);

		std::vector<BYTE> buffer(width * height * 4);
		pwicSource->CopyPixels(0, width * 4, buffer.size(), buffer.data());

		HBITMAP hBitmap = CreateBitmap(width, height, 1, 32, buffer.data());

		m_gImage = new Gdiplus::Bitmap(hBitmap, NULL);

		if (m_gImage == NULL) return;

		m_bEnableRect = false;

		CPrintInfo printInfo;
		ASSERT(printInfo.m_pPD != NULL);    // must be set
		CWinApp* pApp = AfxGetApp();
		if (pApp->DoPrintDialog(printInfo.m_pPD) != IDOK) return;       // do not print

		CDC dcPrint;
		dcPrint.Attach(printInfo.m_pPD->m_pd.hDC);  // attach printer dc
		dcPrint.m_bPrinting = TRUE;

		// Get the application title
		CString strTitle;
		strTitle.LoadString(AFX_IDS_APP_TITLE);

		// Initialise print document details
		DOCINFO di;
		::ZeroMemory(&di, sizeof(DOCINFO));
		di.cbSize = sizeof(DOCINFO);
		di.lpszDocName = strTitle;

		BOOL bPrinting = dcPrint.StartDoc(&di);
		BOOL bPage = TRUE;

		CDC* dc = GetDC();

		int dx = dc->GetDeviceCaps(LOGPIXELSX);

		int px = dcPrint.GetDeviceCaps(LOGPIXELSX);

		int ratio = px / dx + 1;

		while (bPrinting && bPage) {
			dcPrint.StartPage();
			// ̈ʒu1y[W̏o͂邽߂̃R[h
			// ׂẴy[Wo͂ bPage = FALSE ŏI
			CString s;
			s.Format(_T("[ %s ]"), m_sFileName);
			dcPrint.TextOut(300, 200, s);


			Gdiplus::Graphics graphics(dcPrint.m_hDC);


			int xw = m_Xw;
			int yw = m_Yw;

			//p̃TCYisNZj߂
			int width = dcPrint.GetDeviceCaps(PHYSICALWIDTH);
			int height = dcPrint.GetDeviceCaps(PHYSICALHEIGHT);

			//ItZbg}CiX
			width = width - dcPrint.GetDeviceCaps(PHYSICALOFFSETX) * 2;
			height = height - dcPrint.GetDeviceCaps(PHYSICALOFFSETY) * 2;

			int pw = width / ratio;
			int ph = height / ratio;

			if (xw > pw) {
				double br = (double)xw / (double)pw;
				xw = pw;
				yw = (int)((double)yw / br);

				if (yw > ph) {
					br = (double)m_Yw / (double)ph;
					yw = ph;
					xw = (int)((double)m_Xw / br);
				}
			}


			graphics.DrawImage(m_gImage, 50, 60, xw, yw);

			bPage = FALSE;
			bPrinting = (BOOL)dcPrint.EndPage();
		}

		if (bPrinting) dcPrint.EndDoc();
		else dcPrint.AbortDoc();

		dcPrint.Detach();   // will be cleaned up by CPrintInfo destructor


		if (m_gImage) {
			delete m_gImage;
			m_gImage = NULL;
		}
		ReleaseDC(dc);
		SetFocus();
#endif

	}
	else {
		if (m_gImage == NULL) return;

		m_bEnableRect = false;

		CPrintInfo printInfo;
		ASSERT(printInfo.m_pPD != NULL);    // must be set
		CWinApp* pApp = AfxGetApp();
		if (pApp->DoPrintDialog(printInfo.m_pPD) != IDOK) return;       // do not print

		CDC dcPrint;
		dcPrint.Attach(printInfo.m_pPD->m_pd.hDC);  // attach printer dc
		dcPrint.m_bPrinting = TRUE;

		// Get the application title
		CString strTitle;
		strTitle.LoadString(AFX_IDS_APP_TITLE);

		// Initialise print document details
		DOCINFO di;
		::ZeroMemory(&di, sizeof(DOCINFO));
		di.cbSize = sizeof(DOCINFO);
		di.lpszDocName = strTitle;

		BOOL bPrinting = dcPrint.StartDoc(&di);
		BOOL bPage = TRUE;

		CDC* dc = GetDC();
		int dx = dc->GetDeviceCaps(LOGPIXELSX);

		int px = dcPrint.GetDeviceCaps(LOGPIXELSX);

		int ratio = px / dx + 1;

		while (bPrinting && bPage) {
			dcPrint.StartPage();
			// ̈ʒu1y[W̏o͂邽߂̃R[h
			// ׂẴy[Wo͂ bPage = FALSE ŏI
			CString s;
			s.Format(_T("[ %s ]"), m_sFileName);
			dcPrint.TextOut(300, 200, s);


			Gdiplus::Graphics graphics(dcPrint.m_hDC);


			int xw = m_Xw;
			int yw = m_Yw;

			//p̃TCYisNZj߂
			int width = dcPrint.GetDeviceCaps(PHYSICALWIDTH);
			int height = dcPrint.GetDeviceCaps(PHYSICALHEIGHT);

			//ItZbg}CiX
			width = width - dcPrint.GetDeviceCaps(PHYSICALOFFSETX) * 2;
			height = height - dcPrint.GetDeviceCaps(PHYSICALOFFSETY) * 2;

			int pw = width / ratio;
			int ph = height / ratio;

			if (xw > pw) {
				double br = (double)xw / (double)pw;
				xw = pw;
				yw = (int)((double)yw / br);

				if (yw > ph) {
					br = (double)m_Yw / (double)ph;
					yw = ph;
					xw = (int)((double)m_Xw / br);
				}
			}


			graphics.DrawImage(m_gImage, 50, 60, xw, yw);

			bPage = FALSE;
			bPrinting = (BOOL)dcPrint.EndPage();
		}

		if (bPrinting) dcPrint.EndDoc();
		else dcPrint.AbortDoc();

		dcPrint.Detach();   // will be cleaned up by CPrintInfo destructor

		ReleaseDC(dc);

	}


}


void CannsGView::OnPrint(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	CScrollView::OnPrint(pDC, pInfo);
}

void CannsGView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CmdKeyQuit();
	m_bDragging = true;
	m_bEnableRect = false;

//	CScrollView::OnLButtonDblClk(nFlags, point);
}


void CannsGView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	int sx = GetScrollPos(SB_HORZ);
	int sy = GetScrollPos(SB_VERT);

	m_bDragging = true;
	m_cpStartDrag.x = point.x + sx;
	m_cpStartDrag.y = point.y + sy;
	m_bEnableRect = false;

	CScrollView::OnLButtonDown(nFlags, point);
}


void CannsGView::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	int sx = GetScrollPos(SB_HORZ);
	int sy = GetScrollPos(SB_VERT);

	m_bDragging = false;

	if (m_nRad != 0) return;

	m_cpEndDrag.x = point.x + sx;
	m_cpEndDrag.y = point.y + sy;

	if ( (m_cpStartDrag.x != m_cpEndDrag.x) || (m_cpStartDrag.y != m_cpEndDrag.y) ) {
		m_bEnableRect = true;
	}

	CScrollView::OnLButtonUp(nFlags, point);
}


void CannsGView::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	if ( m_bDragging ) {

		if (m_nRad != 0) return;

		if (m_pFmParam->m_nOSversion > 6) {
			if (m_fFlipH < 0.0 || m_fFlipV < 0.0) return;
		}
		else {
			if (m_nFlip == 1) return;

		}

		int sx = GetScrollPos(SB_HORZ);
		int sy = GetScrollPos(SB_VERT);

		m_cpEndDrag.x = point.x + sx;
		m_cpEndDrag.y = point.y + sy;

		if ( (m_cpStartDrag.x != m_cpEndDrag.x) || (m_cpStartDrag.y != m_cpEndDrag.y) ) {
			m_bEnableRect = true;
			Invalidate(FALSE);
		}
	}

	CScrollView::OnMouseMove(nFlags, point);
}




void CannsGView::OnMenuKeyCtrlT()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlTTrimming();
}

#ifndef _WINVER_XP

void CannsGView::WICBitmapCopyToClipboard()
{
	m_bEnableRect = false;

	CComPtr<IWICBitmapSource> pwicSource = nullptr;

	if (m_wicHbBitmap) {
		m_wicHbBitmap->QueryInterface(IID_PPV_ARGS(&pwicSource));

	}
	else {
		m_wicBitmap->QueryInterface(IID_PPV_ARGS(&pwicSource));
	}

	UINT width = 0, height = 0;
	pwicSource->GetSize(&width, &height);

	std::vector<BYTE> buffer(width * height * 4);
	pwicSource->CopyPixels(0, width * 4, buffer.size(), buffer.data());

	HBITMAP hBitmap = CreateBitmap(width, height, 1, 32, buffer.data());

	OpenClipboard();
	EmptyClipboard();

	SetClipboardData(CF_BITMAP, hBitmap);
	CloseClipboard();

	Invalidate();

}

void CannsGView::WICBitmapPasteFromClipboard(bool bAlpha)
{

	m_bEnableRect = false;
	m_bAlphaFormat = bAlpha;

	if (IsClipboardFormatAvailable(CF_BITMAP)) {
	

		::OpenClipboard(NULL);

		HBITMAP hData;
		hData = (HBITMAP)::GetClipboardData(CF_BITMAP);

		if (m_gImage) {
			delete m_gImage;
			m_gImage = NULL;
		}

		m_gImage = new Gdiplus::Bitmap(hData, NULL);
		GetColorBits();



			struct {
				BITMAPINFOHEADER bmiHeader;
				RGBQUAD bmiColors[256];
			} bmi;

			memset(&bmi, 0, sizeof(bmi));
			bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);

			CDC *dc = GetDC();
			HDC hDC = dc->m_hDC;

			GetDIBits(hDC, hData, 0, 1, NULL, (BITMAPINFO *)&bmi, DIB_RGB_COLORS);

			if (bmi.bmiHeader.biBitCount <= 8)
			{
				GetDIBits(hDC, hData, 0, 1, NULL, (BITMAPINFO *)&bmi, DIB_RGB_COLORS);
			}

			UINT iSize = bmi.bmiHeader.biSizeImage;
			BYTE *bit = new BYTE[iSize];
			memset(bit, 0xff, iSize);

			GetDIBits(hDC, hData, 0, 1, bit, (BITMAPINFO *)&bmi, DIB_RGB_COLORS);

//			m_bAlphaFormat = true;

			
			delete[]bit;

			
		if (m_gImage) {
			delete m_gImage;
			m_gImage = NULL;
		}


		bool rr = CreateDrawDataFromHBitmap(hData);

		if (rr) {
			FreeSPI();
			m_nPdfPage = 0;
			m_nPdfPageNow = 0;

			m_Xw = (int)m_gBitmap->GetSize().width;
			m_Yw = (int)m_gBitmap->GetSize().height;

			m_gTarget->Resize(D2D1::Size(static_cast<UINT>(m_Xw), static_cast<UINT>(m_Yw)));

			m_nRad = 0;

			m_nowXw = m_Xw * m_nMulti / GMAG_REF;
			m_nowYw = m_Yw * m_nMulti / GMAG_REF;

			InitScrollBar();

//			m_pViewFrame->ResizeGViewFrame(m_nowXw, m_nowYw, true);

			ResizeViewD2D();
			Invalidate();
			m_pViewFrame->DrawFileName();
			UpdateWindow();

			m_sOrgFileName = m_sFileName;

		}



		::CloseClipboard();


	}
}

#endif


void CannsGView::OnMenuCtrlKeyC()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
#ifndef _WINVER_XP
	WICBitmapCopyToClipboard();
#endif
}


void CannsGView::OnCtrlKeyU()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlVPaste(false);
}

void CannsGView::OnMenuCtrlKeyV()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlVPaste();
}


void CannsGView::OnMenuKeyCtrlB()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	m_nBackColor++;
	if (m_nBackColor > 3) m_nBackColor = 0;
	Invalidate();
}


void CannsGView::OnMenuKeyColon()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyColon();
}


void CannsGView::OnMenuKeySemicolon()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeySemiColon();
}




void CannsGView::OnMenuCtrlKeyF()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyAdjustSize();
}




void CannsGView::OnMenuCtrlKeyA()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyAutoOrientation();

}


void CannsGView::OnMenuKeyE()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyExif();

}




void CannsGView::OnMenuKeyShiftE()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyShiftExif();

}


//void CannsGView::OnMouseHWheel(UINT nFlags, short zDelta, CPoint pt)
//{
//	// ̋@\ɂ Windows Vista ȍ~̃o[WKvłB
//	// V{ _WIN32_WINNT  >= 0x0600 ɂKv܂B
//	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B
//
//
//	CScrollView::OnMouseHWheel(nFlags, zDelta, pt);
//}


BOOL CannsGView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

//	short shift = GetKeyState(VK_SHIFT);

	BOOL hs = FALSE;
	BOOL vs = FALSE;

	CheckScrollBars(hs, vs);
	CRect rc;
	GetClientRect(&rc);

	int xs = rc.right - SCROLLBARHEIGHT;
	int ys = rc.bottom - SCROLLBARHEIGHT;

	if (zDelta > 0) {

			if (hs) {
				if (pt.y > ys) {
					CmdKeyShiftLeft();
					return TRUE;
				}

			}

			if (vs) {
				if (pt.x > xs) {
					CmdKeyShiftUp();
					return TRUE;
				}
			}

			CmdKeyUp();
	}
	else {

			if (hs) {
				if (pt.y > ys) {
					CmdKeyShiftRight();
					return TRUE;
				}

			}

			if (vs) {
				if (pt.x > xs) {
					CmdKeyShiftDown();
					return TRUE;
				}
			}

			CmdKeyDown();
	}

	return TRUE;

//	return CScrollView::OnMouseWheel(nFlags, zDelta, pt);
}


void CannsGView::OnKeyMenuW()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyMaximum();

}

BOOL CannsGView::GetEncoderClsid(const WCHAR* format, CLSID* pClsid)
{
	UINT num = 0; // number of image encoders  
	UINT size = 0; // size of the image encoder array in bytes  

	ImageCodecInfo* pImageCodecInfo = NULL;

	GetImageEncodersSize(&num, &size);
	if (size == 0)
		return -1; // Failure  

	pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
	if (pImageCodecInfo == NULL)
		return -1; // Failure  

	GetImageEncoders(num, size, pImageCodecInfo);

	for (UINT j = 0; j < num; ++j)
	{
		if (wcscmp(pImageCodecInfo[j].MimeType, format) == 0)
		{
			*pClsid = pImageCodecInfo[j].Clsid;
			free(pImageCodecInfo);
			return TRUE; // Success  
		}
	}

	free(pImageCodecInfo);
	return FALSE; // Failure  
}


bool CannsGView::SaveJpeg(LPCTSTR lpszFile, ULONG nQuality)
{
	EncoderParameters cEncParams;
	cEncParams.Count = 1;
	cEncParams.Parameter[0].Guid = EncoderQuality;
	cEncParams.Parameter[0].NumberOfValues = 1;
	cEncParams.Parameter[0].Type = EncoderParameterValueTypeLong;
	cEncParams.Parameter[0].Value = &nQuality;

	CLSID clsid;
	if (!GetEncoderClsid(L"image/jpeg", &clsid))
	{
		return false;
	}

	if (m_gImage->Save(lpszFile, &clsid, &cEncParams) == Ok)
	{
		return true;
	}
	return false;
}


// Cmd No 0x252
void CannsGView::CmdKeyCtrlCCopyToClipboard(void)
{
	if (m_pFmParam->m_nOSversion > 6) {
#ifndef _WINVER_XP
		WICBitmapCopyToClipboard();
#endif
		return;
	}


	if (m_gImage) {

		HBITMAP hBitmap = NULL;
		if (m_gImage->GetHBITMAP(Gdiplus::Color(255, 0, 0, 0), &hBitmap) == Gdiplus::Ok)
		{
			DIBSECTION ds;
			GetObject(hBitmap, sizeof(ds), &ds);
			ds.dsBmih.biCompression = BI_RGB; // change compression from 
											  //		BI_BITFIELDS to BI_RGB
											  // Convert the DIB to a device dependent bitmap(i.e., DDB)
			CDC *cDC = GetDC();
			HBITMAP hDDB = CreateDIBitmap(cDC->m_hDC, &ds.dsBmih, CBM_INIT,
				ds.dsBm.bmBits, (BITMAPINFO*)&ds.dsBmih, DIB_RGB_COLORS);
			ReleaseDC(cDC);
			// Open the clipboard
			OpenClipboard();
			EmptyClipboard();
			// Place the handle to the DDB on the clipboard
			SetClipboardData(CF_BITMAP, hDDB);
			// Do not delete the hDDB handle, the clipboard owns it
			CloseClipboard();
		}
		DeleteObject(hBitmap);

		m_gImage = NULL;
	}
}


// Cmd No 0x256
void CannsGView::CmdKeyCtrlVPaste(bool bAlpha)
{

	if (m_pFmParam->m_nOSversion > 6) {
#ifndef _WINVER_XP
		WICBitmapPasteFromClipboard(bAlpha);
#endif
		return;
	}

	if (IsClipboardFormatAvailable(CF_BITMAP)) {
		if (m_gImage) {


			delete m_gImage;


			::OpenClipboard(NULL);

			HBITMAP hData;
			hData = (HBITMAP)::GetClipboardData(CF_BITMAP);

			//			m_gImage = new Gdiplus::Bitmap(hData, (HPALETTE)GetStockObject(DEFAULT_PALETTE));
			m_gImage = new Gdiplus::Bitmap(hData, NULL);


			::CloseClipboard();


			m_Xw = m_gImage->GetWidth();
			m_Yw = m_gImage->GetHeight();

			m_nowXw = m_Xw * m_nMulti / GMAG_REF;
			m_nowYw = m_Yw * m_nMulti / GMAG_REF;

			InitScrollBar();

			m_bEnableRect = false;
			GetColorBits();
			//			m_pViewFrame->ResizeGViewFrame(m_nowXw, m_nowYw, true);

			//				m_sFileName = path;
			m_pViewFrame->m_pwndFile->DrawCursor();
			m_pViewFrame->DrawFileName();

			Invalidate();
		}

	}
}



BOOL CannsGView::OnScrollBy(CSize sizeScroll, BOOL bDoScroll)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB

	return CScrollView::OnScrollBy(sizeScroll, bDoScroll);
}


void CannsGView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	bool bOrg = false;

	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_TRACKPOS;

	this->GetScrollInfo(SB_HORZ, (&info));
	nPos = info.nTrackPos;

	switch (nSBCode) {
	case SB_RIGHT:	// XN[{bNX̉ENbNꍇ
		break;

	case SB_LEFT:	// XN[{bNX̍NbNꍇ
		break;

	case SB_PAGEUP:		// XN[{bNX̉ENbNꍇi܂PageUpL[j
		break;

	case SB_PAGEDOWN:		// XN[{bNX̍NbNꍇi܂PageDownL[j
		break;

	case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
		break;

	case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
		bOrg = true;

		SetScrollPos(SB_HORZ, nPos);
		Invalidate();
		break;
	}



	if (!bOrg) CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
}


void CannsGView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	bool bOrg = false;

	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_TRACKPOS;

	this->GetScrollInfo(SB_VERT, (&info));
	nPos = info.nTrackPos;

	switch (nSBCode) {
	case SB_LINEUP:	// XN[{bNX̏NbNꍇ
		break;

	case SB_LINEDOWN:	// XN[{bNX̉NbNꍇ
		break;

	case SB_PAGEUP:		// XN[{bNX̏㑤NbNꍇi܂PageUpL[j
		break;

	case SB_PAGEDOWN:		// XN[{bNX̉NbNꍇi܂PageDownL[j
		break;

	case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
		break;

	case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
		bOrg = true;

		SetScrollPos(SB_VERT, nPos);
		Invalidate();
		break;
	}

	if (!bOrg) CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);
}
