// WildCardDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "WildCardDialog.h"
#include "FmParam.h"
#include "afxdialogex.h"


// CWildCardDialog _CAO

IMPLEMENT_DYNAMIC(CWildCardDialog, CDialog)

CWildCardDialog::CWildCardDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CWildCardDialog::IDD, pParent)
	, m_sWildCard(_T("*.*"))
	, m_bMaskdirCheck(false)
	, m_bAddstrCheck(false)
{

}

CWildCardDialog::~CWildCardDialog()
{
}

void CWildCardDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_WILDCARD_COMBO, m_ctrlWildCardCombo);
	DDX_Control(pDX, IDC_MASKDIR_CHECK, m_ctrlMaskdirCheck);
	DDX_Control(pDX, IDC_ADDSTR_CHECK, m_ctrlAddstrCheck);
}


BEGIN_MESSAGE_MAP(CWildCardDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CWildCardDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_MASKDIR_CHECK, &CWildCardDialog::OnBnClickedMaskdirCheck)
	ON_BN_CLICKED(IDC_ADDSTR_CHECK, &CWildCardDialog::OnBnClickedAddstrCheck)
END_MESSAGE_MAP()


// CWildCardDialog bZ[W nh[


BOOL CWildCardDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	CString fext;
	fext = _T(".hiy");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlWildCardCombo);

	m_ctrlWildCardCombo.SetWindowTextW(m_sWildCard);

	m_bAddstrCheck = false;
	int check = BST_UNCHECKED;
	if ( m_pFmParam->m_bAddstr ) {
		check = BST_CHECKED;
		m_bAddstrCheck = true;
	}
	m_ctrlAddstrCheck.SetCheck(check);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


void CWildCardDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	CString s, s2;
	m_ctrlWildCardCombo.GetWindowTextW(s);

	if ( m_bAddstrCheck ) {
		int nLast = s.GetLength() - 1;
		if ( nLast < 0 ) nLast = 0;
		if ( s != _T("") && s != _T("*.*") && s.GetAt(0) != _T('*') && s.GetAt(nLast) != _T('*')) {
			s2 = _T("*");
			s2 += s;
			s2 += _T("*");
			s = s2;
		}
	}
	m_pFmParam->m_bAddstr = m_bAddstrCheck;

	m_sWildCard = s;

//	m_ctrlWildCardCombo.GetWindowTextW(m_sWildCard);

	CDialog::OnOK();
}


void CWildCardDialog::OnBnClickedMaskdirCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	int n = m_ctrlMaskdirCheck.GetCheck();
	m_bMaskdirCheck = ( n == 1) ? true : false;
}


void CWildCardDialog::OnBnClickedAddstrCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	int n = m_ctrlAddstrCheck.GetCheck();
	m_bAddstrCheck = ( n == 1) ? true : false;
}
