// UnPackDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "UnPackDialog.h"
#include "FmParam.h"
#include "SelectJumpFolderDialog.h"
#include "TreeFrameWindow.h"
#include "JumpFrame.h"


// CUnPackDialog _CAO

IMPLEMENT_DYNAMIC(CUnPackDialog, CDialog)

CUnPackDialog::CUnPackDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CUnPackDialog::IDD, pParent)
	, m_sPath(_T(""))
	, m_bWithPath(true)
	, m_sFileName(_T(""))
	, m_bCheckMakeDir(false)
	, m_bCheckMovedir(false)
{
}

CUnPackDialog::~CUnPackDialog()
{
//	CoUninitialize();
}

void CUnPackDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PATH, m_ctrlPath);
	DDX_Control(pDX, IDC_CHECK_WITHPATH, m_ctrlWithPath);
	DDX_Text(pDX, IDC_FILENAME, m_sFileName);
	DDX_Text(pDX, IDC_PATH, m_sPath);
	//	DDX_Check(pDX, IDC_CHECK_WITHPATH, (int&)m_bWithPath);
	DDX_Control(pDX, IDC_CHECK_MAKEDIR, m_ctrlCheckMakeDir);
	DDX_Control(pDX, IDC_CHECK_MOVEDIR, m_ctrlCheckMovedir);
}


BEGIN_MESSAGE_MAP(CUnPackDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CUnPackDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_CHECK_WITHPATH, &CUnPackDialog::OnBnClickedCheckWithpath)
	ON_BN_CLICKED(IDC_BROWSE_BUTTON, &CUnPackDialog::OnBnClickedBrowseButton)
	ON_BN_CLICKED(IDC_JUMPFOLDER_BUTTON, &CUnPackDialog::OnBnClickedJumpfolderButton)

	ON_COMMAND(ID_TREE_MESSAGE, &CUnPackDialog::OnTreeMessage)
	ON_COMMAND(ID_JUMP_MESSAGE, &CUnPackDialog::OnJumpMessage)
	ON_BN_CLICKED(IDC_BROWSE_WIN, &CUnPackDialog::OnBnClickedBrowseWin)
	ON_CBN_SELCHANGE(IDC_PATH, &CUnPackDialog::OnCbnSelchangePath)
	ON_BN_CLICKED(IDC_CHECK_MAKEDIR, &CUnPackDialog::OnBnClickedCheckMakedir)
	ON_BN_CLICKED(IDC_CHECK_MOVEDIR, &CUnPackDialog::OnBnClickedCheckMovedir)
END_MESSAGE_MAP()


// CUnPackDialog bZ[W nh

void CUnPackDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	CString s;
	m_ctrlPath.GetWindowTextW(m_sPath);

	if ( m_sPath == _T("") ) {
		OnBnClickedBrowseButton();
		return;
	}

	int bn = m_ctrlWithPath.GetCheck();

	m_bWithPath = false;
	if ( bn == BST_CHECKED ) m_bWithPath = true;

	bn = m_ctrlCheckMakeDir.GetCheck();

	m_bCheckMakeDir = false;
	if ( bn == BST_CHECKED ) {
		m_bCheckMakeDir = true;
	}


	OnOK();
}

void CUnPackDialog::OnBnClickedCheckWithpath()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int bn = m_ctrlWithPath.GetCheck();

	m_bWithPath = false;
	if ( bn == BST_CHECKED ) m_bWithPath = true;

}

BOOL CUnPackDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	m_bWithPath = true;
	m_ctrlWithPath.SetCheck(BST_CHECKED);

	int n = BST_UNCHECKED;
	if (m_bCheckMakeDir) n = BST_CHECKED;
	m_ctrlCheckMakeDir.SetCheck(n);

	n = BST_UNCHECKED;
	if (m_bCheckMovedir) n = BST_CHECKED;
	m_ctrlCheckMovedir.SetCheck(n);

	CString fext;
	fext = _T(".hid");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlPath);

//	if ( m_pFmParam->m_TagFileNum != 0 ) {
//		m_ctrlCheckMovedir.EnableWindow(FALSE);
//	}
	m_ctrlPath.SetWindowTextW(m_sPath);
	UpdateData(FALSE);

//	CoInitialize(NULL);
	CEdit *pEdit = (CEdit *)m_ctrlPath.GetWindow(GW_CHILD);

	if (m_pFmParam->m_bSettingsAutocomplete) {
		::SHAutoComplete(pEdit->m_hWnd, SHACF_FILESYSTEM);
	}

	if (m_pFmParam->m_bSettingsSetDialogFont) {
		m_font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_ctrlPath.SetFont(&m_font);

	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CUnPackDialog::OnBnClickedBrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}

	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();

}

void CUnPackDialog::OnBnClickedJumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	m_pJumpFrameWindow = new CJumpFrame;
	m_pJumpFrameWindow->m_pFmParam = m_pFmParam;
	m_pJumpFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrameWindow->ShowWindow(SW_SHOW);
	m_pJumpFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pJumpFrameWindow->UpdateWindow();
/*
	CSelectJumpFolderDialog dlg;
	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r = IDOK ) {
		m_sPath = dlg.m_sSelectedFolder;
		m_ctrlPath.SetWindowTextW(m_sPath);
		m_ctrlPath.SetFocus();
	}
*/
}

void CUnPackDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

	SetFocus();
	m_sPath = path;
	m_ctrlPath.SetWindowTextW(path);
	m_ctrlPath.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CUnPackDialog::OnJumpMessage()
{
	CString path = m_pFmParam->m_sSelectedJumpPath;

	SetFocus();
	m_sPath = path;
	m_ctrlPath.SetWindowTextW(path);
	m_ctrlPath.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CUnPackDialog::OnBnClickedBrowseWin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	cpath = cpath.Left(cpath.GetLength() - 1);

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_sPath = chPutFolder;
			m_sPath += STR_YEN;
			m_ctrlPath.SetWindowTextW(m_sPath);
			m_ctrlPath.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}

}

void CUnPackDialog::OnCbnSelchangePath()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlPath.ShowDropDown();
}

int CALLBACK CUnPackDialog::BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
		::SendMessage(hwnd,BFFM_SETSELECTION,(WPARAM)TRUE,lpData);
    }
    return 0;
}

void CUnPackDialog::OnBnClickedCheckMakedir()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int bn = m_ctrlCheckMakeDir.GetCheck();

	m_bCheckMakeDir = false;
	if ( bn == BST_CHECKED ) m_bCheckMakeDir = true;
}


void CUnPackDialog::OnBnClickedCheckMovedir()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	int bn = m_ctrlCheckMovedir.GetCheck();

	m_bCheckMovedir = false;
	if ( bn == BST_CHECKED ) m_bCheckMovedir = true;
}
