// TreeFrameWindow.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "TreeFrameWindow.h"
#include "annsTreeView.h"
#include "FmParam.h"


// CTreeFrameWindow

IMPLEMENT_DYNCREATE(CTreeFrameWindow, CFrameWnd)

CTreeFrameWindow::CTreeFrameWindow()
{
	m_bExit = true;	// true:tH_IEBhE  false:Ȃ
	m_pwndParent = NULL;

}

CTreeFrameWindow::~CTreeFrameWindow()
{
	m_pwndParent = NULL;
}


BEGIN_MESSAGE_MAP(CTreeFrameWindow, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_MOUSEWHEEL()
	ON_WM_KEYDOWN()
//	ON_COMMAND(ID_TREE_EXIT, &CTreeFrameWindow::OnTreeExit)
END_MESSAGE_MAP()


// CTreeFrameWindow bZ[W nh

int CTreeFrameWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB

	CWinApp *pApp = AfxGetApp();

	CRect rc;
	CString sSection, sEntry, tmp;

	sSection = INISECTION_ANNSTREE_WINDOW;
	sEntry = INIENTRY_WINDOW_TOP;
	rc.top = pApp->GetProfileInt(sSection, sEntry, 0);
	sEntry = INIENTRY_WINDOW_LEFT;
	rc.left = pApp->GetProfileInt(sSection, sEntry, 0);
	sEntry = INIENTRY_WINDOW_RIGHT;
	rc.right = pApp->GetProfileInt(sSection, sEntry, 320);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	rc.bottom = pApp->GetProfileInt(sSection, sEntry, 480);

	m_pannsTreeView = new CannsTreeView;
	m_pannsTreeView->m_pTreeFrameWindow = this;
	m_pannsTreeView->m_pFmParam = m_pFmParam;
	m_pannsTreeView->m_pDriveTabWnd = m_pDriveTabWnd;
	if (!m_pannsTreeView->Create(NULL, NULL, WS_CHILD | WS_VISIBLE, rc, this, 1, NULL))
	{
		TRACE0("annsTreeView EBhE쐬ł܂łB\n");
		return -1;
	}

	EnumDisplayMonitors(NULL, NULL, m_pFmParam->MonitorEnumProc, 0);

	int n = m_pFmParam->m_nMonitor;

	bool bok = false;
	int x = rc.left + 10;
	int y = rc.top + 10;

	for (int i = 0; i < n; i++) {
		if (x > m_pFmParam->m_rcMonitor[i].left && y > m_pFmParam->m_rcMonitor[i].top) {
			bok = true;
			break;
		}

	}

	if (bok == false) {
		rc.top = 0;
		rc.left = 0;
		rc.right = 320;
		rc.bottom = 480;
	}

	MoveWindow(&rc);

	m_pFmParam->m_bEnableTreeWindow = true;

	return 0;
}

void CTreeFrameWindow::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CRect rc;
	GetClientRect(&rc);

	m_pannsTreeView->MoveWindow(&rc);

}

BOOL CTreeFrameWindow::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	// uV̍쐬
	CBrush brush(m_pFmParam->m_colBack);
    // VuVw(̃uV̕ۑ)
    CBrush* pOldBrush = pDC->SelectObject(&brush);

    // hԂ̈擾
    CRect rect;
    GetClientRect(&rect);

	// hԂ
    pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

	// uVɖ߂
    pDC->SelectObject(pOldBrush);

	return TRUE;

//	return CFrameWnd::OnEraseBkgnd(pDC);
}

void CTreeFrameWindow::OnDestroy()
{
	CFrameWnd::OnDestroy();

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry, tmp;
	CRect rc;
	GetWindowRect(&rc);

	sSection = INISECTION_ANNSTREE_WINDOW;
	sEntry = INIENTRY_WINDOW_TOP;
	pApp->WriteProfileInt(sSection, sEntry, rc.top);
	sEntry = INIENTRY_WINDOW_LEFT;
	pApp->WriteProfileInt(sSection, sEntry, rc.left);
	sEntry = INIENTRY_WINDOW_RIGHT;
	pApp->WriteProfileInt(sSection, sEntry, rc.right);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	pApp->WriteProfileInt(sSection, sEntry, rc.bottom);

	m_pFmParam->m_bEnableTreeWindow = false;

	// TODO: ɃbZ[W nh R[hǉ܂B
}

/*

BOOL CTreeFrameWindow::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	return m_pannsTreeView->OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);

//	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CTreeFrameWindow::OnTreeExit()
{
// TODO: ɃR}h nh R[hǉ܂B
}
*/


BOOL CTreeFrameWindow::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	return m_pannsTreeView->MouseWheel(nFlags, zDelta, pt);

//	return CFrameWnd::OnMouseWheel(nFlags, zDelta, pt);
}

void CTreeFrameWindow::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	m_pannsTreeView->OnKeyDown(nChar, nRepCnt, nFlags);

//	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}



