// SetJumpdirDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "SetJumpdirDialog.h"
#include "FmParam.h"
#include "JumpView.h"
#include "TreeFrameWindow.h"


// CSetJumpdirDialog _CAO

IMPLEMENT_DYNAMIC(CSetJumpdirDialog, CDialog)

CSetJumpdirDialog::CSetJumpdirDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSetJumpdirDialog::IDD, pParent)
	, m_sJumpPath(_T(""))
	, m_sJumpNameEdit(_T(""))
{
	m_pJumpView = (CJumpView*)pParent;

}

CSetJumpdirDialog::~CSetJumpdirDialog()
{
}

void CSetJumpdirDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_JUMP_PATH_COMBO, m_ctrlJumpPathCombo);
	DDX_Control(pDX, IDC_JUMP_NAME_EDIT, m_ctrlJumpNameEdit);
}


BEGIN_MESSAGE_MAP(CSetJumpdirDialog, CDialog)
	ON_BN_CLICKED(IDC_BROWSE_BUTTON, &CSetJumpdirDialog::OnBnClickedBrowseButton)
	ON_BN_CLICKED(IDC_CURRENT_BUTTON, &CSetJumpdirDialog::OnBnClickedCurrentButton)
	ON_BN_CLICKED(IDOK, &CSetJumpdirDialog::OnBnClickedOk)
	ON_CBN_SELCHANGE(IDC_JUMP_PATH_COMBO, &CSetJumpdirDialog::OnCbnSelchangeJumpPathCombo)
	ON_BN_CLICKED(IDC_BROWSE_WIN, &CSetJumpdirDialog::OnBnClickedBrowseWin)

	ON_COMMAND(ID_TREE_MESSAGE, &CSetJumpdirDialog::OnTreeMessage)
	ON_EN_KILLFOCUS(IDC_JUMP_NAME_EDIT, &CSetJumpdirDialog::OnEnKillfocusJumpNameEdit)
END_MESSAGE_MAP()


// CSetJumpdirDialog bZ[W nh

void CSetJumpdirDialog::OnBnClickedBrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();

}

void CSetJumpdirDialog::OnBnClickedCurrentButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_sJumpPath = m_pJumpView->m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pJumpView->m_pFmParam->m_CurrentDriveNo];
	m_ctrlJumpPathCombo.SetWindowTextW(m_sJumpPath);
	m_ctrlJumpPathCombo.SetFocus();
//	UpdateData();
}

BOOL CSetJumpdirDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	CString fext;
	fext = _T(".hid");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlJumpPathCombo);

	m_ctrlJumpPathCombo.SetWindowTextW(m_sJumpPath);
	m_ctrlJumpNameEdit.SetWindowTextW(m_sJumpNameEdit);


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CSetJumpdirDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CString s;
	m_ctrlJumpPathCombo.GetWindowTextW(s);

	if ( s == _T("") ) {
		OnBnClickedBrowseButton();
		return;
	}

	m_sJumpPath = s;

	CString fext;
	fext = _T(".hid");
	m_pFmParam->WriteHistoryFile(fext, s);

	m_ctrlJumpNameEdit.GetWindowTextW(s);
	m_sJumpNameEdit = s;

	OnOK();
}

void CSetJumpdirDialog::OnCbnSelchangeJumpPathCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_ctrlJumpPathCombo.ShowDropDown();
}

void CSetJumpdirDialog::OnBnClickedBrowseWin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = 0;	//\tOłB
	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_sJumpPath = chPutFolder;
			m_sJumpPath += STR_YEN;
			m_ctrlJumpPathCombo.SetWindowTextW(m_sJumpPath);
			m_ctrlJumpPathCombo.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}
}

void CSetJumpdirDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

	SetFocus();
	m_sJumpPath = path;
	m_ctrlJumpPathCombo.SetWindowTextW(path);
	m_ctrlJumpPathCombo.SetFocus();
	m_pTreeFrameWindow = NULL;

}





void CSetJumpdirDialog::OnEnKillfocusJumpNameEdit()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	CString s;
	CStringA sA, sA2;
	m_ctrlJumpNameEdit.GetWindowTextW(s);

	sA = CW2A(s);
	int len = sA.GetLength();

	while (len > MAX_NAME_NUM) {
		int l = s.GetLength() - 1;
		if (l <= 0) {
			break;
		}
		s = s.Left(l);
		sA = CW2A(s);
		len = sA.GetLength();

	}

	m_sJumpNameEdit = s;
	m_ctrlJumpNameEdit.SetWindowTextW(m_sJumpNameEdit);

}


BOOL CSetJumpdirDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB


	return CDialog::PreTranslateMessage(pMsg);
}
