// SelectSortDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "SelectSortDialog.h"
#include "FmParam.h"


// CSelectSortDialog _CAO

IMPLEMENT_DYNAMIC(CSelectSortDialog, CDialog)

CSelectSortDialog::CSelectSortDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectSortDialog::IDD, pParent)
	, m_bSortExplorerCheck(false)
{

}

CSelectSortDialog::~CSelectSortDialog()
{
	m_SortMode = SORT_NAME;
	m_InitSortOrder = false;
	m_SortOrder = false;
}

void CSelectSortDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SORTNAME, m_ctrlName);
	DDX_Control(pDX, IDC_SORTEXT, m_ctrlExt);
	DDX_Control(pDX, IDC_SORTDATE, m_ctrlTime);
	DDX_Control(pDX, IDC_SORTSIZE, m_ctrlSize);
	DDX_Control(pDX, IDC_SORTNON, m_ctrlNon);
	DDX_Control(pDX, IDC_SORTUOD, m_ctrlUod);
	DDX_Control(pDX, IDC_SORTDOD, m_ctrlDod);
	DDX_Control(pDX, IDC_SORT_EXPLORER_CHECK, m_ctrlSortExplorerCheck);
}


BEGIN_MESSAGE_MAP(CSelectSortDialog, CDialog)
	ON_BN_CLICKED(IDC_SORTNAME, &CSelectSortDialog::OnBnClickedSortname)
	ON_BN_CLICKED(IDC_SORTEXT, &CSelectSortDialog::OnBnClickedSortext)
	ON_BN_CLICKED(IDC_SORTDATE, &CSelectSortDialog::OnBnClickedSortdate)
	ON_BN_CLICKED(IDC_SORTSIZE, &CSelectSortDialog::OnBnClickedSortsize)
	ON_BN_CLICKED(IDC_SORTNON, &CSelectSortDialog::OnBnClickedSortnon)
	ON_BN_CLICKED(IDC_SORTUOD, &CSelectSortDialog::OnBnClickedSortuod)
	ON_BN_CLICKED(IDC_SORTDOD, &CSelectSortDialog::OnBnClickedSortdod)
	ON_BN_CLICKED(IDC_SORT_EXPLORER_CHECK, &CSelectSortDialog::OnBnClickedSortExplorerCheck)
END_MESSAGE_MAP()


// CSelectSortDialog bZ[W nh

void CSelectSortDialog::OnBnClickedSortname()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_SortMode = SORT_NAME;
	EnableButton();
}

void CSelectSortDialog::OnBnClickedSortext()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_SortMode = SORT_EXT;
	EnableButton();
}

void CSelectSortDialog::OnBnClickedSortdate()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_SortMode = SORT_TIME;
	EnableButton();
}

void CSelectSortDialog::OnBnClickedSortsize()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_SortMode = SORT_SIZE;
	EnableButton();
}

void CSelectSortDialog::OnBnClickedSortnon()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_SortMode = SORT_NON;
	EnableButton();
}

void CSelectSortDialog::OnBnClickedSortuod()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_SortOrder = false;
	EndDialog(0);
}

void CSelectSortDialog::OnBnClickedSortdod()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_SortOrder = true;
	EndDialog(0);
}

void CSelectSortDialog::EnableButton(void)
{

	m_ctrlName.EnableWindow(FALSE);
	m_ctrlExt.EnableWindow(FALSE);
	m_ctrlTime.EnableWindow(FALSE);
	m_ctrlSize.EnableWindow(FALSE);
	m_ctrlNon.EnableWindow(FALSE);

	m_ctrlUod.EnableWindow();
	m_ctrlDod.EnableWindow();

	SetDefID(IDC_SORTUOD);
	m_ctrlUod.SetFocus();

	if ( m_InitSortOrder ) {
		SetDefID(IDC_SORTDOD);
		m_ctrlDod.SetFocus();
	}

}

void CSelectSortDialog::OnBnClickedSortExplorerCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_bSortExplorerCheck = !m_bSortExplorerCheck;
	m_ctrlSortExplorerCheck.SetCheck(m_bSortExplorerCheck);

}

BOOL CSelectSortDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	m_ctrlSortExplorerCheck.SetCheck(m_bSortExplorerCheck);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}
