// SelectRemoveDrive.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "SelectRemoveDrive.h"
#include "afxdialogex.h"


// CSelectRemoveDrive _CAO

IMPLEMENT_DYNAMIC(CSelectRemoveDrive, CDialog)

CSelectRemoveDrive::CSelectRemoveDrive(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectRemoveDrive::IDD, pParent)
	, m_nRemovableDriveCombo(0)
	, m_bRemoveMediaCheck(false)
{

}

CSelectRemoveDrive::~CSelectRemoveDrive()
{
}

void CSelectRemoveDrive::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_REMOVABLE_DRIVE_COMBO, m_ctrlRemovableDriveCombo);
	DDX_Control(pDX, IDC_REMOVE_MEDIA_CHECK, m_ctrlRemoveMediaCheck);
}


BEGIN_MESSAGE_MAP(CSelectRemoveDrive, CDialog)
	ON_CBN_SELCHANGE(IDC_REMOVABLE_DRIVE_COMBO, &CSelectRemoveDrive::OnCbnSelchangeRemovableDriveCombo)
	ON_BN_CLICKED(IDOK, &CSelectRemoveDrive::OnBnClickedOk)
	ON_BN_CLICKED(IDC_REMOVE_MEDIA_CHECK, &CSelectRemoveDrive::OnBnClickedRemoveMediaCheck)
END_MESSAGE_MAP()


// CSelectRemoveDrive bZ[W nh[


BOOL CSelectRemoveDrive::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	int max = m_pDriveTabWnd->m_MaxTab;
	int n = 0;

	for ( int i = 0; i < max; i++ ) {

		if (  ( m_pDriveTabWnd->m_pDriveType[i] == DRIVE_REMOVABLE) || (m_pDriveTabWnd->m_pDriveType[i] == DRIVE_CDROM ) ) {
			CString sDrv = m_pDriveTabWnd->m_pDriveList[i];
			if ( m_sCurrentPath[0] != sDrv[0] ) {
				m_ctrlRemovableDriveCombo.AddString( m_pDriveTabWnd->m_pDriveList[i]);
				m_nDriveType[n] = m_pDriveTabWnd->m_pDriveType[i];
				n++;
			}
		}
	}

	m_nRemovableDriveCombo = 0;
	m_ctrlRemovableDriveCombo.SetCurSel(0);

	if ( m_nDriveType[m_nRemovableDriveCombo] == DRIVE_CDROM ) {
		m_ctrlRemoveMediaCheck.SetCheck(TRUE);
		m_ctrlRemoveMediaCheck.EnableWindow(FALSE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


void CSelectRemoveDrive::OnCbnSelchangeRemovableDriveCombo()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	m_nRemovableDriveCombo = m_ctrlRemovableDriveCombo.GetCurSel();

	m_ctrlRemoveMediaCheck.SetCheck(FALSE);
	m_ctrlRemoveMediaCheck.EnableWindow(TRUE);

	if ( m_nDriveType[m_nRemovableDriveCombo] == DRIVE_CDROM ) {
		m_ctrlRemoveMediaCheck.SetCheck(TRUE);
		m_ctrlRemoveMediaCheck.EnableWindow(FALSE);
	}

}


void CSelectRemoveDrive::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	int cp = m_ctrlRemovableDriveCombo.GetCurSel();
	m_ctrlRemovableDriveCombo.GetLBText(cp, m_sDriveName);
	m_nSelectDriveType = m_nDriveType[cp];


	CDialog::OnOK();
}


void CSelectRemoveDrive::OnBnClickedRemoveMediaCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	int n = m_ctrlRemoveMediaCheck.GetCheck();
	m_bRemoveMediaCheck = ( n == 1) ? true : false;
}
