// Param7Dialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "Param7Dialog.h"
#include "MyFontDialog.h"


// CParam7Dialog _CAO

IMPLEMENT_DYNAMIC(CParam7Dialog, CDialog)

CParam7Dialog::CParam7Dialog(CWnd* pParent /*=NULL*/)
	: CDialog(CParam7Dialog::IDD, pParent)
	, m_nCREdit(0)
	, m_nCGEdit(0)
	, m_nCBEdit(0)
	, m_nScrollNum(0)
	, m_nLineSpaceCombo(0)
	, m_bAdjustSizeCheck(false)
	, m_nBackColor(0)
	, m_bAutoOrientationCheck(false)
	, m_sFontName(_T(""))
	, m_nFontSize(0)
	, m_bUseannsFMtextExeCheck(false)
{

}

CParam7Dialog::~CParam7Dialog()
{
}

void CParam7Dialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COLOR_LIST, m_ctrlColorListBox);
	DDX_Control(pDX, IDC_CR_EDIT, m_ctrlCREdit);
	DDX_Control(pDX, IDC_CG_EDIT, m_ctrlCGEdit);
	DDX_Control(pDX, IDC_CB_EDIT, m_ctrlCBEdit);
	DDX_Control(pDX, IDC_COLOR_SAMPLE, m_ctrlColorSample);
	DDX_Control(pDX, IDC_SCROLLNUM_COMBO, m_ctrlScrollNum);
	DDX_Control(pDX, IDC_LINESPACE_COMBO, m_ctrlLineSpaceCombo);
	DDX_Control(pDX, IDC_ADJUST_SIZE_CHECK, m_ctrlAdjustSizeCheck);
	DDX_Control(pDX, IDC_BACKCOLOR_COMBO, m_ctrlBackColor);
	DDX_Control(pDX, IDC_AUTO_ORIENTATION_CHECK, m_ctrlAutoOrientationCheck);
	DDX_Control(pDX, IDC_FONTNAME, m_ctrlFontName);
	DDX_Control(pDX, IDC_FONTSIZE, m_ctrlFontSize);
	DDX_Control(pDX, IDC_USE_ANNSFMTEXTEXE_CHECK, m_ctrlUseannsFMtextExeCheck);
}


BEGIN_MESSAGE_MAP(CParam7Dialog, CDialog)
	ON_WM_CTLCOLOR()
	ON_EN_CHANGE(IDC_CR_EDIT, &CParam7Dialog::OnEnChangeCrEdit)
	ON_EN_CHANGE(IDC_CG_EDIT, &CParam7Dialog::OnEnChangeCgEdit)
	ON_EN_CHANGE(IDC_CB_EDIT, &CParam7Dialog::OnEnChangeCbEdit)
	ON_CBN_SELCHANGE(IDC_SCROLLNUM_COMBO, &CParam7Dialog::OnCbnSelchangeScrollnumCombo)
	ON_LBN_SELCHANGE(IDC_COLOR_LIST, &CParam7Dialog::OnLbnSelchangeColorList)
	ON_CBN_SELCHANGE(IDC_LINESPACE_COMBO, &CParam7Dialog::OnCbnSelchangeLinespaceCombo)
	ON_BN_CLICKED(IDC_ADJUST_SIZE_CHECK, &CParam7Dialog::OnBnClickedAdjustSizeCheck)
	ON_CBN_SELCHANGE(IDC_BACKCOLOR_COMBO, &CParam7Dialog::OnCbnSelchangeBackcolorCombo)
	ON_BN_CLICKED(IDC_AUTO_ORIENTATION_CHECK, &CParam7Dialog::OnBnClickedAutoOrientationCheck)
	ON_BN_CLICKED(IDC_SELECTFONT_BUTTON, &CParam7Dialog::OnBnClickedSelectfontButton)
	ON_BN_CLICKED(IDC_USE_ANNSFMTEXTEXE_CHECK, &CParam7Dialog::OnBnClickedUseAnnsfmtextexeCheck)
END_MESSAGE_MAP()


// CParam7Dialog bZ[W nh

HBRUSH CParam7Dialog::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO:   DC ̑ύXĂB

	// TODO:  lgpȂꍇ͕ʂ̃uVԂ܂B
	if (nCtlColor == CTLCOLOR_STATIC) {
        if (*pWnd == m_ctrlColorSample)
        {
            // F
//            pDC->SetTextColor(m_color);
            // wiF
//            hbr = static_cast<HBRUSH>(GetStockObject(BLACK_BRUSH));
//            pDC->SetBkColor(RGB(0, 0, 0));
			return ::CreateSolidBrush(RGB(m_nCREdit, m_nCGEdit, m_nCBEdit));
		}
	}	

	return hbr;
}

void CParam7Dialog::SetColorSample()
{

	int n = m_ctrlColorListBox.GetCurSel();

	m_crefColor[n] = RGB(m_nCREdit, m_nCGEdit, m_nCBEdit);

	Invalidate();

}



BOOL CParam7Dialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	m_ctrlColorListBox.AddString(_T("KCh\"));
	m_ctrlColorListBox.AddString(_T("KChf[^"));
	m_ctrlColorListBox.AddString(_T("eLXg"));
	m_ctrlColorListBox.AddString(_T("^[}[N"));
	m_ctrlColorListBox.AddString(_T("wi"));

	m_ctrlColorListBox.SetCurSel(0);

	OnLbnSelchangeColorList();

	for ( int i = 1; i < 10; i++ ) {
		CString s;
		s.Format(_T("%d"), i);

		m_ctrlScrollNum.AddString(s);
		m_ctrlLineSpaceCombo.AddString(s);

	}

	m_ctrlBackColor.AddString(_T("annsViewwiF"));
	m_ctrlBackColor.AddString(_T("O["));
	m_ctrlBackColor.AddString(_T(""));
	m_ctrlBackColor.AddString(_T(""));


	m_ctrlScrollNum.SetCurSel(m_nScrollNum - 1);

	m_ctrlLineSpaceCombo.SetCurSel(m_nLineSpaceCombo - 1);

	m_ctrlAdjustSizeCheck.SetCheck(m_bAdjustSizeCheck);
	m_ctrlAutoOrientationCheck.SetCheck(m_bAutoOrientationCheck);
	m_ctrlUseannsFMtextExeCheck.SetCheck(m_bUseannsFMtextExeCheck);

	m_ctrlBackColor.SetCurSel(m_nBackColor);

	m_ctrlFontName.SetWindowTextW(m_sFontName);

	CClientDC dc(AfxGetMainWnd());
	CString s;
	int nPointSize = -::MulDiv(m_LogFont.lfHeight, 72, dc.GetDeviceCaps(LOGPIXELSY));
	s.Format(_T("%d"), nPointSize);
	m_ctrlFontSize.SetWindowTextW(s);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CParam7Dialog::OnEnChangeCrEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	CString s;
	m_ctrlCREdit.GetWindowTextW(s);

	m_nCREdit = _wtoi(s);
	SetColorSample();

}

void CParam7Dialog::OnEnChangeCgEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	CString s;
	m_ctrlCGEdit.GetWindowTextW(s);

	m_nCGEdit = _wtoi(s);
	SetColorSample();

}

void CParam7Dialog::OnEnChangeCbEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	CString s;
	m_ctrlCBEdit.GetWindowTextW(s);

	m_nCBEdit = _wtoi(s);
	SetColorSample();

}

void CParam7Dialog::OnCbnSelchangeScrollnumCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_nScrollNum = m_ctrlScrollNum.GetCurSel() + 1;
}

void CParam7Dialog::OnLbnSelchangeColorList()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int n = m_ctrlColorListBox.GetCurSel();

	m_nCREdit = m_crefColor[n] & 0xff;
	m_nCGEdit = (m_crefColor[n] & 0xff00) / 0x100;
	m_nCBEdit = (m_crefColor[n] & 0xff0000) / 0x10000;

	CString s;

	s.Format(_T("%d"), m_nCREdit);
	m_ctrlCREdit.SetWindowTextW(s);

	s.Format(_T("%d"), m_nCGEdit);
	m_ctrlCGEdit.SetWindowTextW(s);

	s.Format(_T("%d"), m_nCBEdit);
	m_ctrlCBEdit.SetWindowTextW(s);

	Invalidate();

}

void CParam7Dialog::OnCbnSelchangeLinespaceCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_nLineSpaceCombo = m_ctrlLineSpaceCombo.GetCurSel() + 1;
}


void CParam7Dialog::OnBnClickedAdjustSizeCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	int n = m_ctrlAdjustSizeCheck.GetCheck();
	m_bAdjustSizeCheck = (n == 1) ? true : false;

}


void CParam7Dialog::OnCbnSelchangeBackcolorCombo()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	m_nBackColor = m_ctrlBackColor.GetCurSel();

}


void CParam7Dialog::OnBnClickedAutoOrientationCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	int n = m_ctrlAutoOrientationCheck.GetCheck();
	m_bAutoOrientationCheck = (n == 1) ? true : false;
}


void CParam7Dialog::OnBnClickedSelectfontButton()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	CMyFontDialog dlg;

	dlg.m_cf.lpLogFont = &m_LogFont;

	dlg.m_cf.Flags = CF_FIXEDPITCHONLY | CF_INITTOLOGFONTSTRUCT | CF_NOVERTFONTS | CF_SCREENFONTS | CF_ENABLEHOOK
		| CF_NOOEMFONTS | CF_ANSIONLY | CF_FORCEFONTEXIST | CF_NOSIMULATIONS | CF_SELECTSCRIPT;

	if (dlg.DoModal() == IDOK)
	{
		CClientDC dc(AfxGetMainWnd());

		CString strFontFamilyName = dlg.GetFontFamilyName(); //_CAOtHgt@~擾

		LOGFONT logFont;
		dlg.GetCurrentFont(&logFont);

		lstrcpy(logFont.lfFaceName, strFontFamilyName);

		m_LogFont = logFont;

		m_sFontName.Format(_T("%s"), logFont.lfFaceName);


		m_ctrlFontName.SetWindowTextW(m_sFontName);

		m_nFontSize = logFont.lfHeight;
		int nPoint = -::MulDiv(logFont.lfHeight, 72, dc.GetDeviceCaps(LOGPIXELSY));
		CString s;
		s.Format(_T("%d"), nPoint);
		m_ctrlFontSize.SetWindowTextW(s);

	}

}


void CParam7Dialog::OnBnClickedUseAnnsfmtextexeCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	int n = m_ctrlUseannsFMtextExeCheck.GetCheck();
	m_bUseannsFMtextExeCheck = (n == 1) ? true : false;

}
