// Param5Dialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "Param5Dialog.h"


// CParam5Dialog _CAO

IMPLEMENT_DYNAMIC(CParam5Dialog, CDialog)

CParam5Dialog::CParam5Dialog(CWnd* pParent /*=NULL*/)
	: CDialog(CParam5Dialog::IDD, pParent)
	, m_nCREdit(0)
	, m_nCGEdit(0)
	, m_nCBEdit(0)
	, m_bCyclicalCursorCheck(false)
	, m_bCursorMovepageCheck(false)
	, m_bMarkAstCheck(false)
{

}

CParam5Dialog::~CParam5Dialog()
{
}

void CParam5Dialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COLOR_LIST, m_ctrlColorListBox);
	DDX_Control(pDX, IDC_CR_EDIT, m_ctrlCREdit);
	DDX_Control(pDX, IDC_CG_EDIT, m_ctrlCGEdit);
	DDX_Control(pDX, IDC_CB_EDIT, m_ctrlCBEdit);
	DDX_Control(pDX, IDC_COLOR_SAMPLE, m_ctrlColorSample);
	DDX_Control(pDX, IDC_CYCLICAL_CURSOR_CHECK, m_ctrlCyclicalCursorCheck);
	DDX_Control(pDX, IDC_CURSOR_MOVEPAGE_CHECK, m_ctrlCursorMovepageCheck);
	DDX_Control(pDX, IDC_MARK_AST_CHECK, m_ctrlMarkAstCheck);
}


BEGIN_MESSAGE_MAP(CParam5Dialog, CDialog)
	ON_LBN_SELCHANGE(IDC_COLOR_LIST, &CParam5Dialog::OnLbnSelchangeColorList)
	ON_EN_CHANGE(IDC_CR_EDIT, &CParam5Dialog::OnEnChangeCrEdit)
	ON_EN_CHANGE(IDC_CG_EDIT, &CParam5Dialog::OnEnChangeCgEdit)
	ON_EN_CHANGE(IDC_CB_EDIT, &CParam5Dialog::OnEnChangeCbEdit)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_CYCLICAL_CURSOR_CHECK, &CParam5Dialog::OnBnClickedCyclicalCursorCheck)
	ON_BN_CLICKED(IDC_CURSOR_MOVEPAGE_CHECK, &CParam5Dialog::OnBnClickedCursorMovepageCheck)
	ON_BN_CLICKED(IDC_MARK_AST_CHECK, &CParam5Dialog::OnBnClickedMarkAstCheck)
END_MESSAGE_MAP()


// CParam5Dialog bZ[W nh

void CParam5Dialog::OnLbnSelchangeColorList()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int n = m_ctrlColorListBox.GetCurSel();

	m_nCREdit = m_crefColor[n] & 0xff;
	m_nCGEdit = (m_crefColor[n] & 0xff00) / 0x100;
	m_nCBEdit = (m_crefColor[n] & 0xff0000) / 0x10000;

	CString s;

	s.Format(_T("%d"), m_nCREdit);
	m_ctrlCREdit.SetWindowTextW(s);

	s.Format(_T("%d"), m_nCGEdit);
	m_ctrlCGEdit.SetWindowTextW(s);

	s.Format(_T("%d"), m_nCBEdit);
	m_ctrlCBEdit.SetWindowTextW(s);

	Invalidate();
}

void CParam5Dialog::OnEnChangeCrEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	CString s;
	m_ctrlCREdit.GetWindowTextW(s);

	m_nCREdit = _wtoi(s);
	if ( m_nCREdit > 255 ) {
		m_nCREdit = 255;
		s.Format(_T("%d"), m_nCREdit);
		m_ctrlCREdit.SetWindowTextW(s);
	}
	if ( m_nCREdit < 0 ) {
		m_nCREdit = 0;
		s.Format(_T("%d"), m_nCREdit);
		m_ctrlCREdit.SetWindowTextW(s);
	}
	SetColorSample();

}

void CParam5Dialog::OnEnChangeCgEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	CString s;
	m_ctrlCGEdit.GetWindowTextW(s);

	m_nCGEdit = _wtoi(s);
	if ( m_nCGEdit > 255 ) {
		m_nCGEdit = 255;
		s.Format(_T("%d"), m_nCGEdit);
		m_ctrlCGEdit.SetWindowTextW(s);
	}
	if ( m_nCGEdit < 0 ) {
		m_nCGEdit = 0;
		s.Format(_T("%d"), m_nCGEdit);
		m_ctrlCGEdit.SetWindowTextW(s);
	}

	SetColorSample();

}

void CParam5Dialog::OnEnChangeCbEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	CString s;
	m_ctrlCBEdit.GetWindowTextW(s);

	m_nCBEdit = _wtoi(s);
	if ( m_nCBEdit > 255 ) {
		m_nCBEdit = 255;
		s.Format(_T("%d"), m_nCBEdit);
		m_ctrlCBEdit.SetWindowTextW(s);
	}
	if ( m_nCBEdit < 0 ) {
		m_nCBEdit = 0;
		s.Format(_T("%d"), m_nCBEdit);
		m_ctrlCBEdit.SetWindowTextW(s);
	}

	SetColorSample();

}

void CParam5Dialog::SetColorSample()
{

	int n = m_ctrlColorListBox.GetCurSel();

	m_crefColor[n] = RGB(m_nCREdit, m_nCGEdit, m_nCBEdit);

	Invalidate();

}

BOOL CParam5Dialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	m_ctrlColorListBox.AddString(_T("tH_"));
	m_ctrlColorListBox.AddString(_T("ʏt@C"));
	m_ctrlColorListBox.AddString(_T("[hI[t@C"));
	m_ctrlColorListBox.AddString(_T("Bt@C"));
	m_ctrlColorListBox.AddString(_T("VXet@C"));

	m_ctrlColorListBox.SetCurSel(0);

	OnLbnSelchangeColorList();

	m_ctrlCyclicalCursorCheck.SetCheck(m_bCyclicalCursorCheck);
	m_ctrlCursorMovepageCheck.SetCheck(m_bCursorMovepageCheck);
	m_ctrlMarkAstCheck.SetCheck(m_bMarkAstCheck);



	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

HBRUSH CParam5Dialog::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO:   DC ̑ύXĂB

	// TODO:  lgpȂꍇ͕ʂ̃uVԂ܂B

	if (nCtlColor == CTLCOLOR_STATIC) {
        if (*pWnd == m_ctrlColorSample)
        {
            // F
//            pDC->SetTextColor(m_color);
            // wiF
//            hbr = static_cast<HBRUSH>(GetStockObject(BLACK_BRUSH));
//            pDC->SetBkColor(RGB(0, 0, 0));
			return ::CreateSolidBrush(RGB(m_nCREdit, m_nCGEdit, m_nCBEdit));
		}
	}	
		
	return hbr;
}



void CParam5Dialog::OnBnClickedCyclicalCursorCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	if (m_bCyclicalCursorCheck) {
		m_bCyclicalCursorCheck = false;

	}
	else {
		m_bCyclicalCursorCheck = true;

	}

}


void CParam5Dialog::OnBnClickedCursorMovepageCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	if (m_bCursorMovepageCheck) {
		m_bCursorMovepageCheck = false;

	}
	else {
		m_bCursorMovepageCheck = true;

	}
}


void CParam5Dialog::OnBnClickedMarkAstCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	if (m_bMarkAstCheck) {
		m_bMarkAstCheck = false;

	}
	else {
		m_bMarkAstCheck = true;

	}

}
