// Param2Dialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "Param2Dialog.h"
#include "FmParam.h"


// CParam2Dialog _CAO

IMPLEMENT_DYNAMIC(CParam2Dialog, CDialog)

CParam2Dialog::CParam2Dialog(CWnd* pParent /*=NULL*/)
	: CDialog(CParam2Dialog::IDD, pParent)
	, m_sBootFolderEdit(_T(""))
	, m_nDisplayModeCombo(0)
	, m_bDisplayHideFileCheck(false)
	, m_bDisplaySystemFileCheck(false)
	, m_nSortModeCombo(false)
	, m_bReadKeyMapCheck(false)
	, m_bBootLastPathCheck(false)
	, m_bSortExplorerCheck(false)
	, m_bSortOrderCombo(false)
{

}

CParam2Dialog::~CParam2Dialog()
{
}

void CParam2Dialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BOOTFOLDER_EDIT, m_ctrlBootFolderEdit);
	DDX_Control(pDX, IDC_DISPLAYMODE_COMBO, m_ctrlDisplayModeCombo);
	DDX_Control(pDX, IDC_DISPLAYHIDEFILE_CHECK, m_ctrlDisplayHideFileCheck);
	DDX_Control(pDX, IDC_DISPLAYSYSTEMFILE_CHECK, m_ctrlDisplaySystemFileCheck);
	DDX_Control(pDX, IDC_SORTMODE_COMBO, m_ctrlSortModeCombo);
	DDX_Control(pDX, IDC_READKEYMAP_CHECK, m_ctrlReadKeyMapCheck);
	DDX_Control(pDX, IDC_BOOTLASTPATH_CHECK, m_ctrlBootLastPathCheck);
	DDX_Control(pDX, IDC_SORT_EXPLORER_CHECK, m_ctrlSortExplorerCheck);
	DDX_Control(pDX, IDC_SORTORDER_COMBO, m_ctrlSortOrderCombo);
}


BEGIN_MESSAGE_MAP(CParam2Dialog, CDialog)
	ON_CBN_SELCHANGE(IDC_DISPLAYMODE_COMBO, &CParam2Dialog::OnCbnSelchangeDisplaymodeCombo)
	ON_BN_CLICKED(IDC_DISPLAYSYSTEMFILE_CHECK, &CParam2Dialog::OnBnClickedDisplaysystemfileCheck)
	ON_CBN_SELCHANGE(IDC_SORTMODE_COMBO, &CParam2Dialog::OnCbnSelchangeSortmodeCombo)
	ON_BN_CLICKED(IDC_READKEYMAP_CHECK, &CParam2Dialog::OnBnClickedReadkeymapCheck)
	ON_BN_CLICKED(IDC_BOOTLASTPATH_CHECK, &CParam2Dialog::OnBnClickedBootlastpathCheck)
	ON_BN_CLICKED(IDC_BROWSE_BUTTON, &CParam2Dialog::OnBnClickedBrowseButton)
	ON_BN_CLICKED(IDC_DISPLAYHIDEFILE_CHECK, &CParam2Dialog::OnBnClickedDisplayhidefileCheck)
	ON_EN_CHANGE(IDC_BOOTFOLDER_EDIT, &CParam2Dialog::OnEnChangeBootfolderEdit)
	ON_BN_CLICKED(IDC_SORT_EXPLORER_CHECK, &CParam2Dialog::OnBnClickedSortExplorerCheck)
	ON_CBN_SELCHANGE(IDC_SORTORDER_COMBO, &CParam2Dialog::OnCbnSelchangeSortorderCombo)
END_MESSAGE_MAP()


// CParam2Dialog bZ[W nh

BOOL CParam2Dialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ


	CString s;
	for ( int i = 0; i < 5; i++ ) {
		s.Format(_T("%d"), i + 1);
		m_ctrlDisplayModeCombo.AddString(s);
	}
	m_ctrlDisplayModeCombo.SetCurSel(m_nDisplayModeCombo);

	m_ctrlSortModeCombo.AddString(_T("\[gȂ"));
	m_ctrlSortModeCombo.AddString(_T("t@C"));
	m_ctrlSortModeCombo.AddString(_T("gq"));
	m_ctrlSortModeCombo.AddString(_T("t"));
	m_ctrlSortModeCombo.AddString(_T("TCY"));

	m_ctrlSortModeCombo.SetCurSel(m_nSortModeCombo);

	m_ctrlSortOrderCombo.AddString(_T(""));
	m_ctrlSortOrderCombo.AddString(_T("~"));

	m_ctrlSortOrderCombo.SetCurSel(m_bSortOrderCombo);

	m_ctrlDisplayHideFileCheck.SetCheck(m_bDisplayHideFileCheck);
	m_ctrlDisplaySystemFileCheck.SetCheck(m_bDisplaySystemFileCheck);
	m_ctrlReadKeyMapCheck.SetCheck(m_bReadKeyMapCheck);
	m_ctrlBootLastPathCheck.SetCheck(m_bBootLastPathCheck);
	m_ctrlSortExplorerCheck.SetCheck(m_bSortExplorerCheck);

	m_ctrlBootFolderEdit.SetWindowTextW(m_sBootFolderEdit);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CParam2Dialog::OnCbnSelchangeDisplaymodeCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_nDisplayModeCombo = m_ctrlDisplayModeCombo.GetCurSel();
}

void CParam2Dialog::OnBnClickedDisplaysystemfileCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	int n = m_ctrlDisplaySystemFileCheck.GetCheck();
	m_bDisplaySystemFileCheck = ( n == 1) ? true : false;
}

void CParam2Dialog::OnCbnSelchangeSortmodeCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_nSortModeCombo = m_ctrlSortModeCombo.GetCurSel();
}

void CParam2Dialog::OnBnClickedReadkeymapCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int n = m_ctrlReadKeyMapCheck.GetCheck();
	m_bReadKeyMapCheck = ( n == 1) ? true : false;
}

void CParam2Dialog::OnBnClickedBootlastpathCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int n = m_ctrlBootLastPathCheck.GetCheck();
	m_bBootLastPathCheck = ( n == 1) ? true : false;
}

void CParam2Dialog::OnBnClickedBrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString cpath = m_sBootFolderEdit;
	cpath = cpath.Left(cpath.GetLength() - 1);

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_sBootFolderEdit = chPutFolder;
			if ( m_sBootFolderEdit.GetAt(m_sBootFolderEdit.GetLength() - 1) != '\\' )
				m_sBootFolderEdit += STR_YEN;
			m_ctrlBootFolderEdit.SetWindowTextW(m_sBootFolderEdit);
//			m_pDestPathCombo.SetWindowTextW(chPutFolder);
			m_ctrlBootFolderEdit.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}
}

int CALLBACK CParam2Dialog::BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
		::SendMessage(hwnd,BFFM_SETSELECTION,(WPARAM)TRUE,lpData);
    }
    return 0;
}

void CParam2Dialog::OnBnClickedDisplayhidefileCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int n = m_ctrlDisplayHideFileCheck.GetCheck();
	m_bDisplayHideFileCheck = ( n == 1) ? true : false;
}

void CParam2Dialog::OnEnChangeBootfolderEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	m_ctrlBootFolderEdit.GetWindowTextW(m_sBootFolderEdit);
}

void CParam2Dialog::OnBnClickedSortExplorerCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int n = m_ctrlSortExplorerCheck.GetCheck();
	m_bSortExplorerCheck = ( n == 1) ? true : false;
}


void CParam2Dialog::OnCbnSelchangeSortorderCombo()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
	int n = m_ctrlSortOrderCombo.GetCurSel();
	m_bSortOrderCombo = ( n == 1) ? true : false;
}


BOOL CParam2Dialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB


	int i = 0;

	if (WM_KEYDOWN == pMsg->message)
	{
		switch (pMsg->wParam)
		{
		case VK_ESCAPE:
			i = 1;
			break;

		default:
			i = 0;
		}
	}

	if (i == 1) return FALSE;
	return CDialog::PreTranslateMessage(pMsg);
}
