// Param1Dialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "Param1Dialog.h"
#include "MyFontDialog.h"


// CParam1Dialog _CAO

IMPLEMENT_DYNAMIC(CParam1Dialog, CDialog)

CParam1Dialog::CParam1Dialog(CWnd* pParent /*=NULL*/)
	: CDialog(CParam1Dialog::IDD, pParent)
	, m_nCREdit(0)
	, m_nCGEdit(0)
	, m_nCBEdit(0)
	, m_nLineSpace(0)
	, m_nUpdateTime(false)
{

	for ( int i = 0; i < 10; i++ ) {
		m_crefColor[i] = 0;
	}

}

CParam1Dialog::~CParam1Dialog()
{
}

void CParam1Dialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COLOR_LIST, m_ctrlColorListBox);
	DDX_Control(pDX, IDC_CR_EDIT, m_ctrlCREdit);
	DDX_Control(pDX, IDC_CG_EDIT, m_ctrlCGEdit);
	DDX_Control(pDX, IDC_CB_EDIT, m_ctrlCBEdit);
	DDX_Control(pDX, IDC_COLOR_SAMPLE, m_ctrlColorSample);
	DDX_Control(pDX, IDC_FONTNAME, m_ctrlFontName);
	DDX_Control(pDX, IDC_FONTSIZE, m_ctrlFontSize);
	DDX_Control(pDX, IDC_LINESPACE_COMBO, m_ctrlLineSpaceCombo);
	DDX_Control(pDX, IDC_UPDATETIME_COMBO, m_ctrlUpdateTimeCombo);
}


BEGIN_MESSAGE_MAP(CParam1Dialog, CDialog)
	ON_LBN_SELCHANGE(IDC_COLOR_LIST, &CParam1Dialog::OnLbnSelchangeColorList)
	ON_EN_CHANGE(IDC_CR_EDIT, &CParam1Dialog::OnEnChangeCrEdit)
	ON_EN_CHANGE(IDC_CG_EDIT, &CParam1Dialog::OnEnChangeCgEdit)
	ON_EN_CHANGE(IDC_CB_EDIT, &CParam1Dialog::OnEnChangeCbEdit)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_SELECTFONT_BUTTON, &CParam1Dialog::OnBnClickedSelectfontButton)
	ON_CBN_SELCHANGE(IDC_LINESPACE_COMBO, &CParam1Dialog::OnCbnSelchangeLinespaceCombo)
	ON_CBN_SELCHANGE(IDC_UPDATETIME_COMBO, &CParam1Dialog::OnCbnSelchangeUpdatetimeCombo)
END_MESSAGE_MAP()


// CParam1Dialog bZ[W nh

BOOL CParam1Dialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	m_ctrlColorListBox.AddString(_T("wi"));
	m_ctrlColorListBox.AddString(_T("t["));
	m_ctrlColorListBox.AddString(_T("CtH[V"));
	m_ctrlColorListBox.AddString(_T("CtH[Vf[^"));
	m_ctrlColorListBox.AddString(_T("CtH[V"));
	m_ctrlColorListBox.AddString(_T("CtH[V{[x"));

	m_ctrlColorListBox.SetCurSel(0);

	OnLbnSelchangeColorList();

	m_ctrlFontName.SetWindowTextW(m_sFontName);

	CClientDC dc(AfxGetMainWnd());
	CString s;
	int nPointSize = -::MulDiv(m_LogFont.lfHeight, 72, dc.GetDeviceCaps(LOGPIXELSY));
	s.Format(_T("%d"), nPointSize);
	m_ctrlFontSize.SetWindowTextW(s);

	m_ctrlLineSpaceCombo.AddString(_T("0"));
	m_ctrlUpdateTimeCombo.AddString(_T("ĎȂ"));

	for ( int i = 1; i < 11; i++ ) {
		s.Format(_T("%d"), i);
		m_ctrlLineSpaceCombo.AddString(s);
		m_ctrlUpdateTimeCombo.AddString(s);
	}

	m_ctrlLineSpaceCombo.SetCurSel(m_nLineSpace);
	m_ctrlUpdateTimeCombo.SetCurSel(m_nUpdateTime);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CParam1Dialog::OnLbnSelchangeColorList()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	int n = m_ctrlColorListBox.GetCurSel();

	m_nCREdit = m_crefColor[n] & 0xff;
	m_nCGEdit = (m_crefColor[n] & 0xff00) / 0x100;
	m_nCBEdit = (m_crefColor[n] & 0xff0000) / 0x10000;

	CString s;

	s.Format(_T("%d"), m_nCREdit);
	m_ctrlCREdit.SetWindowTextW(s);

	s.Format(_T("%d"), m_nCGEdit);
	m_ctrlCGEdit.SetWindowTextW(s);

	s.Format(_T("%d"), m_nCBEdit);
	m_ctrlCBEdit.SetWindowTextW(s);

	Invalidate();

}

void CParam1Dialog::OnEnChangeCrEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB

	CString s;
	m_ctrlCREdit.GetWindowTextW(s);

	m_nCREdit = _wtoi(s);
	if ( m_nCREdit > 255 ) {
		m_nCREdit = 255;
		s.Format(_T("%d"), m_nCREdit);
		m_ctrlCREdit.SetWindowTextW(s);
	}
	if ( m_nCREdit < 0 ) {
		m_nCREdit = 0;
		s.Format(_T("%d"), m_nCREdit);
		m_ctrlCREdit.SetWindowTextW(s);
	}

	SetColorSample();
}

void CParam1Dialog::OnEnChangeCgEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB
	CString s;
	m_ctrlCGEdit.GetWindowTextW(s);

	m_nCGEdit = _wtoi(s);
	if ( m_nCGEdit > 255 ) {
		m_nCGEdit = 255;
		s.Format(_T("%d"), m_nCGEdit);
		m_ctrlCGEdit.SetWindowTextW(s);
	}
	if ( m_nCGEdit < 0 ) {
		m_nCGEdit = 0;
		s.Format(_T("%d"), m_nCGEdit);
		m_ctrlCGEdit.SetWindowTextW(s);
	}

	SetColorSample();
}

void CParam1Dialog::OnEnChangeCbEdit()
{
	// TODO:  ꂪ RICHEDIT Rg[̏ꍇÃRg[
	// ̒ʒm𑗐Mɂ́ACDialog::OnInitDialog() ֐I[o[ChA
	// CRichEditCtrl().SetEventMask() 
	// OR Ԃ ENM_CHANGE tO}XNɓČĂяoKv܂B

	// TODO:  ɃRg[ʒmnh R[hǉĂB
	CString s;
	m_ctrlCBEdit.GetWindowTextW(s);

	m_nCBEdit = _wtoi(s);
	if ( m_nCBEdit > 255 ) {
		m_nCBEdit = 255;
		s.Format(_T("%d"), m_nCBEdit);
		m_ctrlCBEdit.SetWindowTextW(s);
	}
	if ( m_nCBEdit < 0 ) {
		m_nCBEdit = 0;
		s.Format(_T("%d"), m_nCBEdit);
		m_ctrlCBEdit.SetWindowTextW(s);
	}

	SetColorSample();
}

void CParam1Dialog::SetColorSample()
{

	int n = m_ctrlColorListBox.GetCurSel();

	m_crefColor[n] = RGB(m_nCREdit, m_nCGEdit, m_nCBEdit);

	Invalidate();

}

HBRUSH CParam1Dialog::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO:   DC ̑ύXĂB

	// TODO:  lgpȂꍇ͕ʂ̃uVԂ܂B

	if (nCtlColor == CTLCOLOR_STATIC) {
        if (*pWnd == m_ctrlColorSample)
        {
            // F
//            pDC->SetTextColor(m_color);
            // wiF
//            hbr = static_cast<HBRUSH>(GetStockObject(BLACK_BRUSH));
//            pDC->SetBkColor(RGB(0, 0, 0));
			return ::CreateSolidBrush(RGB(m_nCREdit, m_nCGEdit, m_nCBEdit));
		}
	}	
		
	return hbr;
}

/*
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_SCREENFONTS;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_PRINTERFONTS;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_BOTH;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_SHOWHELP;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_ENABLEHOOK;

dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_ENABLETEMPLATE;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_ENABLETEMPLATEHANDLE;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_INITTOLOGFONTSTRUCT;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_USESTYLE;

dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_EFFECTS;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_APPLY;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_ANSIONLY;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_NOOEMFONTS;

dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_NOSIMULATIONS;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_LIMITSIZE;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_FIXEDPITCHONLY;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_WYSIWYG;

dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_FORCEFONTEXIST;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_SCALABLEONLY;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_TTONLY;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_NOFACESEL;

dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_NOSTYLESEL;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_NOSIZESEL;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_SELECTSCRIPT;
dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_NOSCRIPTSEL;

dlg.m_cf.Flags = 0;
dlg.m_cf.Flags |= CF_NOVERTFONTS;
*/




//	dlg.m_cf.Flags &= ~CF_EFFECTS;

void CParam1Dialog::OnBnClickedSelectfontButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	CMyFontDialog dlg;

	dlg.m_cf.lpLogFont = &m_LogFont;

	dlg.m_cf.Flags = CF_FIXEDPITCHONLY | CF_INITTOLOGFONTSTRUCT | CF_NOVERTFONTS | CF_SCREENFONTS | CF_ENABLEHOOK
		| CF_NOOEMFONTS | CF_ANSIONLY | CF_FORCEFONTEXIST | CF_NOSIMULATIONS | CF_SELECTSCRIPT;

	if (dlg.DoModal() == IDOK)
	{
		CClientDC dc(AfxGetMainWnd());

		CString strFontFamilyName = dlg.GetFontFamilyName(); //_CAOtHgt@~擾

		LOGFONT logFont;
		dlg.GetCurrentFont(&logFont);

		lstrcpy(logFont.lfFaceName, strFontFamilyName);

		m_LogFont = logFont;

		m_sFontName.Format(_T("%s"), logFont.lfFaceName);


		m_ctrlFontName.SetWindowTextW(m_sFontName);

		m_nFontSize = logFont.lfHeight;
		int nPoint = -::MulDiv(logFont.lfHeight, 72, dc.GetDeviceCaps(LOGPIXELSY));
		CString s;
		s.Format(_T("%d"), nPoint);
		m_ctrlFontSize.SetWindowTextW(s);

	}


}

void CParam1Dialog::OnCbnSelchangeLinespaceCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_nLineSpace = m_ctrlLineSpaceCombo.GetCurSel();
}

void CParam1Dialog::OnCbnSelchangeUpdatetimeCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_nUpdateTime = m_ctrlUpdateTimeCombo.GetCurSel();
}
