// PackDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "PackDialog.h"
#include "FmParam.h"
#include "SelectJumpFolderDialog.h"
#include "TreeFrameWindow.h"
#include "JumpFrame.h"


// CPackDialog _CAO

IMPLEMENT_DYNAMIC(CPackDialog, CDialog)

CPackDialog::CPackDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CPackDialog::IDD, pParent)
	, m_sFileName(_T(""))
	, m_sPath(_T(""))
	, m_bWithPath(true)
	, m_sSFile(_T(""))
	, m_iArcType(1)
	, m_bWithPass(false)
	, m_bNameOnlyCheck(false)
	, m_nRate(6)
	, m_bObjectCheck(false)
	, m_bSetExtCheck(true)
{
	m_nRate7 = 5;
}

CPackDialog::~CPackDialog()
{
//	CoUninitialize();
}

void CPackDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ARC_COMBO, m_ctrlArcCombo);
	DDX_Control(pDX, IDC_CHECK_WITHPATH, m_ctrlWithPath);
	//	DDX_Check(pDX, IDC_CHECK_WITHPATH, (int&)m_bWithPath);
	DDX_Control(pDX, IDC_FILENAME_COMBO, m_ctrlFileName);
	DDX_Text(pDX, IDC_FILENAME_COMBO, m_sFileName);
	DDX_Text(pDX, IDC_SFILE, m_sSFile);
	DDX_Text(pDX, IDC_PATH, m_sPath);
	DDX_Control(pDX, IDC_PATH, m_ctrlPath);
	DDX_Control(pDX, IDC_CHECK_WITHPASS, m_ctrlWithPass);
	DDX_Control(pDX, IDC_NAMEONLY_CHECK, m_ctrlNameOnlyCheck);
	DDX_Control(pDX, IDC_RATE_COMBO, m_ctrlRateCombo);
	DDX_Control(pDX, IDC_OBJECT_CHECK, m_ctrlObjectCheck);
	DDX_Control(pDX, IDC_SETEXT_CHECK, m_ctrlSetExtCheck);
	
}


BEGIN_MESSAGE_MAP(CPackDialog, CDialog)
	ON_CBN_SELCHANGE(IDC_ARC_COMBO, &CPackDialog::OnCbnSelchangeArcCombo)
	ON_BN_CLICKED(IDOK, &CPackDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BROUSE_BUTTON, &CPackDialog::OnBnClickedBrowseButton)
	ON_BN_CLICKED(IDC_JUMPFOLDER_BUTTON, &CPackDialog::OnBnClickedJumpfolderButton)

	ON_COMMAND(ID_TREE_MESSAGE, &CPackDialog::OnTreeMessage)
	ON_COMMAND(ID_JUMP_MESSAGE, &CPackDialog::OnJumpMessage)
	ON_BN_CLICKED(IDC_BROWSE_WIN, &CPackDialog::OnBnClickedBrowseWin)
	ON_CBN_SELCHANGE(IDC_FILENAME_COMBO, &CPackDialog::OnCbnSelchangeFilenameCombo)
	ON_CBN_SELCHANGE(IDC_PATH, &CPackDialog::OnCbnSelchangePath)
	ON_BN_CLICKED(IDC_NAMEONLY_CHECK, &CPackDialog::OnBnClickedNameonlyCheck)
	ON_CBN_SELCHANGE(IDC_RATE_COMBO, &CPackDialog::OnCbnSelchangeRateCombo)
	ON_BN_CLICKED(IDC_OBJECT_CHECK, &CPackDialog::OnBnClickedObjectCheck)
	ON_BN_CLICKED(IDC_SETEXT_CHECK, &CPackDialog::OnBnClickedSetextCheck)
END_MESSAGE_MAP()


// CPackDialog bZ[W nh

BOOL CPackDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	m_ctrlArcCombo.AddString(_T("LHA(.LZH)"));
	m_ctrlArcCombo.AddString(_T("ZIP(.ZIP)"));
	m_ctrlArcCombo.AddString(_T("CAB(.CAB)"));
	m_ctrlArcCombo.AddString(_T("7z(.7z)"));

	m_ctrlArcCombo.SetCurSel(m_iArcType);
	m_ctrlRateCombo.SetCurSel(0);


	switch (m_iArcType) {
		case 0 :
			m_ctrlWithPath.EnableWindow(TRUE);
			m_ctrlWithPass.EnableWindow(FALSE);
			m_ctrlRateCombo.EnableWindow(FALSE);
			break;
		case 1 :
			m_ctrlWithPath.EnableWindow(TRUE);
			m_ctrlWithPass.EnableWindow(TRUE);
			m_ctrlRateCombo.EnableWindow(TRUE);

			m_ctrlRateCombo.AddString(_T("0:k"));
			m_ctrlRateCombo.AddString(_T("1:ሳk"));
			m_ctrlRateCombo.AddString(_T("2"));
			m_ctrlRateCombo.AddString(_T("3"));
			m_ctrlRateCombo.AddString(_T("4"));
			m_ctrlRateCombo.AddString(_T("5"));
			m_ctrlRateCombo.AddString(_T("6:ftHg"));
			m_ctrlRateCombo.AddString(_T("7"));
			m_ctrlRateCombo.AddString(_T("8"));
			m_ctrlRateCombo.AddString(_T("9:k"));
			m_ctrlRateCombo.SetCurSel(m_nRate);
			break;
		case 2 :
			m_ctrlWithPath.EnableWindow(FALSE);
			m_ctrlWithPass.EnableWindow(FALSE);
			m_ctrlRateCombo.EnableWindow(FALSE);
			break;
		case 3 :
			m_ctrlWithPath.EnableWindow(FALSE);
			m_ctrlWithPass.EnableWindow(TRUE);
			m_ctrlRateCombo.EnableWindow(TRUE);

			m_ctrlRateCombo.AddString(_T("0:k"));
			m_ctrlRateCombo.AddString(_T("1:ሳk"));
			m_ctrlRateCombo.AddString(_T("3"));
			m_ctrlRateCombo.AddString(_T("5"));
			m_ctrlRateCombo.AddString(_T("7"));
			m_ctrlRateCombo.AddString(_T("9:k"));
			m_ctrlRateCombo.SetCurSel(m_nRate7);
			break;
	}



	m_Ext = _T("");

	m_bWithPath = true;
	m_ctrlWithPath.SetCheck(BST_CHECKED);

	m_ctrlSetExtCheck.SetCheck(BST_CHECKED);
	if (!m_bSetExtCheck) {
		m_ctrlSetExtCheck.SetCheck(BST_UNCHECKED);

	}


	CString fext;
	fext = _T(".hif");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlFileName);

	fext = _T(".hid");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlPath, true);

	m_ctrlPath.SetWindowTextW(m_sPath);
	UpdateData(FALSE);

//	CoInitialize(NULL);
	CEdit *pEdit = (CEdit *)m_ctrlPath.GetWindow(GW_CHILD);
//	CEdit *pEdit2 = (CEdit *)m_ctrlFileName.GetWindow(GW_CHILD);

	if (m_pFmParam->m_bSettingsAutocomplete) {
		::SHAutoComplete(pEdit->m_hWnd, SHACF_FILESYSTEM);
//		::SHAutoComplete(pEdit2->m_hWnd, SHACF_FILESYSTEM);
	}

	m_sOrgFileName = m_sFileName;

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;

	sSection = INISECTION_SETTINGS;
	sEntry = INIENTRY_SETTINGS_PACK_NEMEONLY;

	int b = pApp->GetProfileInt(sSection, sEntry, BST_UNCHECKED);

	m_bNameOnlyCheck = false;
	m_sOname = _T("");
	m_sOext = _T("");

	m_ctrlNameOnlyCheck.SetCheck(b);
	if (b == BST_CHECKED) {
		m_bNameOnlyCheck = true;

		int nf = m_sFileName.ReverseFind(_T('.'));
		int len = m_sFileName.GetLength();
		if (nf > 0) {
			m_sOname = m_sFileName.Left(nf);
			m_sOext = m_sFileName.Right(len - nf);

			m_sFileName = m_sOname;
		}
	}
	UpdateData(FALSE);

	if (m_pFmParam->m_bSettingsSetDialogFont) {
		m_ffont.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_ctrlFileName.SetFont(&m_ffont);
		m_dfont.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_ctrlPath.SetFont(&m_dfont);

	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CPackDialog::OnCbnSelchangeArcCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_iArcType = m_ctrlArcCombo.GetCurSel();

	switch (m_iArcType) {
		case 0 :
			m_ctrlWithPath.EnableWindow(TRUE);
			m_ctrlWithPass.EnableWindow(FALSE);
			m_ctrlRateCombo.EnableWindow(FALSE);
			break;
		case 1 :
			m_ctrlWithPath.EnableWindow(TRUE);
			m_ctrlWithPass.EnableWindow(TRUE);
			m_ctrlRateCombo.EnableWindow(TRUE);

			m_ctrlRateCombo.ResetContent();
			m_ctrlRateCombo.AddString(_T("0:k"));
			m_ctrlRateCombo.AddString(_T("1:ሳk"));
			m_ctrlRateCombo.AddString(_T("2"));
			m_ctrlRateCombo.AddString(_T("3"));
			m_ctrlRateCombo.AddString(_T("4"));
			m_ctrlRateCombo.AddString(_T("5"));
			m_ctrlRateCombo.AddString(_T("6:ftHg"));
			m_ctrlRateCombo.AddString(_T("7"));
			m_ctrlRateCombo.AddString(_T("8"));
			m_ctrlRateCombo.AddString(_T("9:k"));
			m_ctrlRateCombo.SetCurSel(m_nRate);
			break;
		case 2 :
//			m_ctrlWithPath.ShowWindow(SW_HIDE);
			m_ctrlWithPath.EnableWindow(FALSE);
			m_ctrlWithPass.EnableWindow(FALSE);
			m_ctrlRateCombo.EnableWindow(FALSE);
			break;
		case 3 :
//			m_ctrlWithPath.ShowWindow(SW_HIDE);
			m_ctrlWithPath.EnableWindow(FALSE);
			m_ctrlWithPass.EnableWindow(TRUE);
			m_ctrlRateCombo.EnableWindow(TRUE);

			m_ctrlRateCombo.ResetContent();
			m_ctrlRateCombo.AddString(_T("0:k"));
			m_ctrlRateCombo.AddString(_T("1:ሳk"));
			m_ctrlRateCombo.AddString(_T("3"));
			m_ctrlRateCombo.AddString(_T("5"));
			m_ctrlRateCombo.AddString(_T("7"));
			m_ctrlRateCombo.AddString(_T("9:k"));
			m_ctrlRateCombo.SetCurSel(m_nRate7);
			break;
	}
	m_ctrlFileName.SetFocus();

}

void CPackDialog::AddExtention(void)
{
	if (!m_bSetExtCheck) {
		return;
	}


	CString ch, fn;

	m_iArcType = m_ctrlArcCombo.GetCurSel();

	switch (m_iArcType) {
	case 0:
		m_Ext = _T(".lzh");
		break;
	case 1:
		m_Ext = _T(".zip");
		break;
	case 2:
		m_Ext = _T(".cab");
		break;
	case 3:
		m_Ext = _T(".7z");
		break;
	}

	fn = m_sFileName;
	fn += m_Ext;

	m_sFileName = fn;
	UpdateData(FALSE);
}

void CPackDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_ctrlPath.GetWindowTextW(m_sPath);

	if ( m_sPath == _T("") ) {
		OnBnClickedBrowseButton();
		return;
	}

	CString s;
	m_ctrlFileName.GetWindowTextW(s);
	m_sFileName = s;
	AddExtention();
	s = m_sFileName;

	int cn = m_ctrlWithPath.GetCheck();
	m_bWithPath = false;
	if ( cn == BST_CHECKED ) m_bWithPath = true;
	cn = m_ctrlWithPass.GetCheck();
	m_bWithPass = false;
	if ( cn == BST_CHECKED ) m_bWithPass = true;


	CString fext;
	fext = _T(".hif");
	m_pFmParam->WriteHistoryFile(fext, s);

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;

	sSection = INISECTION_SETTINGS;
	sEntry = INIENTRY_SETTINGS_PACK_NEMEONLY;

	int b = m_ctrlNameOnlyCheck.GetCheck();

	pApp->WriteProfileInt(sSection, sEntry, b);

	OnOK();
}

void CPackDialog::OnBnClickedBrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}

	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();


}

void CPackDialog::OnBnClickedJumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_pJumpFrameWindow = new CJumpFrame;
	m_pJumpFrameWindow->m_pFmParam = m_pFmParam;
	m_pJumpFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrameWindow->ShowWindow(SW_SHOW);
	m_pJumpFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pJumpFrameWindow->UpdateWindow();


}

void CPackDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

	SetFocus();
	m_sPath = path;
	m_ctrlPath.SetWindowTextW(path);
	m_ctrlPath.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CPackDialog::OnJumpMessage()
{
	CString path = m_pFmParam->m_sSelectedJumpPath;

	SetFocus();
	m_sPath = path;
	m_ctrlPath.SetWindowTextW(path);
	m_ctrlPath.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CPackDialog::OnBnClickedBrowseWin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	cpath = cpath.Left(cpath.GetLength() - 1);

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_sPath = chPutFolder;
			m_sPath += STR_YEN;
			m_ctrlPath.SetWindowTextW(m_sPath);
			m_ctrlPath.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}

}

void CPackDialog::OnCbnSelchangeFilenameCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlFileName.ShowDropDown();
}

void CPackDialog::OnCbnSelchangePath()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlPath.ShowDropDown();
}

int CALLBACK CPackDialog::BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
		::SendMessage(hwnd,BFFM_SETSELECTION,(WPARAM)TRUE,lpData);
    }
    return 0;
}


void CPackDialog::OnBnClickedNameonlyCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	m_sOname = m_sOrgFileName;
	m_sOext = _T("");

	if (m_bNameOnlyCheck) {
		m_bNameOnlyCheck = false;
		m_ctrlNameOnlyCheck.SetCheck(BST_UNCHECKED);

	}
	else {
		m_bNameOnlyCheck = true;
		m_ctrlNameOnlyCheck.SetCheck(BST_CHECKED);

		int nf = m_sFileName.ReverseFind(_T('.'));
		int len = m_sFileName.GetLength();
		if (nf > 0) {
			m_sOname = m_sFileName.Left(nf);
			m_sOext = m_sFileName.Right(len - nf);
		}

	}
	m_sFileName = m_sOname;
	m_ctrlFileName.SetWindowTextW(m_sFileName);
	m_ctrlFileName.SetEditSel(0, -1);
	m_ctrlFileName.SetFocus();
	m_ctrlFileName.UpdateWindow();

}


void CPackDialog::OnCbnSelchangeRateCombo()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	switch (m_iArcType) {
	case 1:
		m_nRate = m_ctrlRateCombo.GetCurSel();
		break;

	case 3:
		m_nRate7 = m_ctrlRateCombo.GetCurSel();
		break;

	}
}


void CPackDialog::OnBnClickedObjectCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	if (m_bObjectCheck) {
		m_bObjectCheck = false;
		m_ctrlObjectCheck.SetCheck(BST_UNCHECKED);
	}
	else {
		m_bObjectCheck = true;
		m_ctrlObjectCheck.SetCheck(BST_CHECKED);
	}
}


void CPackDialog::OnBnClickedSetextCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	if (m_bSetExtCheck) {
		m_bSetExtCheck = false;
		m_ctrlSetExtCheck.SetCheck(BST_UNCHECKED);
	}
	else {
		m_bSetExtCheck = true;
		m_ctrlSetExtCheck.SetCheck(BST_CHECKED);
	}
}
