// MovePathDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "MovePathDialog.h"
#include "FmParam.h"
#include "TreeFrameWindow.h"


// CMovePathDialog _CAO

IMPLEMENT_DYNAMIC(CMovePathDialog, CDialog)

CMovePathDialog::CMovePathDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMovePathDialog::IDD, pParent)
	, m_Path(_T(""))
{

}

CMovePathDialog::~CMovePathDialog()
{
//	CoUninitialize();
}

void CMovePathDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PATH, m_ctrlPath);
	DDX_CBString(pDX, IDC_PATH, m_Path);
}


BEGIN_MESSAGE_MAP(CMovePathDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CMovePathDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BROWSE_BUTTON, &CMovePathDialog::OnBnClickedBrowseButton)

	ON_COMMAND(ID_TREE_MESSAGE, &CMovePathDialog::OnTreeMessage)
	ON_BN_CLICKED(IDC_BROWSE_WIN, &CMovePathDialog::OnBnClickedBrowseWin)
	ON_CBN_SELCHANGE(IDC_PATH, &CMovePathDialog::OnCbnSelchangePath)
END_MESSAGE_MAP()


// CMovePathDialog bZ[W nh

BOOL CMovePathDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	CString fext;
	fext = _T(".hid");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlPath);

//	CoInitialize(NULL);
	CEdit *pEdit = (CEdit *)m_ctrlPath.GetWindow(GW_CHILD);

	if (m_pFmParam->m_bSettingsAutocomplete) {
		::SHAutoComplete(pEdit->m_hWnd, SHACF_FILESYSTEM);
	}

	m_ctrlPath.SetWindowTextW(m_Path);

	if (m_pFmParam->m_bSettingsSetDialogFont) {
		m_font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_ctrlPath.SetFont(&m_font);

	}



	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CMovePathDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_ctrlPath.GetWindowTextW(m_Path);

	if ( m_Path == _T("") ) {
		OnBnClickedBrowseButton();
		return;
	}

	OnOK();
}

void CMovePathDialog::OnBnClickedBrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}

	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();


}

void CMovePathDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

	SetFocus();
	m_Path = path;
	m_ctrlPath.SetWindowTextW(path);
	m_ctrlPath.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CMovePathDialog::OnBnClickedBrowseWin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	cpath = cpath.Left(cpath.GetLength() - 1);

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_Path = chPutFolder;
			m_Path += STR_YEN;
			m_ctrlPath.SetWindowTextW(m_Path);
			m_ctrlPath.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}

}

void CMovePathDialog::OnCbnSelchangePath()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlPath.ShowDropDown();
}

int CALLBACK CMovePathDialog::BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
		::SendMessage(hwnd,BFFM_SETSELECTION,(WPARAM)TRUE,lpData);
    }
    return 0;
}

