// MirrorCopySureDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "MirrorCopySureDialog.h"
#include "FileView.h"

#include "io.h"


// CMirrorCopySureDialog _CAO

IMPLEMENT_DYNAMIC(CMirrorCopySureDialog, CDialog)

CMirrorCopySureDialog::CMirrorCopySureDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMirrorCopySureDialog::IDD, pParent)
{
}

CMirrorCopySureDialog::~CMirrorCopySureDialog()
{
}

void CMirrorCopySureDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DELETE_CHECK, m_ctrlCheckDlete);
	DDX_Control(pDX, IDC_COPY_CHECK, m_ctrlCheckCopy);
	DDX_Control(pDX, IDC_DELETE_FILE_LIST, m_ctrlListDeleteFile);
	DDX_Control(pDX, IDC_COPY_FILE_LIST, m_ctrlListCopyFile);
	DDX_Control(pDX, IDC_SDIR, m_ctrlSDir);
	DDX_Control(pDX, IDC_DDIR, m_ctrlDDir);
}


BEGIN_MESSAGE_MAP(CMirrorCopySureDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CMirrorCopySureDialog::OnBnClickedOk)
//	ON_BN_CLICKED(IDC_DELETE_CHECK, &CMirrorCopySureDialog::OnBnClickedDeleteCheck)
//	ON_BN_CLICKED(IDC_COPY_CHECK, &CMirrorCopySureDialog::OnBnClickedCopyCheck)
END_MESSAGE_MAP()


// CMirrorCopySureDialog bZ[W nh

BOOL CMirrorCopySureDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ


	m_ctrlCheckDlete.SetCheck(BST_CHECKED);
	m_ctrlCheckCopy.SetCheck(BST_CHECKED);

	if ( m_pFileView->m_MirrorCopyDeleteFileCount == 0 ) m_ctrlCheckDlete.EnableWindow(FALSE);
	if ( m_pFileView->m_MirrorCopyFileCount == 0 ) m_ctrlCheckCopy.EnableWindow(FALSE);

	CString sPath, dPath;

	sPath = m_pFileView->m_sMirrorCopySDir;
	dPath = m_pFileView->m_sMirrorCopyDDir;

	m_ctrlSDir.SetWindowTextW(sPath);
	m_ctrlDDir.SetWindowTextW(dPath);

	LVCOLUMN	lvc;
    TCHAR	cDel[][20] = {_T("t@C"), _T("TCY"), _T("XV")};
    TCHAR	cCopy[][20] = {_T("t@C"), _T("TCY"), _T("XV"), _T("TCY"), _T("XV")};
	int cw = 400;
	int sw = 80;
	int tw = 120;
    
    lvc.mask = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;    // LtO
	int col = 0;
    lvc.iSubItem    = col;            // TuACeԍ
    lvc.pszText     = cDel[col];   // oeLXg
    lvc.cx          = cw;          // 
	m_ctrlListDeleteFile.InsertColumn(col, &lvc);

	col = 1;
    lvc.iSubItem    = col;
    lvc.pszText     = cDel[col];
	lvc.cx          = sw;
	m_ctrlListDeleteFile.InsertColumn(col, &lvc);

	col = 2;
    lvc.iSubItem    = col;
    lvc.pszText     = cDel[col];
	lvc.cx          = tw;
	m_ctrlListDeleteFile.InsertColumn(col, &lvc);

	col = 0;
    lvc.iSubItem    = col;
    lvc.pszText     = cCopy[col];
	lvc.cx          = cw;
	m_ctrlListCopyFile.InsertColumn(col, &lvc);

	col = 1;
    lvc.iSubItem    = col;
    lvc.pszText     = cCopy[col];
	lvc.cx          = sw;
	m_ctrlListCopyFile.InsertColumn(col, &lvc);

	col = 2;
    lvc.iSubItem    = col;
    lvc.pszText     = cCopy[col];
	lvc.cx          = tw;
	m_ctrlListCopyFile.InsertColumn(col, &lvc);

	col = 3;
    lvc.iSubItem    = col;
    lvc.pszText     = cCopy[col];
	lvc.cx          = sw;
	m_ctrlListCopyFile.InsertColumn(col, &lvc);

	col = 4;
    lvc.iSubItem    = col;
    lvc.pszText     = cCopy[col];
	lvc.cx          = tw;
	m_ctrlListCopyFile.InsertColumn(col, &lvc);


	LVITEM	lvi;
	lvi.mask = LVIF_TEXT;
	CString s, fname, *ddpath, *cspath, *cdpath;
	_wfinddata64_t *dfile, *cfile, *cdfile;

	ddpath = m_pFileView->m_pMirrorDeletePath;
	cspath = m_pFileView->m_pMirrorCopySPath;
	cdpath = m_pFileView->m_pMirrorCopyDPath;
	dfile = m_pFileView->m_pw64DeleteData;
	cfile = m_pFileView->m_pw64CopyData;
	cdfile = m_pFileView->m_pw64CopyDData;

	for ( int i = 0; i < m_pFileView->m_MirrorCopyDeleteFileCount; i++ ) {
		lvi.iItem = i;
		lvi.iSubItem = 0;
		fname = ddpath[i];
		fname += dfile[i].name;
		lvi.pszText = fname.GetBuffer();
		m_ctrlListDeleteFile.InsertItem(&lvi);

		lvi.iItem = i;
		lvi.iSubItem = 1;
		s.Format(_T("%13d"), dfile[i].size);
		int at = dfile[i].attrib;
		if ( (at & _A_SUBDIR) != 0 ) s = _T("<DIR>");

		lvi.pszText = s.GetBuffer();
		m_ctrlListDeleteFile.SetItem(&lvi);

		lvi.iItem = i;
		lvi.iSubItem = 2;
		CTime ct(dfile[i].time_write);
		s = ct.Format(_T("%Y/%m/%d %H:%M:%S"));
		lvi.pszText = s.GetBuffer();
		m_ctrlListDeleteFile.SetItem(&lvi);
	}

	for ( int i = 0; i < m_pFileView->m_MirrorCopyFileCount; i++ ) {
		lvi.iItem = i;
		lvi.iSubItem = 0;
		fname = cspath[i];
		fname += cfile[i].name;
		lvi.pszText = fname.GetBuffer();
		m_ctrlListCopyFile.InsertItem(&lvi);

		lvi.iItem = i;
		lvi.iSubItem = 1;
		s.Format(_T("%13d"), cfile[i].size);
		int at = cfile[i].attrib;
		if ( (at & _A_SUBDIR) != 0 ) s = _T("<DIR>");
		lvi.pszText = s.GetBuffer();
		m_ctrlListCopyFile.SetItem(&lvi);

		lvi.iItem = i;
		lvi.iSubItem = 2;
		CTime ct(cfile[i].time_write);
		s = ct.Format(_T("%Y/%m/%d %H:%M:%S"));
		lvi.pszText = s.GetBuffer();
		m_ctrlListCopyFile.SetItem(&lvi);

		lvi.iItem = i;
		lvi.iSubItem = 3;
		at = cdfile[i].attrib;
		if ( (at & _A_SUBDIR) != 0 ) s = _T("<DIR>");
		if ( cdfile[i].name[0] == 0 ) s = _T(""); 
		else s.Format(_T("%13d"), cdfile[i].size);
		lvi.pszText = s.GetBuffer();
		m_ctrlListCopyFile.SetItem(&lvi);

		lvi.iItem = i;
		lvi.iSubItem = 4;
		CTime ct2(cdfile[i].time_write);
		if ( cdfile[i].name[0] == 0 ) s = _T(""); 
		else s = ct2.Format(_T("%Y/%m/%d %H:%M:%S"));
		lvi.pszText = s.GetBuffer();
		m_ctrlListCopyFile.SetItem(&lvi);
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


void CMirrorCopySureDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_bIsDelete = false;
	m_bIsCopy = false;
	if ( m_ctrlCheckDlete.GetCheck() == BST_CHECKED ) m_bIsDelete = true;
	if ( m_ctrlCheckCopy.GetCheck() == BST_CHECKED ) m_bIsCopy = true;

	OnOK();
}
/*
void CMirrorCopySureDialog::OnBnClickedDeleteCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	int r = m_ctrlCheckDlete.GetCheck();
	int sr = BST_CHECKED;

	if ( r == BST_CHECKED ) sr = BST_UNCHECKED;
	m_ctrlCheckDlete.SetCheck(sr);


}

void CMirrorCopySureDialog::OnBnClickedCopyCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	int r = m_ctrlCheckCopy.GetCheck();
	int sr = BST_CHECKED;

	if ( r == BST_CHECKED ) sr = BST_UNCHECKED;
	m_ctrlCheckCopy.SetCheck(sr);

}
*/
