// MirrorCopyDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "MirrorCopyDialog.h"
#include "FmParam.h"
#include "SelectJumpFolderDialog.h"
#include "TreeFrameWindow.h"
#include "JumpFrame.h"


// CMirrorCopyDialog _CAO

IMPLEMENT_DYNAMIC(CMirrorCopyDialog, CDialog)

CMirrorCopyDialog::CMirrorCopyDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMirrorCopyDialog::IDD, pParent)
	, m_bSure(true)
	, m_bDiffTimeCheck(false)
	, m_bDiffSizeCheck(false)
{
	m_pDumyCombo = new CComboBox();
	m_nFocus = 1;
	m_nFocus2 = 1;

}

CMirrorCopyDialog::~CMirrorCopyDialog()
{
	delete m_pDumyCombo;
}

void CMirrorCopyDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SDIR_COMBO, m_ctrlSDirCombo);
	DDX_Control(pDX, IDC_DDIR_COMBO, m_ctrlDDirCombo);
	DDX_Control(pDX, IDC_SURE_CHECK, m_ctrlSureCheck);
	DDX_Control(pDX, IDC_DIFF_TIME_CHECK, m_ctrlDiffTimeCheck);
	DDX_Control(pDX, IDC_DIFF_SIZE_CHECK, m_ctrlDiffSizeCheck);
}


BEGIN_MESSAGE_MAP(CMirrorCopyDialog, CDialog)
	ON_BN_CLICKED(IDC_SBROWSE_BUTTON, &CMirrorCopyDialog::OnBnClickedSbrowseButton)
	ON_BN_CLICKED(IDC_DBROWSE_BUTTON, &CMirrorCopyDialog::OnBnClickedDbrowseButton)
	ON_BN_CLICKED(IDOK, &CMirrorCopyDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_SJUMPFOLDER_BUTTON, &CMirrorCopyDialog::OnBnClickedSjumpfolderButton)
	ON_BN_CLICKED(IDC_DJUMPFOLDER_BUTTON, &CMirrorCopyDialog::OnBnClickedDjumpfolderButton)
	ON_CBN_KILLFOCUS(IDC_DDIR_COMBO, &CMirrorCopyDialog::OnCbnKillfocusDdirCombo)
	ON_CBN_SETFOCUS(IDC_DDIR_COMBO, &CMirrorCopyDialog::OnCbnSetfocusDdirCombo)
	ON_CBN_SETFOCUS(IDC_SDIR_COMBO, &CMirrorCopyDialog::OnCbnSetfocusSdirCombo)
	ON_BN_SETFOCUS(IDC_SJUMPFOLDER_BUTTON, &CMirrorCopyDialog::OnBnSetfocusSjumpfolderButton)
	ON_BN_SETFOCUS(IDC_SBROWSE_BUTTON, &CMirrorCopyDialog::OnBnSetfocusSbrowseButton)
	ON_BN_SETFOCUS(IDC_DJUMPFOLDER_BUTTON, &CMirrorCopyDialog::OnBnSetfocusDjumpfolderButton)
	ON_BN_SETFOCUS(IDC_DBROWSE_BUTTON, &CMirrorCopyDialog::OnBnSetfocusDbrowseButton)
	ON_BN_SETFOCUS(IDC_SURE_CHECK, &CMirrorCopyDialog::OnBnSetfocusSureCheck)

	ON_COMMAND(ID_TREE_MESSAGE, &CMirrorCopyDialog::OnTreeMessage)
	ON_COMMAND(ID_JUMP_MESSAGE, &CMirrorCopyDialog::OnJumpMessage)
	ON_BN_CLICKED(IDC_BROWSE_WIN, &CMirrorCopyDialog::OnBnClickedBrowseWin)
	ON_BN_CLICKED(IDC_BROWSE_WIN2, &CMirrorCopyDialog::OnBnClickedBrowseWin2)
	ON_CBN_SELCHANGE(IDC_SDIR_COMBO, &CMirrorCopyDialog::OnCbnSelchangeSdirCombo)
	ON_CBN_SELCHANGE(IDC_DDIR_COMBO, &CMirrorCopyDialog::OnCbnSelchangeDdirCombo)
END_MESSAGE_MAP()


// CMirrorCopyDialog bZ[W nh

void CMirrorCopyDialog::OnBnClickedSbrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}

	m_nFocus = 1;
	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();


}

void CMirrorCopyDialog::OnBnClickedDbrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B


	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}

	m_nFocus = 2;
	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();


}

void CMirrorCopyDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_ctrlSDirCombo.GetWindowTextW(m_sSDir);
	m_ctrlDDirCombo.GetWindowTextW(m_sDDir);


	if ( m_nFocus2 == 1 ) {
		if ( m_sSDir == _T("") ) {
			OnBnClickedSbrowseButton();
			return;
		}
	}

	if ( m_nFocus2 == 2 ) {
		if ( m_sDDir == _T("") ) {
			OnBnClickedDbrowseButton();
			return;
		}
	}

	int n = m_sSDir.GetLength();
	int n2 = m_sDDir.GetLength();
	CString s;

	if( (n < 4) || (n2 < 4) ) {
		s = _T("ʌyѕʐɂ̓tH_w肵ĉ");
		MessageBox(s);
		return;
	}

	CFileStatus rStatus;

	if ( !(CFile::GetStatus(m_sSDir, rStatus)) ) {	// rtH_݂Ȃ
		s.Format(_T("[ %s ]\r\nʌtH_݂܂B"), m_sSDir);
		MessageBox(s);
		return;
	}

	if ( !(CFile::GetStatus(m_sDDir, rStatus)) ) {	// rtH_݂Ȃ
		s.Format(_T("[ %s ]\r\nʐtH_݂܂B"), m_sDDir);
		MessageBox(s);
		return;
	}

	s = m_sSDir;
	s += _T(";");
	s += m_sDDir;

	CString fext;
	fext = _T(".mir");
	m_pFmParam->WriteHistoryFile(fext, s);

	int ch = m_ctrlSureCheck.GetCheck();
	m_bSure = false;
	if ( ch == BST_CHECKED ) m_bSure = true;

	ch = m_ctrlDiffTimeCheck.GetCheck();
	m_bDiffTimeCheck = false;
	if (ch == BST_CHECKED) m_bDiffTimeCheck = true;

	ch = m_ctrlDiffSizeCheck.GetCheck();
	m_bDiffSizeCheck = false;
	if (ch == BST_CHECKED) m_bDiffSizeCheck = true;

	OnOK();
}

BOOL CMirrorCopyDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	CRect rc(0, 0, 0, 0);
	m_pDumyCombo->Create(CBS_DROPDOWN, rc, this, 10000);

	if (m_bSure) m_ctrlSureCheck.SetCheck(BST_CHECKED);
	if (m_bDiffTimeCheck) m_ctrlDiffTimeCheck.SetCheck(BST_CHECKED);
	if (m_bDiffSizeCheck) m_ctrlDiffSizeCheck.SetCheck(BST_CHECKED);

	CString fext;
	fext = _T(".mir");

	m_pFmParam->ReadHistoryFile(fext, m_pDumyCombo);
//	m_pFmParam->ReadHistoryFile(fext, &m_ctrlDDirCombo);

	int max = m_pDumyCombo->GetCount();
	CString sbuf, sSdir, sDdir;
	m_ctrlSDirCombo.ResetContent();
	m_ctrlDDirCombo.ResetContent();

	int eq = -1;

	for ( int i = 0; i < max; i++ ) {
		m_pDumyCombo->GetLBText(i, sbuf);
		int slen = sbuf.GetLength();
		int nc = sbuf.Find(_T(';'));
		sSdir = sbuf.Left(nc);
		sDdir = sbuf.Right(slen - nc - 1);
		m_ctrlSDirCombo.InsertString(i, sSdir);
		m_ctrlDDirCombo.InsertString(i, sDdir);
		if ( sSdir == m_sSDir ) eq = i;
	}


	m_ctrlSDirCombo.SetWindowTextW(m_sSDir);

	if ( eq != -1 ) {
		m_ctrlSDirCombo.SetCurSel(eq);
		m_ctrlDDirCombo.SetCurSel(eq);
	}

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CMirrorCopyDialog::OnBnClickedSjumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_nFocus = 1;
	m_pJumpFrameWindow = new CJumpFrame;
	m_pJumpFrameWindow->m_pFmParam = m_pFmParam;
	m_pJumpFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrameWindow->ShowWindow(SW_SHOW);
	m_pJumpFrameWindow->SetWindowText(_T("JumpFolder"));
	m_pJumpFrameWindow->UpdateWindow();

/*
	CSelectJumpFolderDialog dlg;
	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r = IDOK ) {
		m_sSDir = dlg.m_sSelectedFolder;
		m_ctrlSDirCombo.SetWindowTextW(m_sSDir);
		m_ctrlSDirCombo.SetFocus();
	}
*/
}

void CMirrorCopyDialog::OnBnClickedDjumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_nFocus = 2;
	m_pJumpFrameWindow = new CJumpFrame;
	m_pJumpFrameWindow->m_pFmParam = m_pFmParam;
	m_pJumpFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrameWindow->ShowWindow(SW_SHOW);
	m_pJumpFrameWindow->SetWindowText(_T("JumpFolder"));
	m_pJumpFrameWindow->UpdateWindow();

/*
	CSelectJumpFolderDialog dlg;
	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r = IDOK ) {
		m_sDDir = dlg.m_sSelectedFolder;
		m_ctrlDDirCombo.SetWindowTextW(m_sDDir);
		m_ctrlDDirCombo.SetFocus();
	}
*/

}

void CMirrorCopyDialog::OnCbnKillfocusDdirCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

}

void CMirrorCopyDialog::OnCbnSetfocusDdirCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_nFocus2 = 2;
}

void CMirrorCopyDialog::OnCbnSetfocusSdirCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_nFocus2 = 1;
}

void CMirrorCopyDialog::OnBnSetfocusSjumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
}

void CMirrorCopyDialog::OnBnSetfocusSbrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
}

void CMirrorCopyDialog::OnBnSetfocusDjumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
}

void CMirrorCopyDialog::OnBnSetfocusDbrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
}

void CMirrorCopyDialog::OnBnSetfocusSureCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
}

void CMirrorCopyDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

//	SetFocus();

	if ( m_nFocus == 1 ) {
		m_sSDir = path;
		m_ctrlSDirCombo.SetWindowTextW(path);
		m_ctrlSDirCombo.SetFocus();
	}

	if ( m_nFocus == 2 ) {
		m_sDDir = path;
		m_ctrlDDirCombo.SetWindowTextW(path);
		m_ctrlDDirCombo.SetFocus();
	}

	m_pTreeFrameWindow = NULL;

}

void CMirrorCopyDialog::OnJumpMessage()
{
	CString path = m_pFmParam->m_sSelectedJumpPath;

//	SetFocus();

	if ( m_nFocus == 1 ) {
		m_sSDir = path;
		m_ctrlSDirCombo.SetWindowTextW(path);
		m_ctrlSDirCombo.SetFocus();
	}

	if ( m_nFocus == 2 ) {
		m_sDDir = path;
		m_ctrlDDirCombo.SetWindowTextW(path);
		m_ctrlDDirCombo.SetFocus();
	}

	m_pJumpFrameWindow = NULL;

}

void CMirrorCopyDialog::OnBnClickedBrowseWin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString cpath, sDestPath;
	m_ctrlSDirCombo.GetWindowTextW(sDestPath);

	if (sDestPath == _T("")) {

		cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		cpath = cpath.Left(cpath.GetLength() - 1);
	}
	else {
		if (sDestPath == _T("\\")) {
			cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			sDestPath = cpath.Left(3);
		}
		cpath = sDestPath;
	}

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_sSDir = chPutFolder;
			m_sSDir += STR_YEN;
			m_ctrlSDirCombo.SetWindowTextW(m_sSDir);
			m_ctrlSDirCombo.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}

}

void CMirrorCopyDialog::OnBnClickedBrowseWin2()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString cpath, sDestPath;
	m_ctrlDDirCombo.GetWindowTextW(sDestPath);

	if (sDestPath == _T("")) {

		cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		cpath = cpath.Left(cpath.GetLength() - 1);
	}
	else {
		if (sDestPath == _T("\\")) {
			cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			sDestPath = cpath.Left(3);
		}
		cpath = sDestPath;
	}

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = 0;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_sDDir = chPutFolder;
			m_sDDir += STR_YEN;
			m_ctrlDDirCombo.SetWindowTextW(m_sDDir);
			m_ctrlDDirCombo.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}

}

void CMirrorCopyDialog::OnCbnSelchangeSdirCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlSDirCombo.ShowDropDown();
}

void CMirrorCopyDialog::OnCbnSelchangeDdirCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlDDirCombo.ShowDropDown();
}

int CALLBACK CMirrorCopyDialog::BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
		::SendMessage(hwnd,BFFM_SETSELECTION,(WPARAM)TRUE,lpData);
    }
    return 0;
}
