// MciDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "MciDialog.h"
#include "Mmsystem.h"
#include "FmParam.h"

#include <mmsystem.h>
#include <stdlib.h>
#include <locale.h>


// CMciDialog _CAO

IMPLEMENT_DYNAMIC(CMciDialog, CDialog)

CMciDialog::CMciDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMciDialog::IDD, pParent)
	, m_sTime(_T(" 00:00 / 00:00"))
	, m_sFileName(_T(""))
{
	m_MinTotal = 0;
	m_SecTotal = 0;
	m_MinNow = 0;
	m_SecNow = 0;
	m_bAutoPlay = true;
	m_bNowPlay = false;
	m_VolRate = VOLUME_RATE;
	m_bEnableCOM = false;
	m_bListMode = false;	// t@CXgĐ[h
	m_psFileList = new CString[MAX_FILELIST];	// t@CXg 100t@C܂
	m_nFileListNum = 0;
	m_sListFilename = _T("");
	m_nNowPlay = 0;
	lpGraph = 0;
}

CMciDialog::~CMciDialog()
{
	delete []m_psFileList;
}

void CMciDialog::ClearFileNameList(void)
{
	for ( int i = 0; i < MAX_FILELIST; i++ ) {
		m_psFileList[i] = _T("");
	}
}

void CMciDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TIME, m_ctrlTime);
	DDX_Control(pDX, IDC_SLIDER1, m_ctrlSlider);
	DDX_Control(pDX, IDC_FILENAME, m_ctrlFileName);
	DDX_Control(pDX, IDC_PAUSE_BUTTON, m_ctrlPauseButton);
	DDX_Control(pDX, IDC_PLAY_BUTTON, m_ctrlPlayButton);
	DDX_Control(pDX, IDC_SLIDER2, m_ctrlSlider2);
}


BEGIN_MESSAGE_MAP(CMciDialog, CDialog)
	ON_BN_CLICKED(IDC_PLAY_BUTTON, &CMciDialog::OnBnClickedPlayButton)
	ON_BN_CLICKED(IDC_PAUSE_BUTTON, &CMciDialog::OnBnClickedPauseButton)
	ON_BN_CLICKED(IDC_STOP_BUTTON, &CMciDialog::OnBnClickedStopButton)
	ON_BN_CLICKED(IDCANCEL, &CMciDialog::OnBnClickedCancel)
	ON_WM_TIMER()
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER1, &CMciDialog::OnNMReleasedcaptureSlider1)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	ON_BN_CLICKED(IDC_VUP_BUTTON, &CMciDialog::OnBnClickedVupButton)
	ON_BN_CLICKED(IDC_VDOWN_BUTTON, &CMciDialog::OnBnClickedVdownButton)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER2, &CMciDialog::OnNMReleasedcaptureSlider2)
	ON_STN_CLICKED(IDC_TIME, &CMciDialog::OnStnClickedTime)
	ON_STN_CLICKED(IDC_FILENAME, &CMciDialog::OnStnClickedFilename)

	ON_COMMAND(ID_MCI_LOAD_LIST, &CMciDialog::OnLoadList)
	ON_COMMAND(ID_MCI_PLAY_LIST, &CMciDialog::OnPlayList)
	ON_COMMAND(ID_MCI_PLAY_NEXT_LIST, &CMciDialog::OnPlayNextList)
	ON_COMMAND(ID_MCI_PLAY_PREV_LIST, &CMciDialog::OnPlayPrevList)

	ON_WM_RBUTTONDOWN()
END_MESSAGE_MAP()


// CMciDialog bZ[W nh

void CMciDialog::OnBnClickedPlayButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	CString s, scom;

	if ( !m_bEnableCOM ) return;

	if ( !m_bNowPlay ) {
		// ĐJn
		lpMediaControl->Run();

		m_bNowPlay = true;
		SetTimer(MCI_TIMER, 1000, NULL);

		m_ctrlPauseButton.EnableWindow();
		m_ctrlPlayButton.EnableWindow(false);
	}
}

void CMciDialog::OnBnClickedPauseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	if ( !m_bEnableCOM ) return;

	if ( m_bNowPlay ) {

		lpMediaControl->Pause();
		m_bNowPlay = false;
		KillTimer(MCI_TIMER);
		m_ctrlPauseButton.EnableWindow(false);
		m_ctrlPlayButton.EnableWindow();
	}
}

void CMciDialog::OnBnClickedStopButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	if ( !m_bEnableCOM ) return;
//	if ( !m_bNowPlay ) return;

	KillTimer(MCI_TIMER);

	lpMediaControl->Pause();
	m_llTimeNowTotal = 0;
	lpMediaSeeking->SetPositions(&m_llTimeNowTotal, AM_SEEKING_AbsolutePositioning, &m_llTimeTotal, AM_SEEKING_AbsolutePositioning);

	m_TimeNowTotal = 0;
	m_bNowPlay = false;
	m_ctrlSlider.SetPos(m_TimeNowTotal);
	m_ctrlPauseButton.EnableWindow(false);
	DrawTime();

	m_ctrlPlayButton.EnableWindow();


}

void CMciDialog::OnBnClickedCancel()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	KillTimer(MCI_TIMER);
	m_TimeNowTotal = 0;
	if ( m_bNowPlay ) OnBnClickedStopButton();
	m_bNowPlay = false;

	ShowWindow(SW_HIDE);

	ReleaseCOM();

//	OnCancel();
}

BOOL CMciDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	fontFileName.CreatePointFont( 70, _T("Meiryo UI") );
	GetDlgItem( IDC_FILENAME )->SetFont( &fontFileName, TRUE );

	ClearFileNameList();

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

DWORD CMciDialog::InitializeData(void)
{

	ReleaseCOM();

	// COM̏
//    CoInitialize( NULL );

    HRESULT ret;
    // Ot}l[W쐬
    ret = CoCreateInstance( CLSID_FilterGraph,NULL,CLSCTX_INPROC_SERVER,IID_IGraphBuilder,(void **)&lpGraph );

    // fBARg[̎擾
    ret = lpGraph->QueryInterface( IID_IMediaControl,(void **)&lpMediaControl );
    ret = lpGraph->QueryInterface( IID_IMediaSeeking,(void **)&lpMediaSeeking );
    ret = lpGraph->QueryInterface( IID_IVideoWindow,(void **)&lpVideoWindow );


	if ( m_bNowPlay ) OnBnClickedStopButton();

	if ( m_bListMode ) {
		m_sFullFileName = m_psFileList[m_nNowPlay];
		int n = m_sFullFileName.ReverseFind('\\') + 1;
		m_sFileName = m_sFullFileName.Mid(n);
	}

	m_ctrlFileName.SetWindowTextW(m_sFileName);

	HRESULT hret;
	hret = lpGraph->RenderFile( m_sFullFileName, NULL );

	LONG lw, lh;
	lw = 0;
	lh = 0;

	if (hret == S_OK) {
/*
		lpVideoWindow->put_Owner((OAHWND)m_pParent->GetSafeHwnd());
		lpVideoWindow->put_WindowStyle(WS_CHILD|WS_CLIPSIBLINGS);
		lpVideoWindow->put_Visible(OATRUE);
*/
		lpVideoWindow->put_Top(20);
		lpVideoWindow->put_Left(20);

		lpVideoWindow->SetWindowForeground(0L);

		lpMediaSeeking->GetDuration(&m_llTimeTotal);
		m_llTimeNowTotal = 0;
		m_TimeNowTotal = 0;
		m_TimeTotal = (UINT)(m_llTimeTotal / TIMEBASE);
		int time = m_TimeTotal;
		DrawTime();

		lpMediaSeeking->SetPositions(&m_llTimeNowTotal, AM_SEEKING_AbsolutePositioning, &m_llTimeTotal, AM_SEEKING_AbsolutePositioning);

		m_ctrlSlider.SetRangeMax(time);
		m_ctrlSlider.SetRangeMin(0);
		m_ctrlSlider.SetPos(m_TimeNowTotal);

		UINT uRetVal, uNumDevs;
		DWORD volume;
		int volumeL = 0;

		WAVEOUTCAPS waveCaps;

		// Make sure there is at least one
		// wave output device to work with.
		if (uNumDevs = waveOutGetNumDevs())
		{
		}

		// This sample uses a hard-coded 0 as the device ID, but retail
		// applications should loop on devices 0 through N-1, where N is the
		// number of devices returned by waveOutGetNumDevs().
		if (!waveOutGetDevCaps(0,(LPWAVEOUTCAPS)&waveCaps,
		   sizeof(WAVEOUTCAPS)))

		{
		   // Verify the device supports volume changes
		   if(waveCaps.dwSupport & WAVECAPS_VOLUME)
		   {

			   // Now get and display the volumes.
			   uRetVal = waveOutGetVolume(0, (LPDWORD)&volume);

			   long ld = 0xffff / m_VolRate;

			   long ov = (int)LOWORD(volume);
			   volumeL = 100 - (ov * 100 / 0xffff);
		   }
	    }

		m_ctrlSlider2.SetRangeMax(100);
		m_ctrlSlider2.SetRangeMin(0);
		m_ctrlSlider2.SetPos(volumeL);

		m_bEnableCOM = true;
		if ( m_bAutoPlay ) {
			OnBnClickedPlayButton();
		}
//		lpVideoWindow->GetMaxIdealImageSize(&lw, &lh);
	} else {
		CString s, scom;
		s = _T("Error:0x%x");
		scom.Format(s, hret);
		m_ctrlTime.SetWindowTextW(scom);
		m_bEnableCOM = false;
	}


	return 0;
}

void CMciDialog::DrawTime(void)
{
	int time = m_TimeTotal;
	m_MinTotal = time / 60;
	m_SecTotal = time - (m_MinTotal * 60);

	int timenow = m_TimeNowTotal;
	m_MinNow = timenow / 60;
	m_SecNow = timenow - (m_MinNow * 60);

	m_sTime.Format(_T(" %02d:%02d / %02d:%02d"), m_MinNow, m_SecNow, m_MinTotal, m_SecTotal);
	m_ctrlTime.SetWindowTextW(m_sTime);

}

void CMciDialog::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	LONGLONG ltime;
	lpMediaSeeking->GetPositions(&m_llTimeNowTotal, &ltime);
	m_TimeNowTotal = (UINT)(m_llTimeNowTotal / TIMEBASE);

	if ( m_TimeNowTotal >= m_TimeTotal ) {
		if ( m_bListMode && (m_nFileListNum != 0) ) {
			m_nNowPlay++;
			if ( m_nNowPlay == m_nFileListNum ) m_nNowPlay = 0;
			InitializeData();
		} else KillTimer(MCI_TIMER);
	} else {
		DrawTime();
		m_ctrlSlider.SetPos(m_TimeNowTotal);
	}

	CDialog::OnTimer(nIDEvent);
}

void CMciDialog::OnNMReleasedcaptureSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	int n = m_ctrlSlider.GetPos();
	m_TimeNowTotal = n;
	LONGLONG nLL = (LONGLONG)n;
	LONGLONG tbLL = (LONGLONG)TIMEBASE;

	m_llTimeNowTotal = n * tbLL;
	lpMediaSeeking->SetPositions(&m_llTimeNowTotal, AM_SEEKING_AbsolutePositioning, &m_llTimeTotal, AM_SEEKING_AbsolutePositioning);
	DrawTime();

	*pResult = 0;
}

void CMciDialog::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	CRect rc;
	GetWindowRect(&rc);

	sSection = INISECTION_MCIWINDOW;
	sEntry = INIENTRY_WINDOW_TOP;
	pApp->WriteProfileInt(sSection, sEntry, rc.top);
	sEntry = INIENTRY_WINDOW_LEFT;
	pApp->WriteProfileInt(sSection, sEntry, rc.left);
	sEntry = INIENTRY_WINDOW_RIGHT;
	pApp->WriteProfileInt(sSection, sEntry, rc.right);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	pApp->WriteProfileInt(sSection, sEntry, rc.bottom);

	ReleaseCOM();

}

void CMciDialog::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
//	m_pParent->SetFocus();
}

void CMciDialog::OnBnClickedVupButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
    UINT uRetVal, uNumDevs;
    DWORD volume;
    long lLeftVol, lRightVol;

    WAVEOUTCAPS waveCaps;

    // Make sure there is at least one
    // wave output device to work with.
    if (uNumDevs = waveOutGetNumDevs())
    {
    }

    // This sample uses a hard-coded 0 as the device ID, but retail
    // applications should loop on devices 0 through N-1, where N is the
    // number of devices returned by waveOutGetNumDevs().
    if (!waveOutGetDevCaps(0,(LPWAVEOUTCAPS)&waveCaps,
       sizeof(WAVEOUTCAPS)))

    {
	   // Verify the device supports volume changes
	   if(waveCaps.dwSupport & WAVECAPS_VOLUME)
	   {

		   // Now get and display the volumes.
		   uRetVal = waveOutGetVolume(0, (LPDWORD)&volume);

		   long ld = 0xffff / m_VolRate;

		   lLeftVol = (long)LOWORD(volume);
		   lRightVol = (long)HIWORD(volume);

		   lLeftVol += ld;
		   lRightVol += ld;

		   if ( (lLeftVol > 0xffff) || (lRightVol > 0xffff) ) {
			   lLeftVol = 0xffff;
			   lRightVol = 0xffff;
		   }

		   volume = (lRightVol * 0x10000) + lLeftVol;

		   uRetVal = waveOutSetVolume(0, volume);

		   long ov = (int)LOWORD(volume);
		   int volumeL = 100 - (ov * 100 / 0xffff);
			m_ctrlSlider2.SetPos(volumeL);
	   }
	}
	m_VolRate = VOLUME_RATE;

}

void CMciDialog::OnBnClickedVdownButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
    UINT uRetVal, uNumDevs;
    DWORD volume;
    long lLeftVol, lRightVol;

    WAVEOUTCAPS waveCaps;

    // Make sure there is at least one
    // wave output device to work with.
    if (uNumDevs = waveOutGetNumDevs())
    {
    }

    // This sample uses a hard-coded 0 as the device ID, but retail
    // applications should loop on devices 0 through N-1, where N is the
    // number of devices returned by waveOutGetNumDevs().
    if (!waveOutGetDevCaps(0,(LPWAVEOUTCAPS)&waveCaps,
       sizeof(WAVEOUTCAPS)))

    {
	   // Verify the device supports volume changes
	   if(waveCaps.dwSupport & WAVECAPS_VOLUME)
	   {

		   // Now get and display the volumes.
		   uRetVal = waveOutGetVolume(0, (LPDWORD)&volume);

		   long ld = 0xffff / m_VolRate;

		   lLeftVol = (long)LOWORD(volume);
		   lRightVol = (long)HIWORD(volume);

		   if ( (lLeftVol < ld) || (lRightVol < ld) ) {
			   lLeftVol = 0;
			   lRightVol = 0;
		   } else {

			   lLeftVol -= ld;
			   lRightVol -= ld;
		   }

		   volume = (lRightVol * 0x10000) + lLeftVol;

		   uRetVal = waveOutSetVolume(0, volume);

		   long ov = (int)LOWORD(volume);
		   int volumeL = 100 - (ov * 100 / 0xffff);
			m_ctrlSlider2.SetPos(volumeL);
	   }
	}
	m_VolRate = VOLUME_RATE;
}

void CMciDialog::OnNMReleasedcaptureSlider2(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

    UINT uRetVal, uNumDevs;
    DWORD volume;

    WAVEOUTCAPS waveCaps;

    // Make sure there is at least one
    // wave output device to work with.
    if (uNumDevs = waveOutGetNumDevs())
    {
    }

    // This sample uses a hard-coded 0 as the device ID, but retail
    // applications should loop on devices 0 through N-1, where N is the
    // number of devices returned by waveOutGetNumDevs().
    if (!waveOutGetDevCaps(0,(LPWAVEOUTCAPS)&waveCaps,
       sizeof(WAVEOUTCAPS)))

    {
	   // Verify the device supports volume changes
	   if(waveCaps.dwSupport & WAVECAPS_VOLUME)
	   {
			int n = 100 - m_ctrlSlider2.GetPos();
			DWORD wv = n * 0xffff / 100;
			volume = (wv * 0x10000) + wv;
			uRetVal = waveOutSetVolume(0, volume);
	   }
	}




	*pResult = 0;
}

void CMciDialog::OnStnClickedTime()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
}


void CMciDialog::ReleaseCOM()
{

	if ( m_bEnableCOM ) {

		OnBnClickedStopButton();

		// J
		lpMediaControl->Release();
		lpMediaSeeking->Release();
		lpVideoWindow->Release();
		if ( lpGraph ) {
			lpGraph->Release();
			lpGraph = 0;
		}

		// COM̏I
//		CoUninitialize();
		m_bEnableCOM = false;
	}
}


void CMciDialog::OnStnClickedFilename()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

}


void CMciDialog::OnLoadList()
{

    CString	filter(_T("Xgt@C (*.fsl)|*.fsl|SẴt@C (*.*)|*.*||"));
    CFileDialog	selDlg(TRUE, NULL, NULL, OFN_FILEMUSTEXIST, filter);
    
    if (selDlg.DoModal() == IDOK)
    {
        m_sListFilename = selDlg.GetPathName();

		int n = m_sListFilename.ReverseFind('\\') + 1;
		CString fname = m_sListFilename.Mid(n);
		SetWindowTextW(fname);

		setlocale( LC_ALL, ".ACP" );
		CStdioFile cfile;

		int max = MAX_FILELIST;

		if ( !cfile.Open( m_sListFilename, CFile::modeRead ) ) {
			MessageBox(m_sListFilename, _T("t@Cǂݍ݃G[I"));
			return;
		}

		if ( m_bNowPlay ) OnBnClickedStopButton();
		ClearFileNameList();

		CString sbuf;

		int i;
		for ( i = 0; i < max; i++ ) {
			BOOL r = cfile.ReadString(m_psFileList[i]);
			if ( !r ) {
				break;
			}
		}
		m_nFileListNum = i;

		cfile.Close();

	}



}

void CMciDialog::OnPlayList()
{
	m_bListMode = true;
	InitializeData();
}


void CMciDialog::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	CMenu pRmenu;
	pRmenu.CreatePopupMenu();

	pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_MCI_LOAD_LIST ,_T("Xgt@C̓ǂݍ(&L)"));
	if ( m_nFileListNum == 0 ) {
		pRmenu.AppendMenu(MF_STRING|MF_DISABLED,ID_MCI_PLAY_LIST ,_T("Xgt@C̍Đ(&P)"));
		pRmenu.AppendMenu(MF_STRING|MF_DISABLED,ID_MCI_PLAY_NEXT_LIST ,_T("̃Xgt@CĐ(&N)"));
		pRmenu.AppendMenu(MF_STRING|MF_DISABLED,ID_MCI_PLAY_PREV_LIST ,_T("ÕXgt@C̍Đ(&R)"));
	} else {
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_MCI_PLAY_LIST ,_T("Xgt@C̍Đ(&P)"));
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_MCI_PLAY_NEXT_LIST ,_T("̃Xgt@C̍Đ(&N)"));
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_MCI_PLAY_PREV_LIST ,_T("ÕXgt@C̍Đ(&R)"));
	}

	ClientToScreen(&point);
	pRmenu.TrackPopupMenu(
		TPM_LEFTALIGN  |	//NbNXWj[̍ӂɂ
		TPM_RIGHTBUTTON,	//ENbNŃj[I\Ƃ
		point.x,point.y,	//j[̕\ʒu
		this            	//̃j[LEBhE
	);
	pRmenu.DestroyMenu();

	CDialog::OnRButtonDown(nFlags, point);
}

void CMciDialog::OnPlayNextList()
{
	m_bListMode = true;

	m_nNowPlay++;
	if ( m_nNowPlay >= m_nFileListNum ) m_nNowPlay = 0;

	InitializeData();
}

void CMciDialog::OnPlayPrevList()
{
	m_bListMode = true;

	m_nNowPlay--;
	if ( m_nNowPlay < 0 ) m_nNowPlay = m_nFileListNum - 1;

	InitializeData();
}

