// MainFrm.cpp : CMainFrame NX̎
//

#include "stdafx.h"
#include "annsFM.h"

#include "MainFrm.h"
#include "MciDialog.h"

#include "imm.h"
#include "io.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	// O[o wv R}h
//	ON_COMMAND(ID_HELP_FINDER, &CFrameWnd::OnHelpFinder)
//	ON_COMMAND(ID_HELP, &CFrameWnd::OnHelp)
//	ON_COMMAND(ID_CONTEXT_HELP, &CFrameWnd::OnContextHelp)
//	ON_COMMAND(ID_DEFAULT_HELP, &CFrameWnd::OnHelpFinder)

	ON_COMMAND(ID_HELP_MENU, &CMainFrame::OnHelp)
	ON_WM_DESTROY()
	ON_COMMAND(ID_VIEW_TOOLBAR, &CMainFrame::OnViewToolbar)
	ON_WM_INITMENU()
	ON_COMMAND(ID_VIEW_STATUS_BAR, &CMainFrame::OnViewStatusBar)
	ON_WM_MOVE()
	ON_WM_SIZE()
	ON_COMMAND(ID_VIEW_SHIFT_KEY_TOOLBAR, &CMainFrame::OnViewShiftKeyToolbar)
	ON_COMMAND(ID_VIEW_CTRL_KEY_TOOLBAR, &CMainFrame::OnViewCtrlKeyToolbar)
	ON_WM_CLOSE()
	ON_WM_INITMENUPOPUP()
	ON_WM_QUERYENDSESSION()
	ON_WM_COPYDATA()
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};


// CMainFrame RXgNV/fXgNV

CMainFrame::CMainFrame()
{
	// TODO: oR[hɒǉĂB
	m_pFmParam = new CFmParam;
	m_pChildView = new CChildView;
	m_pChildView->m_pFmParam = m_pFmParam;
	m_sCurrentPath = _T("");
}

CMainFrame::~CMainFrame()
{
	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry, tmp;
	tmp = _T("%s%02d");
	sSection.Format(tmp, INISECTION_ANNSFM, m_pFmParam->m_annsFMNo);
	sEntry = INIENTRY_ANNSFM_EXIST;
	pApp->WriteProfileInt(sSection, sEntry, false);

	delete m_pFmParam;
	delete m_pChildView;
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

//	HICON hIcon=AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	HICON hIcon=AfxGetApp()->LoadIcon(IDI_ICON1);
	SetIcon(hIcon,FALSE);

	m_pChildView->m_pMainFrame = this;

	// t[̃NCAg̈Ŝ߂r[쐬܂B
	if (!m_pChildView->Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("r[ EBhE쐬ł܂łB\n");
		return -1;
	}

	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC
		, CRect(0, 0, 0, 0), IDR_MAINFRAME) || !m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("c[ o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}

	if (!m_wndShiftKeyToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC
		, CRect(0, 0, 0, 0), IDR_SHIFT_KEY_TOOLBAR) || !m_wndShiftKeyToolBar.LoadToolBar(IDR_SHIFT_KEY_TOOLBAR))
	{
		TRACE0("c[ o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}

	if (!m_wndCtrlKeyToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC
		, CRect(0, 0, 0, 0), IDR_CTRL_KEY_TOOLBAR) || !m_wndCtrlKeyToolBar.LoadToolBar(IDR_CTRL_KEY_TOOLBAR))
	{
		TRACE0("c[ o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Xe[^X o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}


	// TODO: c[ o[hbLO\ɂȂꍇ́A 3 s폜ĂB
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndShiftKeyToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndCtrlKeyToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);

	DockControlBar(&m_wndToolBar);
	DockControlBar(&m_wndShiftKeyToolBar);
	DockControlBar(&m_wndCtrlKeyToolBar);

	LoadBarState(_T("BarState"));

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	m_pFmParam->m_sValCurrentPath = cpath;

	m_hNotify = FindFirstChangeNotification( cpath, FALSE, FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME
		| FILE_NOTIFY_CHANGE_ATTRIBUTES | FILE_NOTIFY_CHANGE_SIZE | FILE_NOTIFY_CHANGE_LAST_WRITE );

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}


// CMainFrame ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


// CMainFrame bZ[W nh

void CMainFrame::OnSetFocus(CWnd* /*pOldWnd*/)
{
	// r[ EBhEɃtH[JX^܂B
	m_pChildView->m_pFileView->SetFocus();

	HIMC hIMC = ::ImmGetContext( m_hWnd );
	if ( hIMC )
	{
		if ( ::ImmGetOpenStatus( hIMC ) )
		{
			::ImmSetOpenStatus( hIMC, FALSE );
//			TRACE( _T("Disable IME\n") );
		}
		::ImmReleaseContext( m_hWnd, hIMC );
	}

	if (!(m_pChildView->m_pFileView->m_bRunCmd)) {
		m_pFmParam->m_pDriveParam->GetDriveParam();
		m_pChildView->m_pDriveTabWnd->m_MaxTab = m_pChildView->m_pDriveTabWnd->CreateDriveList();
		m_pChildView->m_pDriveTabWnd->Invalidate();
	}

//	m_pChildView->m_pFileView->m_pDriveTabWnd->m_MaxTab = m_pChildView->m_pFileView->m_pDriveTabWnd->CreateDriveList();
//	m_pChildView->m_pFileView->m_pDriveTabWnd->Invalidate();

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if ( m_sCurrentPath != cpath) {
		m_sCurrentPath = cpath;
		FindCloseChangeNotification(m_hNotify);
		m_hNotify = FindFirstChangeNotification( m_sCurrentPath, FALSE, FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME
				| FILE_NOTIFY_CHANGE_ATTRIBUTES | FILE_NOTIFY_CHANGE_SIZE | FILE_NOTIFY_CHANGE_LAST_WRITE );
	} else {

		if ( m_pChildView->m_pFmParam->m_bRedrawFocus ) {
			DWORD dwRet = WaitForSingleObject(m_hNotify, 0);
			if ( dwRet == WAIT_OBJECT_0 ) {
				m_pChildView->m_pFileView->UpdateFileList();
			}
		}
	}
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// r[ɍŏɃR}h@^܂B
	if (m_pChildView->m_pFileView->OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// ȊȌꍇ́Ȁs܂B
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}



void CMainFrame::OnDestroy()
{
	CFrameWnd::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B

	if ( m_pFmParam->m_hInstanceNVDA && m_pFmParam->m_bEnableNVDA ) FreeLibrary(m_pFmParam->m_hInstanceNVDA);
	if ( m_pFmParam->m_hInstancePCTalker && m_pFmParam->m_bEnablePCTalker ) FreeLibrary(m_pFmParam->m_hInstancePCTalker);

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry, tmp;
	CRect rc;
	GetWindowRect(&rc);

	tmp = _T("%s%02d");
	sSection.Format(tmp, INISECTION_ANNSFM, m_pFmParam->m_annsFMNo);
	sEntry = INIENTRY_WINDOW_TOP;
	pApp->WriteProfileInt(sSection, sEntry, rc.top);
	sEntry = INIENTRY_WINDOW_LEFT;
	pApp->WriteProfileInt(sSection, sEntry, rc.left);
	sEntry = INIENTRY_WINDOW_RIGHT;
	pApp->WriteProfileInt(sSection, sEntry, rc.right);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	pApp->WriteProfileInt(sSection, sEntry, rc.bottom);

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	sSection = INISECTION_SETTINGS;
	sEntry = INIENTRY_SETTINGS_LAST_FOLDER;
	pApp->WriteProfileString(sSection, sEntry, cpath);

	FindCloseChangeNotification(m_hNotify);

	m_pChildView->m_pFileView->DeleteAllView();
}

void CMainFrame::OnViewToolbar()
{
	// TODO: ɃR}h nh R[hǉ܂B
	int r = m_wndToolBar.IsWindowVisible();
	CMenu* pMenu = GetMenu();
	if ( r ) {
		pMenu->CheckMenuItem(ID_VIEW_TOOLBAR, MF_UNCHECKED);
		ShowControlBar(&m_wndToolBar, FALSE, 0);
		m_pFmParam->m_EnableToolBar = false;
	} else {
		pMenu->CheckMenuItem(ID_VIEW_TOOLBAR, MF_CHECKED);
		ShowControlBar(&m_wndToolBar, TRUE, 0);
		m_pFmParam->m_EnableToolBar = true;
	}

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	sSection = INISECTION_BARSTATUS;
	sEntry = INIENTRY_BARSTATUS_ENABLE_TOOLBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_pFmParam->m_EnableToolBar);
}

void CMainFrame::OnViewShiftKeyToolbar()
{
	// TODO: ɃR}h nh R[hǉ܂B
	int r = m_wndShiftKeyToolBar.IsWindowVisible();
	CMenu* pMenu = GetMenu();
	if ( r ) {
		pMenu->CheckMenuItem(ID_VIEW_SHIFT_KEY_TOOLBAR, MF_UNCHECKED);
		ShowControlBar(&m_wndShiftKeyToolBar, FALSE, 0);
		m_pFmParam->m_EnableShiftKeyToolBar = false;
	} else {
		pMenu->CheckMenuItem(ID_VIEW_SHIFT_KEY_TOOLBAR, MF_CHECKED);
		ShowControlBar(&m_wndShiftKeyToolBar, TRUE, 0);
		m_pFmParam->m_EnableShiftKeyToolBar = true;
	}

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	sSection = INISECTION_BARSTATUS;
	sEntry = INIENTRY_BARSTATUS_ENABLE_SHIFT_KEY_TOOLBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_pFmParam->m_EnableShiftKeyToolBar);
}

void CMainFrame::OnViewCtrlKeyToolbar()
{
	// TODO: ɃR}h nh R[hǉ܂B
	int r = m_wndCtrlKeyToolBar.IsWindowVisible();
	CMenu* pMenu = GetMenu();
	if ( r ) {
		pMenu->CheckMenuItem(ID_VIEW_CTRL_KEY_TOOLBAR, MF_UNCHECKED);
		ShowControlBar(&m_wndCtrlKeyToolBar, FALSE, 0);
		m_pFmParam->m_EnableCtrlKeyToolBar = false;
	} else {
		pMenu->CheckMenuItem(ID_VIEW_CTRL_KEY_TOOLBAR, MF_CHECKED);
		ShowControlBar(&m_wndCtrlKeyToolBar, TRUE, 0);
		m_pFmParam->m_EnableCtrlKeyToolBar = true;
	}

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	sSection = INISECTION_BARSTATUS;
	sEntry = INIENTRY_BARSTATUS_ENABLE_CTRL_KEY_TOOLBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_pFmParam->m_EnableCtrlKeyToolBar);
}


void CMainFrame::OnViewStatusBar()
{
	// TODO: ɃR}h nh R[hǉ܂B
	int r = m_wndStatusBar.IsWindowVisible();
	CMenu* pMenu = GetMenu();
	if ( r ) {
		pMenu->CheckMenuItem(ID_VIEW_STATUS_BAR, MF_UNCHECKED);
		ShowControlBar(&m_wndStatusBar, FALSE, 0);
		m_pFmParam->m_EnableStatusBar = false;
	} else {
		pMenu->CheckMenuItem(ID_VIEW_STATUS_BAR, MF_CHECKED);
		ShowControlBar(&m_wndStatusBar, TRUE, 0);
		m_pFmParam->m_EnableStatusBar = true;
	}

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	sSection = INISECTION_BARSTATUS;
	sEntry = INIENTRY_BARSTATUS_ENABLE_STATUSBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_pFmParam->m_EnableStatusBar);
}

void CMainFrame::EnableBar()
{
	// TODO: ɃR}h nh R[hǉ܂B
	bool rt = m_pFmParam->m_EnableToolBar;
	bool rt2 = m_pFmParam->m_EnableShiftKeyToolBar;
	bool rt3 = m_pFmParam->m_EnableCtrlKeyToolBar;

	bool rs = m_pFmParam->m_EnableStatusBar;
	CMenu* pMenu = GetMenu();

	if ( rt ) {
		pMenu->CheckMenuItem(ID_VIEW_TOOLBAR, MF_CHECKED);
		ShowControlBar(&m_wndToolBar, TRUE, 0);
	} else {
		pMenu->CheckMenuItem(ID_VIEW_TOOLBAR, MF_UNCHECKED);
		ShowControlBar(&m_wndToolBar, FALSE, 0);
	}

	if ( rt2 ) {
		pMenu->CheckMenuItem(ID_VIEW_SHIFT_KEY_TOOLBAR, MF_CHECKED);
		ShowControlBar(&m_wndShiftKeyToolBar, TRUE, 0);
	} else {
		pMenu->CheckMenuItem(ID_VIEW_SHIFT_KEY_TOOLBAR, MF_UNCHECKED);
		ShowControlBar(&m_wndShiftKeyToolBar, FALSE, 0);
	}

	if ( rt3 ) {
		ShowControlBar(&m_wndCtrlKeyToolBar, TRUE, 0);
		pMenu->CheckMenuItem(ID_VIEW_CTRL_KEY_TOOLBAR, MF_CHECKED);
	} else {
		ShowControlBar(&m_wndCtrlKeyToolBar, FALSE, 0);
		pMenu->CheckMenuItem(ID_VIEW_CTRL_KEY_TOOLBAR, MF_UNCHECKED);
	}

	if ( rs ) {
		ShowControlBar(&m_wndStatusBar, TRUE, 0);
//		pMenu->CheckMenuItem(ID_VIEW_STATUSBAR, MF_CHECKED);
	} else {
		ShowControlBar(&m_wndStatusBar, FALSE, 0);
//		pMenu->CheckMenuItem(ID_VIEW_STATUSBAR, MF_UNCHECKED);
	}

}

void CMainFrame::OnMove(int x, int y)
{
	CFrameWnd::OnMove(x, y);

	m_pChildView->MoveMciWindow();
	// TODO: ɃbZ[W nh R[hǉ܂B
}

void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B

	RECT rc;
	GetWindowRect(&rc);

	int ww = rc.bottom - rc.top;
	if (ww < 320) rc.bottom = rc.top + 320;

	ww = rc.right - rc.left;
	if (ww < 480) rc.right = rc.left + 480;

	MoveWindow(&rc);


}


void CMainFrame::OnClose()
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	SaveBarState(_T("BarState"));

	CFrameWnd::OnClose();
}


void CMainFrame::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu)
{
	CFrameWnd::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);

	COleDataObject clipboardData;
	clipboardData.AttachClipboard();

	COleDataObject* pDataObject;
	pDataObject = &clipboardData;
	BOOL da = pDataObject->IsDataAvailable(CF_HDROP);
	HDROP hDrop = (HDROP)pDataObject->GetGlobalData(CF_HDROP);

	UINT nFiles = 0;

	if ( da )
	{
		nFiles = ::DragQueryFile( hDrop, 0xFFFFFFFF, NULL, 0 );
	}

	CMenu* pMenu = GetMenu();
	if ( !nFiles ) {
		pMenu->EnableMenuItem(ID_CTRL_KEY_V, MF_GRAYED);
	}

	CString fname;
	fname =  m_pFmParam->m_pw64FindData[m_pChildView->m_pFileView->m_CurrentFileNo].name;
	if ( fname == _T("..") ) {
		pMenu->EnableMenuItem(ID_KEY_A, MF_GRAYED);
		pMenu->EnableMenuItem(ID_KEY_C, MF_GRAYED);
		pMenu->EnableMenuItem(ID_KEY_D, MF_GRAYED);
		pMenu->EnableMenuItem(ID_KEY_M, MF_GRAYED);
		pMenu->EnableMenuItem(ID_KEY_N, MF_GRAYED);
		pMenu->EnableMenuItem(ID_KEY_P, MF_GRAYED);

		pMenu->EnableMenuItem(ID_CTRL_KEY_B, MF_GRAYED);
		pMenu->EnableMenuItem(ID_CTRL_KEY_C, MF_GRAYED);
		pMenu->EnableMenuItem(ID_CTRL_KEY_N, MF_GRAYED);
		pMenu->EnableMenuItem(ID_CTRL_KEY_T, MF_GRAYED);

		pMenu->EnableMenuItem(ID_CTRL_KEY_ENTER, MF_GRAYED);
	}
	int at;
	at = m_pFmParam->m_pw64FindData[m_pChildView->m_pFileView->m_CurrentFileNo].attrib;
	if ((at & _A_SUBDIR) != 0) {
		pMenu->EnableMenuItem(ID_KEY_G, MF_GRAYED);
		pMenu->EnableMenuItem(ID_KEY_U, MF_GRAYED);
		pMenu->EnableMenuItem(ID_KEY_V, MF_GRAYED);
		pMenu->EnableMenuItem(ID_CTRL_KEY_S, MF_GRAYED);
	}

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	if ( cpath.GetLength() < 4 ) {
		pMenu->EnableMenuItem(ID_KEY_BACKSPACE, MF_GRAYED);
	}

	if ( m_pFmParam->m_TagFileNum == 0 ) {
		pMenu->EnableMenuItem(ID_CTRL_KEY_N, MF_GRAYED);
	}

	BOOL b = FALSE;
	for ( int i = 26; i < MAXDRIVE; i++ ) {
		b = m_pFmParam->m_pDriveParam->m_pExist[i];
		if ( b ) {
			break;
		}
	}
	if ( !b ) {
		pMenu->EnableMenuItem(ID_SHIFT_KEY_C, MF_GRAYED);
	}

	// TODO: ɃbZ[W nh R[hǉ܂B
}


BOOL CMainFrame::OnQueryEndSession()
{
//	if (!CFrameWnd::OnQueryEndSession())
//		return FALSE;

	// TODO: ɓȃNG̏IZbV R[hǉĂB

//	MessageBox(_T("QueryEndSession!"));

	AfxGetMainWnd()->PostMessage(WM_COMMAND, ID_APP_EXIT);

//	DestroyWindow();

	return TRUE;
}

void CMainFrame::OnHelp()
{
	CString s = m_pFmParam->GetExePath(_T("annsFM.chm"));
	ShellExecute(NULL, _T("open"), s, NULL, NULL, SW_SHOW);
}



BOOL CMainFrame::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	m_pChildView->m_pFileView->OnCopyData(pCopyDataStruct);

	return CFrameWnd::OnCopyData(pWnd, pCopyDataStruct);
}
