// JumpView.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "JumpView.h"
#include "FmParam.h"
#include "JumpFrame.h"
#include "FileView.h"
#include "SetJumpdirDialog.h"

#include <locale.h>

// #include "nvdaController.h"

// CJumpView

IMPLEMENT_DYNCREATE(CJumpView, CScrollView)

CJumpView::CJumpView()
{
	INT_PTR size = MAX_LINE_NUM;
	m_saPath.SetSize(size);
	m_saName.SetSize(size);
	m_saKey.SetSize(size);
	m_nStartPos = 0;
	m_nCurLine = 0;
	m_nDeltaLine = 1;
}

CJumpView::~CJumpView()
{
}


BEGIN_MESSAGE_MAP(CJumpView, CScrollView)
	ON_WM_KEYDOWN()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_JUMP_EXIT, &CJumpView::OnJumpExit)
	ON_WM_MOUSEWHEEL()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_32814, &CJumpView::OnMenuSetJumpDir)
	ON_COMMAND(ID_32815, &CJumpView::OnMenuDeleteJumpDir)
	ON_WM_VSCROLL()
END_MESSAGE_MAP()


// CJumpView `

void CJumpView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CFont font;
	CClientDC dc(this);
	CFont* pOldFont;
//	TEXTMETRIC tm;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontJump));
	pOldFont = dc.SelectObject(&font);
//	GetTextMetrics(dc, &tm);
	CString cs;
	cs = "W";
	CSize size = dc.GetTextExtent(cs);
	m_FontW = size.cx;
	m_FontH = size.cy + 1;
	dc.SelectObject(pOldFont);

	CRect rc;
	GetClientRect(rc);

	int xw = rc.right;
	int yw = rc.bottom;
	int max = MAX_LINE_NUM;


	CSize sizeTotal, sizePage, sizeLine;
	// TODO: ̃r[̃TCY̍vvZ܂B
	sizeTotal.cx = m_FontW * MAX_CHAR_NUM;
	sizePage.cx = ((xw / m_FontW) * m_FontW) / 2;
	sizeLine.cx = m_FontW * 10;

	sizeTotal.cy = m_FontH * max;
	sizePage.cy = ((yw / m_FontH) * m_FontH) / 2;
	sizeLine.cy = m_FontH;

	SetScrollSizes(MM_TEXT, sizeTotal, sizePage, sizeLine);

	bool bNewVer = true;

	CString path, s;

	s = _T("annsFM.jp2");	// Vo[W

	path = m_pFmParam->GetExePath(s);

	setlocale( LC_ALL, ".ACP" );

	CFileStatus rStatus, sStatus;
	if ( !(CFile::GetStatus(path,  rStatus)) ) {	// t@C݂Ȃ

		s = _T("annsFM.jmp");	// o[W
		CString path2 = m_pFmParam->GetExePath(s);

		if (!(CFile::GetStatus(path2, rStatus))) {	// t@C݂Ȃ
			WriteJumpFile(true);
		} else{
			bNewVer = false;
			path = path2;
		}
	}

	CStdioFile cfile;
	cfile.Open( path, CFile::modeRead );

	CString sbuf;

	int n;
	CString as;
	BOOL r = TRUE;

	for ( n = 0; n < max; n++ ) {
		if ( r ) {
			r = cfile.ReadString(sbuf);
			m_saKey.SetAt(n, sbuf.Left(4));

			CStringA sA, sA2;
			CString s, s2;
			int len = 4;
			if (bNewVer) {
				sA2 = CW2A(sbuf);
				sA = sA2.Mid(4, MAX_NAME_NUM);
				sA2 = sA;

				int sl = sA.GetLength();

				while (sl != 0) {
					sl--;
					if (sA.GetAt(sl) == 0x20) {
						sA2 = sA.Left(sl);
					}
					else {
						sl = 0;
					}
				}

				s = CA2W(sA2);

				m_saName.SetAt(n, s);
				len += (MAX_NAME_NUM + 1);

				sA2 = CW2A(sbuf);
				sA = sA2.Mid(len);

				m_saPath.SetAt(n, CA2W(sA));
			}
			else {
				m_saName.SetAt(n, _T(""));
				m_saPath.SetAt(n, sbuf.Mid(len));
			}


		}
	}

	cfile.Close();

	if (!bNewVer) {
		WriteJumpFile();
	}

}

void CJumpView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB

	CFont font;
	CFont* pOldFont;
	int fw, fh;
//	TEXTMETRIC tm;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontJump));
	pOldFont = pDC->SelectObject(&font);
//		GetTextMetrics(dc, &tm);
	fh = m_FontH;
	fw = m_FontW + 1;

	CString s, form;
	CSize sizew;

	pDC->SetBkColor(m_pFmParam->m_colBack);

	int max = MAX_LINE_NUM;
	int x, y;
	x = 3;
	y = 0;
	int n;
	for ( n = 0; n < max; n++ ) {
		COLORREF coldata = m_pFmParam->m_colJump;
		if ( (n > 35) && (n < 72) ) coldata = m_pFmParam->m_colJumpShift;
		if ( n == m_nCurLine ) {
			pDC->SetBkColor(coldata);
			pDC->SetTextColor(m_pFmParam->m_colBack);
		} else {
			pDC->SetBkColor(m_pFmParam->m_colBack);
			pDC->SetTextColor(coldata);
		}
		CString s, s2;
		CStringA sA, sA2;
		sA2.Format("%%-%ds", MAX_NAME_NUM);

		CString s3 = m_saName.GetAt(n);
		CStringA sA3 = CW2A(s3);
		sA.Format(sA2, sA3);
		s2 = CA2W(sA);

		s = m_saKey.GetAt(n);
		s += s2;
		s += _T(" ");
		s += m_saPath.GetAt(n);

		pDC->TextOut(x, y, s);
		y += m_FontH;

		if ( n == m_nCurLine ) {
//			if ( m_pFmParam->m_bToolUseNVDA && m_pFmParam->m_bEnableNVDA ) {
//				m_pFmParam->m_pnvdaController_speakText(s);
			if ( m_pFmParam->m_nVoiceGuide != 0 ) {
				m_pFmParam->VoiceGuideOut(s);
			}
		}
	}
	pDC->SelectObject(pOldFont);

	CRect rc;
	GetClientRect(rc);
	m_nLineYw = rc.bottom / m_FontH;
}


// CJumpView ff

#ifdef _DEBUG
void CJumpView::AssertValid() const
{
	CScrollView::AssertValid();
}

#ifndef _WIN32_WCE
void CJumpView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif
#endif //_DEBUG


// CJumpView bZ[W nh

void CJumpView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B


	short shift = GetKeyState(VK_SHIFT);
	short ctrl = GetKeyState(VK_CONTROL);

	UINT cmdno;
	if ( shift < 0 ) {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x300;
		} else {
			cmdno = nChar + 0x100;
		}
	} else {
		if ( ctrl < 0 ) {
			cmdno = nChar + 0x200;
		} else {
			cmdno = nChar;
		}
	}

	RunKeyCmd(cmdno);

//	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}


BOOL CJumpView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	// uV̍쐬
	CBrush brush(m_pFmParam->m_colBack);
    // VuVw(̃uV̕ۑ)
    CBrush* pOldBrush = pDC->SelectObject(&brush);

    // hԂ̈擾
    CRect rect;
    GetClientRect(&rect);

	// hԂ
    pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

	// uVɖ߂
    pDC->SelectObject(pOldBrush);

	return TRUE;

//	return CScrollView::OnEraseBkgnd(pDC);
}

void CJumpView::OnJumpExit()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pJumpFrame->DestroyWindow();
}

void CJumpView::WriteJumpFile(bool init)
{
	// TODO: ɃR}h nh R[hǉ܂B
	CString path, s;

	s = _T("annsFM.jp2");

	path = m_pFmParam->GetExePath(s);

	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;
	cfile.Open( path, CFile::modeCreate | CFile::modeWrite );

	CString sbuf;

	int n;
	int max = MAX_LINE_NUM;

	for ( n = 0; n < max; n++ ) {
		if ( init ) {
			int nn = n;
			s = _T(" ");
			CString as, bs;
			bs = _T(" ");

			if ( n > 25 ) {
				nn = n - 26 - 0x11;
			}
			if ( n > 35 ) {
				s = _T("s");
				nn = n - 36;
				bs = _T("+");
			}
			if ( n > 61 ) {
				nn = n - 62 - 0x11;
			}
			if ( n > 71 ) {
				s = _T("c");
				nn = n - 72;
			}
			if ( n > 97 ) {
				nn = n - 98 - 0x11;
			}

			as.Format(_T("%c"), 'A' + nn);
			sbuf.Format(_T("%s%s%s"), s, bs, as);
			m_saKey.SetAt(n, sbuf);
			m_saName.SetAt(n, _T(""));
			m_saPath.SetAt(n, _T(""));
		}
		CString s, s2;
		CStringA sA, sA2;
		sA2.Format("%%-%ds", MAX_NAME_NUM);
		CString s3 = m_saName.GetAt(n);
		CStringA sA3 = CW2A(s3);
		sA.Format(sA2, sA3);
		s2 = CA2W(sA);

		s = m_saKey.GetAt(n);
		s += s2;
		s += _T(" ");
		s += m_saPath.GetAt(n);
		sbuf = s;

		sbuf += _T("\n");
		cfile.WriteString(sbuf);
	}

	cfile.Close();


}

// L[R}hs	nCmdNo = R}hNo.
// L[JX^}CYyуR}h}NpɁAR}hNo.őSẴR}hs
void CJumpView::RunKeyCmd(UINT uCmdNo)
{
	switch ( uCmdNo ) {

		case 0x08: // "Backspace"
			break;

		case 0x0d: // "Enter"
			CmdKeyEnter();
			break;

		case 0x1b: // "Esc"
			CmdKeyEsc();
			break;

		case 0x20: // Space
			break;

		case 0x21: // PageUp
			CmdKeyPageUp();
			break;

		case 0x22: // PageDown
			CmdKeyPageDown();
			break;


		case 0x24: // "Home"
			break;

		case 0x25: // ""
			break;

		case 0x26: // ""
			CmdKeyUp();
			break;

		case 0x27: // ""
			break;

		case 0x28: // ""
			CmdKeyDown();
			break;

		case 0x2d: // "Insert"
			CmdKeyInsert();
			break;

		case 0x2e: // "Delete"
			CmdKeyDelete();
			break;

		case 0x30: // "0"
		case 0x31: // "1"
		case 0x32: // "2"
		case 0x33: // "3"
		case 0x34: // "4"
		case 0x35: // "5"
		case 0x36: // "6"
		case 0x37: // "7"
		case 0x38: // "8"
		case 0x39: // "9"
			CmdKeyNumber(uCmdNo - 0x30);
			break;

		case 0x41: // "A"
		case 0x42: // "B"
		case 0x43: // "C"
		case 0x44: // "D"
		case 0x45: // "E"
		case 0x46: // "F"
		case 0x47: // "G"
		case 0x48: // "H"
		case 0x49: // "I"
		case 0x4a: // "J"
		case 0x4b: // "K"
		case 0x4c: // "L"
		case 0x4d: // "M"
		case 0x4e: // "N"
		case 0x4f: // "O"
		case 0x50: // "P"
		case 0x51: // "Q"
		case 0x52: // "R"
		case 0x53: // "S"
		case 0x54: // "T"
		case 0x55: // "U"
		case 0x56: // "V"
		case 0x57: // "W"
		case 0x58: // "X"
		case 0x59: // "Y"
		case 0x5a: // "Z"
			CmdKeyAlpha(uCmdNo - 0x41);
			break;

		case 0x60: // "0" eL[
		case 0x61: // "1"
		case 0x62: // "2"
		case 0x63: // "3"
		case 0x64: // "4"
		case 0x65: // "5"
		case 0x66: // "6"
		case 0x67: // "7"
		case 0x68: // "8"
		case 0x69: // "9"
			CmdKeyNumber(uCmdNo - 0x60);
			break;


		// Shift+
		case 0x108: // "Backspace"
			break;

		case 0x10d: // "Enter"
//			CmdKeyShiftEnter();
			break;

		case 0x121: // PageUp
			break;

		case 0x122: // PageDown
			break;


		case 0x125: // ""
			break;

		case 0x126: // ""
			break;

		case 0x127: // ""
			break;

		case 0x128: // ""
			break;

		case 0x130: // "0"
		case 0x131: // "1"
		case 0x132: // "2"
		case 0x133: // "3"
		case 0x134: // "4"
		case 0x135: // "5"
		case 0x136: // "6"
		case 0x137: // "7"
		case 0x138: // "8"
		case 0x139: // "9"
			CmdKeyNumber(uCmdNo - 0x130 + 36);
			break;

		case 0x160: // "0" eL[
		case 0x161: // "1"
		case 0x162: // "2"
		case 0x163: // "3"
		case 0x164: // "4"
		case 0x165: // "5"
		case 0x166: // "6"
		case 0x167: // "7"
		case 0x168: // "8"
		case 0x169: // "9"
			CmdKeyNumber(uCmdNo - 0x160 + 36);
			break;

		case 0x141: // "A"
		case 0x142: // "B"
		case 0x143: // "C"
		case 0x144: // "D"
		case 0x145: // "E"
		case 0x146: // "F"
		case 0x147: // "G"
		case 0x148: // "H"
		case 0x149: // "I"
		case 0x14a: // "J"
		case 0x14b: // "K"
		case 0x14c: // "L"
		case 0x14d: // "M"
		case 0x14e: // "N"
		case 0x14f: // "O"
		case 0x150: // "P"
		case 0x151: // "Q"
		case 0x152: // "R"
		case 0x153: // "S"
		case 0x154: // "T"
		case 0x155: // "U"
		case 0x156: // "V"
		case 0x157: // "W"
		case 0x158: // "X"
		case 0x159: // "Y"
		case 0x15a: // "Z"
			CmdKeyAlpha(uCmdNo - 0x141 + 36);
			break;

		// Ctrl+
		case 0x208: // "Backspace"
			break;

		case 0x20d: // "Enter"
			break;

		case 0x221: // PageUp
			break;

		case 0x222: // PageDown
			break;


		case 0x225: // ""
			break;

		case 0x226: // ""
			break;

		case 0x227: // ""
			break;

		case 0x228: // ""
			break;

		case 0x230: // "0"
		case 0x231: // "1"
		case 0x232: // "2"
		case 0x233: // "3"
		case 0x234: // "4"
		case 0x235: // "5"
		case 0x236: // "6"
		case 0x237: // "7"
		case 0x238: // "8"
		case 0x239: // "9"
			CmdKeyNumber(uCmdNo - 0x230 + 72);
			break;

		case 0x260: // "0" eL[
		case 0x261: // "1"
		case 0x262: // "2"
		case 0x263: // "3"
		case 0x264: // "4"
		case 0x265: // "5"
		case 0x266: // "6"
		case 0x267: // "7"
		case 0x268: // "8"
		case 0x269: // "9"
			CmdKeyNumber(uCmdNo - 0x260 + 72);
			break;

		case 0x241: // "A"
		case 0x242: // "B"
		case 0x243: // "C"
		case 0x244: // "D"
		case 0x245: // "E"
		case 0x246: // "F"
		case 0x247: // "G"
		case 0x248: // "H"
		case 0x249: // "I"
		case 0x24a: // "J"
		case 0x24b: // "K"
		case 0x24c: // "L"
		case 0x24d: // "M"
		case 0x24e: // "N"
		case 0x24f: // "O"
		case 0x250: // "P"
		case 0x251: // "Q"
		case 0x252: // "R"
		case 0x253: // "S"
		case 0x254: // "T"
		case 0x255: // "U"
		case 0x256: // "V"
		case 0x257: // "W"
		case 0x258: // "X"
		case 0x259: // "Y"
		case 0x25a: // "Z"
			CmdKeyAlpha(uCmdNo - 0x241 + 72);
			break;

	}
}

// L[R}h ==================================

// Cmd No 0x0d
void CJumpView::CmdKeyEnter(void)
{
	CString path;
	path = m_saPath.GetAt(m_nCurLine);

	m_pFmParam->m_sSelectedJumpPath = path;
	if ( m_pJumpFrame->m_pwndParent != NULL ) {
		m_pJumpFrame->m_pwndParent->PostMessageW( WM_COMMAND, ID_JUMP_MESSAGE, 0);

	}
	if ( m_pJumpFrame->m_bExit ) CmdKeyEsc();

}

// Cmd No 0x1b
void CJumpView::CmdKeyEsc(void)
{
	m_pJumpFrame->DestroyWindow();
}

// Cmd No 0x20
void CJumpView::CmdKeySpace(void)
{
}

// Cmd No 0x21
void CJumpView::CmdKeyPageUp(void)
{
	m_nStartPos -= m_nLineYw;
	if ( m_nStartPos < 0 ) m_nStartPos = 0; 
	m_nCurLine -= m_nLineYw;
	if ( m_nCurLine < 0 ) {
		m_nCurLine = 0;
	}

	CPoint pt;
	pt.x = 0;
	pt.y = m_nStartPos * m_FontH;
	ScrollToPosition(pt);

	Invalidate();
}

// Cmd No 0x22
void CJumpView::CmdKeyPageDown(void)
{
	m_nStartPos += m_nLineYw;
	if ( m_nStartPos >= MAX_LINE_NUM ) m_nStartPos = MAX_LINE_NUM - m_nLineYw; 
	m_nCurLine += m_nLineYw;
	if ( m_nCurLine >= MAX_LINE_NUM ) {
		m_nCurLine = MAX_LINE_NUM - 1;
	}

	CPoint pt;
	pt.x = 0;
	pt.y = m_nStartPos * m_FontH;
	ScrollToPosition(pt);

	Invalidate();
}


// Cmd No 0x25
void CJumpView::CmdKeyLeft(void)
{
}

// Cmd No 0x27
void CJumpView::CmdKeyRight(void)
{
}

// Cmd No 0x26
void CJumpView::CmdKeyUp(void)
{
	m_nCurLine--;
	if ( m_nCurLine < 0 ) {
		m_nCurLine = 0;
		return;
	}

	if ( m_nCurLine < m_nStartPos ) {
		m_nStartPos -= m_nDeltaLine;
		CPoint pt;
		pt.x = 0;
		pt.y = m_nStartPos * m_FontH;
		ScrollToPosition(pt);
	}

	Invalidate();
}

// Cmd No 0x27
void CJumpView::CmdKeyDown(void)
{
	m_nCurLine++;
	if ( m_nCurLine >= MAX_LINE_NUM ) {
		m_nCurLine = MAX_LINE_NUM - 1;
		return;
	}

	int lastL;
	lastL = m_nStartPos + m_nLineYw;

	if ( m_nCurLine >= lastL ) {
		m_nStartPos += m_nDeltaLine;
		CPoint pt;
		pt.x = 0;
		pt.y = m_nStartPos * m_FontH;
		ScrollToPosition(pt);
	}

	Invalidate();
}

// Cmd No 0x2d
void CJumpView::CmdKeyInsert(void)
{
	CSetJumpdirDialog dlg(this);

	dlg.m_sJumpPath = m_saPath.GetAt(m_nCurLine);
	dlg.m_sJumpNameEdit = m_saName.GetAt(m_nCurLine);
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_pDriveTabWnd = m_pJumpFrame->m_pDriveTabWnd;

	int ret = dlg.DoModal();

	if ( ret == IDOK ) {
		m_saName.SetAt(m_nCurLine, dlg.m_sJumpNameEdit);
		m_saPath.SetAt(m_nCurLine, dlg.m_sJumpPath);
		WriteJumpFile();
		Invalidate();
	}
}

// Cmd No 0x2e
void CJumpView::CmdKeyDelete(void)
{
	CString s;

	s = m_saPath.GetAt(m_nCurLine);
	if ( s.GetLength() == 0 ) return;

	s.Format(_T("Key %s [%s]\n[ %s ]\n폜Ă낵łH"), m_saKey.GetAt(m_nCurLine), m_saName.GetAt(m_nCurLine), m_saPath.GetAt(m_nCurLine));
	int ret = MessageBox(s, _T("pX̍폜"), MB_YESNO | MB_ICONEXCLAMATION);
	if ( ret == IDYES ) {
		m_saName.SetAt(m_nCurLine, _T(""));
		m_saPath.SetAt(m_nCurLine, _T(""));
		WriteJumpFile();
		Invalidate();
	}
}

// Cmd No 0x30 - 0x39 / 0x60 - 0x69
// uNo 0 - 9
void CJumpView::CmdKeyNumber(UINT uNo)
{
	m_nCurLine = uNo + 26;
	CmdKeyEnter();
}

// Cmd No 0x41 - 0x5a / 0x141 - 0x15a / 0x241 - 0x25a
// uNo 0 - 25 / 36 - 51 / 77 - 102
void CJumpView::CmdKeyAlpha(UINT uNo)
{
	m_nCurLine = uNo;
	CmdKeyEnter();
}

BOOL CJumpView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( zDelta < 0 ) CmdKeyDown();
	else CmdKeyUp();

	return TRUE;

//	return CScrollView::OnMouseWheel(nFlags, zDelta, pt);
}

void CJumpView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	int pos = point.y / m_FontH;
	m_nCurLine = pos + m_nStartPos;
	Invalidate();


	CScrollView::OnLButtonDown(nFlags, point);
}

void CJumpView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CmdKeyEnter();

//	CScrollView::OnLButtonDblClk(nFlags, point);
}

void CJumpView::OnMenuSetJumpDir()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyInsert();
}

void CJumpView::OnMenuDeleteJumpDir()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyDelete();
}

void CJumpView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CPoint pt;

	switch(nSBCode) {
		case SB_LINEUP:	// XN[{bNX̏NbNꍇ
			m_nStartPos--;
			if ( m_nStartPos < 0 ) m_nStartPos = 0;

			if ( m_nCurLine >= (m_nStartPos + m_nLineYw) ) m_nCurLine = m_nStartPos + m_nLineYw - 1;
			if ( m_nCurLine >= MAX_LINE_NUM ) m_nCurLine = MAX_LINE_NUM - 1;

			Invalidate();

			pt.y = m_nStartPos * m_FontH;
			ScrollToPosition(pt);

			break;

		case SB_LINEDOWN:	// XN[{bNX̉NbNꍇ
			m_nStartPos++;
			if ( m_nStartPos > (MAX_LINE_NUM - m_nLineYw) ) m_nStartPos = MAX_LINE_NUM - m_nLineYw;

			if ( m_nCurLine < m_nStartPos ) m_nCurLine = m_nStartPos;

			pt.y = m_nStartPos * m_FontH;
			ScrollToPosition(pt);

			Invalidate();

			break;

		case SB_PAGEUP:		// XN[{bNX̏㑤NbNꍇi܂PageUpL[j
			CmdKeyPageUp();
			break;

		case SB_PAGEDOWN:		// XN[{bNX̉NbNꍇi܂PageDownL[j
			CmdKeyPageDown();
			break;

		case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
			break;

		case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
			m_nStartPos = nPos / m_FontH;
			if ( m_nCurLine < m_nStartPos ) m_nCurLine = m_nStartPos;
			if ( m_nCurLine >= (m_nStartPos + m_nLineYw) ) m_nCurLine = m_nStartPos + m_nLineYw - 1;
			if ( m_nCurLine >= MAX_LINE_NUM ) m_nCurLine = MAX_LINE_NUM - 1;

			pt.y = m_nStartPos * m_FontH;
			ScrollToPosition(pt);

			Invalidate();

			break;

	}


//	CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);
}
