#pragma once

#include "FmParam.h"

// CInfoWnd

class CFileView;

class CInfoWnd : public CWnd
{
	DECLARE_DYNAMIC(CInfoWnd)

public:
	CInfoWnd();
	virtual ~CInfoWnd();

#ifndef _WINVER_XP

	void d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush);
	void d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush);
	void d2d1TextPushPop(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush);

	void CreateD2d1Resources();
	void DiscardD2d1Resources();

	HRESULT CreateDeviceIndependentResources();
	void DiscardDeviceIndependentResources();
	HRESULT CreateDeviceResources(void);
	void DiscardDeviceResources();
	void CreateTextFormat();
	void DiscardTextFormat();

#endif

protected:
	DECLARE_MESSAGE_MAP()

public:

	CString m_sDebugString;

#ifndef _WINVER_XP
	ID2D1Factory *g_pD2DFactory;
	IDWriteFactory *g_pDWriteFactory;
	ID2D1HwndRenderTarget *g_pRenderTarget;
	IDWriteTextFormat *g_pTextFormat;
	ID2D1SolidColorBrush *g_pBackBrush;

	UINT32 m_D2DcolBack;

	ID2D1SolidColorBrush *g_pItemBrush;
	ID2D1SolidColorBrush *g_pDataBrush;
	ID2D1SolidColorBrush *g_pLabelBrush;
	ID2D1SolidColorBrush *g_pInfoTimeBrush;

	ID2D1SolidColorBrush *g_pListNormalBrush;
	ID2D1SolidColorBrush *g_pListSystemBrush;
	ID2D1SolidColorBrush *g_pListReadonlyBrush;
	ID2D1SolidColorBrush *g_pListHideBrush;
	ID2D1SolidColorBrush *g_pListDirBrush;

	ID2D1SolidColorBrush *g_pFrameBrush;
#endif

	CFmParam* m_pFmParam;
	CFileView *m_pFileView;

	int m_FontHeight;	// \tHg̍
	int m_FontWidth;	// \tHg̕
	int m_CurrentFileNo;	// Jgt@CNo.

	bool m_bLongNameMode;	// pX܂̓t@CEBhE𒴂ĂꍇA
							// pXƃt@Ĉ݂2s\ɂ郂[h  true:2s\

	int m_MciWindowPosX;

	int m_nVolXsize;	// Volume Label \

	void DrawInfo(bool all = false);
#ifndef _WINVER_XP
	void DrawInfoDirectWrite(void);
#endif

	int AdjustFileNameLength(CString fname, int xw);

	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnChangeLongNameMode(void);
	afx_msg void OnMenuKeyH(void);
	afx_msg void OnMenuKeyN(void);
	afx_msg void OnMenuCtrlKeyT(void);
	afx_msg void OnMenuShiftKeyV(void);
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
};


