// InfoWnd.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "InfoWnd.h"
#include "FileView.h"
#include "ChildView.h"

#include "io.h"
#include <time.h>

#define ID_LONG_NAME_MODE	100

// CInfoWnd

IMPLEMENT_DYNAMIC(CInfoWnd, CWnd)

CInfoWnd::CInfoWnd()
{
	m_CurrentFileNo = 0;
	m_MciWindowPosX = 0;
	m_bLongNameMode = false;
//	m_bEnableLNM = false;

//	if (m_pFmParam->m_bSystemDirectWrite) {
//		CoInitialize(NULL);
//	}

#ifndef _WINVER_XP

	g_pDWriteFactory = NULL;
	g_pD2DFactory = NULL;
	g_pTextFormat = NULL;

	g_pRenderTarget = NULL;
	g_pBackBrush = NULL;

	g_pItemBrush = NULL;
	g_pDataBrush = NULL;
	g_pLabelBrush = NULL;
	g_pInfoTimeBrush = NULL;

	g_pListNormalBrush = NULL;
	g_pListSystemBrush = NULL;
	g_pListReadonlyBrush = NULL;
	g_pListHideBrush = NULL;
	g_pListDirBrush = NULL;

	g_pFrameBrush = NULL;

#endif

}

CInfoWnd::~CInfoWnd()
{

#ifndef _WINVER_XP
		DiscardD2d1Resources();
#endif

}


BEGIN_MESSAGE_MAP(CInfoWnd, CWnd)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_RBUTTONDOWN()

	ON_COMMAND(ID_LONG_NAME_MODE, &CInfoWnd::OnChangeLongNameMode)
	ON_COMMAND(ID_KEY_H, &CInfoWnd::OnMenuKeyH)
	ON_COMMAND(ID_KEY_N, &CInfoWnd::OnMenuKeyN)
	ON_COMMAND(ID_CTRL_KEY_T, &CInfoWnd::OnMenuCtrlKeyT)
	ON_COMMAND(ID_SHIFT_KEY_V, &CInfoWnd::OnMenuShiftKeyV)

	ON_WM_TIMER()
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()


#ifndef _WINVER_XP

void CInfoWnd::CreateD2d1Resources()
{
	CreateDeviceIndependentResources();
	CreateTextFormat();
	CreateDeviceResources();
}

void CInfoWnd::DiscardD2d1Resources()
{
	DiscardDeviceIndependentResources();
	DiscardTextFormat();
	DiscardDeviceResources();

}

HRESULT CInfoWnd::CreateDeviceIndependentResources()
{
	HRESULT result = S_OK;

	D2D1CreateFactory(
		D2D1_FACTORY_TYPE_SINGLE_THREADED,
		&g_pD2DFactory);

	DWriteCreateFactory(
		DWRITE_FACTORY_TYPE_SHARED,
		__uuidof(g_pDWriteFactory),
		(IUnknown **)(&g_pDWriteFactory));


	return result;
}

void CInfoWnd::DiscardDeviceIndependentResources()
{

	if (g_pDWriteFactory != NULL) {
		g_pDWriteFactory->Release();
		g_pDWriteFactory = NULL;

	}

	if (g_pD2DFactory != NULL) {
		g_pD2DFactory->Release();
		g_pD2DFactory = NULL;

	}


}

void CInfoWnd::CreateTextFormat()
{

	if (g_pDWriteFactory == NULL) return;

	if (g_pTextFormat != NULL) return;

	CClientDC dc(AfxGetMainWnd());
	int logpix = dc.GetDeviceCaps(LOGPIXELSY);

	CString fontname = m_pFmParam->m_logfontInfo.lfFaceName;
	int nPoint = -::MulDiv(m_pFmParam->m_logfontInfo.lfHeight, 72, logpix);

	FLOAT fs = logpix * (FLOAT)nPoint / 72;
	int ifs = (INT)(fs + 1.99) / 2;
	FLOAT dip = (FLOAT)(ifs * 2);

	g_pDWriteFactory->CreateTextFormat(
		//		L"Verdana",
		fontname,
		NULL,
		DWRITE_FONT_WEIGHT_NORMAL,
		DWRITE_FONT_STYLE_NORMAL,
		DWRITE_FONT_STRETCH_NORMAL,
		//		50,	// tHgTCY
		dip,
		L"", //locale
		&g_pTextFormat);

	g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_LEADING);
	// g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_CENTER);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_NEAR);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_CENTER);

	m_FontHeight = (int)(g_pTextFormat->GetFontSize());

	FLOAT dpiX, dpiY;
	g_pD2DFactory->GetDesktopDpi(&dpiX, &dpiY);

	m_sDebugString.Format(_T("FontName = %s\nDPIX = %2.1f\nDPIY = %2.1f\ndip = %2.1f\nFontHeight = %4d"), fontname, dpiX, dpiY, dip, m_FontHeight);


}

void CInfoWnd::DiscardTextFormat()
{
	if (g_pTextFormat == NULL) return;

	g_pTextFormat->Release();
	g_pTextFormat = NULL;

}


HRESULT CInfoWnd::CreateDeviceResources(void)
{
	HRESULT hr = S_OK;

	if (g_pRenderTarget != NULL) {
		return hr;
	}

	RECT rc;
	GetClientRect(&rc);

	D2D1_SIZE_U size = D2D1::SizeU(
		rc.right - rc.left,
		rc.bottom - rc.top
		);

	// Create a Direct2D render target.
	g_pD2DFactory->CreateHwndRenderTarget(
		D2D1::RenderTargetProperties(),
		D2D1::HwndRenderTargetProperties(m_hWnd, size),
		&g_pRenderTarget
		);

	COLORREF colBack = m_pFmParam->m_colBack;

	COLORREF colLabel = m_pFmParam->m_colInfoLabel;
	COLORREF colItem = m_pFmParam->m_colInfoItem;
	COLORREF colData = m_pFmParam->m_colInfoData;
	COLORREF colTime = m_pFmParam->m_colInfoTime;

	COLORREF colListNormal = m_pFmParam->m_colListNormal;	// ʏt@C\F
	COLORREF colListSystem = m_pFmParam->m_colListSystem;	// VXet@C\F
	COLORREF colListReadonly = m_pFmParam->m_colListReadonly;	// [hI[t@C\F
	COLORREF colListHide = m_pFmParam->m_colListHide;		// Bt@C\F
	COLORREF colListDir = m_pFmParam->m_colListDir;		// tH_\F

	COLORREF colFrame = m_pFmParam->m_colFrame;


	// Create a back brush.
	BYTE r, g, b;
	r = colBack & 0xff;
	g = (colBack >> 8) & 0xff;
	b = (colBack >> 16) & 0xff;

	UINT32 rgb;
	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pBackBrush
		);

	m_D2DcolBack = rgb;

	r = colLabel & 0xff;
	g = (colLabel >> 8) & 0xff;
	b = (colLabel >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pLabelBrush);

	r = colData & 0xff;
	g = (colData >> 8) & 0xff;
	b = (colData >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pDataBrush);

	r = colItem & 0xff;
	g = (colItem >> 8) & 0xff;
	b = (colItem >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pItemBrush);

	r = colTime & 0xff;
	g = (colTime >> 8) & 0xff;
	b = (colTime >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pInfoTimeBrush);

	r = colListNormal & 0xff;
	g = (colListNormal >> 8) & 0xff;
	b = (colListNormal >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListNormalBrush);


	r = colListSystem & 0xff;
	g = (colListSystem >> 8) & 0xff;
	b = (colListSystem >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListSystemBrush);

	r = colListReadonly & 0xff;
	g = (colListReadonly >> 8) & 0xff;
	b = (colListReadonly >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListReadonlyBrush);


	r = colListHide & 0xff;
	g = (colListHide >> 8) & 0xff;
	b = (colListHide >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListHideBrush);

	r = colListDir & 0xff;
	g = (colListDir >> 8) & 0xff;
	b = (colListDir >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListDirBrush);

	r = colFrame & 0xff;
	g = (colFrame >> 8) & 0xff;
	b = (colFrame >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pFrameBrush);


	return hr;
}

void CInfoWnd::DiscardDeviceResources()
{
	if (g_pRenderTarget != NULL) {
		g_pRenderTarget->Release();
		g_pRenderTarget = NULL;

	}

	if (g_pBackBrush != NULL) {
		g_pBackBrush->Release();
		g_pBackBrush = NULL;
	}

	if (g_pLabelBrush != NULL) {
		g_pLabelBrush->Release();
		g_pLabelBrush = NULL;
	}
	if (g_pItemBrush != NULL) {
		g_pItemBrush->Release();
		g_pItemBrush = NULL;
	}
	if (g_pDataBrush != NULL) {
		g_pDataBrush->Release();
		g_pDataBrush = NULL;
	}

	if (g_pInfoTimeBrush != NULL) {
		g_pInfoTimeBrush->Release();
		g_pInfoTimeBrush = NULL;
	}

	if (g_pListNormalBrush != NULL) {
		g_pListNormalBrush->Release();
		g_pListNormalBrush = NULL;
	}

	if (g_pListSystemBrush != NULL) {
		g_pListSystemBrush->Release();
		g_pListSystemBrush = NULL;
	}

	if (g_pListReadonlyBrush != NULL) {
		g_pListReadonlyBrush->Release();
		g_pListReadonlyBrush = NULL;
	}

	if (g_pListHideBrush != NULL) {
		g_pListHideBrush->Release();
		g_pListHideBrush = NULL;
	}

	if (g_pListDirBrush != NULL) {
		g_pListDirBrush->Release();
		g_pListDirBrush = NULL;
	}

	if (g_pFrameBrush != NULL) {
		g_pFrameBrush->Release();
		g_pFrameBrush = NULL;
	}


}

void CInfoWnd::d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = CA2W(strA);

	int len = sText.GetLength();
	int glen = strA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		//		D2D1::RectF(fX, fY, (FLOAT)rc.right, fY + lh),
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

}

void CInfoWnd::d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = strW;

	CStringA sA;
	sA = CW2A(strW);

	int len = sText.GetLength();
	int glen = sA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + (glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

}

void CInfoWnd::d2d1TextPushPop(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = strW;

	CStringA sA;
	sA = CW2A(strW);

	int len = sText.GetLength();
	int glen = sA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->PushAxisAlignedClip(
		D2D1::RectF(fX, fY, fX + (glen * m_FontWidth), fY + lh),
		D2D1_ANTIALIAS_MODE_PER_PRIMITIVE
		);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + (glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

	g_pRenderTarget->PopAxisAlignedClip();

}

#endif




// CInfoWnd bZ[W nh



BOOL CInfoWnd::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B


// #ifndef _DIRECT_WRITE

	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		// uV̍쐬
		CBrush brush(m_pFmParam->m_colBack);
		// VuVw(̃uV̕ۑ)
		CBrush* pOldBrush = pDC->SelectObject(&brush);

		// hԂ̈擾
		CRect rect;
		GetClientRect(&rect);

		CPen pen(PS_SOLID, 0, m_pFmParam->m_colFrame);
		CPen* pOldPen = pDC->SelectObject(&pen);

		CFont font;
		font.CreateFontIndirect(&(m_pFmParam->m_logfontInfo));
		CFont* pOldFont = pDC->SelectObject(&font);

		CString cs;
		cs = "W";
		CSize size = pDC->GetTextExtent(cs);

		int fw, fh;
		fw = size.cx;
		fh = size.cy + 1;

		// hԂ
		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

		rect.top += ((fh / 2) - 1);
		rect.right--;
		rect.bottom--;

		POINT pt[5];
		pt[0].x = (rect.left);
		pt[0].y = (rect.top);

		pt[1].x = (rect.right);
		pt[1].y = (rect.top);

		pt[2].x = (rect.right);
		pt[2].y = (rect.bottom);

		pt[3].x = (rect.left);
		pt[3].y = (rect.bottom);

		pt[4].x = (rect.left);
		pt[4].y = (rect.top);

		pDC->Polyline((const POINT*)&pt, 5);

		// uVɖ߂
		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
		pDC->SelectObject(pOldFont);
	}

// #endif

	return TRUE;

//	return CWnd::OnEraseBkgnd(pDC);
}

void CInfoWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: ɃbZ[W nh R[hǉ܂B
	// `惁bZ[W CWnd::OnPaint() ĂяoȂłB

// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		DrawInfoDirectWrite();
#endif

	}

// #endif

// #ifndef _DIRECT_WRITE
	
	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		DrawInfo(true);
	}

// #endif


}

void CInfoWnd::DrawInfo(bool all)
{
	if ( m_CurrentFileNo == -1 ) return;
	CClientDC dc(this);

	CRect rect;
    GetClientRect(&rect);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
	CFont* pOldFont = dc.SelectObject(&font);

	CBrush brush(m_pFmParam->m_colBack);
    CBrush* pOldBrush = dc.SelectObject(&brush);

	int fw, fh;
	TEXTMETRIC tm;

	GetTextMetrics(dc, &tm);
	fh = m_FontHeight = tm.tmHeight;
	fw = m_FontWidth = tm.tmAveCharWidth + 1;


	COLORREF colitem = m_pFmParam->m_colInfoItem;
	COLORREF coldata = m_pFmParam->m_colInfoData;
	COLORREF colLabel = m_pFmParam->m_colInfoLabel;

	dc.SetBkColor(m_pFmParam->m_colBack);

	int x, y, xof, yof, xd;
	xof = 4;
	yof = fh + 2;
	x = xof;
	y = yof;

	CString s, ts, ts2, form;
	CSize sizew;
	CRect rc, crc;

	CString cpath, root;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	root = cpath.Left(3);

	wchar_t volume[50];
	wchar_t fsname[50];
	DWORD sn, ml, flag;

	volume[0] = 0;
	GetVolumeInformation(root, &volume[0], 50, &sn, &ml, &flag, &fsname[0], 50);

	CString sVolume;
	sVolume.Format(_T("< %-32s "), volume);
	if (m_pFileView->m_bIncSearch) {
		sVolume.Format(_T("< Search Mode:%-20s "), m_pFileView->m_sIncSearchStr);
	}

	if (m_pFileView->m_bInitialSearch) {
		sVolume = _T("< Initial Search                   ");
	}

	if ( all ) {
		sizew = dc.GetTextExtent(sVolume);
		m_nVolXsize = sizew.cx;
	}

	int xv = fw;
	int yv = 0;
	dc.SetTextColor(colLabel);

	if (m_pFileView->m_bIncSearch) {
//		dc.SetTextColor(m_pFmParam->m_colBack);
//		dc.SetBkColor(m_pFmParam->m_colListNormal);
		dc.SetTextColor(m_pFmParam->m_colListNormal);
	}
	if (m_pFileView->m_bInitialSearch) {
		dc.SetTextColor(m_pFmParam->m_colListNormal);
	}

	dc.TextOut(xv, yv, sVolume);
	dc.TextOut(m_nVolXsize, yv, _T(">"));

	dc.SetBkColor(m_pFmParam->m_colBack);

	s = sVolume + _T(">");
	sizew = dc.GetTextExtent(s);
	xd = sizew.cx + 2;


	xd = 0;
	s = _T("path:");
	if ( all ) {
		dc.SetTextColor(colitem);
		dc.TextOut(x + xd, y, s);
	}
	sizew = dc.GetTextExtent(s);
	xd += sizew.cx + 2;

	s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if ( m_pFmParam->m_sWildCard != _T("*.*") ) {
		s += m_pFmParam->m_sWildCard;
	}
	sizew = dc.GetTextExtent(s);
	dc.SetTextColor(coldata);
	rc.left = x + xd;
	rc.top = y;
	rc.bottom = y + sizew.cy;
	rc.right = rect.right - FRAMEOFSET;
	crc = rc;
	crc.right = rect.right - FRAMEOFSET;
	dc.FillRect(&crc, &brush);

	int xw = rc.right - rc.left;
	CString stmp;
	stmp = s;
	int slen = s.GetLength();

	sizew = dc.GetTextExtent(s);

	int len = slen;

	if ( m_bLongNameMode ) {
		len = AdjustFileNameLength(stmp, xw);
		stmp = s.Left(len);
	}
	dc.DrawText(stmp, &rc, DT_LEFT | DT_NOPREFIX);

	if ( m_bLongNameMode ) {
		rc.top += fh;
		rc.bottom += fh;
		dc.FillRect(&rc, &brush);

		if ( len != slen ) {
			stmp = s.Right(slen - len);
			dc.DrawText(stmp, &rc, DT_LEFT | DT_NOPREFIX);
		}
	}

	int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;

	COLORREF col = m_pFmParam->m_colListNormal;
	if ((at & _A_SUBDIR) != 0) col = m_pFmParam->m_colListDir;
	if ((at & _A_RDONLY) != 0) col = m_pFmParam->m_colListReadonly;
	if ((at & _A_HIDDEN) != 0) col = m_pFmParam->m_colListHide;
	if ((at & _A_SYSTEM) != 0) col = m_pFmParam->m_colListSystem;

	y += fh;

	if ( m_bLongNameMode ) y += fh;

	s = _T("name:");
	if ( all ) {
		dc.SetTextColor(colitem);
		dc.TextOut(x, y, s);
	}
	sizew = dc.GetTextExtent(s);
	xd = sizew.cx + 2;
	s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	CString s3, s4;
	s3 = "&";
	s4 = "&&";
	s.Replace(s3, s4);
	if ( m_pFmParam->m_FileNum == 0 ) {
		s = _T("  ");
	}

	dc.SetTextColor(col);
	sizew = dc.GetTextExtent(s);
	rc.left = x + xd;
	rc.top = y;
	rc.bottom = y + sizew.cy;
	rc.right = rect.right - FRAMEOFSET;
	crc = rc;
	crc.right = rect.right - FRAMEOFSET;
	dc.FillRect(&crc, &brush);

	xw = rc.right - rc.left;
	stmp = s;
	slen = s.GetLength();

	sizew = dc.GetTextExtent(s);

	len = slen;
	len = AdjustFileNameLength(stmp, xw);
	stmp = s.Left(len);
	dc.DrawText(stmp, &rc, DT_LEFT);

	if ( m_bLongNameMode ) {
		rc.top += fh;
		rc.bottom += (fh * 2);
		dc.FillRect(&rc, &brush);

		if ( len != slen ) {
			s = s.Right(slen - len);
			stmp = s;
			slen = s.GetLength();
			len = AdjustFileNameLength(stmp, xw);
			stmp = s.Left(len);
			dc.DrawText(stmp, &rc, DT_LEFT);

			if ( len != slen ) {
				s = s.Right(slen - len);
				stmp = s;
				slen = s.GetLength();
				len = AdjustFileNameLength(stmp, xw);
				stmp = s.Left(len);
				rc.top += fh;
				dc.DrawText(stmp, &rc, DT_LEFT);
			}

		}
	} else {

		s = _T("file:");
		y += fh;
		if ( all ) {
			dc.SetTextColor(colitem);
			dc.TextOut(x, y, s);
		}
		sizew = dc.GetTextExtent(s);
		xd = sizew.cx + 2;
		form = _T("%I64d");
		ts.Format(form, m_pFmParam->m_TotalFileSize);
		m_pFmParam->InsertComma(ts);
		form = _T("%I64d");

		CString s2;
		__int64 fnum;
		fnum = m_pFmParam->m_FileNum;
		s2 = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		if ( s2.GetLength() > 3 ) fnum--; 
		if ( fnum < 0 ) fnum = 0;

		ts2.Format(form, fnum); 
		m_pFmParam->InsertComma(ts2);
		form = _T("%17s %6s");
		s.Format(form, ts, ts2);
		dc.SetTextColor(coldata);
		dc.TextOut(x + xd, y, s);
		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		s = _T(" ");
		if ( all ) {
			dc.SetTextColor(colitem);
			dc.TextOut(x + xd, y, s);
		}

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;

		s = _T("free:");
		xd += fw * 2;
		if ( all ) {
			dc.SetTextColor(colitem);
			dc.TextOut(x + xd, y, s);
		}
		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;
		form = _T("%I64d");
		ts.Format(form, m_pFmParam->m_FreeSize);
		m_pFmParam->InsertComma(ts);
		form = _T("%17s   ");
		s.Format(form, ts);
		dc.SetTextColor(coldata);
		dc.TextOut(x + xd, y, s);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		xd += fw * 2;
		s = _T("size: ");
		if (all) {
			dc.SetTextColor(colitem);
			dc.TextOut(x + xd, y, s);
		}

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;


		CString ss;
		int cmode = m_pFmParam->m_DisplayMode;
		__int64 fsize = m_pFmParam->m_pw64FindData[m_CurrentFileNo].size;
//		CString sUnit;
//		sUnit = "";
//		if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) fsize = m_pFmParam->CalcFileSize(fsize, sUnit);
		form = "%I64d";
		s.Format(form, fsize);
		m_pFmParam->InsertComma(s);
		/*
		if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
			if (sUnit.GetLength() != 0) {
				form = "     %8s%2s";
				ss.Format(form, s, sUnit);
			}
			else {
				form = "     %10s";
				ss.Format(form, s);
			}
		}
		*/
//		else {
			form = "%15s";
			ss.Format(form, s);
//		}
		s = ss;

		dc.SetTextColor(coldata);
		dc.TextOut(x + xd, y, s);


		y += fh;
		s = _T("Tag :");
		if ( all ) {
			dc.SetTextColor(colitem);
			dc.TextOut(x, y, s);
		}
		sizew = dc.GetTextExtent(s);
		xd = sizew.cx + 2;
		form = _T("%I64d");
		ts.Format(form, m_pFmParam->m_TagFileSize);
		m_pFmParam->InsertComma(ts);
		form = _T("%d");
		ts2.Format(form, m_pFmParam->m_TagFileNum);
		m_pFmParam->InsertComma(ts2);
		form = _T("%17s %6s");
		s.Format(form, ts, ts2);
		dc.SetTextColor(coldata);
		dc.TextOut(x + xd, y, s);
		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		s = _T(" ");
		if ( all ) {
			dc.SetTextColor(colitem);
			dc.TextOut(x + xd, y, s);
		}

//		int cmode = m_pFmParam->m_DisplayMode;
		int kd = m_pFmParam->m_pFileParam[cmode].m_KindDate;
		__time64_t time;
		CString sTime;

		if ( kd == 0 ) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_create;
		if ( kd == 1 ) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_write;
		if ( kd == 2 ) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_access;

		if (time < 0) time = 0;

		sTime = m_pFmParam->GetTimeStr(time);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		xd += fw * 2;
		s = _T("time:");
		if ( all ) {
			dc.SetTextColor(colitem);
			dc.TextOut(x + xd, y, s);
		}
		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;
		form = _T("%s");
		s.Format(form, sTime);
		dc.SetTextColor(coldata);
		if ( m_pFmParam->m_FileNum == 0 ) {
			s = _T("                     ");
		}
		dc.TextOut(x + xd, y, s);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		xd += fw * 2;
		s = _T(": ");
		if ( all ) {
			dc.SetTextColor(colitem);
			dc.TextOut(x + xd, y, s);
		}

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;

		s = _T("");
		int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;

		if ((at & _A_RDONLY) != 0) s += _T("R ");
		else s += _T("- ");
		if ((at & _A_HIDDEN) != 0) s += _T("H ");
		else s += _T("- ");
		if ((at & _A_SYSTEM) != 0) s += _T("S ");
		else s += _T("- ");
		if ((at & _A_ARCH) != 0) s += _T("A ");
		else s += _T("- ");
		if ((at & _A_SUBDIR) != 0) s += _T("D ");
		else s += _T("- ");

		dc.SetTextColor(coldata);
		dc.TextOut(x + xd, y, s);



	}

	sizew = dc.GetTextExtent(s);
	m_MciWindowPosX = xd + sizew.cx + 20;

	dc.SelectObject(pOldFont);
    dc.SelectObject(pOldBrush);

}

#ifndef _WINVER_XP

void CInfoWnd::DrawInfoDirectWrite(void)
{
	if (m_CurrentFileNo == -1) return;
	CClientDC dc(this);

	CreateTextFormat();
	CreateDeviceResources();

	if (!g_pRenderTarget) return;

	g_pRenderTarget->BeginDraw();

	g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolBack));


	CRect rect;
	GetClientRect(&rect);


	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontInfo));
	CFont* pOldFont = dc.SelectObject(&font);

//	CBrush brush(m_pFmParam->m_colBack);
//	CBrush* pOldBrush = dc.SelectObject(&brush);

	int fw, fh;
//	TEXTMETRIC tm;

//	GetTextMetrics(dc, &tm);
//	fh = m_FontHeight = tm.tmHeight;
//	fw = m_FontWidth = tm.tmAveCharWidth;

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);
	fw = m_FontWidth = size.cx;
	fh = m_FontHeight = size.cy;


//	COLORREF colitem = m_pFmParam->m_colInfoItem;
//	COLORREF coldata = m_pFmParam->m_colInfoData;
//	COLORREF colLabel = m_pFmParam->m_colInfoLabel;

//	dc.SetBkColor(m_pFmParam->m_colBack);

	D2D1_RECT_F d2d1Rect;
	d2d1Rect.top = (FLOAT)rect.top + (fh / 2) - 1;
	d2d1Rect.bottom = (FLOAT)rect.bottom;
	d2d1Rect.left = (FLOAT)rect.left;
	d2d1Rect.right = (FLOAT)rect.right;

	g_pRenderTarget->DrawRectangle(&d2d1Rect, g_pFrameBrush, 2.0F);

	int x, y, xof, yof, xd;
	xof = 4;
	yof = fh + 2;
	x = xof;
	y = yof;

	CString s, ts, ts2, form;
	CSize sizew;
	CRect rc, crc;

	CString cpath, root;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	root = cpath.Left(3);

	wchar_t volume[50];
	wchar_t fsname[50];
	DWORD sn, ml, flag;

	volume[0] = 0;
	GetVolumeInformation(root, &volume[0], 50, &sn, &ml, &flag, &fsname[0], 50);

	CString sVolume;
	sVolume.Format(_T("< %-32s >"), volume);

	int xv = fw;
	int yv = 0;

	if (m_pFileView->m_bIncSearch) {
		sVolume.Format(_T("< Search Mode:%-20s >"), m_pFileView->m_sIncSearchStr);
		d2d1DrawTextW(xv, yv, sVolume, g_pListNormalBrush, g_pBackBrush);
	}
	else {

		if (m_pFileView->m_bInitialSearch) {
			sVolume = _T("< Initial Search                   >");
			d2d1DrawTextW(xv, yv, sVolume, g_pListNormalBrush, g_pBackBrush);
		}
		else {
			d2d1DrawTextW(xv, yv, sVolume, g_pLabelBrush, g_pBackBrush);

		}


	}

	CStringA sA;
	sA = CW2A(sVolume);
	m_nVolXsize = sVolume.GetLength() * fw;

//	if (all) {
//		sizew = dc.GetTextExtent(sVolume);
//		m_nVolXsize = sizew.cx;
//	}

//	int xv = fw;
//	int yv = 0;
//	dc.SetTextColor(colLabel);

//	if (m_pFileView->m_bIncSearch) {
//		dc.SetTextColor(m_pFmParam->m_colListNormal);
//	}

//	dc.TextOut(xv, yv, sVolume);
//	dc.TextOut(m_nVolXsize, yv, _T(">"));


//	dc.SetBkColor(m_pFmParam->m_colBack);


	xd = 0;
	s = _T("path:");

	d2d1DrawTextW(x + xd, y, s, g_pItemBrush, g_pBackBrush);

//	if (all) {
//		dc.SetTextColor(colitem);
//		dc.TextOut(x + xd, y, s);
//	}
	sizew = dc.GetTextExtent(s);
	xd += sizew.cx + 2;

	s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if (m_pFmParam->m_sWildCard != _T("*.*")) {
		s += m_pFmParam->m_sWildCard;
	}
	sizew = dc.GetTextExtent(s);

//	dc.SetTextColor(coldata);
	rc.left = x + xd;
	rc.top = y;
//	rc.bottom = y + sizew.cy;
	rc.right = rect.right - FRAMEOFSET;
//	crc = rc;
//	crc.right = rect.right - FRAMEOFSET;
//	dc.FillRect(&crc, &brush);

	int xw = rc.right - rc.left;
	CString stmp;
	stmp = s;
	int slen = s.GetLength();

	sizew = dc.GetTextExtent(s);

	int len = slen;

	if (m_bLongNameMode) {
		len = AdjustFileNameLength(stmp, xw);
		stmp = s.Left(len);
	}
//	dc.DrawText(stmp, &rc, DT_LEFT | DT_NOPREFIX);

	d2d1DrawTextW(fw * 6, y, stmp, g_pDataBrush, g_pBackBrush);

	if (m_bLongNameMode) {
		rc.top += fh;
//		rc.bottom += fh;
//		dc.FillRect(&rc, &brush);

		if (len != slen) {
			stmp = s.Right(slen - len);
//			dc.DrawText(stmp, &rc, DT_LEFT | DT_NOPREFIX);
			d2d1DrawTextW(fw * 6, y + fh, stmp, g_pDataBrush, g_pBackBrush);
		}
	}

	int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;

//	COLORREF col = m_pFmParam->m_colListNormal;
//	if ((at & _A_SUBDIR) != 0) col = m_pFmParam->m_colListDir;
//	if ((at & _A_RDONLY) != 0) col = m_pFmParam->m_colListReadonly;
//	if ((at & _A_HIDDEN) != 0) col = m_pFmParam->m_colListHide;
//	if ((at & _A_SYSTEM) != 0) col = m_pFmParam->m_colListSystem;

	ID2D1SolidColorBrush *colBrush;

	colBrush = g_pListNormalBrush;
	if ((at & _A_SUBDIR) != 0) colBrush = g_pListDirBrush;
	if ((at & _A_RDONLY) != 0) colBrush = g_pListReadonlyBrush;
	if ((at & _A_HIDDEN) != 0) colBrush = g_pListHideBrush;
	if ((at & _A_SYSTEM) != 0) colBrush = g_pListSystemBrush;

	y += fh;

	if (m_bLongNameMode) y += fh;

	s = _T("name:");
//	if (all) {
//		dc.SetTextColor(colitem);
//		dc.TextOut(x, y, s);
//	}
	d2d1DrawTextW(x, y, s, g_pItemBrush, g_pBackBrush);


	sizew = dc.GetTextExtent(s);
	xd = sizew.cx + 2;
	s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

//	CString s3, s4;
//	s3 = "&";
//	s4 = "&&";
//	s.Replace(s3, s4);
	if (m_pFmParam->m_FileNum == 0) {
		s = _T("  ");
	}

//	dc.SetTextColor(col);
	sizew = dc.GetTextExtent(s);
	rc.left = x + xd;
	rc.top = y;
	rc.bottom = y + sizew.cy;
	rc.right = rect.right - FRAMEOFSET;
	crc = rc;
	crc.right = rect.right - FRAMEOFSET;
//	dc.FillRect(&crc, &brush);

	xw = rc.right - rc.left;
	stmp = s;
	slen = s.GetLength();

	sizew = dc.GetTextExtent(s);

	len = slen;
	len = AdjustFileNameLength(stmp, xw);
	stmp = s.Left(len);
//	dc.DrawText(stmp, &rc, DT_LEFT);

	d2d1DrawTextW(fw * 6, y, stmp, colBrush, g_pBackBrush);

	if (m_bLongNameMode) {
		rc.top += fh;
		rc.bottom += (fh * 2);
//		dc.FillRect(&rc, &brush);

		if (len != slen) {
			s = s.Right(slen - len);
			stmp = s;
			slen = s.GetLength();
			len = AdjustFileNameLength(stmp, xw);
			stmp = s.Left(len);
//			dc.DrawText(stmp, &rc, DT_LEFT);

			d2d1DrawTextW(fw * 6, y + fh, stmp, colBrush, g_pBackBrush);

			if (len != slen) {
				s = s.Right(slen - len);
				stmp = s;
				slen = s.GetLength();
				len = AdjustFileNameLength(stmp, xw);
				stmp = s.Left(len);
				rc.top += fh;
//				dc.DrawText(stmp, &rc, DT_LEFT);

				d2d1DrawTextW(fw * 6, rc.top, stmp, colBrush, g_pBackBrush);
			}

		}
	}
	else {

		s = _T("file:");
		y += fh;
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x, y, s);
//		}
		d2d1DrawTextW(x, y, s, g_pItemBrush, g_pBackBrush);

		sizew = dc.GetTextExtent(s);
		xd = sizew.cx + 2;
		form = _T("%I64d");
		ts.Format(form, m_pFmParam->m_TotalFileSize);
		m_pFmParam->InsertComma(ts);
		form = _T("%I64d");

		CString s2;
		__int64 fnum;
		fnum = m_pFmParam->m_FileNum;
		s2 = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		if (s2.GetLength() > 3) fnum--;
		if (fnum < 0) fnum = 0;

		ts2.Format(form, fnum);
		m_pFmParam->InsertComma(ts2);
		form = _T("%17s %6s");
		s.Format(form, ts, ts2);
//		dc.SetTextColor(coldata);
//		dc.TextOut(x + xd, y, s);


		d2d1DrawTextW(fw * 6, y, s, g_pDataBrush, g_pBackBrush);

		CString sA;
		sA = CW2A(s);
		int la = sA.GetLength();
		int xa = (la + 6) * fw;

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		s = _T(" ");
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x + xd, y, s);
//		}
		d2d1DrawTextW(xa, y, s, g_pItemBrush, g_pBackBrush);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;

		s = _T("free:");
		xd += fw * 2;
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x + xd, y, s);
//		}

		xa += fw * 5;
		d2d1DrawTextW(xa, y, s, g_pItemBrush, g_pBackBrush);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;
		form = _T("%I64d");
		ts.Format(form, m_pFmParam->m_FreeSize);
		m_pFmParam->InsertComma(ts);
		form = _T("%17s   ");
		s.Format(form, ts);
//		dc.SetTextColor(coldata);
//		dc.TextOut(x + xd, y, s);

		xa += fw * 6;

		d2d1DrawTextW(xa, y, s, g_pDataBrush, g_pBackBrush);

		sA = CW2A(s);
		la = sA.GetLength();
		xa += (la + 2) * fw;

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		xd += fw * 2;
		s = _T("size: ");
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x + xd, y, s);
//		}


		d2d1DrawTextW(xa, y, s, g_pItemBrush, g_pBackBrush);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;


		CString ss;
		int cmode = m_pFmParam->m_DisplayMode;
		__int64 fsize = m_pFmParam->m_pw64FindData[m_CurrentFileNo].size;
		form = "%I64d";
		s.Format(form, fsize);
		m_pFmParam->InsertComma(s);
		form = "%15s";
		ss.Format(form, s);
		s = ss;

//		dc.SetTextColor(coldata);
//		dc.TextOut(x + xd, y, s);

		xa += fw * 6;

		d2d1DrawTextW(xa, y, s, g_pDataBrush, g_pBackBrush);

		y += fh;
		s = _T("Tag :");
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x, y, s);
//		}

		d2d1DrawTextW(x, y, s, g_pItemBrush, g_pBackBrush);

		sizew = dc.GetTextExtent(s);
		xd = sizew.cx + 2;
		form = _T("%I64d");
		ts.Format(form, m_pFmParam->m_TagFileSize);
		m_pFmParam->InsertComma(ts);
		form = _T("%d");
		ts2.Format(form, m_pFmParam->m_TagFileNum);
		m_pFmParam->InsertComma(ts2);
		form = _T("%17s %6s");
		s.Format(form, ts, ts2);
//		dc.SetTextColor(coldata);
//		dc.TextOut(x + xd, y, s);


		d2d1DrawTextW(fw * 6, y, s, g_pDataBrush, g_pBackBrush);

		sA = CW2A(s);
		la = sA.GetLength();
		xa = (la + 6) * fw;


		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		s = _T(" ");
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x + xd, y, s);
//		}

		d2d1DrawTextW(xa, y, s, g_pItemBrush, g_pBackBrush);

		//		int cmode = m_pFmParam->m_DisplayMode;
		int kd = m_pFmParam->m_pFileParam[cmode].m_KindDate;
		__time64_t time;
		CString sTime;

		if (kd == 0) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_create;
		if (kd == 1) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_write;
		if (kd == 2) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_access;

		if (time < 0) time = 0;

		sTime = m_pFmParam->GetTimeStr(time);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		xd += fw * 2;
		s = _T("time:");
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x + xd, y, s);
//		}

		xa += fw * 5;
		d2d1DrawTextW(xa, y, s, g_pItemBrush, g_pBackBrush);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;
		form = _T("%s");
		s.Format(form, sTime);
//		dc.SetTextColor(coldata);
		if (m_pFmParam->m_FileNum == 0) {
			s = _T("                     ");
		}
//		dc.TextOut(x + xd, y, s);

		xa += fw * 6;
		d2d1DrawTextW(xa, y, s, g_pDataBrush, g_pBackBrush);

		sA = CW2A(s);
		la = sA.GetLength();
		xa += (la + 2) * fw;

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx;
		xd += fw * 2;
		s = _T(": ");
//		if (all) {
//			dc.SetTextColor(colitem);
//			dc.TextOut(x + xd, y, s);
//		}

		d2d1DrawTextW(xa, y, s, g_pItemBrush, g_pBackBrush);

		sizew = dc.GetTextExtent(s);
		xd += sizew.cx + 2;

		s = _T("");
		int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;

		if ((at & _A_RDONLY) != 0) s += _T("R ");
		else s += _T("- ");
		if ((at & _A_HIDDEN) != 0) s += _T("H ");
		else s += _T("- ");
		if ((at & _A_SYSTEM) != 0) s += _T("S ");
		else s += _T("- ");
		if ((at & _A_ARCH) != 0) s += _T("A ");
		else s += _T("- ");
		if ((at & _A_SUBDIR) != 0) s += _T("D ");
		else s += _T("- ");

//		dc.SetTextColor(coldata);
//		dc.TextOut(x + xd, y, s);

		xa += fw * 6;
		d2d1DrawTextW(x + xd, y, s, g_pDataBrush, g_pBackBrush);


	}

	sizew = dc.GetTextExtent(s);
	m_MciWindowPosX = xd + sizew.cx + 20;

//	dc.SelectObject(pOldFont);
//	dc.SelectObject(pOldBrush);


	xof = 4;
	yof = fh + 2;

	time_t tnow = time(NULL);
	struct tm tmNow;
	localtime_s(&tmNow, &tnow);

	if (m_pFmParam->m_bSettingsDrawSec) {
		s.Format(_T(" %04d-%02d-%02d %02d:%02d:%02d "), tmNow.tm_year + 1900, tmNow.tm_mon + 1, tmNow.tm_mday,
			tmNow.tm_hour, tmNow.tm_min, tmNow.tm_sec);
	}
	else {
		s.Format(_T(" %04d-%02d-%02d %02d:%02d "), tmNow.tm_year + 1900, tmNow.tm_mon + 1, tmNow.tm_mday,
			tmNow.tm_hour, tmNow.tm_min);

	}

	x = fw * 5;
	y = 0;
	x += m_nVolXsize;

	d2d1DrawTextW(x, y, s, g_pInfoTimeBrush, g_pBackBrush);

	sA = CW2A(s);
	int la = sA.GetLength();
	int xa = (la + 2) * fw + x;

	SYSTEM_POWER_STATUS PStatus;
	GetSystemPowerStatus(&PStatus);

	int bf = PStatus.BatteryFlag;
	int bac = PStatus.ACLineStatus;

	if (bf < 128) {

		if (bac == 1) {	// ACIC
			s.Format(_T(" [ %03d%% <- AC ] "), PStatus.BatteryLifePercent);
		}
		else {
			int tbl = PStatus.BatteryLifeTime;
			if (tbl < 0) s.Format(_T(" [ %03d%% --:-- ] "), PStatus.BatteryLifePercent);
			else {
				int th = 0;
				int tm = tbl / 60;
				if (tm >= 60) {
					th = tm / 60;
					tm -= (th * 60);
				}
				s.Format(_T(" [ %03d%% %02d:%02d ] "), PStatus.BatteryLifePercent, th, tm);
			}
		}

		d2d1TextPushPop(xa, y, s, g_pItemBrush, g_pBackBrush);
	}

	g_pRenderTarget->EndDraw();

}
#endif


int CInfoWnd::AdjustFileNameLength(CString fname, int xw)
{
	CClientDC dc(this);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontInfo));
	CFont* pOldFont = dc.SelectObject(&font);


	CSize cs;
	int len = fname.GetLength();
	CString sn;

	while (1) {
		sn = fname.Left(len);
		cs = dc.GetTextExtent(sn);
		if ( cs.cx < xw ) {
			break;
		}

		len--;
		if ( len < 0 ) {
			len = fname.GetLength();
			break;
		}
	}

	dc.SelectObject(pOldFont);

	return len;

}

void CInfoWnd::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B


	CMenu pRmenu;
	pRmenu.CreatePopupMenu();
	pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_LONG_NAME_MODE ,_T("t@CƃpX𕡐s\ɂ(&L)"));
	pRmenu.AppendMenu(MF_SEPARATOR);
	pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_KEY_H ,_T("JgtH_̕ύX(&H)"));
	pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_KEY_N ,_T("t@C̕ύX(&N)"));
	pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_CTRL_KEY_T ,_T("^CX^v̕ύX(&T)"));
	pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_SHIFT_KEY_V ,_T("{[x̕ύX(&V)"));

	if ( m_bLongNameMode) pRmenu.CheckMenuItem(ID_LONG_NAME_MODE, MF_CHECKED);
	else pRmenu.CheckMenuItem(ID_LONG_NAME_MODE, MF_UNCHECKED);

	CString fname;
	fname =  m_pFmParam->m_pw64FindData[m_pFileView->m_CurrentFileNo].name;
	if ( fname == _T("..") ) {
		pRmenu.EnableMenuItem(ID_KEY_N, MF_GRAYED);
		pRmenu.EnableMenuItem(ID_CTRL_KEY_T, MF_GRAYED);
	}

	ClientToScreen(&point);
	pRmenu.TrackPopupMenu(
		TPM_LEFTALIGN  |	//NbNXWj[̍ӂɂ
		TPM_RIGHTBUTTON,	//ENbNŃj[I\Ƃ
		point.x,point.y,	//j[̕\ʒu
		this            	//̃j[LEBhE
	);
	pRmenu.DestroyMenu();

	m_pFileView->SetFindNotify();

	CWnd::OnRButtonDown(nFlags, point);
}

void CInfoWnd::OnChangeLongNameMode(void)
{
	if ( m_bLongNameMode) {
		m_bLongNameMode = false;
		m_pFmParam->m_InfoHeight = INFOWNDHEIGHT;
	} else {
		m_bLongNameMode = true;
		m_pFmParam->m_InfoHeight = INFOWNDHEIGHT + 1;
	}
	m_pFileView->m_pChildView->ResizeWindow();
//	Invalidate();

}

void CInfoWnd::OnMenuKeyH(void)
{
	m_pFileView->OnMenuKeyH();
}

void CInfoWnd::OnMenuKeyN(void)
{
//	m_pFileView->OnMenuKeyN();
}

void CInfoWnd::OnMenuCtrlKeyT(void)
{
	m_pFileView->OnMenuCtrlKeyT();
}

void CInfoWnd::OnMenuShiftKeyV(void)
{
//	m_pFileView->OnMenuShiftKeyV();
}

void CInfoWnd::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CClientDC dc(this);

    CRect rect;
    GetClientRect(&rect);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontInfo));
	CFont* pOldFont = dc.SelectObject(&font);

	CBrush brush(m_pFmParam->m_colBack);
    CBrush* pOldBrush = dc.SelectObject(&brush);

//	m_bEnableLNM = false;

	int fw, fh;
//	TEXTMETRIC tm;

//	GetTextMetrics(dc, &tm);
//	fh = m_FontHeight = tm.tmHeight;
//	fw = m_FontWidth = tm.tmAveCharWidth;

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);
	fw = m_FontWidth = size.cx;
	fh = m_FontHeight = size.cy;

	COLORREF colitem = m_pFmParam->m_colInfoItem;
	COLORREF coldata = m_pFmParam->m_colInfoData;

	dc.SetBkColor(m_pFmParam->m_colBack);

	int x, y, xof, yof;
	xof = 4;
	yof = fh + 2;

	CString s;

	time_t tnow = time(NULL);
	struct tm tmNow;
	localtime_s(&tmNow, &tnow);

	if (m_pFmParam->m_bSettingsDrawSec) {
		s.Format(_T(" %04d-%02d-%02d %02d:%02d:%02d "), tmNow.tm_year + 1900, tmNow.tm_mon + 1, tmNow.tm_mday,
			tmNow.tm_hour, tmNow.tm_min, tmNow.tm_sec);
	}
	else {
		s.Format(_T(" %04d-%02d-%02d %02d:%02d "), tmNow.tm_year + 1900, tmNow.tm_mon + 1, tmNow.tm_mday,
			tmNow.tm_hour, tmNow.tm_min);

	}

	x = fw * 5;
	y = 0;
	x += m_nVolXsize;

	dc.SetTextColor(m_pFmParam->m_colInfoTime);
// #ifndef _DIRECT_WRITE
	
	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		dc.TextOut(x, y, s);
	}

// #endif


// #ifdef _DIRECT_WRITE
	
	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		g_pRenderTarget->BeginDraw();

		d2d1TextPushPop(x, y, s, g_pInfoTimeBrush, g_pBackBrush);
#endif

	}

// #endif



	SYSTEM_POWER_STATUS PStatus;
	GetSystemPowerStatus(&PStatus);

	int bf = PStatus.BatteryFlag;
	int bac = PStatus.ACLineStatus;

	if ( bf < 128 ) {
		CSize csize = dc.GetTextExtent(s);
		x += (csize.cx + (fw * 2));

		if ( bac == 1 ) {	// ACIC
			s.Format(_T(" [ %03d%% <- AC ] "), PStatus.BatteryLifePercent);
		} else {
			int tbl = PStatus.BatteryLifeTime;
			if ( tbl < 0 ) s.Format(_T(" [ %03d%% --:-- ] "), PStatus.BatteryLifePercent);
			else {
				int th = 0;
				int tm = tbl / 60;
				if ( tm >= 60 ) {
					th = tm / 60;
					tm -= (th * 60);
				}
				s.Format(_T(" [ %03d%% %02d:%02d ] "), PStatus.BatteryLifePercent, th, tm);
			}
		}
		dc.SetTextColor(m_pFmParam->m_colInfoItem);

// #ifndef _DIRECT_WRITE

		if (!(m_pFmParam->m_bSystemDirectWrite)) {
			dc.TextOut(x, y, s);
		}

// #endif


// #ifdef _DIRECT_WRITE

		if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
			d2d1TextPushPop(x, y, s, g_pItemBrush, g_pBackBrush);
#endif

		}

// #endif
	}

	dc.SelectObject(pOldFont);
    dc.SelectObject(pOldBrush);

// #ifdef _DIRECT_WRITE
	
	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		g_pRenderTarget->EndDraw();
#endif

	}

// #endif

  CWnd::OnTimer(nIDEvent);
}

int CInfoWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB

	SetTimer(2, 500, NULL);

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		CreateDeviceIndependentResources();
#endif

	}

	return 0;
}


void CInfoWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B


	CWnd::OnLButtonDown(nFlags, point);
}


void CInfoWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	m_pFileView->CmdKeyShiftHome();

	CWnd::OnLButtonDblClk(nFlags, point);
}
