#include "StdAfx.h"
#include "FmParam.h"
#include "FileParam.h"
#include "DriveParam.h"


#include "io.h"
#include <locale.h>


#include <Winioctl.h>
#include <mmsystem.h>

// #include <windows.h>
// #include <setupapi.h> // SetupDixxx
// #include <Cfgmgr32.h> // CM_Get_xxx
// #include <initguid.h>
// #include <usbiodef.h>

#include "winbase.h"

#include "Shlwapi.h"

#include "Resource.h"
#include "SelectCopyDialog.h"
#include "ChangeNameDialog.h"
#include "FileErrorDialog.h"
#include "CopyInfoDialog.h"
#include "ErrorDialog.h"

#include "spi.h"



// #include <intshcut.h>  

// #pragma comment( lib, "shlwapi.lib" )  

// pPCTKPRead CFmParam::m_pPCTKPRead = NULL;

int CFmParam::m_nMonitor = 0;
CRect CFmParam::m_rcMonitor[10];

BOOL CALLBACK CFmParam::MonitorEnumProc(HMONITOR hMonitor, HDC hdcMonitor, LPRECT lprcMonitor, LPARAM dwData)
{
	m_rcMonitor[m_nMonitor].top = lprcMonitor->top;
	m_rcMonitor[m_nMonitor].bottom = lprcMonitor->bottom;
	m_rcMonitor[m_nMonitor].left = lprcMonitor->left;
	m_rcMonitor[m_nMonitor].right = lprcMonitor->right;

	m_nMonitor++;

	return TRUE;
}


CFmParam::CFmParam(void)
{
	m_EnableToolBar = false;
	m_EnableShiftKeyToolBar = false;
	m_EnableCtrlKeyToolBar = false;

	m_DriveScanTime = 0;	// XLȂ
	m_bInitRedrawFocus = true;	// tH[JXɃhCuXV(INIt@C̐ݒ)
	m_bRedrawFocus = false;	// tH[JXɃhCuXV

	m_bInitReadKeyMap = false;	// NɃL[}bvǂݍ

	m_bBootLastPath = false;

	m_bSystemDirectWrite = true;


	m_annsFMNo = 0;
	m_sIniFileName = INIFILENAME;

	m_pFileParam = new CFileParam[MAXDISPLAYMODE];
	for ( int i = 0; i < MAXDISPLAYMODE; i++ ) {
		m_pFileParam[i].SetInitialData(i);
	}
	m_pDriveParam = new CDriveParam;	// hCu

	m_pKeyMap = new UINT[256];
	m_pShiftKeyMap = new UINT[256];
	m_pCtrlKeyMap = new UINT[256];
	m_pShiftCtrlKeyMap = new UINT[256];

	m_pViewKeyMap = new UINT[256];
	m_pViewShiftKeyMap = new UINT[256];
	m_pViewCtrlKeyMap = new UINT[256];
	m_pViewShiftCtrlKeyMap = new UINT[256];

	m_InitDisplayMode = 2;	// N\[h 0`4 = 1`5
	m_InfoHeight = INFOWNDHEIGHT;	// CtH[V\s
	m_DriveTabMaxWidth = MAX_TAB_WIDTH;	// hCu^u@ő\^u()
	m_DriveTabHeight = TABWNDHEIGHT;	// hCu^u
	m_CurrentDriveNo = 0;	// JghCuNo.
	m_TagFileNum = 0;
	m_TagFileSize = 0;
	m_FreeSize = 0;
	m_FileNum = 0;

	m_psHistory = new CString[MAX_HISTORY_NUM];
	m_psHistory2 = new CString[MAX_HISTORY_NUM];

	m_pExtMap = new _ExtentionMap[MAX_EXTENTION_NUM];

	m_FindMoveLine = 0;

	m_CopyBuffSize = COPY_BUF_SIZE;

	m_ViewDeltaLine = 3;
	m_ViewCharCode = -1;	// R[h

	m_InitSortMode = SORT_NAME;	// Ñ\[g@:t@CŃ\[g
	m_SortMode = m_InitSortMode;
	m_bInitSortOrder = false;
	m_SortOrder = false;
	m_SortNoCase = true;	// \[g͑啶ʂȂ
	m_bInitSortExplorer = false;
	m_bSortExplorer = false;

	m_bSettingsAutocomplete = false;
	m_bSettingsShortTitle = false;
	m_bSettingsAddCopyStr = false;
	m_bSettingsEnterKeyRunSystem = false;
	m_bSettingsDeleteDirWarning = false;

	m_bSettingsSelectDropEffect = false;
	m_bSettingsDrawSec = true;
	m_bSettingsWinMenuRB = false;

	m_bSettingsUseCurrentHistory = false;
	m_bSettingsHoldChangeAtt = false;
	m_bSettingsannsViewHavePriority = true;
	m_bInitannsViewHavePriority = true;

	m_sDirStr = DIRSTAR;

	m_sInitCurrentDir = _T("C:\\");	// ÑJgfBNg
	m_nPackArchiver = 0;	// kA[JCo 0:LZH

	m_bEnableKeyGuid = false;	// L[KC_X\
	m_bListDisplayHide = false;	// Bt@C\
	m_bListDisplaySystem = false;	// VXet@C\

	m_sToolEditor = _T("");	// GfB^t@C(tpX)
	m_sToolBinaryEditor = _T("");	// oCiGfB^t@C
	m_sToolTextViewer = _T("");	// eLXgr[A[t@C
	m_sToolGraphicViewer = _T("");	// 摜r[A[t@C
	m_sToolArchiver = _T("");	// kt@Cc[t@C
	m_sToolBrowser = _T("");	 
	m_sToolMoviePlayer = _T("");	

	m_sToolOptionEditor = _T("");	// GfB^IvV
	m_sToolOptionBinaryEditor = _T("");	// oCiGfB^IvV
	m_sToolOptionTextViewer = _T("");	// eLXgr[A[IvV
	m_sToolOptionGraphicViewer = _T("");	// 摜r[A[IvV
	m_sToolOptionArchiver = _T("");	// kt@CIvV

	m_sToolExtGraphicViewer = _T(".jpg;.jpeg;.bmp;.gif");	// 摜t@Cgq
	m_sToolExtArchiver = _T(".lzh;.zip;.cab;.rar;arj;.tar;.gz;.tgz;.taz;.gca;.gza;.bza;.yz1;");	// kt@Cgq

	m_sToolExtTar = _T(".tar;.gz;.bz2;.tar.gz;.tgz;.tar.bz2;.tar.Z;.taz;.Z;.cpio;.a;.lib;.rpm;.deb;.cpio.gz;.cpio.Z;.cpio.bz2;.a.gz;.a.Z;.a.bz2;.lib.gz;.lib.Z;.lib.bz2;.cpio.xz;.xz;.lzma;");	// Tart@Cgq
	m_sToolSPISettingFile = _T("%p\\BonsFM-Spi.txt");

	m_sHomeFolder = _T("");	// Home Folder

//	m_bToolUseLMZIP32 = true;	// LMZIP32.DLLgpB

	m_bToolUseSPI = false;	// susie plug-ingpȂB

//	m_bToolUseNVDA = false;	// NVDAgpȂ
	m_nVoiceGuide = 0;	// KC_X\tggpȂ
	m_nToolZipDll = 0;	// 0:Lmzip32
	m_nToolZipTestDll = 0;


	m_colBack = RGB(0, 0, 64);	// wi\F
//	m_colBackGray = RGB(0, 0, 64);	// wi\FO[

	m_colFrame = RGB(128, 128, 128);	// t[\F
	m_colTabFrame = RGB(0, 0, 0);	// ^ut[\F
	m_colActiveTabFrame = RGB(164, 164, 164);	// ^ut[\F
	m_colTabBack = RGB(164, 164, 180);	// ^uEBhEwi\F
	m_colActiveTab = m_colBack;	// // Iꂽ^u̔wi\F
	m_colNoActiveTab = RGB(48, 48, 64);	// I^u\F
	m_colTabText = RGB(192, 192, 128);	// ^ũeLXg\F
	m_colTabOnMouse = RGB(32, 32, 128);	// }EXJ[\ʒũ^u\F
	m_colTabRemovable = RGB(80, 80, 108);	// [ouhCũ^u\F
	m_colTabCdrom = RGB(88, 72, 64);	// CD-ROMhCũ^u\F
	m_colTabRemote = RGB(64, 80, 80);	// lbg[NhCũ^u\F
	
	m_colInfoItem = RGB(128, 128, 128);	// CtH[Vڕ\F
	m_colInfoData = RGB(255, 255, 255);	// CtH[Vf[^\F
	m_colInfoTime = RGB(0, 255, 0);	// CtH[Vݎ\F
	m_colInfoLabel = RGB(128, 128, 128);	// CtH[V{[x\F

	m_colListNormal = RGB(255, 255, 0) ;	// ʏt@C\F
	m_colListSystem = RGB(255, 0, 255);	// VXet@C\F
	m_colListReadonly = RGB(0, 255, 0);	// [hI[t@C\F
	m_colListHide = RGB(0, 0, 255);		// Bt@C\F
	m_colListDir = RGB(0, 255, 255);		// tH_\F

	m_bListCyclicalCursor = false;
	m_bListCursorMovePage = true;
	m_bListMarkAst = false;

	m_ViewTabNum = TAB_NUM;	// annsViewtab(ftHg4)
	m_bViewNotResize = false;

	m_bViewDirectWrite = true;

	m_colViewGuide = RGB(128, 128, 128);		// annsViewKCh\F
	m_colViewGuideData = RGB(255, 255, 0);		// annsViewKChf[^\F
	m_colViewText = RGB(255, 255, 255);		// annsVieweLXg\F
	m_colViewRetMark = RGB(128, 128, 128);		// annsView s\F
	m_colViewFindString = m_colBack;		// annsView \F
	m_colViewFindStringBack = RGB(255, 255, 0);		// annsView obN\F

	m_colJump = RGB(0, 255, 255);		// JumpWindow \F
	m_colJumpShift = RGB(0, 255, 0);		// JumpWindow Shift Key\F

	m_colTree = RGB(0, 255, 0);		// TreeWindow \F

	m_pw64FindData = new _wfinddata64_t[MAXFILE];
	m_sTemp64FindDataName = new CString[MAXFILE];
	m_pMark = new bool[MAXFILE];

	int i;
	for (i = 0; i < MAXFILE; i++) m_pMark[i] = false;

	CFont TextFont;

	VERIFY(TextFont.CreateFont(
		12,                        // nHeight
		0,                         // nWidth
		0,                         // nEscapement
		0,                         // nOrientation
		FW_NORMAL,                 // nWeight
		FALSE,                     // bItalic
		FALSE,                     // bUnderline
		0,                         // cStrikeOut
		ANSI_CHARSET,              // nCharSet
		OUT_DEFAULT_PRECIS,        // nOutPrecision
		CLIP_DEFAULT_PRECIS,       // nClipPrecision
		DEFAULT_QUALITY,           // nQuality
		DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
		_T("lr SVbN")));                 // lpszFacename

//	TextFont.CreateStockObject( SYSTEM_FIXED_FONT );
//	TextFont.GetLogFont( &m_logfontInfo );
	TextFont.GetLogFont( &m_logfontFile );
//	TextFont.GetLogFont( &m_logfontDriveTab );

//	TextFont.GetLogFont( &m_logfontView );
//	TextFont.GetLogFont( &m_logfontViewGuide );
//	TextFont.GetLogFont( &m_logfontJump );
//	TextFont.GetLogFont( &m_logfontTree );

	TextFont.DeleteObject();

	m_logfontFile.lfHeight = -16;

/*
	m_logfontFile.lfHeight = -19;
	m_logfontFile.lfWidth = 0;
	m_logfontFile.lfEscapement = 0;
	m_logfontFile.lfOrientation = 0;
	m_logfontFile.lfWeight = 400;
	m_logfontFile.lfItalic = 0;
	m_logfontFile.lfUnderline = 0;
	m_logfontFile.lfStrikeOut = 0;
	m_logfontFile.lfCharSet = 128;
	m_logfontFile.lfOutPrecision = 3;
	m_logfontFile.lfClipPrecision = 2;
	m_logfontFile.lfQuality = 1;
	m_logfontFile.lfPitchAndFamily = 1;
//	strcpy_s((char*)&(m_logfontFile.lfFaceName[0]), 15, "lr@SVbN");
//	strcpy_s((char*)&(m_logfontFile.lfFaceName[0]), 13, "MS UI Gothic");
	strcpy_s((char*)&(m_logfontFile.lfFaceName[0]), 13, "FixedSys");
*/

	m_logfontInfo = m_logfontFile;
	m_logfontDriveTab = m_logfontFile;
	m_logfontView = m_logfontFile;
	m_logfontViewGuide = m_logfontFile;
	m_logfontJump = m_logfontFile;
	m_logfontLauncher = m_logfontFile;
	m_logfontTree = m_logfontFile;

/*
	m_logfontDriveTab.lfHeight = -14;
	m_logfontDriveTab.lfWidth = 0;
	m_logfontDriveTab.lfEscapement = 0;
	m_logfontDriveTab.lfOrientation = 0;
	m_logfontDriveTab.lfWeight = 400;
	m_logfontDriveTab.lfItalic = 0;
	m_logfontDriveTab.lfUnderline = 0;
	m_logfontDriveTab.lfStrikeOut = 0;
	m_logfontDriveTab.lfCharSet = 128;
	m_logfontDriveTab.lfOutPrecision = 3;
	m_logfontDriveTab.lfClipPrecision = 2;
	m_logfontDriveTab.lfQuality = 1;
	m_logfontDriveTab.lfPitchAndFamily = 1;
//	strcpy_s((char*)&(m_logfontDriveTab.lfFaceName[0]), 15, "lr@SVbN");
	strcpy_s((char*)&(m_logfontDriveTab.lfFaceName[0]), 13, "MS UI Gothic");
*/
	m_DisplayMode = m_InitDisplayMode;	// \[h 0`4 = 1`5
	m_sWildCard = _T("*.*");	// ChJ[h

	m_sSelectedTreePath = _T("");
	m_sSelectedJumpPath = _T("");
	m_bEnableTreeWindow = false;
	m_bEnableJumpWindow = false;
	m_bEnableLauncherWindow = false;

	m_SelectFileName = _T("");
	GetWindowsDirectory(&m_sWinDir[0], 259);
	CString tmp = m_sWinDir;
	m_sSystemDrive = tmp.Left(3);

	for (i =0; i < 256; i++) {
		m_pKeyMap[i] = i;
		m_pShiftKeyMap[i] = 0x100 + i;
		m_pCtrlKeyMap[i] = 0x200 + i;
		m_pShiftCtrlKeyMap[i] = 0x300 + i;

		m_pViewKeyMap[i] = i;
		m_pViewShiftKeyMap[i] = 0x100 + i;
		m_pViewCtrlKeyMap[i] = 0x200 + i;
		m_pViewShiftCtrlKeyMap[i] = 0x300 + i;
	}

	m_pHistFolderData = new _folderData[MAX_FOLDER_DATA];	// ő1000
//	m_nCurrentFolderData = -1;	// tH_݂̌̋L(ől)
	m_nHistMaxFolderData = -1;	// tH_݂̌̋L(ől)
	m_nHistCurrentFolderNo = -1;	// tH_݈̌ʒu

	m_bNotSetHistory = false;

	m_bFdFull = false;	// true:tH_1000𒴂
	m_bMoveHistoryFile = false;
	m_bEnableMoveHistoryFile = false;

	m_nLineSpace = LINE_SPACE;
	m_nUpdateTime = 0;

	m_nViewLineSpace = VIEW_LINE_SPACE;

	m_sFindFileSPI = _T("");
	m_bFindSPI = false;

	m_bHideDriveTab = false;
	m_hInstanceNVDA = NULL;
	m_bEnableNVDA = false;
	m_hInstancePCTalker = NULL;
	m_bEnablePCTalker = false;
	m_pPCTKPRead = NULL;

	m_bMaskDir = false;
	m_bAddstr = false;

	m_pDirSize = new _DirSize[MAXFILE];

	m_sViewExifCmd = _T("BonsExif.exe");
	m_sViewExifParam = _T("%s");


	CString ss = _T("%d\\annsFM.exe");
	CString s2 = GetEnvStr(ss);

	ss = _T("%p\\annsFM.exe");
	s2 = GetEnvStr(ss);


}

CFmParam::~CFmParam(void)
{

	delete []m_pKeyMap;
	delete []m_pShiftKeyMap;
	delete []m_pCtrlKeyMap;
	delete []m_pShiftCtrlKeyMap;

	delete []m_pViewKeyMap;
	delete []m_pViewShiftKeyMap;
	delete []m_pViewCtrlKeyMap;
	delete []m_pViewShiftCtrlKeyMap;

	delete []m_pFileParam;
	delete m_pDriveParam;
	delete []m_pw64FindData;
	delete []m_pMark;
	delete []m_sTemp64FindDataName;

	delete []m_psHistory;
	delete []m_psHistory2;
	delete []m_pExtMap;

	delete[]m_pHistFolderData;
	delete[]m_pDirSize;


}


// t@Cꗗ̓ǂݍ
// path : ǂݍރtpX
// flist : ǂݍ݃f[^ۑ_wfinddata64_t*
// nof : _wfinddata64_t\̂ւ̕ۑJnItZbg
// wCard : ChJ[h
// fileonly : trueŃt@Ĉݓǂݍ "."y".."ǂݍ܂Ȃ
// dironly : trueDIR̂ݓǂݍ
int CFmParam::GetFileList(CString path, _wfinddata64_t* flist, int nof, CString wCard, bool fileonly, bool dironly)
{
	struct _wfinddata64_t c_file;
	intptr_t hFile;
	int i = nof;
	CString fpath, wc, fn, mydir, parentDir;
	//	bool fdir = false;
	bool fdir = dironly;
	int at;

	int ny;
	ny = path.Find(_T("\\\\"));
	bool bUncRoot = false;
	if (ny == 0) {
		ny = path.Find(STR_YEN, 2);
		ny++;
		int ny2 = path.Find(STR_YEN, ny);
		ny2++;

		if (ny2 == path.GetLength()) bUncRoot = true;
	}
	if (path.GetLength() < 4) bUncRoot = true;

	int max = MAXDRIVE - 1;
	for (int j = 26; j < max; j++) {
		if (m_pDriveParam->m_pExist[j]) {
			if (m_pDriveParam->m_pUncRootPath[j] == path) {
				bUncRoot = true;
				break;
			}
		}
	}

	mydir = _T(".");
	parentDir = _T("..");

	wc = _T("%s%s");
	//	wc = _T("%s\\%s");
	//	if (wCard.GetLength() == 0) {
	//		fdir = true;
	//		wCard = _T("*.*");
	//	}




	if (i >= (MAXFILE - 1)) {
		return i;
	}

	CStringA saFname;

	fpath.Format(wc, path, _T("*.*"));

	if (!fileonly && m_SortMode != SORT_NON) {
		if ((hFile = _wfindfirst64(fpath, &c_file)) != -1L) {

			while (true) {
				at = c_file.attrib;
				CString cf = c_file.name;

				if ((at & _A_SUBDIR) != 0) {	// dir
					if (cf == parentDir) {
						flist[i] = c_file;
						i++;
						break;
					}
				}

				if ((_wfindnext64(hFile, &c_file) != 0) || (i >= MAXFILE)) {
					break;
				}

			}
			_findclose(hFile);
		}

	}


	bool bDext = m_pFileParam[m_DisplayMode].m_bShowSplitExt;

	if ((hFile = _wfindfirst64(fpath, &c_file)) != -1L) {
		bool ok;
		ok = true;

		while (true) {
			at = c_file.attrib;
			fn = c_file.name;
			ok = true;
			if (!m_bListDisplayHide) {
				if ((at & _A_HIDDEN) != 0) ok = false;
			}
			if (!m_bListDisplaySystem) {
				if ((at & _A_SYSTEM) != 0) ok = false;
			}
			if (bUncRoot && fn == parentDir) ok = false;

			bool bSave = true;
			BOOL bMP = PathMatchSpecX(fn, wCard);


			if (wCard != _T("*.*")) {
				if (!bMP) {
					bSave = false;
				}
				if (!m_bMaskDir) {
					if ((at & _A_SUBDIR) != 0) {
						bSave = true;
					}
				}
				else {
					if (fn == parentDir) {
						bSave = true;
					}
				}

			}

			if (fileonly)
			{
				if ((at & _A_SUBDIR) != 0) {
					bSave = false;
				}
			}

			if (fdir)
			{
				if (((at & _A_SUBDIR) == 0) || (fn == parentDir)) {
					bSave = false;
				}

			}

			if (fn == mydir) {
				bSave = false;
			}

			if (!ok) {
				bSave = false;
			}



			if (bSave) {
				flist[i] = c_file;
				m_TotalFileSize += c_file.size;
				i++;
				if (bDext) {
					DivideFileName(fn);
					saFname = CW2A(m_sName);
				}
				else {
					saFname = CW2A(fn);
				}
				int len = saFname.GetLength();
				if (len > m_MaxFileNameLen) m_MaxFileNameLen = len;
			}

			if ((_wfindnext64(hFile, &c_file) != 0) || (i >= MAXFILE)) {
				break;
			}
		}
		_findclose(hFile);
	}

	return i;
}

int CFmParam::GetAllFileList(CString path)
{
	m_TotalFileSize = 0;
	m_PrevDirNo = 0;
	m_DirNum = 0;
	m_FileNum = 0;

	int n2 = 0;
	m_MaxFileNameLen = 0;

	if ( m_SortMode == SORT_NON ) {
		n2 = GetFileList(path, m_pw64FindData, 0, m_sWildCard);
		m_FileNum = n2;
		for (int i = 0; i < m_FileNum; i++) {
			if (m_pw64FindData[i].name == m_sPrevDir) m_PrevDirNo = i;
		}
	} else {
//		int n = GetFileList(path, m_pw64FindData);	// DIR̂ݓǂݍ
		int n = GetFileList(path, m_pw64FindData, 0, m_sWildCard, false, true);	// DIR̂ݓǂݍ
		m_DirNum = n;
		n2 = GetFileList(path, m_pw64FindData, n, m_sWildCard, true);	// t@Ĉݓǂݍ
		m_FileNum = n2;
		SortFileList(m_SortMode);
	}

	m_SelectFileNo = 0;
	if ( m_SelectFileName != _T("") ) {
		for ( int i = 0; i < m_FileNum; i++ ) {
			int cn = m_SelectFileName.Compare(m_pw64FindData[i].name);
			if ( cn == 0 ) m_SelectFileNo = i;
		}
	}

	CString cpath;
//	cpath = path.Left(3);
	cpath = path;
	GetFreeSize(path);
	ClearDirSize();

	return n2;
}

void CFmParam::ClearMark(void)
{
	int i;
	for (i = 0; i < MAXFILE; i++) m_pMark[i] = false;
	m_TagFileSize = 0;
	m_TagFileNum = 0;
}

void CFmParam::ReverseMark(void)
{
	int i;
	for (i = 0; i < m_FileNum; i++) {
		int at = m_pw64FindData[i].attrib;
		if ((at & _A_SUBDIR) == 0) {
			if (m_pMark[i]) {
				m_pMark[i] = false;
				m_TagFileSize -= m_pw64FindData[i].size;
				m_TagFileNum--;
			}
			else {
				m_pMark[i] = true;
				m_TagFileSize += m_pw64FindData[i].size;
				m_TagFileNum++;
			}
		}

	}

}

void CFmParam::SetMarkAll(void)
{
	int i;
	m_TagFileSize = 0;
	m_TagFileNum = 0;
	for (i = 0; i < m_FileNum; i++) {
		CString s;
		s = m_pw64FindData[i].name;
		if ( s == _T("..")) continue;

		m_pMark[i] = true;
		m_TagFileSize += m_pw64FindData[i].size;
		m_TagFileNum++;
	}
}

void CFmParam::SetMarkAllFile(void)
{
	int i;
	m_TagFileSize = 0;
	m_TagFileNum = 0;
	for (i = 0; i < m_FileNum; i++) {
		int at = m_pw64FindData[i].attrib;
		if ((at & _A_SUBDIR) == 0) {
			m_pMark[i] = true;
			m_TagFileSize += m_pw64FindData[i].size;
			m_TagFileNum++;
		}
	}
}

bool CFmParam::CheckMarkExist(void)
{
	int i;
	for (i = 0; i < m_FileNum; i++) {
		if ( m_pMark[i] ) return true;
	}
	return false;
}

bool CFmParam::GetFreeSize(CString path)
{
	ULARGE_INTEGER FreeBytesAvailableToCaller;
	ULARGE_INTEGER TotalNumberOfBytes;
	ULARGE_INTEGER TotalNumberOfFreeBytes;

	BOOL ret = ::GetDiskFreeSpaceEx( path,
                 &FreeBytesAvailableToCaller,
                 &TotalNumberOfBytes,
                 &TotalNumberOfFreeBytes );
	if( ret == TRUE) {
		m_FreeSize = (__int64)TotalNumberOfFreeBytes.QuadPart;
	} else m_FreeSize = (_int64)0;
	bool r = true;
	if ( !ret ) r = false;

	return r;
}

bool CFmParam::DivideFileName(CString name)
{
	CString ch;
	int n, len;

	m_sName = name;
	m_sExt = "";
	ch = _T(".");
	len = name.GetLength();
	n = name.ReverseFind(ch.GetAt(0));
	if ( n == -1 ) return false;

	m_sName = name.Left(n);
	m_sExt = name.Right(len - n);

	return true;
}

void CFmParam::InsertComma(CString& numstr)
{
	int len, max;
	CString s;
	s = ",";
	len = numstr.GetLength();
	max = (len - 1) / 3;

	for(int i = 0; i < max; i++) {
		int n = len - (3 + i * 3);
		numstr.Insert(n, s);
	}
}

__int64 CFmParam::CalcFileSize(__int64 size, CString& sUnit)
{
	__int64 i, ib, ib2;

	sUnit = "";
	i = size;

	ib = 1024;
	ib2 = ib * 1024;
	if ( size > ib2 ) {
		i = size / ib;
		sUnit = _T("KB");
	}

	ib *= 1024;
	ib2 = ib * 100;
	if ( size > ib2 ) {
		i = size / ib;
		sUnit = _T("MB");
	}

	ib *= 1024;
	ib2 = ib * 100;
	if ( size > ib2 ) {
		i = size / ib;
		sUnit = _T("GB");
	}

	return i;
}

CString CFmParam::GetTimeStr(__time64_t time)
{
	CString stime, form;
	CTime ct(time);

	int year = ct.GetYear();
	int month = ct.GetMonth();
	int date = ct.GetDay();

	int hour = ct.GetHour();
	int minute = ct.GetMinute();
	int second = ct.GetSecond();

	form = _T("%4d/%02d/%02d  %02d:%02d:%02d");
	stime.Format(form, year, month, date, hour, minute, second);

	return stime;
}

void CFmParam::SortFileList(int mode)
{

	if ( m_SortMode == SORT_NON ) return;

	_wfinddata64_t *dirSys, *dirHide, *dirRdonly, *dirNorm;
	_wfinddata64_t *fileSys, *fileHide, *fileRdonly, *fileNorm;
	bool *mdSys, *mdHide, *mdRdonly, *mdNorm;
	bool *mfSys, *mfHide, *mfRdonly, *mfNorm;

	dirSys = new _wfinddata64_t[m_DirNum];
	dirHide = new _wfinddata64_t[m_DirNum];
	dirRdonly = new _wfinddata64_t[m_DirNum];
	dirNorm = new _wfinddata64_t[m_DirNum];

	fileSys = new _wfinddata64_t[m_FileNum];
	fileHide = new _wfinddata64_t[m_FileNum];
	fileRdonly = new _wfinddata64_t[m_FileNum];
	fileNorm = new _wfinddata64_t[m_FileNum];

	mdSys = new bool[m_DirNum];
	mdHide = new bool[m_DirNum];
	mdRdonly = new bool[m_DirNum];
	mdNorm = new bool[m_DirNum];

	mfSys = new bool[m_FileNum];
	mfHide = new bool[m_FileNum];
	mfRdonly = new bool[m_FileNum];
	mfNorm = new bool[m_FileNum];

	int nn = 0;

	CString spd;
	spd = _T("..");
	if ( m_pw64FindData[0].name == spd ) {
		nn = 1;
	}


	int i, n1, n2, n3, n4;
	n1 = n2 = n3 = n4 = 0;
	for (i = nn; i < m_DirNum; i++) {
		bool bf = true;

		unsigned at = m_pw64FindData[i].attrib;
		if ((at & _A_SYSTEM) != 0) {
			dirSys[n1] = m_pw64FindData[i];
			mdSys[n1] = m_pMark[i];
			n1++;
			bf = false;
		}
		if (bf && (at & _A_HIDDEN) != 0) {
			dirHide[n2] = m_pw64FindData[i];
			mdHide[n2] = m_pMark[i];
			n2++;
			bf = false;
		}
		if (bf && (at & _A_RDONLY) != 0) {
			dirRdonly[n3] = m_pw64FindData[i];
			mdRdonly[n3] = m_pMark[i];
			n3++;
			bf = false;
		}
		if ( bf ) {
			dirNorm[n4] = m_pw64FindData[i];
			mdNorm[n4] = m_pMark[i];
			n4++;
		}
	}

	int nf1, nf2, nf3, nf4;
	nf1 = nf2 = nf3 = nf4 = 0;
	for (i = m_DirNum; i < m_FileNum; i++) {
		bool bf = true;
		unsigned at = m_pw64FindData[i].attrib;
		if ((at & _A_SYSTEM) != 0) {
			fileSys[nf1] = m_pw64FindData[i];
			mfSys[nf1] = m_pMark[i];
			nf1++;
			bf = false;
		}
		if (bf && (at & _A_HIDDEN) != 0) {
			fileHide[nf2] = m_pw64FindData[i];
			mfHide[nf2] = m_pMark[i];
			nf2++;
			bf = false;
		}
		if (bf && (at & _A_RDONLY) != 0) {
			fileRdonly[nf3] = m_pw64FindData[i];
			mfRdonly[nf3] = m_pMark[i];
			nf3++;
			bf = false;
		}
		if ( bf ) {
			fileNorm[nf4] = m_pw64FindData[i];
			mfNorm[nf4] = m_pMark[i];
			nf4++;
		}
	}

	int nmode = mode;
	if (mode == SORT_EXT) nmode = SORT_NAME;

	if ( n1 > 1 ) qSort(dirSys, mdSys, nmode, 0, n1 - 1, m_SortOrder);
	if ( n2 > 1 ) qSort(dirHide, mdHide, nmode, 0, n2 - 1, m_SortOrder);
	if ( n3 > 1 ) qSort(dirRdonly, mdRdonly, nmode, 0, n3 - 1, m_SortOrder);
	if ( n4 > 1 ) qSort(dirNorm, mdNorm, nmode, 0, n4 - 1, m_SortOrder);

	if ( nf1 > 1 ) qSort(fileSys, mfSys, mode, 0, nf1 - 1, m_SortOrder);
	if ( nf2 > 1 ) qSort(fileHide, mfHide, mode, 0, nf2 - 1, m_SortOrder);
	if ( nf3 > 1 ) qSort(fileRdonly, mfRdonly, mode, 0, nf3 - 1, m_SortOrder);
	if ( nf4 > 1 ) qSort(fileNorm, mfNorm, mode, 0, nf4 - 1, m_SortOrder);

	int j = nn;
	for (i = 0; i < n1; i++) {
		m_pw64FindData[j] = dirSys[i];
		m_pMark[j] = mdSys[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}
	for (i = 0; i < n2; i++) {
		m_pw64FindData[j] = dirHide[i];
		m_pMark[j] = mdHide[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}
	for (i = 0; i < n3; i++) {
		m_pw64FindData[j] = dirRdonly[i];
		m_pMark[j] = mdRdonly[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}
	for (i = 0; i < n4; i++) {
		m_pw64FindData[j] = dirNorm[i];
		m_pMark[j] = mdNorm[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}

	for (i = 0; i < nf1; i++) {
		m_pw64FindData[j] = fileSys[i];
		m_pMark[j] = mfSys[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}
	for (i = 0; i < nf2; i++) {
		m_pw64FindData[j] = fileHide[i];
		m_pMark[j] = mfHide[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}
	for (i = 0; i < nf3; i++) {
		m_pw64FindData[j] = fileRdonly[i];
		m_pMark[j] = mfRdonly[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}
	for (i = 0; i < nf4; i++) {
		m_pw64FindData[j] = fileNorm[i];
		m_pMark[j] = mfNorm[i];
		if ( m_pw64FindData[j].name == m_sPrevDir ) m_PrevDirNo = j;
		j++;
	}

	delete []mfNorm;
	delete []mfRdonly;
	delete []mfHide;
	delete []mfSys;

	delete []mdNorm;
	delete []mdRdonly;
	delete []mdHide;
	delete []mdSys;

	delete []dirNorm;
	delete []dirRdonly;
	delete []dirHide;
	delete []dirSys;

	delete []fileNorm;
	delete []fileRdonly;
	delete []fileHide;
	delete []fileSys;

}

// mode:\[g̃[h()  SORT_NON`SORT_SIZE
// start:\[gJnCfbNX  end:\[gICfbNX
// od:  true=(ftHg)  false=~
// fdatastartend܂ł̃f[^[hɉă\[g
void CFmParam::qSort(_wfinddata64_t* fdata, bool* mark, int mode, int start, int end, bool od)
{
	int i = start;
	int j = end;
	int npivot = start + ((j - i) / 2);
	int ret = 0;
	bool tmpmb;

	if ( i >= j ) return;

	if ((j - i) == 1) npivot = j;

	_wfinddata64_t tmpfdata;
	_wfinddata64_t pivotdata;
	pivotdata = fdata[npivot];

//	bool bEQ1 = false;
//	bool bEQ2 = false;

	while(1) {
		while( 1 ) {
			ret = Compare(mode, fdata, i, pivotdata);
			if ( !od ) {
				if ( ret < 0 ) i++;
				else break;
			} else {
				if ( ret > 0 ) i++;
				else break;
			}
		}

//		if (ret == 0) bEQ1 = true;


		while( 1 ) {
			ret = Compare(mode, fdata, j, pivotdata);
			if ( !od ) {
				if ( ret > 0 ) j--;
				else break;
			} else {
				if ( ret < 0 ) j--;
				else break;
			}
		}
//		if (ret == 0) bEQ2 = true;

		if (i >= j) {
			break;
		}

//		if (!bEQ1 || !bEQ2) {

			tmpfdata = fdata[i];
			fdata[i] = fdata[j];
			fdata[j] = tmpfdata;

			tmpmb = mark[i];
			mark[i] = mark[j];
			mark[j] = tmpmb;

//		}



		i++;
		j--;
	}
	if (start < (i - 1) ) qSort(fdata, mark, mode, start, i - 1, od);
	if ((j + 1) < end) qSort(fdata, mark, mode, j + 1, end, od);

	return;
}

/*
void QSort(int x[ ], int left, int right)
{
    int i, j;
    int pivot;

    i = left;                       \[gz̈ԏvf̓Y 
    j = right;                      \[gz̈ԑ傫vf̓Y 

    pivot = x[(left + right) / 2];  lz̒t߂ɂƂ 

    while (1) {                     [v 

        while (x[i] < pivot)        pivot 傫l 
            i++;                    o܂ i 𑝉 

        while (pivot < x[j])        pivot 菬l 
            j--;                     o܂ j  
        if (i >= j)                 i >= j Ȃ 
            break;                  [v甲 

        Swap(x, i, j);              x[i]  x[j] 
        i++;                        ̃f[^ 
        j--;
    }
    ShowData(x, 10);                ro߂\ 

    if (left < i - 1)               l̍ 2 ȏvf 
        QSort(x, left, i - 1);      ̔z Q \[g 
    if (j + 1 <  right)             l̉E 2 ȏvf 
        QSort(x, j + 1, right);     E̔z Q \[g 
}
*/


//  +1:d1 > d2  0:d1 = d2  -1:d1 < d2
int CFmParam::Compare(int mode, _wfinddata64_t* fdata, int d1, _wfinddata64_t pivotdata)
{
	int ret = 0;
	switch (mode) {
		case SORT_NAME:
			ret = CompareName(fdata, d1, pivotdata);
			break;

		case SORT_EXT:
			ret = CompareExt(fdata, d1, pivotdata);
			break;

		case SORT_TIME:
			ret = CompareTime(fdata, d1, pivotdata);
			break;

		case SORT_SIZE:
			ret = CompareSize(fdata, d1, pivotdata);
			break;
	}

	return ret;
}
/*
0	1 			2	3 	4	5 	6	7
-------------------------------------
0	NUL	DLE 	SP	0	@	P	`	p
1	SOH	DC1 	!	1	A	Q	a	q
2	STX	DC2 	"	2	B	R	b	r
3	ETX	DC3 	#	3	C	S	c	s
4	EOT	DC4 	$	4	D	T	d	t
5	ENQ	NAC 	%	5	E	U	e	u
6	ACK	SYN 	&	6	F	V	f	v
7	BEL	ETB 	'	7	G	W	g	w
8	BS	CAN 	(	8	H	X	h	x
9	HT	EM		) 	9	I	Y	i	y
A	LF/NL SUB	*	:	J	Z	j 	z
B	VT	ESC 	+	;	K	[	k	{
C	FF	FS		, 	<	L	\	l	|
D	CR	GS 		-	=	M	]	m	}
E	SO	RS 		.	>	N	^	n	~
F	SI	US 		/	?	O	_	o	DEL


    0	1 	    2	3 	4	5 	6	7
-------------------------------------
0	NUL	DLE 	SP	`		P		p
1	SOH	DC1 	!	{	A	Q	a	q
2	STX	DC2 	"	}	B	R	b	r
3	ETX	DC3 	#	~	C	S	c	s
4	EOT	DC4 	$	+	D	T	d	t
5	ENQ	NAC 	%	=	E	U	e	u
6	ACK	SYN 	&	0	F	V	f	v
7	BEL	ETB 		1	G	W	g	w
8	BS	CAN 	(	2	H	X	h	x
9	HT	EM		) 	3	I	Y	i	y
A	LF/NL SUB 	;	4	J	Z	j 	z
B	VT	ESC 	@	5	K		k	
C	FF	FS		[ 	6	L	\	l	|
D	CR	GS 		]	7	M		m	
E	SO	' 		^	8	N		n	
F	SI	- 		_	9	O		o	DEL
*/

// t@C̃\[gpASCIIR[hϊ
void CFmParam::ChangeAsciiStrings(CString *name1, CString *name2)
{
	name1->Replace(_T('-'), 0x1f);
	name2->Replace(_T('-'), 0x1f);

	name1->Replace(_T('\''), 0x1e);
	name2->Replace(_T('\''), 0x1e);

	name1->Replace(_T(';'), 0x2a);
	name2->Replace(_T(';'), 0x2a);

	name1->Replace(_T('['), 0x2c);
	name2->Replace(_T('['), 0x2c);

	name1->Replace(_T(']'), 0x2d);
	name2->Replace(_T(']'), 0x2d);

	name1->Replace(_T('^'), 0x2e);
	name2->Replace(_T('^'), 0x2e);

	name1->Replace(_T('_'), 0x2f);
	name2->Replace(_T('_'), 0x2f);

	name1->Replace(_T('9'), 0x3f);
	name2->Replace(_T('9'), 0x3f);

	name1->Replace(_T('8'), 0x3e);
	name2->Replace(_T('8'), 0x3e);

	name1->Replace(_T('6'), 0x3c);
	name2->Replace(_T('6'), 0x3c);

	name1->Replace(_T('5'), 0x3b);
	name2->Replace(_T('5'), 0x3b);

	name1->Replace(_T('4'), 0x3a);
	name2->Replace(_T('4'), 0x3a);

	name1->Replace(_T('3'), 0x39);
	name2->Replace(_T('3'), 0x39);

	name1->Replace(_T('2'), 0x38);
	name2->Replace(_T('2'), 0x38);

	name1->Replace(_T('='), 0x35);
	name2->Replace(_T('='), 0x35);

	name1->Replace(_T('7'), 0x3d);
	name2->Replace(_T('7'), 0x3d);

	name1->Replace(_T('1'), 0x37);
	name2->Replace(_T('1'), 0x37);

	name1->Replace(_T('0'), 0x36);
	name2->Replace(_T('0'), 0x36);

	name1->Replace(_T('+'), 0x34);
	name2->Replace(_T('+'), 0x34);

	name1->Replace(_T('@'), 0x2b);
	name2->Replace(_T('@'), 0x2b);

	name1->Replace(_T('`'), 0x30);
	name2->Replace(_T('`'), 0x30);

	name1->Replace(_T('{'), 0x31);
	name2->Replace(_T('{'), 0x31);

	name1->Replace(_T('}'), 0x32);
	name2->Replace(_T('}'), 0x32);

	name1->Replace(_T('~'), 0x33);
	name2->Replace(_T('~'), 0x33);
}

// t@C̔r +1:d1 > d2  0:d1 = d2  -1:d1 < d2
int CFmParam::CompareName(_wfinddata64_t* fdata, int d1, _wfinddata64_t pivotdata)
{
	CString name1, name2;
	int r;

	name1 = fdata[d1].name;
	name2 = pivotdata.name;

	if ( m_bSortExplorer ) {
		if ( m_SortNoCase ) {
			name1.MakeUpper();
			name2.MakeUpper();
		}
		r = StrCmpLogicalW(name1, name2);
		return r;
	}

	ChangeAsciiStrings(&name1, &name2);

	CStringA nameA1, nameA2;
	nameA1 = CW2A(name1);
	nameA2 = CW2A(name2);


	if ( m_SortNoCase ) {
		r = nameA1.CompareNoCase(nameA2);
	} else {
		r = nameA1.Compare(nameA2);
	}

	return r;
}


int CFmParam::CompareExt(_wfinddata64_t* fdata, int d1, _wfinddata64_t pivotdata)
{
	CString ext1, ext2, tmp;
	int r;

	tmp = _T("\1");
	DivideFileName(fdata[d1].name);
	ext1 = m_sExt;
	if ( ext1.GetLength() == 0 ) ext1 = tmp;;
	ext1 += _T(" ");
	ext1 += m_sName;
	DivideFileName(pivotdata.name);
	ext2 = m_sExt;
	if ( ext2.GetLength() == 0 ) ext2 = tmp;
	ext2 += _T(" ");
	ext2 += m_sName;

	if ( m_bSortExplorer ) {
		if ( m_SortNoCase ) {
			ext1.MakeUpper();
			ext2.MakeUpper();
		}
		r = StrCmpLogicalW(ext1, ext2);
		return r;
	}

	ChangeAsciiStrings(&ext1, &ext2);

	CStringA extA1, extA2;
	extA1 = CW2A(ext1);
	extA2 = CW2A(ext2);

	if ( m_SortNoCase ) {
		r = extA1.CompareNoCase(extA2);
	} else {
		r = extA1.Compare(extA2);
	}

	return r;

}

int CFmParam::CompareTime(_wfinddata64_t* fdata, int d1, _wfinddata64_t pivotdata)
{
	__time64_t t1, t2;
	int r = 0;

	t1 = fdata[d1].time_write;
	t2 = pivotdata.time_write;
	if ( t1 > t2 ) r = 1;
	if ( t1 < t2 ) r = -1;

	if (t1 == t2) {
		r = CompareName(fdata, d1 ,pivotdata);
	}

	return r;

}

int CFmParam::CompareSize(_wfinddata64_t* fdata, int d1, _wfinddata64_t pivotdata)
{
	__int64 size1, size2;
	int r = 0;

	size1 = fdata[d1].size;
	size2 = pivotdata.size;
	if ( size1 > size2 ) r = 1;
	if ( size1 < size2 ) r = -1;

	return r;
}

CString CFmParam::GetExePath(LPCTSTR pName)
{
	//exet@C̃tpX擾
	TCHAR path[_MAX_PATH];
	::GetModuleFileName(NULL,path,sizeof path);

	//exet@C̃pX𕪉
	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_DIR];
	TCHAR fname[_MAX_FNAME];
	TCHAR ext[_MAX_EXT];
	_wsplitpath_s(path,drive,dir,fname,ext);

	//̃t@Cexet@C̃pXŃtpX
	_wmakepath_s(path,drive,dir,pName,_T(""));

	CString str(path);
	return str;
}

void CFmParam::ReadIniFile(void)
{
	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	CString s, s2;
	int n, org;

	// [System]
	sSection = INISECTION_SYSTEM;


	sEntry = INIENTRY_SYSTEM_DIRECTWRITE;
	n = pApp->GetProfileInt(sSection, sEntry, 1);
	m_bSystemDirectWrite = (n != 0);

	if (m_nOSversion < 7) {
		m_bSystemDirectWrite = 0;
	}

	sEntry = INIENTRY_SYSTEM_DRIVETAB_MAXWIDTH;
	m_DriveTabMaxWidth = pApp->GetProfileInt(sSection, sEntry, 30);

	sEntry = INIENTRY_SYSTEM_DRIVETAB_HEIGHT;
	m_DriveTabHeight = pApp->GetProfileInt(sSection, sEntry, TABWNDHEIGHT);


	sEntry = INIENTRY_SYSTEM_COLOR_BACK;
	s = pApp->GetProfileString(sSection, sEntry, _T("400000"));
	m_colBack = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_SYSTEM_COLOR_FRAME;
	s = pApp->GetProfileString(sSection, sEntry, _T("808080"));
	m_colFrame = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_ITEM;
	s = pApp->GetProfileString(sSection, sEntry, _T("808080"));
	m_colInfoItem = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_DATA;
	s = pApp->GetProfileString(sSection, sEntry, _T("ffffff"));
	m_colInfoData = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_TIME;
	s = pApp->GetProfileString(sSection, sEntry, _T("00ff00"));
	m_colInfoTime = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_LABEL;
	s = pApp->GetProfileString(sSection, sEntry, _T("808080"));
	m_colInfoLabel = wcstol(s.GetBuffer(), NULL, 16);

/*
	m_colTabFrame = RGB(128, 128, 128);;	// ^ut[\F
	m_colActiveTabFrame = RGB(0, 0, 64);;	// ^ut[\F
	m_colTabBack = RGB(223, 223, 223);	// ^uEBhEwi\F
	m_colActiveTab = RGB(248, 248, 248);	// // Iꂽ^u̔wi\F
	m_colNoActiveTab = RGB(208, 208, 208);	// I^u\F
	m_colTabText = RGB(0, 0, 0);	// ^ũeLXg\F
	
*/

	sEntry = INIENTRY_SYSTEM_FONT_NAME;
	s = pApp->GetProfileString(sSection, sEntry, _T("lr SVbN"));


		sEntry = INIENTRY_SYSTEM_FONT_HEIGHT;
		int fh = pApp->GetProfileInt(sSection, sEntry, 12);
		// |CgtHg̍ɕϊ
		CClientDC dc(AfxGetMainWnd());
		m_logfontFile.lfHeight = -::MulDiv(fh, dc.GetDeviceCaps(LOGPIXELSY), 72);

		sEntry = INIENTRY_SYSTEM_FONT_WEIGHT;
		m_logfontFile.lfWeight = pApp->GetProfileInt(sSection, sEntry, 0x190);

		sEntry = INIENTRY_SYSTEM_FONT_STYLE;
		m_logfontFile.lfItalic = pApp->GetProfileInt(sSection, sEntry, 0);


//		m_logfontFile.lfHeight = -14;
		m_logfontFile.lfWidth = 0;
		m_logfontFile.lfEscapement = 0;
		m_logfontFile.lfOrientation = 0;
		m_logfontFile.lfWeight = 0x190;
		m_logfontFile.lfItalic = 0;
		m_logfontFile.lfUnderline = 0;
		m_logfontFile.lfStrikeOut = 0;
		m_logfontFile.lfCharSet = 0x80;
		m_logfontFile.lfOutPrecision = 3;
		m_logfontFile.lfClipPrecision = 2;
		m_logfontFile.lfQuality = 1;
		m_logfontFile.lfPitchAndFamily = 0x31;
	//	strcpy_s((char*)&(m_logfontFile.lfFaceName[0]), 15, "lr@SVbN");
//		strcpy_s((char*)&(m_logfontFile.lfFaceName[0]), 13, s);
		lstrcpy(&(m_logfontFile.lfFaceName[0]), s);

		m_logfontInfo = m_logfontFile;
		m_logfontDriveTab = m_logfontFile;
		m_logfontView = m_logfontFile;
		m_logfontViewGuide = m_logfontView;
		m_logfontJump = m_logfontFile;
		m_logfontTree = m_logfontFile;
		m_logfontLauncher = m_logfontFile;


	sEntry = INIENTRY_SYSTEM_LINE_SPACE;
	m_nLineSpace = pApp->GetProfileInt(sSection, sEntry, LINE_SPACE);
	if ( m_nLineSpace > 10 || m_nLineSpace < 0 ) m_nLineSpace = 0;

	sEntry = INIENTRY_SYSTEM_UPDATE_TIME;
	m_nUpdateTime = pApp->GetProfileInt(sSection, sEntry, 0);
	if ( m_nUpdateTime > 10 || m_nUpdateTime < 0 ) m_nUpdateTime = 0;

	// [Boot]
	sSection = INISECTION_BOOT;

	sEntry = INIENTRY_BOOT_CURRENT_DIR;
	m_sInitCurrentDir = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_BOOT_DISPLAY_MODE;
	m_InitDisplayMode = 2;
	n = pApp->GetProfileInt(sSection, sEntry, 2);
	if ( n >= 0 && n < 5) m_InitDisplayMode = n;	// \[h 0`4
	m_DisplayMode = m_InitDisplayMode;

	sEntry = INIENTRY_BOOT_DISPLAY_HIDEFILE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bInitDisplayHide = (n != 0);
	m_bListDisplayHide = m_bInitDisplayHide;	// Bt@C̕\

	sEntry = INIENTRY_BOOT_DISPLAY_SYSFILE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bInitDisplaySystem = (n != 0);
	m_bListDisplaySystem = m_bInitDisplaySystem;	// VXet@C̕\

	sEntry = INIENTRY_BOOT_SORT_MODE;
	m_InitSortMode = SORT_NAME;
	n = pApp->GetProfileInt(sSection, sEntry, SORT_NAME);
	if ( n >= SORT_NON && n <= SORT_SIZE) m_InitSortMode = n;	// \[g[h 0`4
	m_SortMode = m_InitSortMode;

	sEntry = INIENTRY_BOOT_SORT_ORDER;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bInitSortOrder = (n != 0);
	m_SortOrder = m_bInitSortOrder;

	sEntry = INIENTRY_BOOT_READ_KEY_MAP;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bInitReadKeyMap = (n != 0);

	sEntry = INIENTRY_BOOT_BOOT_LAST_PATH;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bBootLastPath = (n != 0);

	sEntry = INIENTRY_BOOT_SORT_EXPLORER;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bInitSortExplorer = (n != 0);
	m_bSortExplorer = (n != 0);



	// [FileList]
	sSection = INISECTION_FILELIST;

	sEntry = INIENTRY_FILELIST_COLOR_DIR;
	s = pApp->GetProfileString(sSection, sEntry, _T("ffff00"));
	m_colListDir = wcstol(s.GetBuffer(), NULL, 16);		// tH_F

	sEntry = INIENTRY_FILELIST_COLOR_NORMAL;
	s = pApp->GetProfileString(sSection, sEntry, _T("00ffff"));
	m_colListNormal = wcstol(s.GetBuffer(), NULL, 16);	// t@CF

	sEntry = INIENTRY_FILELIST_COLOR_RONLY;
	s = pApp->GetProfileString(sSection, sEntry, _T("00ff00"));
	m_colListReadonly = wcstol(s.GetBuffer(), NULL, 16);	// ǂݎpt@CF

	sEntry = INIENTRY_FILELIST_COLOR_HIDDEN;
	s = pApp->GetProfileString(sSection, sEntry, _T("ff0000"));
	m_colListHide = wcstol(s.GetBuffer(), NULL, 16);	// Bt@CF

	sEntry = INIENTRY_FILELIST_COLOR_SYSTEM;
	s = pApp->GetProfileString(sSection, sEntry, _T("ff00ff"));
	m_colListSystem = wcstol(s.GetBuffer(), NULL, 16);	// VXet@CF

	sEntry = INIENTRY_FILELIST_CYCLICAL_CURSOR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bListCyclicalCursor = (n != 0);			// 1:TCNJ@J[\

	sEntry = INIENTRY_FILELIST_CURSOR_MOVEPAGE;
	n = pApp->GetProfileInt(sSection, sEntry, 1);
	m_bListCursorMovePage = (n != 0);			// 1:J[\ړŃy[Wړ
												
	sEntry = INIENTRY_FILELIST_MARK_AST;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bListMarkAst = (n != 0);	// t@CI}[N*ŕ\

												
												// [FileList#n]
	for ( int i = 0; i < 5; i++ ) {
		s = INISECTION_FILELIST;
		sSection.Format(_T("%s%d"), INISECTION_FILELIST, i+1);

		sEntry = INIENTRY_FILELIST_DISPLAY_NAME_TYPE;
		org = m_pFileParam[i].m_DisplayNameType;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		if ( n >= 0 && n <= 2) m_pFileParam[i].m_DisplayNameType = n;	// t@C\` 0`2

		sEntry = INIENTRY_FILELIST_NAME_LEN;
		org = m_pFileParam[i].m_NameLen;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		if ( n >= 8 && n <= 250) m_pFileParam[i].m_NameLen = n;	// t@C\ 8`250

		sEntry = INIENTRY_FILELIST_EXT_LEN;
		org = m_pFileParam[i].m_ExtLen;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		if ( n >= 3 && n <= 250) m_pFileParam[i].m_ExtLen = n;	// gq\ 3`250

		sEntry = INIENTRY_FILELIST_KIND_DATE;
		org = m_pFileParam[i].m_KindDate;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		if ( n >= 0 && n <= 2) m_pFileParam[i].m_KindDate = n;	// t@C̎ 0:쐬  1:XV(W)  2:ŏIANZX

		sEntry = INIENTRY_FILELIST_SHOW_SPLIT_EXT;
		org = m_pFileParam[i].m_bShowSplitExt;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowSplitExt = (n != 0);				// 1:gq𕪗ĕ\  0:Ȃ

		sEntry = INIENTRY_FILELIST_NOT_SPLIT_DIR_EXT;
		org = m_pFileParam[i].m_bNotSplitDirExt;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bNotSplitDirExt = (n != 0);			// 1:tH_̊gq͕Ȃ   0:

		sEntry = INIENTRY_FILELIST_SHOW_SIZE;
		org = m_pFileParam[i].m_bShowSize;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowSize = (n != 0);					// 1:t@CTCY\  0:\Ȃ

		sEntry = INIENTRY_FILELIST_SHOW_UNIT_SIZE;
		org = m_pFileParam[i].m_bShowUnitSize;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowUnitSize = (n != 0);				// 1:t@CTCYȈ(P)\(MB/KBȂ)  0:ȈՕ\Ȃ

		sEntry = INIENTRY_FILELIST_SHOW_OVER_PART;
		org = m_pFileParam[i].m_bShowOverPart;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowOverPart = (n != 0);				// 1:\Ȃ\  0:\Ȃ

		sEntry = INIENTRY_FILELIST_SHOW_DATE;
		org = m_pFileParam[i].m_bShowDate;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowDate = (n != 0);					// 1:t\  0:\Ȃ

		sEntry = INIENTRY_FILELIST_SHOW_TIME;
		org = m_pFileParam[i].m_bShowTime;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowTime = (n != 0);					// 1:Ԃ\  0:\Ȃ

		sEntry = INIENTRY_FILELIST_SHOW_FULL_CENTURY;
		org = m_pFileParam[i].m_bShowFullCentury;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowFullCentury = (n != 0);			// 1:\ 4 0:2

		sEntry = INIENTRY_FILELIST_SHOW_SECOND;
		org = m_pFileParam[i].m_bShowSecond;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowSecond = (n != 0);				// 1:b\  0:\Ȃ

		sEntry = INIENTRY_FILELIST_SHOW_ATRIBUTE;
		org = m_pFileParam[i].m_bShowAtribute;
		n = pApp->GetProfileInt(sSection, sEntry, org);
		m_pFileParam[i].m_bShowAtribute = (n != 0);				// 1:\

	}

	// [Tools]
	sSection = INISECTION_TOOLS;

	sEntry = INIENTRY_TOOLS_EDITOR;
	m_sToolEditor = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_BINARYEDITOR;
	m_sToolBinaryEditor = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_TEXTVIEWER;
	m_sToolTextViewer = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_GRAPHICVIEWER;
	m_sToolGraphicViewer = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_ARCHIVER;
	m_sToolArchiver = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_BROWSER;
	m_sToolBrowser = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_MOVIEPLAYER;
	m_sToolMoviePlayer = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_OPTION_EDITOR;
	m_sToolOptionEditor = pApp->GetProfileString(sSection, sEntry);
	sEntry = INIENTRY_TOOLS_OPTION_BINARYEDITOR;
	m_sToolOptionBinaryEditor = pApp->GetProfileString(sSection, sEntry);
	sEntry = INIENTRY_TOOLS_OPTION_TEXTVIEWER;
	m_sToolOptionTextViewer = pApp->GetProfileString(sSection, sEntry);
	sEntry = INIENTRY_TOOLS_OPTION_GRAPHICVIEWER;
	m_sToolOptionGraphicViewer = pApp->GetProfileString(sSection, sEntry);
	sEntry = INIENTRY_TOOLS_OPTION_ARCHIVER;
	m_sToolOptionArchiver = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_EXT_GRAPHICVIEWER;
	m_sToolExtGraphicViewer = pApp->GetProfileString(sSection, sEntry);

	sEntry = INIENTRY_TOOLS_EXT_ARCHIVER;
	m_sToolExtArchiver = pApp->GetProfileString(sSection, sEntry, _T(".LZH;.ZIP;.TAR;.CAB;.7Z;"));

	sEntry = INIENTRY_TOOLS_EXT_BROWSER;
	m_sToolExtBrowser = pApp->GetProfileString(sSection, sEntry, _T(".HTM;.HTML;"));

	sEntry = INIENTRY_TOOLS_EXT_MOVIEPLAYER;
	m_sToolExtMoviePlayer = pApp->GetProfileString(sSection, sEntry, _T(".AVI;.MPEG;.MPG;.MOV;.MP4;"));

	sEntry = INIENTRY_TOOLS_EXT_TAR;
	m_sToolExtTar = pApp->GetProfileString(sSection, sEntry, _T(".tar;.gz;.bz2;.tar.gz;.tgz;.tar.bz2;.tar.Z;.taz;.Z;.cpio;.a;.lib;.rpm;.deb;.cpio.gz;.cpio.Z;.cpio.bz2;.a.gz;.a.Z;.a.bz2;.lib.gz;.lib.Z;.lib.bz2;.cpio.xz;.xz;.lzma;"));	// Tart@Cgq


	sEntry = INIENTRY_TOOLS_BONSEXIF;
	m_sToolBonsExif = pApp->GetProfileString(sSection, sEntry, _T("BonsExif.exe"));

//	sEntry = INIENTRY_TOOLS_USELMZIP32;
//	n = pApp->GetProfileInt(sSection, sEntry, 1);
//	m_bToolUseLMZIP32 = (n != 0);

	s = GetExePath(_T("SPI\\"));
	sEntry = INIENTRY_TOOLS_PATH_SPI;
	m_sToolPathSPI = pApp->GetProfileString(sSection, sEntry, s);

	s = _T("%p\\BonsFM-Spi.txt");
	sEntry = INIENTRY_TOOLS_SPI_PARAMFILE_PATH;
	m_sToolSPISettingFile = pApp->GetProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_TOOLS_USESPI;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bToolUseSPI = (n != 0);

//	sEntry = INIENTRY_TOOLS_USENVDA;
//	n = pApp->GetProfileInt(sSection, sEntry, 0);
//	m_bToolUseNVDA = (n != 0);

	sEntry = INIENTRY_TOOLS_VOICEGUIDE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_nVoiceGuide = n;

	sEntry = INIENTRY_TOOLS_ZIPDLL;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_nToolZipDll = n;

	sEntry = INIENTRY_TOOLS_ZIPTESTDLL;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_nToolZipTestDll = n;

	s = _T("cmd.exe");
	sEntry = INIENTRY_TOOLS_F03EXE;
	m_sToolF03exe = pApp->GetProfileString(sSection, sEntry, s);

	s = _T("/k");
	sEntry = INIENTRY_TOOLS_F03OPTION;
	m_sToolF03Option = pApp->GetProfileString(sSection, sEntry, s);



	// [Settings]
	sSection = INISECTION_SETTINGS;

	sEntry = INIENTRY_SETTINGS_REDRAW_FOCUS;
	n = pApp->GetProfileInt(sSection, sEntry, 1);
	m_bInitRedrawFocus = (n != 0); 
	m_bRedrawFocus = (n != 0); 

	sEntry = INIENTRY_SETTINGS_EXTENTION_SOUND;
	m_sExtentionsSound = pApp->GetProfileString(sSection, sEntry, _T(".MP3;.WAV;.MID;.WMA;.MPG;"));

	sEntry = INIENTRY_SETTINGS_EXTENTION_RUN;
	m_sExtentionsRun = pApp->GetProfileString(sSection, sEntry, _T(".EXE;.COM;.CMD;.BAT;"));

	sEntry = INIENTRY_SETTINGS_EXTENTION_IMAGE;
	m_sExtentionsImage = pApp->GetProfileString(sSection, sEntry, _T(".BMP;.JPG;.GIF;.PNG;.TIFF;.DIB;.ICO;.JPEG;.EMF;.WMF;"));

	sEntry = INIENTRY_SETTINGS_HOME_FOLDER;
	m_sHomeFolder = pApp->GetProfileString(sSection, sEntry, _T(""));

	sEntry = INIENTRY_SETTINGS_PACK_ARCHIVER;
	m_nPackArchiver = pApp->GetProfileInt(sSection, sEntry, 1);

	sEntry = INIENTRY_SETTINGS_MOVE_HISTORY_FILE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bMoveHistoryFile = (n != 0);

	sEntry = INIENTRY_SETTINGS_AUTOCOMPLETE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsAutocomplete = (n != 0);

	sEntry = INIENTRY_SETTINGS_SHORTTITLE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsShortTitle = (n != 0);

	sEntry = INIENTRY_SETTINGS_ADDCOPYSTR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsAddCopyStr = (n != 0);

	sEntry = INIENTRY_SETTINGS_ENTERKEYRUNSYSTEM;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsEnterKeyRunSystem = (n != 0);

	sEntry = INIENTRY_SETTINGS_DELETEDIRWARING;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsDeleteDirWarning = (n != 0);

	sEntry = INIENTRY_SETTINGS_SELECT_DROPEFFECT;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsSelectDropEffect = (n != 0);

	sEntry = INIENTRY_SETTINGS_DRAWSEC;
	n = pApp->GetProfileInt(sSection, sEntry, 1);
	m_bSettingsDrawSec = (n != 0);

	sEntry = INIENTRY_SETTINGS_WINMENU_RB;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsWinMenuRB = (n != 0);

	sEntry = INIENTRY_SETTINGS_SET_DIALOG_FONT;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsSetDialogFont = (n != 0);

	sEntry = INIENTRY_SETTINGS_USE_CURRENT_HISTORY;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsUseCurrentHistory = (n != 0);

	sEntry = INIENTRY_SETTINGS_HOLD_CHANGE_ATT;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bSettingsHoldChangeAtt = (n != 0);

	sEntry = INIENTRY_SETTINGS_ANNSVIEW_HAVE_PRIORITY;
	n = pApp->GetProfileInt(sSection, sEntry, 1);
	m_bInitannsViewHavePriority = (n != 0);
	m_bSettingsannsViewHavePriority = (n != 0);

	// [annsView]
	sSection = INISECTION_ANNSVIEW;

	sEntry = INIENTRY_ANNSVIEW_DELTA_LINE;
	n = pApp->GetProfileInt(sSection, sEntry, 3);
	if ( n >= 1 && n <= 9) m_ViewDeltaLine = n;	// XN[s 1`9

	sEntry = INIENTRY_ANNSVIEW_TAB_NUM;
	n = pApp->GetProfileInt(sSection, sEntry, 4);
	if ( n >= 2 && n <= 8) m_ViewTabNum = n;	// tab 2`8

	sEntry = INIENTRY_ANNSVIEW_NOT_RESIZE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bViewNotResize = (n != 0); 

	sEntry = INIENTRY_ANNSVIEW_COLOR_GUIDE;
	s = pApp->GetProfileString(sSection, sEntry, _T("808080"));
	m_colViewGuide = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_ANNSVIEW_COLOR_GUIDEDATA;
	s = pApp->GetProfileString(sSection, sEntry, _T("ffff00"));
	m_colViewGuideData = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_ANNSVIEW_COLOR_TEXT;
	s = pApp->GetProfileString(sSection, sEntry, _T("ffffff"));
	m_colViewText = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_ANNSVIEW_COLOR_RETMARK;
	s = pApp->GetProfileString(sSection, sEntry, _T("808080"));
	m_colViewRetMark = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_ANNSVIEW_COLOR_BACK;
	s = pApp->GetProfileString(sSection, sEntry, _T("400000"));
	m_colViewBack = wcstol(s.GetBuffer(), NULL, 16);

	sEntry = INIENTRY_ANNSVIEW_LINE_SPACE;
	n = pApp->GetProfileInt(sSection, sEntry, VIEW_LINE_SPACE);
	if ( n >= 1 && n <= 9) m_nViewLineSpace = n;	// sԃXy[X 1`9

	sEntry = INIENTRY_ANNSVIEW_ADJUST_SIZE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bViewAdjustSize = (n != 0);

	sEntry = INIENTRY_ANNSVIEW_INIT_BACKCOLOR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	if (n >= 0 && n <= 3) m_nViewBackColor = n;	// wiF

	sEntry = INIENTRY_ANNSVIEW_AUTO_ORIENTATION;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bAutoOrientation = (n != 0);

	sEntry = INIENTRY_ANNSVIEW_EXIF_CMD;
	m_sViewExifCmd = pApp->GetProfileString(sSection, sEntry, _T("BonsExif.exe"));

	sEntry = INIENTRY_ANNSVIEW_EXIF_PARAM;
	m_sViewExifParam = pApp->GetProfileString(sSection, sEntry, _T("%s"));


	sEntry = INIENTRY_ANNSVIEW_FONT_NAME;
	s = pApp->GetProfileString(sSection, sEntry, _T("lr SVbN"));

	sEntry = INIENTRY_ANNSVIEW_FONT_HEIGHT;
	fh = pApp->GetProfileInt(sSection, sEntry, 12);
	// |CgtHg̍ɕϊ
//	CClientDC dc(AfxGetMainWnd());

	m_logfontView.lfHeight = -::MulDiv(fh, dc.GetDeviceCaps(LOGPIXELSY), 72);

	sEntry = INIENTRY_ANNSVIEW_FONT_WEIGHT;
	m_logfontView.lfWeight = pApp->GetProfileInt(sSection, sEntry, 0x190);

	sEntry = INIENTRY_ANNSVIEW_FONT_STYLE;
	m_logfontView.lfItalic = pApp->GetProfileInt(sSection, sEntry, 0);

	m_logfontView.lfWidth = 0;
	m_logfontView.lfEscapement = 0;
	m_logfontView.lfOrientation = 0;
	m_logfontView.lfWeight = 0x190;
	m_logfontView.lfItalic = 0;
	m_logfontView.lfUnderline = 0;
	m_logfontView.lfStrikeOut = 0;
	m_logfontView.lfCharSet = 0x80;
	m_logfontView.lfOutPrecision = 3;
	m_logfontView.lfClipPrecision = 2;
	m_logfontView.lfQuality = 1;
	m_logfontView.lfPitchAndFamily = 0x31;
	lstrcpy(&(m_logfontView.lfFaceName[0]), s);

	m_logfontViewGuide = m_logfontView;

	sEntry = INIENTRY_ANNSVIEW_DIRECTWRITE;
	n = pApp->GetProfileInt(sSection, sEntry, 1);
	m_bViewDirectWrite = (n != 0);

	sEntry = INIENTRY_ANNSVIEW_ANNSFMTEXT_EXE;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bViewannsFMtextExe = (n != 0);


	if (m_nOSversion < 7) {
		m_bViewDirectWrite = 0;
	}


	// [BarStatus]
	sSection = INISECTION_BARSTATUS;

	sEntry = INIENTRY_BARSTATUS_ENABLE_TOOLBAR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_EnableToolBar = (n != 0);

	sEntry = INIENTRY_BARSTATUS_ENABLE_SHIFT_KEY_TOOLBAR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_EnableShiftKeyToolBar = (n != 0);

	sEntry = INIENTRY_BARSTATUS_ENABLE_CTRL_KEY_TOOLBAR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_EnableCtrlKeyToolBar = (n != 0);

	sEntry = INIENTRY_BARSTATUS_ENABLE_STATUSBAR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_EnableStatusBar = (n != 0);

	// [Parameter]
	sSection = INISECTION_PARAMETER;

	sEntry = INIENTRY_PARAMETER_HIDE_DRIVE_TAB;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bHideDriveTab = (n != 0); 

	sEntry = INIENTRY_PARAMETER_WILDCARD_ADDSTR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	m_bAddstr = (n != 0); 

}

void CFmParam::WriteIniFile(void)
{
	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	CString s;

	// [System]
	sSection = INISECTION_SYSTEM;
/*
	sEntry = INIENTRY_SYSTEM_DRIVETAB_MAXWIDTH;
	pApp->WriteProfileInt(sSection, sEntry, m_DriveTabMaxWidth);
	sEntry = INIENTRY_SYSTEM_DRIVETAB_HEIGHT;
	pApp->WriteProfileInt(sSection, sEntry, m_DriveTabHeight);
*/
	sEntry = INIENTRY_SYSTEM_DIRECTWRITE;
	pApp->WriteProfileInt(sSection, sEntry, m_bSystemDirectWrite);

	sEntry = INIENTRY_SYSTEM_COLOR_BACK;
	s.Format(_T("%06x"), m_colBack);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_SYSTEM_COLOR_FRAME;
	s.Format(_T("%06x"), m_colFrame);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_ITEM;
	s.Format(_T("%06x"), m_colInfoItem);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_DATA;
	s.Format(_T("%06x"), m_colInfoData);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_TIME;
	s.Format(_T("%06x"), m_colInfoTime);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_SYSTEM_COLOR_INFO_LABEL;
	s.Format(_T("%06x"), m_colInfoLabel);
	pApp->WriteProfileString(sSection, sEntry, s);



	s = m_logfontFile.lfFaceName;

	sEntry = INIENTRY_SYSTEM_FONT_HEIGHT;
// tHg̍|Cgɕϊ
	CClientDC dc(AfxGetMainWnd());
	int nPoint = -::MulDiv(m_logfontFile.lfHeight, 72, dc.GetDeviceCaps(LOGPIXELSY));
	pApp->WriteProfileInt(sSection, sEntry, nPoint);

	sEntry = INIENTRY_SYSTEM_FONT_NAME;
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_SYSTEM_FONT_WEIGHT;
	pApp->WriteProfileInt(sSection, sEntry, m_logfontFile.lfWeight);

	sEntry = INIENTRY_SYSTEM_FONT_STYLE;
	pApp->WriteProfileInt(sSection, sEntry, m_logfontFile.lfItalic);

	sEntry = INIENTRY_SYSTEM_LINE_SPACE;
	pApp->WriteProfileInt(sSection, sEntry, m_nLineSpace);

	sEntry = INIENTRY_SYSTEM_UPDATE_TIME;
	pApp->WriteProfileInt(sSection, sEntry, m_nUpdateTime);

	// [Boot]
	sSection = INISECTION_BOOT;

	sEntry = INIENTRY_BOOT_CURRENT_DIR;
	pApp->WriteProfileString(sSection, sEntry, m_sInitCurrentDir);

	sEntry = INIENTRY_BOOT_DISPLAY_MODE;
	pApp->WriteProfileInt(sSection, sEntry, m_InitDisplayMode);

	sEntry = INIENTRY_BOOT_DISPLAY_HIDEFILE;
	pApp->WriteProfileInt(sSection, sEntry, m_bInitDisplayHide);

	sEntry = INIENTRY_BOOT_DISPLAY_SYSFILE;
	pApp->WriteProfileInt(sSection, sEntry, m_bInitDisplaySystem);

	sEntry = INIENTRY_BOOT_SORT_MODE;
	pApp->WriteProfileInt(sSection, sEntry, m_InitSortMode);

	sEntry = INIENTRY_BOOT_SORT_ORDER;
	pApp->WriteProfileInt(sSection, sEntry, m_bInitSortOrder);

	sEntry = INIENTRY_BOOT_READ_KEY_MAP;
	pApp->WriteProfileInt(sSection, sEntry, m_bInitReadKeyMap);

	sEntry = INIENTRY_BOOT_BOOT_LAST_PATH;
	pApp->WriteProfileInt(sSection, sEntry, m_bBootLastPath);

	sEntry = INIENTRY_BOOT_SORT_EXPLORER;
	pApp->WriteProfileInt(sSection, sEntry, m_bInitSortExplorer);

	

	// [Tools]
	sSection = INISECTION_TOOLS;

	sEntry = INIENTRY_TOOLS_EDITOR;
	pApp->WriteProfileString(sSection, sEntry, m_sToolEditor);
	sEntry = INIENTRY_TOOLS_BINARYEDITOR;
	pApp->WriteProfileString(sSection, sEntry, m_sToolBinaryEditor);
	/*
	sEntry = INIENTRY_TOOLS_TEXTVIEWER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolTextViewer);
	sEntry = INIENTRY_TOOLS_GRAPHICVIEWER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolGraphicViewer);
*/
	sEntry = INIENTRY_TOOLS_ARCHIVER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolArchiver);

	sEntry = INIENTRY_TOOLS_BROWSER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolBrowser);

	sEntry = INIENTRY_TOOLS_MOVIEPLAYER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolMoviePlayer);

/*
	sEntry = INIENTRY_TOOLS_OPTION_EDITOR;
	pApp->WriteProfileString(sSection, sEntry, m_sToolOptionEditor);
	sEntry = INIENTRY_TOOLS_OPTION_BINARYEDITOR;
	pApp->WriteProfileString(sSection, sEntry, m_sToolOptionBinaryEditor);
	sEntry = INIENTRY_TOOLS_OPTION_TEXTVIEWER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolOptionTextViewer);
	sEntry = INIENTRY_TOOLS_OPTION_GRAPHICVIEWER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolOptionGraphicViewer);
	sEntry = INIENTRY_TOOLS_OPTION_ARCHIVER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolOptionArchiver);

	sEntry = INIENTRY_TOOLS_EXT_GRAPHICVIEWER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolExtGraphicViewer);
*/

	sEntry = INIENTRY_TOOLS_EXT_ARCHIVER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolExtArchiver);

	sEntry = INIENTRY_TOOLS_EXT_BROWSER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolExtBrowser);

	sEntry = INIENTRY_TOOLS_EXT_MOVIEPLAYER;
	pApp->WriteProfileString(sSection, sEntry, m_sToolExtMoviePlayer);

	sEntry = INIENTRY_TOOLS_EXT_TAR;
	pApp->WriteProfileString(sSection, sEntry, m_sToolExtTar);

	sEntry = INIENTRY_TOOLS_BONSEXIF;
	pApp->WriteProfileString(sSection, sEntry, m_sToolBonsExif);

//	sEntry = INIENTRY_TOOLS_USELMZIP32;
//	pApp->WriteProfileInt(sSection, sEntry, m_bToolUseLMZIP32);

	sEntry = INIENTRY_TOOLS_PATH_SPI;
	pApp->WriteProfileString(sSection, sEntry, m_sToolPathSPI);

	sEntry = INIENTRY_TOOLS_SPI_PARAMFILE_PATH;
	pApp->WriteProfileString(sSection, sEntry, m_sToolSPISettingFile);


	sEntry = INIENTRY_TOOLS_USESPI;
	pApp->WriteProfileInt(sSection, sEntry, m_bToolUseSPI);

//	sEntry = INIENTRY_TOOLS_USENVDA;
//	pApp->WriteProfileInt(sSection, sEntry, m_bToolUseNVDA);

	sEntry = INIENTRY_TOOLS_VOICEGUIDE;
	pApp->WriteProfileInt(sSection, sEntry, m_nVoiceGuide);

	sEntry = INIENTRY_TOOLS_ZIPDLL;
	pApp->WriteProfileInt(sSection, sEntry, m_nToolZipDll);

	sEntry = INIENTRY_TOOLS_ZIPTESTDLL;
	pApp->WriteProfileInt(sSection, sEntry, m_nToolZipTestDll);

	sEntry = INIENTRY_TOOLS_F03EXE;
	pApp->WriteProfileString(sSection, sEntry, m_sToolF03exe);

	sEntry = INIENTRY_TOOLS_F03OPTION;
	pApp->WriteProfileString(sSection, sEntry, m_sToolF03Option);


	// [Settings]
	sSection = INISECTION_SETTINGS;

	sEntry = INIENTRY_SETTINGS_REDRAW_FOCUS;
	pApp->WriteProfileInt(sSection, sEntry, m_bInitRedrawFocus);

	sEntry = INIENTRY_SETTINGS_EXTENTION_SOUND;
	pApp->WriteProfileString(sSection, sEntry, m_sExtentionsSound);

	sEntry = INIENTRY_SETTINGS_EXTENTION_RUN;
	pApp->WriteProfileString(sSection, sEntry, m_sExtentionsRun);

	sEntry = INIENTRY_SETTINGS_EXTENTION_IMAGE;
	pApp->WriteProfileString(sSection, sEntry, m_sExtentionsImage);

	sEntry = INIENTRY_SETTINGS_HOME_FOLDER;
	pApp->WriteProfileString(sSection, sEntry, m_sHomeFolder);

	sEntry = INIENTRY_SETTINGS_PACK_ARCHIVER;
	pApp->WriteProfileInt(sSection, sEntry, m_nPackArchiver);

	sEntry = INIENTRY_SETTINGS_MOVE_HISTORY_FILE;
	pApp->WriteProfileInt(sSection, sEntry, m_bMoveHistoryFile);

	sEntry = INIENTRY_SETTINGS_AUTOCOMPLETE;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsAutocomplete);

	sEntry = INIENTRY_SETTINGS_SHORTTITLE;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsShortTitle);

	sEntry = INIENTRY_SETTINGS_ADDCOPYSTR;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsAddCopyStr);

	sEntry = INIENTRY_SETTINGS_ENTERKEYRUNSYSTEM;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsEnterKeyRunSystem);

	sEntry = INIENTRY_SETTINGS_DELETEDIRWARING;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsDeleteDirWarning);

	sEntry = INIENTRY_SETTINGS_SELECT_DROPEFFECT;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsSelectDropEffect);

	sEntry = INIENTRY_SETTINGS_DRAWSEC;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsDrawSec);

	sEntry = INIENTRY_SETTINGS_WINMENU_RB;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsWinMenuRB);

	sEntry = INIENTRY_SETTINGS_SET_DIALOG_FONT;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsSetDialogFont);

	sEntry = INIENTRY_SETTINGS_USE_CURRENT_HISTORY;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsUseCurrentHistory);

	sEntry = INIENTRY_SETTINGS_HOLD_CHANGE_ATT;
	pApp->WriteProfileInt(sSection, sEntry, m_bSettingsHoldChangeAtt);

	sEntry = INIENTRY_SETTINGS_ANNSVIEW_HAVE_PRIORITY;
	pApp->WriteProfileInt(sSection, sEntry, m_bInitannsViewHavePriority);
	m_bSettingsannsViewHavePriority = m_bInitannsViewHavePriority;


	// [FileList]
	sSection = INISECTION_FILELIST;

	sEntry = INIENTRY_FILELIST_COLOR_DIR;
	s.Format(_T("%06x"), m_colListDir);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_FILELIST_COLOR_NORMAL;
	s.Format(_T("%06x"), m_colListNormal);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_FILELIST_COLOR_RONLY;
	s.Format(_T("%06x"), m_colListReadonly);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_FILELIST_COLOR_HIDDEN;
	s.Format(_T("%06x"), m_colListHide);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_FILELIST_COLOR_SYSTEM;
	s.Format(_T("%06x"), m_colListSystem);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_FILELIST_CYCLICAL_CURSOR;
	pApp->WriteProfileInt(sSection, sEntry, m_bListCyclicalCursor);

	sEntry = INIENTRY_FILELIST_CURSOR_MOVEPAGE;
	pApp->WriteProfileInt(sSection, sEntry, m_bListCursorMovePage);

	sEntry = INIENTRY_FILELIST_MARK_AST;
	pApp->WriteProfileInt(sSection, sEntry, m_bListMarkAst);

	

	// [FileList#n]
	for ( int i = 0; i < 5; i++ ) {
		sSection.Format(_T("%s%d"), INISECTION_FILELIST, i+1);

		sEntry = INIENTRY_FILELIST_DISPLAY_NAME_TYPE;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_DisplayNameType);

		sEntry = INIENTRY_FILELIST_NAME_LEN;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_NameLen);

		sEntry = INIENTRY_FILELIST_EXT_LEN;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_ExtLen);

		sEntry = INIENTRY_FILELIST_KIND_DATE;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_KindDate);

		sEntry = INIENTRY_FILELIST_SHOW_SPLIT_EXT;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowSplitExt);

		sEntry = INIENTRY_FILELIST_NOT_SPLIT_DIR_EXT;
	//	pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[0].m_bNotSplitDirExt);

		sEntry = INIENTRY_FILELIST_SHOW_SIZE;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowSize);

		sEntry = INIENTRY_FILELIST_SHOW_UNIT_SIZE;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowUnitSize);

		sEntry = INIENTRY_FILELIST_SHOW_OVER_PART;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowOverPart);

		sEntry = INIENTRY_FILELIST_SHOW_DATE;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowDate);

		sEntry = INIENTRY_FILELIST_SHOW_TIME;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowTime);

		sEntry = INIENTRY_FILELIST_SHOW_FULL_CENTURY;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowFullCentury);

		sEntry = INIENTRY_FILELIST_SHOW_SECOND;
	//	pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[0].m_bShowSecond);

		sEntry = INIENTRY_FILELIST_SHOW_ATRIBUTE;
		pApp->WriteProfileInt(sSection, sEntry, m_pFileParam[i].m_bShowAtribute);
	}

	// [annsView]
	sSection = INISECTION_ANNSVIEW;
	sEntry = INIENTRY_ANNSVIEW_DELTA_LINE;
	pApp->WriteProfileInt(sSection, sEntry, m_ViewDeltaLine);

	sEntry = INIENTRY_ANNSVIEW_TAB_NUM;
	pApp->WriteProfileInt(sSection, sEntry, m_ViewTabNum);

	sEntry = INIENTRY_ANNSVIEW_COLOR_GUIDE;
	s.Format(_T("%06x"), m_colViewGuide);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_ANNSVIEW_COLOR_GUIDEDATA;
	s.Format(_T("%06x"), m_colViewGuideData);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_ANNSVIEW_COLOR_TEXT;
	s.Format(_T("%06x"), m_colViewText);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_ANNSVIEW_COLOR_RETMARK;
	s.Format(_T("%06x"), m_colViewRetMark);
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_ANNSVIEW_COLOR_BACK;
	s.Format(_T("%06x"), m_colViewBack);
	pApp->WriteProfileString(sSection, sEntry, s);

	sSection = INISECTION_ANNSVIEW;
	sEntry = INIENTRY_ANNSVIEW_LINE_SPACE;
	pApp->WriteProfileInt(sSection, sEntry, m_nViewLineSpace);

	sEntry = INIENTRY_ANNSVIEW_ADJUST_SIZE;
	pApp->WriteProfileInt(sSection, sEntry, m_bViewAdjustSize);

	sEntry = INIENTRY_ANNSVIEW_INIT_BACKCOLOR;
	pApp->WriteProfileInt(sSection, sEntry, m_nViewBackColor);

	sEntry = INIENTRY_ANNSVIEW_AUTO_ORIENTATION;
	pApp->WriteProfileInt(sSection, sEntry, m_bAutoOrientation);

	sEntry = INIENTRY_ANNSVIEW_EXIF_CMD;
	pApp->WriteProfileString(sSection, sEntry, m_sViewExifCmd);

	sEntry = INIENTRY_ANNSVIEW_EXIF_PARAM;
	pApp->WriteProfileString(sSection, sEntry, m_sViewExifParam);

	s = m_logfontView.lfFaceName;

	sEntry = INIENTRY_ANNSVIEW_FONT_HEIGHT;
	// tHg̍|Cgɕϊ
//	CClientDC dc(AfxGetMainWnd());
	nPoint = -::MulDiv(m_logfontView.lfHeight, 72, dc.GetDeviceCaps(LOGPIXELSY));
	pApp->WriteProfileInt(sSection, sEntry, nPoint);

	sEntry = INIENTRY_ANNSVIEW_FONT_NAME;
	pApp->WriteProfileString(sSection, sEntry, s);

	sEntry = INIENTRY_ANNSVIEW_FONT_WEIGHT;
	pApp->WriteProfileInt(sSection, sEntry, m_logfontView.lfWeight);

	sEntry = INIENTRY_ANNSVIEW_FONT_STYLE;
	pApp->WriteProfileInt(sSection, sEntry, m_logfontView.lfItalic);

	sEntry = INIENTRY_ANNSVIEW_DIRECTWRITE;
	pApp->WriteProfileInt(sSection, sEntry, m_bViewDirectWrite);

	sEntry = INIENTRY_ANNSVIEW_ANNSFMTEXT_EXE;
	pApp->WriteProfileInt(sSection, sEntry, m_bViewannsFMtextExe);

	// [BarStatus]
	sSection = INISECTION_BARSTATUS;
	sEntry = INIENTRY_BARSTATUS_ENABLE_TOOLBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_EnableToolBar);

	sEntry = INIENTRY_BARSTATUS_ENABLE_SHIFT_KEY_TOOLBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_EnableShiftKeyToolBar);

	sEntry = INIENTRY_BARSTATUS_ENABLE_CTRL_KEY_TOOLBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_EnableCtrlKeyToolBar);
/*
	sEntry = INIENTRY_BARSTATUS_ENABLE_STATUSBAR;
	pApp->WriteProfileInt(sSection, sEntry, m_EnableStatusBar);
*/



}

void CFmParam::WriteIniFileParameter(void)
{
	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
//	CString s;

	// [Parameter]
	sSection = INISECTION_PARAMETER;

	sEntry = INIENTRY_PARAMETER_HIDE_DRIVE_TAB;
	pApp->WriteProfileInt(sSection, sEntry, m_bHideDriveTab);

	sEntry = INIENTRY_PARAMETER_WILDCARD_ADDSTR;
	pApp->WriteProfileInt(sSection, sEntry, m_bAddstr);
}


// t@C̑A[JCû݂ɕύX
// ݗpɕύX邽
// fname : ύXt@C̃tpX 
void CFmParam::SetArchAttribute(CString fname)
{
	CFileStatus rStatus;
	CFile::GetStatus(fname, rStatus);

//	byte at = rStatus.m_attribute;
	DWORD at = rStatus.m_attribute;

	at = at & !_A_RDONLY;
	at = at & !_A_HIDDEN;
	at = at & !_A_SYSTEM;

	rStatus.m_attribute = at;
	rStatus.m_mtime = 0;
	bool bErr = false;
	try
	{
		CFile::SetStatus(fname, rStatus);
	}
	catch (CFileException* pEx)
	{
		CString s;
		s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
		MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("ANZXG["), MB_OK);
		pEx->Delete();
		bErr = true;
	}
//	CFile::SetStatus(fname, rStatus);
}


// 1t@CRs[
// m_CopySourcePath : ʌpX(\t)
// m_CopyDestPath : ʐpX(\t)
// m_CopyFileName : t@C
void CFmParam::CopyOneFile(void)
{
	CString sfile, dfile, sstime, sdtime, sUnit, s, s2, form, sSize, tmp;
	CFileStatus rStatus, sStatus;
	__time64_t stime, dtime;
	__int64 sfsize, dfsize;
//	__int64 sfsize, dfsize, fsize;

	sfile = m_CopySourcePath;
	sfile += m_CopyFileName;
	dfile = m_CopyDestPath;
	dfile += m_CopyFileName;

	CFile::GetStatus(sfile, rStatus);
	sStatus = rStatus;
	stime = rStatus.m_mtime.GetTime();
	sstime = GetTimeStr(stime);
	sfsize = rStatus.m_size;
//	sUnit = _T("");
//	fsize = CalcFileSize(sfsize, sUnit);
	form = _T("%I64d");
	sSize.Format(form, sfsize);
	InsertComma(sSize);


/*
	s.Format(form, fsize);
	InsertComma(s);
	if ( sUnit.GetLength() != 0 ) {
		form = _T("%8s%2s");
		sSize.Format(form, s, sUnit);
	} else {
		form = _T("%10s");
		sSize.Format(form, s);
	}
*/


	CSelectCopyDialog dlg;
	MyDispatchMessage();

	bool run = true;
	bool exist = false;
	if ( CFile::GetStatus(dfile, rStatus) ) {	// ʐt@C݂
		exist = true;
		run = false;
		dtime = rStatus.m_mtime.GetTime();
		sdtime = GetTimeStr(dtime);

		dlg.m_FileName = m_CopyFileName;
		dlg.m_SourcePath = m_CopySourcePath;
		dlg.m_SourceDate = sstime;
		dlg.m_SourceSize = sSize;

		dlg.m_DestPath = m_CopyDestPath;
		dlg.m_DestDate = sdtime;

		dfsize = rStatus.m_size;

/*
		sUnit = _T("");
//		fsize = CalcFileSize(dfsize, sUnit);

		__int64 ds, ib, ib2, size;

		size = sfsize;
		ds = dfsize;
		fsize = ds;

		ib = 1024;
		ib2 = ib * 1024;
		if (size > ib2) {
			fsize = ds / ib;
			sUnit = _T("KB");
		}

		ib *= 1024;
		ib2 = ib * 100;
		if (size > ib2) {
			fsize = ds / ib;
			sUnit = _T("MB");
		}

		ib *= 1024;
		ib2 = ib * 100;
		if (size > ib2) {
			fsize = ds / ib;
			sUnit = _T("GB");
		}

*/

		form = _T("%I64d");
		sSize.Format(form, dfsize);
		InsertComma(sSize);

/*
		s.Format(form, fsize);
		InsertComma(s);
		if ( sUnit.GetLength() != 0 ) {
			form = _T("%8s%2s");
			sSize.Format(form, s, sUnit);
		} else {
			form = _T("%10s");
			sSize.Format(form, s);
		}
*/

		if ( !m_CopySame ) {
			if ( sfile == dfile ) {
				m_CopyMode = COPY_CHANGENAME;
			} else {
				dlg.m_DestSize = sSize;
				dlg.DoModal();
				m_CopyMode = dlg.m_CopyMode;
				m_CopySame = dlg.m_CheckSame;
			}
		}
		if ( m_CopyMode == COPY_NON ) return;
		if ( m_CopyMode == COPY_CANCEL ) return;

		if ( m_CopyMode == COPY_NEWTIME ) {
			if ( stime > dtime ) run = true;
		}
		if ( m_CopyMode == COPY_OVERWRITE ) {
			run = true;
		}
		if ( m_CopyMode == COPY_CHANGENAME ) {
			CChangeNameDialog cdlg;
			cdlg.m_FileName = m_CopyFileName;
			cdlg.m_pFmParam = this;

			INT_PTR id;

			if (m_bSettingsAddCopyStr && m_TagFileNum == 0) {
				cdlg.m_FileName = _T("Copy_");
				cdlg.m_FileName += m_CopyFileName;
			}

			while(1) {
				id = cdlg.DoModal();
				if ( id == IDCANCEL ) {
					run = false;
					break;
				}
				CString dname;
				dname = m_CopyDestPath;
				dname += cdlg.m_FileName;
				if ( !CFile::GetStatus(dname, rStatus) ) {	// t@C݂Ȃ
					dfile = dname;
					run = true;
					break;
				}
				cdlg.m_Message = _T("̃t@C͊ɑ݂܂BVt@C͂ĂB");

			}
		}
		if ( m_CopyMode == COPY_CHANGEDESTNAME ) {
			CChangeNameDialog cdlg;
			cdlg.m_FileName = m_CopyFileName;
			INT_PTR id;
			cdlg.m_pFmParam = this;

			cdlg.m_Message = _T("ʂ܂͈ړ̃t@CύXĂB");
			while(1) {
				id = cdlg.DoModal();
				if ( id == IDCANCEL ) {
					run = false;
					break;
				}
				CString dname;
				dname = m_CopyDestPath;
				dname += cdlg.m_FileName;
				if ( !CFile::GetStatus(dname, rStatus) ) {	// t@C݂Ȃ

					try
					{
						CFile::Rename(dfile, dname);
						run = true;
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CύXł܂ł!"), dname);
						MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("G["), IDYES);
						pEx->Delete();
					}
//					CFile::Rename(dfile, dname);
//					run = true;
					break;
				}
				cdlg.m_Message = _T("̃t@C͊ɑ݂܂BVt@C͂ĂB");

			}
		}
	}

	CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pCopyInfoDlg;
	cidlg->m_FileName = m_CopyFileName;
	cidlg->m_SourcePath = m_CopySourcePath;
	cidlg->m_DestPath = m_CopyDestPath;

	__int64 fs, fd;
	fs = sfsize;
	fd = 0;

	CString path;
	__int64 dfreesize = -1;
//	path = m_CopyDestPath.Left(3);
	path = m_CopyDestPath;
	ULARGE_INTEGER FreeBytesAvailableToCaller;
	ULARGE_INTEGER TotalNumberOfBytes;
	ULARGE_INTEGER TotalNumberOfFreeBytes;

	BOOL ret = ::GetDiskFreeSpaceEx( path,
				 &FreeBytesAvailableToCaller,
				 &TotalNumberOfBytes,
				 &TotalNumberOfFreeBytes );
	if( ret == TRUE) {
		dfreesize = (__int64)TotalNumberOfFreeBytes.QuadPart;
	}

	CString sDFree;
	sDFree.Format(_T("%I64d"), dfreesize);
	InsertComma(sDFree);

	cidlg->m_FreeSize = sDFree;
	cidlg->UpdateData(FALSE);

	form = _T("%I64d");
	s.Format(form, fs);
	InsertComma(s);
	s2.Format(form, fd);
	InsertComma(s2);
	form = _T("%16s / %16s");
	sSize.Format(form, s2, s);
	cidlg->m_FileSize = sSize;
	cidlg->UpdateData(FALSE);
	cidlg->m_CtrlSize.SetRange(0, 100);
	cidlg->m_CtrlSize.SetStep(1);
	cidlg->m_CtrlSize.SetPos(0);
	MyDispatchMessage();

	if ( run ) {
		exist = false;
		if (CFile::GetStatus(dfile, rStatus)) {	// ʐt@C݂
			exist = true;
		}

		if ( m_CopyMove && (sfile.GetAt(0) == dfile.GetAt(0))) {
			if ( m_CopyMode != COPY_NON && exist ) {
				try
				{
					SetArchAttribute(dfile);
					CFile::Remove(dfile);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\n폜ł܂ł!"), dfile);
					MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("G["), IDYES);
					pEx->Delete();
				}
			}
			::MoveFile(sfile, dfile);
		} else {

			if ( sfsize > dfreesize ) {
				m_CopyMode = -1;
				CErrorDialog cedlg;
				CString tmp2, tmp3, tmp5;
				tmp3 = m_CopyDestPath.Left(2);

				cedlg.m_sMes1 = _T("\nʐ̗eʂsĂ܂B");
				cedlg.m_sMes2 = m_CopyFileName;
				tmp3.Format(_T("%I64d"), sfsize);
				InsertComma(tmp3);
				tmp2.Format(_T("%s%15s\n\n%s%15s"), _T("t@CTCY:"), tmp3, _T("ʐ󂫗e:"), sDFree);

				cedlg.m_sMes3 = tmp2;

				cedlg.DoModal();

				return;
			}

			CFile cfSource, cfDest;
			BOOL r;
			r = cfSource.Open(sfile, CFile::modeRead);
			while ( !r ) {	// I[vłȂ
				CFileErrorDialog edlg;
				edlg.m_FileName = sfile;
				CString tmp = _T("t@CI[vł܂!");
				int id;
				edlg.DoModal();
				id = edlg.m_ButtonId;
				if ( id == -1 ) {	// cancel
					m_CopyMode = -1;
					return;
				}
				if ( id == 0 ) {	// Ďs
					r = cfSource.Open(sfile, CFile::modeRead);
				}
				if ( id == 1 ) {	// XLbv
					return;
				}
			}

			CFileStatus dStatus;
			if ( CFile::GetStatus(dfile, dStatus) ) {	// t@C݂
				SetArchAttribute(dfile);
			}
			r = cfDest.Open(dfile, CFile::modeCreate | CFile::modeWrite);
			while ( !r ) {
				CFileErrorDialog edlg;
				edlg.m_FileName = dfile;
				CString tmp = _T("t@CI[vł܂!");
				int id;
				edlg.DoModal();
				id = edlg.m_ButtonId;
				if ( id == -1 ) {	// cancel
					m_CopyMode = -1;
					return;
				}
				if ( id == 0 ) {	// Ďs
					r = cfDest.Open(dfile, CFile::modeCreate | CFile::modeWrite);
				}
				if ( id == 1 ) {	// XLbv
					return;
				}
			}



			while ( sfsize > 0 ) {

				if ( cidlg->m_Cancel == true ) {
					cidlg->m_Cancel = false;
					tmp = _T("t@C̕ʂ܂͈ړ𒆒f܂H");
					s = _T("f");
					int id = MessageBox(cidlg->m_hWnd, tmp, s, MB_YESNO);
					if ( id == IDYES ) {
						m_CopyMode = -1;
						cfSource.Close();
						cfDest.Close();
						CFile::Remove(dfile);
						return;
					}
				}
				UINT n = cfSource.Read(m_pCopyBuff, m_CopyBuffSize);
				cfDest.Write(m_pCopyBuff, n);
				sfsize -= n;
				fd += n;
				int pos = (int)(fd * 100 / fs);

				form = _T("%I64d");
				s.Format(form, fs);
				InsertComma(s);
				s2.Format(form, fd);
				InsertComma(s2);
				form = _T("%16s / %16s");
				sSize.Format(form, s2, s);
				cidlg->m_FileSize = sSize;
				cidlg->UpdateData(FALSE);
				cidlg->m_CtrlSize.SetPos(pos);
				cidlg->m_CtrlSize.Invalidate();
				MyDispatchMessage();
			}
			cfSource.Close();
			cfDest.Close();

			bool bErr = false;
			try
			{
				CFile::SetStatus(dfile, sStatus);
			}
			catch (CFileException* pEx)
			{
				CString s;
				s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), dfile);
				MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("ANZXG["), MB_OK);
				pEx->Delete();
				bErr = true;
			}
	//		CFile::SetStatus(dfile, sStatus);
			if ( m_CopyMove ) {
				CFile::GetStatus(sfile, rStatus);
				rStatus.m_attribute = 0;

				bool bErr = false;
				try
				{
					CFile::SetStatus(sfile, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), sfile);
					MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("ANZXG["), MB_OK);
					pEx->Delete();
					bErr = true;
				}
	//			CFile::SetStatus(sfile, rStatus);

						try
						{
							CFile::Remove(sfile);
						}
						catch (CFileException* pEx)
						{
							CString s;
							s.Format(_T("[ %s ]\n폜ł܂ł!"), sfile);
							MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("G["), IDYES);
							pEx->Delete();
						}
	//			CFile::Remove(sfile);
			}
		}
	} else {

		cidlg->m_CtrlSize.SetRange(0, 100);
		cidlg->m_CtrlSize.SetStep(1);
		cidlg->m_CtrlSize.SetPos(100);

		form = _T("%d");
		s.Format(form, fs);
		InsertComma(s);
		s2.Format(form, fd);
		InsertComma(s2);
		form = _T("%16s / %16s");
		sSize.Format(form, s2, s);
		cidlg->m_FileSize = sSize;
		cidlg->UpdateData(FALSE);
		cidlg->m_CtrlSize.Invalidate();
		MyDispatchMessage();
	}
	m_pCopyInfoDlg->SetFocus();

}

// ߂l  -1:G[  0:DIRłȂ  1:DIRRs[I
int CFmParam::CopyDirectory(void)
{
	CString sfile, dfile, sstime, sdtime, sUnit, s, s2, form, sSize, tmp, tmp2;
	CFileStatus rStatus, sStatus;
	bool cd = false;
//	__time64_t stime, dtime;
//	__int64 sfsize, dfsize, fsize;

	sfile = m_CopySourcePath;
	sfile += m_CopyFileName;
	dfile = m_CopyDestPath;
	dfile += m_CopyFileName;

	CFile::GetStatus(sfile, rStatus);
	int at = rStatus.m_attribute;
	if ( (at & _A_SUBDIR) == 0 ) {	// DIRłȂ
		return 0;
	}

	if ( sfile == dfile ) {

		CChangeNameDialog cdlg;
		cdlg.m_FileName = m_CopyFileName;
		INT_PTR id;
		cdlg.m_bDir = true;
		cdlg.m_pFmParam = this;

		while(1) {
			id = cdlg.DoModal();
			if ( id == IDCANCEL ) {
				return -1;
			}
			if ( cdlg.m_FileName != m_CopyFileName ) {	// ύXꂽ
				 m_CopyFileName = cdlg.m_FileName; 
				dfile = m_CopyDestPath;
				dfile += m_CopyFileName;
				break;
			} else {
				cdlg.m_Message = _T("VtH_͂ĂB");
			}
		}
	}

	if ( !CFile::GetStatus(dfile, rStatus) ) {	// ʐDIR݂Ȃ
		if ( !MakeDirectory(dfile) ) {
			CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pCopyInfoDlg;
			tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
			tmp.Format(tmp2, dfile);
			tmp2 = _T("Error!");
			MessageBox(cidlg->m_hWnd, tmp, NULL,  MB_ICONERROR | MB_OK);
			return -1;
		}
		cd = true;
	}
	struct _wfinddata64_t c_file;
	intptr_t hFile;
	CString fpath, fn, mydir, parentdir, wCard;
	bool fdir = false;

	mydir = _T(".");
	parentdir = _T("..");

	wCard = _T("\\*.*");
	fpath = sfile + wCard;

	CString spath, dpath, fname;
	int iret = 1;
	if( (hFile = _wfindfirst64( fpath, &c_file )) != -1L ) {
		spath = m_CopySourcePath;	// ޔ
		dpath = m_CopyDestPath;	// ޔ
		fname = m_CopyFileName;	// ޔ

		while( true ) {
			if ( ((CCopyInfoDialog*)m_pCopyInfoDlg)->m_Cancel ) m_bCancelCopy = true;
			if ( m_bCancelCopy ) break;
			at = c_file.attrib;
			fn = c_file.name;
			m_CopySourcePath = sfile;
			m_CopySourcePath += STR_YEN;
			m_CopyDestPath = dfile;
			m_CopyDestPath += STR_YEN;
			m_CopyFileName = fn;

			if ( (at & _A_SUBDIR) != 0 ) {	// DIRȂ
				if  ( (fn != mydir) && (fn != parentdir) ) {
					iret = CopyDirectory();
					if ( iret == -1 ) break;
				}
			} else {
				CopyOneFile();

				if ( m_CopyMode == COPY_CANCEL ) {
					iret = -1;
					break;
				}

			}

			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose( hFile );
		m_CopySourcePath = spath;	// A
		m_CopyDestPath = dpath;	// A
		m_CopyFileName = fname;	// A
		MyDispatchMessage();
	}

	if ( cd ) {
		SetDirTime(sfile, dfile);
		CFile::GetStatus(sfile, sStatus);
		sStatus.m_mtime = 0;
		sStatus.m_ctime = 0;
		sStatus.m_atime = 0;
		bool bErr = false;
		try
		{
			CFile::SetStatus(dfile, sStatus);
		}
		catch (CFileException* pEx)
		{
			CString s;
			s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), dfile);
			MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("ANZXG["), MB_OK);
			pEx->Delete();
			bErr = true;
		}
//		CFile::SetStatus(dfile, sStatus);
	}

	if ( (iret == 1) && (m_CopyMove) ) {
		CFile::GetStatus(sfile, rStatus);
		rStatus.m_attribute = 0;
		rStatus.m_mtime = 0;

		bool bErr = false;
		try
		{
			CFile::SetStatus(sfile, rStatus);
		}
		catch (CFileException* pEx)
		{
			CString s;
			s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), sfile);
			MessageBox(m_pCopyInfoDlg->m_hWnd, s, _T("ANZXG["), MB_OK);
			pEx->Delete();
			bErr = true;
		}
//		CFile::SetStatus(sfile, rStatus);
		RemoveDirectory(sfile);
	}


	return iret;
}

bool CFmParam::MakeDirectory(CString path)
{
	CString npath;
	BOOL r;
	bool br;

	int len = path.GetLength() - 1;
//	if ( path.GetAt(len) == CHAR_YEN ) path.SetAt(len, CHAR_NULL);	// Ōオ'\'̏ꍇ'\'菜
	if ( path.GetAt(len) == CHAR_YEN ) path = path.Left(len);	// Ōオ'\'̏ꍇ'\'菜

	r = CreateDirectory(path, NULL);

	if ( !r ) {
		int n = path.ReverseFind(CHAR_YEN);
		if ( n < 3 ) return false;
		npath = path.Left(n);
		br = MakeDirectory(npath);
		if ( !br ) return br;
		else {
			r = CreateDirectory(path, NULL);
			if ( !r ) return false;
			else br = true;
		}
	} else br = true;

	return br;
}


// path犮SȃpX쐬
// JghCuƎw肳ꂽhCũJgfBNgl
// hCu܂܂ĂȂꍇ̓JghCu
// UNCɂΉ
bool CFmParam::MakeFullPath(CString path)
{
	CString fpath, cpath;
	int dn;

	m_FullPath = "";
	fpath = path;
	int len = path.GetLength() - 1;
	wchar_t wc[1000];

//	if ( (path.GetLength() > 3) && (path.GetAt(len) == CHAR_YEN) ) fpath.SetAt(len, CHAR_NULL);	// Ōオ'\'̏ꍇ'\'菜
	if ( (path.GetLength() > 3) && (path.GetAt(len) == CHAR_YEN) ) fpath = fpath.Left(len);	// Ōオ'\'̏ꍇ'\'菜

	if ( (fpath.GetAt(0) == CHAR_YEN) && (fpath.GetAt(1) == CHAR_YEN) ) {	// UNC
		if ( fpath.GetAt(len) != CHAR_YEN ) fpath += STR_YEN;	// Ōオ'\'łȂꍇ'\'ǉ
		m_FullPath = fpath;
		BOOL r = PathCanonicalize(wc, m_FullPath);
		if ( r ) m_FullPath.Format(_T("%s"), wc);
		return true;
	}

	if ( fpath.GetAt(1) == CHAR_COLON ) {	// hCu
		if ( fpath.GetAt(2) == CHAR_YEN ) {	// ':\'  = tpX
			m_FullPath = fpath;
			TCHAR c;
			c = fpath.GetAt(0);
			if ( c >= 0x61 ) m_FullPath.SetAt(0, c - 0x20);
			BOOL r = PathCanonicalize(wc, m_FullPath);
			if ( r ) m_FullPath.Format(_T("%s"), wc);
			return true;
		}

		if ( ((fpath.GetAt(0) >= 'A') && (fpath.GetAt(0) <= 'Z')) || ((fpath.GetAt(0) >= 'a') && (fpath.GetAt(0) <= 'z')) ) {
			dn = (int)fpath.GetAt(0);
			dn -= 0x41;
			if ( fpath.GetAt(0) >= 'a' ) dn -= 0x20;
			cpath = m_pDriveParam->m_pCurrentPath[dn];
			if ( fpath.GetLength() > 2 ) cpath += fpath.Right(fpath.GetLength() - 2);
			else {
				len = cpath.GetLength() - 1;
//				if ( (cpath.GetLength() > 3) && (cpath.GetAt(len) == CHAR_YEN) ) cpath.SetAt(len, CHAR_NULL);	// Ōオ'\'̏ꍇ'\'菜
				if ( (cpath.GetLength() > 3) && (cpath.GetAt(len) == CHAR_YEN) ) cpath = cpath.Left(len);	// Ōオ'\'̏ꍇ'\'菜
			}
			m_FullPath = cpath;
			BOOL r = PathCanonicalize(wc, m_FullPath);
			if ( r ) m_FullPath.Format(_T("%s"), wc);

		} else {
			return false;
		}

	} else {	// hCuȂ = JghCu
		dn = m_CurrentDriveNo;
		cpath = m_pDriveParam->m_pCurrentPath[dn];
		if ( fpath.GetAt(0) == CHAR_YEN ) {	// 擪\ //
			cpath = cpath.Left(2);
		}
//		cpath += STR_YEN;
		cpath += fpath;
		m_FullPath = cpath;
//		m_FullPath += STR_YEN;
		BOOL r = PathCanonicalize(wc, m_FullPath);
		if ( r ) m_FullPath.Format(_T("%s"), wc);
	}

	return true;
}

void CFmParam::MyDispatchMessage(void)
{
	MSG aMsg;
	while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
	{
/*
		if( aMsg.message == WM_KEYDOWN )
		{
			if ( aMsg.wParam == VK_RETURN || aMsg.wParam == VK_ESCAPE )
			{
				m_bIsInterrupt = TRUE;
				continue;
			}
		}
*/
		::TranslateMessage( &aMsg );
		::DispatchMessage( &aMsg );
	}
}

void CFmParam::SetDirTime(CString src, CString dest)
{

	HANDLE hFile = CreateFile(src, 0, FILE_SHARE_READ,
                         0, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
	FILETIME ct, at, wt;
	
	if(hFile != INVALID_HANDLE_VALUE) {
        GetFileTime(hFile, &ct, &at, &wt);
        CloseHandle(hFile);

		HANDLE hFile = CreateFile(dest, GENERIC_WRITE, FILE_SHARE_READ,
								 0, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
		if(hFile != INVALID_HANDLE_VALUE) {

			SetFileTime(hFile, &ct, &at, &wt);
			CloseHandle(hFile);
		}
    }
}

// t@Cݔ
BOOL CFmParam::MoveToRecycler( CString name )
{
	SHFILEOPSTRUCT fileOp;
	const TCHAR *src = name;
	const TCHAR *src2 = name;
	TCHAR *dest;
	FILEOP_FLAGS flags = FOF_NOCONFIRMATION;

	fileOp.pFrom = dest = (TCHAR*)alloca(sizeof(*dest) * (_tcslen(src2) + 2));
	while((*dest++ = *src++) != _T('\0')) {}
	*dest = _T('\0');

	fileOp.hwnd = NULL;
//	fileOp.hwnd = hwnd;
	fileOp.wFunc = FO_DELETE;
	fileOp.pTo = NULL;
	fileOp.fFlags = FOF_ALLOWUNDO | flags;
	fileOp.fAnyOperationsAborted = FALSE;
	fileOp.hNameMappings = NULL;
	fileOp.lpszProgressTitle = NULL;
	
	return SHFileOperation(&fileOp);
}

// t@C̓ǂݏo
void CFmParam::ReadHistoryFile( CString fext, CComboBox *pcombo, bool next )
{
	CString path, s;

	s.Format(_T("annsFM%s"), fext);

	path = GetExePath(s);

	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;

	int max = MAX_HISTORY_NUM;

	if ( !cfile.Open( path, CFile::modeRead ) ) {
		for ( int i = 0; i < max; i++ ) {
			if ( next ) m_psHistory2[i] = _T("");
			else m_psHistory[i] = _T("");
		}
		return;
	}

	CString sbuf;

	int n;
	for ( n = 0; n < max; n++ ) {
		BOOL r = cfile.ReadString(sbuf);
		if ( r ) {
			if ( next ) m_psHistory2[n] = sbuf;
			else m_psHistory[n] = sbuf;
		} else {
			if ( next ) m_psHistory2[n] = _T("");
			else m_psHistory[n] = _T("");
		}
	}

	cfile.Close();

	if ( pcombo == NULL ) return;

	pcombo->ResetContent();

	for ( int i = 0; i < n; i++ ) {
		if ( next ) {
			if ( m_psHistory2[i] != _T("") ) pcombo->InsertString(i, m_psHistory2[i]);
		} else {
			if ( m_psHistory[i] != _T("") ) pcombo->InsertString(i, m_psHistory[i]);
		}
	}

}

// t@C̏o
// fext : oqXg[t@C̊gq
// sAdd : 擪ɒǉqXg[
//        NULL̏ꍇ͒ǉȂ
void CFmParam::WriteHistoryFile( CString fext, CString sAdd, bool next )
{
	CString path, sbuf, s;

	s.Format(_T("annsFM%s"), fext);

	path = GetExePath(s);

	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;
	if ( !cfile.Open( path, CFile::modeWrite | CFile::modeCreate ) ) {
		return;
	}

	if ( sAdd.GetLength() != 0 ) {
		if ( fext == _T(".hid") ) {
			if ( sAdd.GetAt(sAdd.GetLength() - 1) != CHAR_YEN ) sAdd += STR_YEN;
			wchar_t wc[1000];
			BOOL r = PathCanonicalize(wc, sAdd);
			if ( r ) sAdd.Format(_T("%s"), wc);
		}
		sbuf = sAdd;
		sbuf += _T("\n");
		cfile.WriteString(sbuf);
	}

	int max = MAX_HISTORY_NUM - 1;
	for ( int i = 0; i < max; i++ ) {
		if ( next ) sbuf = m_psHistory2[i];
		else sbuf = m_psHistory[i];
		if ( (sbuf.GetLength() != 0) && (sbuf != sAdd)) {
			sbuf += _T("\n");
			cfile.WriteString(sbuf);
		}
	}

	cfile.Close();

}

void  CFmParam::UnixTimeToFileTime(time_t t, LPFILETIME pft)
{
	// Note that LONGLONG is a 64-bit value
	LONGLONG ll;

	ll = Int32x32To64(t, 10000000) + 116444736000000000;
	pft->dwLowDateTime = (DWORD)ll;
	pft->dwHighDateTime = ll >> 32;
}

HRESULT CFmParam::CreateShortcut(  
        LPCWSTR pszLink,	// t@C
        LPCWSTR pszLinkFile,	// linkt@C
        LPCWSTR pszArguments,	// 	=NULL
        LPCWSTR pszDescription,	// Rg	=NULL
        LPCWSTR pszWorkingDirectory,	// =NULL
        int nSetShowCmd,	// =SW_SHOWNORMAL
        WORD wHotkey,	// =0
        LPCWSTR pszIcon,	// =NULL
        int iIcon	// =0
    )  
{
	HRESULT hRet;
	wchar_t buff[MAX_PATH];
	CString slink;

	hRet = SHGetSpecialFolderPath( NULL, buff, CSIDL_DESKTOPDIRECTORY, false );  

	slink.Format(_T("%s\\%s.lnk"), &buff[0], pszLinkFile);

	pszLinkFile = slink.GetBuffer();

	HRESULT hRes;
	IShellLink *pLink = NULL;
	wchar_t szWorkingDirectory[MAX_PATH];

	// IuWFNg쐬  
	hRes = CoCreateInstance( CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (LPVOID*) &pLink );
     
        //   
        if ( SUCCEEDED( hRes ) ) {  
      
            IPersistFile *pPF = NULL;  
      
            hRes = pLink->SetPath(pszLink);  
          
            if ( SUCCEEDED(hRes) ) {  
                // {́ASẴ\bhŌʂ`FbNׂłA  
                // Ӗǂݎ₷ׂɏȗĂ܂  
                if ( pszArguments != NULL ) {  
                    //   
                    hRes = pLink->SetArguments(pszArguments);  
                }  
                if ( pszDescription != NULL ) {  
                    // Rg  
                    hRes = pLink->SetDescription(pszDescription);  
                }  
                if ( pszIcon != NULL ) {  
                    // Rg  
                    hRes = pLink->SetIconLocation(pszIcon,iIcon);  
                }  
                if ( wHotkey != 0 ) {  
                    // Rg  
                    hRes = pLink->SetHotkey(wHotkey);  
                }  
                if ( pszWorkingDirectory != NULL ) {  
                    // ƃtH_  
                    lstrcpy( szWorkingDirectory, pszWorkingDirectory );  
                }  
                else {
					CString sWork = pszLink;
					int n = sWork.ReverseFind(_T('\\'));
					CString s = sWork.Left(n);
                    lstrcpy( szWorkingDirectory, s );  
                }  
                hRes = pLink->SetWorkingDirectory( szWorkingDirectory );  
                // s̑傫  
                hRes = pLink->SetShowCmd(nSetShowCmd);  
      
                CString path = pszLinkFile;  
      
                hRes = pLink->QueryInterface( IID_IPersistFile, (void **)&pPF );  
                if ( SUCCEEDED(hRes) ) {  
                    hRes = pPF->Save(path, TRUE);  
                    pPF->Release();  
                }  
            }  
      
            pLink->Release();  
        }  
      
        return hRes;  
}  



void  CFmParam::ReadKeyMap(void)
{
	CString path, s;

	s = _T("annsFM.key");

	path = GetExePath(s);

//	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;

	int max = 768;	// = 256x3

	UINT *pKeyMap;
	pKeyMap = new UINT[max];

	if ( cfile.Open( path, CFile::modeRead ) ) {
		for ( int i = 0; i < max; i++ ) {
			CString sbuf;
			BOOL r = cfile.ReadString(sbuf);
			pKeyMap[i] = i;
			if ( r ) {
				int kn = _wtoi(sbuf.Left(3));
				if ( kn >= 0 && kn < 768 ) pKeyMap[i] = kn;
			}
		}
		cfile.Close();
		for ( int i = 0; i < 256; i++ ) {
			m_pKeyMap[i] = pKeyMap[i];
			m_pShiftKeyMap[i] = pKeyMap[i + 256];
			m_pCtrlKeyMap[i] = pKeyMap[i + 512];
		}
	}

	delete []pKeyMap;
}


// gq̑Ήt@C̓ǂݏo
// ߂l error
// 1:"/"̈ʒuُ
// 2:t@CpXʒuُ(gq2񗈂)
// 3:ŏ"." "/"ȊÔ̂
int CFmParam::ReadExtentionMapFile( void )
{
	CString path, s;

	s = _T("annsFM.ext");

	path = GetExePath(s);

	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;

	int max = MAX_EXTENTION_NUM;
	int err = 0;
	int mnum = 0;
	m_nExtMapErrLineNo = 0;

	if ( cfile.Open( path, CFile::modeRead ) ) {

		CString sbuf, fname, ename;

		int n;
		int fase = 0;

		fname = _T("");
		ename = _T("");

		for ( n = 0; n < max; n++ ) {
			BOOL r = cfile.ReadString(sbuf);
			if ( r ) {
				if ( sbuf[0] == '/' ) {
					if ( fase == 0 ) {	// "/"2񗈂 I
						break;
					}

					if ( fase == 1 ) {
						err = 1;
						m_nExtMapErrLineNo =n;
						break;
					}

					if ( fase == 2) {	// 1ZbgI
						fase = 0;
						continue;
					}
				}

				if ( sbuf[0] == '.' ) {
					if ( fase == 0 ) {
						sbuf.MakeUpper();
						m_pExtMap[mnum].ext = sbuf;
						ename = sbuf;
						fase = 1;
						continue;
					}

					if ( fase == 1 ) {
						err = 2;
						m_nExtMapErrLineNo =n;
						break;
					}

					if ( fase == 2 ) {
						sbuf.MakeUpper();
						m_pExtMap[mnum].ext = sbuf;
						m_pExtMap[mnum].exeFile = fname;
						mnum++;
					}


				} else {
					if ( fase == 0 ) {
						err = 3;
						m_nExtMapErrLineNo =n;
						break;
					}

					if ( fase == 1 ) {
						m_pExtMap[mnum].exeFile = sbuf;
						fname = sbuf;
						fase = 2;
						mnum++;
						continue;
					}

					if ( fase == 2) {
						m_pExtMap[mnum].ext = ename;
						m_pExtMap[mnum].exeFile = sbuf;
						mnum++;
					}

				}

			} else break;
		}

		cfile.Close();
	}

	m_nMaxExtMapNum = mnum;
	return err;
}

// gq̑Ήt@C̏o
void CFmParam::WriteExtentionMapFile( void )
{
/*
	CString path, sbuf, s;

	s.Format(_T("annsFM%s"), fext);

	path = GetExePath(s);

	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;
	if ( !cfile.Open( path, CFile::modeWrite | CFile::modeCreate ) ) {
		return;
	}

	if ( sAdd.GetLength() != 0 ) {
		if ( fext == _T(".hid") ) {
			if ( sAdd.GetAt(sAdd.GetLength() - 1) != CHAR_YEN ) sAdd += STR_YEN;
			wchar_t wc[1000];
			BOOL r = PathCanonicalize(wc, sAdd);
			if ( r ) sAdd.Format(_T("%s"), wc);
		}
		sbuf = sAdd;
		sbuf += _T("\n");
		cfile.WriteString(sbuf);
	}

	int max = MAX_HISTORY_NUM - 1;
	for ( int i = 0; i < max; i++ ) {
		if ( next ) sbuf = m_psHistory2[i];
		else sbuf = m_psHistory[i];
		if ( (sbuf.GetLength() != 0) && (sbuf != sAdd)) {
			sbuf += _T("\n");
			cfile.WriteString(sbuf);
		}
	}

	cfile.Close();
*/
}

// tH_f[^̏
void CFmParam::SetHistFolderData( CString scFile )
{
	if (m_bNotSetHistory) return;

	int dn = m_CurrentDriveNo;
	CString cpath = m_pDriveParam->m_pCurrentPath[dn];

	if (m_nHistMaxFolderData != -1) {
		CString fdPath = m_pHistFolderData[m_nHistMaxFolderData].sDirName;

		if (cpath == fdPath) return;

	}
	
	m_nHistMaxFolderData++;
	if (m_nHistMaxFolderData == MAX_FOLDER_DATA) {
		m_bFdFull = true;
		m_nHistMaxFolderData = 0;
	}
	m_nHistCurrentFolderNo = m_nHistMaxFolderData;

	m_pHistFolderData[m_nHistCurrentFolderNo].sDirName = cpath;
	m_pHistFolderData[m_nHistCurrentFolderNo].sFileName = scFile;
	m_bEnableMoveHistoryFile = true;


}

// tH_f[^̌
// scDirāAv΂̃tH_̊Yt@CԂ
CString CFmParam::GetHistFolderData( CString scDir )
{
	CString sfile;
	sfile = _T("");

	int max = MAX_FOLDER_DATA;
	if ( !m_bFdFull ) max = m_nHistMaxFolderData;

	int n = m_nHistMaxFolderData;
	while( max != 0 ) {
		CString cpath;
		cpath = m_pHistFolderData[n].sDirName;
		if ( scDir == cpath ) {
			sfile = m_pHistFolderData[n].sFileName;
			break;
		}
		n--;
		max--;
	}

	return sfile;
}


// JgtH_Ԃ
CString CFmParam::GetHistCurrentFolder( void )
{
	CString path;

	path = m_pHistFolderData[m_nHistCurrentFolderNo].sDirName;

	return path;

}

// JgtH_ЂƂO
void CFmParam::HistPrevFolder(void)
{
	m_nHistCurrentFolderNo--;

	if ( m_nHistCurrentFolderNo < 0 ) {
		if ( m_bFdFull ) m_nHistCurrentFolderNo = MAX_FOLDER_DATA - 1;
		else m_nHistCurrentFolderNo = 0;
	}


}

// JgtH_ЂƂ
void CFmParam::HistNextFolder(void)
{
	m_nHistCurrentFolderNo++;

	if (m_nHistCurrentFolderNo > m_nHistMaxFolderData) {
		m_nHistCurrentFolderNo = m_nHistMaxFolderData;
	}


}

BOOL CFmParam::EjectMedia(TCHAR cDriveLetter)
{
	TCHAR tszDrive[24];
	_stprintf_s( tszDrive, _T("\\\\.\\%c:"), cDriveLetter );

	HANDLE hFile = CreateFile( tszDrive, GENERIC_READ,
			FILE_SHARE_READ | FILE_SHARE_WRITE, 0,
			OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0 );

	BOOL bResult = FALSE;
	if ( hFile != INVALID_HANDLE_VALUE )
	{
		DWORD cb;
		bResult = DeviceIoControl( hFile,
				IOCTL_STORAGE_EJECT_MEDIA, NULL, 0, NULL, 0, &cb, 0 );
		CloseHandle( hFile );
	}

	if (bResult) {
		m_sDeviceError.Format(_T("hCu %c: ̃fBA͈SɎO܂"), cDriveLetter);
	} else {
		m_sDeviceError.Format(_T("hCu %c ̃fBA̎OɎs܂"), cDriveLetter);
		return FALSE;
	}

	return TRUE;
	
}

HANDLE CFmParam::OpenVolume(TCHAR cDriveLetter)
{
	HANDLE hVolume;
	UINT uDriveType;
	DWORD dwAccessFlags;

	CString szVolumeName;
	CString szRootName;
	CString szRootFormat = _T("%c:\\");

	   
	szRootName.Format(szRootFormat, cDriveLetter);

	uDriveType = GetDriveType(szRootName);

	switch(uDriveType) {
		case DRIVE_REMOVABLE:
			dwAccessFlags = GENERIC_READ | GENERIC_WRITE;
			break;

		case DRIVE_CDROM:
			dwAccessFlags = GENERIC_READ;
			break;

		default:
			m_sDeviceError = _T("hCu^Cvł");
			return INVALID_HANDLE_VALUE;
	}

	CString szVolumeFormat = _T("\\\\.\\%c:");
	szVolumeName.Format(szVolumeFormat, cDriveLetter);

	hVolume = CreateFile(szVolumeName, dwAccessFlags, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
                               OPEN_EXISTING, 0, NULL );

	if (hVolume == INVALID_HANDLE_VALUE)
	{
		m_sDeviceError = _T("I[vG[");
	}

	return hVolume;

}

BOOL CFmParam::CloseVolume(HANDLE hVolume)
{
	return CloseHandle(hVolume);
}

// #include <windows.h>
// #include <stdio.h>

#define LOCK_TIMEOUT        10000       // 10 Seconds
#define LOCK_RETRIES        20

BOOL CFmParam::LockVolume(HANDLE hVolume)
{
	DWORD dwBytesReturned;
	DWORD dwSleepAmount;
	int nTryCount;


	dwSleepAmount = LOCK_TIMEOUT / LOCK_RETRIES;

       // Do this in a loop until a timeout period has expired

	for (nTryCount = 0; nTryCount < LOCK_RETRIES; nTryCount++) {

		if (DeviceIoControl(hVolume, FSCTL_LOCK_VOLUME, NULL, 0, NULL, 0, &dwBytesReturned, NULL)) {
			return TRUE;
		}

		Sleep(dwSleepAmount);
	}

	return FALSE;
}


BOOL CFmParam::DismountVolume(HANDLE hVolume)
{
	DWORD dwBytesReturned;

	return DeviceIoControl( hVolume, FSCTL_DISMOUNT_VOLUME, NULL, 0, NULL, 0, &dwBytesReturned, NULL);
}


BOOL CFmParam::PreventRemovalOfVolume(HANDLE hVolume, BOOL fPreventRemoval)
{
	DWORD dwBytesReturned;

	PREVENT_MEDIA_REMOVAL PMRBuffer;
	PMRBuffer.PreventMediaRemoval = fPreventRemoval;

	return DeviceIoControl( hVolume, IOCTL_STORAGE_MEDIA_REMOVAL, &PMRBuffer, sizeof(PREVENT_MEDIA_REMOVAL),
                               NULL, 0, &dwBytesReturned, NULL);
}


BOOL CFmParam::AutoEjectVolume(HANDLE hVolume)
{
	DWORD dwBytesReturned;

	return DeviceIoControl( hVolume, IOCTL_STORAGE_EJECT_MEDIA, NULL, 0, NULL, 0, &dwBytesReturned, NULL);
}

BOOL CFmParam::EjectVolume(TCHAR cDriveLetter)
{
	HANDLE hVolume;

	BOOL fRemoveSafely = FALSE;
	BOOL fAutoEject = FALSE;

	m_sDeviceError = _T("");

       // Open the volume.
	hVolume = OpenVolume(cDriveLetter);
	if (hVolume == INVALID_HANDLE_VALUE) {
		m_sDeviceError = _T("{[̃I[vɎs܂");
		return FALSE;
	}

       // Lock and dismount the volume.
	if (LockVolume(hVolume) && DismountVolume(hVolume)) {
		fRemoveSafely = TRUE;

           // Set prevent removal to false and eject the volume.
		if (PreventRemovalOfVolume(hVolume, FALSE) && AutoEjectVolume(hVolume)) 
               fAutoEject = TRUE;
	}

       // Close the volume so other processes can use the drive.
	if (!CloseVolume(hVolume)) {
		m_sDeviceError.Format( _T("hCu %c: ̃fBA͎gpł"), cDriveLetter);
		return FALSE;
	}

	if (fAutoEject) {
		m_sDeviceError.Format(_T("hCu %c: ̃fBA͈SɎO܂"), cDriveLetter);
	} else {
		if (fRemoveSafely) m_sDeviceError.Format(_T("hCu %c: ̃fBA͈SɎO܂"), cDriveLetter);
		else {
			m_sDeviceError.Format(_T("hCu %c ̃fBA̎OɎs܂"), cDriveLetter);
			return FALSE;
		}
	}

       return TRUE;
}


bool CFmParam::RemoveUSB(TCHAR sDriveName)
{
// "X:\"    -> for GetDriveType
	CString szRootPath = _T("X:\\");
	szRootPath.SetAt(0, sDriveName);

// "X:"     -> for QueryDosDevice
	CString szDevicePath = _T("X:");
	szDevicePath.SetAt(0, sDriveName);

// "\\.\X:" -> to open the volume
	CString szVolumeAccessPath = _T("\\\\.\\X:");
	szVolumeAccessPath.SetAt(4, sDriveName);

	long DeviceNumber = -1;

	HANDLE hVolume = CreateFile(szVolumeAccessPath, 0, FILE_SHARE_READ | FILE_SHARE_WRITE,
                    NULL, OPEN_EXISTING, 0, NULL);
	if (hVolume == INVALID_HANDLE_VALUE) {
	  return false;
	}

	STORAGE_DEVICE_NUMBER sdn;
	DWORD dwBytesReturned = 0;
	long res = DeviceIoControl(hVolume, IOCTL_STORAGE_GET_DEVICE_NUMBER,
                    NULL, 0, &sdn, sizeof(sdn), &dwBytesReturned, NULL);
	if ( res ) {
	  DeviceNumber = sdn.DeviceNumber;
	}

	CloseHandle(hVolume);

	if ( DeviceNumber == -1 ) {
	  return false;
	}

	UINT DriveType = GetDriveType(szRootPath);

// get the dos device name (like \device\floppy0)
// to decide if it's a floppy or not
	TCHAR dName[4096];
	res = QueryDosDevice(szDevicePath, dName, 4096);
	if ( !res ) {
	  return false;
	}
	CString szDosDeviceName;
	szDosDeviceName.Format(_T("%s"), dName);

	DEVINST DevInst = GetDrivesDevInstByDeviceNumber(DeviceNumber, DriveType, szDosDeviceName);
	if ( ! DevInst ) {
	  return false;
	}

	ULONG Status = 0;
	ULONG ProblemNumber = 0;
	PNP_VETO_TYPE VetoType = PNP_VetoTypeUnknown;
	WCHAR VetoNameW[MAX_PATH];
	bool bSuccess = false;

// get drives's parent, e.g. the USB bridge,
// the SATA port, an IDE channel with two drives!
	DEVINST DevInstParent = 0;
	res = CM_Get_Parent(&DevInstParent, DevInst, 0);

	for ( int i = 0; i < 5; i++ ) {
// sometimes we need some tries...

		VetoNameW[0] = 0;
		res = CM_Request_Device_EjectW(DevInstParent, &VetoType, VetoNameW, MAX_PATH, 0);

		bSuccess = ( res==CR_SUCCESS && VetoType==PNP_VetoTypeUnknown );
		if ( bSuccess )  {
			break;
		}

		Sleep(500); // required to give the next tries a chance!
	}

	return bSuccess;

}


DEVINST CFmParam::GetDrivesDevInstByDeviceNumber(long DeviceNumber,
          UINT DriveType, CString szDosDeviceName)
{
//  bool IsFloppy = (strstr(szDosDeviceName,
//       "\\Floppy") != NULL); // is there a better way?
	int nn = szDosDeviceName.Find(_T("\\Floppy"));
	bool IsFloppy = false;
	if ( nn >= 0 ) IsFloppy = true;

  GUID* guid;

  switch (DriveType) {
  case DRIVE_REMOVABLE:
    if ( IsFloppy ) {
      guid = (GUID*)&GUID_DEVINTERFACE_FLOPPY;
    } else {
      guid = (GUID*)&GUID_DEVINTERFACE_DISK;
    }
    break;
  case DRIVE_FIXED:
    guid = (GUID*)&GUID_DEVINTERFACE_DISK;
    break;
  case DRIVE_CDROM:
    guid = (GUID*)&GUID_DEVINTERFACE_CDROM;
    break;
  default:
    return 0;
  }

  // Get device interface info set handle
  // for all devices attached to system
  HDEVINFO hDevInfo = SetupDiGetClassDevs(guid, NULL, NULL,
                    DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);

  if ( hDevInfo == INVALID_HANDLE_VALUE )  {
    return 0;
  }

  // Retrieve a context structure for a device interface
  // of a device information set.
  DWORD dwIndex = 0;
  BOOL bRet = FALSE;

  BYTE Buf[1024];
  PSP_DEVICE_INTERFACE_DETAIL_DATA pspdidd =
     (PSP_DEVICE_INTERFACE_DETAIL_DATA)Buf;
  SP_DEVICE_INTERFACE_DATA         spdid;
  SP_DEVINFO_DATA                  spdd;
  DWORD                            dwSize;

  spdid.cbSize = sizeof(spdid);

  while ( true )  {
    bRet = SetupDiEnumDeviceInterfaces(hDevInfo, NULL,
           guid, dwIndex, &spdid);
    if ( !bRet ) {
      break;
    }

    dwSize = 0;
    SetupDiGetDeviceInterfaceDetail(hDevInfo,
      &spdid, NULL, 0, &dwSize, NULL);

    if ( dwSize!=0 && dwSize<=sizeof(Buf) ) {
      pspdidd->cbSize = sizeof(*pspdidd); // 5 Bytes!

      ZeroMemory((PVOID)&spdd, sizeof(spdd));
      spdd.cbSize = sizeof(spdd);

      long res =
        SetupDiGetDeviceInterfaceDetail(hDevInfo, &
                                        spdid, pspdidd,
                                        dwSize, &dwSize,
                                        &spdd);
      if ( res ) {
        HANDLE hDrive = CreateFile(pspdidd->DevicePath,0,
                      FILE_SHARE_READ | FILE_SHARE_WRITE,
                      NULL, OPEN_EXISTING, 0, NULL);
        if ( hDrive != INVALID_HANDLE_VALUE ) {
          STORAGE_DEVICE_NUMBER sdn;
          DWORD dwBytesReturned = 0;
          res = DeviceIoControl(hDrive,
                        IOCTL_STORAGE_GET_DEVICE_NUMBER,
                        NULL, 0, &sdn, sizeof(sdn),
                        &dwBytesReturned, NULL);
          if ( res ) {
            if ( DeviceNumber == (long)sdn.DeviceNumber ) {
              CloseHandle(hDrive);
              SetupDiDestroyDeviceInfoList(hDevInfo);
              return spdd.DevInst;
            }
          }
          CloseHandle(hDrive);
        }
      }
    }
    dwIndex++;
  }

  SetupDiDestroyDeviceInfoList(hDevInfo);

  return 0;
}

// BonsFMSPIݒt@CYSPI

// ߂l : ݒt@CȂꍇfalseAꍇtrue
// ꍇ́Am_sFindFileSPI ɊYSPIt@C
// YSPIt@CA\t@C̊gqT|[gĂꍇAm_bFindSPI = true;

bool CFmParam::SearchSPISettingFile(CString sFileName, CString sExt)
{
//	bool br = false;

	CString sFile;
	sFile = _T("");
	CString sSettingFile;

	if (m_sToolSPISettingFile == _T("")) {
		return false;
	}

	sSettingFile = GetEnvStr(m_sToolSPISettingFile);

	bool bHit = false;

	CFileStatus rStatus;
	if (CFile::GetStatus(sSettingFile, rStatus)) {	// t@C݂

//		br = true;

		CStdioFile cfile;
		cfile.Open(sSettingFile, CFile::modeRead);

		CString sbuf, sbuf2;

//		BOOL r = TRUE;


		while(cfile.ReadString(sbuf)) {

			int n = sbuf.Find(_T("	"));

			if (n >= 0) {
				CString ss = sbuf.Left(n);

				if (ss == _T("L")) {
					n++;
					sbuf2 = sbuf.Mid(n);
					sbuf = sbuf2;	// gqȍ~

					n = sbuf.Find(_T("	"));

					if (n >= 0) {
						ss = sbuf.Left(n);	// gq
						ss.MakeUpper();
						if (ss == sExt) {
							n++;
							sbuf2 = sbuf.Mid(n);
							sbuf = sbuf2;	// Oȍ~

							n = sbuf.Find(_T("	"));
							n++;
							sbuf2 = sbuf.Mid(n);
							sbuf = sbuf2;	// SPIt@Cȍ~

							n = sbuf.Find(_T("	"));
							if (n >= 0) {
								sFile = sbuf.Left(n);
								bHit = true;
								break;
							}

						}

					}

				}
			}

		}

	}
	else {
		return false;
	}


	if (bHit) {

//		br = false;
		CString sFindName;
		sFindName = GetEnvStr(sFile);

		m_bAtypeSPI = false;

		HANDLE hFile = CreateFile(sFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		BOOL rb = true;
		char *cpbuf = NULL;
		if (hFile) {
			cpbuf = new char[4000];
			DWORD rbyte;
			memset(cpbuf, 0, 4000);
			rb = ReadFile(hFile, cpbuf, 3000, &rbyte, NULL);
		}
		else rb = false;

		if (!sFindName.IsEmpty()) {

			DWORD flag = 0xa00;
			SetDllDirectory(_T(""));
			HINSTANCE hInstance = LoadLibraryEx(sFindName, 0, flag);

			if (hInstance)
			{
				SpiFuncGetPluginInfo pGetPluginInfo;
				pGetPluginInfo = (SpiFuncGetPluginInfo)GetProcAddress(hInstance, "GetPluginInfo");

				if (pGetPluginInfo) {
					char buf[10], ebuf[1000];
					int ir = pGetPluginInfo(0, buf, 9);
					buf[9] = 0;
					if (ir > 3) {


						if (!m_bFindSPI) {
							ir = pGetPluginInfo(2, ebuf, 999);
							if (ir != 0) {
								ebuf[999] = 0;
								CString sFind;
								CString sw = CA2W(ebuf);
								sFind.Format(_T("%s"), sw);
								sFind.MakeUpper();
								int nf = sFind.Find(sExt);
								if (nf >= 0) {
									m_bFindSPI = true;
//									br = true;
								}
							}
						}


						if (!m_bFindSPI) {
							SpiFuncIsSupported pIsSupported;
							pIsSupported = (SpiFuncIsSupported)GetProcAddress(hInstance, "IsSupported");

							DWORD	dw = (DWORD)cpbuf;
							int ret = pIsSupported((LPSTR)CW2A(sFileName.GetBuffer()), dw);
							if (ret != 0) {
								m_bFindSPI = true;
//								br = true;
							}
						}

						if (m_bFindSPI) {
							if (buf[2] == 'A') {
								m_bAtypeSPI = true;
								if ((sExt.Find(_T("PDF")) < 0) && (sExt.Find(_T("XPS")) < 0)) {
									m_bAtypeSPI = false;
									m_bFindSPI = false;
								}
//								br = true;
							}
						}
					}
				}

				FreeLibrary(hInstance);
			}
		}

		m_sFindFileSPI = sFindName;

		if (hFile) CloseHandle(hFile);
		if (cpbuf) delete[]cpbuf;

	}

	return true;
}


// wt@C̊gqɑΉsusievOČ

// ߂l ΉvOCꍇ́ÃtpXtt@C
// Ȃꍇ_T("")߂

//  Y摜t@C̃tpXtt@C

bool CFmParam::SearchSPI(CString sFileName)
{
	m_bFindSPI = false;

	DivideFileName(sFileName);
	if ( m_sExt == _T("") ) {
		m_bFindSPI = false;
		return false;
	}

	CString sExt = m_sExt;
	sExt.MakeUpper();


	bool br = SearchSPISettingFile(sFileName, sExt);

	if (br) {

		return m_bFindSPI;

	}

	CString sRet = _T("");
	CString sPathSPI = _T("");
	sPathSPI = GetEnvStr(m_sToolPathSPI);
	if ( sPathSPI == _T("") ) {
		sPathSPI = GetExePath(_T("SPI\\"));
	} else {
		int n = sPathSPI.GetLength() - 1;
		if ( sPathSPI.GetAt(n) != _T('\\') ) sPathSPI += _T("\\");
	}

	sPathSPI += _T("*.spi");

	CFileFind ff;
	BOOL bRet = ff.FindFile(sPathSPI, 0);

	m_bAtypeSPI = false;

	HANDLE hFile = CreateFile(sFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	BOOL rb = true;
	char *cpbuf = NULL;
	if(hFile) {
		cpbuf = new char [4000];
		DWORD rbyte;
		memset(cpbuf, 0, 4000);
		rb = ReadFile( hFile, cpbuf, 3000, &rbyte, NULL);
	} else rb = false;

	while ( rb && bRet ) {
		bRet = ff.FindNextFile();
		CString sFindName;
		CStringA saFindName;
		saFindName = ff.GetFilePath();
		CString ss = CA2W(saFindName);
		sFindName.Format(_T("%s"), ss);

		if(!sFindName.IsEmpty()){
//			HINSTANCE hInstance = LoadLibrary( sFindName );

			DWORD flag = 0xa00;
			SetDllDirectory(_T(""));
			HINSTANCE hInstance = LoadLibraryEx(sFindName, 0, flag);

			if ( hInstance )
			{
				SpiFuncGetPluginInfo pGetPluginInfo;
				pGetPluginInfo = (SpiFuncGetPluginInfo)GetProcAddress(hInstance, "GetPluginInfo");

				if ( pGetPluginInfo ) {
					char buf[10], ebuf[1000];
					int ir = pGetPluginInfo(0, buf, 9);
					buf[9] = 0;
					if ( ir > 3 ) {


						if ( !m_bFindSPI ) {
							ir = pGetPluginInfo(2, ebuf, 999);
							if ( ir != 0 ) {
								ebuf[999] = 0;
								CString sFind;
								CString ss = CA2W(ebuf);
								sFind.Format(_T("%s"), ss);
								sFind.MakeUpper();
								int nf = sFind.Find(sExt);
								if ( nf >= 0 ) {
									m_bFindSPI = true;
								}
							}
						}


						if ( !m_bFindSPI ) {
							SpiFuncIsSupported pIsSupported;
							pIsSupported = (SpiFuncIsSupported)GetProcAddress(hInstance, "IsSupported");
/*
							HANDLE hFile = CreateFile(sFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
							if(hFile) {
								char cbuf2[4000];
								DWORD rbyte;
								memset(cbuf2, 0, 4000);
								BOOL rb = ReadFile( hFile, cbuf2, 3000, &rbyte, NULL);
								if ( rb != 0 ) {
*/
									DWORD	dw = (DWORD)cpbuf;
									int ret = pIsSupported((LPSTR)CW2A(sFileName.GetBuffer()), dw);
									if ( ret != 0 ) {
										m_bFindSPI = true;
									}
//								}
//								CloseHandle(hFile);

//							}
						}

/*
						if ( !m_bFindSPI ) {
							SpiFuncIsSupported pIsSupported;
							pIsSupported = (SpiFuncIsSupported)GetProcAddress(hInstance, "IsSupported");
							HANDLE hFile = CreateFile(sFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
							if(hFile) {
								DWORD	dw = (DWORD)hFile;
								int ret = pIsSupported((LPSTR)CW2A(sFileName.GetBuffer()), dw);
								CloseHandle(hFile);
								if ( ret != 0 ) {
									m_bFindSPI = true;
								}

							}
						}
*/
						if ( m_bFindSPI ) {
							sRet = ff.GetFilePath();
							if ( buf[2] == 'A' ) {
								m_bAtypeSPI = true;
								if ( (sExt.Find(_T("PDF")) < 0) && (sExt.Find(_T("XPS")) < 0) ) {
									m_bAtypeSPI = false;
									m_bFindSPI = false;
								}
							}
						}
						if ( m_bFindSPI ) {
							break;
						}
					}
				}

				FreeLibrary( hInstance );
			}
		}
	}
	if ( hFile ) CloseHandle(hFile);
	if ( cpbuf ) delete []cpbuf;

	m_sFindFileSPI = sRet;
	return m_bFindSPI;
}

/*
int	CSPICore::IsSupported(LPCTSTR filename)
{
	if(!filename || !m_pIsSupported)
		return 0	;
	HANDLE hFile = CreateFile(filename, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(!hFile)
		return 0;
	DWORD	dw = (DWORD)hFile;
	int nRet = m_pIsSupported((LPSTR)filename, dw);
	CloseHandle(hFile);
	return nRet;
}
*/

#define TTSPRIORITY_HIGH 4

void CFmParam::VoiceGuideOut(CString sMessage)
{
	if ( m_nVoiceGuide == 0 ) return;

	if ( m_nVoiceGuide == 1 ) {	// NVDA
		if ( !m_bEnableNVDA ) return;
		m_pnvdaController_speakText(sMessage);
	}

	if ( m_nVoiceGuide == 2 ) {	// PC-Talker
		if ( !m_bEnablePCTalker ) return;
		CStringA sA;
		sA = CW2A(sMessage);
		m_pPCTKPRead( sA, TTSPRIORITY_HIGH, TRUE );
	}

}


void CFmParam::ClearDirSize(void)
{
	for (int i = 0; i < MAXFILE; i++) {
		m_pDirSize[i].Enable = false;
		m_pDirSize[i].Size = 0;
	}
}

// f~^ŋ؂ꂽeLXg𕪉ĔzɊi[ixAᑬŁj
// pArray : ̔zi]񐔂炵|C^ԂĂ͌ςƎgȂȂj
// strString : Ώە
// cTarget : f~^
int CFmParam::TokenSearch(CStringArray *pArray, CString strString, TCHAR cTarget, BOOL bTrim)
{
	int nMax = strString.GetLength();
	if (nMax == 0)
		return 0;
	wchar_t *szToken = new wchar_t[nMax + 1];

	int nCounter = 0;
	for (int i = 0; i < nMax; i++)
	{
		if (strString[i] == '\0')//I[
			break;
		if (strString[i] == cTarget)//o
		{
			if (bTrim)
			{
				CString strTrimText = szToken;
				strTrimText.Trim();
				pArray->Add(strTrimText);
			}
			else
				pArray->Add(szToken);
			nCounter = 0;
			szToken[nCounter] = 0;
		}
		else
		{
			szToken[nCounter] = strString[i];
			szToken[nCounter + 1] = 0;
			nCounter++;
		}
	}
	if (bTrim)
	{
		CString strTrimText = szToken;
		strTrimText.Trim();
		pArray->Add(strTrimText);
	}
	else
		pArray->Add(szToken);
	delete[]szToken;

	return (int)pArray->GetSize();
}

// ChJ[hp^[}b`iwsj
// lpszString : 
// lpszSpec : ChJ[h܂ޕ 
BOOL CFmParam::_MatchSpec(LPCWSTR lpszString, LPCWSTR lpszSpec)
{
	//ǂNGɂȂ܂ōċAŃ`FbN
	switch (*lpszSpec)
	{
	case '\0'://I[Ȃ̂ŐōċA𔲂
		return (*lpszString == '\0');
	case '*'://̌₪vAI[łȂr̎v
		return _MatchSpec(lpszString, lpszSpec + 1) || ((*lpszString != '\0') && _MatchSpec(lpszString + 1, lpszSpec));
	case '?'://I[łȂꂼ̎v
		return (*lpszString != '\0') && _MatchSpec(lpszString + 1, lpszSpec + 1);
	default:
		return (*lpszString == *lpszSpec) && _MatchSpec(lpszString + 1, lpszSpec + 1);
	}
}

//Zp[^t̃ChJ[h̃p^[}b`APathMatchSpec()̒up
//Windows8PathMatchSpecR(Ƃ}b`Ȃ)Ԃ̂ŎbIɍ쐬
BOOL CFmParam::PathMatchSpecX(LPCWSTR szCheckString, LPCWSTR szWildcard)
{
	//SŔ
	CString strWildCard = szWildcard;
	strWildCard.MakeLower();
	CString strCheckString = szCheckString;
	strCheckString.MakeLower();

	CStringArray arr;
	int nCount = TokenSearch(&arr, strWildCard, ';');//ChJ[hw蕶;ŕ
	for (int i = 0; i < nCount; i++)
	{
		if (_MatchSpec(strCheckString, arr.GetAt(i)))
			return TRUE;
	}
	return FALSE;
}



/*

2000 : 5.0
XP : 5.1
Vista : 6.0
7 : 6.1
8 : 6.2
8.1 : 6.3

Value
Meaning
VER_EQUAL
1
The current value must be equal to the specified value.
VER_GREATER
2
The current value must be greater than the specified value.
VER_GREATER_EQUAL
3
The current value must be greater than or equal to the specified value.
VER_LESS
4
The current value must be less than the specified value.
VER_LESS_EQUAL
5
The current value must be less than or equal to the specified value.


ł́A܂ VerifyVersionInfo() g߂̏łB
OSVERSIONINFOEX?OSver;
ULONGLONG?condition? = 0;
OSver.dwOSVersionInfoSize? = sizeof(OSVERSIONINFOEX);
OSver.dwMajorVersion? = 6;
OSver.dwMinorVersion? = 2;
VER_SET_CONDITION(condition, VER_MAJORVERSION, VER_GREATER_EQUAL);
VER_SET_CONDITION(condition, VER_MINORVERSION, VER_GREATER_EQUAL);
OSVERSIONINFOEX ɐݒ肵Ă̂́A̍\̂̃TCYƁAWindows̃o[W
łB ̃o[WƁA̎gĂOS̃o[Wr킯łBTCY
KKvłB  dwMajorVersion 6A dwMinorVersion 2nĂ
ŁAWindows8.0\Ă܂B Major6̂܂܂ŁAMinor1ɂWindows7A3
Windows8.1\܂B
VER_SET_CONDITION() Ƃ̂́A̒lǂ̂悤ɔr̂AƂ̂
condition ɐݒ肵Ă܂B  OSVERSIONINFOEX ɂ͂̃o܂BOS
o[WȊOɂAServicePack̃o[WƂAȂ񂩐FXłBŁA
 VER_MAJORVERSION  VER_MINORVERSION r܂Br̎d
 VER_GREATER_EQUAL Av͔rZq <= Ŕr킯łB
܂AW[o[WA}Ci[o[W̔r <= Ŕr悤ɐݒ肵
B}Ci[o[W == ŔrAƂRɐݒł킯łB
āAł VerifyVersionInfo() ۂɎgĂ݂ƂȂ܂B
if (VerifyVersionInfo(&OSver, VER_MAJORVERSION | VER_MINORVERSION, condit
ion))
{
//?Windows8.0ȏ̎̏
}
else
{
//?ȊȌ
}
ŁAƉr̂pCvZqŐݒ肵܂B 𐳂ݒ肵Ȃ
ƁApӂ condition ̐ݒ肪ʂɂȂ܂B  OSVer  condition 
ݒ肾ƁA̎gĂOSWindows8.0ȏȂ trueAȊOȂfalseԂ
B
*/


// utf-16̒w̔pZoCgȉ̕ɃJbgB
// ̒w̔pZoCg菬ꍇ͂̂܂܁B

// sWstr : 
// nALen : Jbg锼pZoCg
// bAddContStr : JbgꍇAwoCg̍Ō̕"~"ɂB
// bAddSpace : 񂪎w萔菬ꍇƁAw萔蔼pZꍇAŌɃXy[X

CString CFmParam::GetFixedLengthWstr(CString sWstr, int nALen, bool bAddContStr, bool bAddSpace)
{
	WCHAR *wcp, wc;
	int nmax = nALen - 1;
	int napos = 0;	// pZoCgJE^
	CString rStr;	// Jbgďoオ
	int len = sWstr.GetLength();
	int olen = len;
	int nalen = 0;	// Jbgďoオ̔pZoCg

	rStr = _T("");

	wcp = sWstr.GetBuffer();


	while (len > 0) {
		wc = *wcp;

		nalen = napos;
		if ((unsigned __int16)wc > 0x7f) {
			if (((unsigned __int16)wc != 0x2013) 
				&& ((unsigned __int16)wc < 0xff60)
				&& ((unsigned __int16)wc != 0x2661)
				&& ((unsigned __int16)wc != 0x2665)
				) {
				napos++;
			}
		}

		napos++;

		if (napos > nmax) {	// woCgzI(ۂ͔p1܂2Ȃ)
			break;
		}

		rStr += wc;

		len--;
		wcp++;
	}

	if (len == 1) {	// ̍̕Ō̕
		if (napos <= nALen) {
			rStr += wc;
		}
		else {
			if (bAddContStr) {
				rStr += _T("~");
			}
			else {
				rStr += _T(" ");
			}

		}

	}
	else {
		int nof = nmax - nalen;	// oオ񂪎w萔艽oCgȂ

		if (olen != 0) {
			if (bAddContStr && len > 1) {
				rStr += _T("~");
			}
			else {
				if (len == 0) {
					if ((unsigned __int16)wc > 0x7f) {
						if (((unsigned __int16)wc != 0x2013)
							&& ((unsigned __int16)wc < 0xff60)
							&& ((unsigned __int16)wc != 0x2661)
							&& ((unsigned __int16)wc != 0x2665)
							) {
							nof--;
						}
					}

				}
			}

		} else {
			nof = nALen;

		}




		if (bAddSpace) {
			// ȂoCgAɃXy[Xǉ
			while (nof > 0) {
				rStr += _T(" ");
				nof--;
			}
		}

	}




	return rStr;

}


CString CFmParam::GetEnvStr(CString str)
{

	CString sRet = _T("");
	DWORD d = ExpandEnvironmentStrings(str, NULL, 0);

	WCHAR *sw;
	sw = new WCHAR[MAX_PATH];

	d = ExpandEnvironmentStrings(str, sw, d);

	sRet = sw;
	
	delete []sw;

	CString s, s2, sExePath;
//	s = sRet.Left(2);
	s = _T("%d");
	s2 = _T("%p");

	sExePath = GetExePath(_T(""));
	int n = sExePath.GetLength() - 1;
	if (n > 1) {
		sExePath = sExePath.Left(n);
	}

	CString sDrive;
	sDrive = sExePath.Left(2);

	sRet.Replace(s, sDrive);
	sRet.Replace(s2, sExePath);



	return sRet;


}


