
// FindFileDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "FindFileDialog.h"
#include "FmParam.h"
#include "SelectJumpFolderDialog.h"
#include "TreeFrameWindow.h"
#include "JumpFrame.h"

#include <io.h>
#include <locale.h>

#include "Shlwapi.h"

// CFindFileDialog _CAO

IMPLEMENT_DYNAMIC(CFindFileDialog, CDialog)

CFindFileDialog::CFindFileDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CFindFileDialog::IDD, pParent)
	, m_FindDir(_T(""))
	, m_FileName(_T("*.*"))
	, m_Path(_T("C:\\"))
	, m_FullPath(_T(""))
	, m_CheckDirname(FALSE)
	, m_CheckInsubdir(TRUE)
{
	m_Cancel = false;
	m_Run = false;
	m_Move = false;
	m_FindFileName = _T("");
	m_FindPath = _T("");


}

CFindFileDialog::~CFindFileDialog()
{
//	CoUninitialize();
}

void CFindFileDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_FILENAME, m_ctrlFileName);
	DDX_Control(pDX, IDC_PATH, m_ctrlPath);
	DDX_Text(pDX, IDC_FIND_DIR, m_FindDir);
	DDX_Control(pDX, IDC_FIND_LIST, m_ctrlFindList);
	DDX_CBString(pDX, IDC_FILENAME, m_FileName);
	DDX_CBString(pDX, IDC_PATH, m_Path);
	DDX_Check(pDX, IDC_CHECK_DIRNAME, m_CheckDirname);
	DDX_Check(pDX, IDC_CHECK_INSUBDIR, m_CheckInsubdir);
	DDX_Control(pDX, IDC_CHECK_INSUBDIR, m_ctrlCheckInSubDir);
	DDX_Control(pDX, IDC_CHECK_DIRNAME, m_ctrlCheckDirName);
	DDX_Control(pDX, IDC_FIND_DIR, m_ctrlSerchingDir);
}


BEGIN_MESSAGE_MAP(CFindFileDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CFindFileDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_MOVE_BUTTON, &CFindFileDialog::OnBnClickedMoveButton)
	ON_LBN_SETFOCUS(IDC_FIND_LIST, &CFindFileDialog::OnLbnSetfocusFindList)
	ON_BN_CLICKED(IDC_BROWSE_BUTTON, &CFindFileDialog::OnBnClickedBrowseButton)
	ON_BN_CLICKED(IDC_JUMPFOLDER_BUTTON, &CFindFileDialog::OnBnClickedJumpfolderButton)

	ON_COMMAND(ID_TREE_MESSAGE, &CFindFileDialog::OnTreeMessage)
	ON_COMMAND(ID_JUMP_MESSAGE, &CFindFileDialog::OnJumpMessage)
	ON_BN_CLICKED(IDC_BROWSE_WIN, &CFindFileDialog::OnBnClickedBrowseWin)
	ON_CBN_SELCHANGE(IDC_FILENAME, &CFindFileDialog::OnCbnSelchangeFilename)
	ON_CBN_SELCHANGE(IDC_PATH, &CFindFileDialog::OnCbnSelchangePath)
	ON_LBN_KILLFOCUS(IDC_FIND_LIST, &CFindFileDialog::OnLbnKillfocusFindList)
	ON_BN_CLICKED(IDC_COPYBUTTON, &CFindFileDialog::OnBnClickedCopybutton)
END_MESSAGE_MAP()


// CFindFileDialog bZ[W nh

// Jn{^ON
void CFindFileDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	CString s;
	m_ctrlPath.GetWindowTextW(s);
	m_Path = s;

	if ( s == _T("") ) {
		OnBnClickedBrowseButton();
		return;
	}
	if ( m_Run ) {
		m_Cancel = true;
		return;
	}

	CDialog::SetDefID(IDOK);

	m_Run = true;
//	UpdateData(FALSE);

	int cb;
	cb = m_ctrlCheckInSubDir.GetCheck();
	m_CheckInsubdir = false;
	if ( cb == BST_CHECKED ) m_CheckInsubdir = true;

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;

	sSection = INISECTION_SETTINGS;
	sEntry = INIENTRY_SETTINGS_SEARCH_SUBDIR;

	pApp->WriteProfileInt(sSection, sEntry, cb);

	cb = m_ctrlCheckDirName.GetCheck();
	m_CheckDirname = false;
	if ( cb == BST_CHECKED ) m_CheckDirname = true;

	m_ctrlFileName.GetWindowTextW(s);
	m_FileName = s;

	m_ctrlPath.GetWindowTextW(s);
	m_Path = s;

	CFileStatus rStatus;
	CFile::GetStatus(s, rStatus);
	int at = rStatus.m_attribute;
	if ( !CFile::GetStatus(s, rStatus) || ((at & _A_SUBDIR) == 0 ) ) {	// DIR݂Ȃ܂DIRłȂ
		s.Format(_T("[ %s ]\ntH_܂"), m_Path);
		MessageBox(s);
		return;
	}
	CString fext;
	fext = _T(".hid");
	m_pFmParam->WriteHistoryFile(fext, s);
	fext = _T(".hiw");
	m_pFmParam->WriteHistoryFile(fext, m_FileName, true);


	if ( m_Path.GetAt(m_Path.GetLength() - 1) != CHAR_YEN ) m_Path += STR_YEN;
	m_FullPath = m_Path;
	m_ctrlFindList.ResetContent();
	m_ctrlFindList.Invalidate();
	m_MaxStrNum = 0;
	m_Cancel = false;
	GetDlgItem(IDCANCEL)->EnableWindow(FALSE);
	GetDlgItem(IDC_MOVE_BUTTON)->EnableWindow(FALSE);
	CString mes;
	mes = _T("~");
	GetDlgItem(IDOK)->SetWindowTextW(mes);

	m_ffNum = 0;
	m_dwSize = 0;
	m_dwSizeT = 0;
	m_saDropFilesArray.RemoveAll();

	FindFileInDir(m_FullPath);

// Xg{bNX̃foCXReLXg擾
	CDC *pDC = m_ctrlFindList.GetDC();
// foCXReLXgɃXg{bNX̃tHgݒ
	CFont* pOldFont = pDC->SelectObject(m_ctrlFindList.GetFont());
// Xg{bNX̍ő啶񕝎擾
    int nSize = pDC->GetTextExtent(m_sMax).cx;
// XN[o[ݒ
	m_ctrlFindList.SetHorizontalExtent(nSize + 10);
// foCXReLXg̃tHgɖ߂
	pDC->SelectObject(pOldFont);
	ReleaseDC(pDC);


	m_Run = false;
	mes = _T("t@ČI܂B");
	AfxMessageBox(mes);
	mes = _T("");
	GetDlgItem(IDOK)->SetWindowTextW(mes);
	if ( m_ffNum > 0 ) {
		m_ctrlFindList.SetCurSel(0);
		GetDlgItem(IDC_MOVE_BUTTON)->EnableWindow();
		m_ctrlFindList.SetFocus();
		CDialog::SetDefID(IDC_MOVE_BUTTON);
	}
	GetDlgItem(IDCANCEL)->EnableWindow();

	m_pFmParam->m_FindMoveLine = 0;

	fext = _T(".hid");
	m_pFmParam->ReadHistoryFile(fext, &m_ctrlPath);

	fext = _T(".hiw");
	m_pFmParam->ReadHistoryFile(fext, &m_ctrlFileName, true);

	m_ctrlPath.SetWindowTextW(m_Path);
	m_ctrlFileName.SetWindowTextW(m_FileName);

	CString path, sbuf;
	s.Format(_T("annsFM%s"), _T(".fnd"));
	path = m_pFmParam->GetExePath(s);

	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;
	if ( !cfile.Open( path, CFile::modeWrite | CFile::modeCreate ) ) {
		return;
	}

	int max = m_ctrlFindList.GetCount();

	for( int n = 0; n < max; n++ ) {
		m_ctrlFindList.GetText(n, sbuf);
		sbuf += _T("\n");
		cfile.WriteString(sbuf);
	}

	cfile.Close();

	ReleaseDC(pDC);


//	OnOK();
}

void CFindFileDialog::FindFileInDir(CString fullpath)
{
	struct _wfinddata64_t *pc_file;
	intptr_t hFile;
	CString fpath, fn, mydir, parentdir, wCard, fullname;
	bool fdir = false;
	int at, ir;
	CFileStatus rStatus;
	m_FindDir = fullpath;
//	UpdateData(false);

	pc_file = new _wfinddata64_t[MAX_FIND_FILE];

	mydir = _T(".");
	parentdir = _T("..");
//	UpdateData();
	m_ctrlSerchingDir.SetWindowTextW(m_FindDir);

	wCard = _T("*.*");
	fpath = fullpath + wCard;
	wCard = m_FileName;

	if( (hFile = _wfindfirst64( fpath, &pc_file[m_ffNum] )) != -1L ) {
		ir = 0;

		while( ir == 0 ) {
			at = pc_file[m_ffNum].attrib;
			fn = pc_file[m_ffNum].name;
			fullname = fullpath;
//			fullname += _T("\\");
			fullname += fn;
			BOOL pr = m_pFmParam->PathMatchSpecX(fn, wCard);

			if ( (at & _A_SUBDIR) != 0 ) {	// DIRȂ
				if  ( (fn != mydir) && (fn != parentdir) ) {
					if ( m_CheckDirname ) {
						if ( pr ) {
							m_ctrlFindList.AddString(fullname);
							m_saDropFilesArray.Add(fullname);
							m_dwSize += (fullname.GetLength() + 1);
							m_dwSizeT += (fullname.GetLength() + 2);
							m_ffNum++;
							int smax;
							smax = fullname.GetLength();
							if ( smax > m_MaxStrNum ) {
								m_MaxStrNum = smax;
								m_sMax = fullname;
							}
						}
					}
					if ( m_CheckInsubdir ) {
						fullname += _T("\\");
						FindFileInDir(fullname);
					}
				}
			} else {
				if ( pr ) {
					m_ctrlFindList.AddString(fullname);
					m_saDropFilesArray.Add(fullname);
					m_dwSize += (fullname.GetLength() + 1);
					m_dwSizeT += (fullname.GetLength() + 2);

					m_ffNum++;
					int smax;
					smax = fullname.GetLength();
					if ( smax > m_MaxStrNum ) {
						m_MaxStrNum = smax;
						m_sMax = fullname;
					}
				}
			}
			if ( m_Cancel ) break;
			ir = _wfindnext64( hFile, &pc_file[m_ffNum] );
			MyDispatchMessage();
		}
		_findclose( hFile );
	}

	delete []pc_file;
}

void CFindFileDialog::OnBnClickedMoveButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	CString fname;

	m_pFmParam->m_FindMoveLine = m_ctrlFindList.GetCurSel();

	m_ctrlFindList.GetText(m_pFmParam->m_FindMoveLine, fname);
	int at = GetFileAttributes(fname);
	if ( at != -1 ) {
		int n = fname.ReverseFind(CHAR_YEN);
		m_FindPath = fname.Left(n + 1);
		int rn = fname.GetLength() - n;
		m_FindFileName = fname.Right(rn - 1);
		m_Move = true;
	}
	OnOK();

}

void CFindFileDialog::MyDispatchMessage(void)
{
	MSG aMsg;
	while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
	{

		::TranslateMessage( &aMsg );
		::DispatchMessage( &aMsg );
	}
}

BOOL CFindFileDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ



//	UpdateData(FALSE);

	CString fext;
	fext = _T(".hid");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlPath);

	fext = _T(".hiw");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlFileName, true);

	m_ctrlPath.SetWindowTextW(m_Path);
	m_ctrlFileName.SetWindowTextW(m_FileName);

	m_ffNum = 0;
	m_dwSize = 0;
	m_dwSizeT = 0;

	m_saDropFilesArray.RemoveAll();

	CString path, s;
	s.Format(_T("annsFM%s"), _T(".fnd"));
	path = m_pFmParam->GetExePath(s);

	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;
	if ( cfile.Open( path, CFile::modeRead ) ) {

		CString sbuf;
		int max = MAX_FIND_FILE;
		CString *sLine;
		sLine = new CString[MAX_FIND_FILE];

		int n;
		for ( n = 0; n < max; n++ ) {
			BOOL r = cfile.ReadString(sbuf);
			if ( !r ) break;
			sLine[n] = sbuf;
			m_ffNum++;
		}

		cfile.Close();

		m_ctrlFindList.ResetContent();

		for ( int i = 0; i < n; i++ ) {
			m_ctrlFindList.InsertString(i, sLine[i]);
			m_saDropFilesArray.Add(sLine[i]);
			m_dwSize += (sLine[i].GetLength() + 1);
			m_dwSizeT += (sLine[i].GetLength() + 2);
		}
		delete []sLine;
	}

	if ( m_ffNum > 0 ) {
		m_ctrlFindList.SetCurSel(m_pFmParam->m_FindMoveLine);
		GetDlgItem(IDC_MOVE_BUTTON)->EnableWindow();
	}

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;

	sSection = INISECTION_SETTINGS;
	sEntry = INIENTRY_SETTINGS_SEARCH_SUBDIR;

	int sub = pApp->GetProfileInt(sSection, sEntry, BST_CHECKED);

	m_ctrlCheckInSubDir.SetCheck(sub);
//	m_ctrlCheckInSubDir.SetCheck(BST_CHECKED);

//	CoInitialize(NULL);
	CEdit *pEdit = (CEdit *)m_ctrlPath.GetWindow(GW_CHILD);
//	CEdit *pEdit2 = (CEdit *)m_ctrlFileName.GetWindow(GW_CHILD);

	if (m_pFmParam->m_bSettingsAutocomplete) {
		::SHAutoComplete(pEdit->m_hWnd, SHACF_FILESYSTEM);
//		::SHAutoComplete(pEdit2->m_hWnd, SHACF_FILESYSTEM);
	}

	if (m_pFmParam->m_bSettingsSetDialogFont) {
		m_nfont.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_ctrlFileName.SetFont(&m_nfont);
		m_pfont.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_ctrlPath.SetFont(&m_pfont);

	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CFindFileDialog::OnLbnSetfocusFindList()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	CDialog::SetDefID(IDC_MOVE_BUTTON);

}

void CFindFileDialog::OnBnClickedBrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}

	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();


}

void CFindFileDialog::OnBnClickedJumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_pJumpFrameWindow = new CJumpFrame;
	m_pJumpFrameWindow->m_pFmParam = m_pFmParam;
	m_pJumpFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrameWindow->ShowWindow(SW_SHOW);
	m_pJumpFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pJumpFrameWindow->UpdateWindow();

/*
	CSelectJumpFolderDialog dlg;
	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r = IDOK ) {
		m_Path = dlg.m_sSelectedFolder;
		m_ctrlPath.SetWindowTextW(m_Path);
		m_ctrlPath.SetFocus();
	}
*/

}

void CFindFileDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

	SetFocus();
	m_Path = path;
	m_ctrlPath.SetWindowTextW(path);
	m_ctrlPath.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CFindFileDialog::OnJumpMessage()
{
	CString path = m_pFmParam->m_sSelectedJumpPath;

	SetFocus();
	m_Path = path;
	m_ctrlPath.SetWindowTextW(path);
	m_ctrlPath.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CFindFileDialog::OnBnClickedBrowseWin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	cpath = cpath.Left(cpath.GetLength() - 1);

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = 0;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_Path = chPutFolder;
			m_Path += STR_YEN;
			m_ctrlPath.SetWindowTextW(m_Path);
			m_ctrlPath.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}

}

void CFindFileDialog::OnCbnSelchangeFilename()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlFileName.ShowDropDown();
}

void CFindFileDialog::OnCbnSelchangePath()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlPath.ShowDropDown();
}

int CALLBACK CFindFileDialog::BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
		::SendMessage(hwnd,BFFM_SETSELECTION,(WPARAM)TRUE,lpData);
    }
    return 0;
}


void CFindFileDialog::OnLbnKillfocusFindList()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	CDialog::SetDefID(IDOK);

}

void CFindFileDialog::CopyClipboard(void)
{
	HDROP hDrop = CopyCreateFiles();

	if (!OpenClipboard()) {
		return;
	}
	EmptyClipboard();

	SetClipboardData(CF_HDROP, hDrop);

	int hsize = sizeof(DROPEFFECT);
	HDROP hDropEffect = (HDROP)::GlobalAlloc(GHND, hsize);
	DROPEFFECT *pDropEffect = (DROPEFFECT*)::GlobalLock(hDropEffect);
	DROPEFFECT dropeffect = DROPEFFECT_COPY;

	char* lpchr = (char *)(pDropEffect);
	char* lpchr2 = (char *)(&dropeffect);

	::memcpy(lpchr, lpchr2, hsize);
	::GlobalUnlock(hDropEffect);

	UINT cfFormat = ::RegisterClipboardFormat(CFSTR_PREFERREDDROPEFFECT);
	SetClipboardData(cfFormat, hDropEffect);

	CloseClipboard();

	CopyTextClipboard(false);

}


void CFindFileDialog::CopyTextClipboard(bool clear)
{

	DWORD size = m_dwSizeT;
	size++;
	int sof = sizeof(wchar_t);
	size = size * sof;

	int hsize = size;

	CString fname;
	int asize;
	wchar_t *cbuf, *pcb;
	cbuf = new wchar_t[hsize];
	pcb = cbuf;

	for (int i = 0; i < m_ffNum; i++) {
		fname = m_saDropFilesArray.GetAt(i);
		if (m_ffNum > 1) fname += _T("\r\n");
		asize = fname.GetLength();
		memcpy(pcb, fname.GetBuffer(), asize * sof);
		pcb += asize;
	}
	*pcb = '\0';
	pcb++;
	*pcb = '\0';

	HGLOBAL hg = (HGLOBAL)::GlobalAlloc(GHND | GMEM_SHARE, hsize);
	if (hg == NULL) {
		delete[]cbuf;
		return;
	}

	PTSTR ptStr = (PTSTR)GlobalLock(hg);

	::memcpy(ptStr, cbuf, hsize);

	delete[]cbuf;

	GlobalUnlock(hg);


	if (!OpenClipboard()) {
		return;
	}

	if (clear) EmptyClipboard();
	SetClipboardData(CF_UNICODETEXT, hg);

	CloseClipboard();
}



HDROP CFindFileDialog::CopyCreateFiles(void)
{
	DWORD size = m_dwSize * sizeof(wchar_t);

	int hsize = sizeof(DROPFILES) + size + (sizeof(wchar_t) * 2);
	HDROP hDrop = (HDROP)::GlobalAlloc(GHND, hsize);
	if (hDrop == NULL)
		return hDrop;

	LPDROPFILES pDropFile = (LPDROPFILES)::GlobalLock(hDrop);
	pDropFile->pFiles = sizeof(DROPFILES);
	pDropFile->pt.x = 0;
	pDropFile->pt.y = 0;
	pDropFile->fNC = FALSE;
	pDropFile->fWide = TRUE;

	CString fname;
	char* lpNams = (char *)(pDropFile);
	lpNams += pDropFile->pFiles;
	for (int i = 0; i < m_ffNum; i++) {
		fname = m_saDropFilesArray.GetAt(i);
		int asize = (fname.GetLength() + 1) * sizeof(wchar_t);
		::memcpy(lpNams, fname.GetBuffer(), asize);
		lpNams += asize;
	}
	::GlobalUnlock(hDrop);

	return(hDrop);
}


void CFindFileDialog::OnBnClickedCopybutton()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	if (m_ffNum == 0) {
		MessageBox(_T("ς݃t@C܂"));
		return;

	}

	CopyClipboard();

}
