// FileView.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "FileView.h"

#include "DriveTabWnd.h"
#include "InfoWnd.h"
#include "annsViewFrame.h"
#include "annsView.h"
#include "annsViewEx.h"
#include "SetAttributeDialog.h"
#include "CopyFileDialog.h"
#include "SelectCopyDialog.h"
#include "CopyInfoDialog.h"
#include "DeleteFileDialog.h"
#include "EditorDialog.h"
#include "FindFileDialog.h"
#include "MovePathDialog.h"
#include "MakeDirDialog.h"
#include "SelectDriveDialog.h"
#include "SelectSortDialog.h"
#include "ChangeNameDialog.h"
#include "DeleteInfoDialog.h"
#include "UnPackDialog.h"
#include "PackDialog.h"
#include "annsGView.h"
#include "ConnectNetworkDialog.h"
#include "MciDialog.h"
#include "MirrorCopyDialog.h"
#include "MirrorCopyingDialog.h"
#include "MirrorCopySureDialog.h"
#include "ChangeDisplayAttributeDialog.h"
#include "ChangeNameAllDialog.h"
#include "JumpFrame.h"
#include "CloseUncTabDialog.h"
#include "MainFrm.h"
#include "ChildView.h"
#include "RunProgramDialog.h"
#include "ChangeFileTimeDialog.h"
#include "ChangeVolumeLabelDialog.h"
#include "SelectExtfileDialog.h"
#include "RunMacroDialog.h"
#include "annsTreeView.h"
#include "SelectCurdirDialog.h"
#include "SetparamDialog.h"

#include "Devicetopology.h"
#include "mmdeviceapi.h"
#include "endpointvolume.h"

#include "InputPasswordDialog.h"
#include "WildCardDialog.h"

#include <locale.h>

#include "io.h"
#include "shellapi.h"

#include <mmsystem.h>
#include <stdlib.h>


#include "spi.h"

#include "RestoreZipDialog.h"
#include "ExitDialog.h"
#include "SelectRemoveDrive.h"
#include "FileErrorDialog.h"

#include "LauncherFrame.h"
#include "LauncherView.h"

// #include "nvdaController.h"


#define MARKOFSET 5
#define MARKX 12


// Key code
/*

0x08	Backspace
0x09	Tab

0x0d	Enter

0x10	Shift
0x11	Ctrl

0x1b	Esc

0x20	Space
0x21	Page Up
0x22	Page Down
0x23	End
0x24	Home
0x25	
0x26	
0x27	
0x28	

0x2d	Insert
0x2e	Delete

0x30	0
0x31	1
0x32	2
0x33	3
0x34	4
0x35	5
0x36	6
0x37	7
0x38	8
0x39	9

0x41	A
0x42	B
0x43	C
0x44	D
0x45	E
0x46	F
0x47	G
0x48	H
0x49	I
0x4a	J
0x4b	K
0x4c	L
0x4d	M
0x4e	N
0x4f	O

0x50	P
0x51	Q
0x52	R
0x53	S
0x54	T
0x55	U
0x56	V
0x57	W
0x58	X
0x59	Y
0x5a	Z
0x5b	Windows key

0x5d	j[

ȉeL[
0x60	0
0x61	1
0x62	2
0x63	3
0x64	4
0x65	5
0x66	6
0x67	7
0x68	8
0x69	9
0x6a	*
0x6b	+
0x6c
0x6d	-
0x6e	.
0x6f	/
eL[܂


0x70	F1
0x71	F2
0x72	F3
0x73	F4
0x74	F5
0x75	F6
0x76	F7
0x77	F8
0x78	F9
0x79	F10
0x7a	F11
0x7b	F12

0xba	:
0xbb	;
0xbc	,
0xbd	-
0xbe	.
0xbf	/

0xc0	@

0xdb	[
0xdc	\
0xdd	]
0xde	^

0xe2	obNXbV()
0xe5	ϊ



0xf0	CapsLock

0xf2	Ђ炪

0xf4	p/Sp

*/


namespace MyShellHelpers
{
	bool ShowShellContextMenuImpl(IShellFolder* pShellFolder, CWnd* pWnd, CPoint point, LPCITEMIDLIST itemIdListPtrs[], UINT itemIdListCount, IContextMenu3*& pContextMenuExtra)
	{
		if (pShellFolder && itemIdListPtrs)
		{
			ATLASSERT(pContextMenuExtra == nullptr);
			ATL::CComPtr<IContextMenu> pContextMenu;
			// IShellFolder::GetUIObjectOf() ̑3̌^ PCUITEMID_CHILD_ARRAY ɂȂĂBLPCITEMIDLIST* B
			// LPCITEMIDLIST z擪vf̃AhXw肷B
			// 2Ŕz̗vfw肷B
			if (SUCCEEDED(pShellFolder->GetUIObjectOf(pWnd->GetSafeHwnd(), itemIdListCount, itemIdListPtrs, IID_IContextMenu, nullptr, reinterpret_cast<void**>(&pContextMenu))) &&
				SUCCEEDED(pContextMenu->QueryInterface(IID_PPV_ARGS(&pContextMenuExtra))))
			{
				CMenu menu;
				menu.CreatePopupMenu();
				const UINT uFlags = CMF_NORMAL | CMF_CANRENAME;
				if (SUCCEEDED(pContextMenuExtra->QueryContextMenu(menu.GetSafeHmenu(), 0, 1, 0x7fff, uFlags)))
				{
					pWnd->ClientToScreen(&point);
					pWnd->SetForegroundWindow();
					const int selectedMenuItemId = menu.TrackPopupMenuEx(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON | TPM_RETURNCMD, point.x, point.y, pWnd, nullptr);
					if (selectedMenuItemId > 0)
					{
						CMINVOKECOMMANDINFO cmi = {};
						cmi.cbSize = sizeof(CMINVOKECOMMANDINFO);
						cmi.nShow = SW_SHOWNORMAL;
						cmi.hwnd = pWnd->GetSafeHwnd();
						cmi.lpVerb = MAKEINTRESOURCEA(selectedMenuItemId - 1);
						pContextMenuExtra->InvokeCommand(&cmi);
						return true;
					}
				}
			}
		}

		return false;
	}

	template<typename T> ULONG SafeReleaseAndGetLastRefCount(T*& ptr)
	{
		if (ptr)
		{
			const auto refCount = ptr->Release();
			ptr = nullptr;
			return refCount;
		}
		return 0;
	}

	struct CoTaskMemDeleter
	{
		void operator ()(void* ptr)
		{
			::CoTaskMemFree(ptr);
		}
	};

	using TItemIdListUniquePtr = std::unique_ptr<ITEMIDLIST, CoTaskMemDeleter>;

#if 0
	// P̃t@CpX݂̂ɑΉBzo[WX[p[ZbgɂȂ̂ŁAۂ͕KvȂB
	bool ShowShellContextMenuImpl(CWnd* pWnd, CPoint point, const CString& strFilePath, IContextMenu3*& pContextMenuExtra)
	{
		ATL::CComPtr<IShellFolder> pShellFolder;

		LPCITEMIDLIST pidlLast = nullptr;
		// Â OS ł ITEMIDLIST ̉ ILFree() gKvAWindows 2000 ȍ~ CoTaskMemFree() gĂ悢Ƃ̂ƁB
		// https://msdn.microsoft.com/en-us/library/windows/desktop/bb776441.aspx
		ATL::CComHeapPtr<ITEMIDLIST> pidlFull(::ILCreateFromPath(strFilePath));
		if (pidlFull)
		{
			ATLVERIFY(SUCCEEDED(::SHBindToParent(pidlFull, IID_PPV_ARGS(&pShellFolder), &pidlLast)));
			//ATL::CComHeapPtr<ITEMIDLIST> pidlParent(::ILClone(pidlFull));
			//::ILRemoveLastID(pidlParent);
		}

		if (pidlLast)
		{
			return ShowShellContextMenuImpl(pShellFolder, pWnd, point, &pidlLast, 1, pContextMenuExtra);
		}
		else
		{
			return false;
		}
	}
#endif

	bool ShowShellContextMenuImpl(CWnd* pWnd, CPoint point, const std::vector<CString>& strFilePaths, IContextMenu3*& pContextMenuExtra)
	{
		ATL::CComPtr<IShellFolder> pShellFolder;

		// ]炠 ATL/MFC  CStringArray  CArray<CString> g@邪AC++11 ֗̕ȍ\@\gȂ̂ŋpB

		std::vector<LPCITEMIDLIST> pidlLasts;
		std::vector<TItemIdListUniquePtr> pidlFulls;
		for (const auto& strFilePath : strFilePaths)
		{
			TItemIdListUniquePtr pidlFull(::ILCreateFromPath(strFilePath));
			if (pidlFull)
			{
				LPCITEMIDLIST pidlLast = nullptr;
				if (pShellFolder)
				{
					pidlLast = ::ILFindLastID(pidlFull.get());
				}
				else
				{
					ATLVERIFY(SUCCEEDED(::SHBindToParent(pidlFull.get(), IID_PPV_ARGS(&pShellFolder), &pidlLast)));
				}
				ATLASSERT(pidlLast);
				if (pidlLast)
				{
					pidlLasts.push_back(pidlLast);
				}
				pidlFulls.push_back(std::move(pidlFull));
			}
		}

		if (pidlLasts.empty())
		{
			return false;
		}
		else
		{
			return ShowShellContextMenuImpl(pShellFolder, pWnd, point, pidlLasts.data(), static_cast<UINT>(pidlLasts.size()), pContextMenuExtra);
		}
	}

#if 0
	bool ShowShellContextMenu(CWnd* pWnd, CPoint point, const CString& strFilePath, IContextMenu3*& pContextMenuExtra)
	{
		const bool ret = ShowShellContextMenuImpl(pWnd, point, strFilePath, pContextMenuExtra);
		ATLVERIFY(SafeReleaseAndGetLastRefCount(pContextMenuExtra) == 0);
		return ret;
	}
#endif

	bool ShowShellContextMenu(CWnd* pWnd, CPoint point, const std::vector<CString>& strFilePaths, IContextMenu3*& pContextMenuExtra)
	{
		const bool ret = ShowShellContextMenuImpl(pWnd, point, strFilePaths, pContextMenuExtra);
		ATLVERIFY(SafeReleaseAndGetLastRefCount(pContextMenuExtra) == 0);
		return ret;
	}
}

template <class T> void SafeRelease(T **ppT)
{
	if (*ppT)
	{
		(*ppT)->Release();
		*ppT = NULL;
	}
}


// CFileView

IMPLEMENT_DYNCREATE(CFileView, CView)

CFileView::CFileView()
{

	m_xOfset = 20;	// t@C\ʒux ItZbg(}[N\)
	m_yOfset = 3;
	m_CurrentFileNo = 0;	// J[\ʒu̓ftHg擪
	m_CurrentPage = 0;	// y[Wl0
	m_PageFileNum = 1;
	m_PostCmdNo = 0;

	for (int i = 0; i < MAXVIEW; i++) {
		m_pViewFrame[i] = NULL;
//		m_ViewExist[i] = false; 
	}
	m_lpDropTarget	= NULL;
	m_bOwnDragging	= FALSE;
	m_pMciDialog = NULL;

	m_bMciShow = false;
	m_bInitFileList = false;
	m_pTreeFrameWindow = NULL;
//	m_pwndChild = NULL;
	m_sSelectedTreePath = _T("");
	m_pTreeFrameWindow = NULL;
	m_nWndCount = 0;
	m_phwndannsFM = new HWND[10];

	m_bRunCmd = false;

	m_pw64fdSendTo = new _wfinddata64_t[100];

	m_hMixer = NULL;
	m_dwVolumeControlID = -1;
	m_dwMuteControlID = -1;

	saLmzip32ViewOption = "";
	m_bPerfectDelete = false;

	m_bVoiceInit = true;
//	m_bDisplayOff = false;
	m_bNowGetDir = false;
	m_bIncSearch = false;
	m_sIncSearchStr = _T("");

//	if (m_pFmParam->m_bSystemDirectWrite) {
//		CoInitialize(NULL);
//	}

#ifndef _WINVER_XP
	g_pDWriteFactory = NULL;
	g_pD2DFactory = NULL;
	g_pTextFormat = NULL;

	g_pRenderTarget = NULL;
	g_pBackBrush = NULL;
	g_pListNormalBrush = NULL;
	g_pListSystemBrush = NULL;
	g_pListReadonlyBrush = NULL;
	g_pListHideBrush = NULL;
	g_pListDirBrush = NULL;

	g_pFrameBrush = NULL;
#endif

	hInsMoviePlayer = NULL;

	lpMpdOpenForm = NULL;
	lpMpdCloseForm = NULL;
	lpMpdStart = NULL;

	m_bInitialSearch = false;


}

CFileView::~CFileView()
{
// #ifndef _DIRECT_WRITE

//	if (!(m_pFmParam->m_bSystemDirectWrite)) {
//		delete m_pScrollBar;
//	}
	
// #endif

//	if ( m_pJumpFrame ) delete m_pJumpFrame;
	delete []m_phwndannsFM;
	delete []m_pw64fdSendTo;

	if (m_pFmParam->m_bSystemDirectWrite) {
#ifndef _WINVER_XP
		DiscardD2d1Resources();
#endif
	}

	if (hInsMoviePlayer) {
		MoviePlayer(1);	// close
		FreeLibrary(hInsMoviePlayer);
	}

	hInsMoviePlayer = NULL;

	lpMpdOpenForm = NULL;
	lpMpdCloseForm = NULL;
	lpMpdStart = NULL;


}

BEGIN_MESSAGE_MAP(CFileView, CView)
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_WM_HSCROLL()
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEWHEEL()
ON_COMMAND(ID_KEY_A, &CFileView::OnMneuKeyA)
ON_COMMAND(ID_KEY_C, &CFileView::OnMenuKeyC)
ON_COMMAND(ID_KEY_D, &CFileView::OnMenuKeyD)
ON_COMMAND(ID_KEY_E, &CFileView::OnMenuKeyE)
ON_COMMAND(ID_KEY_F, &CFileView::OnMenuKeyF)
ON_COMMAND(ID_KEY_H, &CFileView::OnMenuKeyH)
ON_COMMAND(ID_KEY_J, &CFileView::OnMenuKeyJ)
ON_COMMAND(ID_KEY_K, &CFileView::OnMenuKeyK)
ON_COMMAND(ID_KEY_L, &CFileView::OnMenuKeyL)
ON_COMMAND(ID_KEY_M, &CFileView::OnMenuKeyM)
ON_COMMAND(ID_KEY_N, &CFileView::OnMenuKeyN)
ON_COMMAND(ID_KEY_O, &CFileView::OnMenuKeyO)
ON_COMMAND(ID_KEY_P, &CFileView::OnMenuKeyP)
ON_COMMAND(ID_KEY_Q, &CFileView::OnMenuKeyQ)
ON_COMMAND(ID_KEY_R, &CFileView::OnMenuKeyR)
ON_COMMAND(ID_KEY_S, &CFileView::OnMenuKeyS)
ON_COMMAND(ID_KEY_T, &CFileView::OnMenuKeyT)
ON_COMMAND(ID_KEY_U, &CFileView::OnMenuKeyU)
ON_COMMAND(ID_KEY_G, &CFileView::OnMenuKeyG)
ON_COMMAND(ID_KEY_V, &CFileView::OnMenuKeyV)

ON_COMMAND(ID_SHIFT_KEY_A, &CFileView::OnMenuShiftKeyA)
ON_COMMAND(ID_SHIFT_KEY_B, &CFileView::OnMenuShiftKeyB)
ON_COMMAND(ID_SHIFT_KEY_C, &CFileView::OnMenuShiftKeyC)
ON_COMMAND(ID_SHIFT_KEY_D, &CFileView::OnMenuShiftKeyD)
ON_COMMAND(ID_SHIFT_KEY_E, &CFileView::OnMenuShiftKeyE)
ON_COMMAND(ID_SHIFT_KEY_I, &CFileView::OnMenuShiftKeyI)
ON_COMMAND(ID_SHIFT_KEY_L, &CFileView::OnMenuShiftKeyL)
ON_COMMAND(ID_SHIFT_KEY_M, &CFileView::OnMenuShiftKeyM)
ON_COMMAND(ID_SHIFT_KEY_N, &CFileView::OnMenuShiftKeyN)
ON_COMMAND(ID_SHIFT_KEY_O, &CFileView::OnMenuShiftKeyO)
ON_COMMAND(ID_SHIFT_KEY_P, &CFileView::OnMenuShiftKeyP)
ON_COMMAND(ID_SHIFT_KEY_V, &CFileView::OnMenuShiftKeyV)
ON_COMMAND(ID_SHIFT_KEY_Z, &CFileView::OnMenuShiftKeyZ)

ON_COMMAND(ID_SHIFT_KEY_1, &CFileView::OnMenuShiftKey1)
ON_COMMAND(ID_SHIFT_KEY_2, &CFileView::OnMenuShiftKey2)
ON_COMMAND(ID_SHIFT_KEY_3, &CFileView::OnMenuShiftKey3)
ON_COMMAND(ID_SHIFT_KEY_4, &CFileView::OnMenuShiftKey4)
ON_COMMAND(ID_SHIFT_KEY_5, &CFileView::OnMenuShiftKey5)

ON_COMMAND(ID_CTRL_KEY_A, &CFileView::OnMenuCtrlKeyA)
ON_COMMAND(ID_CTRL_KEY_B, &CFileView::OnMenuCtrlKeyB)
ON_COMMAND(ID_CTRL_KEY_C, &CFileView::OnMenuCtrlKeyC)
ON_COMMAND(ID_CTRL_KEY_I, &CFileView::OnMenuCtrlKeyI)
ON_COMMAND(ID_CTRL_KEY_M, &CFileView::OnMenuCtrlKeyM)
ON_COMMAND(ID_CTRL_KEY_N, &CFileView::OnMenuCtrlKeyN)
ON_COMMAND(ID_CTRL_KEY_O, &CFileView::OnMenuCtrlKeyO)
ON_COMMAND(ID_CTRL_KEY_P, &CFileView::OnMenuCtrlKeyP)
ON_COMMAND(ID_CTRL_KEY_R, &CFileView::OnMenuCtrlKeyR)
ON_COMMAND(ID_CTRL_KEY_S, &CFileView::OnMenuCtrlKeyS)
ON_COMMAND(ID_CTRL_KEY_T, &CFileView::OnMenuCtrlKeyT)
ON_COMMAND(ID_CTRL_KEY_V, &CFileView::OnMenuCtrlKeyV)

ON_COMMAND(ID_KEY_YEN, &CFileView::OnMenuKeyYen)
ON_COMMAND(ID_KEY_BACKSPACE, &CFileView::OnMenuSpecialKeyBS)
ON_COMMAND(ID_KEY_SPACE, &CFileView::OnMenuSpecialKeySpace)
ON_COMMAND(ID_KEY_HOME, &CFileView::OnMenuSpecialKeyHome)
ON_COMMAND(ID_SHIFT_KEY_HOME, &CFileView::OnMenuSpecialKeyShiftHome)
ON_COMMAND(ID_KEY_ENTER, &CFileView::OnMenuSpecialKeyEnter)
ON_COMMAND(ID_SHIFT_KEY_ENTER, &CFileView::OnMenuSpecialKeyShiftEnter)
ON_COMMAND(ID_CTRL_KEY_ENTER, &CFileView::OnMenuSpecialKeyCtrlEnter)
ON_COMMAND(ID_KEY_SLASH, &CFileView::OnMenuSpecialKeySlash)

ON_COMMAND(ID_CTRL_KEY_HOME, &CFileView::OnMenuSpecialKeyCtrlHome)
ON_COMMAND(ID_KEY_END, &CFileView::OnMenuSpecialKeyEnd)

ON_WM_RBUTTONDOWN()

ON_COMMAND(ID_TREE_MESSAGE, &CFileView::OnTreeMessage)
ON_COMMAND(ID_JUMP_MESSAGE, &CFileView::OnJumpMessage)

ON_WM_SYSKEYDOWN()
ON_WM_SYSKEYUP()
ON_COMMAND(ID_Alt_Left, &CFileView::OnMenuSpecialKeyAltLeft)

ON_COMMAND(ID_MENU_SENDTO, &CFileView::OnMenuSendTo00)
ON_COMMAND(ID_MENU_SENDTO + 1, &CFileView::OnMenuSendTo01)
ON_COMMAND(ID_MENU_SENDTO + 2, &CFileView::OnMenuSendTo02)
ON_COMMAND(ID_MENU_SENDTO + 3, &CFileView::OnMenuSendTo03)
ON_COMMAND(ID_MENU_SENDTO + 4, &CFileView::OnMenuSendTo04)
ON_COMMAND(ID_MENU_SENDTO + 5, &CFileView::OnMenuSendTo05)
ON_COMMAND(ID_MENU_SENDTO + 6, &CFileView::OnMenuSendTo06)
ON_COMMAND(ID_MENU_SENDTO + 7, &CFileView::OnMenuSendTo07)
ON_COMMAND(ID_MENU_SENDTO + 8, &CFileView::OnMenuSendTo08)
ON_COMMAND(ID_MENU_SENDTO + 9, &CFileView::OnMenuSendTo09)
ON_COMMAND(ID_MENU_SENDTO + 10, &CFileView::OnMenuSendTo10)
ON_COMMAND(ID_MENU_SENDTO + 11, &CFileView::OnMenuSendTo11)
ON_COMMAND(ID_MENU_SENDTO + 12, &CFileView::OnMenuSendTo12)
ON_COMMAND(ID_MENU_SENDTO + 13, &CFileView::OnMenuSendTo13)
ON_COMMAND(ID_MENU_SENDTO + 14, &CFileView::OnMenuSendTo14)
ON_COMMAND(ID_MENU_SENDTO + 15, &CFileView::OnMenuSendTo15)
ON_COMMAND(ID_MENU_SENDTO + 16, &CFileView::OnMenuSendTo16)
ON_COMMAND(ID_MENU_SENDTO + 17, &CFileView::OnMenuSendTo17)
ON_COMMAND(ID_MENU_SENDTO + 18, &CFileView::OnMenuSendTo18)
ON_COMMAND(ID_MENU_SENDTO + 19, &CFileView::OnMenuSendTo19)
ON_COMMAND(ID_MENU_SENDTO + 20, &CFileView::OnMenuSendTo20)
ON_COMMAND(ID_MENU_SENDTO + 21, &CFileView::OnMenuSendTo21)
ON_COMMAND(ID_MENU_SENDTO + 22, &CFileView::OnMenuSendTo22)
ON_COMMAND(ID_MENU_SENDTO + 23, &CFileView::OnMenuSendTo23)
ON_COMMAND(ID_MENU_SENDTO + 24, &CFileView::OnMenuSendTo24)
ON_COMMAND(ID_MENU_SENDTO + 25, &CFileView::OnMenuSendTo25)

ON_WM_TIMER()
ON_COMMAND(ID_CTRL_KEY_TAB, &CFileView::OnMenuCtrlKeyTab)
ON_COMMAND(ID_KEY_Y, &CFileView::OnMenuKeyY)
ON_COMMAND(ID_CTRL_KEY_D, &CFileView::OnMenuCtrlKeyD)
ON_COMMAND(ID_KEY_ESC, &CFileView::OnMenuKeyEsc)
ON_COMMAND(ID_CTRL_KEY_X, &CFileView::OnMenuCtrlKeyX)
ON_COMMAND(ID_SHIFT_KEY_LEFT, &CFileView::OnMenuShiftKeyLeft)
ON_COMMAND(ID_CTRL_KEY_E, &CFileView::OnMenuCtrlKeyE)
ON_COMMAND(ID_SHIFT_KEY_T, &CFileView::OnMenuShiftKeyT)
ON_COMMAND(ID_SHIFT_KEY_U, &CFileView::OnMenuShiftKeyU)
ON_COMMAND(ID_SHIFT_KEY_S, &CFileView::OnShiftKeyS)
ON_COMMAND(ID_SHIFT_KEY_F, &CFileView::OnMenuShiftKeyF)
ON_COMMAND(ID_KEY_F3, &CFileView::OnMenuKeyF3)
ON_COMMAND(ID_KEY_TAB, &CFileView::OnMenuKeyTab)
ON_WM_CHAR()
ON_COMMAND(ID_CTRL_KEY_Z, &CFileView::OnMenuCtrlKeyZ)
ON_COMMAND(ID_CTRL_KEY_K, &CFileView::OnMenuCtrlKeyK)
ON_COMMAND(ID_KEY_F7, &CFileView::OnMenuKeyF7)
ON_COMMAND(ID_KEY_F2, &CFileView::OnMenuKeyF2)
ON_WM_QUERYENDSESSION()
ON_WM_RBUTTONUP()
ON_COMMAND(ID_KEY_RMENU, &CFileView::OnKeyMenuRmenu)
ON_COMMAND(ID_KEY_X, &CFileView::OnMenuKeyX)
ON_COMMAND(ID_KEY_INS, &CFileView::OnKeyMenuIns)
ON_COMMAND(ID_KEY_F5, &CFileView::OnKeyMenuF5)
ON_COMMAND(ID_CTRL_KEY_G, &CFileView::OnMenuCtrlKeyG)
ON_COMMAND(ID_SHIFT_KEY_G, &CFileView::OnMneuShiftKeyG)
ON_COMMAND(ID_KEY_F9, &CFileView::OnKeyF9)
ON_COMMAND(ID_Alt_Right, &CFileView::OnMneuAltRight)
ON_COMMAND(ID_33065, &CFileView::OnMenuEmptyRecycleBin)
ON_COMMAND(ID_KEY_B, &CFileView::OnMenuKeyB)
ON_COMMAND(ID_KEY_F8, &CFileView::OnKeyF8)
END_MESSAGE_MAP()


// CFileView ff

#ifdef _DEBUG
void CFileView::AssertValid() const
{
	CView::AssertValid();
}

#ifndef _WIN32_WCE
void CFileView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif
#endif //_DEBUG

#ifndef _WINVER_XP

void CFileView::CreateD2d1Resources()
{
	CreateDeviceIndependentResources();
	CreateTextFormat();
	CreateDeviceResources();
}

void CFileView::DiscardD2d1Resources()
{
	DiscardDeviceIndependentResources();
	DiscardTextFormat();
	DiscardDeviceResources();

}

HRESULT CFileView::CreateDeviceIndependentResources()
{
	HRESULT result = S_OK;

	D2D1CreateFactory(
		D2D1_FACTORY_TYPE_SINGLE_THREADED,
		&g_pD2DFactory);

	DWriteCreateFactory(
		DWRITE_FACTORY_TYPE_SHARED,
		__uuidof(g_pDWriteFactory),
		(IUnknown **)(&g_pDWriteFactory));


	return result;
}

void CFileView::DiscardDeviceIndependentResources()
{

	if (g_pDWriteFactory != NULL) {
		g_pDWriteFactory->Release();
		g_pDWriteFactory = NULL;

	}

	if (g_pD2DFactory != NULL) {
		g_pD2DFactory->Release();
		g_pD2DFactory = NULL;

	}


}

void CFileView::CreateTextFormat()
{

	if (g_pDWriteFactory == NULL) return;

	if (g_pTextFormat != NULL) return;

	CClientDC dc(AfxGetMainWnd());
	int logpix = dc.GetDeviceCaps(LOGPIXELSY);

	CString fontname = m_pFmParam->m_logfontFile.lfFaceName;

	int nPoint = -::MulDiv(m_pFmParam->m_logfontFile.lfHeight, 72, logpix);

	FLOAT fs = logpix * (FLOAT)nPoint / 72;
	int ifs = (INT)(fs + 1.99) / 2;
	FLOAT dip = (FLOAT)(ifs * 2);

	int it = m_pFmParam->m_logfontFile.lfItalic;

	DWRITE_FONT_STYLE st = DWRITE_FONT_STYLE_NORMAL;
	if (it != 0) st = DWRITE_FONT_STYLE_ITALIC;

	HRESULT hr;

	hr = g_pDWriteFactory->CreateTextFormat(
		//		L"Verdana",
		fontname,
		NULL,
		DWRITE_FONT_WEIGHT_NORMAL,
//		(DWRITE_FONT_WEIGHT)(m_pFmParam->m_logfontFile.lfWeight),
		DWRITE_FONT_STYLE_NORMAL,
//		st, // DWRITE_FONT_STYLE_NORMAL,
		DWRITE_FONT_STRETCH_NORMAL,
		//		50,	// tHgTCY
		dip,
		L"", //locale
		&g_pTextFormat);

	g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_LEADING);
	// g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_CENTER);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_NEAR);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_CENTER);

	m_FontHeight = (int)(g_pTextFormat->GetFontSize());
	m_LineHeight = m_FontHeight + m_pFmParam->m_nLineSpace;

	FLOAT dpiX, dpiY;
	g_pD2DFactory->GetDesktopDpi(&dpiX, &dpiY);

	m_sDebugString.Format(_T("FontName = %s\nDPIX = %2.1f\nDPIY = %2.1f\ndip = %2.1f\nFontHeight = %4d"), fontname, dpiX, dpiY, dip, m_FontHeight);


	LOGFONT lf;
	lf = m_pFmParam->m_logfontFile;
//	lf.lfWeight = 0x190;
//	lf.lfItalic = 0;

	CFont font;
	font.CreateFontIndirect(&lf);
	CFont* pOldFont = dc.SelectObject(&font);


	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);
	m_FontWidth = size.cx;

	dc.SelectObject(pOldFont);

	RecalcPageDirectWrite();

}

void CFileView::DiscardTextFormat()
{
	if (g_pTextFormat == NULL) return;

	g_pTextFormat->Release();
	g_pTextFormat = NULL;

}


HRESULT CFileView::CreateDeviceResources(void)
{
	HRESULT hr = S_OK;

	if (g_pRenderTarget != NULL) {
		return hr;
	}

	RECT rc;
	GetClientRect(&rc);

	D2D1_SIZE_U size = D2D1::SizeU(
		rc.right - rc.left,
		rc.bottom - rc.top
		);

	// Create a Direct2D render target.
	g_pD2DFactory->CreateHwndRenderTarget(
		D2D1::RenderTargetProperties(),
		D2D1::HwndRenderTargetProperties(m_hWnd, size),
		&g_pRenderTarget
		);

	COLORREF colBack = m_pFmParam->m_colBack;

	COLORREF colListNormal = m_pFmParam->m_colListNormal;	// ʏt@C\F
	COLORREF colListSystem = m_pFmParam->m_colListSystem;	// VXet@C\F
	COLORREF colListReadonly = m_pFmParam->m_colListReadonly;	// [hI[t@C\F
	COLORREF colListHide = m_pFmParam->m_colListHide;		// Bt@C\F
	COLORREF colListDir = m_pFmParam->m_colListDir;		// tH_\F

	COLORREF colFrame = m_pFmParam->m_colFrame;


	// Create a back brush.
	BYTE r, g, b;
	r = colBack & 0xff;
	g = (colBack >> 8) & 0xff;
	b = (colBack >> 16) & 0xff;

	UINT32 rgb;
	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pBackBrush
		);

	m_D2DcolBack = rgb;


	r = colListNormal & 0xff;
	g = (colListNormal >> 8) & 0xff;
	b = (colListNormal >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListNormalBrush);


	r = colListSystem & 0xff;
	g = (colListSystem >> 8) & 0xff;
	b = (colListSystem >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListSystemBrush);

	r = colListReadonly & 0xff;
	g = (colListReadonly >> 8) & 0xff;
	b = (colListReadonly >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListReadonlyBrush);


	r = colListHide & 0xff;
	g = (colListHide >> 8) & 0xff;
	b = (colListHide >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListHideBrush);

	r = colListDir & 0xff;
	g = (colListDir >> 8) & 0xff;
	b = (colListDir >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pListDirBrush);

	r = colFrame & 0xff;
	g = (colFrame >> 8) & 0xff;
	b = (colFrame >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pFrameBrush);

	return hr;
}

void CFileView::DiscardDeviceResources()
{
	if (g_pRenderTarget != NULL) {
		g_pRenderTarget->Release();
		g_pRenderTarget = NULL;

	}

	if (g_pBackBrush != NULL) {
		g_pBackBrush->Release();
		g_pBackBrush = NULL;
	}

	if (g_pListNormalBrush != NULL) {
		g_pListNormalBrush->Release();
		g_pListNormalBrush = NULL;
	}

	if (g_pListSystemBrush != NULL) {
		g_pListSystemBrush->Release();
		g_pListSystemBrush = NULL;
	}

	if (g_pListReadonlyBrush != NULL) {
		g_pListReadonlyBrush->Release();
		g_pListReadonlyBrush = NULL;
	}

	if (g_pListHideBrush != NULL) {
		g_pListHideBrush->Release();
		g_pListHideBrush = NULL;
	}

	if (g_pListDirBrush != NULL) {
		g_pListDirBrush->Release();
		g_pListDirBrush = NULL;
	}

	if (g_pFrameBrush != NULL) {
		g_pFrameBrush->Release();
		g_pFrameBrush = NULL;
	}




}

void CFileView::d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = CA2W(strA);

	int len = sText.GetLength();
	int glen = strA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_LineHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		//		D2D1::RectF(fX, fY, (FLOAT)rc.right, fY + lh),
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

}

void CFileView::d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = strW;

	CStringA sA;
	sA = CW2A(strW);

	int len = sText.GetLength();
	int glen = sA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_LineHeight);

//	CDC* pDC = GetDC();
//	CFont font;
//	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
//	CFont* pOldFont = pDC->SelectObject(&font);

//	int fw;

//	CSize size = pDC->GetTextExtent(strW);
//	fw = size.cx;

//	pDC->SelectObject(pOldFont);

	FLOAT fw = (FLOAT)(m_ColumnWidth - m_xOfset);


	CRect rc;
	GetClientRect(&rc);

//	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + (glen * m_FontWidth), fY + lh), backbrush);
	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + fw, fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
//		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		D2D1::RectF(fX, fY, fX + (FLOAT)fw, fY + lh),
		brush
		);

}

#endif




void CFileView::RecalcPage(void)
{

// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		RecalcPageDirectWrite();
#endif

		return;
	}

// #endif

	//	CClientDC pDC = CClientDC(this);
	CDC* pDC = GetDC();

	CRect rect;
	GetClientRect(&rect);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
	CFont* pOldFont = pDC->SelectObject(&font);


	int fw, fh;
	TEXTMETRIC tm;

	pDC->GetTextMetrics(&tm);
	m_FontHeight = tm.tmHeight;
	fw = m_FontWidth = tm.tmAveCharWidth;
	m_LineHeight = tm.tmHeight + m_pFmParam->m_nLineSpace;
	fh = m_LineHeight;



	CString s, s2, fname, fext, sSize, form;
	int max = m_pFmParam->m_FileNum;
	int cnt, dw, extw, tw, cmode, dt, maxtw, xlim;
	CSize csize;

	int sbh = m_ScrollBarHeight;

// #ifdef _DIRECT_WRITE

//	if (m_pFmParam->m_bSystemDirectWrite) {
		sbh = 0;
//	}

// #endif

	m_MaxLine = (rect.bottom - sbh - 2) / fh;	// ő\s
	maxtw = (rect.right - m_xOfset) / fw;	// ő\

	xlim = rect.right - FRAMEOFSET;
	cnt = 0;
	cmode = m_pFmParam->m_DisplayMode;
	dt = m_pFmParam->m_pFileParam[cmode].m_DisplayNameType;
	tw = 0;
	if (dt == 0) tw = m_pFmParam->m_pFileParam[cmode].m_NameLen;	// w
	if (dt == 1) tw = 8;	// DOS(8.3)
							//	if ( dt == 2 ) tw = m_pFmParam->m_MaxFileNameLen;	// 

	if (tw > maxtw) tw = maxtw;
	//	dw = fw * tw;	// 1̕\
	int nextw = m_pFmParam->m_pFileParam[cmode].m_ExtLen;
	if (dt == 1) nextw = 4;	// DOS(8.3)
							//	extw = fw * m_pFmParam->m_pFileParam[cmode].m_ExtLen;	// gq̕\
	extw = fw * nextw;	// gq̕\
	m_NameWidth = fw * tw;	// t@C̕\
	m_ExtWidth = extw;	// gq̕\

						//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize ) m_SizeWidth = fw * FILESIZEUNITWIDTH;	// t@CTCY̕\
						//	else m_SizeWidth = fw * FILESIZEWIDTH;	// t@CTCY̕\

	int fsn = FILESIZEWIDTH;
	if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
		fsn = FILESIZEUNITWIDTH;
	}

	m_SizeWidth = fw * fsn;	// t@CTCY̕\
//	m_SizeWidth = fw * FILESIZEWIDTH;	// t@CTCY̕\

										//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowDate ) m_DateWidth += fw * 2;
	m_DateWidth = fw * FILEDATEWIDTH;	// t̕\
	if (m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury) m_DateWidth += fw * 2;

	//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury ) m_TimeWidth += fw * 2;
	m_TimeWidth = fw * FILETIMEWIDTH;	// Ԃ̕\

										//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowAtribute ) m_AttWidth += fw * 2;
	m_AttWidth = fw * FILEATTWIDTH;	// ̕\

									//	dw = m_NameWidth;
	dw = 0;
	//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowSplitExt ) dw += extw;
	dw += extw;
	if (m_pFmParam->m_pFileParam[cmode].m_bShowSize) dw += (m_SizeWidth + (fw * 2));
	if (m_pFmParam->m_pFileParam[cmode].m_bShowDate) dw += (m_DateWidth + (fw * 2));
	if (m_pFmParam->m_pFileParam[cmode].m_bShowTime) dw += (m_TimeWidth + (fw * 2));
	if (m_pFmParam->m_pFileParam[cmode].m_bShowAtribute) dw += (m_AttWidth + (fw * 2));


	int dnw;
	if (dt == 2) {
		dnw = rect.right - (FRAMEOFSET * 2) - m_xOfset - (fw * 2) - dw;
		//		dnw = xlim - m_xOfset - dw;
		//		if ( m_pFmParam->m_pFileParam[cmode].m_bShowSplitExt ) dw += extw;
		tw = m_pFmParam->m_MaxFileNameLen * fw;
		if (tw < dnw) dnw = tw;
		m_NameWidth = dnw;	// t@C̕\
		dw += dnw;
	}
	else dw += m_NameWidth;

	m_ColumnWidth = dw + m_xOfset;	// 1̕\

	m_MaxColumn = (rect.right - ((FRAMEOFSET + fw) * 2)) / m_ColumnWidth;
	if (m_MaxColumn == 0) m_MaxColumn = 1;

	if (m_pFmParam->m_pFileParam[cmode].m_bShowOverPart) {
		//		int nmc = m_MaxColumn;
		//		m_MaxColumn = (rect.right - (FRAMEOFSET * 2) - m_xOfset - (fw * 2)) / (dw + m_xOfset) + 1;
		//		if ( m_MaxColumn > nmc ) {
		//		}
	}
	m_PageFileNum = m_MaxLine * m_MaxColumn;
	if (m_PageFileNum == 0) m_PageFileNum = m_MaxLine;
	m_CurrentPage = m_CurrentFileNo / m_PageFileNum;

	ReleaseDC(pDC);
}


#ifndef _WINVER_XP

void CFileView::RecalcPageDirectWrite(void)
{

//	CClientDC pDC = CClientDC(this);
	CDC* pDC = GetDC();

	CRect rect;
    GetClientRect(&rect);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
	CFont* pOldFont = pDC->SelectObject(&font);

	int fw, fh;
//	TEXTMETRIC tm;

//	pDC->GetTextMetrics(&tm);
//	fh = tm.tmHeight + m_pFmParam->m_nLineSpace;
//	fw = m_FontWidth = tm.tmAveCharWidth;
//	m_FontHeight = fh;

//	CString ss;
//	ss = "M";
//	CSize size = pDC->GetTextExtent(ss);
//	fh = size.cy + m_pFmParam->m_nLineSpace;
//	m_FontHeight = fh;

	fh = m_LineHeight;
	fw = m_FontWidth;



	CString s, s2, fname, fext, sSize, form;
	int max = m_pFmParam->m_FileNum;
	int cnt, dw, extw, tw, cmode, dt, maxtw, xlim;
	CSize csize;

	int sbh = m_ScrollBarHeight;

// #ifdef _DIRECT_WRITE

//	if (m_pFmParam->m_bSystemDirectWrite) {
		sbh = 0;
//	}

// #endif

	m_MaxLine = (rect.bottom - sbh - 2) / fh;	// ő\s

//	m_MaxLine = (rect.bottom - m_ScrollBarHeight - 2) / fh;	// ő\s
	maxtw = (rect.right - m_xOfset) / fw;	// ő\

	xlim = rect.right - FRAMEOFSET;
	cnt = 0;
	cmode = m_pFmParam->m_DisplayMode;
	dt = m_pFmParam->m_pFileParam[cmode].m_DisplayNameType;
	tw = 0;
	if ( dt == 0 ) tw = m_pFmParam->m_pFileParam[cmode].m_NameLen;	// w
	if ( dt == 1 ) tw = 8;	// DOS(8.3)
//	if ( dt == 2 ) tw = m_pFmParam->m_MaxFileNameLen;	// 

	if ( tw > maxtw ) tw = maxtw;
//	dw = fw * tw;	// 1̕\
	int nextw = m_pFmParam->m_pFileParam[cmode].m_ExtLen;
	if ( dt == 1 ) nextw = 4;	// DOS(8.3)
//	extw = fw * m_pFmParam->m_pFileParam[cmode].m_ExtLen;	// gq̕\
	extw = fw * nextw;	// gq̕\
	m_nExtWidthA = nextw;

	m_NameWidth = fw * tw;	// t@C̕\
	m_nNameWidthA = tw;

	m_ExtWidth = extw;	// gq̕\

//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize ) m_SizeWidth = fw * FILESIZEUNITWIDTH;	// t@CTCY̕\
//	else m_SizeWidth = fw * FILESIZEWIDTH;	// t@CTCY̕\

	int fsn = FILESIZEWIDTH;
	if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
		fsn = FILESIZEUNITWIDTH;
	}

	m_SizeWidth = fw * fsn;	// t@CTCY̕\
	m_nSizeWidthA = fsn;

//	m_SizeWidth = fw * FILESIZEWIDTH;	// t@CTCY̕\
//	m_nSizeWidthA = FILESIZEWIDTH;

//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowDate ) m_DateWidth += fw * 2;
	m_DateWidth = fw * FILEDATEWIDTH;	// t̕\
	if ( m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury ) m_DateWidth += fw * 2;

	m_nDateWidthA = FILEDATEWIDTH;
	if (m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury) m_nDateWidthA += 2;

//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury ) m_TimeWidth += fw * 2;
	m_TimeWidth = fw * FILETIMEWIDTH;	// Ԃ̕\
	m_nTimeWidthA = FILETIMEWIDTH;	// Ԃ̕\

//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowAtribute ) m_AttWidth += fw * 2;
	m_AttWidth = fw * FILEATTWIDTH;	// ̕\
	m_nAttWidthA = FILEATTWIDTH;	// ̕\

//	dw = m_NameWidth;
	dw = 0;
//	if ( m_pFmParam->m_pFileParam[cmode].m_bShowSplitExt ) dw += extw;
	dw += extw;
	if ( m_pFmParam->m_pFileParam[cmode].m_bShowSize ) dw += (m_SizeWidth + (fw * 2));
	if ( m_pFmParam->m_pFileParam[cmode].m_bShowDate ) dw += (m_DateWidth + (fw));
	if ( m_pFmParam->m_pFileParam[cmode].m_bShowTime ) dw += (m_TimeWidth + (fw));
	if ( m_pFmParam->m_pFileParam[cmode].m_bShowAtribute ) dw += (m_AttWidth + (fw));


	int dnw;
	if ( dt == 2 ) {
		dnw = rect.right - (FRAMEOFSET * 2) - m_xOfset - (fw * 2) - dw;
//		dnw = xlim - m_xOfset - dw;
//		if ( m_pFmParam->m_pFileParam[cmode].m_bShowSplitExt ) dw += extw;
		tw = m_pFmParam->m_MaxFileNameLen * fw;
		if ( tw < dnw ) dnw = tw;

		if ((dnw / fw) < 9) dnw = fw * 8;

		m_NameWidth = dnw;	// t@C̕\

		m_nNameWidthA = dnw / fw;	// t@C̕\

		dw += dnw;
	} else dw += m_NameWidth;

	m_ColumnWidth =  dw + m_xOfset;	// 1̕\

	m_MaxColumn = (rect.right - ((FRAMEOFSET + fw) * 2)) / m_ColumnWidth;
	if ( m_MaxColumn == 0 ) m_MaxColumn = 1;

	if ( m_pFmParam->m_pFileParam[cmode].m_bShowOverPart ) {
//		int nmc = m_MaxColumn;
//		m_MaxColumn = (rect.right - (FRAMEOFSET * 2) - m_xOfset - (fw * 2)) / (dw + m_xOfset) + 1;
//		if ( m_MaxColumn > nmc ) {
//		}
	}
	m_PageFileNum = m_MaxLine * m_MaxColumn;
	if ( m_PageFileNum == 0 ) m_PageFileNum = m_MaxLine;
	m_CurrentPage = m_CurrentFileNo / m_PageFileNum;

	ReleaseDC(pDC);
}

#endif





// CFileView `



void CFileView::OnDraw(CDC* pDC)
{

// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		OnDrawDirectWrite();
#endif

		return;
	}

// #endif

	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB

	CString wTitle;
	wTitle = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if (m_pFmParam->m_bSettingsShortTitle) {
		int len = wTitle.GetLength();
		CString st = wTitle.Left(len - 1);
		int n = st.ReverseFind(_T('\\'));
		if (n > 1) {
			wTitle = st.Right(len - n - 2);
		}
	}

	wTitle += _T(" - annsFM");
	BOOL b = IsUserAnAdmin();
	if (b) {
		wTitle += _T("(Admin)");
	}
	m_pChildView->m_pMainFrame->SetWindowTextW(wTitle);

	CBrush brush(m_pFmParam->m_colBack);
	CBrush* pOldBrush = pDC->SelectObject(&brush);

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colFrame);
	CPen* pOldPen = pDC->SelectObject(&pen);

	CRect rect;
	GetClientRect(&rect);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
	CFont* pOldFont = pDC->SelectObject(&font);

	int fw, fh;
	TEXTMETRIC tm;

	pDC->GetTextMetrics(&tm);
	m_FontHeight = tm.tmHeight;
	fw = m_FontWidth = tm.tmAveCharWidth;
	m_LineHeight = m_FontHeight + m_pFmParam->m_nLineSpace;
	fh = m_LineHeight;

	CString s, s2, fname, fext, sSize, form;
	int max = m_pFmParam->m_FileNum;
	int i, at, x, y;
	__int64 fsize;
	CSize csize;

	COLORREF col;
	CRect crc;

	RecalcPage();

	x = 0;
	y = 0;

	CString sNVDA = _T("");

	if (max == 0) {
		CString ns = _T("t@C܂");
		col = m_pFmParam->m_colListNormal;
		pDC->SetTextColor(m_pFmParam->m_colBack);
		pDC->SetBkColor(col);

		pDC->TextOutW(m_xOfset, m_yOfset, ns);
		sNVDA = ns;
		if (m_pFmParam->m_nVoiceGuide != 0) {
			m_pFmParam->VoiceGuideOut(sNVDA);
		}
	}

	int cmode = m_pFmParam->m_DisplayMode;
	int xlim = rect.right - FRAMEOFSET;
	int cnt = 0;
	int xp, yp;
	int start, end;
	start = m_CurrentPage * m_PageFileNum;
	end = start + m_PageFileNum;

	if (m_pFmParam->m_pFileParam[cmode].m_bShowOverPart) {
		end += m_MaxLine;
	}

	if (end > m_pFmParam->m_FileNum) end = m_pFmParam->m_FileNum;

	for (i = start; i < end; i++) {
		if (max == 0) break;

		at = m_pFmParam->m_pw64FindData[i].attrib;

		col = m_pFmParam->m_colListNormal;
		if ((at & _A_SUBDIR) != 0) col = m_pFmParam->m_colListDir;
		if ((at & _A_RDONLY) != 0) col = m_pFmParam->m_colListReadonly;
		if ((at & _A_HIDDEN) != 0) col = m_pFmParam->m_colListHide;
		if ((at & _A_SYSTEM) != 0) col = m_pFmParam->m_colListSystem;

		s = m_pFmParam->m_pw64FindData[i].name;
		sNVDA = s;

		bool dir = false;
		if ((at & _A_SUBDIR) != 0) dir = true;
		AdjustFileName(s, dir);

		pDC->SetTextColor(col);
		pDC->SetBkColor(m_pFmParam->m_colBack);
		if (cnt >= m_MaxLine) {
			x = ((i - start) / m_MaxLine) * (m_ColumnWidth + m_xOfset);
			y = 0;
			cnt = 0;
		}
		xp = m_xOfset + x;
		yp = fh * y + m_yOfset;
		int plast = xp;
		if (i == m_CurrentFileNo) {
			CBrush cbr(col);
			crc.top = yp;
			crc.left = xp;
			crc.right = xp + m_ColumnWidth - m_xOfset;
			crc.bottom = yp + fh;
			if (crc.left < xlim) {
				if (crc.right > xlim) crc.right = xlim;
			}
			pDC->FillRect(&crc, &cbr);
			pDC->SetTextColor(m_pFmParam->m_colBack);
			pDC->SetBkColor(col);

		}
		s2 = m_pFmParam->m_sName;

// #ifndef _DIRECT_WRITE

		CString s3, s4;
		if (!(m_pFmParam->m_bSystemDirectWrite)) {
			s3 = "&";
			s4 = "&&";
			s2.Replace(s3, s4);
		}

// #endif

		csize = pDC->GetTextExtent(s2);
		crc.top = yp;
		crc.left = xp;
		crc.right = crc.left + csize.cx;
		crc.bottom = yp + csize.cy;
		if (crc.right > xlim) crc.right = xlim;
		pDC->DrawText(s2, &crc, DT_LEFT);

		s2 = m_pFmParam->m_sExt;

// #ifndef _DIRECT_WRITE

		if (!(m_pFmParam->m_bSystemDirectWrite)) {
			s2.Replace(s3, s4);
		}


// #endif
		csize = pDC->GetTextExtent(s2);
		crc.top = yp;
		crc.left = xp + m_NameWidth;
		crc.right = crc.left + csize.cx;
		crc.bottom = yp + csize.cy;
		if (crc.left < xlim) {
			if (crc.right > xlim) crc.right = xlim;
			pDC->DrawText(s2, &crc, DT_LEFT);
		}

		plast = xp + m_NameWidth + m_ExtWidth + (fw * 2);
		if (m_pFmParam->m_pFileParam[cmode].m_bShowSize) {
			if (dir) {
				if (m_pFmParam->m_pDirSize[i].Enable) {
					fsize = m_pFmParam->m_pDirSize[i].Size;
					CString sUnit;
					sUnit = "";
					if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) fsize = m_pFmParam->CalcFileSize(fsize, sUnit);
					form = "%I64d";
					s.Format(form, fsize);
					m_pFmParam->InsertComma(s);
					if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
						if (sUnit.GetLength() != 0) {
							form = "%8s%2s";
							sSize.Format(form, s, sUnit);
						}
						else {
							form = "%10s";
							sSize.Format(form, s);
						}
					}
					else {
						form = "%15s";
						sSize.Format(form, s);
					}

				}
				else {
					if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
						form = "%10s";
					}
					else {
						form = "%15s";

					}
					sSize.Format(form, m_pFmParam->m_sDirStr);
				}
			}
			else {
				fsize = m_pFmParam->m_pw64FindData[i].size;
				CString sUnit;
				sUnit = "";
				if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) fsize = m_pFmParam->CalcFileSize(fsize, sUnit);
				form = "%I64d";
				s.Format(form, fsize);
				m_pFmParam->InsertComma(s);
				if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
					if (sUnit.GetLength() != 0) {
						form = "%8s%2s";
						sSize.Format(form, s, sUnit);
					}
					else {
						form = "%10s";
						sSize.Format(form, s);
					}
				}
				else {
					form = "%15s";
					sSize.Format(form, s);
				}
			}
			s2 = sSize;

			csize = pDC->GetTextExtent(s2);
			crc.top = yp;
			crc.left = plast;
			crc.right = crc.left + csize.cx;
			crc.bottom = yp + csize.cy;
			if (crc.left < xlim) {
				if (crc.right > xlim) crc.right = xlim;
				pDC->DrawText(s2, &crc, DT_LEFT);
				sNVDA += s2;
				if (i == m_CurrentFileNo &&  m_pFmParam->m_nVoiceGuide != 0 && m_bVoiceInit) {
				}
			}
			plast = crc.right + (fw * 2);
		}

		CString sNVDA2 = _T("");
		int kd = m_pFmParam->m_pFileParam[cmode].m_KindDate;
		__time64_t time;

		if (kd == 0) time = m_pFmParam->m_pw64FindData[i].time_create;
		if (kd == 1) time = m_pFmParam->m_pw64FindData[i].time_write;
		if (kd == 2) time = m_pFmParam->m_pw64FindData[i].time_access;

		s2 = m_pFmParam->GetTimeStr(time);

		CString sDate, sTime;

		sDate = s2.Left(10);
		sTime = s2.Mid(12);

		if (!m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury) {
			s = sDate.Mid(2);
			sDate = s;
		}

		s2 = _T("");
		if (m_pFmParam->m_pFileParam[cmode].m_bShowDate) {
			s2 = sDate;
		}

		if (m_pFmParam->m_pFileParam[cmode].m_bShowTime) {
			if (m_pFmParam->m_pFileParam[cmode].m_bShowDate) s2 += _T("  ");
			s.Format(_T("%s"), sTime);
			s2 += s;
		}

		csize = pDC->GetTextExtent(s2);
		crc.top = yp;
		crc.left = plast;
		crc.right = crc.left + csize.cx;
		crc.bottom = yp + csize.cy;
		if (crc.left < xlim) {
			if (crc.right > xlim) crc.right = xlim;
			if (m_pFmParam->m_pFileParam[cmode].m_bShowDate || m_pFmParam->m_pFileParam[cmode].m_bShowTime) {
				pDC->DrawText(s2, &crc, DT_LEFT);
				plast = crc.right + (fw * 2);
				sNVDA2 += s2;
			}
		}

		if (m_pFmParam->m_pFileParam[cmode].m_bShowAtribute) {

			s = _T("");
			int at = m_pFmParam->m_pw64FindData[i].attrib;

			if ((at & _A_RDONLY) != 0) s += _T("R ");
			else s += _T("- ");
			if ((at & _A_HIDDEN) != 0) s += _T("H ");
			else s += _T("- ");
			if ((at & _A_SYSTEM) != 0) s += _T("S ");
			else s += _T("- ");
			if ((at & _A_ARCH) != 0) s += _T("A ");
			else s += _T("- ");
			if ((at & _A_SUBDIR) != 0) s += _T("D");
			else s += _T("-");


			csize = pDC->GetTextExtent(s);
			crc.top = yp;
			crc.left = plast;
			crc.right = crc.left + csize.cx;
			crc.bottom = yp + csize.cy;
			if (crc.left < xlim) {
				if (crc.right > xlim) crc.right = xlim;
				pDC->DrawText(s, &crc, DT_LEFT);
				sNVDA2 += s;
			}
		}

		DrawMark(m_pFmParam->m_pMark[i], i);


		if (i == m_CurrentFileNo &&  m_pFmParam->m_nVoiceGuide != 0 && m_bVoiceInit) {
			if (m_pFmParam->m_pMark[i]) {
				CString sm = _T("}[N");
				m_pFmParam->VoiceGuideOut(sm);
			}
			m_pFmParam->VoiceGuideOut(sNVDA);
			if (sNVDA2 != _T("")) m_pFmParam->VoiceGuideOut(sNVDA2);
			m_bVoiceInit = false;
		}

		y++;
		cnt++;
	}

	pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);

	pDC->SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = (m_pFmParam->m_FileNum - 1) / m_PageFileNum;
	if (maxpage > 0) SetScrollPos(m_CurrentPage);

	RedrawInfo();

}


// bPart true : Jgʒûݕ`
// bCursor true : J[\ON

#ifndef _WINVER_XP

void CFileView::OnDrawDirectWrite(bool bPart, bool bCursor)
{
	CDC* pDC = GetDC();

	CreateTextFormat();
	CreateDeviceResources();

	if (!g_pRenderTarget) return;

 
//	MessageBox(m_sDebugString);

	CString wTitle;
	wTitle = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if (m_pFmParam->m_bSettingsShortTitle) {
		int len = wTitle.GetLength();
		CString st = wTitle.Left(len - 1);
		int n = st.ReverseFind(_T('\\'));
		if (n > 1) {
			wTitle = st.Right(len - n - 2);
		}
	}

	wTitle += _T(" - annsFM");
	BOOL b = IsUserAnAdmin();
	if (b) {
		wTitle += _T("(Admin)");
	}
	m_pChildView->m_pMainFrame->SetWindowTextW(wTitle);

    CRect rect;
    GetClientRect(&rect);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
	CFont* pOldFont = pDC->SelectObject(&font);

	int fw, fh;

	fw = m_FontWidth;
	fh = m_LineHeight;


	CString s, s2, fname, fext, sSize, form;
	int max = m_pFmParam->m_FileNum;
	int i, at, x, y;
	__int64 fsize;
	CSize csize;

	CRect crc;

	RecalcPageDirectWrite();

	x = 0;
	y = 0;

	CString sNVDA = _T("");


	g_pRenderTarget->BeginDraw();

	if (!bPart) {
		g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolBack));
	}

	
	D2D1_RECT_F d2d1Rect;
	d2d1Rect.top = (FLOAT)rect.top;
	d2d1Rect.bottom = (FLOAT)rect.bottom;
	d2d1Rect.left = (FLOAT)rect.left;
	d2d1Rect.right = (FLOAT)rect.right;

	g_pRenderTarget->DrawRectangle(&d2d1Rect, g_pFrameBrush, 2.0F);

	if ( max == 0 ) {
		CString ns = _T("t@C܂");

			d2d1DrawTextW(m_xOfset, m_yOfset, ns, g_pListNormalBrush, g_pBackBrush);

			sNVDA = ns;
		if ( m_pFmParam->m_nVoiceGuide != 0 ) {
			m_pFmParam->VoiceGuideOut(sNVDA);
		}
	}

	int cmode = m_pFmParam->m_DisplayMode;
	int xlim = rect.right - FRAMEOFSET;
	int cnt = 0;
	int xp, yp;
	int start, end;
	start = m_CurrentPage * m_PageFileNum;
	end = start + m_PageFileNum;

	if ( m_pFmParam->m_pFileParam[cmode].m_bShowOverPart ) {
		end += m_MaxLine;
	}

	if ( end > m_pFmParam->m_FileNum ) end = m_pFmParam->m_FileNum;

	for (i = start; i < end; i++) {
		if (max == 0) break;

		if (cnt >= m_MaxLine) {
			x = ((i - start) / m_MaxLine) * (m_ColumnWidth + m_xOfset);
			y = 0;
			cnt = 0;
		}

		if (bPart) {
			if (i != m_CurrentFileNo) {
				y++;
				cnt++;
				continue;
			}
		}

		xp = m_xOfset + x;
		yp = fh * y + m_yOfset;

		ID2D1SolidColorBrush *pListBrush;

		at = m_pFmParam->m_pw64FindData[i].attrib;

		pListBrush = g_pListNormalBrush;
		if ((at & _A_SUBDIR) != 0) pListBrush = g_pListDirBrush;
		if ((at & _A_RDONLY) != 0) pListBrush = g_pListReadonlyBrush;
		if ((at & _A_HIDDEN) != 0) pListBrush = g_pListHideBrush;
		if ((at & _A_SYSTEM) != 0) pListBrush = g_pListSystemBrush;

		s = m_pFmParam->m_pw64FindData[i].name;
		sNVDA = s;

		bool dir = false;
		if ((at & _A_SUBDIR) != 0) dir = true;

		AdjustFileNameDirectWrite(s, dir);

		CString sLine;

		s2 = m_pFmParam->m_sName;

		sLine = s2;

		s2 = m_pFmParam->m_sExt;

		sLine += s2;

		sLine += _T(" ");



		if (m_pFmParam->m_pFileParam[cmode].m_bShowSize) {
			if (dir) {
				if (m_pFmParam->m_pDirSize[i].Enable) {
					fsize = m_pFmParam->m_pDirSize[i].Size;
					CString sUnit;
					sUnit = "";
					if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) fsize = m_pFmParam->CalcFileSize(fsize, sUnit);
					form = "%I64d";
					s.Format(form, fsize);
					m_pFmParam->InsertComma(s);
					if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
						if (sUnit.GetLength() != 0) {
							form = "%8s%2s";
							sSize.Format(form, s, sUnit);
						}
						else {
							form = "%10s";
							sSize.Format(form, s);
						}
					}
					else {
						form = "%15s";
						sSize.Format(form, s);
					}

				}
				else {
					if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
						form = "%10s";
					}
					else {
						form = "%15s";

					}
					sSize.Format(form, m_pFmParam->m_sDirStr);
				}
			}
			else {
				fsize = m_pFmParam->m_pw64FindData[i].size;
				CString sUnit;
				sUnit = "";
				if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) fsize = m_pFmParam->CalcFileSize(fsize, sUnit);
				form = "%I64d";
				s.Format(form, fsize);
				m_pFmParam->InsertComma(s);
				if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
					if (sUnit.GetLength() != 0) {
						form = "%8s%2s";
						sSize.Format(form, s, sUnit);
					}
					else {
						form = "%10s";
						sSize.Format(form, s);
					}
				}
				else {
					form = "%15s";
					sSize.Format(form, s);
				}
			}
			//			s2 = sSize;

			sLine += _T(" ");
			sLine += sSize;


			sNVDA += _T(" ");
//			sNVDA += s2;
			sNVDA += sSize;

		}

		CString sNVDA2 = _T("");
		int kd = m_pFmParam->m_pFileParam[cmode].m_KindDate;
		__time64_t time;

		if (kd == 0) time = m_pFmParam->m_pw64FindData[i].time_create;
		if (kd == 1) time = m_pFmParam->m_pw64FindData[i].time_write;
		if (kd == 2) time = m_pFmParam->m_pw64FindData[i].time_access;

		s2 = m_pFmParam->GetTimeStr(time);

		CString sDate, sTime;

		sDate = s2.Left(10);
		sTime = s2.Mid(12);

		if (!m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury) {
			s = sDate.Mid(2);
			sDate = s;
		}

		s2 = _T("");
		if (m_pFmParam->m_pFileParam[cmode].m_bShowDate) {
			s2 = sDate;
		}

		if (m_pFmParam->m_pFileParam[cmode].m_bShowTime) {
			if (m_pFmParam->m_pFileParam[cmode].m_bShowDate) s2 += _T(" ");
			s.Format(_T("%s"), sTime);
			s2 += s;
		}


		if (m_pFmParam->m_pFileParam[cmode].m_bShowDate || m_pFmParam->m_pFileParam[cmode].m_bShowTime) {
			sLine += _T(" ");
			sLine += s2;

			sNVDA += _T(" ");
			sNVDA2 += s2;
		}


		if (m_pFmParam->m_pFileParam[cmode].m_bShowAtribute) {


			s = _T("");
			int at = m_pFmParam->m_pw64FindData[i].attrib;

			if ((at & _A_RDONLY) != 0) s += _T("R ");
			else s += _T("- ");
			if ((at & _A_HIDDEN) != 0) s += _T("H ");
			else s += _T("- ");
			if ((at & _A_SYSTEM) != 0) s += _T("S ");
			else s += _T("- ");
			if ((at & _A_ARCH) != 0) s += _T("A ");
			else s += _T("- ");
			if ((at & _A_SUBDIR) != 0) s += _T("D");
			else s += _T("-");


			sLine += _T(" ");
			sLine += s;

			sNVDA += _T(" ");
			sNVDA2 += s;


		}

		if (m_pFmParam->m_bListMarkAst) {
			if (m_pFmParam->m_pMark[i]) {
				int xm = xp - fw - (fw / 2);
				d2d1DrawTextW(xm, yp, _T("*"), pListBrush, g_pBackBrush);
			}
		}

		if (bPart) {
			if (bCursor) {
				d2d1DrawTextW(xp, yp, sLine, g_pBackBrush, pListBrush);
			}
			else {
				d2d1DrawTextW(xp, yp, sLine, pListBrush, g_pBackBrush);
			}
		}
		else {
			if (i == m_CurrentFileNo) {
				d2d1DrawTextW(xp, yp, sLine, g_pBackBrush, pListBrush);

			}
			else {
				d2d1DrawTextW(xp, yp, sLine, pListBrush, g_pBackBrush);

			}
		}

		if (m_pFmParam->m_bListMarkAst) {
			if (m_pFmParam->m_pMark[i]) {
//				d2d1DrawTextW(xp - (m_xOfset + x), yp, _T("*"), pListBrush, g_pBackBrush);
			}
		}
		else {
			d2d1DrawMark(m_pFmParam->m_pMark[i], i);
		}


		if ( i == m_CurrentFileNo &&  m_pFmParam->m_nVoiceGuide != 0 && m_bVoiceInit ) {
			if ( m_pFmParam->m_pMark[i] ) {
				CString sm = _T("}[N");
				m_pFmParam->VoiceGuideOut(sm);
			}
			m_pFmParam->VoiceGuideOut(sNVDA);
			if ( sNVDA2 != _T("") ) m_pFmParam->VoiceGuideOut(sNVDA2);
			m_bVoiceInit = false;
		}

		y++;
		cnt++;
	}



	g_pRenderTarget->EndDraw();

	pDC->SelectObject(pOldFont);

	SetScrollData();
	int maxpage;
	maxpage = (m_pFmParam->m_FileNum - 1) / m_PageFileNum;
	if ( maxpage > 0 ) SetScrollPos(m_CurrentPage);

	RedrawInfo();


}
#endif


void CFileView::AdjustFileName(CString name, bool dir)
{
// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		AdjustFileNameDirectWrite(name, dir);
#endif

		return;
	}

// #endif


	CClientDC dc(this);
	CString s, sn, se;
	CSize cs;
	bool b;

	int len;
	int cmode = m_pFmParam->m_DisplayMode;
	int dw = m_NameWidth;
	int extw = m_ExtWidth;

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
	CFont* pOldFont = dc.SelectObject(&font);

	if (m_pFmParam->m_pFileParam[cmode].m_bShowSplitExt && !dir) {
		m_pFmParam->DivideFileName(name);
		sn = m_pFmParam->m_sName;
		bool bEmpty = false;
		if (sn == _T("")) {
			sn = m_pFmParam->m_sExt;
			m_pFmParam->m_sName = sn;
			bEmpty = true;
		}
		cs = dc.GetTextExtent(sn);
		b = false;
		while (cs.cx > dw) {	// t@C\𒴂Ă
			b = true;
			len = sn.GetLength() - 1;
			if (len < 5) break;
			s = sn.Left(len);
			sn = s;
			cs = dc.GetTextExtent(sn);
		}
		if (b) {
			len = sn.GetLength() - 1;
			s = sn.Left(len);
			s += _T("~");
			m_pFmParam->m_sName = s;
		}

		se = m_pFmParam->m_sExt;
		if (bEmpty) {
			se = _T("");
			m_pFmParam->m_sExt = se;
		}
		cs = dc.GetTextExtent(se);
		b = false;
		while (cs.cx > extw) {	// gq\𒴂Ă
			b = true;
			len = se.GetLength() - 1;
			if (len < 5) break;
			s = se.Left(len);
			se = s;
			cs = dc.GetTextExtent(se);
		}
		if (b) {
			len = se.GetLength() - 1;
			s = se.Left(len);
			s += _T("~");
			m_pFmParam->m_sExt = s;
		}
	}
	else {
		dw += extw;
		sn = name;
		cs = dc.GetTextExtent(sn);
		b = false;
		while (cs.cx > dw) {	// t@C\𒴂Ă
			b = true;
			len = sn.GetLength() - 1;
			if (len < 5) break;
			s = sn.Left(len);
			sn = s;
			cs = dc.GetTextExtent(sn);
		}
		m_pFmParam->m_sName = name;
		m_pFmParam->m_sExt = _T("");
		if (b) {
			len = sn.GetLength() - 1;
			s = sn.Left(len);
			s += _T("~");
			m_pFmParam->m_sName = s;
		}
	}
	dc.SelectObject(pOldFont);
}

#ifndef _WINVER_XP

void CFileView::AdjustFileNameDirectWrite(CString name, bool dir)
{
	CString s, sn, se;
	int cmode = m_pFmParam->m_DisplayMode;

	if (m_pFmParam->m_pFileParam[cmode].m_bShowSplitExt && !dir) {
		m_pFmParam->DivideFileName(name);
		sn = m_pFmParam->m_sName;
		bool bEmpty = false;
		if (sn == _T("")) {
			sn = m_pFmParam->m_sExt;
			m_pFmParam->m_sName = sn;
			bEmpty = true;
		}

		m_pFmParam->m_sName = m_pFmParam->GetFixedLengthWstr(sn, m_nNameWidthA, true, true);

		se = m_pFmParam->m_sExt;
		if (bEmpty) {
			se = _T("");
			m_pFmParam->m_sExt = se;
		}

		m_pFmParam->m_sExt = m_pFmParam->GetFixedLengthWstr(se, m_nExtWidthA, true, true);


	}
	else {

		m_pFmParam->m_sName = m_pFmParam->GetFixedLengthWstr(name, m_nNameWidthA + m_nExtWidthA, true, true);
		m_pFmParam->m_sExt = _T("");


	}
}


void CFileView::d2d1DrawMark(bool on, int cpos)
{
	if (!on) return;

	if (cpos == -1) cpos = m_CurrentFileNo;

	CRect rect;
	GetClientRect(&rect);

	ID2D1SolidColorBrush *pMarkBrush;

	int at = m_pFmParam->m_pw64FindData[cpos].attrib;

	pMarkBrush = g_pListNormalBrush;
	if ((at & _A_SUBDIR) != 0) pMarkBrush = g_pListDirBrush;
	if ((at & _A_RDONLY) != 0) pMarkBrush = g_pListReadonlyBrush;
	if ((at & _A_HIDDEN) != 0) pMarkBrush = g_pListHideBrush;
	if ((at & _A_SYSTEM) != 0) pMarkBrush = g_pListSystemBrush;

	int x = 0;
	int y = 0;

	int dw = m_ColumnWidth;
	int pageof, pos, filenum;
	filenum = m_MaxLine * m_MaxColumn;
	pageof = m_CurrentPage * filenum;
	pos = cpos - pageof;

	if (cpos != 0) {
		x = (pos / m_MaxLine) * (dw + m_xOfset);
		//		x = (pos / m_MaxLine) * (dw);
		y = pos % m_MaxLine;
	}

	int xp = x + MARKOFSET;
	int yp = m_LineHeight * y + m_yOfset;

	//	g_pRenderTarget->FillRectangle(D2D1::RectF((FLOAT)xp, (FLOAT)yp, (FLOAT)(xp + m_FontWidth), (FLOAT)(yp + m_FontHeight)), g_pBackBrush);

	if (on) {

		ID2D1PathGeometry *pTabGeometry;

		POINT pt[9];

		int pf1 = yp + (m_LineHeight / 4) + 1;
		pt[0].x = xp;
		pt[0].y = pf1;

		int pf2 = xp + (MARKX / 3);
		pt[1].x = pf2;
		pt[1].y = pf1;

		pt[2].x = pf2;
		pt[2].y = yp + 2;

		pt[3].x = xp + MARKX - 1;
		pt[3].y = yp + m_LineHeight / 2;

		pt[4].x = pf2;
		pt[4].y = yp + m_LineHeight - 2;

		pt[5].x = pf2;
		pt[5].y = yp + (m_LineHeight * 3 / 4) - 1;

		int pf3 = yp + (m_LineHeight * 3 / 4) - 1;
		pt[6].x = xp;
		pt[6].y = pf3;


		pt[7].x = xp;
		pt[7].y = pf1;

		pt[8].x = pf2 + 1;
		pt[8].y = yp + (m_LineHeight * 3 / 4) - 1;



		HRESULT hr = g_pD2DFactory->CreatePathGeometry(&pTabGeometry);
		if (SUCCEEDED(hr))
		{
			ID2D1GeometrySink *pSink = NULL;

			hr = pTabGeometry->Open(&pSink);
			if (SUCCEEDED(hr))
			{
				pSink->SetFillMode(D2D1_FILL_MODE_WINDING);

				pSink->BeginFigure(
					D2D1::Point2F((FLOAT)pt[0].x, (FLOAT)pt[0].y),
					D2D1_FIGURE_BEGIN_FILLED
					);
				D2D1_POINT_2F points[] = {
					D2D1::Point2F((FLOAT)pt[1].x, (FLOAT)pt[1].y),
					D2D1::Point2F((FLOAT)pt[2].x, (FLOAT)pt[2].y),
					D2D1::Point2F((FLOAT)pt[3].x, (FLOAT)pt[3].y),
					D2D1::Point2F((FLOAT)pt[4].x, (FLOAT)pt[4].y),
					D2D1::Point2F((FLOAT)pt[5].x, (FLOAT)pt[5].y),
					D2D1::Point2F((FLOAT)pt[6].x, (FLOAT)pt[6].y),
					D2D1::Point2F((FLOAT)pt[7].x, (FLOAT)pt[7].y),
					D2D1::Point2F((FLOAT)pt[8].x, (FLOAT)pt[8].y),
					//					D2D1::Point2F((FLOAT)pt[9].x, (FLOAT)pt[9].y),
				};
				pSink->AddLines(points, ARRAYSIZE(points));
				pSink->EndFigure(D2D1_FIGURE_END_CLOSED);
			}
			hr = pSink->Close();

			SafeRelease(&pSink);
		}

		g_pRenderTarget->FillGeometry(pTabGeometry, pMarkBrush);

		//		g_pRenderTarget->DrawGeometry(m_pTabGeometry, pcBrush, 1.f);



	}


}
#endif

int CFileView::DrawCursor(bool on, int cpos)
{
// #ifdef _DIRECT_WRITE

//	OnDrawDirectWrite(true, on);
	if (m_pFmParam->m_bSystemDirectWrite) {
		if (on) {
			Invalidate();
		}
		return 0;
	}

// #endif


	if (m_pFmParam->m_FileNum == 0) return 0;
	//	CClientDC dc = CClientDC(this);
	CDC* dc = GetDC();

	if (cpos == -1) cpos = m_CurrentFileNo;
	RecalcPage();

	CString sNVDA = _T("");

	CRect rect;
	GetClientRect(&rect);

	CBrush brush(m_pFmParam->m_colBack);
	CBrush* pOldBrush = dc->SelectObject(&brush);
	CBrush cbr;

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colFrame);
	CPen* pOldPen = dc->SelectObject(&pen);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
	CFont* pOldFont = dc->SelectObject(&font);

	CString s, s2, form, sSize;
	int max = m_pFmParam->m_FileNum;
	int at, x, y, dw, tw, cmode, xlim;
	__int64 fsize;
	CSize csize;

	xlim = rect.right - FRAMEOFSET;
	COLORREF col;

	x = 0;
	y = 0;

	cmode = m_pFmParam->m_DisplayMode;
	dw = m_ColumnWidth;
	tw = m_ColumnWidth / m_FontWidth;
	int extw = m_ExtWidth;	// gq̕\
	CRect crc;
	int xp, yp, pageof, pos, filenum;
	//	filenum = m_MaxLine * m_MaxColumn;
	filenum = m_PageFileNum;
	pageof = m_CurrentPage * filenum;
	pos = cpos - pageof;

	at = m_pFmParam->m_pw64FindData[cpos].attrib;

	col = m_pFmParam->m_colListNormal;
	if ((at & _A_SUBDIR) != 0) col = m_pFmParam->m_colListDir;
	if ((at & _A_RDONLY) != 0) col = m_pFmParam->m_colListReadonly;
	if ((at & _A_HIDDEN) != 0) col = m_pFmParam->m_colListHide;
	if ((at & _A_SYSTEM) != 0) col = m_pFmParam->m_colListSystem;

	s = m_pFmParam->m_pw64FindData[cpos].name;

	sNVDA = s;



	//	fname = s;

	if (cpos != 0) {
		x = (pos / m_MaxLine) * (dw + m_xOfset);
		y = pos % m_MaxLine;
	}
	xp = m_xOfset + x;
	yp = m_LineHeight * y + m_yOfset;
	if (on) {
		cbr.CreateSolidBrush(col);
		dc->SetTextColor(m_pFmParam->m_colBack);
		dc->SetBkColor(col);
	}
	else {
		cbr.CreateSolidBrush(m_pFmParam->m_colBack);
		dc->SetTextColor(col);
		dc->SetBkColor(m_pFmParam->m_colBack);
	}
	crc.top = yp;
	crc.left = xp;
	crc.right = xp + dw - m_xOfset;
	crc.bottom = yp + m_LineHeight;
	if (crc.right > xlim) crc.right = xlim;
	dc->FillRect(&crc, &cbr);
	//	dc.SetBkColor(col);

	int fw = m_FontWidth;
	int plast = xp;
	bool dir = false;
	if ((at & _A_SUBDIR) != 0) dir = true;
	AdjustFileName(s, dir);
	s2 = m_pFmParam->m_sName;

// #ifndef _DIRECT_WRITE

	CString s3, s4;
	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		s3 = "&";
		s4 = "&&";
		s2.Replace(s3, s4);
	}

// #endif

	csize = dc->GetTextExtent(s2);
	crc.top = yp;
	crc.left = xp;
	crc.right = crc.left + csize.cx;
	crc.bottom = yp + csize.cy;
	if (crc.left < xlim) {
		if (crc.right > xlim) crc.right = xlim;
		dc->DrawText(s2, &crc, DT_LEFT);
		//		sNVDA += s2;
	}
	//	dc.TextOut(xp, yp, s2);

	s2 = m_pFmParam->m_sExt;

// #ifndef _DIRECT_WRITE

	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		s2.Replace(s3, s4);
	}

// #endif

	csize = dc->GetTextExtent(s2);
	crc.top = yp;
	crc.left = xp + m_NameWidth;
	crc.right = crc.left + csize.cx;
	crc.bottom = yp + csize.cy;
	if (crc.left < xlim) {
		if (crc.right > xlim) crc.right = xlim;
		dc->DrawText(s2, &crc, DT_LEFT);
		//			sNVDA += s2;
	}

	//	dc.TextOut(xp + m_NameWidth, yp, m_pFmParam->m_sExt);
	plast = xp + m_NameWidth + m_ExtWidth + (fw * 2);
	if (m_pFmParam->m_pFileParam[cmode].m_bShowSize) {
		if (dir) {
			if (m_pFmParam->m_pDirSize[cpos].Enable) {
				fsize = m_pFmParam->m_pDirSize[cpos].Size;
				CString sUnit;
				sUnit = "";
				if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) fsize = m_pFmParam->CalcFileSize(fsize, sUnit);
				form = "%I64d";
				s.Format(form, fsize);
				m_pFmParam->InsertComma(s);
				if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
					if (sUnit.GetLength() != 0) {
						form = "%8s%2s";
						sSize.Format(form, s, sUnit);
					}
					else {
						form = "%10s";
						sSize.Format(form, s);
					}
				}
				else {
					form = "%15s";
					sSize.Format(form, s);
				}

			}
			else {
				if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
					form = "%10s";
				}
				else {
					form = "%15s";

				}
				sSize.Format(form, m_pFmParam->m_sDirStr);
			}
		}
		else {
			fsize = m_pFmParam->m_pw64FindData[cpos].size;
			CString sUnit;
			sUnit = "";
			if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) fsize = m_pFmParam->CalcFileSize(fsize, sUnit);
			form = "%I64d";
			s.Format(form, fsize);
			m_pFmParam->InsertComma(s);
			if (m_pFmParam->m_pFileParam[cmode].m_bShowUnitSize) {
				if (sUnit.GetLength() != 0) {
					form = "%8s%2s";
					sSize.Format(form, s, sUnit);
				}
				else {
					form = "%10s";
					sSize.Format(form, s);
				}
			}
			else {
				form = "%15s";
				sSize.Format(form, s);
			}
		}
		s2 = sSize;
		csize = dc->GetTextExtent(s2);
		crc.top = yp;
		crc.left = xp + m_NameWidth + m_ExtWidth + (m_FontWidth * 2);
		crc.right = crc.left + csize.cx;
		crc.bottom = yp + csize.cy;
		if (crc.left < xlim) {
			if (crc.right > xlim) crc.right = xlim;
			dc->DrawText(s2, &crc, DT_LEFT);
			sNVDA += s2;
			if (on && m_pFmParam->m_nVoiceGuide != 0 && m_bVoiceInit) {
				//				m_pFmParam->VoiceGuideOut(sNVDA);
				//				sNVDA = _T("");
			}
		}
		plast = crc.right + (fw * 2);
	}

	CString sNVDA2 = _T("");
	int kd = m_pFmParam->m_pFileParam[cmode].m_KindDate;
	__time64_t time;

	if (kd == 0) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_create;
	if (kd == 1) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_write;
	if (kd == 2) time = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_access;

	s2 = m_pFmParam->GetTimeStr(time);

	CString sDate, sTime;

	sDate = s2.Left(10);
	sTime = s2.Mid(12);

	if (!m_pFmParam->m_pFileParam[cmode].m_bShowFullCentury) {
		s = sDate.Mid(2);
		sDate = s;
	}

	s2 = _T("");
	if (m_pFmParam->m_pFileParam[cmode].m_bShowDate) {
		s2 = sDate;
	}

	if (m_pFmParam->m_pFileParam[cmode].m_bShowTime) {
		if (m_pFmParam->m_pFileParam[cmode].m_bShowDate) s2 += _T("  ");
		s.Format(_T("%s"), sTime);
		s2 += s;
	}

	csize = dc->GetTextExtent(s2);
	crc.top = yp;
	crc.left = plast;
	crc.right = crc.left + csize.cx;
	crc.bottom = yp + csize.cy;
	if (crc.left < xlim) {
		if (crc.right > xlim) crc.right = xlim;
		if (m_pFmParam->m_pFileParam[cmode].m_bShowDate || m_pFmParam->m_pFileParam[cmode].m_bShowTime) {
			dc->DrawText(s2, &crc, DT_LEFT);
			plast = crc.right + (fw * 2);
			sNVDA2 += s2;
		}
	}

	if (m_pFmParam->m_pFileParam[cmode].m_bShowAtribute) {
		s = _T("");

		int at = m_pFmParam->m_pw64FindData[cpos].attrib;

		if ((at & _A_RDONLY) != 0) s += _T("R ");
		else s += _T("- ");
		if ((at & _A_HIDDEN) != 0) s += _T("H ");
		else s += _T("- ");
		if ((at & _A_SYSTEM) != 0) s += _T("S ");
		else s += _T("- ");
		if ((at & _A_ARCH) != 0) s += _T("A ");
		else s += _T("- ");
		if ((at & _A_SUBDIR) != 0) s += _T("D");
		else s += _T("-");


		csize = dc->GetTextExtent(s);
		crc.top = yp;
		crc.left = plast;
		crc.right = crc.left + csize.cx;
		crc.bottom = yp + csize.cy;
		if (crc.left < xlim) {
			if (crc.right > xlim) crc.right = xlim;
			dc->DrawText(s, &crc, DT_LEFT);
			sNVDA2 += s;
		}
	}

	dc->SelectObject(pOldBrush);
	dc->SelectObject(pOldPen);

	dc->SelectObject(pOldFont);

	//	if ( m_pFmParam->m_bToolUseNVDA && on && m_bNVDAInit && m_pFmParam->m_bEnableNVDA ) {
	//		m_pFmParam->m_pnvdaController_speakText(sNVDA);
	if (on && m_pFmParam->m_nVoiceGuide != 0 && m_bVoiceInit) {
		if (m_pFmParam->m_pMark[cpos]) {
			CString sm = _T("}[N");
			m_pFmParam->VoiceGuideOut(sm);
		}
		m_pFmParam->VoiceGuideOut(sNVDA);
		if (sNVDA2 != _T("")) m_pFmParam->VoiceGuideOut(sNVDA2);
		m_bVoiceInit = false;
	}
	ReleaseDC(dc);

	return 0;
}


// CFileView bZ[W nh


// bZ[W nh ==================================

BOOL CFileView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

// #ifndef _DIRECT_WRITE

	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		CBrush brush(m_pFmParam->m_colBack);
		// VuVw(̃uV̕ۑ)
		CBrush* pOldBrush = pDC->SelectObject(&brush);

		// hԂ̈擾
		CRect rect;
		//    pDC->GetClipBox(&rect);
		GetClientRect(&rect);

		CPen pen(PS_SOLID, 0, m_pFmParam->m_colFrame);
		CPen* pOldPen = pDC->SelectObject(&pen);


		// hԂ
//		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height() - SCROLLBARHEIGHT, PATCOPY);
		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);


		rect.right--;
		rect.bottom--;

		POINT pt[5];
		pt[0].x = (rect.left);
		pt[0].y = (rect.top);

		pt[1].x = (rect.right);
		pt[1].y = (rect.top);

		pt[2].x = (rect.right);
		pt[2].y = (rect.bottom);

		pt[3].x = (rect.left);
		pt[3].y = (rect.bottom);

		pt[4].x = (rect.left);
		pt[4].y = (rect.top);

		// g`
		pDC->Polyline((const POINT*)&pt, 5);

		// uVɖ߂
		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
	}



// #endif

	return TRUE;

//	return CView::OnEraseBkgnd(pDC);
}

void CFileView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CRect rc;
	GetWindowRect(&rc);
	ScreenToClient(&rc);
	rc.top = rc.bottom - SCROLLBARHEIGHT;
	rc.left++;
	rc.right--;
//	rc.bottom--;

// #ifndef _DIRECT_WRITE

//	if (!(m_pFmParam->m_bSystemDirectWrite)) {
//		m_ScrollBarHeight = rc.bottom - rc.top;
//		m_pScrollBar->MoveWindow(&rc);
//	}

// #endif


	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		DiscardDeviceResources();
		CreateDeviceResources();
#endif

	}


	SetScrollData();

}

void CFileView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	short shift = GetKeyState(VK_SHIFT);
	short ctrl = GetKeyState(VK_CONTROL);

	m_bKeyShift = false;
	m_bKeyCtrl = false;

	UINT cmdno = 0;
	if ( shift < 0 ) {
		m_bKeyShift = true;
		if ( ctrl < 0 ) {
			m_bKeyCtrl = true;
			cmdno = m_pFmParam->m_pShiftCtrlKeyMap[nChar];
		} else {
			cmdno = m_pFmParam->m_pShiftKeyMap[nChar];
		}
	} else {
		if ( ctrl < 0 ) {
			if ( nChar != 0x11 ) {
				cmdno = m_pFmParam->m_pCtrlKeyMap[nChar];
				m_bKeyCtrl = true;
			}
		} else {
			cmdno = m_pFmParam->m_pKeyMap[nChar];
		}
	}

	m_nCmdNo = cmdno;
//	m_bRunKey = false;

	if (!m_bIncSearch)
	{
		GetNoUsedViewNo();
		if ((nChar != 0x10) && (nChar != 0x11)) {
//			m_bRunKey = true;
			RunKeyCmd(cmdno);
			RedrawInfo();
		}
	}
	else {
		if ((nChar == 0x1b) || (cmdno == 0x226) || (cmdno == 0x228)) {
			IncSearch(nChar);
			RedrawInfo();
			Invalidate();
		}
		else {
			if ( (nChar == 0x09) || (nChar == 0x0d) || ((nChar >= 0x21) && (nChar <= 0x2e)) || (nChar == 0x5b)
				|| (nChar == 0x5d) || ((nChar >= 0x6f) && (nChar <= 0x7b)) || (nChar == 0xbf) || (nChar == 0xdc)
				|| (nChar == 0xe5) || (nChar == 0xf2) || (nChar == 0xf4) ) {
//				m_bRunKey = true;
				RunKeyCmd(cmdno);
				RedrawInfo();
				Invalidate();
			}
		}

	}



//	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

bool CFileView::IncSearch(UINT nCmdNo)
{
	bool bf = false;
	int nStart = 0;

	if (nCmdNo == 0x1b) {
		m_bIncSearch = false;
		bf = true;
		return bf;
	}

	bool bKey = false;
	CString uc;
	uc.Format(_T("%c"), nCmdNo);

	if (nCmdNo == 0x2a || nCmdNo == 0x2f || nCmdNo == 0x5c) {	// A^A
		return bf;
	}

	int nc = m_CurrentFileNo;
	int nmax = m_pFmParam->m_FileNum;
	nStart = nc;

	if (!bKey && nCmdNo == 0x08) {	// Backspace
		bKey = true;
		uc.Format(_T(""));
		int j = m_sIncSearchStr.GetLength() - 1;
		if (j < 0) j = 0;
		else {
			CString s = m_sIncSearchStr.Left(j);
			m_sIncSearchStr = s;
			nStart = 0;
		}
	}

	bool bBack = false;

	if (nc < (nmax - 1) && !bKey && nCmdNo == 0x28) {	// Ctrl + 
		nStart = nc + 1;
		bKey = true;
		uc.Format(_T(""));
	}

	if (!bKey && nc > 0 && nCmdNo == 0x26) {	// Ctrl + 
		nStart = nc - 1;
		bKey = true;
		uc.Format(_T(""));
		bBack = true;
	}

	if (!bKey && nCmdNo >= 0x20 && nCmdNo <= 0x7e) {	// SP`~
		bKey = true;
	}

	if (!bKey) return bf;


	bf = true;
	if (m_sIncSearchStr.GetLength() >= 19) return bf;

	CString sSerchStr;
	m_sIncSearchStr += uc;
	m_sIncSearchStr.MakeLower();
	sSerchStr = m_sIncSearchStr;

	int len = sSerchStr.GetLength();


	int i = nStart;
	while (1) {
		CString cfname = m_pFmParam->m_pw64FindData[i].name;
		CString fn = m_pFmParam->m_pw64FindData[i].name;
		cfname.MakeLower();
		int nn = cfname.Find(sSerchStr);

		if (nn >= 0) {
			m_CurrentFileNo = i;
			m_CurrentPage = m_CurrentFileNo / m_PageFileNum;
			bf = true;
//			m_sIncSearchStr = fn.Left(len);
			m_sIncSearchStr = fn.Mid(nn, len);
			break;
		}
		if (bBack) {	// Ctrl + 
			i--;
			if (i <= 0) {
				break;
			}
		}
		else {
			i++;
			if (i >= nmax) {
				break;
			}

		}

	}

	return bf;
}

void CFileView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	switch(nSBCode) {
		case SB_LINELEFT:	// XN[{bNX̍NbNꍇ
			CmdKeyPageUp();
			break;

		case SB_LINERIGHT:	// XN[{bNX̉ENbNꍇ
			CmdKeyPageDown();
			break;

		case SB_PAGELEFT:		// XN[{bNX̍NbNꍇi܂PageUpL[j
			CmdKeyPageUp();
			break;

		case SB_PAGERIGHT:		// XN[{bNX̉ENbNꍇi܂PageDownL[j
			CmdKeyPageDown();
			break;

		case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
			break;

		case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
			if ( m_CurrentPage != nPos ) {
				m_CurrentPage = nPos;
				m_CurrentFileNo = m_CurrentPage * m_PageFileNum;
				Invalidate();
			}
			break;

	}

//	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}

int CFileView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB
	// #ifndef _DIRECT_WRITE

//	if (!(m_pFmParam->m_bSystemDirectWrite)) {
//		m_pScrollBar = new CScrollBar;
//	}

	// #endif
	
// #ifndef _DIRECT_WRITE

//	if (!(m_pFmParam->m_bSystemDirectWrite)) {
//		m_pScrollBar->Create(SBS_HORZ | WS_CHILD, CRect(0, 0, 0, 0), this, 100);
//	}

// #endif

	BOOL b = m_DropTarget.Register(this);

	CMenu* pMenu = m_pChildView->m_pMainFrame->GetMenu();
	pMenu->CheckMenuItem(ID_CTRL_KEY_A, MF_UNCHECKED);
	pMenu->CheckMenuItem(ID_KEY_TAB, MF_UNCHECKED);
	pMenu->CheckMenuItem(ID_KEY_F9, MF_UNCHECKED);

	if (m_pFmParam->m_bHideDriveTab) {
		pMenu->CheckMenuItem(ID_KEY_INS, MF_UNCHECKED);
	}
	else {
		pMenu->CheckMenuItem(ID_KEY_INS, MF_CHECKED);
	}

	SetTimer(5, 1000, NULL);
	m_nUpdateTimeCount = m_pFmParam->m_nUpdateTime;

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		CreateDeviceIndependentResources();
#endif

	}

	return 0;
}


HDROP CFileView::DragCreateFiles (void)
{
	int nTag = m_pFmParam->m_TagFileNum;
	DWORD size;
	int nFile;
	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	m_saDropFilesArray.RemoveAll();

	if ( nTag == 0 ) {	// It@CȂ
		CString fname = cpath;
		fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		m_saDropFilesArray.Add(fname);
		size = fname.GetLength() + 1;
		nFile = 1;

	} else {
		int nt = m_pFmParam->m_FileNum;
		int num = nt;
		m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
		size = 0;
		nFile = 0;

		for ( int n = 0; n < nt; n++ ) {
			if ( !m_pFmParam->m_pMark[n] ) continue;

			CString fname = cpath;
			fname += m_pFmParam->m_pw64FindData[n].name;
			m_saDropFilesArray.Add(fname);
			size += (fname.GetLength() + 1);
		}
		nFile = nTag;

		delete []m_pFmParam->m_pCopyBuff;
	}
	size = size * sizeof(wchar_t);

	int hsize = sizeof(DROPFILES) + size + (sizeof(wchar_t) * 2);
	HDROP hDrop = (HDROP)::GlobalAlloc(GHND, hsize);
    if (hDrop == NULL)
        return hDrop;

    LPDROPFILES pDropFile = (LPDROPFILES)::GlobalLock(hDrop);
    pDropFile->pFiles = sizeof(DROPFILES);    
    pDropFile->pt.x = 0;
    pDropFile->pt.y = 0;
    pDropFile->fNC = FALSE;
    pDropFile->fWide = TRUE;

	CString fname;
    char* lpNams = (char *)(pDropFile);
	lpNams += pDropFile->pFiles;
	for ( int i = 0; i < nFile; i++ ) {
		fname = m_saDropFilesArray.GetAt(i);
		int asize = (fname.GetLength() + 1) * sizeof(wchar_t);
		::memcpy(lpNams, fname.GetBuffer(), asize);
		lpNams += asize;
	}
    ::GlobalUnlock(hDrop);
/*
	COleDataSource oleDataSrc;

	oleDataSrc.CacheGlobalData(CF_HDROP, hDrop);
    DROPEFFECT dropEffect = oleDataSrc.DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
*/
	return(hDrop);
}

void CFileView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( m_pFmParam->m_FileNum == 0 ) return;
	if ( m_bRunCmd ) return;

	m_bVoiceInit = true;
	DrawCursor(false);

	int fno;
	int x, y;  

	x = point.x / (m_ColumnWidth + m_xOfset);
	y = (point.y - m_yOfset) / m_LineHeight;
	int sn = m_CurrentPage * m_PageFileNum;

	fno = sn + (x * m_MaxLine) + y;
	if ( fno < m_pFmParam->m_FileNum ) {

		int pm = sn + m_PageFileNum - 1;

		int cmode = m_pFmParam->m_DisplayMode;
		if ( m_pFmParam->m_pFileParam[cmode].m_bShowOverPart ) {
			pm += m_MaxLine;
		}

		if ( fno > pm ) fno = pm;

		int xxs = x * (m_ColumnWidth + m_xOfset);
		int xxe = xxs + m_xOfset;
		if (point.x > xxs && point.x < xxe) {
			DrawCursor(false);

			CString s;
			s = m_pFmParam->m_pw64FindData[fno].name;
			if (s != _T("..")) {

				if (m_pFmParam->m_pMark[fno]) {
#ifdef _WINVER_XP
					DrawMark(false, fno);
#endif
					m_pFmParam->m_TagFileNum--;
					m_pFmParam->m_TagFileSize -= m_pFmParam->m_pw64FindData[fno].size;
				}
				else {
#ifdef _WINVER_XP
					DrawMark(true, fno);
#endif
					m_pFmParam->m_TagFileNum++;
					m_pFmParam->m_TagFileSize += m_pFmParam->m_pw64FindData[fno].size;
				}
				m_pFmParam->m_pMark[fno] = !(m_pFmParam->m_pMark[fno]);
			}

			Invalidate();
			DrawCursor();
		}
		else {
			m_CurrentFileNo = fno;
		}

	}


	DrawCursor();
	RedrawInfo();

	m_bOwnDragging = TRUE;
		
	HDROP hDrop = DragCreateFiles ();

	bool r = true;

	CString	fname = m_saDropFilesArray.GetAt(0);
	if ( fname.Right(2) == _T("..") ) r = false;


	if ( r && (hDrop != NULL) ) {
		m_OleDataSource.CacheGlobalData(CF_HDROP, hDrop);
		DROPEFFECT dropEffect = m_OleDataSource.DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
		UpdateFileList();
	}

	m_bOwnDragging = FALSE;
//	UpdateFileList();

//	SetFindNotify();

//	CView::OnLButtonDown(nFlags, point);
}

void CFileView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( m_bRunCmd ) return;

	m_bVoiceInit = true;
	CmdKeyEnter();

//	CView::OnLButtonDblClk(nFlags, point);
}

BOOL CFileView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	m_bVoiceInit = true;

	if ( zDelta > 0 ) CmdKeyPageUp();
	else CmdKeyPageDown();

	return 0;

//	return CView::OnMouseWheel(nFlags, zDelta, pt);
}

/*
	
DROPEFFECT
hbOhbvƂɁAIWiRs[邩Aړ邩Aۂ邩ʂ܂B

DROPEFFECT_NONE    0	hbvۂ܂
DROPEFFECT_COPY    1	Rs[܂
DROPEFFECT_MOVE    2	ړ܂iIWi폜܂j
DROPEFFECT_LINK    4	N쐬܂
DROPEFFECT_SCROLL  0x80000000

http://msdn.microsoft.com/ja-jp/library/9s5z33c4%28v=vs.80%29.aspx

*/

DROPEFFECT CFileView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	DROPEFFECT dwDropEffect = DROPEFFECT_NONE;

	if ( m_bOwnDragging ) return dwDropEffect;

	m_dwKeyState = dwKeyState;
	dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	dwDropEffect = (dwKeyState & MK_SHIFT) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;

/*
	if( pDataObject->IsDataAvailable(CF_TEXT) ) {
		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	} else {
		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;
	}
*/

	return dwDropEffect;
		
//	return CView::OnDragEnter(pDataObject, dwKeyState, point);
}

void CFileView::OnDragLeave()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	CView::OnDragLeave();
}

DROPEFFECT CFileView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	DROPEFFECT dwDropEffect = DROPEFFECT_NONE;


	if ( m_bOwnDragging ) return dwDropEffect;

	dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	dwDropEffect = (dwKeyState & MK_SHIFT) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;

/*
	if( pDataObject->IsDataAvailable(CF_TEXT) ) {
		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	} else {
		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;
	}
*/

	return dwDropEffect;

//	return CView::OnDragOver(pDataObject, dwKeyState, point);
}

BOOL CFileView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	if ( m_bOwnDragging ) return FALSE;

	if ( pDataObject->IsDataAvailable( CF_HDROP ) )
	{
		HDROP hDrop = (HDROP)pDataObject->GetGlobalData( CF_HDROP );
		if ( hDrop )
		{
			UINT nFiles = ::DragQueryFile( hDrop, 0xFFFFFFFF, NULL, 0 );
			if ( nFiles )
			{
				m_bRunCmd = true;

				if (m_pFmParam->m_bSettingsSelectDropEffect) {

					::SetForegroundWindow(m_pChildView->m_pMainFrame->m_hWnd);

					CSelectDropEffectDialog dlg;
					if (dropEffect == DROPEFFECT_MOVE) {
						dlg.m_bSetMove = true;

					}

					int r = dlg.DoModal();

					if (r == IDOK) {
						if (dlg.m_bMove) {
							dropEffect = DROPEFFECT_MOVE;
						}
						else {
							dropEffect = DROPEFFECT_COPY;

						}

					}
					if (r == IDCANCEL) {
						::DragFinish(hDrop);
						m_pFmParam->m_bRedrawFocus = true;
						m_bRunCmd = false;
						::SetForegroundWindow(m_pChildView->m_pMainFrame->m_hWnd);

						return CView::OnDrop(pDataObject, dropEffect, point);
					}

				}

				m_pFmParam->m_bCancelCopy = false;

				m_pFmParam->m_bRedrawFocus = false;
				m_saDropFilesArray.SetSize( nFiles );
				LPTSTR lpFileName = new TCHAR [MAX_PATH];
				UINT nDropFile = 0;

				for ( UINT i = 0 ; i < nFiles ; i ++ )
				{
					if ( ::DragQueryFile( hDrop, i, lpFileName, MAX_PATH ) )
						m_saDropFilesArray.SetAt( nDropFile++, lpFileName );
				}

				::DragFinish( hDrop );
				delete [] lpFileName;

				if ( nDropFile )
				{
					if ( nDropFile != nFiles )
						m_saDropFilesArray.SetSize( nDropFile );

					::SetForegroundWindow(m_pChildView->m_pMainFrame->m_hWnd);
					DropFilesCopy(dropEffect);
					UpdateFileList();

				}
				m_pFmParam->m_bRedrawFocus = true;
				m_bRunCmd = false;
				::SetForegroundWindow(m_pChildView->m_pMainFrame->m_hWnd);
				
			}
		}
	}
	return CView::OnDrop(pDataObject, dropEffect, point);
}


void CFileView::DropFilesCopy(DROPEFFECT dropEffect, CString cpath)
{
	int nFile = m_saDropFilesArray.GetSize();
	m_pFmParam->m_CopyMove = false;
	m_pFmParam->m_CopySame = FALSE;
	m_pFmParam->m_CopyMode = COPY_NON;
	if ( dropEffect == DROPEFFECT_MOVE ) m_pFmParam->m_CopyMove = true;
	CString currentPath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	if ( cpath != _T("") ) currentPath = cpath;

	m_pFmParam->m_CopyDestPath = currentPath;
	m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
	m_pFmParam->m_pCopyInfoDlg = new CCopyInfoDialog;
	CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pFmParam->m_pCopyInfoDlg;
	m_pFmParam->m_pCopyInfoDlg->Create(IDD_COPY_INFO_DIALOG, this);
	cidlg->ShowWindow(SW_SHOW);

	CString tmp, tmp2, tmp3;
	for ( int i = 0; i < nFile; i++ ) {
		CString fname = m_saDropFilesArray.GetAt(i);
		CString ch = STR_YEN;
		int n = fname.ReverseFind(ch.GetAt(0));
		m_pFmParam->m_CopySourcePath = fname.Left(n + 1);
		int len = fname.GetLength();
		len = len - n - 1;
		m_pFmParam->m_CopyFileName = fname.Right(len);

		if ( m_pFmParam->m_CopyFileName == _T("..") ) continue;

			tmp = _T("%d");
			tmp2.Format(tmp, i + 1);
			m_pFmParam->InsertComma(tmp2);
			tmp3.Format(tmp, nFile);
			m_pFmParam->InsertComma(tmp3);
			tmp = _T("%16s / %16s");
			cidlg->m_FileNum.Format(tmp, tmp2, tmp3);
			int iret = m_pFmParam->CopyDirectory();
			if ( iret == 0 ) m_pFmParam->CopyOneFile();
			if ( m_pFmParam->m_CopyMode == -1 ) break;

	}

	delete []m_pFmParam->m_pCopyBuff;
	m_pFmParam->m_pCopyInfoDlg->DestroyWindow();
	delete m_pFmParam->m_pCopyInfoDlg;

}


BOOL CFileView::OnScrollBy(CSize sizeScroll, BOOL bDoScroll)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	return CView::OnScrollBy(sizeScroll, bDoScroll);
}


// ʊ֐ ==================================

void CFileView::InitialSearch(UINT uCmdNo)
{

	int nmax = m_pFmParam->m_FileNum;
	int cf = m_CurrentFileNo;

	while (nmax > 0) {

		cf++;
		if (cf >= m_pFmParam->m_FileNum) {
			cf = 0;
		}

		CString s = m_pFmParam->m_pw64FindData[cf].name;

		UINT ua = s.GetAt(0);
		if ( (ua > 0x60) && (ua < 0x7b) ) {
			ua -= 0x20;
		}

		if (ua == uCmdNo) {

			m_CurrentFileNo = cf;
			break;

		}


		nmax--;
	}

	Invalidate();

}


void CFileView::CmdKeyF09ChangeInitialSearch(void)
{
	CMenu* pMenu = m_pChildView->m_pMainFrame->GetMenu();

	if (m_bInitialSearch) {
		m_bInitialSearch = false;
		pMenu->CheckMenuItem(ID_KEY_F9, MF_UNCHECKED);
	}
	else {
		m_bInitialSearch = true;
		pMenu->CheckMenuItem(ID_KEY_F9, MF_CHECKED);
	}

	Invalidate();
}


void CFileView::CmdKeyF11EmptyRecycleBin(void)
{
	DWORD dwFlag = 0x0000;

	// ݔɂ
//	dwFlag |= SHERB_NOCONFIRMATION;     // 폜O̊mF_CAO\Ȃ
//	dwFlag |= SHERB_NOPROGRESSUI;       // 폜̐is_CAO\Ȃ
//	dwFlag |= SHERB_NOSOUND;            // 폜̃TEh(WAVE)ĐȂ

	SHEmptyRecycleBin(NULL, NULL, dwFlag);

}


// L[R}hs	nCmdNo = R}hNo.
// L[JX^}CYyуR}h}NpɁAR}hNo.őSẴR}hs
void CFileView::RunKeyCmd(UINT uCmdNo)
{

	if (m_bRunCmd) {
		if (m_bNowGetDir && uCmdNo == 0x1b) m_bNowGetDir = false;

		if (uCmdNo == 0x1b) {
			m_bCancelMacro = true;
		}

		return;
	}

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	SetCurrentDirectory(cpath);

	m_pFmParam->m_bRedrawFocus = false;
	m_bInitFileList = false;
	m_bRunCmd = true;

	m_bVoiceInit = true;

	CPoint point(-1, -1);
	CString s;

	if (m_bInitialSearch && uCmdNo > 0x2f && uCmdNo < 0x5b) {
		
		InitialSearch(uCmdNo);

		if (m_bInitFileList) UpdateFileList(true);
		else CheckFindNotify();

		m_bRunCmd = false;
		m_pFmParam->m_bRedrawFocus = m_pFmParam->m_bInitRedrawFocus;

		return;
	}

	switch ( uCmdNo ) {

		case 0x08: // "Backspace"
			CmdKeyBackspace();
			break;

		case 0x09: // "tab"
			CmdKeyTab();
			break;

		case 0x0d: // "Enter"
			CmdKeyEnter();
			break;

		case 0x1b: // "Esc"
			CmdKeyEsc();
			break;

		case 0x20: // Space
			CmdKeySpace();
			break;

		case 0x21: // PageUp
			CmdKeyPageUp();
			break;

		case 0x22: // PageDown
			CmdKeyPageDown();
			break;

		case 0x23: // "End"
			CmdKeyEnd();
			break;

		case 0x24: // "Home"
			CmdKeyHome();
			break;

		case 0x25: // ""
			CmdKeyLeft();
			break;

		case 0x26: // ""
			CmdKeyUp();
			break;

		case 0x27: // ""
			CmdKeyRight();
			break;

		case 0x28: // ""
			CmdKeyDown();
			break;

		case 0x2d: // "Insert"
			CmdKeyInsert();
			break;

		case 0x30: // "0"
		case 0x31: // "1"
		case 0x32: // "2"
		case 0x33: // "3"
		case 0x34: // "4"
		case 0x35: // "5"
		case 0x36: // "6"
		case 0x37: // "7"
		case 0x38: // "8"
		case 0x39: // "9"
			CmdKeyChangeDrive(uCmdNo);
			break;

		case 0x41: // "A"
			CmdKeySetAttribute();
			break;

		case 0x42: // "B"
			CmdKeyBinaryEditFile();
			break;

		case 0x43: // "C"
//			if (m_pFmParam->m_TagFileNum == 0) {
//				s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
//				if (s == _T("..")) break;
//			}
			CmdKeyCopyFile();
			break;

		case 0x44: // "D"
			CmdKeyDeleteFile();
			break;

		case 0x45: // "E"
			CmdKeyEditFile();
			break;

		case 0x46: // "F"
			CmdKeyFindFile();
			break;

		case 0x47: // "G"
			CmdKeyGraphView();
			break;

		case 0x48: // "H"
			CmdKeyMovePath();
			break;

		case 0x4a: // "J"
			CmdKeyJump();
			break;

		case 0x4b: // "K"
			CmdKeyMakeDir();
			break;

		case 0x4c: // "L"
			CmdKeySelectDrive();
			break;

		case 0x4d: // "M"
			CmdKeyMoveFile();
			break;

		case 0x4e: // "N"
			CmdKeyChangeName();
			break;

		case 0x4f: // "O"
			CmdKeyMovePosOrgWindow();
			break;

		case 0x50: // "P"
			CmdKeyPack();
			break;

		case 0x51: // "Q"
			CmdKeyQuit();
			break;

		case 0x52: // "R"
			CmdKeyRunProgram();
			break;

		case 0x53: // "S"
			CmdKeySort();
			break;

		case 0x54: // "T"
			CmdKeyTree();
			break;

		case 0x55: // "U"
			CmdKeyUnpack();
			break;

		case 0x56: // "V"
			CmdKeyView();
			break;

		case 0x57: // "W"
			CmdKeyHome();
			break;

		case 0x58: // "X"
			CmdKeyDeleteExif();
			break;

		case 0x59: // "Y"
			CmdKeySetWildCard();
			break;

		case 0x5D: // "App"
			CmdKeyApp(point);
			break;

		case 0x60: // "0" eL[
		case 0x61: // "1"
		case 0x62: // "2"
		case 0x63: // "3"
		case 0x64: // "4"
		case 0x65: // "5"
		case 0x66: // "6"
		case 0x67: // "7"
		case 0x68: // "8"
		case 0x69: // "9"
			CmdKeyChangeDrive(uCmdNo - 0x30);
			break;

		case 0x71: // "F2"
			CmdKeyF02();
			break;

		case 0x72: // "F3"
			CmdKeyF03();
			break;

		case 0x74: // "F5"
			CmdKeyF05();
			break;

		case 0x76: // "F7"
			CmdKeyF07Launcher();
			break;

		case 0x77: // "F8"
			CmdKeyF08();
			break;


		case 0x78: // "F9"
			CmdKeyF09ChangeInitialSearch();
			break;

		case 0x7a: // "F11"
			CmdKeyF11EmptyRecycleBin();
			break;

		case 0xbc: // "<"
			CmdKeyTop();
			break;

		case 0xbe: // ">"
			CmdKeyEnd();
			break;

		case 0xbf: // "/"
			CmdKeyGoHomeFolder();
			break;

		case 0x80: // PostMessageɂFileWndɃR}h𑗐M邽߂ɎgpB
			RunPostCmd();	// m_PostCmdNõR}hs
			break;

		case 0xdc: // "\"
			CmdKeyMoveRoot();
			break;

		// Shift+
		case 0x108: // "Backspace"
			break;

		case 0x10d: // "Enter"
			CmdKeyShiftEnter();
			break;

		case 0x121: // PageUp
			break;

		case 0x122: // PageDown
			break;


		case 0x124: // "Home"
			CmdKeyShiftHome();
			break;

		case 0x125: // ""
			CmdKeyShiftLeft();
			break;

		case 0x126: // ""
			break;

		case 0x127: // ""
			break;

		case 0x128: // ""
			break;

		case 0x130: // "0"
			break;
		case 0x131: // "1"
			m_pFmParam->m_DisplayMode = 0;
			RecalcPage();
			Invalidate();
			break;
		case 0x132: // "2"
			m_pFmParam->m_DisplayMode = 1;
			RecalcPage();
			Invalidate();
			break;
		case 0x133: // "3"
			m_pFmParam->m_DisplayMode = 2;
			RecalcPage();
			Invalidate();
			break;
		case 0x134: // "4"
			m_pFmParam->m_DisplayMode = 3;
			RecalcPage();
			Invalidate();
			break;
		case 0x135: // "5"
			m_pFmParam->m_DisplayMode = 4;
			RecalcPage();
			Invalidate();
			break;
		case 0x136: // "6"
			break;
		case 0x137: // "7"
			break;
		case 0x138: // "8"
			break;
		case 0x139: // "9"
			break;

		case 0x141: // "A"
			CmdKeyShiftAannsFM();
			break;

		case 0x142: // "B"
			CmdKeyShiftBCopyFileNameTextClipboard();
			break;

		case 0x143: // "C"
			CmdKeyShiftCCloseUncTab();
			break;

		case 0x144: // "D"
			CmdKeyShiftDChangeDisplayAttribute();
			break;

		case 0x145: // "E"
			CmdKeyShiftEExplorer();
			break;

		case 0x146: // "F"
			CmdKeyShiftFRestoreZip();
			break;

		case 0x147: // "G"
			CmdKeyShiftGPlayMovie();
			break;

		case 0x149: // "I"
			CmdKeyShiftISetParam();
			break;

		case 0x14c: // "L"
			CmdKeyShiftLCreateShortcut();
			break;

		case 0x14d: // "M"
			MacroCommand();
			break;

		case 0x14e: // "N"
			CmdKeyShiftNConnectNetwork();
			break;

		case 0x14f: // "O"
			CmdKeyShiftOSavePosOrgWindow();
			break;

		case 0x150: // "P"
			CmdKeyShiftPOpenProperties();
			break;

		case 0x153: // "S"
			CmdKeyShiftSDrawDirSize();
			break;

		case 0x154: // "T"
			saLmzip32ViewOption = "-t";
			CmdKeyView();
			break;

		case 0x155: // "U"
			saLmzip32ViewOption = "-l";
			CmdKeyView();
			break;

		case 0x156: // "V"
			CmdKeyShiftVChangeVolumeLabel();
			break;

		case 0x157: // "W"
			CmdKeyShiftHome();
			break;

		case 0x15a: // "Z"
			OnMenuShiftKeyZ();
			break;


		case 0x160: // "0" eL[
			break;
		case 0x161: // "1"
			break;
		case 0x162: // "2"
			break;
		case 0x163: // "3"
			break;
		case 0x164: // "4"
			break;
		case 0x165: // "5"
			break;
		case 0x166: // "6"
			break;
		case 0x167: // "7"
			break;
		case 0x168: // "8"
			break;
		case 0x169: // "9"
			break;



		// Ctrl+
		case 0x208: // "Backspace"
			break;

		case 0x209: // "Tab"
			CmdKeyCtrlTab();
			break;

		case 0x20d: // "Enter"
			CmdKeyCtrlEnter();
			break;

		case 0x221: // PageUp
			break;

		case 0x222: // PageDown
			break;

		case 0x224: // "Home"
			CmdKeyCtrlHome();
			break;

		case 0x225: // ""
			CmdKeyCtrlLeft();
			break;

		case 0x226: // ""
			CmdKeyCtrlUp();
			break;

		case 0x227: // ""
			CmdKeyCtrlRight();
			break;

		case 0x228: // ""
			CmdKeyCtrlDown();
			break;

		case 0x230: // "0"
		case 0x231: // "1"
		case 0x232: // "2"
		case 0x233: // "3"
		case 0x234: // "4"
		case 0x235: // "5"
		case 0x236: // "6"
		case 0x237: // "7"
		case 0x238: // "8"
		case 0x239: // "9"

			CmdKeyCtrlNumber(uCmdNo - 0x230);

			break;


		case 0x241: // "A"
			OnMenuCtrlKeyA();
			break;


		case 0x242: // "B"
			CmdKeyCtrlBCopyTextClipboard();
			break;

		case 0x243: // "C"
			CmdKeyCtrlCCopyClipboard();
			break;

		case 0x244: // "D"
			CmdKeyCtrlDDisplayOnOff();
			break;

		case 0x245: // "E"
			CmdKeyCtrlERemoveDrive();
			break;

		case 0x247: // "G"
			CmdKeyCtrlGPlayMovie();
			break;

		case 0x248: // "H"
			CmdKeyCtrlHHelp();
			break;

		case 0x249: // "I"
			CmdKeyCtrlIWriteIniFile();
			break;

		case 0x24b: // "K"
			CmdKeyCtrlKSelectMark();
			break;


		case 0x24d: // "M"
			CmdKeyCtrlMMirrorCopy();
			break;

		case 0x24e: // "N"
			CmdKeyCtrlNChangeNameAll();
			break;

		case 0x24f: // "O"
			CmdKeyCtrlOChangeNameOnly();
			break;

		case 0x250: // "P"
			CmdKeyCtrlPPushCurrentPath();
			break;

		case 0x252: // "R"
			CmdKeyCtrlRPopCurrentPath();
			break;


		case 0x253: // "S"
			CmdKeyCtrlSPlaySound();
			break;

		case 0x254: // "T"
			CmdKeyCtrlTChangeFileTime();
			break;

		case 0x256: // "V"
			CmdKeyCtrlVPasteClipboard();
			break;

		case 0x258: // "X"
			CmdKeyCtrlXCopyCutClipboard();
			break;

		case 0x25a: // "Z"
			CmdKeyCtrlZReverseMark();
			break;

		case 0x25d: // "App"
			point.y = -2;
			CmdKeyApp(point);
			break;

		case 0x260: // "0" eL[
//			MessageBox(m_pInfoWnd->m_sDebugString);
			break;
		case 0x261: // "1"
			break;
		case 0x262: // "2"
			break;
		case 0x263: // "3"
			break;
		case 0x264: // "4"
			break;
		case 0x265: // "5"
			break;
		case 0x266: // "6"
			break;
		case 0x267: // "7"
			break;
		case 0x268: // "8"
			break;
		case 0x269: // "9"
			break;

	}


	if ( m_bInitFileList ) UpdateFileList(true);
	else CheckFindNotify();

	if ( m_pFmParam->m_bMoveHistoryFile ) {
//		CString ppath =m_pFmParam->m_pFolderData[m_pFmParam->m_nCurrentFolderData].sDirName;
		CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		if ( m_pFmParam->m_bEnableMoveHistoryFile ) {
			CString sHfile = m_pFmParam->GetHistFolderData(cpath);
			if ( sHfile != _T("") ) {
				int max = m_pFmParam->m_FileNum;
				for ( int n = 0; n < max; n++ ) {
					CString cf;
					cf = m_pFmParam->m_pw64FindData[n].name;
					if ( sHfile == cf ) {
						m_CurrentFileNo = n;
						Invalidate();

						break;
					}
				}
			}
			m_pFmParam->m_bEnableMoveHistoryFile = false;
		}

	}

	m_bRunCmd = false;
	m_pFmParam->m_bRedrawFocus = m_pFmParam->m_bInitRedrawFocus;
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}

void CFileView::CheckFindNotify(void)
{
	DWORD dwRet = WaitForSingleObject(m_pChildView->m_pMainFrame->m_hNotify, 0);
	if ( dwRet == WAIT_OBJECT_0 ) {
		UpdateFileList();
	}
}


void CFileView::SetFindNotify(bool bInit)
{
	CString cpath, path;
	path = m_pChildView->m_pMainFrame->m_sCurrentPath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if ( (path != cpath) || bInit ) {
		m_pChildView->m_pMainFrame->m_sCurrentPath = cpath;
		FindCloseChangeNotification(m_pChildView->m_pMainFrame->m_hNotify);
		m_pChildView->m_pMainFrame->m_hNotify = FindFirstChangeNotification( cpath, FALSE, FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME
				| FILE_NOTIFY_CHANGE_ATTRIBUTES | FILE_NOTIFY_CHANGE_SIZE | FILE_NOTIFY_CHANGE_LAST_WRITE );
	}
}


void CFileView::UpdateFileList(bool bInit)
{
	m_pFmParam->m_pDriveParam->GetDriveParam();
	m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
	m_pDriveTabWnd->Invalidate();

	int fmax = m_pFmParam->m_FileNum;
	int nMax = 0;
	int tagnum = m_pFmParam->m_TagFileNum;

	if ( (tagnum != 0) && !bInit) {
		for ( int i = 0; i < fmax; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) {
				m_pFmParam->m_sTemp64FindDataName[nMax] = m_pFmParam->m_pw64FindData[i].name;
				nMax++;
			}
		}
	}

	CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(cpath);
	int max = m_pFmParam->m_FileNum - 1;
	if ( m_CurrentFileNo > max ) m_CurrentFileNo = max;
	if ( m_CurrentFileNo < 0 ) m_CurrentFileNo = 0;
	m_CurrentPage = m_CurrentFileNo / m_PageFileNum;

	if ( bInit ) m_pFmParam->ClearMark();

	if ( (tagnum != 0) && !bInit) {
		m_pFmParam->ClearMark();
		for ( int i = 0; i < nMax; i++ ) {
			CString sfname = m_pFmParam->m_sTemp64FindDataName[i];
			for ( int j = 0; j <= max; j++ ) {
				if ( m_pFmParam->m_pw64FindData[j].name == sfname ) {
					m_pFmParam->m_pMark[j] = true;
					m_pFmParam->m_TagFileNum++;
					m_pFmParam->m_TagFileSize += m_pFmParam->m_pw64FindData[j].size;
					break;
				}
			}
		}
	}

	Invalidate();
	SetScrollData();
	SetFindNotify(true);

}



void CFileView::SetScrollData(void)
{
	int maxpage;
	maxpage = (m_pFmParam->m_FileNum - 1) / m_PageFileNum;
	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_PAGE | SIF_RANGE;
	info.nMin = 0;    
	info.nMax = maxpage;
	info.nPage = 1;
	info.nPos = 0;
	info.nTrackPos = 2;

// #ifdef _DIRECT_WRITE

//	if (m_pFmParam->m_bSystemDirectWrite) {
		m_pChildView->m_pScrollBar->SetScrollInfo(&info);

		if (maxpage == 0) {
			m_pChildView->m_pScrollBar->EnableScrollBar(ESB_DISABLE_BOTH);
		}
		m_pChildView->m_pScrollBar->ShowScrollBar();
//	}

// #endif

// #ifndef _DIRECT_WRITE

//	if (!(m_pFmParam->m_bSystemDirectWrite)) {
//		m_pScrollBar->SetScrollInfo(&info);

//		if (maxpage == 0) {
//			m_pScrollBar->EnableScrollBar(ESB_DISABLE_BOTH);
//		}
//		m_pScrollBar->ShowScrollBar();
//	}

// #endif

}

void CFileView::SetScrollPos(int pos)
{
// #ifdef _DIRECT_WRITE

//	if (m_pFmParam->m_bSystemDirectWrite) {
		m_pChildView->m_pScrollBar->SetScrollPos(pos);
//	}

// #endif

// #ifndef _DIRECT_WRITE

//	if (!(m_pFmParam->m_bSystemDirectWrite)) {
//		m_pScrollBar->SetScrollPos(pos);
//	}

// #endif

}

bool CFileView::GetParentDir(CString path, CString& parentPath)
{
	int ny;
	ny = path.Find(_T("\\\\"));
	bool bUncRoot = false;
	if ( ny == 0 ) {
		ny = path.Find(STR_YEN, 2);
		ny++;
		int ny2 = path.Find(STR_YEN, ny);
		ny2++;

		if ( ny2 == path.GetLength() ) bUncRoot = true;
	}

	if ( bUncRoot ) {
		parentPath = _T("");
		return false;
	}

	int i, n;
	CString s = _T("\\");
	CString tmp;

	i = path.ReverseFind(s.GetAt(0));
	if ( (i == -1) || (path.GetLength() < 4) ) {
		parentPath = _T("");
		return false;
	}
	tmp = path.Left(i);
	i = tmp.ReverseFind(s.GetAt(0));
	i++;
	parentPath = tmp.Left(i);

	n = path.GetLength();
	m_pFmParam->m_sPrevDir = tmp.Mid(i, n - i);

	return true;
}


bool CFileView::ChangeDirectory(UINT driveno, CString fname)
{
	CString path;
	bool ex;
	ex = m_pFmParam->m_pDriveParam->m_pExist[driveno];
	if ( !ex ) return false;

	m_pFmParam->m_SelectFileName = fname;

	m_pFmParam->m_CurrentDriveNo = driveno;
	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[driveno];
	m_CurrentFileNo = 0;

	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(path);

	if ( m_pFmParam->m_SelectFileNo != 0 ) m_CurrentFileNo = m_pFmParam->m_SelectFileNo;
	m_CurrentPage = 0;
	Invalidate();
	SetScrollData();
	m_pDriveTabWnd->CreateDriveList();
	m_pDriveTabWnd->Invalidate();

	SetFindNotify();

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	SetCurrentDirectory(cpath);

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	return true;
}

void CFileView::DrawMark(bool on, int cpos)
{
	CDC* dc = GetDC();
	if ( cpos == -1 ) cpos = m_CurrentFileNo;

    CRect rect;
    GetClientRect(&rect);

	CString s, fname;
	int max = m_pFmParam->m_FileNum;
	int at, x, y, dw, tw;

	COLORREF col;

	x = 0;
	y = 0;

	dw = m_ColumnWidth;
	tw = m_ColumnWidth / m_FontWidth;
	CRect crc;
	int xp, yp, pageof, pos, filenum;
	filenum = m_MaxLine * m_MaxColumn;
	pageof = m_CurrentPage * filenum;
	pos = cpos - pageof;

	at = m_pFmParam->m_pw64FindData[cpos].attrib;

	col = m_pFmParam->m_colListNormal;
	if ((at & _A_SUBDIR) != 0) col = m_pFmParam->m_colListDir;
	if ((at & _A_RDONLY) != 0) col = m_pFmParam->m_colListReadonly;
	if ((at & _A_HIDDEN) != 0) col = m_pFmParam->m_colListHide;
	if ((at & _A_SYSTEM) != 0) col = m_pFmParam->m_colListSystem;

	if ( cpos != 0 ) {
		x = (pos / m_MaxLine) * (dw + m_xOfset);
		y = pos % m_MaxLine;
	}
	xp = x + MARKOFSET;
	yp = m_LineHeight * y + m_yOfset;
	crc.top = yp;
	crc.left = xp;
	crc.right = xp + MARKX;
	crc.bottom = yp + m_LineHeight;


	if (m_pFmParam->m_bListMarkAst) {
		CFont font;
		font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		CFont* pOldFont = dc->SelectObject(&font);

		dc->SetTextColor(col);
		dc->SetBkColor(m_pFmParam->m_colBack);

		CString sm = _T(" ");
		if (on) {
			sm = _T("*");
		}
		dc->DrawText(sm, crc, DT_LEFT);

		dc->SelectObject(pOldFont);

		ReleaseDC(dc);

		return;
	}



	POINT pt[8];
	pt[0].x = xp;
	pt[0].y = yp + (m_LineHeight / 4) + 2;
	pt[1].x = xp + MARKX / 3;
	pt[1].y = pt[0].y;
	pt[2].x = pt[1].x;
	pt[2].y = yp + 2;
	pt[3].x = xp + MARKX - 1;
	pt[3].y = yp + m_LineHeight / 2;
	pt[4].x = pt[1].x;
	pt[4].y = yp + m_LineHeight - 2;
	pt[5].x = pt[1].x;
	pt[5].y = yp + (m_LineHeight * 3 / 4) - 1;
	pt[6].x = pt[0].x;
	pt[6].y = pt[5].y;
	pt[7].x = pt[0].x;
	pt[7].y = pt[0].y;

	CBrush cbr;
	if ( on ) {
		CPen pen(PS_SOLID, 0, col);
		CPen* pOldPen = dc->SelectObject(&pen);
		CBrush brush(col);
		CBrush* pOldBrush = dc->SelectObject(&brush);
		cbr.CreateSolidBrush(col);
		dc->Polygon((const POINT*)&pt, 8);
		dc->SelectObject(pOldBrush);
		dc->SelectObject(pOldPen);
	} else {
		cbr.CreateSolidBrush(m_pFmParam->m_colBack);
		dc->FillRect(&crc, &cbr);
	}
	ReleaseDC(dc);

}

void CFileView::RedrawInfo(void)
{
	CString cpath, path;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
//	path = cpath.Left(3);
	path = cpath;
	m_pFmParam->GetFreeSize(path);
	m_pInfoWnd->m_CurrentFileNo = m_CurrentFileNo;

///#ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		m_pInfoWnd->DrawInfoDirectWrite();
#endif

	}

// #endif

// #ifndef _DIRECT_WRITE

	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		m_pInfoWnd->DrawInfo();
	}

// #endif

}



// I[vĂȂView̔ԍԂ
// ɁAɕĂViewdeleteĂȂ̂delete
// ߂l -1 ̏ꍇA󂫂Ȃ
int CFileView::GetNoUsedViewNo(void)
{
	int n;
	n = -1;
	for (int i = 0; i < MAXVIEW; i++) {
		if ( m_pViewFrame[i] == NULL ) {
			if ( n == -1 ) n = i;
		} else {
			if ( !m_pViewFrame[i]->m_Exist ) {
				m_pViewFrame[i] = NULL;
				if ( n == -1 ) n = i;
			}
		}
	}

	return n;
}

bool CFileView::CheckGraphExt(CString fname)
{

	bool r = false;

	if (!m_pFmParam->m_bSettingsannsViewHavePriority) return r;

	if ( m_pFmParam->DivideFileName(fname) ) {
		CString ext = m_pFmParam->m_sExt;
		ext.MakeUpper();

		CString param = m_pFmParam->m_sExtentionsImage;
		param.MakeUpper();
		int nr = param.Find(ext);
		if ( nr >= 0 ) {
			r = true;
		}
/*
		if ( ext == _T(".JPG") ) r = true;
		if ( ext == _T(".BMP") ) r = true;
		if ( ext == _T(".GIF") ) r = true;
		if ( ext == _T(".PNG") ) r = true;
		if ( ext == _T(".TIF") ) r = true;
		if ( ext == _T(".ICO") ) r = true;
		if ( ext == _T(".JPEG") ) r = true;
*/
	}
	return r;
}

void CFileView::RunannsFMtextExe(CString sFileName)
{
	CString sExePath = m_pFmParam->GetExePath(_T(""));

	HWND hWnd = m_pChildView->m_pMainFrame->m_hWnd;	// hWnd

	CString sExeFname;
	sExeFname = sExePath;
	sExeFname += ANNSFMTEXT_EXE;

	CString sCom, cfname;
	sCom.Format(_T("hwnd=%d \"%s\""), hWnd, sFileName);

	CString tmp = _T("open");

	ShellExecute(this->m_hWnd, tmp, sExeFname, sCom, sExePath, SW_SHOW);
}


void CFileView::CreateannsView(bool bGmode, bool bFMtextExe, CString sFileName)
{
	CString cpath, sname;
	CString fname;

	fname = sFileName;
	cpath = _T("");
	sname = fname;

	if (sFileName == _T("")) {

		cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		sname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

		fname = cpath + sname;
	}


	int n = GetNoUsedViewNo();

	if (n < 0) {
		MessageBox(_T("\łannsView10܂łłB"), MB_OK);
		return;
	}

	int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
	if ((at & _A_SUBDIR) != 0) return;
	



	CFile f;
//	if (!f.Open(fname, CFile::modeRead | CFile::shareDenyWrite)) {
	if (!f.Open(fname, CFile::modeRead | CFile::shareDenyNone)) {
			CString s = _T("t@CI[vł܂!");
		MessageBox(s);
		return;
	} else f.Close();

	m_pViewFrame[n] = new CannsViewFrame;
	m_pViewFrame[n]->m_pFmParam = m_pFmParam;
	m_pViewFrame[n]->m_pwndView->m_sFileName = sname;
	m_pViewFrame[n]->m_pwndView->m_sFullFileName = cpath;
	m_pViewFrame[n]->m_pwndView->m_sFullFileName += sname;

	m_pViewFrame[n]->m_pwndGView->m_sFileName = cpath;
	m_pViewFrame[n]->m_pwndGView->m_sFileName += sname;

	m_pViewFrame[n]->m_ViewNo = n;

	m_pFmParam->m_bFindSPI = false;

	bool bFindSPI = false;

	if ( bGmode ) {
		if ( CheckGraphExt( m_pViewFrame[n]->m_pwndGView->m_sFileName ) ) {
			m_pViewFrame[n]->m_bGmode = true;
		} else {
			m_pViewFrame[n]->m_bGmode = false;
			if ( m_pFmParam->m_bToolUseSPI ) {
				bFindSPI = m_pFmParam->SearchSPI( m_pViewFrame[n]->m_pwndGView->m_sFileName );
				m_pViewFrame[n]->m_bGmode = bFindSPI;
			}
		}
	}
	
	CString sPfname = _T("");
	if (!bFindSPI) {
		if (saLmzip32ViewOption == _T("-t")) {
			sPfname = CreateTestArcListFile();

		}
		else {
			sPfname = CreateArcListFile(sname);

		}
	}

	if ( sPfname != _T("") ) {
		m_pViewFrame[n]->m_pwndView->m_sFullFileName = sPfname;
		m_pViewFrame[n]->m_bGmode = false;
		fname = sPfname;
	}


	m_pViewFrame[n]->m_pwndFile = this;
	BOOL br = m_pViewFrame[n]->LoadFrame(IDR_ANNSVIEWFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);

	if ( !br ) return;

	CMenu* pMenu = m_pViewFrame[n]->GetMenu();
	if (!m_pViewFrame[n]->m_bGmode) {
		pMenu->RemoveMenu(2, MF_BYPOSITION | MF_GRAYED);

	}
	else {
		pMenu->RemoveMenu(3, MF_BYPOSITION | MF_GRAYED);

	}


	DrawMenuBar();



	m_bFailGmode = false;
	if (!(m_pViewFrame[n]->m_bGmode) || m_pViewFrame[n]->m_pwndGView->m_gImage 

#ifndef _WINVER_XP
		|| m_pViewFrame[n]->m_pwndGView->m_gTarget
#endif
		
		) {
//	if (!(m_pViewFrame[n]->m_bGmode) || m_pViewFrame[n]->m_pwndGView->m_gImage) {

		
		if (bFMtextExe && !(m_pViewFrame[n]->m_bGmode)) {

			if (m_pViewFrame[n] != NULL) {
				m_pViewFrame[n]->DestroyWindow();
				m_pViewFrame[n] = NULL;
			}

			RunannsFMtextExe(fname);

			return;
		}
		

		m_pViewFrame[n]->ShowWindow(SW_SHOW);
		m_pViewFrame[n]->UpdateWindow();
	} else {
//		MessageBox(_T("摜̓ǂݍ݂Ɏs܂"));
		m_bFailGmode = true;
		m_pViewFrame[n]->ShowWindow(SW_HIDE);

	}



}

void CFileView::DeleteAllView(void)
{
	for (int i = 0; i < MAXVIEW; i++) {
		if ( m_pViewFrame[i] != NULL ) {
			m_pViewFrame[i]->DestroyWindow();
			m_pViewFrame[i] = NULL;
		}
	}
	
}


// ret -1:gqI_CAOŃLZ 1:gqv 0:YȂ
int CFileView::CheckExtentionMap(CString ext)
{

	int ret = 0;
	int k = 0;

	int max = m_pFmParam->m_nMaxExtMapNum;
	for (int i = 0; i < max; i++ ) {
		CString smext = m_pFmParam->m_pExtMap[i].ext;
		if ( smext == ext ) {	// gq}bviԖڂƈv
			int n = i + 1;
			if ( n < max ) {	// ̊gq邩
				smext = m_pFmParam->m_pExtMap[n].ext;
				if ( smext == ext ) {	// (nԖ)v
					int fmax = MAX_EXTENTION_FILE_NUM;
					m_psExtMapFiles = new CString[MAX_EXTENTION_FILE_NUM];
					m_psExtMapFiles[0] = m_pFmParam->m_pExtMap[i].exeFile;
					m_psExtMapFiles[1] = m_pFmParam->m_pExtMap[n].exeFile;
					k = 2;
					for ( int j = n + 1; j < max; j++ ) {
						smext = m_pFmParam->m_pExtMap[j].ext;
						if ( k >= fmax ) break;
						if ( smext == ext ) {	// (jԖ)v
							m_psExtMapFiles[k] = m_pFmParam->m_pExtMap[j].exeFile;
							k++;
						} else {
							break;
						}
					}
					m_nExtMapFileNum = k;

					CSelectExtfileDialog dlg;
					dlg.m_psExtMapFiles = m_psExtMapFiles;
					dlg.m_nFileNum = m_nExtMapFileNum;
					dlg.m_sExtStatic = ext;

					int rd = dlg.DoModal();
					delete []m_psExtMapFiles;

					if ( rd == IDOK ) {
						m_sExtMapFile = dlg.m_sSelectedFile;
						ret = 1;
						break;
					} else {
						ret = -1;
						break;
					}

				} else {	// ͂Ȃ̂iԖڂŌ
					m_sExtMapFile = m_pFmParam->m_pExtMap[i].exeFile;
					k++;
					ret = 1;
					break;
				}
			} else {	// ͂Ȃ̂Ō
				m_sExtMapFile = m_pFmParam->m_pExtMap[i].exeFile;
				k++;
				ret = 1;
				break;
			}

		}
	}

	return ret;
}

// gqɂU蕪(EnterL[)
// true:Ygq  false:YȂ(m_pFmParam->m_ExtKind = EXT_KIND_VIEW)܂̓LZ
bool CFileView::AnalyzeExtention(CString fname)
{
	CString param, ext, s;


	m_pFmParam->m_ExtKind = NULL;

	if ( m_pFmParam->DivideFileName(fname) ) {

		m_pFmParam->m_sExt.MakeUpper();
		ext = m_pFmParam->m_sExt;
		int re =  CheckExtentionMap(ext);
		if ( re == -1 ) {
			return false;
		}

		if ( re == 1 ) {
			m_pFmParam->m_ExtKind = EXT_KIND_EXTMAP;
			return true;
		}

		ext += _T(";");

		// OA[JCo-
		param = m_pFmParam->m_sToolExtArchiver;
		param.MakeUpper();
		int r = param.Find(ext);
		if ( r >= 0 ) {
			if ( m_pFmParam->m_sToolExtArchiver != _T("") ) {
				m_pFmParam->m_ExtKind = EXT_KIND_ARCHIVER;
			}
		}

		// uEUt@C
		s = m_pFmParam->m_sToolBrowser;
		if ( s != _T("") ) {
			param = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolExtBrowser);
			param.MakeUpper();
			r = param.Find(ext);
			if ( r >= 0 ) {
				m_pFmParam->m_ExtKind = EXT_KIND_HTML;
			}
		}

		// t@C
		param = m_pFmParam->m_sExtentionsSound;
		param.MakeUpper();
		r = param.Find(ext);
		if ( r >= 0 ) {
			m_pFmParam->m_ExtKind = EXT_KIND_SOUND;
		}

		// st@C
		param = m_pFmParam->m_sExtentionsRun;
		param.MakeUpper();
		r = param.Find(ext);
		if ( r >= 0 ) {
			m_pFmParam->m_ExtKind = EXT_KIND_EXE;
		}

		// t@C
		param = m_pFmParam->m_sToolExtMoviePlayer;
		param.MakeUpper();
		r = param.Find(ext);
		if (r >= 0) {
			m_pFmParam->m_ExtKind = EXT_KIND_MOVIE;
		}

		if (m_pFmParam->m_ExtKind == NULL) {
			m_pFmParam->m_ExtKind = EXT_KIND_VIEW;
			return false;
		}
	} else {
		m_pFmParam->m_ExtKind = EXT_KIND_VIEW;
		return false;	// gqȂꍇreturn
	}


	return true;
}


// w肳ꂽtH_̃t@CSĕύX
void CFileView::SetAttributeAllFile(CString dirname, DWORD attr, BOOL noChangeDir)
{
	struct _wfinddata64_t c_file;
	intptr_t hFile;
	CString fpath, fn, mydir, parentdir, wCard, fullname;
	bool fdir = false;
	int at;
	CFileStatus rStatus;

	mydir = _T(".");
	parentdir = _T("..");

	wCard = _T("\\*.*");
	fpath = dirname + wCard;

	if( (hFile = _wfindfirst64( fpath, &c_file )) != -1L ) {

		while( true ) {
			at = c_file.attrib;
			fn = c_file.name;
			fullname = dirname;
			fullname += _T("\\");
			fullname += c_file.name;
			if ( (at & _A_SUBDIR) != 0 ) {	// DIRȂ
				if  ( (fn != mydir) && (fn != parentdir) ) {
					if ( !noChangeDir ) {
						rStatus.m_attribute = attr;
						rStatus.m_mtime = 0;

						bool bErr = false;
						try
						{
							CFile::SetStatus(fullname, rStatus);
						}
						catch (CFileException* pEx)
						{
							CString s;
							s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fullname);
							MessageBox(s, _T("ANZXG["));
							pEx->Delete();
							bErr = true;
						}


//						CFile::SetStatus(fullname, rStatus);
					}
					SetAttributeAllFile(fullname, attr, noChangeDir);
				}
			} else {
				rStatus.m_attribute = attr;
				rStatus.m_mtime = 0;

				bool bErr = false;
				try
				{
					CFile::SetStatus(fullname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fullname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}

//				CFile::SetStatus(fullname, rStatus);
			}
			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose( hFile );
	}

}

// oCit@C̕ҏW
void CFileView::BinaryEditFile(void)
{
	CString fn, path, fname;
	CString tmp, tmp2, sEditor, sOption;

	CEditorDialog dlg;
	CFileStatus rStatus;

	sEditor = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolBinaryEditor);
	sOption = _T("");
	int n = sEditor.ReverseFind(_T('\"'));
	if (n > 0) {
		sOption = sEditor.Mid(n + 1);
		sEditor = sEditor.Mid(1, n - 1);
	}

	dlg.m_pFmParam = m_pFmParam;
	dlg.m_bBinaryEdit = true;

	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	tmp = _T("open");

	if (m_pFmParam->m_TagFileNum != 0) {
		int i;
		for (i = 0; i < m_pFmParam->m_FileNum; i++) {
			if (m_pFmParam->m_pMark[i]) {
				fname.Format(_T("%s \""), sOption);
//				fname = _T("\"");
				fname += path;
				fname += m_pFmParam->m_pw64FindData[i].name;
				fname += _T("\"");
				ShellExecute(this->m_hWnd, tmp, sEditor, fname, path, SW_SHOW);
//				ShellExecute(this->m_hWnd, tmp, m_pFmParam->m_sToolBinaryEditor, fname, path, SW_SHOW);
			}
		}
		return;
	}
	fname = path + m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	CFile::GetStatus(fname, rStatus);
	int at = rStatus.m_attribute;
	if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
		fn = _T("");
	}
	dlg.m_FileName = fn;

	INT_PTR id = dlg.DoModal();

	if (id == IDCANCEL) return;

	fname.Format( _T("%s \""), sOption );

//	fname = _T("\"");
	fname += path;
	fname += dlg.m_FileName;
	fname += _T("\"");

	ShellExecute(this->m_hWnd, tmp, sEditor, fname, path, SW_SHOW);
//	ShellExecute(this->m_hWnd, tmp, m_pFmParam->m_sToolBinaryEditor, fname, path, SW_SHOW);

}

// Rs[̌t@CAtH_łRs[tH_Ɠꂩǂ̃`FbN
// true:  false:łȂ
bool CFileView::CopyCheckSouceDest(CString sfile, CString dpath)
{
	bool br = false;

	CFileStatus rStatus;

	CFile::GetStatus(sfile, rStatus);

	int at = rStatus.m_attribute;
		if ((at & _A_SUBDIR) == 0) {	// DIRłȂ
			return br;
		}

	if ( sfile == dpath ) br = true;

	return br;
}

// t@C̕ʁEړ
void CFileView::CopyFile(bool move)
{

//	m_pFmParam->m_bRedrawFocus = false;

	if (m_pFmParam->m_TagFileNum == 0) {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if (s == _T("..")) return;
	}

	CCopyFileDialog dlg;
	CString sfile, dfile, dpath, tmp, tmp2, tmp3;
	int nTag;



	dlg.m_pFmParam = m_pFmParam;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;
	if (m_pFmParam->m_bEnableTreeWindow) {
		dlg.m_pTreeFrameWindow = m_pTreeFrameWindow;
	}


	m_pFmParam->m_CopySame = FALSE;
	m_pFmParam->m_CopyMove = move;
	m_pFmParam->m_CopyMode = COPY_NON;

	m_pFmParam->m_CopySourcePath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	if ( m_pFmParam->m_TagFileNum == 0 ) {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;

		m_pFmParam->m_CopyFileName = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		dlg.m_Filename = m_pFmParam->m_CopySourcePath;
		dlg.m_Filename += m_pFmParam->m_CopyFileName;
	} else {
		CString tmp;
		tmp = _T("%d̑Iꂽt@C");
		dlg.m_Filename.Format(tmp, m_pFmParam->m_TagFileNum);
	}

	GetAllCurDir();
	dlg.m_sCdirannsFM = m_sCdirannsFM;
	dlg.m_NumannsFM = m_nWndCount;

	dlg.m_DpathStatic = _T("ʐpX:");
	if ( move ) dlg.m_DpathStatic = _T("ړpX:");
	INT_PTR n = dlg.DoModal();
	if ( n != IDOK ) return;
	nTag = m_pFmParam->m_TagFileNum;

	dpath = dlg.m_DestPath;
	m_pFmParam->MakeFullPath(dpath);
	dpath = m_pFmParam->m_FullPath;
	m_pFmParam->m_CopyDestPath = dpath;
	if ( dpath.GetAt(dpath.GetLength() - 1) != CHAR_YEN ) {
		tmp = STR_YEN;
		m_pFmParam->m_CopyDestPath += tmp;
	}

	CFileStatus rStatus;
	if ( (dpath.GetLength() > 3) && !(CFile::GetStatus(dpath, rStatus)) ) {	// ʐtH_݂Ȃ
		tmp2 = _T("[ %s ]\r\nʐtH_݂܂B쐬܂H");
		tmp.Format(tmp2, dpath);
		tmp2 = _T("ʐtH_̍쐬");
		int id = MessageBox(tmp, tmp2,  MB_ICONWARNING | MB_YESNO);
		if ( id != IDYES ) return;
		if ( !m_pFmParam->MakeDirectory(dpath) ) {
			tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
			tmp.Format(tmp2, dpath);
			MessageBox(tmp, NULL,  MB_ICONERROR | MB_OK);
			return;
		}

	}

	CString fext;
	fext = _T(".hid");
	m_pFmParam->WriteHistoryFile(fext, dpath);
	m_pFmParam->m_bCancelCopy = false;

	if ( nTag == 0 ) {	// It@CȂ

		tmp = m_pFmParam->m_CopySourcePath;
		tmp += m_pFmParam->m_CopyFileName;
		bool br = CopyCheckSouceDest(tmp, dpath);
		if ( br ) {
			tmp2 = _T("[ %s ]\r\nʂ܂͈ړtH_Aʂ܂͈ړtH_ƓłB");
			tmp3.Format(tmp2, tmp);
			MessageBox(tmp3, NULL,  MB_ICONERROR | MB_OK);
			return;
		}

		m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
		m_pFmParam->m_pCopyInfoDlg = new CCopyInfoDialog;
		CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pFmParam->m_pCopyInfoDlg;
		m_pFmParam->m_pCopyInfoDlg->Create(IDD_COPY_INFO_DIALOG, this);
		cidlg->ShowWindow(SW_SHOW);
		tmp = _T("%d");
		tmp2.Format(tmp, 1);
		m_pFmParam->InsertComma(tmp2);
		tmp = _T("%16s / %16s");
		cidlg->m_FileNum.Format(tmp, tmp2, tmp2);
		int iret = m_pFmParam->CopyDirectory();
		if ( iret == 0 ) m_pFmParam->CopyOneFile();
		delete []m_pFmParam->m_pCopyBuff;
		m_pFmParam->m_pCopyInfoDlg->DestroyWindow();
		delete m_pFmParam->m_pCopyInfoDlg;

	} else {
		int nt = m_pFmParam->m_FileNum;
		int num = 1;
		m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
		m_pFmParam->m_pCopyInfoDlg = new CCopyInfoDialog;
		CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pFmParam->m_pCopyInfoDlg;
		m_pFmParam->m_pCopyInfoDlg->Create(IDD_COPY_INFO_DIALOG, this);
		cidlg->ShowWindow(SW_SHOW);

		for ( int n = 0; n < nt; n++ ) {
			if ( !m_pFmParam->m_pMark[n] ) continue;
			if ( cidlg->m_Cancel ) {
				m_pFmParam->m_bCancelCopy = true;
			}

			m_pFmParam->m_CopyFileName = m_pFmParam->m_pw64FindData[n].name;

			tmp = _T("%d");
			tmp2.Format(tmp, num);
			m_pFmParam->InsertComma(tmp2);
			tmp3.Format(tmp, nTag);
			m_pFmParam->InsertComma(tmp3);
			tmp = _T("%16s / %16s");
			cidlg->m_FileNum.Format(tmp, tmp2, tmp3);

			tmp = m_pFmParam->m_CopySourcePath;
			tmp += m_pFmParam->m_CopyFileName;
			bool br = CopyCheckSouceDest(tmp, dpath);
			if ( br ) {
				tmp2 = _T("[ %s ]\r\nʂ܂͈ړtH_Aʂ܂͈ړtH_ƓłB");
				tmp3.Format(tmp2, tmp);
				MessageBox(tmp3, NULL,  MB_ICONERROR | MB_OK);
			} else {
				int iret = m_pFmParam->CopyDirectory();
				if ( iret == 0 ) m_pFmParam->CopyOneFile();
				if ( iret == -1 ) break;
			}
			if ( m_pFmParam->m_CopyMode == -1 ) break;
			num++;
		}

		delete []m_pFmParam->m_pCopyBuff;
		m_pFmParam->m_pCopyInfoDlg->DestroyWindow();
		delete m_pFmParam->m_pCopyInfoDlg;

	}
	if ( m_pFmParam->m_nVoiceGuide != 0 ) Beep(BEEP_FREQ, BEEP_DURATION);

}

// t@C݃`FbN
bool CFileView::CheckExistFile(CString sDirName)
{
	bool r = false;

	struct _wfinddata64_t c_file;
	intptr_t hFile;
	CString fpath, fn, mydir, parentdir, wCard, fullname;
	int at;
	CFileStatus rStatus;

	mydir = _T(".");
	parentdir = _T("..");

	wCard = _T("\\*.*");
	fpath = sDirName + wCard;

	if ((hFile = _wfindfirst64(fpath, &c_file)) != -1L) {

		int n = 3;
		while (true) {

			at = c_file.attrib;
			fn = c_file.name;
			fullname = sDirName;
			fullname += _T("\\");
			fullname += c_file.name;
			if ((at & _A_SUBDIR) != 0) {	// DIRȂ
				if ((fn != mydir) && (fn != parentdir)) {
					r = true;
					break;
				}
			}
			else {
				r = true;
				break;
			}
			n--;
			if (n == 0) break;

			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose(hFile);
	}

	return r;
}

void CFileView::FilesMoveToRecycler(void)
{
	CString tmp, s, path, fn, fname;
	int fnum = m_pFmParam->m_FileNum;
	int tNum = m_pFmParam->m_TagFileNum;
	int dNum = tNum;

	m_pDelInfoDlg = new CDeleteInfoDialog;
	m_pDelInfoDlg->Create(IDD_DELETE_INFO_DIALOG, this);
	m_pDelInfoDlg->ShowWindow(SW_SHOW);
	CDeleteInfoDialog* didlg = (CDeleteInfoDialog*)m_pDelInfoDlg;

	CFileStatus rStatus;
	int at = rStatus.m_attribute;

	m_bStopDelete = false;
//	bool bErr = false;
	int nSize = 0;

	for (int i = 0; i < fnum; i++) {
		MSG aMsg;
		while (::PeekMessage(&aMsg, NULL, 0, 0, PM_REMOVE))
		{
			::TranslateMessage(&aMsg);
			::DispatchMessage(&aMsg);
		}

		if (didlg->m_Cancel) {
			tmp = _T("t@C̍폜𒆒f܂H");
			s = _T("f");
			int id = MessageBox(tmp, s, MB_YESNO);
			if (id == IDYES) {
				m_bStopDelete = true;
				break;
			}
			didlg->m_Cancel = false;
		}

		if (!(m_pFmParam->m_pMark[i])) continue;
		path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		fn = m_pFmParam->m_pw64FindData[i].name;
		fname = path + fn;
		at = m_pFmParam->m_pw64FindData[i].attrib;

		didlg->m_FileName = fn;
		didlg->m_SourcePath = path;
		CString fntmp;
		fntmp.Format(_T("%8d / %8d"), dNum, tNum);
		didlg->m_FileNum = fntmp;
		didlg->UpdateData(FALSE);

		dNum--;

		int n = fname.GetLength();
//		n = n * 2;
		n++;
		nSize += n;

	}

	nSize++;

	if (!m_bStopDelete) {

		WCHAR* cpFileNames;

		cpFileNames = new WCHAR[nSize];
		WCHAR* cp = cpFileNames;

		ZeroMemory(cp, nSize * 2);



		for (int i = 0; i < fnum; i++) {
			MSG aMsg;
			while (::PeekMessage(&aMsg, NULL, 0, 0, PM_REMOVE))
			{
				::TranslateMessage(&aMsg);
				::DispatchMessage(&aMsg);
			}

			if (didlg->m_Cancel) {
				tmp = _T("t@C̍폜𒆒f܂H");
				s = _T("f");
				int id = MessageBox(tmp, s, MB_YESNO);
				if (id == IDYES) {
					m_bStopDelete = true;
					break;
				}
				didlg->m_Cancel = false;
			}

			if (!(m_pFmParam->m_pMark[i])) continue;
			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			fn = m_pFmParam->m_pw64FindData[i].name;
			fname = path + fn;
			at = m_pFmParam->m_pw64FindData[i].attrib;

			didlg->m_FileName = fn;
			didlg->m_SourcePath = path;
			CString fntmp;
			fntmp.Format(_T("%8d / %8d"), dNum, tNum);
			didlg->m_FileNum = fntmp;
			didlg->UpdateData(FALSE);

			dNum--;

			int n = fname.GetLength();
			n++;

			wcscpy_s(cp, n, fname);

			cp += n;

		}

		*cp = 0;

		SHFILEOPSTRUCT fileOp;
		FILEOP_FLAGS flags = FOF_NOCONFIRMATION;

		fileOp.pFrom = cpFileNames;

		fileOp.hwnd = NULL;
		//	fileOp.hwnd = hwnd;
		fileOp.wFunc = FO_DELETE;
		fileOp.pTo = NULL;
		fileOp.fFlags = FOF_ALLOWUNDO | flags;
		fileOp.fAnyOperationsAborted = FALSE;
		fileOp.hNameMappings = NULL;
		fileOp.lpszProgressTitle = NULL;

		SHFileOperation(&fileOp);


		delete []cpFileNames;
	}

	m_pDelInfoDlg->DestroyWindow();
	delete m_pDelInfoDlg;
	m_bInitFileList = true;
	if (m_pFmParam->m_nVoiceGuide != 0) Beep(BEEP_FREQ, BEEP_DURATION);

}


// t@C̍폜
void CFileView::DeleteFile(void)
{
	m_pFmParam->m_bRedrawFocus = false;

	CString fname, fn, path;

	CDeleteFileDialog dlg;

	CFileStatus rStatus;

	fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	path = fname;

	if ( m_pFmParam->m_TagFileNum != 0 ) {
		int i;
		for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) break;
		}
		fname += m_pFmParam->m_pw64FindData[i].name;
		CString tmp;
		tmp = _T("%d̑Iꂽt@C");
		fn.Format(tmp, m_pFmParam->m_TagFileNum);
	} else {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;

		fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	}

	CFile::GetStatus(fname, rStatus);

	dlg.m_FileName = fn;
	dlg.m_Path = path;

	dlg.DoModal();

	if ( dlg.m_IdButton == -1 ) return;
	bool recycle = false;
	if ( dlg.m_IdButton == 0 ) recycle = true;

	m_bPerfectDelete = dlg.m_bPerfectDelete;

	m_pDelInfoDlg = new CDeleteInfoDialog;
	m_pDelInfoDlg->Create(IDD_DELETE_INFO_DIALOG, this);
	m_pDelInfoDlg->ShowWindow(SW_SHOW);
	CDeleteInfoDialog* didlg = (CDeleteInfoDialog*)m_pDelInfoDlg;

	int at = rStatus.m_attribute;

	m_bStopDelete = false;
	bool bErr = false;

	if ( m_pFmParam->m_TagFileNum == 0 ) {
		didlg->m_FileName = fn;
		didlg->m_SourcePath = path;
		didlg->m_FileNum = _T("1/1");
		didlg->UpdateData(FALSE);
		MSG aMsg;
		while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
		{
			::TranslateMessage( &aMsg );
			::DispatchMessage( &aMsg );
		}

		if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
			bool r = CheckExistFile(fname);
			bool rd = true;
			if (m_pFmParam->m_bSettingsDeleteDirWarning && r) {
				int id = MessageBox(_T("tH_ł͂܂񂪍폜Ă낵łH"), _T("tH_폜x"), MB_YESNO);
				if (id != IDYES) {
					rd = false;
				}

			}
			if (rd) {
				if (recycle) {
					m_pFmParam->MoveToRecycler(fname);
				}
				else {
					DeleteDir(fname, recycle);
				}
			}
		}
		else {
			if ( recycle ) {
				m_pFmParam->MoveToRecycler(fname);
			} else {
				CFile::GetStatus(fname, rStatus);
				rStatus.m_attribute = 0;
				rStatus.m_mtime = 0;

				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}

				CFile file;
				try
				{
					if ( !bErr ) {
						if ( m_bPerfectDelete ) PerfectDelete(fname);
						file.Remove(fname);
					}
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CI[vĂ܂!\n폜ł܂łB"), fname);
					MessageBox(s, _T("Lᔽ"));
					pEx->Delete();
				}
			}
		}
	} else {

		if (recycle) {
			m_pDelInfoDlg->DestroyWindow();
			delete m_pDelInfoDlg;

			FilesMoveToRecycler();

			m_bInitFileList = true;
			if (m_pFmParam->m_nVoiceGuide != 0) Beep(BEEP_FREQ, BEEP_DURATION);

			return;
		}


		CString tmp, s;
		int fnum = m_pFmParam->m_FileNum;
		int tNum = m_pFmParam->m_TagFileNum;
		int dNum = tNum;

		for ( int i = 0; i < fnum; i++ ) {
			MSG aMsg;
			while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
			{
				::TranslateMessage( &aMsg );
				::DispatchMessage( &aMsg );
			}

			if ( didlg->m_Cancel ) {
				tmp = _T("t@C̍폜𒆒f܂H");
				s = _T("f");
				int id = MessageBox(tmp, s, MB_YESNO);
				if ( id == IDYES ) {
					m_bStopDelete = true;
					break;
				}
				didlg->m_Cancel = false;
			}

			if ( !(m_pFmParam->m_pMark[i]) ) continue;
			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			fn = m_pFmParam->m_pw64FindData[i].name;
			fname = path + fn;
			at = m_pFmParam->m_pw64FindData[i].attrib;

			didlg->m_FileName = fn;
			didlg->m_SourcePath = path;
			CString fntmp;
			fntmp.Format(_T("%8d / %8d"), dNum, tNum);
			didlg->m_FileNum = fntmp;
			didlg->UpdateData(FALSE);

			dNum--;

			if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
				bool r = CheckExistFile(fname);
				bool rd = true;
				if (m_pFmParam->m_bSettingsDeleteDirWarning && r) {
					int id = MessageBox(_T("tH_ł͂܂񂪍폜Ă낵łH"), _T("tH_폜x"), MB_YESNOCANCEL);
					if (id != IDYES) {
						rd = false;
					}
					if (id == IDCANCEL) {
						rd = false;
						m_bStopDelete = true;
						didlg->m_Cancel = false;
						break;
					}

				}
				if (rd) DeleteDir(fname, recycle);
			} else {
				if ( recycle ) {
					m_pFmParam->MoveToRecycler(fname);
					MSG aMsg;
					while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
					{
						::TranslateMessage( &aMsg );
						::DispatchMessage( &aMsg );
					}
				} else {
					CFile::GetStatus(fname, rStatus);
					rStatus.m_attribute = 0;
					rStatus.m_mtime = 0;

					try
					{
						CFile::SetStatus(fname, rStatus);
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
						MessageBox(s, _T("ANZXG["));
						pEx->Delete();
						bErr = true;
					}

					CFile file;
					try
					{
						if ( !bErr ) {
							if ( m_bPerfectDelete ) PerfectDelete(fname);
							file.Remove(fname);
						}
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CI[vĂ܂!\n폜ł܂łB"), fname);
						MessageBox(s, _T("Lᔽ"));
						pEx->Delete();
//					   break;
					}
				}
			}

		}
	}
	m_pDelInfoDlg->DestroyWindow();
	delete m_pDelInfoDlg;
	m_bInitFileList = true;
	if ( m_pFmParam->m_nVoiceGuide != 0 ) Beep(BEEP_FREQ, BEEP_DURATION);
}

// t@C̊S폜
void CFileView::PerfectDelete(CString sFname)
{
	CFileStatus status;
	ULONGLONG fsize;

	CFile cfile;
	cfile.Open(sFname, CFile::modeReadWrite);


	cfile.GetStatus(status);
	fsize = status.m_size;

	unsigned char c = 0xff;

	while( fsize > 0 ) {
		cfile.Write(&c, 1);
//		cfile.Seek(1, CFile::current);
		fsize--;
	}

	cfile.Flush();

	cfile.Close();

}

// fBNg̍폜
void CFileView::DeleteDir(CString name, bool recycle)
{
	if ( m_bStopDelete ) return;

	struct _wfinddata64_t c_file;
	intptr_t hFile;
	CString fpath, fn, mydir, parentdir, wCard, fullname;
	int at;
	CFileStatus rStatus;

	mydir = _T(".");
	parentdir = _T("..");

	wCard = _T("\\*.*");
	fpath = name + wCard;

	if( (hFile = _wfindfirst64( fpath, &c_file )) != -1L ) {

		CDeleteInfoDialog* didlg = (CDeleteInfoDialog*)m_pDelInfoDlg;
		CString tmp, s;
		while( true ) {
			if ( m_bStopDelete ) break;
			MSG aMsg;
			while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
			{
				::TranslateMessage( &aMsg );
				::DispatchMessage( &aMsg );
			}

			if ( didlg->m_Cancel ) {
				tmp = _T("t@C̍폜𒆒f܂H");
				s = _T("f");
				int id = MessageBox(tmp, s, MB_YESNO);
				if ( id == IDYES ) {
					m_bStopDelete = true;
					break;
				}
				didlg->m_Cancel = false;
			}

			at = c_file.attrib;
			fn = c_file.name;
			fullname = name;
			fullname += _T("\\");
			fullname += c_file.name;
			if ( (at & _A_SUBDIR) != 0 ) {	// DIRȂ
				if  ( (fn != mydir) && (fn != parentdir) ) {
					DeleteDir(fullname, recycle);
				}
			} else {
				didlg->m_FileName = fn;
				didlg->m_SourcePath = name;
				didlg->UpdateData(FALSE);
				if ( recycle ) {
					m_pFmParam->MoveToRecycler(fullname);
					MSG aMsg;
					while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
					{
						::TranslateMessage( &aMsg );
						::DispatchMessage( &aMsg );
					}
				} else {
					CFile::GetStatus(fullname, rStatus);
					rStatus.m_attribute = 0;
					rStatus.m_mtime = 0;

					bool bErr = false;
					try
					{
						CFile::SetStatus(fullname, rStatus);
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fullname);
						MessageBox(s, _T("ANZXG["));
						pEx->Delete();
						bErr = true;
					}

					CFile file;
					try
					{
						if ( !bErr ) file.Remove(fullname);
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CI[vĂ܂!\n폜ł܂łB"), fullname);
						MessageBox(s, _T("Lᔽ"));
						pEx->Delete();
					}
				}
			}
			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose( hFile );
	}
	CFile::GetStatus(name, rStatus);
	rStatus.m_attribute = 0;
	rStatus.m_mtime = 0;

	bool bErr = false;
	try
	{
		CFile::SetStatus(name, rStatus);
	}
	catch (CFileException* pEx)
	{
		CString s;
		s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), name);
		MessageBox(s, _T("ANZXG["));
		pEx->Delete();
		bErr = true;
	}

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	SetCurrentDirectory(cpath);

	int r = RemoveDirectory(name);
	while (r == 0) {

		CFileErrorDialog edlg;
		edlg.m_FileName = name;
		edlg.m_sMessage = _T("tH_̍폜Ɏs܂!");
		int id;
		edlg.DoModal();
		id = edlg.m_ButtonId;
		if (id == -1) {	// cancel
			m_bStopDelete = true;
			return;
		}
		if (id == 0) {	// Ďs
			r = RemoveDirectory(name);
		}
		if (id == 1) {	// XLbv
			return;
		}

	}

}

// t@C̕ҏW
void CFileView::EditFile(void)
{
	CString fn, path, fname;
	CString tmp, tmp2, sEditor, sOption;

	CEditorDialog dlg;
	CFileStatus rStatus;

	sEditor = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolEditor);
	sOption = _T("");
	int n = sEditor.ReverseFind(_T('\"'));
	if (n > 0) {
		sOption = sEditor.Mid(n + 1);
		sEditor = sEditor.Mid(1, n - 1);
	}

	dlg.m_pFmParam = m_pFmParam;

	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	tmp = _T("open");

	if ( m_pFmParam->m_TagFileNum != 0 ) {

		int id = MessageBox(_T("It@CׂăGfB^ŊJ܂낵łH"), _T("t@C̕ҏW"),  MB_OKCANCEL);
		if (id == IDCANCEL) return;

		int i;
		for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if (m_pFmParam->m_pMark[i]) {
				fname.Format(_T("%s \""), sOption);
				//				fname = _T("\"");
				fname += path;
				fname += m_pFmParam->m_pw64FindData[i].name;
				fname += _T("\"");
				ShellExecute(this->m_hWnd, tmp, sEditor, fname, path, SW_SHOW);
//				ShellExecute(this->m_hWnd, tmp, m_pFmParam->m_sToolEditor, fname, path, SW_SHOW;
			}
		}
		return;
	}
	fname = path + m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	CFile::GetStatus(fname, rStatus);
	int at = rStatus.m_attribute;
	if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
		fn = _T("");
	}
	dlg.m_FileName = fn;

	INT_PTR id = dlg.DoModal();

	if ( id == IDCANCEL ) return;

	fname.Format(_T("%s \""), sOption);
//	fname = _T("\"");
	fname += path;
	fname += dlg.m_FileName;
	fname += _T("\"");

	ShellExecute(this->m_hWnd, tmp, sEditor, fname, path, SW_SHOW);
//	ShellExecute(this->m_hWnd, tmp, m_pFmParam->m_sToolEditor, fname, path, SW_SHOW);

}

// t@Č
void CFileView::FindFile(void)
{
	CFindFileDialog dlg;

	CString path;
	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	dlg.m_Path = path;
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	INT_PTR id = dlg.DoModal();

	if ( dlg.m_Move == true ) {
		int n;
		n = (int)dlg.m_FindPath.GetAt(0);
		n = n & 0x0f;
		n--;
		m_pFmParam->m_pDriveParam->m_pCurrentPath[n] = dlg.m_FindPath;
		ChangeDirectory(n, dlg.m_FindFileName);
//		m_pFmParam->m_bEnableMoveHistoryFile = false;
	}
}

// JgtH_̕ύX
void CFileView::MovePath(void)
{
	CMovePathDialog dlg;
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	dlg.m_Path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	INT_PTR id = dlg.DoModal();

	if ( id == IDOK ) {
		CString path;
		m_pFmParam->MakeFullPath(dlg.m_Path);
		path = m_pFmParam->m_FullPath;
		if ( path.GetAt(path.GetLength() - 1) != CHAR_YEN ) path += STR_YEN;

		CFileStatus rStatus;
		if ( !(CFile::GetStatus(path, rStatus)) || ((rStatus.m_attribute & _A_SUBDIR) == 0) ) {	// tH_݂Ȃ܂̓tH_łȂ
			CString s;
			s = _T("w肳ꂽpX͖ł");
			AfxMessageBox(s);
			return;
		} else {
			CString fext;
			fext = _T(".hid");
			m_pFmParam->WriteHistoryFile(fext, path);
//			m_pFmParam->m_PrevDirNo;

			CString parentPath;
			GetParentDir(path, parentPath);

			int drive;
			CString sd;
			sd = path.Left(2);
			sd.MakeUpper();

//			m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

			if ( sd.GetAt(0) <= _T('Z') ) {
				drive = sd.GetAt(0) - 0x41;
				m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
			} else {
				drive = -1;
				for ( int i = 26; i < MAXDRIVE; i++ ) {
					BOOL b;
					b = m_pFmParam->m_pDriveParam->m_pExist[i];
					if ( b == FALSE ) {
						drive = i;
						break;
					}
				}
				if ( drive == -1 ) drive = MAXDRIVE - 1;
				m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
				m_pFmParam->m_pDriveParam->m_pUncRootPath[drive] = path;
				m_pFmParam->m_pDriveParam->m_pExist[drive] = TRUE;
				m_pFmParam->m_pDriveParam->m_pType[drive] = DRIVE_REMOTE;
				m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
			}
			ChangeDirectory(drive);
		}

			m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	}
	
}

// fBNg̍쐬
void CFileView::MakeDir(void)
{
	CMakeDirDialog dlg;
	dlg.m_pFmParam = m_pFmParam;
	
	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

		
	dlg.m_sCurDir = cpath;

	INT_PTR id = dlg.DoModal();

	if ( id == IDOK ) {
		CString path;
		m_pFmParam->MakeFullPath(dlg.m_Path);
		path = m_pFmParam->m_FullPath;

		CFileStatus rStatus;
		if (CFile::GetStatus(path, rStatus)) {	// tH_܂̓t@C݂
			MessageBox(_T("͂ꂽtH_͊̃t@C܂̓tH_łB"), MB_OK);
			return;
		}

		bool r = m_pFmParam->MakeDirectory(path);
		if ( r ) {
			CString fext;
			fext = _T(".hid");
			m_pFmParam->ReadHistoryFile(fext, NULL);
			m_pFmParam->WriteHistoryFile(fext, path);
			int n = path.ReverseFind(CHAR_YEN) + 1;
			int l = path.GetLength() - n;
			CString s = path.Right(l);
			UpdateFileList();


				int max = m_pFmParam->m_FileNum;
				for ( int n = 0; n < max; n++ ) {
					CString cf;
					cf = m_pFmParam->m_pw64FindData[n].name;
					if ( s == cf ) {
						m_CurrentFileNo = n;
						Invalidate();

						break;
					}
				}

		}
	}
}

// hCȗI
void CFileView::SelectDrive(void)
{
	CSelectDriveDialog dlg;

	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	INT_PTR id = dlg.DoModal();

	if ( id == IDOK ) {
//		m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);
		int dn;
		dn = dlg.m_sDriveName.GetAt(0) - 0x41;
		ChangeDirectory(dn);

		m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	}
}

	typedef BOOL (WINAPI* LPFNCOMPRESS)( HWND, LPCSTR, LPSTR, DWORD );
	typedef BOOL (WINAPI* LPUNRAR)( BOOL );
	typedef BOOL (WINAPI* LPUNRARCOMPRESS)(HWND, char*, LPSTR, DWORD);
	typedef BOOL (WINAPI* LPUNRARCHECKARCHIVE)(LPCSTR, const int);

//	BOOL WINAPI UnrarCheckArchive(LPCSTR szFileName, const int iMode);

// kt@C̉(1t@C)
bool CFileView::UnPackOneFile(CString fn, CString dpath, bool withPath, CString sSpath)
{
		CString sDllFname, fname;

		sDllFname = _T("");

		m_pFmParam->DivideFileName(fn);
		CString sext = m_pFmParam->m_sExt;
		sext.MakeUpper();

		CString path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		if ( sSpath != _T("") ) path = sSpath;
		fname = path;
		fname += fn;

		LPSTR lpBuffer = new CHAR [32768];
		LPSTR cfname = new CHAR[1000];
		LPSTR cpath = new CHAR[1000];
		LPSTR lpProc = new char[100];

		strncpy_s(cfname, 1000, CW2A(fname), _TRUNCATE);
		strncpy_s(cpath, 1000, CW2A(dpath), _TRUNCATE);

		CStringA sComm;

		if ( sext == ".LZH" ) {
			sDllFname = _T("UNLHA32.DLL");
			strcpy_s(lpProc, 20, "Unlha");
			if ( withPath ) sComm.Format("x -c1m0a1 -jf0 -p2 \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("e -c1m0a1 -p2 \"%s\" \"%s\"", cfname, cpath);
		}

		if ( sext == ".ZIP" ) {
			bool wp = withPath;
/*
			if ( m_pFmParam->m_bToolUseLMZIP32 ) {
				sDllFname = _T("LMZIP32.DLL");
				strcpy_s(lpProc, 20, "Unzip");
			} else {
				sDllFname = _T("UNZIP32.DLL");
				strcpy_s(lpProc, 20, "UnZip");
				wp = !wp;
			}
*/
			if ( m_pFmParam->m_nToolZipDll == 0 ) {
				sDllFname = _T("LMZIP32.DLL");
				strcpy_s(lpProc, 20, "Unzip");
			}

			if ( m_pFmParam->m_nToolZipDll == 1 ) {
				sDllFname = _T("UNZIP32.DLL");
				strcpy_s(lpProc, 20, "UnZip");
				wp = !wp;
			}
			if ( wp ) sComm.Format("-j \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("\"%s\" \"%s\"", cfname, cpath);

			if ( m_pFmParam->m_nToolZipDll == 2 ) {
				sDllFname = _T("7-ZIP32.DLL");
				strcpy_s(lpProc, 20, "SevenZip");
				if ( withPath ) sComm.Format("x \"%s\" \"%s\"", cfname, cpath);
				else sComm.Format("e \"%s\" \"%s\"", cfname, cpath);
			}

		}

		if ( sext == ".ARJ" ) {
			sDllFname = _T("UNARJ32J.DLL");
			strcpy_s(lpProc, 20, "Unarj");
			if ( withPath ) sComm.Format("x \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("e \"%s\" \"%s\"", cfname, cpath);
		}

		if ( sext == ".CAB" ) {
			sDllFname = _T("CAB32.DLL");
			strcpy_s(lpProc, 20, "Cab");
			if ( withPath ) sComm.Format("-x -j \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("-x \"%s\" \"%s\"", cfname, cpath);
		}

		CString stext = m_pFmParam->m_sToolExtTar;
		stext.MakeUpper();

		if (stext.Find(sext) >= 0) {
			sDllFname = _T("TAR32.DLL");
			strcpy_s(lpProc, 20, "Tar");
			if (withPath) sComm.Format("--check-all-path=1 -xvf \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("--check-all-path=1 --use-directory=0 -xvf \"%s\" \"%s\"", cfname, cpath);
		}

		/*
		if ( sext == ".TAR" ) {
			sDllFname = _T("TAR32.DLL");
			strcpy_s(lpProc, 20, "Tar");
			if ( withPath ) sComm.Format("--check-all-path=1 -xvf \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("--check-all-path=1 --use-directory=0 -xvf \"%s\" \"%s\"", cfname, cpath);
		}
		*/

		if ( sext == ".RAR" ) {
			sDllFname = _T("UNRAR32.DLL");
			strcpy_s(lpProc, 20, "Unrar");
			if ( withPath ) sComm.Format("-x \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("-e \"%s\" \"%s\"", cfname, cpath);
		}

		if ( sext == ".GCA" ) {
			sDllFname = _T("UnGCA32.DLL");
			strcpy_s(lpProc, 20, "UnGCA");
			if ( withPath ) sComm.Format("e -xx1 \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("e -xx0 \"%s\" \"%s\"", cfname, cpath);
		}

		if ( sext == ".GZA" || sext == ".BZA" ) {
			sDllFname = _T("Bga32.DLL");
			strcpy_s(lpProc, 20, "Bga");
			if ( withPath ) sComm.Format("x -a \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("x -a -j \"%s\" \"%s\"", cfname, cpath);
		}

		if ( sext == ".YZ1" ) {
			sDllFname = _T("YZ1.DLL");
			strcpy_s(lpProc, 20, "Yz1");
			if ( withPath ) sComm.Format("x -x1 \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("x -x0 \"%s\" \"%s\"", cfname, cpath);
		}

		if ( sext == ".7Z" ) {
			sDllFname = _T("7-ZIP32.DLL");
			strcpy_s(lpProc, 20, "SevenZip");
			if ( withPath ) sComm.Format("x \"%s\" \"%s\"", cfname, cpath);
			else sComm.Format("e \"%s\" \"%s\"", cfname, cpath);
		}

		bool b = false;
		if ( sDllFname != _T("") ) {
//			HINSTANCE hInstance = LoadLibrary( sDllFname );

			DWORD flag = 0xa00;
			SetDllDirectory(_T(""));
			HINSTANCE hInstance = LoadLibraryEx(sDllFname, 0, flag);

			if ( hInstance )
			{
				if ( sext == ".RAR" ) {
					sDllFname = _T("UNRAR32.DLL");

					strcpy_s(lpProc, 100, "UnrarSetUnicodeMode");

					LPUNRAR lpExe
						= (LPUNRAR)GetProcAddress( hInstance, lpProc );

					if ( lpExe )
					{
						int nStatus = lpExe( TRUE );

						CString comm;
						strcpy_s(lpProc, 20, "Unrar");
						if ( withPath ) comm.Format(_T("-x \"%s\" \"%s\""), fname, dpath);
						else comm.Format(_T("-e \"%s\" \"%s\""), fname, dpath);

//						CStringW utf16(tchar);
 
						// ----------------------------------------
						// Convert Unicode(UTF-16) to UTF-8.
						// Unicode(UTF-16)UTF-8ɕϊ
						// ----------------------------------------
						// First, get the size of the buffer to store UTF-8 chars.
						// ܂AUTF-8i[obt@TCY擾
						INT bufsize = ::WideCharToMultiByte(CP_UTF8, 0, comm, -1, NULL, 0, NULL, NULL);
						CHAR* utf8 = new CHAR[bufsize];
 
						// Then, convert Unicode to UTF-8.
						// UnicodeUTF-8ɕϊ
//						::WideCharToMultiByte(CP_UTF8, 0, utf16, -1, utf8, bufsize, NULL, NULL);
						::WideCharToMultiByte(CP_UTF8, 0, comm, -1, utf8, bufsize, NULL, NULL);
 

						LPUNRARCOMPRESS lpUnraraExecute
							= (LPUNRARCOMPRESS)GetProcAddress( hInstance, lpProc );

						if ( lpUnraraExecute )
						{
							HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
//							int nStatus = lpUnraraExecute( hWnd, comm, lpBuffer, 32768 );
							int nStatus = lpUnraraExecute( hWnd, utf8, lpBuffer, 32768 );
							b = true;

						}
						delete [] utf8;
					} else {

						strcpy_s(lpProc, 20, "Unrar");
						if ( withPath ) sComm.Format("-x \"%s\" \"%s\"", cfname, cpath);
						else sComm.Format("-e \"%s\" \"%s\"", cfname, cpath);

						LPFNCOMPRESS lpfnExecute
							= (LPFNCOMPRESS)GetProcAddress( hInstance, lpProc );

						if ( lpfnExecute )
						{
							HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
							int nStatus = lpfnExecute( hWnd, sComm, lpBuffer, 32768 );
							b = true;

						}
					}
				} else {

					LPFNCOMPRESS lpfnExecute
						= (LPFNCOMPRESS)GetProcAddress( hInstance, lpProc );

					if ( lpfnExecute )
					{
						HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
						int nStatus = lpfnExecute( hWnd, sComm, lpBuffer, 32768 );
						b = true;

					}
				}

				FreeLibrary( hInstance );
			}
		}

		delete [] lpBuffer;
		delete [] cfname;
		delete [] cpath;
		delete [] lpProc;

		return b;

}

// kt@C̉
void CFileView::UnPackFile(void)
{

	CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	CString fname = fn;
	CString tmp;

	if ( m_pFmParam->m_TagFileNum != 0 ) {
		int i;
		for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) break;
		}
		tmp = _T("%d̑Iꂽt@C");
		fname.Format(tmp, m_pFmParam->m_TagFileNum);
	} else {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;
	}

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;

	sSection = INISECTION_SETTINGS;


	CUnPackDialog dlg;
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_sFileName = fname;
	dlg.m_sPath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	sEntry = INIENTRY_SETTINGS_UNPACK_MAKEDIR;
	int n = pApp->GetProfileInt(sSection, sEntry, 0);
	dlg.m_bCheckMakeDir = (n != 0);

	sEntry = INIENTRY_SETTINGS_UNPACK_MOVEDIR;
	n = pApp->GetProfileInt(sSection, sEntry, 0);
	dlg.m_bCheckMovedir = (n != 0);

	int r = dlg.DoModal();

	bool bCheckMakeDir = dlg.m_bCheckMakeDir;

	CString dpath = dlg.m_sPath;


	if ( dlg.m_sPath != _T("") ) {
		bool b = m_pFmParam->MakeFullPath(dpath);
		if ( b == false ) {
			tmp = _T("𓀐pX܂");
			MessageBox(tmp);
			return;
		} else {
			dpath = m_pFmParam->m_FullPath;
			dpath += _T("\\");
			CFileStatus rStatus;
			if ( !(CFile::GetStatus(dpath, rStatus)) ) {
				CString tmp2 = _T("[ %s ]\r\n𓀐tH_݂܂B쐬܂H");
				tmp.Format(tmp2, dpath);
				tmp2 = _T("𓀐tH_̍쐬");
				int id = MessageBox(tmp, tmp2,  MB_ICONWARNING | MB_YESNO);
				if ( id != IDYES ) return;

				if ( !m_pFmParam->MakeDirectory(dpath) ) {
					tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
					tmp.Format(tmp2, dpath);
					MessageBox(tmp, NULL,  MB_ICONERROR | MB_OK);
					return;
				}

			}
		}
	} else dpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];



	if ( r == IDOK ) {

		bool b;
		b = dlg.m_bWithPath;
		CString sDpath = dpath;

		if ( m_pFmParam->m_TagFileNum != 0 ) {
			int i;
			for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
				if ( m_pFmParam->m_pMark[i] ) {


					fn = m_pFmParam->m_pw64FindData[i].name;



					if ( bCheckMakeDir ) {
						CString s, tmp2;
						s = _T("");
						int pn = fn.ReverseFind(_T('.'));
						if ( pn > 0 ) {
							s = fn.Left(pn);
							s += _T("\\");
							dpath = sDpath + s;

							CFileStatus rStatus;
							if (!(CFile::GetStatus(dpath, rStatus))) {
								if (!m_pFmParam->MakeDirectory(dpath)) {
									tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
									tmp.Format(tmp2, dpath);
									MessageBox(tmp, NULL, MB_ICONERROR | MB_OK);
									return;
								}
							}

						}
					}


					r = UnPackOneFile( fn, dpath, b );
					if ( !r ) {
						CString smes;
						smes.Format(_T("[ %s ]\nɃt@Cł͂܂!"), fn);
						MessageBox(smes);
					}
				}
			}
		} else {
			if ( bCheckMakeDir ) {
				CString s, tmp2;
				s = _T("");
				int pn = fn.ReverseFind(_T('.'));
				if ( pn > 0 ) {
					s = fn.Left(pn);
					s += _T("\\");
					dpath = sDpath + s;

					CFileStatus rStatus;
					if (!(CFile::GetStatus(dpath, rStatus))) {
						if (!m_pFmParam->MakeDirectory(dpath)) {
							tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
							tmp.Format(tmp2, dpath);
							MessageBox(tmp, NULL, MB_ICONERROR | MB_OK);
							return;
						}
					}

				}
			}
			r = UnPackOneFile( fn, dpath, b );
		}

		if ( r ) {
			CString fext;
			fext = _T(".hid");
			m_pFmParam->WriteHistoryFile(fext, dpath);
			UpdateFileList();
			if ( dlg.m_bCheckMovedir ) {
				if ( m_pFmParam->m_TagFileNum != 0 ) CmdMacroMovePath(sDpath);
				else CmdMacroMovePath(dpath);

			}
			sEntry = INIENTRY_SETTINGS_UNPACK_MAKEDIR;
			pApp->WriteProfileInt(sSection, sEntry, dlg.m_bCheckMakeDir);

			sEntry = INIENTRY_SETTINGS_UNPACK_MOVEDIR;
			pApp->WriteProfileInt(sSection, sEntry, dlg.m_bCheckMovedir);

		} else {
			CString smes;
			smes.Format(_T("[ %s ]\nɃt@Cł͂܂!"), fn);
			MessageBox(smes);
		}
	}
}

// t@C̈k(1t@C)
void CFileView::PackOneFile(CString fnpack, CString sfname, bool withPath, bool bWithPass)
{
		CString sDllFname, fname, path;

		path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		m_pFmParam->DivideFileName(fnpack);
		CString sext = m_pFmParam->m_sExt;
		sext.MakeUpper();


		LPSTR lpBuffer = new CHAR [32768];
		LPSTR pfn = new CHAR[1000];
		LPSTR sfn = new CHAR[1000];
		LPSTR sdir = new CHAR[1000];
		LPSTR lpProc = new char[20];

		strncpy_s(pfn, 1000, CW2A(fnpack), _TRUNCATE);
		strncpy_s(sfn, 1000, CW2A(sfname), _TRUNCATE);
		strncpy_s(sdir, 1000, CW2A(path), _TRUNCATE);

		CStringA sComm;

		if ( sext == ".LZH" ) {
			sDllFname = _T("UNLHA32.DLL");
			strcpy_s(lpProc, 20, "Unlha");
			if ( withPath ) sComm.Format("a -x1 -r2a2 -d \"%s\" \"%s\" \"%s\"", pfn, sdir, sfn);
			else sComm.Format("a -r2a1 \"%s\" \"%s\" \"%s\"", pfn, sdir, sfn);
		}
		if ( sext == ".ZIP" ) {	// -0`9 k
			sDllFname = _T("LMZIP32.DLL");
			strcpy_s(lpProc, 20, "Zip");
			CStringA saOpt;
			saOpt = "";
			if ( bWithPass ) saOpt = " -e ";
			if ( !withPath ) sComm.Format("-ru -j -S -%1d %s\"%s\" \"%s\" \"%s\"", m_pFmParam->m_nPackRate, saOpt,pfn, sdir, sfn);
			else sComm.Format("-ru -S -%1d %s\"%s\" \"%s\" \"%s\"", m_pFmParam->m_nPackRate, saOpt, pfn, sdir, sfn);
		}

		if ( sext == ".CAB" ) {

			sDllFname = _T("CAB32.DLL");
			strcpy_s(lpProc, 20, "Cab");
			sComm.Format("-a -mz \"%s\" \"%s\" \"%s\"", pfn, sdir, sfn);

		}


		if ( sext == ".7Z" ) {	// -mx=9 k
			sDllFname = _T("7-zip32.DLL");
			strcpy_s(lpProc, 20, "SevenZip");

			CStringA saOpt;
			saOpt = "";
			if ( bWithPass ) {
				CInputPasswordDialog dlg;
				int r = dlg.DoModal();
				if ( r == IDOK ) {
					CString sp = dlg.m_sPasswordEdit;
					CStringA ssA = CW2A(sp.GetBuffer());
					saOpt.Format("-p%s -mhe", ssA);
				}
			}

			sComm.Format("a -t7z -mx=%1d \"%s\" %s \"%s\" \"%s\" -ms=off", m_pFmParam->m_nPackRate7, pfn, saOpt, sdir, sfn);
		}

//		HINSTANCE hInstance = LoadLibrary( sDllFname );

		DWORD flag = 0xa00;
		SetDllDirectory(_T(""));
		HINSTANCE hInstance = LoadLibraryEx(sDllFname, 0, flag);

		if ( hInstance )
		{
			LPFNCOMPRESS lpfnExecute
				= (LPFNCOMPRESS)GetProcAddress( hInstance, lpProc );

			if ( lpfnExecute )
			{
				HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
				int nStatus = lpfnExecute( hWnd, sComm, lpBuffer, 32768 );

			}
		}
		delete [] lpBuffer;
		delete [] pfn;
		delete [] sfn;
		delete [] sdir;
		delete [] lpProc;
		FreeLibrary( hInstance );
}

// t@C̈k(X|Xt@C)
// fnpack:kt@C
// sResf:X|Xt@C
// bWithPath:pXtĈk
// bWithPass:pX[htňk
void CFileView::PackResponceFile(CString fnpack, CString sResf, bool bWithPath, bool bWithPass)
{
	CString sDllFname, sfname, s, cpath;

	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	m_pFmParam->DivideFileName(fnpack);
	CString sext = m_pFmParam->m_sExt;
	sext.MakeUpper();

	LPSTR lpBuffer = new CHAR [32768];
	LPSTR pfn = new CHAR[1000];
	LPSTR sfn = new CHAR[1000];
	LPSTR lpProc = new char[20];
	LPSTR scp = new CHAR[1000];

	strncpy_s(pfn, 1000, CW2A(fnpack), _TRUNCATE);
	strncpy_s(sfn, 1000, CW2A(sResf), _TRUNCATE);
	strncpy_s(scp, 1000, CW2A(cpath), _TRUNCATE);

	CStringA sComm;
	bool wp = bWithPath;

		if ( sext == ".LZH" ) {
			sDllFname = _T("UNLHA32.DLL");
			strcpy_s(lpProc, 20, "Unlha");
			if ( wp ) sComm.Format("a -x1 -r2a2 -d \"%s\" \"%s\" \"@%s\"", pfn, scp, sfn);
			else sComm.Format("a -r2a1 \"%s\"  \"%s\" \"@%s\"", pfn, scp, sfn);
		}
		if ( sext == ".ZIP" ) {
			sDllFname = _T("LMZIP32.DLL");
			strcpy_s(lpProc, 20, "Zip");
			CStringA saOpt;
			saOpt = "";
			if ( bWithPass ) saOpt = " -e ";
			if ( !wp ) sComm.Format("-ru -j -S -%1d %s\"%s\" \"%s\" \"@%s\"", m_pFmParam->m_nPackRate, saOpt, pfn, scp, sfn);
			else sComm.Format("-ru -S -%1d %s\"%s\" \"%s\" \"@%s\"", m_pFmParam->m_nPackRate, saOpt, pfn, scp, sfn);
		}

		if ( sext == ".CAB" ) {
			sDllFname = _T("CAB32.DLL");
			strcpy_s(lpProc, 20, "Cab");
			sComm.Format("-a \"%s\" \"%s\" \"@%s\"", pfn, scp, sfn);
		}

		if ( sext == ".7Z" ) {
			sDllFname = _T("7-zip32.DLL");
			strcpy_s(lpProc, 20, "SevenZip");

			CStringA saOpt;
			saOpt = "";
			if ( bWithPass ) {
				CInputPasswordDialog dlg;
				int r = dlg.DoModal();
				if ( r == IDOK ) {
					CString sp = dlg.m_sPasswordEdit;
					CStringA ssA = CW2A(sp);
					saOpt.Format("-p%s -mhe", ssA);
				}
			}

			sComm.Format("a -t7z -mx=%1d \"%s\" %s \"%s\" \"@%s\" -ms=off", m_pFmParam->m_nPackRate7, pfn, saOpt, scp, sfn);
		}

//		HINSTANCE hInstance = LoadLibrary( sDllFname );

		DWORD flag = 0xa00;
		SetDllDirectory(_T(""));

		HINSTANCE hInstance = LoadLibraryEx(sDllFname, 0, flag);

		if ( hInstance )
		{
			LPFNCOMPRESS lpfnExecute
				= (LPFNCOMPRESS)GetProcAddress( hInstance, lpProc );

			if ( lpfnExecute )
			{
				HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
				int nStatus = lpfnExecute( hWnd, sComm, lpBuffer, 32768 );

			}
		}
		delete [] scp;
		delete [] lpBuffer;
		delete [] pfn;
		delete [] sfn;
		delete [] lpProc;
		FreeLibrary( hInstance );
}

// t@C̈k
void CFileView::PackFile(void)
{

	CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
	CString fname = fn;
	CString tmp;

	if ( m_pFmParam->m_TagFileNum != 0 ) {
		int i;
		for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) {
				fn = m_pFmParam->m_pw64FindData[i].name;
				break;
			}
		}
		tmp = _T("%d̑Iꂽt@C");
		fname.Format(tmp, m_pFmParam->m_TagFileNum);
	} else {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;
	}

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;

	sSection = INISECTION_SETTINGS;
	sEntry = INIENTRY_SETTINGS_PACK_ARCHIVER;

	m_pFmParam->m_nPackArchiver = pApp->GetProfileInt(sSection, sEntry, 0);

	sEntry = INIENTRY_SETTINGS_PACK_RATE;

	m_pFmParam->m_nPackRate = pApp->GetProfileInt(sSection, sEntry, 6);

	sEntry = INIENTRY_SETTINGS_PACK_RATE7;
	m_pFmParam->m_nPackRate7 = pApp->GetProfileInt(sSection, sEntry, 3);


	CPackDialog dlg;
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_sSFile = fname;
	dlg.m_sPath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	dlg.m_iArcType = m_pFmParam->m_nPackArchiver;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;
	dlg.m_nRate = m_pFmParam->m_nPackRate;
	dlg.m_nRate7 = m_pFmParam->m_nPackRate7;

//	m_pFmParam->DivideFileName(fn);
//	CString pfile = m_pFmParam->m_sName;
//	dlg.m_sFileName = pfile;
	dlg.m_sFileName = fn;

	int r = dlg.DoModal();

	m_pFmParam->m_nPackArchiver = dlg.m_iArcType;

	CString dpath = dlg.m_sPath;
	if ( dlg.m_sPath != _T("") ) {
		bool b = m_pFmParam->MakeFullPath(dpath);
		if ( b == false ) {
			tmp = _T("ɍ쐬pX܂");
			MessageBox(tmp);
			return;
		} else {
			dpath = m_pFmParam->m_FullPath;
			dpath += _T("\\");
			CFileStatus rStatus;
			if ( !(CFile::GetStatus(dpath, rStatus)) ) {
				CString tmp2 = _T("[ %s ]\r\nɍ쐬tH_݂܂B쐬܂H");
				tmp.Format(tmp2, dpath);
				tmp2 = _T("ɍ쐬tH_̍쐬");
				int id = MessageBox(tmp, tmp2,  MB_ICONWARNING | MB_YESNO);
				if ( id != IDYES ) return;
				if ( !m_pFmParam->MakeDirectory(dpath) ) {
					tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
					tmp.Format(tmp2, dpath);
					MessageBox(tmp, NULL,  MB_ICONERROR | MB_OK);
					return;
				}

			}
		}
	} else dpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];


	if ( r == IDOK ) {

		m_pFmParam->m_nPackRate = dlg.m_nRate;
		m_pFmParam->m_nPackRate7 = dlg.m_nRate7;

		bool m_bObject;
		m_bObject = dlg.m_bObjectCheck;

		CString fext;
		fext = _T(".hid");
		m_pFmParam->WriteHistoryFile(fext, dpath, true);

		CString fnpack = dpath;
		fnpack += dlg.m_sFileName;
		CString sfname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		sfname += fn;

		bool bWithPath = dlg.m_bWithPath;
		bool bWithPass = dlg.m_bWithPass;

		m_pFmParam->DivideFileName(fnpack);
		CString sext = m_pFmParam->m_sExt;
		sext.MakeUpper();

		if ( m_pFmParam->m_TagFileNum != 0 ) {

			if (m_bObject) {



				CString sComm, path;
				int i;

				path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				bool wp = bWithPath;

				for (i = 0; i < m_pFmParam->m_FileNum; i++) {
					if (m_pFmParam->m_pMark[i]) {

						CString sResf;
						tmp = RESPONCE_FILE_NAME;
						sResf = m_pFmParam->GetExePath(tmp);
						setlocale(LC_ALL, ".ACP");
						CStdioFile cfile;
						if (!cfile.Open(sResf, CFile::modeWrite | CFile::modeCreate)) {
							tmp.Format(_T("[ %s ]\nX|Xt@C̍쐬Ɏs܂!"));
							MessageBox(tmp, _T("I[vG["));
							return;
						}


						sfname = m_pFmParam->m_pw64FindData[i].name;
						fn = sfname;
						int at = m_pFmParam->m_pw64FindData[i].attrib;
						if (sext == _T(".CAB")) {
							if ((at & _A_SUBDIR) != 0) {
								sfname += STR_YEN;
								sfname += _T("*.*");
							}
						}
						if (sext == _T(".7Z")) {
							if ((at & _A_SUBDIR) != 0) {

								sComm.Format(_T("\"%s\\*\""), sfname);
								sComm += _T("\n");
								cfile.WriteString(sComm);

								sfname += STR_YEN;

							}
						}

						sComm.Format(_T("\"%s\""), sfname);
						sComm += _T("\n");

						cfile.WriteString(sComm);

						cfile.Close();

						CString se = sext;
						se.MakeLower();

						fnpack = dpath;

						CString ofn = fn;
						if (dlg.m_bNameOnlyCheck) {
							int nf = fn.ReverseFind(_T('.'));
							int len = fn.GetLength();
							if (nf > 0) {
								ofn = fn.Left(nf);
							}

						}

						fnpack += ofn;
						fnpack += se;

						PackResponceFile(fnpack, sResf, wp, bWithPass);
					}
				}

			}
			else {
				CString sResf;
				tmp = RESPONCE_FILE_NAME;
				sResf = m_pFmParam->GetExePath(tmp);
				setlocale(LC_ALL, ".ACP");
				CStdioFile cfile;
				if (!cfile.Open(sResf, CFile::modeWrite | CFile::modeCreate)) {
					tmp.Format(_T("[ %s ]\nX|Xt@C̍쐬Ɏs܂!"));
					MessageBox(tmp, _T("I[vG["));
					return;
				}


				CString sComm, path;
				int i;

				path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				bool wp = bWithPath;

				for (i = 0; i < m_pFmParam->m_FileNum; i++) {
					if (m_pFmParam->m_pMark[i]) {
						sfname = m_pFmParam->m_pw64FindData[i].name;
						int at = m_pFmParam->m_pw64FindData[i].attrib;
						if (sext == _T(".CAB")) {
							if ((at & _A_SUBDIR) != 0) {
								sfname += STR_YEN;
								sfname += _T("*.*");
							}
						}
						if (sext == _T(".7Z")) {
							if ((at & _A_SUBDIR) != 0) {

								sComm.Format(_T("\"%s\\*\""), sfname);
								sComm += _T("\n");
								cfile.WriteString(sComm);

								sfname += STR_YEN;

							}
						}

						sComm.Format(_T("\"%s\""), sfname);
						sComm += _T("\n");

						cfile.WriteString(sComm);
					}
				}
				cfile.Close();
				PackResponceFile(fnpack, sResf, wp, bWithPass);

			}



		} else {
			CString sResf;
			tmp = RESPONCE_FILE_NAME;
			sResf = m_pFmParam->GetExePath(tmp);
			setlocale(LC_ALL, ".ACP");
			CStdioFile cfile;
			if (!cfile.Open(sResf, CFile::modeWrite | CFile::modeCreate)) {
				tmp.Format(_T("[ %s ]\nX|Xt@C̍쐬Ɏs܂!"));
				MessageBox(tmp, _T("I[vG["));
				return;
			}


			CString sComm, path;

			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			bool wp = bWithPath;

			sfname = fn;

			if (sext == _T(".CAB")) {
				if ((at & _A_SUBDIR) != 0) {
					sfname += STR_YEN;
					sfname += _T("*.*");
				}
			}

			if (sext == _T(".7Z")) {
				if ((at & _A_SUBDIR) != 0) {

					sComm.Format(_T("\"%s\\*\""), sfname);
					sComm += _T("\n");
					cfile.WriteString(sComm);

					sfname += STR_YEN;

				}
			}

			sComm.Format(_T("\"%s\""), sfname);
			sComm += _T("\n");

			cfile.WriteString(sComm);

			cfile.Close();
			PackResponceFile(fnpack, sResf, wp, bWithPass);

		}
		sEntry = INIENTRY_SETTINGS_PACK_ARCHIVER;

		pApp->WriteProfileInt(sSection, sEntry, m_pFmParam->m_nPackArchiver);


		sEntry = INIENTRY_SETTINGS_PACK_RATE;

		pApp->WriteProfileInt(sSection, sEntry, m_pFmParam->m_nPackRate);

		sEntry = INIENTRY_SETTINGS_PACK_RATE7;

		pApp->WriteProfileInt(sSection, sEntry, m_pFmParam->m_nPackRate7);
	}
}


// [gֈړ
void CFileView::MoveRoot(void)
{
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	int cdrive = m_pFmParam->m_CurrentDriveNo;
	CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[cdrive];
	CString path;
	int n = cpath.Find(STR_YEN);
	if ( n == -1 ) return;
	if ( n == 0 ) {
		n = cpath.Find(STR_YEN, 1);
		if ( n == -1 ) return;
		if ( n == 1 ) {
			n = cpath.Find(STR_YEN, 2);
			if ( n == -1 ) return;
			else {
				n++;
				int n2 = cpath.Find(STR_YEN, n);
				if ( n == -1 ) return;
				path = cpath.Left(n2 + 1);
			}
		} else return;

	} else {
		path = cpath.Left(n + 1);
	}

	m_pFmParam->m_pDriveParam->m_pCurrentPath[cdrive] = path;
	m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
	m_pFmParam->ClearMark();
	ChangeDirectory(cdrive);

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);


}

// ~[Rs[@ʌtH_蕡ʂt@C
void CFileView::MirrorCopyFindCopyDir(CString fspath, CString fdpath)
{
	struct _wfinddata64_t c_file, c_dfile;
	intptr_t hFile;
	CString fn, mydir, parentdir, wCard, fullname;

	mydir = _T(".");
	parentdir = _T("..");

	wCard = _T("*.*");
	CString spath = m_sMirrorCopySDir;
	spath += fspath;
	spath += wCard;

	if( (hFile = _wfindfirst64( spath, &c_file )) != -1L ) {

		while( !m_pMirrorCopyingDlg->m_bCancel ) {
			fn = c_file.name;
			MSG aMsg;
			while (::PeekMessage(&aMsg, NULL, 0, 0, PM_REMOVE))
			{
				::TranslateMessage(&aMsg);
				::DispatchMessage(&aMsg);
			}

			if ((fn != parentdir) && (fn != mydir)) {

				CString fdn = fdpath;
				fdn += c_file.name;
				m_pMirrorCopyingDlg->m_ctrlFilename.SetWindowTextW(fdn);

				CString ffdn = m_sMirrorCopyDDir;
				ffdn += fdn;

				int at = c_file.attrib;
				CFileStatus rStatus;


				if (!(CFile::GetStatus(ffdn, rStatus))) {	// t@C݂Ȃ
					m_pw64CopyData[m_MirrorCopyFileCount] = c_file;
					c_dfile = c_file;
					c_dfile.name[0] = 0;
					m_pw64CopyDData[m_MirrorCopyFileCount] = c_dfile;
					m_pMirrorCopySPath[m_MirrorCopyFileCount] = fspath;
					m_pMirrorCopyDPath[m_MirrorCopyFileCount] = fdpath;
					m_MirrorCopyFileCount++;
				}
				else {
					if ((at & _A_SUBDIR) != 0) {	// DIRȂ
						spath = fspath;
						spath += c_file.name;
						spath += STR_YEN;

						CString dpath = fdpath;
						dpath += c_file.name;
						dpath += STR_YEN;

						MirrorCopyFindCopyDir(spath, dpath);
					}
					else {
						bool bDoCopy = false;

						__time64_t stime = c_file.time_write;
						__time64_t dtime = rStatus.m_mtime.GetTime();
						if (stime > dtime) {
							bDoCopy = true;
						}
						if (m_bMCopyDiffTime) {
							if (stime != dtime) {
								bDoCopy = true;
							}

						}
						__int64 ssize, dsize;
						ssize = c_file.size;
						dsize = rStatus.m_size;
						if (m_bMCopyDiffSize) {
							if (ssize != dsize) {
								bDoCopy = true;
							}

						}

						if (bDoCopy) {
							m_pw64CopyData[m_MirrorCopyFileCount] = c_file;
							c_dfile = c_file;
							c_dfile.size = rStatus.m_size;
							c_dfile.time_write = rStatus.m_mtime.GetTime();
							m_pw64CopyDData[m_MirrorCopyFileCount] = c_dfile;
							m_pMirrorCopySPath[m_MirrorCopyFileCount] = fspath;
							m_pMirrorCopyDPath[m_MirrorCopyFileCount] = fdpath;
							m_MirrorCopyFileCount++;

						}
					}
				}

			}

			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose( hFile );
	}

}


// ~[Rs[@ʐtH_폜t@C
void CFileView::MirrorCopyFindDeleteDir(CString fdpath, CString fspath)
{
	struct _wfinddata64_t c_file;
	intptr_t hFile;
	CString fn, mydir, parentdir, wCard, fullname;

	mydir = _T(".");
	parentdir = _T("..");

	wCard = _T("*.*");
	CString dpath = m_sMirrorCopyDDir;
	dpath += fdpath;
	dpath += wCard;

	if( (hFile = _wfindfirst64( dpath, &c_file )) != -1L ) {

		while( !m_pMirrorCopyingDlg->m_bCancel ) {
			fn = c_file.name;

			MSG aMsg;
			while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
			{
				::TranslateMessage( &aMsg );
				::DispatchMessage( &aMsg );
			}

			if ((fn != parentdir) && (fn != mydir)) {
				int at = c_file.attrib;
					if ((at & _A_SUBDIR) != 0) {	// DIRȂ

						CString fsn = fspath;
							fsn += c_file.name;

							m_pMirrorCopyingDlg->m_ctrlFilename.SetWindowTextW(fsn);

							CString ffsn = m_sMirrorCopySDir;
							ffsn += fsn;

							CFileStatus rStatus;
						if (!(CFile::GetStatus(ffsn, rStatus))) {	// t@C݂Ȃ
							m_pw64DeleteData[m_MirrorCopyDeleteFileCount] = c_file;
							m_pMirrorDeletePath[m_MirrorCopyDeleteFileCount] = fdpath;
							m_MirrorCopyDeleteFileCount++;
						}
						else {

							dpath = fdpath;
							dpath += c_file.name;
							dpath += STR_YEN;

							CString spath = fspath;
							spath += c_file.name;
							spath += STR_YEN;

							MirrorCopyFindDeleteDir(dpath, spath);
						}

					}
					else {

						CString fsn = fspath;
						fsn += c_file.name;

						m_pMirrorCopyingDlg->m_ctrlFilename.SetWindowTextW(fsn);

						CString ffsn = m_sMirrorCopySDir;
						ffsn += fsn;

						CFileStatus rStatus;
						if (!(CFile::GetStatus(ffsn, rStatus))) {	// t@C݂Ȃ
							m_pw64DeleteData[m_MirrorCopyDeleteFileCount] = c_file;
							m_pMirrorDeletePath[m_MirrorCopyDeleteFileCount] = fdpath;
							m_MirrorCopyDeleteFileCount++;
						}
					}

			}

			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose( hFile );
	}
	if ( m_pMirrorCopyingDlg->m_bCancel ) {
		m_bCancelCmd = true;
	}

}

// ~[Rs[t@C̍폜
void CFileView::MirrorCopyDeleteFile(void)
{

	CString fname, fn, path;
	CFileStatus rStatus;

	bool recycle = false;

	m_pDelInfoDlg = new CDeleteInfoDialog;
	m_pDelInfoDlg->Create(IDD_DELETE_INFO_DIALOG, this);
	m_pDelInfoDlg->ShowWindow(SW_SHOW);
	CDeleteInfoDialog* didlg = (CDeleteInfoDialog*)m_pDelInfoDlg;

	int fnum = m_MirrorCopyDeleteFileCount;

	for ( int i = 0; i < fnum; i++ ) {
		if ( didlg->m_Cancel ) 	{
			m_bCancelCmd = true;
			break;
		}

		MSG aMsg;
		while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
		{
			::TranslateMessage( &aMsg );
			::DispatchMessage( &aMsg );
		}

		path = m_sMirrorCopyDDir;
		path += m_pMirrorDeletePath[i];
		fn = m_pw64DeleteData[i].name;
		fname = path + fn;
		int at = m_pw64DeleteData[i].attrib;

		didlg->m_FileName = fn;
		didlg->m_SourcePath = path;
		CString fntmp;
		fntmp.Format(_T("%8d / %8d"), i + 1, fnum);
		didlg->m_FileNum = fntmp;
		didlg->UpdateData(FALSE);

		if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
			DeleteDir(fname, recycle);
		} else {
			if ( recycle ) {
				m_pFmParam->MoveToRecycler(fname);
			} else {
				CFile::GetStatus(fname, rStatus);
				rStatus.m_attribute = 0;
				rStatus.m_mtime = 0;

				bool bErr = false;

				try
				{
				CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}

				CFile file;
				try
				{
					if ( !bErr ) file.Remove(fname);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CI[vĂ܂!\n폜ł܂łB"), fname);
					MessageBox(s, _T("Lᔽ"));
					pEx->Delete();
				}
			}
		}

	}

	m_pDelInfoDlg->DestroyWindow();
	delete m_pDelInfoDlg;
}

// ~[Rs[t@C̃Rs[
void CFileView::MirrorCopyCopyFile(void)
{

	CString sfile, dfile, dpath, tmp, tmp2, tmp3;

	
	m_pFmParam->m_CopySame = TRUE;
	m_pFmParam->m_CopyMove = false;
	m_pFmParam->m_CopyMode = COPY_OVERWRITE;

	CFileStatus rStatus;

	int nt = m_MirrorCopyFileCount;
	int num = nt;

	m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
	m_pFmParam->m_pCopyInfoDlg = new CCopyInfoDialog;
	CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pFmParam->m_pCopyInfoDlg;
	m_pFmParam->m_pCopyInfoDlg->Create(IDD_COPY_INFO_DIALOG, this);
	cidlg->ShowWindow(SW_SHOW);

	for ( int n = 0; n < nt; n++ ) {

		if ( cidlg->m_Cancel ) 	{
			m_bCancelCmd = true;
			break;
		}

		m_pFmParam->m_CopySourcePath = m_sMirrorCopySDir;
		m_pFmParam->m_CopySourcePath += m_pMirrorCopySPath[n];

		m_pFmParam->m_CopyDestPath = m_sMirrorCopyDDir;
		m_pFmParam->m_CopyDestPath += m_pMirrorCopyDPath[n];

		m_pFmParam->m_CopyFileName = m_pw64CopyData[n].name;

		tmp = _T("%d");
		tmp2.Format(tmp, n);
		m_pFmParam->InsertComma(tmp2);
		tmp3.Format(tmp, nt);
		m_pFmParam->InsertComma(tmp3);
		tmp = _T("%16s / %16s");
		cidlg->m_FileNum.Format(tmp, tmp2, tmp3);
		int iret = m_pFmParam->CopyDirectory();
		if ( iret == 0 ) m_pFmParam->CopyOneFile();
		if ( m_pFmParam->m_CopyMode == -1 ) break;
		num--;
	}

	delete []m_pFmParam->m_pCopyBuff;
	m_pFmParam->m_pCopyInfoDlg->DestroyWindow();
	delete m_pFmParam->m_pCopyInfoDlg;

}

	
// ~[Rs[ b:sO̊mF  true:L
void CFileView::MirrorCopy(bool b)
{

	m_pw64CopyData = new _wfinddata64_t[MAXFILE];
	m_pw64CopyDData = new _wfinddata64_t[MAXFILE];
	m_pw64DeleteData = new _wfinddata64_t[MAXFILE];
	m_pMirrorCopySPath = new CString[MAXFILE];
	m_pMirrorCopyDPath = new CString[MAXFILE];
	m_pMirrorDeletePath = new CString[MAXFILE];


	m_pMirrorCopyingDlg = new CMirrorCopyingDialog;
	m_pMirrorCopyingDlg->m_sSDir = m_sMirrorCopySDir;
	m_pMirrorCopyingDlg->m_sDDir = m_sMirrorCopyDDir;

	m_pMirrorCopyingDlg->Create(IDD_MIRROR_COPYING_DIALOG, this);

	m_pMirrorCopyingDlg->ShowWindow(SW_SHOW);

	m_bCancelCmd = false;

	CString fdpath = m_sMirrorCopyDDir;
	int n = fdpath.GetLength();
	if( fdpath.GetAt(n - 1) != CHAR_YEN ) fdpath += STR_YEN;
	m_sMirrorCopyDDir = fdpath;

	CString fspath = m_sMirrorCopySDir;
	n = fspath.GetLength();
	if( fspath.GetAt(n - 1) != CHAR_YEN ) fspath += STR_YEN;
	m_sMirrorCopySDir = fspath;

	m_MirrorCopyDeleteFileCount = 0;
	m_MirrorCopyFileCount = 0;


	CString snull = _T("");
	MirrorCopyFindDeleteDir(snull, snull);

	CString s = _T("ʌtH_̌...");
	m_pMirrorCopyingDlg->m_Status.SetWindowTextW(s);
	MirrorCopyFindCopyDir(snull, snull);

	bool bcancel = m_pMirrorCopyingDlg->m_bCancel;

	m_pMirrorCopyingDlg->DestroyWindow();
	delete m_pMirrorCopyingDlg;

	if ( !bcancel ) {
		if ( (m_MirrorCopyDeleteFileCount == 0) && (m_MirrorCopyFileCount == 0) ) {
			s = _T("XVׂt@C͂܂");
			MessageBox(s);
		} else {
			m_MirrorCopySureDlg.m_pFileView = this;
			int ret = IDOK;
			if ( b ) ret = m_MirrorCopySureDlg.DoModal();

			if ( ret == IDOK ) {
				if ( m_MirrorCopySureDlg.m_bIsDelete ) {
					MirrorCopyDeleteFile();
				}
				if ( !m_bCancelCmd && m_MirrorCopySureDlg.m_bIsCopy ) {
					MirrorCopyCopyFile();
				}
			}
		}
	}

	delete []m_pw64CopyData;
	delete []m_pw64CopyDData;
	delete []m_pw64DeleteData;
	delete []m_pMirrorCopySPath;
	delete []m_pMirrorCopyDPath;
	delete []m_pMirrorDeletePath;


}

// t@C̃^CX^vύX
// changeDir  true:tH_ύX
void CFileView::ChangeFileTime(bool changeDir)
{

	CString fn;
	fn = m_sCPathChangeFileTime;
	fn += m_pw64ChangeFileTime->name;

	CFileStatus fStatus, st;
	bool run = true;

	CFile::GetStatus(fn, fStatus);
	int at = fStatus.m_attribute;

	if ((at & _A_SUBDIR) != 0) {	// DIRȂ
		run = changeDir;
	}

	if (run) {
		if (m_nChangeFileDate == BST_CHECKED) {
			fStatus.m_mtime = m_t64Write;
			m_pw64ChangeFileTime->time_write = m_t64Write;
		}
		if (m_nKindFileCreateDate == 1) {
			fStatus.m_ctime = m_t64Write;
			m_pw64ChangeFileTime->time_create = m_t64Write;
		}
		if (m_nKindFileCreateDate == 2) {
			fStatus.m_ctime = m_t64Create;
			m_pw64ChangeFileTime->time_create = m_t64Create;
		}

		if ((at & _A_SUBDIR) == 0) {	// DIRłȂ
			bool bErr = false;
			CFile::GetStatus(fn, st);
			int at2 = st.m_attribute;
			if ((at2 & _A_RDONLY) != 0) {	// [hI[Ȃ

				st.m_attribute = _A_ARCH;
				st.m_mtime = 0;
				try
				{
					CFile::SetStatus(fn, st);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fn);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}
			}

			if (!bErr) {
				CFile::SetStatus(fn, fStatus);	// DIRłȂȂ
			}
		}
		else {
			HANDLE hFile = CreateFile(fn, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ,
				0, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
			FILETIME ct, at3, wt;
			GetFileTime(hFile, &ct, &at3, &wt);


			if (m_nChangeFileDate == BST_CHECKED) {
				m_pFmParam->UnixTimeToFileTime(m_t64Write, &wt);
			}
			if (m_nKindFileCreateDate == 1) {
				m_pFmParam->UnixTimeToFileTime(m_t64Write, &ct);
			}
			if (m_nKindFileCreateDate == 2) {
				m_pFmParam->UnixTimeToFileTime(m_t64Create, &ct);
			}


			SetFileTime(hFile, &ct, &at3, &wt);
			CloseHandle(hFile);
		}
	}

	if ((at & _A_SUBDIR) != 0) {	// DIRȂ
		if (m_nChangeAllFileCheck == BST_CHECKED) {
			bool cd = false;
			if (m_nChangeAllDirCheck == BST_CHECKED) cd = true;
			fn += STR_YEN;
			m_sCPathChangeFileTime = fn;

			struct _wfinddata64_t c_file;
			intptr_t hFile;
			CString fpath, mydir, parentdir, wCard, fullname, cfn;
			int at4;
			CFileStatus rStatus;

			mydir = _T(".");
			parentdir = _T("..");

			wCard = _T("*.*");
			fpath = fn + wCard;

			if ((hFile = _wfindfirst64(fpath, &c_file)) != -1L) {

				while (true) {
					at4 = c_file.attrib;
					cfn = c_file.name;

					if ((cfn != mydir) && (cfn != parentdir)) {
						fullname = fn;
						//					fullname += _T("\\");
						fullname += c_file.name;
						m_pw64ChangeFileTime = &c_file;

						CString sp = m_sCPathChangeFileTime;
						ChangeFileTime(cd);
						m_sCPathChangeFileTime = sp;

					}


					if (_wfindnext64(hFile, &c_file) != 0) {
						break;
					}
				}
				_findclose(hFile);
			}

		}
	}
}


CString CFileView::CreateTestArcListFile(void)
{
		CString sDllFname, fname, path, sRetFname, fn;
		CStringA saOption;

		int i;
		CString sext;

		sDllFname = _T("");
		sRetFname = _T("");

		LPSTR lpBuffer = new CHAR[PACK_BUFFER_SIZE + 1];
		LPSTR cfname = new CHAR[1000];
		LPSTR cpath = new CHAR[1000];
		LPSTR lpProc = new char[100];

		CStringA sComm;
		CStringA sbuf;

		sRetFname = m_pFmParam->GetExePath(_T("annsFMpk.lst"));

		CFile cfile;
		BOOL fr = cfile.Open(sRetFname, CFile::modeCreate | CFile::modeWrite);

		for (i = 0; i < m_pFmParam->m_FileNum; i++) {
			bool b = false;
			if (m_pFmParam->m_TagFileNum == 0 && i == m_CurrentFileNo) {
				b = true;
			}

			if (m_pFmParam->m_pMark[i] || b) {
				b = false;
				fname = m_pFmParam->m_pw64FindData[i].name;

				m_pFmParam->DivideFileName(fname);
				sext = m_pFmParam->m_sExt;
				sext.MakeUpper();

				path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				fn = path;
				fn += fname;

				memset(lpBuffer, 0, PACK_BUFFER_SIZE);

				strncpy_s(cfname, 1000, CW2A(fn), _TRUNCATE);
				strncpy_s(cpath, 1000, CW2A(path), _TRUNCATE);

				if (sext == ".LZH") {
					sDllFname = _T("UNLHA32.DLL");
					strcpy_s(lpProc, 20, "Unlha");
					sComm.Format("t -c1m0a1 -jf0 -p2 \"%s\" \"%s\"", cfname, cpath);
				}

				if (sext == ".ZIP") {

					if (m_pFmParam->m_nToolZipTestDll == 0) {
						sDllFname = _T("LMZIP32.DLL");
						strcpy_s(lpProc, 20, "Unzip");

						sComm.Format("-t \"%s\" \"%s\"", cfname, cpath);
					}
					else {

						if (m_pFmParam->m_nToolZipTestDll == 1) {
							sDllFname = _T("UNZIP32.DLL");
							strcpy_s(lpProc, 20, "UnZip");
							sComm.Format("-t \"%s\" \"%s\"", cfname, cpath);
						}

						if (m_pFmParam->m_nToolZipTestDll == 2) {
							sDllFname = _T("7-ZIP32.DLL");
							strcpy_s(lpProc, 20, "SevenZip");
							sComm.Format("t \"%s\" \"%s\"", cfname, cpath);
						}
					}

				}

				if (sext == ".CAB") {
					sDllFname = _T("CAB32.DLL");
					strcpy_s(lpProc, 20, "Cab");
					sComm.Format("-t -j \"%s\" \"%s\"", cfname, cpath);
				}

				if (sext == ".ARJ") {
					sDllFname = _T("UNARJ32J.DLL");
					strcpy_s(lpProc, 20, "Unarj");
					sComm.Format("t \"%s\" \"%s\"", cfname, cpath);
				}


				if (sext == ".GCA") {
					sDllFname = _T("UnGCA32.DLL");
					strcpy_s(lpProc, 20, "UnGCA");
					sComm.Format("t -xx0 \"%s\" \"%s\"", cfname, cpath);
				}

				if (sext == ".GZA" || sext == ".BZA") {
					sDllFname = _T("Bga32.DLL");
					strcpy_s(lpProc, 20, "Bga");
					sComm.Format("t -a \"%s\" \"%s\"", cfname, cpath);
				}

				if (sext == ".7Z") {
					sDllFname = _T("7-ZIP32.DLL");
					strcpy_s(lpProc, 20, "SevenZip");
					sComm.Format("t \"%s\" \"%s\"", cfname, cpath);
				}

				if (sext == ".RAR") {
					sDllFname = _T("UNRAR32.DLL");
				}

				if (sDllFname != _T("")) {

					//			HINSTANCE hInstance = LoadLibrary( sDllFname );

					DWORD flag = 0xa00;
					SetDllDirectory(_T(""));
					HINSTANCE hInstance = LoadLibraryEx(sDllFname, 0, flag);


					if (hInstance)
					{
						if (sext == ".RAR") {
							sDllFname = _T("UNRAR32.DLL");
							strcpy_s(lpProc, 50, "UnrarCheckArchive");
							sComm.Format("\"%s\"", cfname);
							LPUNRARCHECKARCHIVE lpUnrarCheck
								= (LPUNRARCHECKARCHIVE)GetProcAddress(hInstance, lpProc);

							if (lpUnrarCheck) {
								HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
								BOOL r = lpUnrarCheck(sComm, 2);

								sbuf = "****************************************************\n";
								cfile.Write(sbuf, sbuf.GetLength());

								if (r) {
									sbuf.Format("%s\nA[JCut@C͐łB\n", cfname);
								}
								else {
									sbuf.Format("%s\nA[JCut@C͕słB\n", cfname);

								}
								cfile.Write(sbuf, sbuf.GetLength());

							}
						}
						else {
							LPFNCOMPRESS lpfnExecute
								= (LPFNCOMPRESS)GetProcAddress(hInstance, lpProc);

							int nStatus = 0;
							if (lpfnExecute)
							{
								HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
								nStatus = lpfnExecute(hWnd, sComm, lpBuffer, PACK_BUFFER_SIZE);
							}

							FreeLibrary(hInstance);
							sbuf = "****************************************************\n";
							cfile.Write(sbuf, sbuf.GetLength());
							sbuf.Format("%s\n", lpBuffer);
							cfile.Write(sbuf, sbuf.GetLength());

						}



					}


				}


			}
		}

		cfile.Close();

		delete[] lpBuffer;
		delete[] cfname;
		delete[] cpath;
		delete[] lpProc;

		saLmzip32ViewOption = "";

		return sRetFname;

}


CString CFileView::CreateArcListFile(CString sFname)
{
	CString sDllFname, fname, path, sRetFname, fn;
	CStringA saOption;


	sDllFname = _T("");
	sRetFname = _T("");

	m_pFmParam->DivideFileName(sFname);
	CString sext = m_pFmParam->m_sExt;
	sext.MakeUpper();

	if (sext == _T("")) return _T("");

	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = sFname;
	fn = path;
	fn += fname;

	LPSTR lpBuffer = new CHAR[PACK_BUFFER_SIZE + 1];
	LPSTR cfname = new CHAR[1000];
	LPSTR cpath = new CHAR[1000];
	LPSTR lpProc = new char[100];

	memset(lpBuffer, 0, PACK_BUFFER_SIZE);

	strncpy_s(cfname, 1000, CW2A(fn), _TRUNCATE);
	strncpy_s(cpath, 1000, CW2A(path), _TRUNCATE);

	CStringA sComm;

	if (sext == ".LZH") {
		sDllFname = _T("UNLHA32.DLL");
		strcpy_s(lpProc, 20, "Unlha");
		sComm.Format("l -c1m0a1 -jf0 -p2 \"%s\" \"%s\"", cfname, cpath);
	}

	if (sext == ".ZIP") {
		saOption = "-v";
		/*
		if ( m_pFmParam->m_bToolUseLMZIP32 ) {
		sDllFname = _T("LMZIP32.DLL");
		strcpy_s(lpProc, 20, "Unzip");

		if ( saLmzip32ViewOption != "" ) saOption = saLmzip32ViewOption;
		} else {
		sDllFname = _T("UNZIP32.DLL");
		strcpy_s(lpProc, 20, "UnZip");
		}
		*/
		if (m_pFmParam->m_nToolZipDll == 0 || saLmzip32ViewOption != "") {
			sDllFname = _T("LMZIP32.DLL");
			strcpy_s(lpProc, 20, "Unzip");

			if (saLmzip32ViewOption != "") saOption = saLmzip32ViewOption;
			sComm.Format("%s \"%s\" \"%s\"", saOption, cfname, cpath);
		}
		else {

			if (m_pFmParam->m_nToolZipDll == 1) {
				sDllFname = _T("UNZIP32.DLL");
				strcpy_s(lpProc, 20, "UnZip");
			}
			sComm.Format("%s \"%s\" \"%s\"", saOption, cfname, cpath);

			if (m_pFmParam->m_nToolZipDll == 2) {
				sDllFname = _T("7-ZIP32.DLL");
				strcpy_s(lpProc, 20, "SevenZip");
				sComm.Format("l \"%s\" \"%s\"", cfname, cpath);
			}
		}

	}

	if (sext == ".ARJ") {
		sDllFname = _T("UNARJ32J.DLL");
		strcpy_s(lpProc, 20, "Unarj");
		sComm.Format("v \"%s\" \"%s\"", cfname, cpath);
	}

	if (sext == ".CAB") {
		sDllFname = _T("CAB32.DLL");
		strcpy_s(lpProc, 20, "Cab");
		sComm.Format("-l -j \"%s\" \"%s\"", cfname, cpath);
	}

//	if (sext == ".TAR") {
		CString stext = m_pFmParam->m_sToolExtTar;
		stext.MakeUpper();

		if (stext.Find(sext) >= 0) {
			CString text = sext + _T(";");

			if (stext.Find(text) >= 0) {
				sDllFname = _T("TAR32.DLL");
				strcpy_s(lpProc, 20, "Tar");
				sComm.Format("--check-all-path=1 -tvf \"%s\" \"%s\"", cfname, cpath);
			}

		}
//	}


	if (sext == ".RAR") {
		sDllFname = _T("UNRAR32.DLL");
		strcpy_s(lpProc, 20, "Unrar");
		sComm.Format("-v \"%s\" \"%s\"", cfname, cpath);
	}

	if (sext == ".GCA") {
		sDllFname = _T("UnGCA32.DLL");
		strcpy_s(lpProc, 20, "UnGCA");
		sComm.Format("l -xx1 \"%s\" \"%s\"", cfname, cpath);
	}

	if (sext == ".GZA" || sext == ".BZA") {
		sDllFname = _T("Bga32.DLL");
		strcpy_s(lpProc, 20, "Bga");
		sComm.Format("v -a \"%s\" \"%s\"", cfname, cpath);
	}

	if (sext == ".YZ1") {
		sDllFname = _T("YZ1.DLL");
		strcpy_s(lpProc, 20, "Yz1");
		sComm.Format("l -x1 \"%s\" \"%s\"", cfname, cpath);
	}

	if (sext == ".7Z") {
		sDllFname = _T("7-ZIP32.DLL");
		strcpy_s(lpProc, 20, "SevenZip");
		sComm.Format("l \"%s\" \"%s\"", cfname, cpath);
	}

	bool b = false;
	if (sDllFname != _T("")) {

		//			HINSTANCE hInstance = LoadLibrary( sDllFname );

		DWORD flag = 0xa00;
		SetDllDirectory(_T(""));
		HINSTANCE hInstance = LoadLibraryEx(sDllFname, 0, flag);


		if (hInstance)
		{
			if (sext == ".RAR") {
				sDllFname = _T("UNRAR32.DLL");

				strcpy_s(lpProc, 100, "UnrarSetUnicodeMode");

				LPUNRAR lpExe
					= (LPUNRAR)GetProcAddress(hInstance, lpProc);

				if (lpExe)
				{
					int nStatus = lpExe(TRUE);

					CString comm;
					strcpy_s(lpProc, 20, "Unrar");
					comm.Format(_T("-v \"%s\" \"%s\""), fn, path);

					//						CStringW utf16(tchar);

					// ----------------------------------------
					// Convert Unicode(UTF-16) to UTF-8.
					// Unicode(UTF-16)UTF-8ɕϊ
					// ----------------------------------------
					// First, get the size of the buffer to store UTF-8 chars.
					// ܂AUTF-8i[obt@TCY擾
					INT bufsize = ::WideCharToMultiByte(CP_UTF8, 0, comm, -1, NULL, 0, NULL, NULL);
					CHAR* utf8 = new CHAR[bufsize];

					// Then, convert Unicode to UTF-8.
					// UnicodeUTF-8ɕϊ
					//						::WideCharToMultiByte(CP_UTF8, 0, utf16, -1, utf8, bufsize, NULL, NULL);
					::WideCharToMultiByte(CP_UTF8, 0, comm, -1, utf8, bufsize, NULL, NULL);


					LPUNRARCOMPRESS lpUnraraExecute
						= (LPUNRARCOMPRESS)GetProcAddress(hInstance, lpProc);

					if (lpUnraraExecute)
					{
						HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
						//							int nStatus = lpUnraraExecute( hWnd, comm, lpBuffer, 32768 );
						int nStatus = lpUnraraExecute(hWnd, utf8, lpBuffer, PACK_BUFFER_SIZE);
						b = true;

					}
					delete[] utf8;
				}
				else {

					LPFNCOMPRESS lpfnExecute
						= (LPFNCOMPRESS)GetProcAddress(hInstance, lpProc);

					if (lpfnExecute)
					{
						HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
						int nStatus = lpfnExecute(hWnd, sComm, lpBuffer, PACK_BUFFER_SIZE);
						b = true;

					}
				}
			}
			else {

				LPFNCOMPRESS lpfnExecute
					= (LPFNCOMPRESS)GetProcAddress(hInstance, lpProc);

				if (lpfnExecute)
				{
					HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
					int nStatus = lpfnExecute(hWnd, sComm, lpBuffer, PACK_BUFFER_SIZE);
					b = true;

				}
			}

			FreeLibrary(hInstance);
		}


		/*
		HINSTANCE hInstance = LoadLibrary( sDllFname );

		if ( hInstance )
		{
		LPFNCOMPRESS lpfnExecute
		= (LPFNCOMPRESS)GetProcAddress( hInstance, lpProc );

		if ( lpfnExecute )
		{
		HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
		int nStatus = lpfnExecute( hWnd, sComm, lpBuffer, 32768 );
		b = true;

		}
		FreeLibrary( hInstance );
		}
		*/
	}

	if (b) {

		sRetFname = m_pFmParam->GetExePath(_T("annsFMpk.lst"));
		CStringA sbuf;
		sbuf.Format("%s", lpBuffer);

		CFile cfile;
		BOOL fr = cfile.Open(sRetFname, CFile::modeCreate | CFile::modeWrite);

		cfile.Write(sbuf, sbuf.GetLength());

		cfile.Close();


	}

	delete[] lpBuffer;
	delete[] cfname;
	delete[] cpath;
	delete[] lpProc;

	saLmzip32ViewOption = "";


	return sRetFname;

}

void CFileView::RestoreZip(int nZipDll, bool bfixfix)
{
		CString sDllFname, fname, path, sRetFname, fn;


		sDllFname = _T("");
		sRetFname = _T("");

		path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		fn = path;
		fn += fname;

//		m_pFmParam->DivideFileName(fname);
//		CString sext = m_pFmParam->m_sExt;
//		sext.MakeUpper();

//		if ( sext != ".ZIP" ) return;

		LPSTR lpBuffer = new CHAR [32768];
		LPSTR cfname = new CHAR[1000];
		LPSTR cpath = new CHAR[1000];
		LPSTR cfn = new CHAR[1000];
		LPSTR lpProc = new char[20];

		memset(lpBuffer, 0, 32768);

		strncpy_s(cfname, 1000, CW2A(fn), _TRUNCATE);
		strncpy_s(cpath, 1000, CW2A(path), _TRUNCATE);
		strncpy_s(cfn, 1000, CW2A(fname), _TRUNCATE);

		CStringA sComm, saOption;
		saOption = "-F";
		if ( bfixfix ) saOption = "-FF";

		if ( nZipDll == 0 ) {
			sDllFname = _T("LMZIP32.DLL");
			strcpy_s(lpProc, 20, "Unzip");
		}

		sComm.Format("%s \"%s\" -O \"%scopy_%s\"", saOption, cfname, cpath, cfn);


		if ( nZipDll == 1 ) {
			sDllFname = _T("ZIP32J.DLL");
			strcpy_s(lpProc, 20, "Zip");
//			sComm.Format("%s \"%s\" \"%s\"", saOption, cfn, cpath);
			sComm.Format("%s \"%s\"", saOption, cfname);
		}


//		bool b = false;
		if ( sDllFname != _T("") ) {
//			HINSTANCE hInstance = LoadLibrary( sDllFname );

			DWORD flag = 0xa00;
			SetDllDirectory(_T(""));
			HINSTANCE hInstance = LoadLibraryEx(sDllFname, 0, flag);


			if ( hInstance )
			{
				LPFNCOMPRESS lpfnExecute
					= (LPFNCOMPRESS)GetProcAddress( hInstance, lpProc );

				if ( lpfnExecute )
				{
					HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
					int nStatus = lpfnExecute( hWnd, sComm, lpBuffer, 32768 );
					if ( nStatus != 0 ) {
						MessageBox(_T("CɎs܂B"));
					}
//					b = true;

				}
				FreeLibrary( hInstance );
			}
		}

		delete [] lpBuffer;
		delete [] cfname;
		delete [] cpath;
		delete cfn;
		delete [] lpProc;



		return;

}

// L[R}h ==================================

// Cmd No 0x08
void CFileView::CmdKeyBackspace(void)
{

	CString cpath, spath, tmp;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if ( cpath.GetLength() < 4 ) return;
	DrawCursor(false);
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	spath = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	m_pFmParam->m_sPrevDir = "";
	if ( !GetParentDir(cpath, tmp) ) {
		tmp = cpath;
	}
	cpath = tmp;
	m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo] = cpath;
	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(cpath);
	m_CurrentFileNo = m_pFmParam->m_PrevDirNo;
	m_CurrentPage = m_CurrentFileNo / m_PageFileNum;
	SetFindNotify();
	Invalidate();
	SetScrollData();
	m_pFmParam->ClearMark();
	m_pDriveTabWnd->CreateDriveList();
	m_pDriveTabWnd->Invalidate();

	RecalcPage();

	DrawCursor();

	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	SetCurrentDirectory(cpath);

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}

// Cmd No 0x09
void CFileView::CmdKeyTab(void)
{
	OnMenuKeyTab();
}

// Cmd No 0x0d
void CFileView::CmdKeyEnter(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
	CString pdir = _T("..");
	CString tmp;
	if ( (at & _A_SUBDIR) != 0 ) {	// fBNgȂ
		CString cpath, spath;
		int pn;
		cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		spath = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		m_pFmParam->m_sPrevDir = "";
		if ( spath == pdir ) {
			if ( !GetParentDir(cpath, tmp) ) {
				cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				return;	// \Ȃ!
			}
			cpath = tmp;
		} else {
			cpath += spath;
			cpath += _T("\\");
			pn = 0;
		}
//		m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

		m_pFmParam->ClearMark();

		m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo] = cpath;
		m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(cpath);
		m_CurrentFileNo = m_pFmParam->m_PrevDirNo;
		m_CurrentPage = m_CurrentFileNo / m_PageFileNum;
		SetFindNotify();
		Invalidate();
		SetScrollData();

		m_pDriveTabWnd->CreateDriveList();
		m_pDriveTabWnd->Invalidate();

		m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);


	} else {
		CString cpath, fname, cfname, tmp, ftmp, ptmp;
		fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( !AnalyzeExtention(fname) ) {
			if (m_pFmParam->m_bSettingsEnterKeyRunSystem) {
				CmdKeyCtrlEnter();

			}
			else {
				if (m_pFmParam->m_ExtKind == EXT_KIND_VIEW) CreateannsView(true, m_pFmParam->m_bViewannsFMtextExe);	// view[h̏ꍇ摜[hCreateannsView()ĂŌ
				if (m_bFailGmode) CreateannsView(false, m_pFmParam->m_bViewannsFMtextExe);	// CreateannsView()ŉ摜[hłȂꍇeLXg[hviewNB
			}

		} else {
			CString sArc = _T("");
			CString sBrw = _T("");

			switch ( m_pFmParam->m_ExtKind ) {
				case EXT_KIND_EXTMAP :
					cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
					fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

					ftmp = m_sExtMapFile;
					ptmp = _T("");

					if ( m_sExtMapFile[0] == _T('\"') ) {
						int n = m_sExtMapFile.ReverseFind(_T('\"'));
						ptmp = m_sExtMapFile.Mid(n + 1);
						n--;
						ftmp = m_sExtMapFile.Mid(1, n);
					}

					tmp = _T("open");
					cfname = ptmp;
					cfname += _T(" \"") + cpath + fname + _T("\"");

					ShellExecute(this->m_hWnd, tmp, ftmp, cfname, cpath, SW_SHOW);
					break;

				case EXT_KIND_ARCHIVER :
					cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
					fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

					tmp = _T("open");
					cfname = _T("\"") + cpath + fname + _T("\"");
					sArc = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolArchiver);
					ShellExecute(this->m_hWnd, tmp, sArc, cfname, cpath, SW_SHOW);
					break;

				case EXT_KIND_HTML :
					cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
					fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

					tmp = _T("open");
					cfname = _T("\"") + cpath + fname + _T("\"");
					sBrw = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolBrowser);
					ShellExecute(this->m_hWnd, tmp, sBrw, cfname, cpath, SW_SHOW);
					break;

				case EXT_KIND_EXE :
					CmdKeyRunProgram();
					break;

				case EXT_KIND_APP :
					break;

				case EXT_KIND_SOUND :
					CmdKeyCtrlSPlaySound();
					break;

				case EXT_KIND_MOVIE:
					CmdKeyShiftGPlayMovie();
					break;


				default :
					CmdKeyGraphView();
					break;
			}
		}
	}
}

typedef	CArray<HWND> CHwndArray;

typedef struct tagannsMAllExit
{
	TCHAR		chPathName[MAX_PATH];
	CHwndArray	annsArray;
} annsFMALLEXIT, FAR* LPANNSFMALLEXIT;

static BOOL CheckTitle( LPTSTR lpszTitle )
{
	BOOL bResult = FALSE;

	if (lpszTitle)
	{
		CString st;
		st.Format(_T("%s"), lpszTitle);
		int n = st.Find(_T(" - annsFM"));
		if (n > 0) {
			bResult = TRUE;

		}
		/*
		int nLength = (int)_tcslen( lpszTitle );
		if ( nLength > 10 )
		{
		if ( !_tcscmp( lpszTitle + nLength - 9, _T(" - annsFM") ) )
		{
		bResult = TRUE;
		}
		else if ( !_tcsncmp( lpszTitle, _T("annsFM - "), 9 ) )
		{
		if ( lpszTitle[11] == _T(':') || lpszTitle[11] == _T('\\') )
		bResult = TRUE;
		}
		}
		*/
	}

	return bResult;
}

// NŁA\Ă邷ׂĂannsFM񋓂B
BOOL CALLBACK EnumWindowsProc( HWND hWnd, LPARAM lParam )
{
	LPANNSFMALLEXIT lpAllExit = (LPANNSFMALLEXIT)lParam;

//	TRACE( _T("EnumWindowsProc()\n") );

	int nNeedLength = GetWindowTextLength( hWnd );
	if ( nNeedLength > 7 && nNeedLength < MAX_PATH + 7 )
	{
		if ( IsWindow( hWnd ) && !IsIconic( hWnd ) && IsWindowVisible( hWnd ) )
		{
			nNeedLength += 8;
			LPTSTR lpBuffer = new TCHAR [nNeedLength];
			ZeroMemory( lpBuffer, nNeedLength * sizeof(TCHAR) );
			if ( GetWindowText( hWnd, lpBuffer, nNeedLength ) )
			{
				if ( CheckTitle( lpBuffer ) )
				{
					HMODULE hInstance = (HMODULE)GetWindowLongPtr( hWnd, GWLP_HINSTANCE );
					if ( hInstance )
					{
						TCHAR chPathName[MAX_PATH];
						if ( ::GetModuleFileName( hInstance, chPathName, MAX_PATH ) )
						{
							if ( !_tcsicmp( lpAllExit->chPathName, chPathName ) )
							{
								lpAllExit->annsArray.Add( hWnd );
							}
						}
					}
				}
			}
			delete [] lpBuffer;
		}
	}

	return TRUE;
}


// Cmd No 0x0d
void CFileView::CmdKeyEsc(void)
{
//	if ( m_pMciDialog->m_bNowPlay ) {
//		m_pMciDialog->OnBnClickedStopButton();
//	} else {

		m_pMciDialog->OnBnClickedCancel();

		CExitDialog dlg;
		int id = dlg.DoModal();

		if ( id == IDCANCEL ) return;

		int rId = dlg.m_nId;


		if ( rId == 0 ) {	// annsFM̏I
			CmdKeyQuit();
			return;
		}

		if ( rId == 1 ) {	// SĂannsFM̏I

			HINSTANCE hInstance = AfxGetInstanceHandle();
			if ( hInstance )
			{
				annsFMALLEXIT AllannsFMArray;
				::GetModuleFileName( hInstance, AllannsFMArray.chPathName, MAX_PATH );
				EnumWindows( (WNDENUMPROC)&EnumWindowsProc, (LPARAM)&AllannsFMArray );

				CHwndArray& refHWndArray = AllannsFMArray.annsArray;
				if ( refHWndArray.GetSize() )
				{
					INT_PTR nCount = refHWndArray.GetSize();
					for ( INT_PTR i = 0 ; i < nCount ; i ++ )
					{
						if ( refHWndArray[i] != m_pChildView->m_pMainFrame->m_hWnd )
						{
							::SendMessage( refHWndArray[i], WM_CLOSE, 0, 0 );
						}
					}
				}
			}

			CmdKeyQuit();
			return;
		}

		HANDLE hToken;
		TOKEN_PRIVILEGES tokenPriv;
		BOOL bRet;

	//ANZXg[NJ
		bRet = OpenProcessToken(GetCurrentProcess(),
											 TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,
											 &hToken);
	//Vbg_ELUID擾
		LookupPrivilegeValue(NULL, SE_SHUTDOWN_NAME, &(tokenPriv.Privileges[0].Luid));
		tokenPriv.PrivilegeCount = 1;
		tokenPriv.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

	//Vbg_ELUIDŁAVbg_ELɂ
		bRet = AdjustTokenPrivileges(hToken, FALSE, &tokenPriv, 0, NULL, NULL);

		if ( rId == 2 ) {	// Vbg_E
			ExitWindowsEx(EWX_SHUTDOWN, 0);
		}
		if ( rId == 3 ) {	// ċN
			ExitWindowsEx(EWX_REBOOT, 0);
		}
		if ( rId == 4 ) {	// OIt
			ExitWindowsEx(EWX_LOGOFF, 0);
		}
		if ( rId == 5 ) {	// X[v(x~)
			SetSystemPowerState( FALSE, FALSE );
		}
		if ( rId == 6 ) {	// X^oC
			SetSystemPowerState( TRUE, FALSE );
		}
		CmdKeyQuit();

//	}
}

// Cmd No 0x20
void CFileView::CmdKeySpace(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	DrawCursor(false);

	CString s;
	s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	if ( s != _T("..")) {

		if ( m_pFmParam->m_pMark[m_CurrentFileNo] ) {
#ifdef _WINVER_XP
			DrawMark(false);
#endif

#ifndef _WINVER_XP
			if (!m_pFmParam->m_bSystemDirectWrite) {
				DrawMark(false);
			}
#endif

			m_pFmParam->m_TagFileNum--;
			m_pFmParam->m_TagFileSize -= m_pFmParam->m_pw64FindData[m_CurrentFileNo].size;
		} else {
#ifdef _WINVER_XP
			DrawMark(true);
#endif

#ifndef _WINVER_XP
			if (!m_pFmParam->m_bSystemDirectWrite) {
				DrawMark(true);
			}
#endif
			m_pFmParam->m_TagFileNum++;
			m_pFmParam->m_TagFileSize += m_pFmParam->m_pw64FindData[m_CurrentFileNo].size;
		}
		m_pFmParam->m_pMark[m_CurrentFileNo] = !(m_pFmParam->m_pMark[m_CurrentFileNo]);
	}

	int pmax = (m_CurrentPage + 1) * m_PageFileNum - 1;
	int fno = m_CurrentFileNo;
	if ( fno < (m_pFmParam->m_FileNum - 1) ) m_CurrentFileNo++;
	if ( m_CurrentFileNo > pmax ) {
		m_CurrentPage++;
		Invalidate();
	}
	DrawCursor();
}

// Cmd No 0x21
void CFileView::CmdKeyPageUp(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	if ( m_CurrentPage > 0 ) {
		m_CurrentPage--;
		m_CurrentFileNo -= m_PageFileNum;
	} else {
		m_CurrentPage = 0;
		m_CurrentFileNo = 0;
	}
	Invalidate();
}

// Cmd No 0x22
void CFileView::CmdKeyPageDown(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	int pmax = (m_pFmParam->m_FileNum - 1) / m_PageFileNum;
//	if ( pmax == 0 ) return;
	if ( m_CurrentPage < pmax ) {
		m_CurrentPage++;
		m_CurrentFileNo += m_PageFileNum;
		if ( m_CurrentFileNo >= m_pFmParam->m_FileNum ) m_CurrentFileNo = m_pFmParam->m_FileNum - 1;
	} else {
		m_CurrentPage = pmax - 1;
		m_CurrentFileNo = m_pFmParam->m_FileNum - 1;
	}
	Invalidate();
}

// Cmd No 0x23
void CFileView::CmdKeyEnd(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	int pmax = (m_pFmParam->m_FileNum - 1) / m_PageFileNum;

	m_CurrentPage = pmax - 1;
	m_CurrentFileNo = m_pFmParam->m_FileNum - 1;

	Invalidate();
}

// Cmd No 0x24
void CFileView::CmdKeyHome(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	if ( m_pFmParam->CheckMarkExist() ) {
		m_pFmParam->ClearMark();
	} else m_pFmParam->SetMarkAllFile();
	Invalidate();
}

// Cmd No 0x25
void CFileView::CmdKeyLeft(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	DrawCursor(false);

	int pmin = m_CurrentPage * m_PageFileNum;
	int cfn = m_CurrentFileNo;
	m_CurrentFileNo -= m_MaxLine;

	if (m_pFmParam->m_bListCursorMovePage) {
		if (m_CurrentFileNo < 0) m_CurrentFileNo = 0;
		if (m_CurrentFileNo < pmin) {
			m_CurrentPage--;
			Invalidate();
		}

	}
	else {
		int ncol = (m_PageFileNum - 1) / m_MaxLine;
		if (m_CurrentFileNo < pmin) {
			m_CurrentFileNo = cfn + (m_MaxLine * ncol);
			if (m_CurrentFileNo >= m_pFmParam->m_FileNum) {
				int n = m_pFmParam->m_FileNum - pmin;
				int n2 = ((n / m_MaxLine) - 1) * m_MaxLine;
				if (n2 <= 0) {
					m_CurrentFileNo = cfn;
				}
				else {
					m_CurrentFileNo = n2 + cfn - pmin;

				}
			}
		}

	}

	DrawCursor();
}

// Cmd No 0x27
void CFileView::CmdKeyRight(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	DrawCursor(false);

	int pmax = (m_CurrentPage + 1) * m_PageFileNum - 1;
	int cfn = m_CurrentFileNo;
	m_CurrentFileNo += m_MaxLine;

	if (m_pFmParam->m_bListCursorMovePage) {
		if (m_CurrentFileNo >= m_pFmParam->m_FileNum) m_CurrentFileNo = m_pFmParam->m_FileNum - 1;
		if (m_CurrentFileNo > pmax) {
			m_CurrentPage++;
			Invalidate();
		}
	}
	else {
		if (m_CurrentFileNo >= m_pFmParam->m_FileNum) {
			int a = cfn % m_MaxLine;
			m_CurrentFileNo = (m_CurrentPage * m_PageFileNum) + a;

		}
		else {
			if (m_CurrentFileNo > pmax) {
				int ncol = (m_PageFileNum - 1) / m_MaxLine;
				m_CurrentFileNo = cfn - (m_MaxLine * ncol);
			}

		}


	}


	DrawCursor();
}

// Cmd No 0x26
void CFileView::CmdKeyUp(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	DrawCursor(false);

	int pmin = m_CurrentPage * m_PageFileNum;
	int cfn = m_CurrentFileNo;

	m_CurrentFileNo--;

	if (m_pFmParam->m_bListCursorMovePage) {
		if (m_CurrentFileNo < 0) {
			if (m_pFmParam->m_bListCyclicalCursor) {
				CmdKeyEnd();
				pmin = m_CurrentFileNo;
			}
			else {
				m_CurrentFileNo = 0;
			}
		}
		if (m_CurrentFileNo < pmin) {
			m_CurrentPage--;
			Invalidate();
		}
	}
	else {
		if (m_CurrentFileNo < pmin) {
			if (m_pFmParam->m_bListCyclicalCursor) {
				m_CurrentFileNo = pmin + m_PageFileNum - 1;
				if (m_CurrentFileNo >= m_pFmParam->m_FileNum) {
					m_CurrentFileNo = m_pFmParam->m_FileNum - 1;
				}
			}
			else {
				m_CurrentFileNo = cfn;

			}
		}

	}



	DrawCursor();
}

// Cmd No 0x27
void CFileView::CmdKeyDown(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	DrawCursor(false);

	int pmax = (m_CurrentPage + 1) * m_PageFileNum - 1;
	int cfn = m_CurrentFileNo;

	if (m_pFmParam->m_bListCursorMovePage) {
		if (cfn < (m_pFmParam->m_FileNum - 1)) {
			m_CurrentFileNo++;
			if (m_CurrentFileNo > pmax) {
				m_CurrentPage++;
				Invalidate();
			}
		}
		else {
			if (m_pFmParam->m_bListCyclicalCursor) {
				m_CurrentPage = 0;
				m_CurrentFileNo = 0;
				Invalidate();
			}
		}
	}
	else {
		if (cfn < (m_pFmParam->m_FileNum - 1)) {
			m_CurrentFileNo++;
			if (m_CurrentFileNo > pmax) {
				if (m_pFmParam->m_bListCyclicalCursor) {
					m_CurrentFileNo = m_CurrentPage * m_PageFileNum;
				}
				else {
					m_CurrentFileNo = cfn;
				}
			}
		}
		else {
			if (m_pFmParam->m_bListCyclicalCursor) {
				m_CurrentFileNo = m_CurrentPage * m_PageFileNum;
			}
			else {
				m_CurrentFileNo = cfn;
			}
		}

	}



	DrawCursor();
}

// Cmd No 0x2d
void CFileView::CmdKeyInsert(void)
{
	CMenu* pMenu = m_pChildView->m_pMainFrame->GetMenu();

	if (m_pFmParam->m_bHideDriveTab) {
		m_pFmParam->m_bHideDriveTab = false;
		pMenu->CheckMenuItem(ID_KEY_INS, MF_CHECKED);
	}
	else {
		m_pFmParam->m_bHideDriveTab = true;
		pMenu->CheckMenuItem(ID_KEY_INS, MF_UNCHECKED);
	}
	m_pChildView->ResizeWindow();
	m_pFmParam->WriteIniFileParameter();

}

// Cmd No 0x30`0x39
void CFileView::CmdKeyChangeDrive(UINT driveno)
{
	m_pFmParam->m_bRedrawFocus = false;
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	UINT dn;
	dn = driveno - 0x31;
	if ( driveno == 0x30 ) dn = 9;
	m_pFmParam->ClearMark();
	ChangeDirectory(dn);

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}


// sfileJgt@CɂB(J[\sFilëʒuɈړ)
void CFileView::MoveCursor(CString sfile)
{

	int max = m_pFmParam->m_FileNum;
	for (int n = 0; n < max; n++) {
		CString cf;
		cf = m_pFmParam->m_pw64FindData[n].name;
		if (sfile == cf) {
			m_CurrentFileNo = n;
			break;
		}
	}

}


// Cmd No 0x41
void CFileView::CmdKeySetAttribute(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	CString fname, fn, path;

	CString scfile;
	scfile = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	CSetAttributeDialog dlg;

	CFileStatus rStatus;

	fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	path = fname;

	if ( m_pFmParam->m_TagFileNum != 0 ) {
		int i;
		for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) break;
		}
		fname += m_pFmParam->m_pw64FindData[i].name;
		CString tmp;
		tmp = _T("%d̑Iꂽt@C");
		fn.Format(tmp, m_pFmParam->m_TagFileNum);
	} else {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;

		fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	}

	CFile::GetStatus(fname, rStatus);
	dlg.m_FileName = fn;
	dlg.m_Path = path;

	DWORD at = rStatus.m_attribute;

	if ((at & _A_SUBDIR) != 0) {
		dlg.m_bEnableChangeInSubdir = true;
	}
	if ((at & _A_RDONLY) != 0) dlg.m_bReadonly = true;
	if ((at & _A_HIDDEN) != 0) dlg.m_bHidden = true;
	if ((at & _A_SYSTEM) != 0) dlg.m_bSystem = true;
	if ((at & _A_ARCH) != 0) dlg.m_bArchive = true;

	int r = dlg.DoModal();
	if ( r != IDOK ) return;

	at &= _A_SUBDIR;
	if ( dlg.m_bReadonly ) at |= _A_RDONLY;
	if ( dlg.m_bHidden ) at |= _A_HIDDEN;
	if ( dlg.m_bSystem ) at |= _A_SYSTEM;
	if ( dlg.m_bArchive ) at |= _A_ARCH;
	rStatus.m_attribute = at;
	rStatus.m_mtime = 0;


	if ( m_pFmParam->m_TagFileNum == 0 ) {
		if ((at & _A_SUBDIR) != 0) {
			if ( dlg.m_bChangeInSubdir ) {
				SetAttributeAllFile(fname, at, dlg.m_bNoChangeDir);
			}
			if ( !dlg.m_bNoChangeDir ) {

				bool bErr = false;
				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fn);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}

				m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib = rStatus.m_attribute;
			}
		} else {
			bool bErr = false;
			try
			{
				CFile::SetStatus(fname, rStatus);
			}
			catch (CFileException* pEx)
			{
				CString s;
				s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fn);
				MessageBox(s, _T("ANZXG["));
				pEx->Delete();
				bErr = true;
			}
			m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib = rStatus.m_attribute;
		}
	} else {
		for ( int i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( !(m_pFmParam->m_pMark[i]) ) continue;
			fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			fname += m_pFmParam->m_pw64FindData[i].name;
			int at2 = m_pFmParam->m_pw64FindData[i].attrib;

			if ((at2 & _A_SUBDIR) != 0) {
				if ( dlg.m_bChangeInSubdir ) {
					SetAttributeAllFile(fname, at, dlg.m_bNoChangeDir);
				}
				if ( !dlg.m_bNoChangeDir ) {
					bool bErr = false;
					try
					{
						CFile::SetStatus(fname, rStatus);
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
						MessageBox(s, _T("ANZXG["));
						pEx->Delete();
						bErr = true;
					}
					m_pFmParam->m_pw64FindData[i].attrib = rStatus.m_attribute;
				}
			} else {
				bool bErr = false;
				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}
				m_pFmParam->m_pw64FindData[i].attrib = rStatus.m_attribute;
			}

		}
	}
	if ( m_pFmParam->m_SortMode != SORT_NON )  m_pFmParam->SortFileList(m_pFmParam->m_SortMode);


	MoveCursor(scfile);

	Invalidate();
}

// Cmd No 0x42
void CFileView::CmdKeyBinaryEditFile(void)
{
	BinaryEditFile();
}

// Cmd No 0x43
void CFileView::CmdKeyCopyFile(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	CopyFile();
}

// Cmd No 0x44
void CFileView::CmdKeyDeleteFile(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	DeleteFile();
	m_bInitFileList = true;

}

// Cmd No 0x45
void CFileView::CmdKeyEditFile(void)
{
	EditFile();
}

// Cmd No 0x46
void CFileView::CmdKeyFindFile(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	FindFile();
}

// Cmd No 0x47
void CFileView::CmdKeyGraphView(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	CreateannsView(true);
}

// Cmd No 0x48
void CFileView::CmdKeyMovePath(void)
{
	m_pFmParam->m_bRedrawFocus = false;
	MovePath();
}

// Cmd No 0x4a
void CFileView::CmdKeyJump(void)
{
	if ( m_pFmParam->m_bEnableTreeWindow ) return;
	if ( m_pFmParam->m_bEnableJumpWindow ) {
		m_pJumpFrame->SetFocus();
		return;
	}

	m_pFmParam->m_bRedrawFocus = false;

	m_pJumpFrame = new CJumpFrame;
	m_pJumpFrame->m_pFmParam = m_pFmParam;
	m_pJumpFrame->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrame->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrame->LoadFrame(IDR_JUMPVIEWFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrame->ShowWindow(SW_SHOW);
	m_pJumpFrame->SetWindowText(_T("WvtH_"));
	m_pJumpFrame->UpdateWindow();

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	SetCurrentDirectory(cpath);
}

// Cmd No 0x4b
void CFileView::CmdKeyMakeDir(void)
{
	MakeDir();

}

// Cmd No 0x4c
void CFileView::CmdKeySelectDrive(void)
{
	SelectDrive();
	m_bInitFileList = true;
}

// Cmd No 0x4d
void CFileView::CmdKeyMoveFile(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	CopyFile(true);
}

// Cmd No 0x4e
void CFileView::CmdKeyChangeName(bool bNameOnly)
{
	CString fname;
	int mn;

	if ( m_pFmParam->m_FileNum == 0 ) return;

	CString scfile;
	scfile = _T("");

	mn = m_pFmParam->m_TagFileNum;

	CString cpath, sfname, dfname;

	if ( mn == 0 ) {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;

		fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		CString cfname = fname;
		bool retry = true;

		while (retry) {

			retry = false;

			CChangeNameDialog dlg;
			dlg.m_FileName = cfname;
			dlg.m_Message = _T("");
			dlg.m_pFmParam = m_pFmParam;
			if (bNameOnly) dlg.m_bSetNameOnlyCheck = true;

			int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
			if ((at & _A_SUBDIR) != 0) dlg.m_bDir = true;

			int r = dlg.DoModal();

			if (r == IDOK) {
				cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				sfname = cpath + fname;
				dfname = cpath + dlg.m_FileName;

				try
				{
					CFile::Rename(sfname, dfname);
				}
				catch (CFileException* pEx)
				{
					cfname = dlg.m_FileName;

					CString s;
					s.Format(_T("[ %s ]\nt@CύXł܂ł!"), dfname);
					MessageBox(s, _T("G["));
					pEx->Delete();

					retry = true;
				}
				if (!retry) {
					UpdateFileList();
					scfile = dlg.m_FileName;
					MoveCursor(scfile);
					Invalidate();

				}
			}
			else {
				scfile = _T("");
			}

		}
	} else {


		for ( int i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( !(m_pFmParam->m_pMark[i]) ) continue;
			fname = m_pFmParam->m_pw64FindData[i].name;
			CString cfname = fname;

			bool retry = true;
			int r = IDCANCEL;

			while (retry) {

				retry = false;


				CChangeNameDialog dlg;
				dlg.m_EnableSkipButton = true;
				dlg.m_pFmParam = m_pFmParam;
				dlg.m_FileName = cfname;
				dlg.m_Message = _T("");
				dlg.m_pFmParam = m_pFmParam;

				int at = m_pFmParam->m_pw64FindData[i].attrib;

				if (bNameOnly) dlg.m_bSetNameOnlyCheck = true;
				dlg.m_bDir = false;
				if ((at & _A_SUBDIR) != 0) dlg.m_bDir = true;

				r = dlg.DoModal();

				if (r == IDOK) {
					cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
					sfname = cpath + fname;
					dfname = cpath + dlg.m_FileName;

					try
					{
						CFile::Rename(sfname, dfname);
						fname = dlg.m_FileName;
						wcscpy_s(m_pFmParam->m_pw64FindData[i].name, fname.GetLength() + 1, fname);
					}
					catch (CFileException* pEx)
					{
						cfname = dlg.m_FileName;

						CString s;
						s.Format(_T("[ %s ]\nt@CύXł܂ł!"), dfname);
						MessageBox(s, _T("G["));
						pEx->Delete();

						retry = true;
					}
				}
				else {
					if (r == IDCANCEL) break;
				}
			}
			if (r == IDCANCEL) break;
		}

		if ( m_pFmParam->m_SortMode != SORT_NON )  m_pFmParam->SortFileList(m_pFmParam->m_SortMode);
	}

}

// Cmd No 0x4f
void CFileView::CmdKeyMovePosOrgWindow(void)
{
	CRect rc;

	rc.top = DEF_WINDOW_SIZE_TOP;
	rc.left = DEF_WINDOW_SIZE_LEFT;
	rc.right = DEF_WINDOW_SIZE_RIGHT;
	rc.bottom = DEF_WINDOW_SIZE_BOTTOM;

	CWinApp *pApp = AfxGetApp();
	CString tmp, sSection, sEntry;

	tmp = _T("%s%02d");
	sSection.Format(tmp, INISECTION_ANNSFM, m_pFmParam->m_annsFMNo);
	sEntry = INIENTRY_WINDOW_orgTOP;
	rc.top = pApp->GetProfileInt(sSection, sEntry, rc.top);
	sEntry = INIENTRY_WINDOW_orgLEFT;
	rc.left = pApp->GetProfileInt(sSection, sEntry, rc.left);
	sEntry = INIENTRY_WINDOW_orgRIGHT;
	rc.right = pApp->GetProfileInt(sSection, sEntry, rc.right);
	sEntry = INIENTRY_WINDOW_orgBOTTOM;
	rc.bottom = pApp->GetProfileInt(sSection, sEntry, rc.bottom);

	m_pChildView->m_pMainFrame->MoveWindow(rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top);

}


// Cmd No 0x50
void CFileView::CmdKeyPack(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	PackFile();

}

// Cmd No 0x51
void CFileView::CmdKeyQuit(void)
{
//	DeleteAllView();
//	if ( m_pTreeFrameWindow != NULL ) m_pTreeFrameWindow->DestroyWindow();;

	AfxGetMainWnd()->PostMessage(WM_COMMAND, ID_APP_EXIT);
}

// Cmd No 0x52
void CFileView::CmdKeyRunProgram(void)
{
	CRunProgramDialog dlg;

	dlg.m_pFmParam = m_pFmParam;
	dlg.m_sRunExe = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	int r = dlg.DoModal();

	if ( r == IDOK ) {

		CString sExe = dlg.m_sRunExe;
		m_pFmParam->MakeFullPath(sExe);
		sExe = m_pFmParam->m_FullPath;
		CString fext;
		fext = _T(".hie");
		m_pFmParam->WriteHistoryFile(fext, sExe);
		fext = _T(".hip");
		m_pFmParam->WriteHistoryFile(fext, dlg.m_sParam, true);

		CString path;
		path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		CString tmp;
		tmp = _T("open");
//		ShellExecute(this->m_hWnd, tmp, dlg.m_sRunExe, dlg.m_sParam, path, SW_SHOW);
		ShellExecute(this->m_hWnd, tmp, sExe, dlg.m_sParam, path, SW_SHOW);
	}
}


// Cmd No 0x53
void CFileView::CmdKeySort(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	CSelectSortDialog dlg;

	dlg.m_bSortExplorerCheck = m_pFmParam->m_bSortExplorer;
	dlg.m_InitSortOrder = m_pFmParam->m_bInitSortOrder;

	int r = dlg.DoModal();
	if ( r != IDCANCEL ) {
		m_pFmParam->m_bSortExplorer = dlg.m_bSortExplorerCheck;
		int oldsmode = m_pFmParam->m_SortMode;
		m_pFmParam->m_SortMode = dlg.m_SortMode;
		m_pFmParam->m_SortOrder = dlg.m_SortOrder;
		if ( (m_pFmParam->m_SortMode != SORT_NON) && (oldsmode != SORT_NON) )  m_pFmParam->SortFileList(m_pFmParam->m_SortMode);
		else UpdateFileList(true);
		Invalidate();
	}
	DrawCursor();

}

// Cmd No 0x54
void CFileView::CmdKeyTree(void)
{
//	m_pFmParam->m_bRedrawFocus = false;

//	if ( m_pTreeFrameWindow != NULL ) return;
	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}
	if ( m_pFmParam->m_bEnableJumpWindow ) return;

	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
//	m_pTreeFrameWindow->m_pFileView = this;
//	m_pTreeFrameWindow->m_bExit = false;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();

}

// Cmd No 0x55
void CFileView::CmdKeyUnpack(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	UnPackFile();
	SetFocus();
}

// Cmd No 0x56
void CFileView::CmdKeyView(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	CreateannsView(false, m_pFmParam->m_bViewannsFMtextExe);
}

// Cmd No 0x58
void CFileView::CmdKeyDeleteExif(void)
{
	if (m_pFmParam->m_FileNum == 0) return;


	CString sResf, tmp, tmp2;
	tmp = EXIF_RESPONSE_FILENAME;
	tmp2 = m_pFmParam->GetExePath(tmp);
	sResf = _T("@") + tmp2;

	setlocale(LC_ALL, ".ACP");
	CStdioFile cfile;
	if (!cfile.Open(tmp2, CFile::modeWrite | CFile::modeCreate)) {
		tmp.Format(_T("[ %s ]\nX|Xt@C̍쐬Ɏs܂!"));
		MessageBox(tmp, _T("I[vG["));
		return;
	}


	CString path, sfname;

	if (m_pFmParam->m_TagFileNum != 0) {

		int i;

		path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

		for (i = 0; i < m_pFmParam->m_FileNum; i++) {
			if (m_pFmParam->m_pMark[i]) {
				sfname = path;
				//				sfname += STR_YEN;
				sfname += m_pFmParam->m_pw64FindData[i].name;
				sfname += _T("\n");

				int at = m_pFmParam->m_pw64FindData[i].attrib;
				if ((at & _A_SUBDIR) == 0) {

					cfile.WriteString(sfname);

				}

			}
		}

	}
	else {


		path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

		sfname = path;
		//		sfname += STR_YEN;
		sfname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		sfname += _T("\n");

		int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
		if ((at & _A_SUBDIR) == 0) {
			cfile.WriteString(sfname);

		}

	}


	cfile.Close();

	tmp = _T("open");

	path = m_pFmParam->GetExePath(_T(""));

	CString sBe = _T("");
	sBe = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolBonsExif);
	ShellExecute(this->m_hWnd, tmp, sBe, sResf, path, SW_SHOW);


}

// Cmd No 0x59
void CFileView::CmdKeySetWildCard(void)
{
	CWildCardDialog dlg;
	dlg.m_sWildCard = m_pFmParam->m_sWildCard;
	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r == IDOK ) {

		CString cf;
		cf = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

		m_pFmParam->m_bMaskDir = dlg.m_bMaskdirCheck;
		m_pFmParam->m_sWildCard = dlg.m_sWildCard;
		if ( m_pFmParam->m_sWildCard == _T("") ) m_pFmParam->m_sWildCard = _T("*.*");

		CString fext;
		fext = _T(".hiy");
		if (  m_pFmParam->m_sWildCard != _T("*.*") ) {
			m_pFmParam->WriteHistoryFile(fext, m_pFmParam->m_sWildCard);
		}
		UpdateFileList();
		m_pFmParam->WriteIniFileParameter();

		int max = m_pFmParam->m_FileNum;
		for (int n = 0; n < max; n++) {
			CString cfn;
			cfn = m_pFmParam->m_pw64FindData[n].name;
			if (cfn == cf) {
				m_CurrentFileNo = n;
				Invalidate();
				break;
			}
		}
	}
}

// Cmd No 0x5D App key
void CFileView::CmdKeyApp(CPoint point, bool bMouse)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_pFmParam->m_bSettingsWinMenuRB) {
		CString path;

		if (m_pFmParam->m_FileNum == 0) {

			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

			PopupContextMenu(m_hWnd, point, path);

			m_pChildView->Invalidate();

			return;
		}

		if (bMouse) {
			if (m_bRunCmd) return;

			m_bVoiceInit = true;
			DrawCursor(false);

			int fno;
			int x, y;

			x = point.x / (m_ColumnWidth + m_xOfset);
			y = (point.y - m_yOfset) / m_LineHeight;
			//		y = (point.y - m_yOfset) / m_FontHeight;	// v1.xx
			int sn = m_CurrentPage * m_PageFileNum;

			fno = sn + (x * m_MaxLine) + y;
			if (fno < m_pFmParam->m_FileNum) {

				int pm = sn + m_PageFileNum - 1;

				int cmode = m_pFmParam->m_DisplayMode;
				if (m_pFmParam->m_pFileParam[cmode].m_bShowOverPart) {
					pm += m_MaxLine;
				}

				if (fno > pm) fno = pm;

				int xxs = x * (m_ColumnWidth + m_xOfset);
				int xxe = xxs + m_xOfset;
				if (point.x > xxs && point.x < xxe) {
					DrawCursor(false);

					CString s;
					s = m_pFmParam->m_pw64FindData[fno].name;
					if (s != _T("..")) {

						if (m_pFmParam->m_pMark[fno]) {
#ifdef _WINVER_XP
							DrawMark(false, fno);
#endif
#ifndef _WINVER_XP
							if (!m_pFmParam->m_bSystemDirectWrite) {
								DrawMark(false, fno);
							}
#endif
							m_pFmParam->m_TagFileNum--;
							m_pFmParam->m_TagFileSize -= m_pFmParam->m_pw64FindData[fno].size;
						}
						else {
#ifdef _WINVER_XP
							DrawMark(true, fno);
#endif
#ifndef _WINVER_XP
							if (!m_pFmParam->m_bSystemDirectWrite) {
								DrawMark(true, fno);
							}
#endif
							m_pFmParam->m_TagFileNum++;
							m_pFmParam->m_TagFileSize += m_pFmParam->m_pw64FindData[fno].size;
						}
						m_pFmParam->m_pMark[fno] = !(m_pFmParam->m_pMark[fno]);
					}

				}
				else {
					m_CurrentFileNo = fno;
				}
				Invalidate();
				DrawCursor();

				path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

				path += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

				PopupContextMenu(m_hWnd, point, path);

			}
			else {
				path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

				PopupContextMenu(m_hWnd, point, path);

			}

		}
		else {

			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

			CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

			int r = IDYES;
			//		r = MessageBox(_T("J[\ʒũtH_܂̓t@CŃj[N܂B\nJgpXŃj[Nꍇ́AwxĂB"), _T("j[I"), MB_YESNO);

			if (point.y == -2) {
				r = IDNO;
				point.y = -1;
			}

			if (r == IDYES) {
				if (fn.Find(_T("..")) < 0) {
					path += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
				}
			}

			PopupContextMenu(m_hWnd, point, path);

		}

		UpdateFileList(true);

		SetFindNotify();

//		Invalidate();
//		DrawCursor();

//		m_pChildView->Invalidate();

		return;

	}


	if (point.x > 0 && point.y > 0) {
		DrawCursor(false);

		int fno;
		int x, y;

		x = point.x / (m_ColumnWidth + m_xOfset);
		y = (point.y - m_yOfset) / m_LineHeight;
		int sn = m_CurrentPage * m_PageFileNum;

		fno = sn + (x * m_MaxLine) + y;
		if (fno < m_pFmParam->m_FileNum) {

			int pm = sn + m_PageFileNum - 1;
			if (fno > pm) fno = pm;
			m_CurrentFileNo = fno;
		}

		DrawCursor();
		RedrawInfo();
	}
	else {
		point.x = 0;
		point.y = 0;

	}

	m_nSendTo = 0;

	WCHAR lpszPath[1000] = _T("");

	SHGetSpecialFolderPath(this->m_hWnd, lpszPath, CSIDL_SENDTO, FALSE);


	CString wcard = _T("*.*");
	m_sSendToPath = lpszPath;
	m_sSendToPath += _T("\\");
	m_nSendTo = m_pFmParam->GetFileList(m_sSendToPath, m_pw64fdSendTo, 0, wcard, true);


	//	C:\Users\ann\AppData\Roaming\Microsoft\Windows\SendTo

	CMenu pSendTomenu;
	//	m_nSelectSendTo = -1;
	if (m_nSendTo > 25) m_nSendTo = 25;
	if (m_nSendTo != 0) {
		pSendTomenu.CreatePopupMenu();

		CString fn, s, sext;
		bool bf;

		for (int i = 0; i < m_nSendTo; i++) {
			fn = m_pw64fdSendTo[i].name;
			int en = fn.ReverseFind(_T('.'));
			s = fn.Left(en);
			//			sext = fn.Right(fn.GetLength() - en);
			//			sext.MakeUpper();
			bf = true;

			//			if ( s == _T("Fax Recipient") ) s = _T("FAXM");
			//			if ( s == _T("Mail Recipient") ) s = _T("MailM");
			//			if ( s == _T("Desktop (create shortcut)") ) s = _T("fXNgbv(V[gJbg쐬)");

			if (s == _T("Fax Recipient")) bf = false;
			if (s == _T("Mail Recipient")) bf = false;
			if (s == _T("Desktop (create shortcut)")) bf = false;

			if (s == _T("Compressed (zipped) Folder")) {
				s = _T("k");
				bf = false;
				pSendTomenu.AppendMenu(MF_STRING | MF_ENABLED, ID_KEY_P, s);

			}
			/*
			if ( s == _T("hLg") ) {
			bf = false;
			pSendTomenu.AppendMenu(MF_STRING|MF_ENABLED,ID_KEY_C, s);
			}
			*/
			if (bf) {
				//				m_nSelectSendTo = i;
				pSendTomenu.AppendMenu(MF_STRING | MF_ENABLED, ID_MENU_SENDTO + i, s);
			}
		}
	}


	COleDataObject clipboardData;
	clipboardData.AttachClipboard();

	COleDataObject* pDataObject;
	pDataObject = &clipboardData;
	BOOL da = pDataObject->IsDataAvailable(CF_HDROP);
	HDROP hDrop = (HDROP)pDataObject->GetGlobalData(CF_HDROP);

	UINT nFiles = 0;

	if (da)
	{
		nFiles = ::DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);
	}

	CMenu pRmenu;
	pRmenu.CreatePopupMenu();
	if (m_pFmParam->m_FileNum != 0) {
		pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_CTRL_KEY_X, _T("؂(&X)"));
		pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_CTRL_KEY_C, _T("Rs[(&C)"));
	}
	pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_CTRL_KEY_V, _T("\t(&V)"));
	if (m_pFmParam->m_FileNum != 0) {
		pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_KEY_D, _T("폜(&D)"));
		pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_KEY_N, _T("t@C̕ύX(&N)"));
		pRmenu.AppendMenu(MF_SEPARATOR);

		if (m_nSendTo != 0) {
			pRmenu.AppendMenu(MF_POPUP, (UINT)pSendTomenu.GetSafeHmenu(), _T("(&S)"));
		}

		pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_SHIFT_KEY_L, _T("fXNgbvɃV[gJbg쐬(&L)"));
		pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_SHIFT_KEY_P, _T("vpeB(&P)"));
	}

	if (!nFiles) 	pRmenu.EnableMenuItem(ID_CTRL_KEY_V, MF_GRAYED);

	CString fname;
	fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	if (fname == _T("..")) {
		pRmenu.EnableMenuItem(ID_KEY_D, MF_GRAYED);
		pRmenu.EnableMenuItem(ID_CTRL_KEY_C, MF_GRAYED);
		pRmenu.EnableMenuItem(ID_CTRL_KEY_X, MF_GRAYED);
		pRmenu.EnableMenuItem(ID_KEY_N, MF_GRAYED);
		pRmenu.EnableMenuItem(ID_SHIFT_KEY_L, MF_GRAYED);
	}


	ClientToScreen(&point);
	pRmenu.TrackPopupMenu(
		TPM_LEFTALIGN |	//NbNXWj[̍ӂɂ
		TPM_RIGHTBUTTON,	//ENbNŃj[I\Ƃ
		point.x, point.y,	//j[̕\ʒu
		this            	//̃j[LEBhE
		);
	pRmenu.DestroyMenu();

	if (m_nSendTo != 0) {
		pSendTomenu.DestroyMenu();
	}


	SetFindNotify();

}

// Cmd No 0x71
void CFileView::CmdKeyF02(void)
{
	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	CString path, s;

	s = _T("Vt@C");

	setlocale(LC_ALL, ".ACP");
	CStdioFile cfile;

	cpath += s;

	CFileStatus rStatus, sStatus;
	if (CFile::GetStatus(cpath, rStatus)) {	// Ƀt@C݂

		int n = AfxMessageBox(_T("wVt@Cxɑ݂܂B㏑Ă낵łH"), MB_YESNO);
		if (n == IDNO) return;


	}

	BOOL b = cfile.Open(cpath, CFile::modeCreate | CFile::modeWrite);

	if (b) {
		cfile.Close();
	}
	else {
		AfxMessageBox(_T("t@C쐬ł܂łB"));

	}

	UpdateFileList();
	Invalidate();
	
}


// Cmd No 0x72
void CFileView::CmdKeyF03(void)
{
	CString tmp, sExe, sParam, cpath;
	tmp = _T("open");
	sExe = m_pFmParam->m_sToolF03exe;
	sParam = m_pFmParam->m_sToolF03Option;
//	sExe = _T("cmd");
//	sParam = _T("/k");
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	ShellExecute(this->m_hWnd, tmp, sExe, sParam, cpath, SW_SHOW);
}


static BOOL CheckTitleBonsFM(LPTSTR lpszTitle)
{
	BOOL bResult = FALSE;

	if (lpszTitle)
	{
		CString st;
		st.Format(_T("%s"), lpszTitle);
		int n = st.Find(_T(" - BonsFM"));
		if (n > 0) {
			bResult = TRUE;

		}
	}

	return bResult;
}


// NŁA\Ă邷ׂĂBonsFM񋓂B
BOOL CALLBACK EnumWindProcBonsFM(HWND hWnd, LPARAM lParam)

{
	HWND FAR* lpHwnd;

	lpHwnd = (HWND FAR*)lParam;


	int nNeedLength = GetWindowTextLength(hWnd);
	if (nNeedLength > 7 && nNeedLength < MAX_PATH + 7)
	{
		if (IsWindow(hWnd) && !IsIconic(hWnd) && IsWindowVisible(hWnd))
		{
			nNeedLength += 8;
			LPTSTR lpBuffer = new TCHAR[nNeedLength];
			ZeroMemory(lpBuffer, nNeedLength * sizeof(TCHAR));
			if (GetWindowText(hWnd, lpBuffer, nNeedLength))
			{
				if (CheckTitleBonsFM(lpBuffer))
				{
					*lpHwnd = hWnd;
					return FALSE;
				}
			}
			delete[] lpBuffer;
		}
	}

	return TRUE;
}


// Cmd No 0x74
void CFileView::CmdKeyF05(void)
{
	HWND hwnd = 0;

	EnumWindows((WNDENUMPROC)&EnumWindProcBonsFM, (LPARAM)&hwnd);

	if (hwnd != 0) {
		::SetForegroundWindow(hwnd);
	}


}

// Cmd No 0x76
void CFileView::CmdKeyF07Launcher(void)
{
	if (m_pFmParam->m_bEnableLauncherWindow) {
		m_pLauncherFrame->SetFocus();
		return;
	}

	m_pFmParam->m_bRedrawFocus = false;

	m_pLauncherFrame = new CLauncherFrame;
	m_pLauncherFrame->m_pFmParam = m_pFmParam;
	m_pLauncherFrame->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pLauncherFrame->m_pwndParent = (CWnd*)this;

	BOOL br = m_pLauncherFrame->LoadFrame(IDR_LAUNCHERVIEWFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pLauncherFrame->m_pLauncherView->m_nCurrentFileNo = m_CurrentFileNo;
	m_pLauncherFrame->ShowWindow(SW_SHOW);
	m_pLauncherFrame->SetWindowText(_T("\tgEFA̋N"));
	m_pLauncherFrame->UpdateWindow();

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	SetCurrentDirectory(cpath);

}

// Cmd No 0x77
void CFileView::CmdKeyF08(void)
{
//	CMenu* pMenu = m_pChildView->m_pMainFrame->GetMenu();


	CString s = _T("annsViewDɐݒ肵܂B");

	if (m_pFmParam->m_bSettingsannsViewHavePriority) {
		m_pFmParam->m_bSettingsannsViewHavePriority = false;
		s = _T("susie Plug-inDɐݒ肵܂B");
//		pMenu->CheckMenuItem(ID_KEY_F8, MF_UNCHECKED);
	}
	else {
		m_pFmParam->m_bSettingsannsViewHavePriority = true;
//		pMenu->CheckMenuItem(ID_KEY_F8, MF_CHECKED);
	}

	MessageBox(s, _T("annsView摜\Dݒ"));

}


// Cmd No 0xbc
void CFileView::CmdKeyTop(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	m_CurrentPage = 0;
	m_CurrentFileNo = 0;

	Invalidate();
}

// Cmd No 0xbf
void CFileView::CmdKeyGoHomeFolder(void)
{
	int i;
	CString s, sCdir, cd;

	sCdir = m_pFmParam->GetEnvStr(m_pFmParam->m_sHomeFolder);

	if ( sCdir == _T("") ) return;
	else {
		CFileStatus rStatus;
		if ( !(CFile::GetStatus(sCdir, rStatus)) ) { // tH_݂Ȃ
			return;
		}
	}
	if ( sCdir.GetAt(sCdir.GetLength() - 1) != CHAR_YEN ) sCdir += STR_YEN;
	cd = sCdir.Left(3);
	cd.MakeUpper();

	for (i = 0; i < 26 ; i++) {
		s = m_pFmParam->m_pDriveParam->m_pCurrentPath[i].Left(3);
		if ( s == cd ) {
			m_pFmParam->m_pDriveParam->m_pCurrentPath[i] = sCdir;
			break;
		}
	}
	if ( i > 25 ) return;

	m_pFmParam->ClearMark();

//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	m_pFmParam->m_CurrentDriveNo = i;
	m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
	m_CurrentFileNo = 0;

	s = m_pFmParam->m_pDriveParam->m_pCurrentPath[i];
	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
	UpdateFileList();
//	Invalidate();

	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	SetCurrentDirectory(cpath);

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}


// Cmd No 0x80 PostCommand(WM_KEYDOWN)ł̓R}h
void CFileView::RunPostCmd(void)
{
}

// Cmd No 0xdc
void CFileView::CmdKeyMoveRoot(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;
	MoveRoot();
}

// Shift +
// Cmd No 0x10d Shift Enter
void CFileView::CmdKeyShiftEnter(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	CString cpath, fname, cfname, tmp;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	tmp = _T("open");

	CString sEditor, sOption;

	sEditor = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolEditor);
	sOption = _T("");
	int n = sEditor.ReverseFind(_T('\"'));
	if (n > 0) {
		sOption = sEditor.Mid(n + 1);
		sEditor = sEditor.Mid(1, n - 1);
	}

	cfname.Format(_T("%s \""), sOption);
//	cfname = _T("\"");
	cfname += cpath;
	cfname += fname;
	cfname += _T("\"");
	ShellExecute(this->m_hWnd, tmp, sEditor, cfname, cpath, SW_SHOW);
//	ShellExecute(this->m_hWnd, tmp, m_pFmParam->m_sToolEditor, cfname, cpath, SW_SHOW);

}


// Cmd No 0x124
void CFileView::CmdKeyShiftHome(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	if ( m_pFmParam->CheckMarkExist() ) m_pFmParam->ClearMark();
	else m_pFmParam->SetMarkAll();
	Invalidate();
}

// Cmd No 0x125
void CFileView::CmdKeyShiftLeft(void)
{

		OSVERSIONINFOEX OSver;
		ULONGLONG condition = 0;
		OSver.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
		OSver.dwMajorVersion = 6;
		OSver.dwMinorVersion = 0;

		VER_SET_CONDITION(condition, VER_MAJORVERSION, VER_GREATER_EQUAL);

		if ( VerifyVersionInfo(&OSver, VER_MAJORVERSION, condition) ) {	// ver6 VistaȏȂ


/*
	OSVERSIONINFO OSver;
	OSver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&OSver);
	
		if (OSver.dwMajorVersion >= 6) {
*/
			HRESULT hr;
			HRESULT mute;
			BOOL muted = false;

//			CoInitialize(NULL);
			IMMDeviceEnumerator *deviceEnumerator = NULL;
			hr = CoCreateInstance(__uuidof(MMDeviceEnumerator), NULL, CLSCTX_INPROC_SERVER, __uuidof(IMMDeviceEnumerator), (LPVOID *)&deviceEnumerator);
			IMMDevice *defaultDevice = NULL;
			hr = deviceEnumerator->GetDefaultAudioEndpoint(eRender, eConsole, &defaultDevice);
			deviceEnumerator->Release();
			deviceEnumerator = NULL;

			IAudioEndpointVolume *endpointVolume = NULL;
			hr = defaultDevice->Activate(__uuidof(IAudioEndpointVolume), CLSCTX_INPROC_SERVER, NULL, (LPVOID *)&endpointVolume);
			defaultDevice->Release();
			defaultDevice = NULL;

			mute = endpointVolume->GetMute( &muted );
			endpointVolume->SetMute(!muted, NULL);
			endpointVolume->Release();
//			CoUninitialize();
		} else {
			ReverseMasterMute();
		}
}


// Cmd No 0x141
void CFileView::CmdKeyShiftAannsFM(void)
{
	CString fname;
	fname = m_pFmParam->GetExePath(_T("annsFM.exe"));

	CString path;
	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	CString tmp;
	tmp = _T("open");
	ShellExecute(this->m_hWnd, tmp, fname, path, path, SW_SHOW);
}


// Cmd No 0x142
void CFileView::CmdKeyShiftBCopyFileNameTextClipboard(void)
{
	int nTag = m_pFmParam->m_TagFileNum;
	int size, nFile;

	m_saDropFilesArray.RemoveAll();

	if ( nTag == 0 ) {	// It@CȂ
		CString fname;
		fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		m_saDropFilesArray.Add(fname);
		size = fname.GetLength();
		nFile = 1;

	} else {
		int nt = m_pFmParam->m_FileNum;
		int num = nt;
		size = 0;
		nFile = 0;

		CString fname = _T("");
		size = 0;

		for ( int n = 0; n < nt; n++ ) {
			if ( !m_pFmParam->m_pMark[n] ) continue;

			fname = m_pFmParam->m_pw64FindData[n].name;
			m_saDropFilesArray.Add(fname);
			size += fname.GetLength() + 2;
		}
		nFile = nTag;

	}

	size++;
	int sof = sizeof(wchar_t);
	int hsize = size * sof;


	CString fname;
	int asize;
	wchar_t *cbuf, *pcb;
	cbuf = new wchar_t[hsize];
	pcb = cbuf;

	for ( int i = 0; i < nFile; i++ ) {
		fname = m_saDropFilesArray.GetAt(i);
		if (nTag != 0) fname += _T("\r\n");
		asize = fname.GetLength();
		memcpy(pcb, fname.GetBuffer(), asize * sof);
		pcb += asize;
	}
	*pcb = '\0';
	pcb++;
	*pcb = '\0';


	HGLOBAL hg = (HGLOBAL)::GlobalAlloc(GHND | GMEM_SHARE, hsize);
	if (hg == NULL) {
		delete []cbuf;
        return;
	}

	PTSTR ptStr = (PTSTR)GlobalLock(hg);

	::memcpy(ptStr, cbuf, hsize);

	delete []cbuf;

	GlobalUnlock(hg);


	if( !OpenClipboard() ) {
		return;
	}

	EmptyClipboard();
	SetClipboardData(CF_UNICODETEXT, hg);
	CloseClipboard();


}


// Cmd No 0x143
void CFileView::CmdKeyShiftCCloseUncTab(void)
{

	int max = m_pDriveTabWnd->m_MaxTab;
	bool b = false;

	for ( int i = 0; i < max; i++ ) {
		CString sdrv;
		sdrv = m_pDriveTabWnd->m_pDriveList[i];
		if ( sdrv.Find(_T("\\\\")) == 0 ) {
			b = true;
			break;
		}
	}

	if ( !b ) return;
	m_pFmParam->m_bRedrawFocus = false;

	CCloseUncTabDialog dlg;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	int ret = dlg.DoModal();
	if ( ret == IDOK ) {
//		m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);
		int drvno = dlg.m_DriveNo + 26;

		max = MAXDRIVE - 1;
		int i;
		for ( i = drvno; i < max; i++ ) {
			m_pFmParam->m_pDriveParam->m_pExist[i] = m_pFmParam->m_pDriveParam->m_pExist[i + 1];
			m_pFmParam->m_pDriveParam->m_pType[i] = m_pFmParam->m_pDriveParam->m_pType[i + 1];
			m_pFmParam->m_pDriveParam->m_pCurrentPath[i] = m_pFmParam->m_pDriveParam->m_pCurrentPath[i + 1];
		}
		m_pFmParam->m_pDriveParam->m_pExist[i] = FALSE;

		for( i = drvno; i > 0; i-- ) {
			if ( m_pFmParam->m_pDriveParam->m_pExist[i] ) {
				break;
			}
		}

		bool bch = false;
		if ( m_pFmParam->m_CurrentDriveNo == drvno ) {
			bch = true;
			m_pFmParam->m_CurrentDriveNo = i;
		}
		m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();

		if ( bch ) {
			m_pFmParam->ClearMark();
			ChangeDirectory(m_pFmParam->m_CurrentDriveNo);
		}

		m_pDriveTabWnd->Invalidate();

		m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);
	}
}

// Cmd No 0x144
void CFileView::CmdKeyShiftDChangeDisplayAttribute(void)
{
	CChangeDisplayAttributeDialog dlg;

//	dlg.m_bHoldChangeAtt = m_pFmParam->m_bSettingsHoldChangeAtt;

	dlg.m_bSystem = false;
	dlg.m_bHide = false;
	if (m_pFmParam->m_bSettingsHoldChangeAtt) {
		dlg.m_bSystem = m_pFmParam->m_bListDisplaySystem;
		dlg.m_bHide = m_pFmParam->m_bListDisplayHide;
	}

	int ret = dlg.DoModal();
	if ( ret == IDOK ) {
		m_pFmParam->m_bListDisplaySystem = dlg.m_bSystem; 
		m_pFmParam->m_bListDisplayHide = dlg.m_bHide; 

		CString s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
		m_pFmParam->ClearMark();
		Invalidate();
	}
}

// Cmd No 0x145
void CFileView::CmdKeyShiftEExplorer(void)
{
	CString path, fn;
	CString tmp, tmp2;

	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	tmp = _T("open");


	tmp2 = _T("\"");
	tmp2 += path;
	tmp2 += _T("\"");

	fn = _T("explorer.exe");

	ShellExecute(this->m_hWnd, tmp, fn, tmp2, tmp2, SW_SHOW);

}

// Cmd No 0x146
void CFileView::CmdKeyShiftFRestoreZip(void)
{
		CString fname;

		fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

		m_pFmParam->DivideFileName(fname);
		CString sext = m_pFmParam->m_sExt;
		sext.MakeUpper();

		if ( sext != ".ZIP" ) {
			MessageBox(_T("̃t@Czipɂł͂܂B"));
			return;
		}


	CRestoreZipDialog dlg;

	int id = dlg.DoModal();

	if ( id == IDOK ) {
		bool bfixfix = dlg.m_bFFCheck;
		int nzip = dlg.m_nZipDllCombo;

		RestoreZip(nzip, bfixfix);
	}
}

// Cmd No 0x147
void CFileView::CmdKeyShiftGPlayMovie(void)
{
	CString cpath, fname, cfname, tmp, s;


	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;


	tmp = _T("open");
	cfname = _T("\"") + cpath + fname + _T("\"");
	s = m_pFmParam->GetEnvStr(m_pFmParam->m_sToolMoviePlayer);

	CFileStatus rStatus;
	if (CFile::GetStatus(s, rStatus)) {	// Đ\tgt@C݂
		ShellExecute(this->m_hWnd, tmp, s, cfname, cpath, SW_SHOW);
	}
	else {
		CmdKeyCtrlGPlayMovie();
	}

}

// Cmd No 0x149
void CFileView::CmdKeyShiftISetParam(void)
{

	int n = GetNoUsedViewNo();

	while (n > 0) {
		n--;
		m_pViewFrame[n]->DestroyWindow();
	}

	CSetparamDialog dlg;

	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r != IDOK ) return;

	if (dlg.m_bSave) {
		CmdKeyCtrlIWriteIniFile();
	}

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP

		CFont TextFont;

		VERIFY(TextFont.CreateFont(
			m_pFmParam->m_logfontFile.lfHeight,                        // nHeight
			0,                         // nWidth
			0,                         // nEscapement
			0,                         // nOrientation
//			m_pFmParam->m_logfontFile.lfWeight, // nWeight
			FW_NORMAL,                 // nWeight
//			m_pFmParam->m_logfontFile.lfItalic, // bItalic
			FALSE,                     // bItalic
			FALSE,                     // bUnderline
			0,                         // cStrikeOut
			128,              // nCharSet
			OUT_DEFAULT_PRECIS,        // nOutPrecision
			CLIP_DEFAULT_PRECIS,       // nClipPrecision
			DEFAULT_QUALITY,           // nQuality
//			m_pFmParam->m_logfontFile.lfPitchAndFamily, // nPitchAndFamily
			0x31,  // nPitchAndFamily
			m_pFmParam->m_logfontFile.lfFaceName));                 // lpszFacename

		TextFont.GetLogFont(&(m_pFmParam->m_logfontFile));

		TextFont.DeleteObject();

		VERIFY(TextFont.CreateFont(
			m_pFmParam->m_logfontView.lfHeight,                        // nHeight
			0,                         // nWidth
			0,                         // nEscapement
			0,                         // nOrientation
//			m_pFmParam->m_logfontView.lfWeight, // nWeight
			FW_NORMAL,                 // nWeight
//			m_pFmParam->m_logfontView.lfItalic, // bItalic
			FALSE,                     // bItalic
			FALSE,                     // bUnderline
			0,                         // cStrikeOut
			128,              // nCharSet
			OUT_DEFAULT_PRECIS,        // nOutPrecision
			CLIP_DEFAULT_PRECIS,       // nClipPrecision
			DEFAULT_QUALITY,           // nQuality
									   //			m_pFmParam->m_logfontFile.lfPitchAndFamily, // nPitchAndFamily
			0x31,  // nPitchAndFamily
			m_pFmParam->m_logfontView.lfFaceName));                 // lpszFacename

		TextFont.GetLogFont(&(m_pFmParam->m_logfontView));

		TextFont.DeleteObject();

		m_pFmParam->m_logfontInfo = m_pFmParam->m_logfontFile;
		m_pFmParam->m_logfontDriveTab = m_pFmParam->m_logfontFile;
//		m_pFmParam->m_logfontView = m_pFmParam->m_logfontFile;
		m_pFmParam->m_logfontViewGuide = m_pFmParam->m_logfontFile;
		m_pFmParam->m_logfontJump = m_pFmParam->m_logfontFile;
		m_pFmParam->m_logfontLauncher = m_pFmParam->m_logfontFile;
		m_pFmParam->m_logfontTree = m_pFmParam->m_logfontFile;


		DiscardTextFormat();
		DiscardDeviceResources();

		m_pDriveTabWnd->DiscardTextFormat();
		m_pDriveTabWnd->DiscardDeviceResources();

		m_pInfoWnd->DiscardTextFormat();
		m_pInfoWnd->DiscardDeviceResources();

		CreateTextFormat();
		CreateDeviceResources();

		m_pDriveTabWnd->CreateTextFormat();
		m_pDriveTabWnd->CreateDeviceResources();

		m_pInfoWnd->CreateTextFormat();
		m_pInfoWnd->CreateDeviceResources();

#endif
	}



	CRect rc;
	m_pChildView->m_pMainFrame->GetWindowRect(&rc);
	rc.bottom += 1;
	m_pChildView->m_pMainFrame->MoveWindow(&rc);
	rc.bottom -= 1;
	m_pChildView->m_pMainFrame->MoveWindow(&rc);

	CString s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
	m_pFmParam->ClearMark();

	m_pFmParam->SortFileList(m_pFmParam->m_SortMode);
	m_pChildView->Invalidate();

	Invalidate();



}


// Cmd No 0x14c
void CFileView::CmdKeyShiftLCreateShortcut(void)
{
	CString cpath, fname, cfname, slink;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	cfname = cpath;
	cfname += fname;

	slink.Format(_T("%s̃V[gJbg"), fname);
	m_pFmParam->CreateShortcut(cfname, slink);
}

// Cmd No 0x14e
void CFileView::CmdKeyShiftNConnectNetwork(void)
{
	m_pFmParam->m_bRedrawFocus = false;
	CConnectNetworkDialog dlg;

	dlg.m_pFileView = this;
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	dlg.DoModal();
}

// Cmd No 0x14f
void CFileView::CmdKeyShiftOSavePosOrgWindow(void)
{
	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry, tmp;
	CRect rc;
	m_pChildView->m_pMainFrame->GetWindowRect(&rc);

	tmp = _T("%s%02d");
	sSection.Format(tmp, INISECTION_ANNSFM, m_pFmParam->m_annsFMNo);
	sEntry = INIENTRY_WINDOW_TOP;
	sEntry = INIENTRY_WINDOW_orgTOP;
	pApp->WriteProfileInt(sSection, sEntry, rc.top);
	sEntry = INIENTRY_WINDOW_LEFT;
	sEntry = INIENTRY_WINDOW_orgLEFT;
	pApp->WriteProfileInt(sSection, sEntry, rc.left);
	sEntry = INIENTRY_WINDOW_RIGHT;
	sEntry = INIENTRY_WINDOW_orgRIGHT;
	pApp->WriteProfileInt(sSection, sEntry, rc.right);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	sEntry = INIENTRY_WINDOW_orgBOTTOM;
	pApp->WriteProfileInt(sSection, sEntry, rc.bottom);

	tmp = _T("EBhEʒuL܂B");
	MessageBox(tmp);
}

// Cmd No 0x150
void CFileView::CmdKeyShiftPOpenProperties(void)
{
	CString cpath, fname, cfname, tmp;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

	tmp = _T("properties");
	cfname = cpath + fname;

	SHELLEXECUTEINFO sei;

	sei.cbSize = sizeof(sei);
	sei.fMask  = SEE_MASK_NOCLOSEPROCESS | SEE_MASK_INVOKEIDLIST | SEE_MASK_FLAG_NO_UI;
	sei.lpVerb = tmp;
	sei.hwnd = this->m_hWnd;
	sei.lpParameters = NULL;
	sei.lpDirectory = NULL;
	sei.lpIDList = NULL;
	sei.lpFile = cfname;
	
	ShellExecuteEx(&sei);

}

// fBNg̑TCY擾
__int64 CFileView::GetDirSize(CString sDirname, int nNo)
{

	struct _wfinddata64_t c_file;
	intptr_t hFile;
	CString fpath, fn, mydir, parentdir, wCard, fullname;
	int at;
	CFileStatus rStatus;
	if (nNo == -1) nNo = m_CurrentFileNo;

	mydir = _T(".");
	parentdir = _T("..");

	wCard = _T("\\*.*");
	fpath = sDirname + wCard;

	if ((hFile = _wfindfirst64(fpath, &c_file)) != -1L) {

		CString tmp, s;
		while (true) {

			if (!m_bNowGetDir) break;

			MSG aMsg;
			while (::PeekMessage(&aMsg, NULL, 0, 0, PM_REMOVE))
			{
				::TranslateMessage(&aMsg);
				::DispatchMessage(&aMsg);
			}

			at = c_file.attrib;
			fn = c_file.name;
			fullname = sDirname;
			fullname += _T("\\");
			fullname += c_file.name;
			if ((at & _A_SUBDIR) != 0) {	// DIRȂ
				if ((fn != mydir) && (fn != parentdir)) {
					GetDirSize(fullname, nNo);
				}
			}
			else {
				m_i64DirSize += c_file.size;

			}

			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose(hFile);
	}


	m_pFmParam->m_pDirSize[nNo].Size = m_i64DirSize;
	bool b = false;
	if (nNo = m_CurrentFileNo) b = true;
	if (m_pFmParam->m_nVoiceGuide == 0 ) DrawCursor(b, nNo);

	return m_i64DirSize;

}

// Cmd No 0x153
void CFileView::CmdKeyShiftSDrawDirSize(void)
{

	CString cfname;

	if (m_pFmParam->m_TagFileNum == 0) {

		unsigned int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
		CString cf = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ((at & _A_SUBDIR) == 0 || cf == _T(".") || cf == _T("..")) {	// DIRłȂ/./..
			return;
		}

		cfname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		cfname += cf;
		m_pFmParam->m_pDirSize[m_CurrentFileNo].Enable = true;
		m_pFmParam->m_pDirSize[m_CurrentFileNo].Size = 0;
		m_i64DirSize = 0;
		m_bNowGetDir = true;
		__int64 dsize = GetDirSize(cfname);
		m_bNowGetDir = false;

		DrawCursor();
	}
	else {
		for (int i = 0; i < m_pFmParam->m_FileNum; i++) {
			if (!(m_pFmParam->m_pMark[i])) continue;

			unsigned int at = m_pFmParam->m_pw64FindData[i].attrib;
			CString cf = m_pFmParam->m_pw64FindData[i].name;
			if ((at & _A_SUBDIR) == 0 || cf == _T(".") || cf == _T("..")) {	// DIRłȂ/./..
				continue;
			}

			cfname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			cfname += cf;
			m_pFmParam->m_pDirSize[i].Enable = true;
			m_pFmParam->m_pDirSize[i].Size = 0;
			m_i64DirSize = 0;
			m_bNowGetDir = true;
			__int64 dsize = GetDirSize(cfname, i);
			m_bNowGetDir = false;

			bool b = false;
			if (i == m_CurrentFileNo) b = true;
			DrawCursor(b, i);
		}
	}




//	Invalidate();

}

// Cmd No 0x156
void CFileView::CmdKeyShiftVChangeVolumeLabel(void)
{
	CChangeVolumeLabelDialog dlg;

	CString cpath, root;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	root = cpath.Left(3);
	dlg.m_sRootPath = root;

	wchar_t volume[50];
	wchar_t fsname[50];
	DWORD sn, ml, flag;

	GetVolumeInformation(root, &volume[0], 50, &sn, &ml, &flag, &fsname[0], 50);

	CString sVolume;
	sVolume.Format(_T("%s"), volume);

	dlg.m_sVolumeLabel = sVolume;

	int r = dlg.DoModal();

	sVolume = dlg.m_sVolumeLabel;

	if ( r == IDOK ) {
		BOOL bret = SetVolumeLabel( root, sVolume );
		if ( !bret ) {
			CString s;
			s = _T("{[xύXł܂ł!");
			MessageBox(s);
		}
	}

	
}


// Ctrl +


// Cmd No 0x209
void CFileView::CmdKeyCtrlTab(void)
{

	HWND myHwnd = m_pChildView->m_pMainFrame->m_hWnd;
	HWND nHwnd;

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	CString tmp = _T("%s%02d");
	UINT hWndH, hWndL;
	int n = 0;

	for ( int i = 0; i < MAXANNSFMNO; i++ ) {

		sSection.Format(tmp, INISECTION_ANNSFM, i);

		sEntry = INIENTRY_ANNSFM_EXIST;
		int nexist = pApp->GetProfileInt(sSection, sEntry, 0);

		m_phwndannsFM[i] = 0;
		if ( nexist == 1 ) {
			sEntry = INIENTRY_ANNSFM_HWNDH;
			hWndH = pApp->GetProfileInt(sSection, sEntry, 0);
			sEntry = INIENTRY_ANNSFM_HWNDL;
			hWndL = pApp->GetProfileInt(sSection, sEntry, 0);
			nHwnd = (HWND)(hWndH * 0x10000000 + hWndL);
			m_phwndannsFM[n] = nHwnd;
			n++;
		}
	}


	int i;
	HWND iHwnd;
	if ( n > 1 ) {
		for ( i = 0; i < n; i++ ) {
			iHwnd = m_phwndannsFM[i];
			if ( iHwnd == myHwnd ) {
				break;
			}
		}
		int ih = i + 1;
		if ( ih >= n ) nHwnd = m_phwndannsFM[0];
		else nHwnd = m_phwndannsFM[ih];

	}
	::SetForegroundWindow(nHwnd);

}

// Cmd No 0x20d
void CFileView::CmdKeyCtrlEnter(void)
{
	CString fname;
	fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	ShellExecute(NULL, _T("open"), fname, NULL, NULL, SW_SHOW);
}

// Cmd No 0x224
void CFileView::CmdKeyCtrlHome(void)
{
	if ( m_pFmParam->m_FileNum == 0 ) return;

	m_CurrentPage = 0;
	m_CurrentFileNo = 0;
	Invalidate();

}

// Cmd No 0x225
void CFileView::CmdKeyCtrlLeft(void)
{
	if ( m_pMciDialog->m_bNowPlay ) {
		m_pMciDialog->OnBnClickedPauseButton();
	} else {
		if ( m_bMciShow ) {
			m_pMciDialog->OnBnClickedPlayButton();
		}
	}
}
// Cmd No 0x227
void CFileView::CmdKeyCtrlRight(void)
{
	if ( m_bMciShow ) {
		m_pMciDialog->OnLoadList();
		if ( m_pMciDialog->m_nFileListNum != 0 ) m_pMciDialog->OnPlayList();
	}
}
// Cmd No 0x226
void CFileView::CmdKeyCtrlUp(void)
{
	if ( m_pMciDialog->m_bNowPlay ) {
//		m_pMciDialog->m_VolRate = 100;
		m_pMciDialog->OnBnClickedVupButton();
	} else {
/*
	    OSVERSIONINFO OSver; 
		OSver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO); 
		GetVersionEx(&OSver); 
 
		if( OSver.dwMajorVersion >= 6 ) { 
*/

		OSVERSIONINFOEX OSver;
		ULONGLONG condition = 0;
		OSver.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
		OSver.dwMajorVersion = 6;
		OSver.dwMinorVersion = 0;

		VER_SET_CONDITION(condition, VER_MAJORVERSION, VER_GREATER_EQUAL);

		if (VerifyVersionInfo(&OSver, VER_MAJORVERSION, condition)) {	// ver6 VistaȏȂ

			HRESULT hr;

			float fLevelMinDB;
			float fLevelMaxDB;
			float fVolumeIncrementDB;
	  
//			CoInitialize(NULL);
			IMMDeviceEnumerator *deviceEnumerator = NULL;
			hr = CoCreateInstance(__uuidof(MMDeviceEnumerator), NULL, CLSCTX_INPROC_SERVER, __uuidof(IMMDeviceEnumerator), (LPVOID *)&deviceEnumerator);
			IMMDevice *defaultDevice = NULL;
			hr = deviceEnumerator->GetDefaultAudioEndpoint(eRender, eConsole, &defaultDevice);
			deviceEnumerator->Release();
			deviceEnumerator = NULL;

			IAudioEndpointVolume *endpointVolume = NULL;
			hr = defaultDevice->Activate(__uuidof(IAudioEndpointVolume), CLSCTX_INPROC_SERVER, NULL, (LPVOID *)&endpointVolume);
			defaultDevice->Release();
			defaultDevice = NULL;

			float fVlevel;
			endpointVolume->GetMasterVolumeLevel(&fVlevel);
			endpointVolume->GetVolumeRange(&fLevelMinDB, &fLevelMaxDB, &fVolumeIncrementDB);

			fVlevel += (fVolumeIncrementDB * 4);
			if ( fVlevel > fLevelMaxDB ) fVlevel = fLevelMaxDB;
			endpointVolume->SetMasterVolumeLevel(fVlevel, NULL);

			endpointVolume->Release();
//			CoUninitialize();
		} else {
			UpDownMasterVolume(2);
		}
	}

}



// Cmd No 0x228
void CFileView::CmdKeyCtrlDown(void)
{
	if ( m_pMciDialog->m_bNowPlay ) {
//		m_pMciDialog->m_VolRate = 100;
		m_pMciDialog->OnBnClickedVdownButton();
	} else {
/*
	    OSVERSIONINFO OSver; 
		OSver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO); 
		GetVersionEx(&OSver); 
 
		if( OSver.dwMajorVersion >= 6 ) { 
*/
		OSVERSIONINFOEX OSver;
		ULONGLONG condition = 0;
		OSver.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
		OSver.dwMajorVersion = 6;
		OSver.dwMinorVersion = 0;

		VER_SET_CONDITION(condition, VER_MAJORVERSION, VER_GREATER_EQUAL);

		if (VerifyVersionInfo(&OSver, VER_MAJORVERSION, condition)) {	// ver6 VistaȏȂ


			HRESULT hr;

			float fLevelMinDB;
			float fLevelMaxDB;
			float fVolumeIncrementDB;
	  
//			CoInitialize(NULL);
			IMMDeviceEnumerator *deviceEnumerator = NULL;
			hr = CoCreateInstance(__uuidof(MMDeviceEnumerator), NULL, CLSCTX_INPROC_SERVER, __uuidof(IMMDeviceEnumerator), (LPVOID *)&deviceEnumerator);
			IMMDevice *defaultDevice = NULL;
			hr = deviceEnumerator->GetDefaultAudioEndpoint(eRender, eConsole, &defaultDevice);
			deviceEnumerator->Release();
			deviceEnumerator = NULL;

			IAudioEndpointVolume *endpointVolume = NULL;
			hr = defaultDevice->Activate(__uuidof(IAudioEndpointVolume), CLSCTX_INPROC_SERVER, NULL, (LPVOID *)&endpointVolume);
			defaultDevice->Release();
			defaultDevice = NULL;

			float fVlevel;
			endpointVolume->GetMasterVolumeLevel(&fVlevel);
			endpointVolume->GetVolumeRange(&fLevelMinDB, &fLevelMaxDB, &fVolumeIncrementDB);

			fVlevel -= fVolumeIncrementDB;
			if ( fVlevel < fLevelMinDB ) fVlevel = fLevelMinDB;
			endpointVolume->SetMasterVolumeLevel(fVlevel, NULL);

			endpointVolume->Release();
//			CoUninitialize();
		} else {
			UpDownMasterVolume(-2);
		}
	}
}


// Cmd No 0x230-239
void CFileView::CmdKeyCtrlNumber(int n)
{

	CString sKey;
	
	sKey.Format(_T("c+%1d") , n);

	CString path, s;

	s = _T("annsFM.lnc");

	path = m_pFmParam->GetExePath(s);

	setlocale(LC_ALL, ".ACP");

	CFileStatus rStatus, sStatus;
	if (!(CFile::GetStatus(path, rStatus))) {	// t@C݂Ȃ
		AfxMessageBox(_T("\tgEFA̓o^t@C܂B"), MB_OK);
		return;

	}

	CStdioFile cfile;
	cfile.Open(path, CFile::modeRead);

	CString sbuf;

	CString as;
	BOOL r = TRUE;
	int max = MAX_LINE_NUM;
	bool bSetFilename;

	CString exepath, opt, fname, param;

	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;


	for (int i = 0; i < max; i++) {
		if (r) {
			r = cfile.ReadString(sbuf);	// L[

			if (sbuf == sKey) {
				r = cfile.ReadString(sbuf);	// O
				r = cfile.ReadString(sbuf);	// t@Cn

				bSetFilename = false;
				if (sbuf.GetAt(0) == _T('1')) bSetFilename = true;

				r = cfile.ReadString(sbuf);	// pX 
				exepath = sbuf;

				r = cfile.ReadString(sbuf);	// IvV
				opt = sbuf;

				param = _T("");
				param += opt;
				param += _T(" ");

				if (bSetFilename) {
					CString cfn = _T("\"");
					cfn += path;

					if (fname != _T("..")) {
						cfn += fname;

					}
					cfn += _T("\"");
					param += cfn;
				}

				CString tmp;
				tmp = _T("open");
				ShellExecute(this->m_hWnd, tmp, exepath, param, path, SW_SHOW);
				return;

			}
			else {
				r = cfile.ReadString(sbuf);
				r = cfile.ReadString(sbuf);
				r = cfile.ReadString(sbuf);
				r = cfile.ReadString(sbuf);

			}



		}
	}

	cfile.Close();

}


// Cmd No 0x242
void CFileView::CmdKeyCtrlBCopyTextClipboard(bool clear)
{
	int nTag = m_pFmParam->m_TagFileNum;
	int size, nFile;
	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	m_saDropFilesArray.RemoveAll();

	if (nTag == 0) {	// It@CȂ
		CString fname = cpath;
		if (!clear) fname = _T("");
		fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		m_saDropFilesArray.Add(fname);
		size = fname.GetLength();
		nFile = 1;

	}
	else {
		int nt = m_pFmParam->m_FileNum;
		int num = nt;
		size = 0;
		nFile = 0;

		//		CString fname = cpath;
		//		m_saDropFilesArray.Add(fname);
		//		size = fname.GetLength() + 2;

		CString fname;

		for (int n = 0; n < nt; n++) {
			if (!m_pFmParam->m_pMark[n]) continue;
			fname = cpath;
			fname += m_pFmParam->m_pw64FindData[n].name;
			m_saDropFilesArray.Add(fname);
			size += (fname.GetLength() + 2);
		}
		nFile = nTag;

	}

	size++;
	int sof = sizeof(wchar_t);
	size = size * sof;

	int hsize = size;

	CString fname;
	int asize;
	wchar_t *cbuf, *pcb;
	cbuf = new wchar_t[hsize];
	pcb = cbuf;

	for (int i = 0; i < nFile; i++) {
		fname = m_saDropFilesArray.GetAt(i);
		if (nTag != 0) fname += _T("\r\n");
		asize = fname.GetLength();
		memcpy(pcb, fname.GetBuffer(), asize * sof);
		pcb += asize;
	}
	*pcb = '\0';
	pcb++;
	*pcb = '\0';

	HGLOBAL hg = (HGLOBAL)::GlobalAlloc(GHND | GMEM_SHARE, hsize);
	if (hg == NULL) {
		delete[]cbuf;
		return;
	}

	PTSTR ptStr = (PTSTR)GlobalLock(hg);

	::memcpy(ptStr, cbuf, hsize);

	delete[]cbuf;

	GlobalUnlock(hg);


	if (!OpenClipboard()) {
		return;
	}

	if (clear) EmptyClipboard();
	SetClipboardData(CF_UNICODETEXT, hg);
/*
	hsize = sizeof(DROPEFFECT);
	HDROP hDropEffect = (HDROP)::GlobalAlloc(GHND, hsize);
	DROPEFFECT *pDropEffect = (DROPEFFECT*)::GlobalLock(hDropEffect);
	DROPEFFECT dropeffect = DROPEFFECT_COPY;

	char* lpchr = (char *)(pDropEffect);
	char* lpchr2 = (char *)(&dropeffect);

	::memcpy(lpchr, lpchr2, hsize);
	::GlobalUnlock(hDropEffect);

	UINT cfFormat = ::RegisterClipboardFormat(CFSTR_PREFERREDDROPEFFECT);
	SetClipboardData(cfFormat, hDropEffect);
*/

	CloseClipboard();
}

// Cmd No 0x243
void CFileView::CmdKeyCtrlCCopyClipboard(void)
{
	HDROP hDrop = DragCreateFiles ();

	if( !OpenClipboard() ) {
		return;
	}
	EmptyClipboard();

	SetClipboardData(CF_HDROP, hDrop);

	int hsize = sizeof(DROPEFFECT);
	HDROP hDropEffect = (HDROP)::GlobalAlloc(GHND, hsize);
	DROPEFFECT *pDropEffect = (DROPEFFECT*)::GlobalLock(hDropEffect);
	DROPEFFECT dropeffect = DROPEFFECT_COPY;

	char* lpchr = (char *)(pDropEffect);
	char* lpchr2 = (char *)(&dropeffect);

	::memcpy(lpchr, lpchr2, hsize);
	::GlobalUnlock(hDropEffect);

	UINT cfFormat = ::RegisterClipboardFormat(CFSTR_PREFERREDDROPEFFECT);
	SetClipboardData(cfFormat, hDropEffect);

	CloseClipboard();

	CmdKeyCtrlBCopyTextClipboard(false);

}

// Cmd No 0x244
void CFileView::CmdKeyCtrlDDisplayOnOff(void)
{
	SendMessage(WM_SYSCOMMAND, SC_MONITORPOWER, 1);
	Sleep(500);
	SendMessage(WM_SYSCOMMAND, SC_MONITORPOWER, 2);

}

// Cmd No 0x245
void CFileView::CmdKeyCtrlERemoveDrive(void)
{
	CSelectRemoveDrive dlg;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;
	dlg.m_sCurrentPath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	int id = dlg.DoModal();

	if ( id == IDOK ) {
		CString sd = dlg.m_sDriveName;
		int dt = dlg.m_nSelectDriveType;
		bool bm = dlg.m_bRemoveMediaCheck;

		if ( dt == DRIVE_CDROM || bm ) {
//			m_pFmParam->EjectVolume(sd[0]);
			m_pFmParam->EjectMedia(sd[0]);
			MessageBox(m_pFmParam->m_sDeviceError);

		} else {
			bool r = m_pFmParam->RemoveUSB(sd[0]);

			CString s;
			if ( r ) {
				s.Format(_T("hCu %c: ̃fBA͈SɎO܂B"), sd[0]);
				MessageBox(s);
			} else {
				s.Format(_T("hCu %c: ̃fBA̎OɎs܂B"), sd[0]);
				MessageBox(s);
			}
		}
		m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
		OnMenuShiftKeyZ();
	}

}

// Cmd No 0x248
void CFileView::CmdKeyCtrlHHelp(void)
{
	m_pChildView->m_pMainFrame->SendMessage(WM_COMMAND, ID_HELP_MENU);
}

// Cmd No 0x249
void CFileView::CmdKeyCtrlIWriteIniFile(void)
{
	m_pFmParam->WriteIniFile();
	AfxMessageBox(_T("ݒinit@Cɕۑ܂"));
}

// Cmd No 0x24b
void CFileView::CmdKeyCtrlKSelectMark(void)
{
	CWildCardDialog dlg;
	dlg.m_sWildCard = m_pFmParam->m_sWildCard;
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_sWildCard = _T("");

	int r = dlg.DoModal();

	if (r == IDOK) {

		CString cf, sWcard;
		cf = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

		bool bDirCheck = dlg.m_bMaskdirCheck;
		sWcard = dlg.m_sWildCard;


		int nTop = 0;

		int max = m_pFmParam->m_FileNum;
		for (int n = 0; n < max; n++) {
			CString cfn;
			cfn = m_pFmParam->m_pw64FindData[n].name;
			int at = m_pFmParam->m_pw64FindData[n].attrib;

			BOOL pr = m_pFmParam->PathMatchSpecX(cfn, sWcard);

			if (pr) {
				if (!(at & _A_SUBDIR) != 0) {	// DIRłȂȂ
					m_pFmParam->m_pMark[n] = true;
					m_pFmParam->m_TagFileNum++;
					m_pFmParam->m_TagFileSize += m_pFmParam->m_pw64FindData[m_CurrentFileNo].size;
				}
				else {
					if (bDirCheck) {
						m_pFmParam->m_pMark[n] = true;
						m_pFmParam->m_TagFileNum++;
					}
				}
			}
		}
		Invalidate();

		CString fext;
		fext = _T(".hiy");
		if (sWcard != _T("*.*")) {
			m_pFmParam->WriteHistoryFile(fext, sWcard);
		}

	}

}


// Cmd No 0x24d
void CFileView::CmdKeyCtrlMMirrorCopy(void)
{
	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
	if ( (at & _A_SUBDIR) != 0 ) {	// DIRȂ
		CString fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( fname != _T("..") ) cpath += fname;
	}

	CMirrorCopyDialog dlg;

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;

	sSection = INISECTION_PARAMETER;
	sEntry = INIENTRY_PARAMETER_MCOPYDIFFTIME;

	int n = pApp->GetProfileInt(sSection, sEntry, 0);
	dlg.m_bDiffTimeCheck = (n != 0);

	sEntry = INIENTRY_PARAMETER_MCOPYDIFFSIZE;

	n = pApp->GetProfileInt(sSection, sEntry, 0);
	dlg.m_bDiffSizeCheck = (n != 0);

	dlg.m_sSDir = cpath;
	dlg.m_pFmParam = m_pFmParam;
	dlg.m_pDriveTabWnd = m_pDriveTabWnd;

	int ret = dlg.DoModal();
	if ( ret != IDOK ) return;


	m_sMirrorCopySDir = dlg.m_sSDir;
	m_sMirrorCopyDDir = dlg.m_sDDir;

	m_bMCopyDiffTime = dlg.m_bDiffTimeCheck;
	m_bMCopyDiffSize = dlg.m_bDiffSizeCheck;

	sEntry = INIENTRY_PARAMETER_MCOPYDIFFTIME;
	pApp->WriteProfileInt(sSection, sEntry, m_bMCopyDiffTime);

	sEntry = INIENTRY_PARAMETER_MCOPYDIFFSIZE;
	pApp->WriteProfileInt(sSection, sEntry, m_bMCopyDiffSize);


	bool b = dlg.m_bSure;

	MirrorCopy(b);

}

// Cmd No 0x24e
void CFileView::CmdKeyCtrlNChangeNameAll(void)
{
	int nTag = m_pFmParam->m_TagFileNum;
	if ( nTag == 0 ) return;

	CString s;
	s.Format(_T(" %d ̑Iꂽt@C"), nTag);

	m_pChangeNameAllDialog = new CChangeNameAllDialog();
	m_pChangeNameAllDialog->m_sMesStatic = s;

	int nmax = m_pFmParam->m_FileNum;

	CString sFname, sExt;
	sFname = _T("");
	sExt = _T("");

	for( int i = 0; i < nmax; i++ ) {
		if ( m_pFmParam->m_pMark[i] ) {
			CString s = m_pFmParam->m_pw64FindData[i].name;
			m_pFmParam->DivideFileName(s);
			sFname = m_pFmParam->m_sName;
			sExt = m_pFmParam->m_sExt.Right(m_pFmParam->m_sExt.GetLength() - 1);
			i = nmax;
		}
	}

	m_pChangeNameAllDialog->m_sFixedChar = sFname;
	m_pChangeNameAllDialog->m_sFixedChar2 = sExt;

	int ret = m_pChangeNameAllDialog->DoModal();


	if ( ret == IDOK ) {
		CString sFixedChar = m_pChangeNameAllDialog->m_sFixedChar;
		CString sFixedChar2 = m_pChangeNameAllDialog->m_sFixedChar2;

		int num = m_pChangeNameAllDialog->m_iNum;
		int num2 = m_pChangeNameAllDialog->m_iNum2;
		int startNum = m_pChangeNameAllDialog->m_iStartNum;
		int startNum2 = m_pChangeNameAllDialog->m_iStartNum2;
		int addPos = m_pChangeNameAllDialog->m_iAddPos;

		bool efname = m_pChangeNameAllDialog->m_bChangeFilenameCheck;
		bool eext = m_pChangeNameAllDialog->m_bChangeFileextCheck;

		nmax = m_pFmParam->m_FileNum;

		int ns = startNum;
		int ns2 = startNum2;

		CString sFnform, sExform;
		CString cpath;
		cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

		CString sform, sform2;
		sform.Format(_T("%%0%dd"), num);
		sform2.Format(_T("%%0%dd"), num2);

		if ( num == 0 ) sform = _T("");
		if ( num2 == 0 ) sform2 = _T("");

		for( int i = 0; i < nmax; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) {
				CString sSfname = cpath;
				s = m_pFmParam->m_pw64FindData[i].name;
				sSfname += s;

				m_pFmParam->DivideFileName(s);
				sFname = m_pFmParam->m_sName;
				sExt = m_pFmParam->m_sExt.Right(m_pFmParam->m_sExt.GetLength() - 1);


				CString sd, sd2, sDfname, sForm;
				switch(addPos) {
					case 0:	// 擪ɕt
						if ( efname ) {
							sFnform = sform + sFixedChar;
							sd.Format(sFnform, ns);
						} else sd = sFname;
						if ( eext ) {
							sExform = sform2 + sFixedChar2;
							sd2.Format(sExform, ns2);
						} else sd2 = sExt;
						break;

					case 1:	// ɕt
						if ( efname ) {
							sFnform = sFixedChar + sform;
							sd.Format(sFnform, ns);
						} else sd = sFname;
						if ( eext ) {
							sExform = sFixedChar2 + sform2;
							sd2.Format(sExform, ns2);
						} else sd2 = sExt;
						break;
					case 2:	// ɕt
						if ( efname ) {
							sFnform = sform + sFixedChar + sform;
							sd.Format(sFnform, ns, ns);
						} else sd = sFname;
						if ( eext ) {
							sExform = sform2 + sFixedChar2 + sform2;
							sd2.Format(sExform, ns2, ns2);
						} else sd2 = sExt;
						break;
				}

				sDfname = cpath;
				s = sd;
				s += _T(".");
				s += sd2;
				sDfname += s;

				try
				{
					CFile::Rename(sSfname, sDfname);
					wcscpy_s(m_pFmParam->m_pw64FindData[i].name, s.GetLength() + 1,s);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CύXł܂ł!"), sDfname);
					MessageBox(s, _T("G["));
					pEx->Delete();
				}

				ns++;
				ns2++;
			}
		}

	}
	if ( m_pFmParam->m_SortMode != SORT_NON )  m_pFmParam->SortFileList(m_pFmParam->m_SortMode);
	Invalidate();

	delete m_pChangeNameAllDialog;

}

// Cmd No 0x24f
void CFileView::CmdKeyCtrlOChangeNameOnly(void)
{
	CmdKeyChangeName(true);

}

// Cmd No 0x250
void CFileView::CmdKeyCtrlPPushCurrentPath(void)
{
	m_pFmParam->m_sValCurrentPath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
}

// Cmd No 0x252
void CFileView::CmdKeyCtrlRPopCurrentPath(void)
{
	m_pFmParam->m_sSelectedJumpPath = m_pFmParam->m_sValCurrentPath;
	OnJumpMessage();
}

// Cmd No 0x253
void CFileView::CmdKeyCtrlSPlaySound(void)
{

	if ( m_pFmParam->m_TagFileNum == 0 ) {

		m_pMciDialog->m_sFileName = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		m_pMciDialog->m_sFullFileName = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		m_pMciDialog->m_sFullFileName += m_pMciDialog->m_sFileName;

		m_pMciDialog->m_bListMode = false;
		DWORD ret = m_pMciDialog->InitializeData();

		m_pMciDialog->ShowWindow(SW_SHOW);
		m_bMciShow = true;
		SetFocus();

	} else {
		CString	filter(_T("Xgt@C (*.fsl)|*.fsl|SẴt@C (*.*)|*.*||"));
		CFileDialog	selDlg(FALSE, NULL, NULL, OFN_FILEMUSTEXIST, filter);
    
		if (selDlg.DoModal() == IDOK) {
			CString fname = selDlg.GetPathName();

			int n = fname.ReverseFind('.');
			if ( n < 0 ) {
				fname += _T(".fsl");
			}

			setlocale( LC_ALL, ".ACP" );
			CStdioFile cfile;

			int max = m_pFmParam->m_TagFileNum;

			if ( !cfile.Open( fname, CFile::modeWrite | CFile::modeCreate ) ) {
				MessageBox(fname, _T("t@C쐬G[I"));
				return;
			}

			CString sbuf, cfname;

			for ( int i = 0; i < m_pFmParam->m_FileNum; i++ ) {
				if ( !(m_pFmParam->m_pMark[i]) ) continue;

				cfname = m_pFmParam->m_pw64FindData[i].name;
				sbuf = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				sbuf += cfname;
				sbuf += _T("\n");
				cfile.WriteString(sbuf);
			}

			cfile.Close();

		}
	}
}

// Cmd No 0x254
void CFileView::CmdKeyCtrlTChangeFileTime(void)
{

	m_t64Write = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_write;
	m_t64Create = m_pFmParam->m_pw64FindData[m_CurrentFileNo].time_create;

	bool b = false;
	int i = 0;
	if ( m_pFmParam->m_TagFileNum != 0 ) {
		int max = m_pFmParam->m_FileNum;
		for ( i = 0; i < max; i++ ) {
			b = m_pFmParam->m_pMark[i];
			if ( b ) break;
		}
	}
	if ( b ) {
		m_t64Write = m_pFmParam->m_pw64FindData[i].time_write;
		m_t64Create = m_pFmParam->m_pw64FindData[i].time_create;
	}

	CChangeFileTimeDialog dlg;

	dlg.m_timeNewDate = m_t64Write;
	dlg.m_timeCreateDate = m_t64Create;

	CString fname, cpath;
	fname =  m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	dlg.m_sFileName =  fname;
	dlg.m_sPathName = cpath;

	if ( b ) dlg.m_sFileName.Format(_T("%d̑Iꂽt@C"), m_pFmParam->m_TagFileNum);

	int r;
	r = dlg.DoModal();

	if ( r == IDCANCEL ) return;

	m_nKindFileCreateDate = 0;
	if ( dlg.m_nSameRadio == BST_CHECKED ) m_nKindFileCreateDate = 1;
	if ( dlg.m_nSetRadio == BST_CHECKED ) m_nKindFileCreateDate = 2;

	m_nChangeFileDate = dlg.m_nChangeCheck;
	m_nChangeAllFileCheck = dlg.m_nChangeAllFileCheck;
	m_nChangeAllDirCheck = dlg.m_nChangeAllDirCheck;

	m_t64Write = dlg.m_timeNewDate;
	m_t64Create = dlg.m_timeCreateDate;

	CFileStatus fStatus;

	if ( m_pFmParam->m_TagFileNum != 0 ) {
		int max = m_pFmParam->m_FileNum;
		for ( i = 0; i < max; i++ ) {
			b = m_pFmParam->m_pMark[i];
			if ( b ) {
				m_sCPathChangeFileTime = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				m_pw64ChangeFileTime = &(m_pFmParam->m_pw64FindData[i]);
				ChangeFileTime(true);
			}
		}
	} else {
		m_sCPathChangeFileTime = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		m_pw64ChangeFileTime = &(m_pFmParam->m_pw64FindData[m_CurrentFileNo]);
		ChangeFileTime(true);
	}
}

// Cmd No 0x256
void CFileView::CmdKeyCtrlVPasteClipboard(void)
{
	COleDataObject clipboardData;
	clipboardData.AttachClipboard();

	COleDataObject* pDataObject;
	pDataObject = &clipboardData;
	BOOL da = pDataObject->IsDataAvailable(CF_HDROP);

	BOOL bMoveFile = FALSE;
	UINT cfFormat = ::RegisterClipboardFormat( CFSTR_PREFERREDDROPEFFECT );
	if ( pDataObject->IsDataAvailable( cfFormat ) )
	{
	HGLOBAL hgHandle = pDataObject->GetGlobalData( cfFormat );
	if ( hgHandle )
	{
			LPDWORD lpDropEffect = (LPDWORD)::GlobalLock( hgHandle );
			bMoveFile = (*lpDropEffect & DROPEFFECT_MOVE) ? TRUE : FALSE;
			::GlobalUnlock( hgHandle );
		}
	}


	HDROP hDrop = (HDROP)pDataObject->GetGlobalData(CF_HDROP);

		if ( da )
		{
			UINT nFiles = ::DragQueryFile( hDrop, 0xFFFFFFFF, NULL, 0 );
			if ( nFiles )
			{

				m_saDropFilesArray.SetSize( nFiles );
				LPTSTR lpFileName = new TCHAR [MAX_PATH];
				UINT nDropFile = 0;

				for ( UINT i = 0 ; i < nFiles ; i ++ )
				{
					if ( ::DragQueryFile( hDrop, i, lpFileName, MAX_PATH ) )
						m_saDropFilesArray.SetAt( nDropFile++, lpFileName );
				}

				::DragFinish( hDrop );
				delete [] lpFileName;

				if ( nDropFile )
				{
					if ( nDropFile != nFiles )
						m_saDropFilesArray.SetSize( nDropFile );

					DROPEFFECT dropeffect = DROPEFFECT_COPY;
					if ( bMoveFile ) dropeffect = DROPEFFECT_MOVE;

					m_pFmParam->m_bCancelCopy = false;
					DropFilesCopy(dropeffect);
//					DropFilesCopy(DROPEFFECT_COPY);

				}
			}
			UpdateFileList(true);
		}
	if ( m_pFmParam->m_nVoiceGuide != 0 ) Beep(BEEP_FREQ, BEEP_DURATION);

}

// Cmd No 0x258
void CFileView::CmdKeyCtrlXCopyCutClipboard(void)
{
// move
	int hsize = sizeof(DROPEFFECT);
	HDROP hDropEffect = (HDROP)::GlobalAlloc(GHND, hsize);

    DROPEFFECT *pDropEffect = (DROPEFFECT*)::GlobalLock(hDropEffect);

	DROPEFFECT dropeffect = DROPEFFECT_MOVE;

	char* lpchr = (char *)(pDropEffect);
	char* lpchr2 = (char *)(&dropeffect);

	::memcpy(lpchr, lpchr2, hsize);
    ::GlobalUnlock(hDropEffect);

//	COleDataSource* pEffectData = new COleDataSource;
	UINT cfFormat = ::RegisterClipboardFormat( CFSTR_PREFERREDDROPEFFECT );
//	pEffectData->Empty();
//	pEffectData->CacheGlobalData( cfFormat, hDropEffect );
//	pEffectData->SetClipboard();
//

	HDROP hDrop = DragCreateFiles ();

	if( !OpenClipboard() ) {
		return;
	}
	EmptyClipboard();

	SetClipboardData(CF_HDROP, hDrop);
	SetClipboardData(cfFormat, hDropEffect);
	CloseClipboard();

	CmdKeyCtrlBCopyTextClipboard(false);

}

// Cmd No 0x25a
void CFileView::CmdKeyCtrlZReverseMark(void)
{
	m_pFmParam->ReverseMark();
	Invalidate();
}

void CFileView::OnMneuKeyA()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeySetAttribute();
}

void CFileView::OnMenuKeyC()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCopyFile();
}


void CFileView::OnMenuKeyD()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyDeleteFile();
	UpdateFileList(true);
}

void CFileView::OnMenuKeyE()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyEditFile();
}

void CFileView::OnMenuKeyF()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyFindFile();
}

void CFileView::OnMenuKeyG()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyGraphView();
}

void CFileView::OnMenuKeyH()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyMovePath();
}

void CFileView::OnMenuKeyJ()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyJump();
}

void CFileView::OnMenuKeyK()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyMakeDir();
}

void CFileView::OnMenuKeyL()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeySelectDrive();
}

void CFileView::OnMenuKeyM()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyMoveFile();
}

void CFileView::OnMenuKeyN()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyChangeName();
	UpdateFileList(true);
}

void CFileView::OnMenuKeyO()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyMovePosOrgWindow();
}

void CFileView::OnMenuKeyP()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyPack();
}

void CFileView::OnMenuKeyQ()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyQuit();
}

void CFileView::OnMenuKeyR()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyRunProgram();
}

void CFileView::OnMenuKeyS()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeySort();
}

void CFileView::OnMenuKeyT()
{
	// TODO: ɃR}h nh R[hǉ܂B
			CmdKeyTree();
}

void CFileView::OnMenuKeyU()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyUnpack();
}

void CFileView::OnMenuKeyV()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyView();
}


void CFileView::OnMenuKeyY()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeySetWildCard();

}




void CFileView::OnMenuShiftKeyA()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftAannsFM();
}

void CFileView::OnMenuShiftKeyB()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftBCopyFileNameTextClipboard();
}

void CFileView::OnMenuShiftKeyC()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftCCloseUncTab();
}

void CFileView::OnMenuShiftKeyD()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftDChangeDisplayAttribute();

}

void CFileView::OnMenuShiftKeyE()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftEExplorer();

}

void CFileView::OnMenuShiftKeyI()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftISetParam();
}

void CFileView::OnMenuShiftKeyL()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftLCreateShortcut();

}

void CFileView::OnMenuShiftKeyM()
{
	// TODO: ɃR}h nh R[hǉ܂B

	MacroCommand();
}

void CFileView::OnMenuShiftKeyN()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftNConnectNetwork();

}

void CFileView::OnMenuShiftKeyO()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftOSavePosOrgWindow();
}

void CFileView::OnMenuShiftKeyP()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftPOpenProperties();
}

void CFileView::OnMenuShiftKeyV()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftVChangeVolumeLabel();
}

void CFileView::OnMenuShiftKeyZ()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pFmParam->m_pDriveParam->GetDriveParam();
	m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
	m_pDriveTabWnd->Invalidate();

	CString s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
	int max = m_pFmParam->m_FileNum - 1;
	if ( m_CurrentFileNo > max ) m_CurrentFileNo = max;
	m_pFmParam->ClearMark();
	Invalidate();
}

void CFileView::OnMenuShiftKey1()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pFmParam->m_DisplayMode = 0;
	Invalidate();
}

void CFileView::OnMenuShiftKey2()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pFmParam->m_DisplayMode = 1;
	Invalidate();
}

void CFileView::OnMenuShiftKey3()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pFmParam->m_DisplayMode = 2;
	Invalidate();
}

void CFileView::OnMenuShiftKey4()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pFmParam->m_DisplayMode = 3;
	Invalidate();
}

void CFileView::OnMenuShiftKey5()
{
	// TODO: ɃR}h nh R[hǉ܂B
	m_pFmParam->m_DisplayMode = 4;
	Invalidate();
}

void CFileView::OnMenuCtrlKeyTab()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlTab();
}

void CFileView::OnMenuCtrlKeyA()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CMenu* pMenu = m_pChildView->m_pMainFrame->GetMenu();

	if ( m_pInfoWnd->m_bLongNameMode) {
		m_pInfoWnd->m_bLongNameMode = false;
		pMenu->CheckMenuItem(ID_CTRL_KEY_A, MF_UNCHECKED);
		m_pFmParam->m_InfoHeight = INFOWNDHEIGHT;
	} else {
		m_pInfoWnd->m_bLongNameMode = true;
		pMenu->CheckMenuItem(ID_CTRL_KEY_A, MF_CHECKED);
		m_pFmParam->m_InfoHeight = INFOWNDHEIGHT + 1;
	}
	m_pChildView->ResizeWindow();
	m_pChildView->m_psbDriveTab->Invalidate();
	m_pChildView->m_pScrollBar->Invalidate();

}

void CFileView::OnMenuCtrlKeyB()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlBCopyTextClipboard();
}

void CFileView::OnMenuCtrlKeyC()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlCCopyClipboard();
}

void CFileView::OnMenuCtrlKeyD()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlDDisplayOnOff();
}

void CFileView::OnMenuCtrlKeyI()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlIWriteIniFile();
}

void CFileView::OnMenuCtrlKeyM()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlMMirrorCopy();
}

void CFileView::OnMenuCtrlKeyN()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlNChangeNameAll();
}

void CFileView::OnMenuCtrlKeyO()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlOChangeNameOnly();
}
void CFileView::OnMenuCtrlKeyP()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlPPushCurrentPath();
}

void CFileView::OnMenuCtrlKeyR()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlRPopCurrentPath();
}

void CFileView::OnMenuCtrlKeyS()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlSPlaySound();
}

void CFileView::OnMenuCtrlKeyT()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlTChangeFileTime();
}

void CFileView::OnMenuCtrlKeyV()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlVPasteClipboard();
}


void CFileView::OnMenuCtrlKeyX()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlXCopyCutClipboard();
}


void CFileView::OnMenuKeyYen()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyMoveRoot();
}

void CFileView::OnMenuSpecialKeyBS()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyBackspace();
}

void CFileView::OnMenuSpecialKeySlash()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyGoHomeFolder();
}

void CFileView::OnMenuSpecialKeySpace()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeySpace();
}

void CFileView::OnMenuSpecialKeyHome()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyHome();
}

void CFileView::OnMenuSpecialKeyShiftHome()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftHome();
}

void CFileView::OnMenuSpecialKeyEnter()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyEnter();
}

void CFileView::OnMenuSpecialKeyShiftEnter()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyShiftEnter();
}

void CFileView::OnMenuSpecialKeyCtrlEnter()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyCtrlEnter();
}

void CFileView::OnMenuKeyEsc()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyEsc();
}



void CFileView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if (m_bRunCmd) return;

	CmdKeyApp(point, true);

	CView::OnRButtonDown(nFlags, point);
}

void CFileView::OnMenuSendTo()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CString fn, s, sext;
	fn = m_pw64fdSendTo[m_nSelectSendTo].name;

	int en = fn.ReverseFind(_T('.'));
	s = fn.Left(en);
	sext = fn.Right(fn.GetLength() - en);
	sext.MakeUpper();

	if ( s == _T("hLg") ) {
		WCHAR lpszPath[1000] = _T("");
		SHGetSpecialFolderPath(this->m_hWnd, lpszPath, CSIDL_PERSONAL, FALSE);
		CString dpath = lpszPath;
		dpath += _T("\\");
		CmdMacroCopyFile(false, 9, dpath);
	}

	if ( sext == _T(".LNK") ) {
		s = m_sSendToPath;
		s += fn;

		CString cfn, cpath;
		if ( m_pFmParam->m_TagFileNum == 0 ) {
			cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			cfn = _T("\"");
			cfn +=  cpath;
			cfn += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
			cfn += _T("\"");
		} else {
			cfn = _T("");
			for ( int i = 0; i < m_pFmParam->m_FileNum; i++ ) {
				if ( !(m_pFmParam->m_pMark[i]) ) continue;

				cfn += _T("\"");
				cfn += m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				cfn += m_pFmParam->m_pw64FindData[i].name;
				cfn += _T("\" ");
			}
		}
		ShellExecute(this->m_hWnd, _T("open"), s, cfn, cpath, SW_SHOW);
	}

}

void CFileView::OnMenuSendTo00()
{
	m_nSelectSendTo = 0;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo01()
{
	m_nSelectSendTo = 1;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo02()
{
	m_nSelectSendTo = 2;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo03()
{
	m_nSelectSendTo = 3;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo04()
{
	m_nSelectSendTo = 4;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo05()
{
	m_nSelectSendTo = 5;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo06()
{
	m_nSelectSendTo = 6;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo07()
{
	m_nSelectSendTo = 7;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo08()
{
	m_nSelectSendTo = 8;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo09()
{
	m_nSelectSendTo = 9;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo10()
{
	m_nSelectSendTo = 10;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo11()
{
	m_nSelectSendTo = 11;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo12()
{
	m_nSelectSendTo = 12;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo13()
{
	m_nSelectSendTo = 13;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo14()
{
	m_nSelectSendTo = 14;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo15()
{
	m_nSelectSendTo = 15;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo16()
{
	m_nSelectSendTo = 16;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo17()
{
	m_nSelectSendTo = 17;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo18()
{
	m_nSelectSendTo = 18;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo19()
{
	m_nSelectSendTo = 19;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo20()
{
	m_nSelectSendTo = 20;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo21()
{
	m_nSelectSendTo = 21;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo22()
{
	m_nSelectSendTo = 22;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo23()
{
	m_nSelectSendTo = 23;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo24()
{
	m_nSelectSendTo = 24;
	OnMenuSendTo();
}

void CFileView::OnMenuSendTo25()
{
	m_nSelectSendTo = 25;
	OnMenuSendTo();
}


void CFileView::SetLastYen(CString& sPath)
{
	if ( sPath.GetAt(sPath.GetLength() - 1) != CHAR_YEN ) sPath += STR_YEN;

}

CString CFileView::SelectCurDir(void)
{
	CString sRet = _T("");

	GetAllCurDir();
	if ( m_nWndCount == 1 ) {
		sRet = m_sMacroPath;
	} else {
		CSelectCurdirDialog dlg;
		dlg.m_nNum = m_nWndCount;

		int j = 0;
		for ( int i = 0; i < m_nWndCount; i++ ) {
			if ( m_sCdirannsFM[i] != m_sMacroPath ) {
				dlg.m_sCurDir[j] = m_sCdirannsFM[i];
				j++;
			}
		}
		if ( m_nWndCount == 2 ) {
			sRet = dlg.m_sCurDir[0];
		} else {
			dlg.m_sCurDir[j] = m_sMacroPath;
			int r = dlg.DoModal();
			if ( r == IDOK ) sRet = m_sCdirannsFM[dlg.m_nSelectNo];
		}
	}

	return sRet;
}



// R}h  sCom:R}h Kx Sx Cx Exx
int CFileView::GetMacroCmdNo(CString sCom)
{
	int comNo = -1;
	sCom.MakeUpper();

	if ( sCom[0] == 'K' ) {
		comNo = (int)sCom[1];
	}

	if ( sCom[0] == 'S' ) {
		comNo = (int)(sCom[1] + 0x100);
	}

	if ( sCom[0] == 'C' ) {
		comNo = (int)(sCom[1] + 0x200);
	}

	if ( sCom[0] == 'E' ) {
		if ( sCom == _T("EBS") ) {
			comNo = 0x08;
		}

		if ( sCom == _T("EET") ) {
			comNo = 0x0d;
		}

		if (sCom == _T("EWT")) {
			comNo = 0x1f;
		}

		if ( sCom == _T("ESP") ) {
			comNo = 0x20;
		}

		if ( sCom == _T("EPU") ) {
			comNo = 0x21;
		}

		if ( sCom == _T("EPD") ) {
			comNo = 0x22;
		}

		if ( sCom == _T("ECL") ) {
			comNo = 0x25;
		}

		if ( sCom == _T("ECU") ) {
			comNo = 0x26;
		}

		if ( sCom == _T("ECR") ) {
			comNo = 0x27;
		}

		if ( sCom == _T("ECD") ) {
			comNo = 0x28;
		}

		if ( sCom == _T("EYN") ) {
			comNo = 0xdc;
		}

		if ( sCom == _T("ECE") ) {
			comNo = 0x20d;
		}
	}

	return comNo;
}

int CFileView::RunCmdMacro(int cmdNo, int paramLineNo)
{
	int nextLineNo = paramLineNo;
	int n = nextLineNo + 1;
	int cn1, cn2, cn3, cn4, at, nparam[10];
	bool b1, b2, r, bparam[5];
	CString sFname, sSfname, sDfname, cpath, sDpath, s, sDrv, sUnc, sUser, sPass, sparam[5];
	int nTag = m_pFmParam->m_TagFileNum;
	r = true;
	m_bRunCmd = true;

	switch(cmdNo) {
		case 0x08:	// Backspace
			CmdKeyBackspace();
			break;

		case 0x0d:	// Enter
			CmdKeyEnter();
			break;

		case 0x1f:	// Wait
			cn1 = _wtoi(m_psMacroCmdList[n]);
			if (cn1 > 10000) cn1 = 10000;
			MySleep(cn1);
			break;

		case 0x20:	// Space
			CmdKeySpace();
			break;

		case 0x21:	// Page Up
			CmdKeyPageUp();
			break;

		case 0x22:	// Page Down
			CmdKeyPageDown();
			break;

		case 0x25:	// Cursor Left
			CmdKeyLeft();
			break;

		case 0x26:	// Cursor Up
			CmdKeyUp();
			break;

		case 0x27:	// Cursor Right
			CmdKeyRight();
			break;

		case 0x28:	// Cursor Down
			CmdKeyDown();
			break;


		case 0x40:	// @
			s.Format(_T("[ %s ]\ñ}Ns܂H"), m_psMacroCmdList[n]);
			at = MessageBox(s, _T("}Nꎞ~"), MB_YESNO);
			if ( at == IDNO ) {
				r = false;
				m_bCancelCmd = true;
			}
			nextLineNo = n;
			break;


// Key

		case 0x41:	// A
			cn1 = _wtoi(m_psMacroCmdList[n]);
			cn2 = _wtoi(m_psMacroCmdList[n+1]);
			cn3 = _wtoi(m_psMacroCmdList[n+2]);
			cn4 = _wtoi(m_psMacroCmdList[n+3]);
			b1 = (_wtoi(m_psMacroCmdList[n+4]) != 0);
			b2 = (_wtoi(m_psMacroCmdList[n+5]) != 0);
			if ( m_psMacroCmdList[n+6][0] == '/' ) {	// Jg܂̓^Ot@C
				at = 0;
				sFname = _T("");
				if ( m_pFmParam->m_FileNum == 0 ) {
					s = _T("JgtH_ɂ̓t@C܂!");
					MessageBox(s, _T("}NsG["));
					r = false;					
				}
			} else {
				sFname = m_psMacroCmdList[n+4];
				CFileStatus rStatus;

				if ( !CFile::GetStatus(sFname, rStatus) ) {	// wt@C݂Ȃ
					s.Format(_T("[ %s ] R}h\n[ %s ]\nt@C݂܂!"),m_psMacroCmdList[cmdNo] , sFname);
					MessageBox(s, _T("}NsG["));
					r = false;					
				} else {
					at = rStatus.m_attribute;
					at &= _A_SUBDIR;
				}

			}
			if ( r ) {
				if ( cn1 == 1 ) at |= _A_ARCH;
				if ( cn2 == 1 ) at |= _A_RDONLY;
				if ( cn3 == 1 ) at |= _A_HIDDEN;
				if ( cn4 == 1 ) at |= _A_SYSTEM;
				CmdMacroSetAttribute(at, b1, b2, sFname);
			}
			nextLineNo = n + 6;

			break;

		case 0x43:	// C
			cn1 = _wtoi(m_psMacroCmdList[n]);
			sDpath = m_psMacroCmdList[n+1];
			if ( sDpath.GetAt(0) == _T('*') ) {
				if ( m_pFmParam->m_sValMacroCurrentPath != _T("") ) {
					sDpath = m_pFmParam->m_sValMacroCurrentPath;
				} else r = false;
			} else {
				if ( sDpath.GetAt(0) == _T('#') ) {
					sDpath = SelectCurDir();
					if ( sDpath == _T("") ) r = false;
				} else SetLastYen(sDpath);
			}

			if ( m_psMacroCmdList[n+2][0] == '/' ) {	// Jg܂̓^Ot@C
				sFname = _T("");
				if ( m_pFmParam->m_FileNum == 0 ) {
					s = _T("JgtH_ɂ̓t@C܂!");
					MessageBox(s, _T("}NsG["));
					r = false;					
				}
			} else {
				sFname = m_psMacroCmdList[n+2];
			}

			if ( r ) {
				CmdMacroCopyFile(false, cn1, sDpath, sFname);
			}
			nextLineNo = n + 2;

			break;

		case 0x44:	// D
			cn1 = _wtoi(m_psMacroCmdList[n]);
			if ( m_psMacroCmdList[n+1][0] == '/' ) {	// Jg܂̓^Ot@C
				sFname = _T("");
				if ( m_pFmParam->m_FileNum == 0 ) {
					s = _T("JgtH_ɂ̓t@C܂!");
					MessageBox(s, _T("}NsG["));
					r = false;					
				}
			} else {
				sFname = m_psMacroCmdList[n+1];
			}

			if ( r ) {
				CmdMacroDeleteFile((cn1 != 0), sFname);
			}
			nextLineNo = n + 1;
			break;

		case 0x48:	// H
			sDpath = m_psMacroCmdList[n];
			SetLastYen(sDpath);
			CmdMacroMovePath(sDpath);
			nextLineNo = n;
			break;

		case 0x4b:	// K
			sDpath = m_psMacroCmdList[n];
			SetLastYen(sDpath);
			CmdMacroMakeDir(sDpath);
			nextLineNo = n;
			break;

		case 0x4c:	// L
			s = m_psMacroCmdList[n];
			CmdMacroSelectDrive(s);
			nextLineNo = n;
			break;

		case 0x4d:	// M
			cn1 = _wtoi(m_psMacroCmdList[n]);
			sDpath = m_psMacroCmdList[n+1];
			if ( sDpath.GetAt(0) == _T('*') ) {
				if ( m_pFmParam->m_sValMacroCurrentPath != _T("") ) {
					sDpath = m_pFmParam->m_sValMacroCurrentPath;
				} else r = false;
			} else {
				if ( sDpath.GetAt(0) == _T('#') ) {
					sDpath = SelectCurDir();
					if ( sDpath == _T("") ) r = false;
				} else SetLastYen(sDpath);
			}

			if ( m_psMacroCmdList[n+2][0] == '/' ) {	// Jg܂̓^Ot@C
				sFname = _T("");
				if ( m_pFmParam->m_FileNum == 0 ) {
					s = _T("JgtH_ɂ̓t@C܂!");
					MessageBox(s, _T("}NsG["));
					r = false;					
				}
			} else {
				sFname = m_psMacroCmdList[n+2];
			}

			if ( r ) {
				CmdMacroCopyFile(true, cn1, sDpath, sFname);
			}
			nextLineNo = n + 2;
			break;

		case 0x4e:	// N
			if ( m_psMacroCmdList[n][0] == '/' ) {	// Jg܂̓^Ot@C
				nextLineNo = n;
				CmdMacroChangeName();
			} else {
				sSfname = m_psMacroCmdList[n];
				sDfname = m_psMacroCmdList[n+1];
				nextLineNo = n + 1;
				CmdMacroChangeName(sSfname, sDfname);
			}
			break;

		case 0x50:	// P
			sFname = m_psMacroCmdList[n];
			sDpath = m_psMacroCmdList[n+1];
			cn1 = _wtoi(m_psMacroCmdList[n+2]);
			cn2 = _wtoi(m_psMacroCmdList[n+3]);

			if ( m_pFmParam->m_FileNum == 0 ) {
				s = _T("JgtH_ɂ̓t@C܂!");
				MessageBox(s, _T("}NsG["));
				r = false;					
			}

			if ( r ) {
				CmdMacroPackFile(sFname, sDpath, (cn1 != 0), (cn2 != 0));
			}
			nextLineNo = n + 3;
			break;

		case 0x52:	// R
			sSfname = m_psMacroCmdList[n];
			s = m_psMacroCmdList[n+1];
			sFname = m_psMacroCmdList[n+2];

			if ( sFname[0] == '/' ) {	// Jg܂̓^Ot@C
				if ( m_pFmParam->m_FileNum == 0 ) {
					s = _T("JgtH_ɂ̓t@C܂!");
					MessageBox(s, _T("}NsG["));
					r = false;					
				}
			}

			if ( r ) {
				CmdMacroRunProgram(sSfname, s, sFname);
			}

			nextLineNo = n + 2;
			break;

		case 0x55:	// U
			if ( m_psMacroCmdList[n][0] == '/' ) {	// Jg܂̓^Ot@C
				sFname = _T("");
				if ( m_pFmParam->m_FileNum == 0 ) {
					s = _T("JgtH_ɂ̓t@C܂!");
					MessageBox(s, _T("}NsG["));
					r = false;					
				}
			} else {
				sFname = m_psMacroCmdList[n];
			}
			sDpath = m_psMacroCmdList[n+1];
			SetLastYen(sDpath);
			cn1 = _wtoi(m_psMacroCmdList[n+2]);

			if ( r ) {
				CmdMacroUnPackFile(sFname, sDpath, (cn1 != 0));
			}
			nextLineNo = n + 2;
			break;

		case 0x57:	// W
			CmdKeyHome();
			break;

		case 0xdc: // "\"
			CmdKeyMoveRoot();
			break;


// Shift + Key

		case 0x142:	// B
			CmdKeyShiftBCopyFileNameTextClipboard();
			break;

		case 0x143:	// C
			s = m_psMacroCmdList[n];
			CmdMacroCloseUncTab(s);
			nextLineNo = n;
			break;

		case 0x144:	// D
			cn1 = _wtoi(m_psMacroCmdList[n]);
			cn2 = _wtoi(m_psMacroCmdList[n+1]);
			CmdMacroDispSpecialFile((cn1 != 0), (cn2 != 0));
			nextLineNo = n+1;
			break;

		case 0x14e:	// N
			cn1 = _wtoi(m_psMacroCmdList[n]);
			sDrv = m_psMacroCmdList[n+1];

			if ( cn1 != 0 ) {
				sUnc = m_psMacroCmdList[n+2];
				sUser = m_psMacroCmdList[n+3];
				sPass = m_psMacroCmdList[n+4];
				cn2 = _wtoi(m_psMacroCmdList[n+5]);
				CmdMacroConnectNetwork(sDrv, sUnc, sUser, sPass, (cn2 != 0));
				nextLineNo = n + 5;
			} else {
				CmdMacroDisConnectNetwork(sDrv);
			}
			nextLineNo = n + 1;
			break;

		case 0x156:	// V
			s = m_psMacroCmdList[n];
			CmdMacroChangeVolumeLabel(s);
			nextLineNo = n;
			break;

		case 0x157:	// W
			CmdKeyShiftHome();
			break;

		case 0x15a:	// Z
			OnMenuShiftKeyZ();
			break;


			
// Ctrl + Key

		case 0x20d:	// Enter
			if ( m_psMacroCmdList[n][0] == '/' ) {	// Jg܂̓^Ot@C
				CmdKeyCtrlEnter();
			} else {
				s = m_psMacroCmdList[n];
				ShellExecute(NULL, _T("open"), s, NULL, NULL, SW_SHOW);
			}
			break;

		case 0x242:	// B
			CmdKeyCtrlBCopyTextClipboard();
			break;

		case 0x243:	// C
			CmdKeyCtrlCCopyClipboard();
			break;

		case 0x24d:	// M
			cn4 = 2;
			m_sMirrorCopySDir = m_psMacroCmdList[n];
			m_sMirrorCopyDDir = m_psMacroCmdList[n+1];
			cn1 = _wtoi(m_psMacroCmdList[n+2]);
			cn2 = 0;
			cn3 = 0;
			m_bMCopyDiffTime = false;
			m_bMCopyDiffSize = false;
			if ( !(cn1 != 0) ) {	// mFȂ
				cn2 = _wtoi(m_psMacroCmdList[n+3]);
				cn3 = _wtoi(m_psMacroCmdList[n+4]);
				cn4 = 4;
				if (m_psMacroCmdList[n + 5].GetAt(0) == _T('0') || m_psMacroCmdList[n + 5].GetAt(0) == _T('1')) {
					m_bMCopyDiffTime = (_wtoi(m_psMacroCmdList[n + 5]) != 0);
					m_bMCopyDiffSize = (_wtoi(m_psMacroCmdList[n + 6]) != 0);
					cn4 = 6;

				}
			}
			else {
				if (m_psMacroCmdList[n + 3].GetAt(0) == _T('0') || m_psMacroCmdList[n + 3].GetAt(0) == _T('1')) {
					m_bMCopyDiffTime = (_wtoi(m_psMacroCmdList[n + 3]) != 0);
					m_bMCopyDiffSize = (_wtoi(m_psMacroCmdList[n + 4]) != 0);
					cn4 = 4;

				}
			}
			CmdMacroMirrorCopy((cn1 != 0), (cn2 != 0), (cn3 != 0));
			nextLineNo = n + cn4;
			break;

		case 0x24e:	// N
			bparam[0] = ((_wtoi(m_psMacroCmdList[n])) != 0);
			if ( m_psMacroCmdList[n+1][0] == '\\' ) sparam[0] = m_psMacroCmdList[n+1].Mid(1);
			else sparam[0] = m_psMacroCmdList[n+1];
			nparam[0] = _wtoi(m_psMacroCmdList[n+2]);
			nparam[1] = _wtoi(m_psMacroCmdList[n+3]);
			nparam[2] = _wtoi(m_psMacroCmdList[n+4]);
			bparam[1] = ((_wtoi(m_psMacroCmdList[n+5])) != 0);
			if ( m_psMacroCmdList[n+6][0] == '\\' ) sparam[1] = m_psMacroCmdList[n+6].Mid(1);
			else sparam[1] = m_psMacroCmdList[n+6];
			nparam[3] = _wtoi(m_psMacroCmdList[n+7]);
			nparam[4] = _wtoi(m_psMacroCmdList[n+8]);
			CmdMacroChangeNameAll(&bparam[0], &sparam[0], &nparam[0]);
			nextLineNo = n + 8;
			break;

		case 0x250:	// P
			m_pFmParam->m_sValMacroCurrentPath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			break;

		case 0x252:	// R
			m_pFmParam->m_sSelectedJumpPath = m_pFmParam->m_sValMacroCurrentPath;
			OnJumpMessage();
			break;

		case 0x254:	// T
			if ( m_psMacroCmdList[n][0] == '/' ) {	// Jg܂̓^Ot@C
				sFname = _T("");
			} else {
				sSfname = m_psMacroCmdList[n];
			}
			bparam[0] = ((_wtoi(m_psMacroCmdList[n+1])) != 0);
			sparam[0] = m_psMacroCmdList[n+2];
			cn1 = _wtoi(m_psMacroCmdList[n+3]);
			sparam[1] = m_psMacroCmdList[n+4];
			bparam[1] = ((_wtoi(m_psMacroCmdList[n+5])) != 0);
			bparam[2] = ((_wtoi(m_psMacroCmdList[n+6])) != 0);
			CmdMacroChangeFileTime(sSfname, &bparam[0], &sparam[0], cn1);
			nextLineNo = n + 6;
			break;

		case 0x256:	// V
			CmdKeyCtrlVPasteClipboard();
			break;
	}
	m_bRunCmd = false;

	return nextLineNo;
}

void CFileView::MySleep(int time)
{
	int n = time / 10;

	for (int i = 0; i < n; i++) {
		MSG aMsg;
		while (::PeekMessage(&aMsg, NULL, 0, 0, PM_REMOVE))
		{
			::TranslateMessage(&aMsg);
			::DispatchMessage(&aMsg);
		}
		Sleep(10);
	}
}

void CFileView::RunMacro(CString fname)
{
	CString s, sbuf;


	setlocale( LC_ALL, ".ACP" );
	CStdioFile cfile;

	int max = MAX_MACRO_LINE_NUM;

	m_nMacroLineNum = 0;
	if ( cfile.Open( fname, CFile::modeRead ) ) {
		for ( int i = 0; i < max; i++ ) {
			m_psMacroCmdList[i] = _T("");
			BOOL r = cfile.ReadString(sbuf);
			if ( r ) {
				m_psMacroCmdList[i] = sbuf;
				m_nMacroLineNum++;
			}
		}
	}

	cfile.Close();

	int fase = 0;
	CString sL;
	int cmdNo;
	m_bCancelMacro = false;
	m_bCancelCmd = false;

	if ( m_nMacroLineNum == 0 ) return;

	m_pFmParam->m_bRedrawFocus = false;

	max = m_nMacroLineNum + 1;
	for ( int i = 0; i < max; i++ ) {
		sL = m_psMacroCmdList[i];

		if ( sL[0] == '-' ) {
			s = sL.Mid(1, 3);
			cmdNo = GetMacroCmdNo(s);
			if ( cmdNo < 0 ) {
				s.Format(_T("Line %d:R}hG[!"), i + 1);
				MessageBox(s);
				break;
			}
			m_bInitFileList = false;
			i = RunCmdMacro(cmdNo, i);


		}
		MSG aMsg;
		while (::PeekMessage(&aMsg, NULL, 0, 0, PM_REMOVE))
		{
			::TranslateMessage(&aMsg);
			::DispatchMessage(&aMsg);
		}

		if ( m_bCancelCmd ) m_bCancelMacro = true;
		if (m_bCancelMacro) {
			s = _T("R}h}N𒆒f܂B");
			MessageBox(s);
			break;
		}

	}
	m_pFmParam->m_bRedrawFocus = m_pFmParam->m_bInitRedrawFocus;

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}

	
void CFileView::MacroCommand(void)
{
	m_psMacroFileList = new CString[MAX_MACRO_FILE_NUM];

	CString path, s, fName;
	s = _T("*.FMM");

	path = m_pFmParam->GetExePath(_T("MACRO\\"));
	fName = path;
	fName += s;

	struct _wfinddata64_t c_file;
	intptr_t hFile;

	int n = 0;
	int at;
	CString fn;

	if( (hFile = _wfindfirst64( fName, &c_file )) != -1L ) {

		at = c_file.attrib;
		fn = c_file.name;

		int max = MAX_MACRO_FILE_NUM;
		while( true ) {
			at = c_file.attrib;
			fn = c_file.name;

			if ( (at & _A_SUBDIR) == 0 ) {	// fBNgłȂȂ
				m_psMacroFileList[n] = fn;
				n++;
			}
			if ( n == max ) break;
			if (_wfindnext64(hFile, &c_file) != 0) {
				break;
			}
		}
		_findclose( hFile );

		CRunMacroDialog dlg;
		dlg.m_pFmParam = m_pFmParam;
		dlg.m_psFileList = m_psMacroFileList;
		dlg.m_nFileNum = n;
		dlg.m_FontXw = m_FontWidth;

		int r = dlg.DoModal();
		if ( r == IDOK ) {

			m_sMacroPath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

			fn = dlg.m_sMacroFileName;
			fName = path;
			fName += fn;

			m_psMacroCmdList = new CString[MAX_MACRO_LINE_NUM];

			RunMacro(fName);

			delete []m_psMacroCmdList;
		}



	} else {
		CString s;
		s = _T("}Nt@C܂");
		MessageBox(s);
	}



	delete []m_psMacroFileList;
}

// CmdMacro No 0x41
// t@C̕ύX
void CFileView::CmdMacroSetAttribute(int attri, bool bChangeInSubdir, bool bNoChangeDir, CString filename)
{

	CString fname, fn;
	CFileStatus rStatus;
	int at = attri;

	rStatus.m_attribute = at;
	rStatus.m_mtime = 0;

	if ( filename != _T("") ) {
		fname = filename;
		if ((at & _A_SUBDIR) != 0) {
			if ( bChangeInSubdir ) {
				SetAttributeAllFile(fname, at, bNoChangeDir);
			}
			if ( !bNoChangeDir ) {
//				CFile::SetStatus(fname, rStatus);
				bool bErr = false;
				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}
			}
		} else {
			bool bErr = false;
			try
			{
				CFile::SetStatus(fname, rStatus);
			}
			catch (CFileException* pEx)
			{
				CString s;
				s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
				MessageBox(s, _T("ANZXG["));
				pEx->Delete();
				bErr = true;
			}
		}
		return;
	}



	if ( m_pFmParam->m_TagFileNum == 0 ) {
		CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( fn == _T("") ) return;
		if ( fn == _T("..") ) return;

		fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		int cat = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
		if ((cat & _A_SUBDIR) != 0) {
			if ( bChangeInSubdir ) {
				SetAttributeAllFile(fname, at, bNoChangeDir);
			}
			if ( !bNoChangeDir ) {
				rStatus.m_attribute = at;
				bool bErr = false;
				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}
				m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib = rStatus.m_attribute;
			}
		} else {
			bool bErr = false;
			try
			{
				CFile::SetStatus(fname, rStatus);
			}
			catch (CFileException* pEx)
			{
				CString s;
				s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
				MessageBox(s, _T("ANZXG["));
				pEx->Delete();
				bErr = true;
			}
			m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib = rStatus.m_attribute;
		}
	} else {
		for ( int i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( !(m_pFmParam->m_pMark[i]) ) continue;
			fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			fname += m_pFmParam->m_pw64FindData[i].name;
			int at2 = m_pFmParam->m_pw64FindData[i].attrib;

			if ((at2 & _A_SUBDIR) != 0) {
				if ( bChangeInSubdir ) {
					SetAttributeAllFile(fname, at, bNoChangeDir);
				}
				if ( !bNoChangeDir ) {
					rStatus.m_attribute = at;
					bool bErr = false;
					try
					{
						CFile::SetStatus(fname, rStatus);
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
						MessageBox(s, _T("ANZXG["));
						pEx->Delete();
						bErr = true;
					}
					m_pFmParam->m_pw64FindData[i].attrib = rStatus.m_attribute;
				}
			} else {
				rStatus.m_attribute = at;
				bool bErr = false;
				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}
				m_pFmParam->m_pw64FindData[i].attrib = rStatus.m_attribute;
			}

		}
	}
	if ( m_pFmParam->m_SortMode != SORT_NON )  m_pFmParam->SortFileList(m_pFmParam->m_SortMode);
	Invalidate();
}

// CmdMacro No 0x43 or 0x4d
// t@C̕ʁEړ
void CFileView::CmdMacroCopyFile(bool move, int copymode, CString sDpath, CString filename)
{
	CString sfile, dfile, dpath, tmp, tmp2, tmp3;
	int nTag;

	m_pFmParam->m_bCancelCopy = false;

//	m_pFmParam->m_CopySame = FALSE;
	m_pFmParam->m_CopySame = TRUE;
	m_pFmParam->m_CopyMove = move;
//	m_pFmParam->m_CopyMode = COPY_NON;
	m_pFmParam->m_CopyMode = copymode;

	m_pFmParam->m_CopyDestPath = sDpath;
	dpath = sDpath;
// m_CopySourcePath : ʌpX(\t)
// m_CopyDestPath : ʐpX(\t)
// m_CopyFileName : t@C

	if ( copymode == 9 ) m_pFmParam->m_CopySame = FALSE;

	if ( filename != _T("") ) {


		CFileStatus fStatus;
		CFile::GetStatus(filename, fStatus);
		int at = fStatus.m_attribute;
		int n = filename.ReverseFind(_T('\\'));

		if ( (at & _A_SUBDIR) == 0 ) {	// DIRłȂ

			n++;
			m_pFmParam->m_CopySourcePath = filename.Left(n);
			m_pFmParam->m_CopyFileName = filename.Mid(n);

		} else {
			if ( n == (filename.GetLength() - 1) ) {
				CString fn;
				fn = filename.Left(n);
				n = fn.ReverseFind(_T('\\'));
				n++;
				m_pFmParam->m_CopySourcePath = fn.Left(n);
				m_pFmParam->m_CopyFileName = fn.Mid(n);
			}

		}



		m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
		m_pFmParam->m_pCopyInfoDlg = new CCopyInfoDialog;
		CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pFmParam->m_pCopyInfoDlg;
		m_pFmParam->m_pCopyInfoDlg->Create(IDD_COPY_INFO_DIALOG, this);
		cidlg->ShowWindow(SW_SHOW);
		tmp = _T("%d");
		tmp2.Format(tmp, 1);
		m_pFmParam->InsertComma(tmp2);
		tmp = _T("%16s / %16s");
		cidlg->m_FileNum.Format(tmp, tmp2, tmp2);
		int iret = m_pFmParam->CopyDirectory();
		if ( iret == 0 ) m_pFmParam->CopyOneFile();
		delete []m_pFmParam->m_pCopyBuff;
		m_pFmParam->m_pCopyInfoDlg->DestroyWindow();
		delete m_pFmParam->m_pCopyInfoDlg;
		return;
	}

	CFileStatus rStatus;
	if ( (dpath.GetLength() > 3) && !(CFile::GetStatus(dpath, rStatus)) ) {	// ʐtH_݂Ȃ
		tmp2 = _T("[ %s ]\r\nʐtH_݂܂B쐬܂H");
		tmp.Format(tmp2, dpath);
		tmp2 = _T("ʐtH_̍쐬");
		int id = MessageBox(tmp, tmp2,  MB_ICONWARNING | MB_YESNO);
		if ( id != IDYES ) return;
		if ( !m_pFmParam->MakeDirectory(dpath) ) {
			tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
			tmp.Format(tmp2, dpath);
			MessageBox(tmp, NULL,  MB_ICONERROR | MB_OK);
			m_bCancelMacro = true;
			return;
		}

	}

	nTag = m_pFmParam->m_TagFileNum;
	m_pFmParam->m_CopySourcePath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if ( nTag == 0 ) {	// It@CȂ
		m_pFmParam->m_CopyFileName = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;

		if ( m_pFmParam->m_CopyFileName == _T("..") ) return;

		m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
		m_pFmParam->m_pCopyInfoDlg = new CCopyInfoDialog;
		CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pFmParam->m_pCopyInfoDlg;
		m_pFmParam->m_pCopyInfoDlg->Create(IDD_COPY_INFO_DIALOG, this);
		cidlg->ShowWindow(SW_SHOW);
		tmp = _T("%d");
		tmp2.Format(tmp, 1);
		m_pFmParam->InsertComma(tmp2);
		tmp = _T("%16s / %16s");
		cidlg->m_FileNum.Format(tmp, tmp2, tmp2);
		int iret = m_pFmParam->CopyDirectory();
		if ( iret == 0 ) m_pFmParam->CopyOneFile();
		delete []m_pFmParam->m_pCopyBuff;
		m_pFmParam->m_pCopyInfoDlg->DestroyWindow();
		delete m_pFmParam->m_pCopyInfoDlg;

	} else {
		int nt = m_pFmParam->m_FileNum;
		int num = 1;
		m_pFmParam->m_pCopyBuff = new char[m_pFmParam->m_CopyBuffSize];
		m_pFmParam->m_pCopyInfoDlg = new CCopyInfoDialog;
		CCopyInfoDialog* cidlg = (CCopyInfoDialog*)m_pFmParam->m_pCopyInfoDlg;
		m_pFmParam->m_pCopyInfoDlg->Create(IDD_COPY_INFO_DIALOG, this);
		cidlg->ShowWindow(SW_SHOW);

		for ( int n = 0; n < nt; n++ ) {
			if ( !m_pFmParam->m_pMark[n] ) continue;

			m_pFmParam->m_CopyFileName = m_pFmParam->m_pw64FindData[n].name;

			tmp = _T("%d");
			tmp2.Format(tmp, num);
			m_pFmParam->InsertComma(tmp2);
			tmp3.Format(tmp, nTag);
			m_pFmParam->InsertComma(tmp3);
			tmp = _T("%16s / %16s");
			cidlg->m_FileNum.Format(tmp, tmp2, tmp3);
			int iret = m_pFmParam->CopyDirectory();
			if ( iret == 0 ) m_pFmParam->CopyOneFile();
			if ( m_pFmParam->m_CopyMode == -1 ) {
				m_bCancelMacro = true;
				break;
			}
			num++;
		}

		delete []m_pFmParam->m_pCopyBuff;
		m_pFmParam->m_pCopyInfoDlg->DestroyWindow();
		delete m_pFmParam->m_pCopyInfoDlg;
	}

}

// CmdMacro No 0x44
// t@C̍폜
void CFileView::CmdMacroDeleteFile(bool recycle, CString filename)
{
	CString fname, fn, path;
	CFileStatus rStatus;
	int at;

	m_pDelInfoDlg = new CDeleteInfoDialog;
	m_pDelInfoDlg->Create(IDD_DELETE_INFO_DIALOG, this);
	m_pDelInfoDlg->ShowWindow(SW_SHOW);
	CDeleteInfoDialog* didlg = (CDeleteInfoDialog*)m_pDelInfoDlg;

	if ( filename != _T("") ) {

		int len = filename.GetLength();
		if ( filename.GetAt(len - 1) == _T('\\') ) filename = filename.Left(len);

		m_bStopDelete = false;
		CFile::GetStatus(filename, rStatus);
		at = rStatus.m_attribute;
		if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
			DeleteDir(filename, recycle);
		} else {
			fname = filename;
			if ( recycle ) {
				m_pFmParam->MoveToRecycler(fname);
			} else {
				CFile::GetStatus(fname, rStatus);
				rStatus.m_attribute = 0;
				rStatus.m_mtime = 0;

				bool bErr = false;
				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}
				CFile file;
				try
				{
					file.Remove(fname);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CI[vĂ܂!\n폜ł܂łB"), fname);
					MessageBox(s, _T("Lᔽ"));
					pEx->Delete();
					m_bCancelMacro = true;
				}
			}
		}

		m_pDelInfoDlg->DestroyWindow();
		delete m_pDelInfoDlg;
		return;
	}

	m_bStopDelete = false;

	if ( m_pFmParam->m_TagFileNum == 0 ) {
		CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( fn == _T("") ) return;
		if ( fn == _T("..") ) return;

		fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		CFile::GetStatus(fname, rStatus);
		at = rStatus.m_attribute;
		if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
			DeleteDir(fname, recycle);
		} else {
			didlg->m_FileName = fn;
			didlg->m_SourcePath = path;
			didlg->m_FileNum = _T("1/1");
			didlg->UpdateData(FALSE);
			if ( recycle ) {
				m_pFmParam->MoveToRecycler(fname);
			} else {
				CFile::GetStatus(fname, rStatus);
				rStatus.m_attribute = 0;
				rStatus.m_mtime = 0;

				bool bErr = false;
				try
				{
					CFile::SetStatus(fname, rStatus);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
					MessageBox(s, _T("ANZXG["));
					pEx->Delete();
					bErr = true;
				}

				CFile file;
				try
				{
					file.Remove(fname);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CI[vĂ܂!\n폜ł܂łB"), fname);
					MessageBox(s, _T("Lᔽ"));
					pEx->Delete();
					m_bCancelMacro = true;
				}
			}
		}
	} else {
		CString tmp, s;
		int fnum = m_pFmParam->m_FileNum;
		for ( int i = 0; i < fnum; i++ ) {
			MSG aMsg;
			while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
			{
				::TranslateMessage( &aMsg );
				::DispatchMessage( &aMsg );
			}

			if ( didlg->m_Cancel ) {
				tmp = _T("t@C̍폜𒆒f܂H");
				s = _T("f");
				int id = MessageBox(tmp, s, MB_YESNO);
				if ( id == IDYES ) {
					m_bStopDelete = true;
					m_bCancelMacro = true;
					break;
				}
				didlg->m_Cancel = false;
			}

			if ( !(m_pFmParam->m_pMark[i]) ) continue;
			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			fn = m_pFmParam->m_pw64FindData[i].name;
			fname = path + fn;
			at = m_pFmParam->m_pw64FindData[i].attrib;

			didlg->m_FileName = fn;
			didlg->m_SourcePath = path;
			CString fntmp;
			fntmp.Format(_T("%8d / %8d"), i + 1, fnum);
			didlg->m_FileNum = fntmp;
			didlg->UpdateData(FALSE);

			if ((at & _A_SUBDIR) != 0) {	// fBNgȂ
				DeleteDir(fname, recycle);
			} else {
				if ( recycle ) {
					m_pFmParam->MoveToRecycler(fname);
					MSG aMsg;
					while ( ::PeekMessage( &aMsg, NULL, 0, 0, PM_REMOVE ) )
					{
						::TranslateMessage( &aMsg );
						::DispatchMessage( &aMsg );
					}
				} else {
					CFile::GetStatus(fname, rStatus);
					rStatus.m_attribute = 0;
					rStatus.m_mtime = 0;

					bool bErr = false;
					try
					{
						CFile::SetStatus(fname, rStatus);
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CɃANZXł܂!"), fname);
						MessageBox(s, _T("ANZXG["));
						pEx->Delete();
						bErr = true;
					}
					CFile file;
					try
					{
						file.Remove(fname);
					}
					catch (CFileException* pEx)
					{
						CString s;
						s.Format(_T("[ %s ]\nt@CI[vĂ܂!\n폜ł܂łB"), fname);
						MessageBox(s, _T("Lᔽ"));
						pEx->Delete();
						m_bStopDelete = true;
						m_bCancelMacro = true;
						break;
					}
				}
			}

		}
	}
	m_pDelInfoDlg->DestroyWindow();
	delete m_pDelInfoDlg;

	CString s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
	int max = m_pFmParam->m_FileNum - 1;
	if ( m_CurrentFileNo > max ) m_CurrentFileNo = max;
	m_pFmParam->ClearMark();
	Invalidate();

}

// CmdMacro No 0x48
// JgtH_̕ύX
void CFileView::CmdMacroMovePath(CString sdPath)
{
	CFileStatus rStatus;
	
	if ( !(CFile::GetStatus(sdPath, rStatus)) || ((rStatus.m_attribute & _A_SUBDIR) == 0) ) {	// tH_݂Ȃ܂̓tH_łȂ
		CString s;
		s = _T("w肳ꂽpX͖ł");
		AfxMessageBox(s);
		m_bCancelMacro = true;
		return;
	} else {
//		m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);
		int drive;
		CString sd;
		sd = sdPath.Left(2);
		sd.MakeUpper();

		if ( sd.GetAt(0) <= _T('Z') ) {
			drive = sd.GetAt(0) - 0x41;
			m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = sdPath;
		} else {
			drive = -1;
			for ( int i = 26; i < MAXDRIVE; i++ ) {
				BOOL b;
				b = m_pFmParam->m_pDriveParam->m_pExist[i];
				if ( b == FALSE ) {
					drive = i;
					break;
				}
			}

			if ( drive == -1 ) drive = MAXDRIVE - 1;
			m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = sdPath;
			m_pFmParam->m_pDriveParam->m_pUncRootPath[drive] = sdPath;
			m_pFmParam->m_pDriveParam->m_pExist[drive] = TRUE;
			m_pFmParam->m_pDriveParam->m_pType[drive] = DRIVE_REMOTE;
			m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
		}
		ChangeDirectory(drive);
		m_pFmParam->ClearMark();

		m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	}
	
}

// CmdMacro No 0x4b
// fBNg̍쐬
void CFileView::CmdMacroMakeDir(CString sdPath)
{
	bool r = m_pFmParam->MakeDirectory(sdPath);
	if ( r ) {
	} else {
		CString s;
		s.Format(_T("[ %s ]\ntH_̍쐬Ɏs܂!"), sdPath);
		AfxMessageBox(s);
		m_bCancelMacro = true;
	}
}

// CmdMacro No 0x4c
// hCȗI
void CFileView::CmdMacroSelectDrive(CString sDrive)
{
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);
	sDrive.MakeUpper();
	int dn = sDrive.GetAt(0) - 0x41;
	ChangeDirectory(dn);
	m_pFmParam->ClearMark();

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}

// Cmdmacro No 0x4e
void CFileView::CmdMacroChangeName(CString sSfilename, CString sDfilename)
{
	CString cpath, sfname, dfname, fname;

	if ( sSfilename != _T("") ) {

		try
		{
			CFile::Rename(sSfilename, sDfilename);
		}
		catch (CFileException* pEx)
		{
			CString s;
			s.Format(_T("[ %s ]\nt@CύXł܂ł!"), sSfilename);
			MessageBox(s, _T("G["));
			pEx->Delete();
		}
		return;
	}

	int mn;
	mn = m_pFmParam->m_TagFileNum;

	if ( mn == 0 ) {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;

		fname = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		CChangeNameDialog dlg;
		dlg.m_FileName = fname;
		dlg.m_Message = _T("");
		int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
		if ((at & _A_SUBDIR) != 0) dlg.m_bDir = true;
		dlg.m_pFmParam = m_pFmParam;


		int r = dlg.DoModal();

		if ( r == IDOK ) {
			cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			sfname = cpath + fname;
			dfname = cpath + dlg.m_FileName;

			try
			{
				CFile::Rename(sfname, dfname);
			}
			catch (CFileException* pEx)
			{
				CString s;
				s.Format(_T("[ %s ]\nt@CύXł܂ł!"), sfname);
				MessageBox(s, _T("G["));
				pEx->Delete();
			}
		}
//		InitFileView();
	} else {
		CChangeNameDialog dlg;
		dlg.m_EnableSkipButton = true;
		dlg.m_pFmParam = m_pFmParam;


		for ( int i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( !(m_pFmParam->m_pMark[i]) ) continue;
			fname = m_pFmParam->m_pw64FindData[i].name;

			dlg.m_FileName = fname;
			dlg.m_Message = _T("");
			int at = m_pFmParam->m_pw64FindData[i].attrib;
			if ((at & _A_SUBDIR) != 0) dlg.m_bDir = true;

			int r = dlg.DoModal();

			if ( r == IDOK ) {
				cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				sfname = cpath + fname;
				dfname = cpath + dlg.m_FileName;

				try
				{
					CFile::Rename(sfname, dfname);
					fname = dlg.m_FileName;
					wcscpy_s(m_pFmParam->m_pw64FindData[i].name, fname.GetLength() + 1, fname);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CύXł܂ł!"), sfname);
					MessageBox(s, _T("G["));
					pEx->Delete();
				}
			} else {
				if ( r == IDCANCEL ) break;
			}
		}

		if ( m_pFmParam->m_SortMode != SORT_NON )  m_pFmParam->SortFileList(m_pFmParam->m_SortMode);
		Invalidate();
	}

}

// CmdMacro No 0x50
// t@C̈k
void CFileView::CmdMacroPackFile(CString sFname, CString sDpath, bool bWpath, bool bWpass)
{

	CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	CString fname = fn;
	CString tmp;

	SetLastYen(sDpath);

	CString dpath = sDpath;

	CFileStatus rStatus;
	if ( !(CFile::GetStatus(dpath, rStatus)) ) {
		CString tmp2 = _T("[ %s ]\r\nɍ쐬tH_݂܂B쐬܂H");
		tmp.Format(tmp2, dpath);
		tmp2 = _T("ɍ쐬tH_̍쐬");
		int id = MessageBox(tmp, tmp2,  MB_ICONWARNING | MB_YESNO);
		if ( id != IDYES ) {
			m_bCancelMacro = true;
			return;
		}

		if ( !m_pFmParam->MakeDirectory(dpath) ) {
			tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
			tmp.Format(tmp2, dpath);
			MessageBox(tmp, NULL,  MB_ICONERROR | MB_OK);
			m_bCancelMacro = true;
			return;
		}

	}


	CString fnpack = dpath;
	fnpack += sFname;

	CString sfname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	sfname += fn;

	if ( m_pFmParam->m_TagFileNum != 0 ) {
			CString sResf;
			tmp = RESPONCE_FILE_NAME;
			sResf = m_pFmParam->GetExePath(tmp);
			setlocale( LC_ALL, ".ACP" );
			CStdioFile cfile;
			if ( !cfile.Open( sResf, CFile::modeWrite | CFile::modeCreate ) ) {
				tmp.Format(_T("[ %s ]\nX|Xt@C̍쐬Ɏs܂!"));
				MessageBox(tmp, _T("I[vG["));
				m_bCancelMacro = true;
				return;
			}


			CString sComm, path;
			int i;

			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			bool wp = bWpath;

			for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
				if ( m_pFmParam->m_pMark[i] ) {
					sfname = m_pFmParam->m_pw64FindData[i].name;
					int at = m_pFmParam->m_pw64FindData[i].attrib;
					if ( (at & _A_SUBDIR) != 0 ) {	// DIRȂ
//						sfname += STR_YEN;
//						sfname += _T("*.*");
					}

					sComm.Format(_T("\"%s%s\""), path, sfname);
					sComm += _T("\n");

					cfile.WriteString(sComm);
//					PackOneFile( fnpack, sfname, dlg.m_bWithPath );
				}
			}
			cfile.Close();
			PackResponceFile( fnpack, sResf, wp, bWpass );
	} else {
		CString s;
		s = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		if ( s == _T("..")) return;

		PackOneFile( fnpack, sfname, bWpath, bWpass );
	}
}


// CmdMacro No 0x52
// vO̎s
void CFileView::CmdMacroRunProgram(CString sPfname, CString sParam, CString sFname)
{
	CString path, fname;
	path = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	if (sPfname[0] == '/') {
		int n = sPfname.ReverseFind(_T('\\'));
		path = sPfname.Mid(1, n);
		sPfname = sPfname.Right(sPfname.GetLength() - 1);
	}


	CString tmp, ptmp;
	tmp = _T("open");
	ptmp = _T("");
	bool dq = false;


	if( sFname == _T("") ) {
		ShellExecute(this->m_hWnd, tmp, sPfname, sParam, path, SW_SHOW);
		return;
	}

	if ( sFname[1] == 'Q' ) dq = true;

	if ( m_pFmParam->m_TagFileNum == 0 ) {
		CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
		fname = "";
			if (dq) fname = _T("\"");
			fname += m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			if (fn != _T("..")) {
				fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
			}
			if (dq) fname += _T("\"");
		ptmp = sParam;
		ptmp += _T(" ");
		ptmp += fname;
		ShellExecute(this->m_hWnd, tmp, sPfname, ptmp, path, SW_SHOW);

	} else {

		ptmp = sParam;

		int fnum = m_pFmParam->m_FileNum;

		for ( int i = 0; i < fnum; i++ ) {

			if ( !(m_pFmParam->m_pMark[i]) ) continue;
			fname = "";
			if (dq) fname = _T("\"");
			fname += m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			fname += m_pFmParam->m_pw64FindData[i].name;
			if (dq) fname += _T("\"");

			ptmp += _T(" ");
			ptmp += fname;
		}
		ShellExecute(this->m_hWnd, tmp, sPfname, ptmp, path, SW_SHOW);
	}


}

// CmdMacro No 0x55
// kt@C̉
void CFileView::CmdMacroUnPackFile(CString sFname, CString sDpath, bool bWpath)
{

	CString fn = m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	CString fname = fn;
	CString tmp;

	CString dpath = sDpath;

	CFileStatus rStatus;
	if ( !(CFile::GetStatus(dpath, rStatus)) ) {
		CString tmp2 = _T("[ %s ]\r\n𓀐tH_݂܂B쐬܂H");
		tmp.Format(tmp2, dpath);
		tmp2 = _T("𓀐tH_̍쐬");
		int id = MessageBox(tmp, tmp2,  MB_ICONWARNING | MB_YESNO);
		if ( id != IDYES ) {
			m_bCancelMacro = true;
			return;
		}

		if ( !m_pFmParam->MakeDirectory(dpath) ) {
			tmp2 = _T("[ %s ]\r\ntH_̍쐬Ɏs܂I");
			tmp.Format(tmp2, dpath);
			MessageBox(tmp, NULL,  MB_ICONERROR | MB_OK);
			m_bCancelMacro = true;
			return;
		}

	}

	bool b = bWpath;
	bool r = true;

	if ( sFname != _T("") ) {
		int ny = sFname.ReverseFind('\\') + 1;
		fname = sFname.Mid(ny);
		tmp = sFname.Left(ny);

		r = UnPackOneFile( fname, dpath, b, tmp );
		if ( !r ) {
			CString smes;
			smes.Format(_T("[ %s ]\nɃt@Cł͂܂!"), fn);
			MessageBox(smes);
			m_bCancelMacro = true;
		}
		return;
	}

	if ( m_pFmParam->m_TagFileNum != 0 ) {
	int i;
		for ( i = 0; i < m_pFmParam->m_FileNum; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) {
				fn = m_pFmParam->m_pw64FindData[i].name;
				r = UnPackOneFile( fn, dpath, b );
				if ( !r ) {
					break;
				}
			}
		}
	} else r = UnPackOneFile( fn, dpath, b );

	if ( !r ) {
		CString smes;
		smes.Format(_T("[ %s ]\nɃt@Cł͂܂!"), fn);
		MessageBox(smes);
		m_bCancelMacro = true;
	}

}

// Cmd No 0x143
// UNC^ũN[Y
void CFileView::CmdMacroCloseUncTab(CString sUncDname)
{
	m_pFmParam->m_bRedrawFocus = false;

	int max = m_pDriveTabWnd->m_MaxTab;
	bool b = false;
	int nDrvNo = 0;

	for ( int i = 0; i < max; i++ ) {
		CString sdrv;
		sdrv = m_pDriveTabWnd->m_pDriveList[i];
		if ( sdrv.Find(_T("\\\\")) == 0 ) {
			sdrv.MakeUpper();
			sUncDname.MakeUpper();

			if ( sdrv == sUncDname ) {
				b = true;
				break;
			}
			nDrvNo++;
		}
	}

//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	int drvno = nDrvNo + 26;

	max = MAXDRIVE - 1;
	int i;
	for ( i = drvno; i < max; i++ ) {
		m_pFmParam->m_pDriveParam->m_pExist[i] = m_pFmParam->m_pDriveParam->m_pExist[i + 1];
		m_pFmParam->m_pDriveParam->m_pType[i] = m_pFmParam->m_pDriveParam->m_pType[i + 1];
		m_pFmParam->m_pDriveParam->m_pCurrentPath[i] = m_pFmParam->m_pDriveParam->m_pCurrentPath[i + 1];
	}
	m_pFmParam->m_pDriveParam->m_pExist[i] = FALSE;

	for( i = drvno; i > 0; i-- ) {
		if ( m_pFmParam->m_pDriveParam->m_pExist[i] ) {
			break;
		}
	}

	bool bch = false;
	if ( m_pFmParam->m_CurrentDriveNo == drvno ) {
		bch = true;
		m_pFmParam->m_CurrentDriveNo = i;
	}
	m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();

	if ( bch ) {
		m_pFmParam->ClearMark();
		ChangeDirectory(m_pFmParam->m_CurrentDriveNo);
	}
	m_pDriveTabWnd->Invalidate();

	m_pFmParam->m_bRedrawFocus = m_pFmParam->m_bInitRedrawFocus;

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}

// CmdMacro No 0x144
// ꑮt@C̕\
void CFileView::CmdMacroDispSpecialFile(bool bSys, bool bHide)
{
	m_pFmParam->m_bListDisplaySystem = bSys; 
	m_pFmParam->m_bListDisplayHide = bHide; 

	CString s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
	m_pFmParam->ClearMark();
	Invalidate();
}

// CmdMacro No 0x14e
// lbg[NhCu̐ڑ
void CFileView::CmdMacroConnectNetwork(CString sDrv, CString sUnc, 
									   CString sUser, CString sPassword, bool bReconnect )
{
	CString sdrive;

	sdrive = sDrv;

	DWORD ret = NO_ERROR;

	int len = sUnc.GetLength() - 1;
	if ( sUnc.GetAt(len) == '\\' ) {
		CString s;
		s = sUnc.Left(len);
		sUnc = s;
	}

	if ( sUser == _T("") ) {
		// ڑ
		ret = WNetAddConnection( sUnc, NULL, sdrive );
	} else {

		NETRESOURCE nr;
		
		nr.dwScope = RESOURCE_GLOBALNET;
		nr.dwType = RESOURCETYPE_DISK;
		nr.dwDisplayType= RESOURCEDISPLAYTYPE_SERVER;
		nr.dwUsage = RESOURCEUSAGE_CONNECTABLE;
		nr.lpLocalName = sdrive.GetBuffer(); //ڑhCu
		nr.lpRemoteName = sUnc.GetBuffer(); //pX
		nr.lpComment = NULL;
		nr.lpProvider = NULL;

		UINT r = IsDlgButtonChecked( IDC_CHECK1 );
		DWORD df = ( bReconnect ) ? CONNECT_UPDATE_PROFILE : 0;
		// ڑ
		ret = WNetAddConnection2(&nr, sPassword, sUser, df);
	}
	if ( ret != NO_ERROR ) {
		CString s;
		s.Format(_T("[ %s ]\nڑɎs܂B"), sdrive);
		MessageBox(s, _T("ڑG["));
		m_bCancelMacro = true;
	} else {

		int dno = sdrive[0] - 'A';
		m_pFmParam->m_pDriveParam->SetDriveParam(dno, DRIVE_REMOTE);
		m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
		m_pDriveTabWnd->Invalidate();

	}
}

// CmdMacro No 0x14e
// lbg[NhCu̐ؒf
void CFileView::CmdMacroDisConnectNetwork(CString sDrv)
{
	CString sdrive;
	sdrive = sDrv;
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	// ؒf
	DWORD ret = WNetCancelConnection2( sdrive, CONNECT_UPDATE_PROFILE, TRUE );

	int dno = sdrive[0] - 'A';
	m_pFmParam->m_pDriveParam->SetDriveParam(dno, -1);
	m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
	m_pDriveTabWnd->Invalidate();

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}

// CmdMacro No 0x156
// {[x̕ύX
void CFileView::CmdMacroChangeVolumeLabel(CString sVlabel)
{
	CString cpath, root;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	root = cpath.Left(3);

	SetVolumeLabel( root, sVlabel );
	
}

// CmdMacro No 0x24d
// ~[Rs[
void CFileView::CmdMacroMirrorCopy(bool bSure, bool bDel, bool bCopy)
{
	bool b = bSure;	// sO̊mF  true:L
	bool bd, bc;
	bd = bDel;	// 폜s
	bc = bCopy;	// Rs[s

	m_pw64CopyData = new _wfinddata64_t[MAXFILE];
	m_pw64CopyDData = new _wfinddata64_t[MAXFILE];
	m_pw64DeleteData = new _wfinddata64_t[MAXFILE];
	m_pMirrorCopySPath = new CString[MAXFILE];
	m_pMirrorCopyDPath = new CString[MAXFILE];
	m_pMirrorDeletePath = new CString[MAXFILE];


	m_pMirrorCopyingDlg = new CMirrorCopyingDialog;
	m_pMirrorCopyingDlg->m_sSDir = m_sMirrorCopySDir;
	m_pMirrorCopyingDlg->m_sDDir = m_sMirrorCopyDDir;

	m_pMirrorCopyingDlg->Create(IDD_MIRROR_COPYING_DIALOG, this);

	m_pMirrorCopyingDlg->ShowWindow(SW_SHOW);

	m_bCancelCmd = false;

	CString fdpath = m_sMirrorCopyDDir;
	int n = fdpath.GetLength();
	if( fdpath.GetAt(n - 1) != CHAR_YEN ) fdpath += STR_YEN;
	m_sMirrorCopyDDir = fdpath;

	CString fspath = m_sMirrorCopySDir;
	n = fspath.GetLength();
	if( fspath.GetAt(n - 1) != CHAR_YEN ) fspath += STR_YEN;
	m_sMirrorCopySDir = fspath;

	m_MirrorCopyDeleteFileCount = 0;
	m_MirrorCopyFileCount = 0;


	CString snull = _T("");
	MirrorCopyFindDeleteDir(snull, snull);

	CString s = _T("ʌtH_̌...");
	m_pMirrorCopyingDlg->m_Status.SetWindowTextW(s);
	MirrorCopyFindCopyDir(snull, snull);

	bool bcancel = m_pMirrorCopyingDlg->m_bCancel;

	m_pMirrorCopyingDlg->DestroyWindow();
	delete m_pMirrorCopyingDlg;

	if ( !bcancel ) {
		if ( (m_MirrorCopyDeleteFileCount == 0) && (m_MirrorCopyFileCount == 0) ) {
			s = _T("XVׂt@C͂܂");
			if ( bSure ) MessageBox(s);
		} else {
			m_MirrorCopySureDlg.m_pFileView = this;
			int ret = IDOK;
			if ( b ) ret = m_MirrorCopySureDlg.DoModal();

			if ( ret == IDOK ) {
				if ( b ) bd = m_MirrorCopySureDlg.m_bIsDelete;
				if ( bd ) {
					MirrorCopyDeleteFile();
				}
				if ( b ) bc = m_MirrorCopySureDlg.m_bIsCopy;
				if ( !m_bCancelCmd && bc ) {
					MirrorCopyCopyFile();
				}
			}
		}
	}

	delete []m_pw64CopyData;
	delete []m_pw64CopyDData;
	delete []m_pw64DeleteData;
	delete []m_pMirrorCopySPath;
	delete []m_pMirrorCopyDPath;
	delete []m_pMirrorDeletePath;


}


void CFileView::CmdMacroChangeNameAll(bool *bpParam, CString *spParam, int *npParam)
{
	int nTag = m_pFmParam->m_TagFileNum;
	if ( nTag == 0 ) return;

	int nmax = m_pFmParam->m_FileNum;

	CString sFname, sExt;
	sFname = _T("");
	sExt = _T("");



	CString sFixedChar = spParam[0];
	CString sFixedChar2 = spParam[1];

	int num = npParam[0];
	int num2 = npParam[3];
	int startNum = npParam[1];
	int startNum2 = npParam[4];
	int addPos = npParam[2];

	bool efname = bpParam[0];
	bool eext = bpParam[1];

	nmax = m_pFmParam->m_FileNum;

	int ns = startNum;
	int ns2 = startNum2;

	CString sFnform, sExform;
	CString cpath;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	CString sform, sform2, s;
	sform.Format(_T("%%0%dd"), num);
	sform2.Format(_T("%%0%dd"), num2);

		for( int i = 0; i < nmax; i++ ) {
			if ( m_pFmParam->m_pMark[i] ) {
				CString sSfname = cpath;
				s = m_pFmParam->m_pw64FindData[i].name;
				sSfname += s;

				m_pFmParam->DivideFileName(s);
				sFname = m_pFmParam->m_sName;
				sExt = m_pFmParam->m_sExt.Right(m_pFmParam->m_sExt.GetLength() - 1);


				CString sd, sd2, sDfname, sForm;
				switch(addPos) {
					case 0:	// 擪ɕt
						if ( efname ) {
							sFnform = sform + sFixedChar;
							sd.Format(sFnform, ns);
						} else sd = sFname;
						if ( eext ) {
							sExform = sform2 + sFixedChar2;
							sd2.Format(sExform, ns2);
						} else sd2 = sExt;
						break;

					case 1:	// ɕt
						if ( efname ) {
							sFnform = sFixedChar + sform;
							sd.Format(sFnform, ns);
						} else sd = sFname;
						if ( eext ) {
							sExform = sFixedChar2 + sform2;
							sd2.Format(sExform, ns2);
						} else sd2 = sExt;
						break;
					case 2:	// ɕt
						if ( efname ) {
							sFnform = sform + sFixedChar + sform;
							sd.Format(sFnform, ns, ns);
						} else sd = sFname;
						if ( eext ) {
							sExform = sform2 + sFixedChar2 + sform2;
							sd2.Format(sExform, ns2, ns2);
						} else sd2 = sExt;
						break;
				}

				sDfname = cpath;
				s = sd;
				s += _T(".");
				s += sd2;
				sDfname += s;

				try
				{
					CFile::Rename(sSfname, sDfname);
					wcscpy_s(m_pFmParam->m_pw64FindData[i].name, s.GetLength() + 1,s);
				}
				catch (CFileException* pEx)
				{
					CString s;
					s.Format(_T("[ %s ]\nt@CύXł܂ł!"), sDfname);
					MessageBox(s, _T("G["));
					pEx->Delete();
				}

				ns++;
				ns2++;
			}
		}

	if ( m_pFmParam->m_SortMode != SORT_NON )  m_pFmParam->SortFileList(m_pFmParam->m_SortMode);
	Invalidate();

}

// CmdMacro No 0x254
// ^CX^v̕ύX
void CFileView::CmdMacroChangeFileTime(CString sFname, bool *bpParam, CString *spParam, int cfkind)
{

    COleDateTime oWriteTime, oCreateTime;
	SYSTEMTIME sysTime;
	bool bt;
	CString s;

	if ( spParam[0] == _T("/") ) {
		oWriteTime = COleDateTime::GetCurrentTime();
	} else {
		bt = oWriteTime.ParseDateTime(spParam[0]);
		if ( !bt ) {
			s.Format(_T("[ %s ]\nsȓwł!"), spParam[0]);
			MessageBox(s, _T("G["));
			m_bCancelMacro = true;
			return;
		}
	}

	CString fname, cpath;
	fname =  m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	m_nKindFileCreateDate = cfkind;
	if ( cfkind == 1 ) oCreateTime = oWriteTime;
	if ( cfkind == 2 ) {
		bt = oCreateTime.ParseDateTime(spParam[1]);
		if ( !bt ) {
			s.Format(_T("[ %s ]\nsȓwł!"), spParam[1]);
			MessageBox(s, _T("G["));
			m_bCancelMacro = true;
			return;
		}
	}

	oWriteTime.GetAsSystemTime(sysTime);
	CTime ctw(sysTime);
	m_t64Write = ctw.GetTime();

	oCreateTime.GetAsSystemTime(sysTime);
	CTime ctc(sysTime);
	m_t64Create = ctc.GetTime();

	m_nChangeFileDate = bpParam[0];

	m_nChangeAllFileCheck = BST_UNCHECKED;
	if ( bpParam[1] ) m_nChangeAllFileCheck = BST_CHECKED;
	m_nChangeAllDirCheck = BST_UNCHECKED;
	if ( bpParam[2] ) m_nChangeAllDirCheck = BST_CHECKED;

	if ( sFname != _T("") ) {
		CFileStatus rStatus;
		if ( !(CFile::GetStatus(sFname, rStatus)) ) {
			s.Format(_T("[ %s ]\nt@C܂!"), sFname);
			MessageBox(s, _T("G["));
			m_bCancelMacro = true;
			return;
		}
		_wfinddata64_t wfdata64;
		int l = sFname.ReverseFind('\\') + 1;

		m_sCPathChangeFileTime = sFname.Left(l);
		s = sFname.Mid(l);
		wcscpy_s(wfdata64.name, s.GetLength() + 1, s);
		m_pw64ChangeFileTime = &wfdata64;
		ChangeFileTime(true);
		s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
		Invalidate();
	}

	CFileStatus fStatus;

	int i;
	bool b;

	if ( m_pFmParam->m_TagFileNum != 0 ) {
		int max = m_pFmParam->m_FileNum;
		for ( i = 0; i < max; i++ ) {
			b = m_pFmParam->m_pMark[i];
			if ( b ) {
				m_sCPathChangeFileTime = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
				m_pw64ChangeFileTime = &(m_pFmParam->m_pw64FindData[i]);
				ChangeFileTime(true);
			}
		}
	} else {
		m_sCPathChangeFileTime = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		m_pw64ChangeFileTime = &(m_pFmParam->m_pw64FindData[m_CurrentFileNo]);
		ChangeFileTime(true);
	}
}


void CFileView::OnTreeMessage()
{
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	int drive;
	CString sd;
	CString path = m_pFmParam->m_sSelectedTreePath;
	sd = path.Left(2);

	drive = sd.GetAt(0) - 0x41;
	m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;

	ChangeDirectory(drive);
	SetFocus();
//	m_pTreeFrameWindow = NULL;

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

}

void CFileView::OnJumpMessage()
{

	CString path = m_pFmParam->m_sSelectedJumpPath;

	CString s, s2, sExePath;
	s = _T("%d");
	s2 = _T("%p");

	sExePath = m_pFmParam->GetExePath(_T(""));
	int n = sExePath.GetLength() - 1;
	if (n > 1) {
		sExePath = sExePath.Left(n);
	}

	CString sDrive;
	sDrive = sExePath.Left(2);

	path.Replace(s, sDrive);
	path.Replace(s2, sExePath);


	CFileStatus rStatus, sStatus;
	if ( !(CFile::GetStatus(path,  rStatus)) ) {	// tH_݂Ȃ
		CString s;
		s.Format(_T("[ %s ]\nȃpXłB"), path);
		MessageBox(s);
		return;

	}



//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	m_pFmParam->MakeFullPath(path);
	path = m_pFmParam->m_FullPath;
	if ( path.GetAt(path.GetLength() - 1) != CHAR_YEN ) path += STR_YEN;
	int drive;
	CString sd;
	sd = path.Left(2);
	sd.MakeUpper();

	if ( sd.GetAt(0) <= _T('Z') ) {
		drive = sd.GetAt(0) - 0x41;
		m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
	} else {
		drive = -1;
		for ( int i = 26; i < MAXDRIVE; i++ ) {
			BOOL b;
			b = m_pFmParam->m_pDriveParam->m_pExist[i];
			if ( b == FALSE ) {
				drive = i;
				break;
			}
		}
		if ( drive == -1 ) drive = MAXDRIVE - 1;
		m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
		m_pFmParam->m_pDriveParam->m_pExist[drive] = TRUE;
		m_pFmParam->m_pDriveParam->m_pType[drive] = DRIVE_REMOTE;
		m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
	}
	ChangeDirectory(drive);
	m_pFmParam->ClearMark();

	SetFocus();

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	if (m_pFmParam->m_bMoveHistoryFile) {
		//		CString ppath =m_pFmParam->m_pFolderData[m_pFmParam->m_nCurrentFolderData].sDirName;
		CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		if (m_pFmParam->m_bEnableMoveHistoryFile) {
			CString sHfile = m_pFmParam->GetHistFolderData(cpath);
			if (sHfile != _T("")) {
				int max = m_pFmParam->m_FileNum;
				for (int n = 0; n < max; n++) {
					CString cf;
					cf = m_pFmParam->m_pw64FindData[n].name;
					if (sHfile == cf) {
						m_CurrentFileNo = n;
						Invalidate();

						break;
					}
				}
			}
			m_pFmParam->m_bEnableMoveHistoryFile = false;
		}

	}

	Invalidate();

}


void CFileView::OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CString path;
	if ( (nFlags & 0x2000) != 0 ) {	// Alt key+
		switch ( nChar ) {

			case 0x25: // ""

				CmdKeyAltLeft();

				break;

			case 0x27: // ""

				CmdKeyAltRight();

				break;
		}
	}


	CView::OnSysKeyDown(nChar, nRepCnt, nFlags);
}

void CFileView::OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CView::OnSysKeyUp(nChar, nRepCnt, nFlags);
}

bool CFileView::MoveFolder(CString sPath)
{
	CString path = sPath;
	CFileStatus rStatus, sStatus;
	if ( !(CFile::GetStatus(path,  rStatus)) ) {	// tH_݂Ȃ
		CString s;
		s.Format(_T("[ %s ]\nȃpXłB"), path);
		MessageBox(s);
		return false;

	}
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	m_pFmParam->MakeFullPath(path);
	path = m_pFmParam->m_FullPath;
	if ( path.GetAt(path.GetLength() - 1) != CHAR_YEN ) path += STR_YEN;
	int drive;
	CString sd;
	sd = path.Left(2);
	sd.MakeUpper();

	if ( sd.GetAt(0) <= _T('Z') ) {
		drive = sd.GetAt(0) - 0x41;
		m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
	} else {
		drive = -1;
		for ( int i = 26; i < MAXDRIVE; i++ ) {
			BOOL b;
			b = m_pFmParam->m_pDriveParam->m_pExist[i];
			if ( b == FALSE ) {
				drive = i;
				break;
			}
		}
		if ( drive == -1 ) drive = MAXDRIVE - 1;
		m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
		m_pFmParam->m_pDriveParam->m_pExist[drive] = TRUE;
		m_pFmParam->m_pDriveParam->m_pType[drive] = DRIVE_REMOTE;
		m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
	}
	ChangeDirectory(drive);
	m_pFmParam->ClearMark();

	m_pFmParam->SetHistFolderData(m_pFmParam->m_pw64FindData[m_CurrentFileNo].name);

	return true;
}

void CFileView::CmdKeyAltLeft()
{
	CString path;
	if (m_pFmParam->m_nHistCurrentFolderNo > 0) {
		m_pFmParam->m_bNotSetHistory = true;

		m_pFmParam->HistPrevFolder();
		path = m_pFmParam->GetHistCurrentFolder();
		MoveFolder(path);

		if (m_pFmParam->m_bMoveHistoryFile) {
			CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			CString sHfile = m_pFmParam->GetHistFolderData(cpath);
			if (sHfile != _T("")) {
				int max = m_pFmParam->m_FileNum;
				for (int n = 0; n < max; n++) {
					CString cf;
					cf = m_pFmParam->m_pw64FindData[n].name;
					if (sHfile == cf) {
						m_CurrentFileNo = n;
						Invalidate();
						break;
					}
				}
			}
			m_pFmParam->m_bEnableMoveHistoryFile = false;

		}
		m_pFmParam->m_bNotSetHistory = false;
	}

}

void CFileView::CmdKeyAltRight()
{
	CString path;
	if (m_pFmParam->m_nHistCurrentFolderNo < m_pFmParam->m_nHistMaxFolderData) {
		m_pFmParam->m_bNotSetHistory = true;

		m_pFmParam->HistNextFolder();
		path = m_pFmParam->GetHistCurrentFolder();
		MoveFolder(path);

		if (m_pFmParam->m_bMoveHistoryFile) {
			CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			CString sHfile = m_pFmParam->GetHistFolderData(cpath);
			if (sHfile != _T("")) {
				int max = m_pFmParam->m_FileNum;
				for (int n = 0; n < max; n++) {
					CString cf;
					cf = m_pFmParam->m_pw64FindData[n].name;
					if (sHfile == cf) {
						m_CurrentFileNo = n;
						Invalidate();
						break;
					}
				}
			}
			m_pFmParam->m_bEnableMoveHistoryFile = false;

		}
		m_pFmParam->m_bNotSetHistory = false;
	}
}

void CFileView::OnMenuSpecialKeyAltLeft()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyAltLeft();

}



HWND *CFileView::m_phwndannsFM = NULL;
int CFileView::m_nWndCount = 0;



BOOL CALLBACK CFileView::EnumWinProc(HWND hwnd, LPARAM lParam)
{

	BOOL r = TRUE;

	WCHAR s[1000];
	s[0] = 0;
	::GetWindowText(hwnd, &s[0], sizeof(s));

	CString cs, s2, s3;
	cs = s;
	s2 = cs.Right(8);

	if ( m_nWndCount == 9 ) return FALSE;

	int n = cs.Find(_T("- annsFM"));
	if (n > 0) {
		m_phwndannsFM[m_nWndCount] = hwnd;
		m_nWndCount++;

	}
	/*
	if ( s2 == _T("- annsFM") ) {
	m_phwndannsFM[m_nWndCount] = hwnd;
	m_nWndCount++;

	}
	*/


	return r;

}

void CFileView::OnMenuSpecialKeyCtrlHome()
{
	// TODO: ɃR}h nh R[hǉ܂B

	CmdKeyCtrlHome();
}

void CFileView::OnMenuSpecialKeyEnd()
{
	// TODO: ɃR}h nh R[hǉ܂B
	CmdKeyEnd();
}

void CFileView::GetAllCurDir()
{
	// TODO: ɃR}h nh R[hǉ܂B

	m_nWndCount = 0;

	EnumWindows(&CFileView::EnumWinProc, 0);

//	if ( m_nWndCount < 2 ) return;
	int e = m_nWndCount;

	WCHAR s[1000];
	CString s2, s3;

	for ( int i = 0; i < e; i++ ) {
		::GetWindowText(m_phwndannsFM[i], &s[0], sizeof(s));
		s2 = s;
		int n = s2.Find(_T(" - annsFM"));
		s3 = s2.Left(n);

//		s3 = s2.Left(s2.GetLength() - 9);
		m_sCdirannsFM[i] = s3;
	}

}


void CFileView::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	if ( !(m_pFmParam->m_bRedrawFocus) ) return;

	m_nUpdateTimeCount--;
	if ( m_nUpdateTimeCount == 0 ) {

		CheckFindNotify();
		m_nUpdateTimeCount = m_pFmParam->m_nUpdateTime;
	}

	CView::OnTimer(nIDEvent);
}

BOOL CFileView::InitMixer(void)
{
	if( m_hMixer ) return TRUE;
	if( mixerOpen(&m_hMixer, 0, 0, 0, MIXER_OBJECTF_MIXER) != MMSYSERR_NOERROR ) return FALSE;
	if( mixerGetDevCaps((UINT)m_hMixer, &m_Mxcaps, sizeof(MIXERCAPS)) != MMSYSERR_NOERROR ) return FALSE;
	return TRUE;
}

void CFileView::ReleaseMixer(void)
{
	if( m_hMixer) mixerClose(m_hMixer);
	m_hMixer = NULL;
	m_dwVolumeControlID = -1;
	m_dwMuteControlID = -1;
}


BOOL CFileView::InitMasterVolumeControl(void)
{
	MIXERLINE mxl;
	MIXERCONTROL mxc;
	MIXERLINECONTROLS mxlc;

	if( m_dwVolumeControlID != -1 ) return TRUE;
	if( InitMixer() == FALSE ) return FALSE;

	mxl.cbStruct = sizeof(MIXERLINE);
	mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS;

	if( mixerGetLineInfo((HMIXEROBJ)m_hMixer, &mxl,
				MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_COMPONENTTYPE) != MMSYSERR_NOERROR) return FALSE;

	mxlc.cbStruct = sizeof(MIXERLINECONTROLS);
	mxlc.dwLineID = mxl.dwLineID;
	mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
	mxlc.cControls = 1;
	mxlc.cbmxctrl = sizeof(MIXERCONTROL);
	mxlc.pamxctrl = &mxc;

	if( mixerGetLineControls((HMIXEROBJ)m_hMixer, &mxlc,
			   MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE) != MMSYSERR_NOERROR) return FALSE;

	m_dwMinimum = mxc.Bounds.dwMinimum;
	m_dwMaximum = mxc.Bounds.dwMaximum;
	m_dwVolumeControlID = mxc.dwControlID;

	return TRUE;
}

BOOL CFileView::GetMasterVolume(int *Val)
{
	MIXERCONTROLDETAILS_UNSIGNED mxcdVolume;
	MIXERCONTROLDETAILS mxcd;

	if( InitMasterVolumeControl() == FALSE ) return FALSE;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS);
	mxcd.dwControlID = m_dwVolumeControlID;
	mxcd.cChannels = 1;
	mxcd.cMultipleItems = 0;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	mxcd.paDetails = &mxcdVolume;
	if( mixerGetControlDetails((HMIXEROBJ)m_hMixer, &mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE) != MMSYSERR_NOERROR ) return FALSE;
	
	*Val = ( ( mxcdVolume.dwValue - m_dwMinimum ) * 100 + ( m_dwMaximum - m_dwMinimum ) / 2) / ( m_dwMaximum - m_dwMinimum );

	return TRUE;
}

BOOL CFileView::SetMasterVolume(int Val)
{
	MIXERCONTROLDETAILS_UNSIGNED mxcdVolume;
	MIXERCONTROLDETAILS mxcd;

	if( InitMasterVolumeControl() == FALSE ) return FALSE;

	mxcdVolume.dwValue = Val * ( m_dwMaximum - m_dwMinimum ) / 100 + m_dwMinimum;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS);
	mxcd.dwControlID = m_dwVolumeControlID;
	mxcd.cChannels = 1;
	mxcd.cMultipleItems = 0;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	mxcd.paDetails = &mxcdVolume;
	if ( mixerSetControlDetails( (HMIXEROBJ)m_hMixer, &mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_SETCONTROLDETAILSF_VALUE) != MMSYSERR_NOERROR ) return FALSE;
	
	return TRUE;
}

BOOL CFileView::UpDownMasterVolume(int dif)
{
	int	Val;

	if( GetMasterVolume(&Val) == FALSE ) return FALSE;

	Val += dif;
	if( Val > 100 ) Val = 100;
	else if( Val < 0) Val = 0;

	if( SetMasterVolume(Val) == FALSE ) return FALSE;

	return	TRUE;
}

BOOL CFileView::InitMasterMuteControl()
{
	MIXERLINE mxl;
	MIXERCONTROL mxc;
	MIXERLINECONTROLS mxlc;

	if(m_dwMuteControlID != -1) return TRUE;
	if(InitMixer() == FALSE) return FALSE;

	mxl.cbStruct = sizeof(MIXERLINE);
	mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_SPEAKERS;
	if(mixerGetLineInfo((HMIXEROBJ)m_hMixer,&mxl,
				MIXER_OBJECTF_HMIXER | MIXER_GETLINEINFOF_COMPONENTTYPE)!=MMSYSERR_NOERROR) return FALSE;

	mxlc.cbStruct = sizeof(MIXERLINECONTROLS);
	mxlc.dwLineID = mxl.dwLineID;
	mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_MUTE;
	mxlc.cControls = 1;
	mxlc.cbmxctrl = sizeof(MIXERCONTROL);
	mxlc.pamxctrl = &mxc;
	if(mixerGetLineControls((HMIXEROBJ)m_hMixer,&mxlc,
			   MIXER_OBJECTF_HMIXER | MIXER_GETLINECONTROLSF_ONEBYTYPE) != MMSYSERR_NOERROR) return FALSE;

	m_dwMuteControlID = mxc.dwControlID;

	return TRUE;
}

BOOL CFileView::GetMasterMute(BOOL *Val)
{
	MIXERCONTROLDETAILS_BOOLEAN mxcdMute;
	MIXERCONTROLDETAILS mxcd;

	if(InitMasterMuteControl() == FALSE) return FALSE;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS);
	mxcd.dwControlID = m_dwMuteControlID;
	mxcd.cChannels = 1;
	mxcd.cMultipleItems = 0;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_BOOLEAN);
	mxcd.paDetails = &mxcdMute;
	if (mixerGetControlDetails((HMIXEROBJ)m_hMixer,&mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_GETCONTROLDETAILSF_VALUE)!=MMSYSERR_NOERROR) return FALSE;
	
	*Val = mxcdMute.fValue;

	return TRUE;
}

BOOL CFileView::SetMasterMute(BOOL Val)
{
	MIXERCONTROLDETAILS_BOOLEAN mxcdMute;
	MIXERCONTROLDETAILS mxcd;

	if(InitMasterMuteControl() == FALSE) return FALSE;

	mxcdMute.fValue=Val;

	mxcd.cbStruct = sizeof(MIXERCONTROLDETAILS);
	mxcd.dwControlID = m_dwMuteControlID;
	mxcd.cChannels = 1;
	mxcd.cMultipleItems = 0;
	mxcd.cbDetails = sizeof(MIXERCONTROLDETAILS_BOOLEAN);
	mxcd.paDetails = &mxcdMute;
	if (mixerSetControlDetails((HMIXEROBJ)m_hMixer,&mxcd,
				 MIXER_OBJECTF_HMIXER | MIXER_SETCONTROLDETAILSF_VALUE)!=MMSYSERR_NOERROR) return FALSE;
	
	return TRUE;
}

BOOL CFileView::ReverseMasterMute(void)
{
	BOOL lVal;

	if(GetMasterMute(&lVal)==FALSE) return FALSE;
	if(SetMasterMute(!lVal)==FALSE) return FALSE;
	
	return TRUE;
}




void CFileView::OnMenuShiftKeyLeft()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyShiftLeft();
}


void CFileView::OnMenuCtrlKeyE()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyCtrlERemoveDrive();
}


void CFileView::OnMenuShiftKeyT()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	saLmzip32ViewOption = "-t";
	CmdKeyView();
}


void CFileView::OnMenuShiftKeyU()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	saLmzip32ViewOption = "-l";
	CmdKeyView();
}


void CFileView::OnShiftKeyS()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyShiftSDrawDirSize();
}


void CFileView::OnMenuShiftKeyF()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CmdKeyShiftFRestoreZip();
}


void CFileView::OnMenuKeyF3()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyF03();
}


void CFileView::OnMenuKeyTab()
{
	// TODO: ɃR}h nh[ R[hǉ܂B
	CMenu* pMenu = m_pChildView->m_pMainFrame->GetMenu();

	m_sIncSearchStr = _T("");
	if (m_bIncSearch) {
		m_bIncSearch = false;
		pMenu->CheckMenuItem(ID_KEY_TAB, MF_UNCHECKED);
	}
	else {
		m_bIncSearch = true;
		pMenu->CheckMenuItem(ID_KEY_TAB, MF_CHECKED);
	}
	RedrawInfo();
}


void CFileView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	if (m_bIncSearch)
	{
		bool r = IncSearch(nChar);

		RedrawInfo();
		Invalidate();
	}

	CView::OnChar(nChar, nRepCnt, nFlags);
}


void CFileView::OnMenuCtrlKeyZ()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyCtrlZReverseMark();
}


void CFileView::OnMenuCtrlKeyK()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyCtrlKSelectMark();

}


void CFileView::OnMenuKeyF7()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyF07Launcher();


}


void CFileView::OnMenuKeyF2()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyF02();

}



void CFileView::OnRButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	CView::OnRButtonUp(nFlags, point);
}


void CFileView::OnKeyMenuRmenu()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CPoint point(-1, -1);
	CmdKeyApp(point);

}


void CFileView::OnMenuKeyX()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyDeleteExif();

}


void CFileView::OnKeyMenuIns()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyInsert();
}


void CFileView::OnKeyMenuF5()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyF05();

}


BOOL CFileView::PopupContextMenu(HWND hwnd, CPoint pt, CString sFname)
{

	std::vector<CString> selectedFilePaths;

	CString fname;
	fname = _T("");
	bool b = false;

	for (int i = 0; i < m_pFmParam->m_FileNum; i++) {
		if (m_pFmParam->m_pMark[i]) {
			fname = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			fname += m_pFmParam->m_pw64FindData[i].name;
			selectedFilePaths.push_back(fname);
			b = true;
		}
	}

	if (!b) {
		selectedFilePaths.push_back(sFname);
	}



		MyShellHelpers::ShowShellContextMenu(this, pt, selectedFilePaths, m_pContextMenu);
	ATLASSERT(m_pContextMenu == nullptr);

	return TRUE;

}


void CFileView::CmdKeyCtrlGPlayMovie(CString sName)
{
	CString sCpath, fname;

	sCpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];

	fname = sName;

	if (sName == _T("")) {
		fname = sCpath;
		fname += m_pFmParam->m_pw64FindData[m_CurrentFileNo].name;
	}

	CString sExePath = m_pFmParam->GetExePath(_T(""));
	CString sResponceDir = sExePath;
	sResponceDir += FMPLAYER_RESPONSE_DIR;

	m_pFmParam->MakeDirectory(sResponceDir);

	CString sResf;
	HINSTANCE hInst = AfxGetInstanceHandle();	// hInstance
	HWND hWnd = m_pChildView->m_pMainFrame->m_hWnd;	// hWnd


	CTime cTime = CTime::GetCurrentTime();           // ݎ
	CString str = cTime.Format("%Y%m%d-%H%M%S");
	
	CString tmp = _T("%s@%d-%s.txt");
//	sResf.Format(tmp, sResponceDir, hInst, str);
	sResf.Format(tmp, sResponceDir, hWnd, str);

	setlocale(LC_ALL, ".ACP");
	CStdioFile cfile;
	if (!cfile.Open(sResf, CFile::modeWrite | CFile::modeCreate)) {
		tmp.Format(_T("[ %s ]\nX|Xt@C̍쐬Ɏs܂!"));
		MessageBox(tmp, _T("I[vG["));
		return;
	}



	CString sfname, fullname, sR;

	int cnt = 0;
	if (m_pFmParam->m_TagFileNum != 0) {
		for (int i = 0; i < m_pFmParam->m_FileNum; i++) {
			if (m_pFmParam->m_pMark[i]) {
				int at = m_pFmParam->m_pw64FindData[i].attrib;

				if ((at & _A_SUBDIR) == 0) {
					sfname = m_pFmParam->m_pw64FindData[i].name;
					fullname = sCpath;
					fullname += sfname;
					int nc = 0;
					if (cnt == 0) nc = 1;
					sR.Format(_T("%d 0 1 0 0 %s\n"), nc, fullname);
					cfile.WriteString(sR);
					cnt++;
				}
			}
		}
	}
	else {
		int at = m_pFmParam->m_pw64FindData[m_CurrentFileNo].attrib;
		if ((at & _A_SUBDIR) == 0) {
			sR.Format(_T("1 0 1 0 0 %s"), fname);
			cfile.WriteString(sR);
		}
	}

	cfile.Close();

	CString sPlayerFname;
	sPlayerFname = sExePath;
	sPlayerFname += FMPLAYER_FILENAME;

	CString sCom;
//	sCom.Format(_T("hInstance=%d \"%s\""), hInst, sResf);
	sCom.Format(_T("hwnd=%d \"%s\""), hWnd, sResf);

	tmp = _T("open");

	ShellExecute(this->m_hWnd, tmp, sPlayerFname, sCom, sExePath, SW_SHOW);

}





bool CFileView::MoviePlayer(int nCommand, CString fName)
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	bool ret = true;

	LPSTR cfname = new CHAR[1000];
	LPSTR lpProc = new char[100];

	if (hInsMoviePlayer)
	{
		if (nCommand == 0) {
			strcpy_s(lpProc, 20, "OpenForm");
			int nStayTop = 1;
			int nIniFile = 0;

			if (lpMpdOpenForm == NULL) {
				lpMpdOpenForm = (LPMPDOPENFORM)GetProcAddress(hInsMoviePlayer, lpProc);
			}

			if (lpMpdOpenForm) {
				HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
				int nStatus = lpMpdOpenForm(hWnd, nStayTop, nIniFile);
			}
			else {
				ret = false;
			}
		}

		if (nCommand == 1) {
			strcpy_s(lpProc, 20, "CloseForm");

			lpMpdCloseForm = (LPMPDCLOSEFORM)GetProcAddress(hInsMoviePlayer, lpProc);

			if (lpMpdCloseForm)
			{
				HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
				int nStatus = lpMpdCloseForm(hWnd);
			}
			else {
				ret = false;
			}
		}

		if (nCommand == 2) {
			strcpy_s(lpProc, 20, "Start");
			strncpy_s(cfname, MAX_PATH, CW2A(fName), _TRUNCATE);

			if (lpMpdStart == NULL) {
				lpMpdStart = (LPMPDSTART)GetProcAddress(hInsMoviePlayer, lpProc);
			}

			if (lpMpdStart) {
				HWND hWnd = AfxGetMainWnd()->GetSafeHwnd();
				int nStatus = lpMpdStart(hWnd, fName);
			}
			else {
				ret = false;
			}

		}

	}

	delete[] lpProc;
	delete[] cfname;

	return ret;

}


void CFileView::OnMenuCtrlKeyG()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyCtrlGPlayMovie();

}


void CFileView::OnMneuShiftKeyG()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyShiftGPlayMovie();

}


void CFileView::OnKeyF9()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyF09ChangeInitialSearch();
}


void CFileView::OnMneuAltRight()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyAltRight();

}


#if 0
LRESULT CFileView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB

	switch (message)
	{
	case WM_INITMENUPOPUP:
	case WM_DRAWITEM:
	case WM_MENUCHAR:
	case WM_MEASUREITEM:
		if (m_pContextMenu)
		{
			LRESULT ret = 0;
			const HRESULT hr = m_pContextMenu->HandleMenuMsg2(message, wParam, lParam, &ret);
			ATLTRACE(_T("Msg = 0x%08x, Result of IContextMenu3::HandleMenuMsg2() = 0x%08lx\n"), message, hr);
			return ret;
		}
		break;
	default:
		break;
	}

	return __super::WindowProc(message, wParam, lParam);
}
#else
BOOL CFileView::OnWndMsg(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	// TODO: ɓȃR[hǉ邩A͊NXĂяoĂB

	switch (message)
	{
	case WM_INITMENUPOPUP:
	case WM_DRAWITEM:
	case WM_MENUCHAR:
	case WM_MEASUREITEM:
		if (m_pContextMenu)
		{
			const HRESULT hr = m_pContextMenu->HandleMenuMsg2(message, wParam, lParam, pResult);
			ATLTRACE(_T("Msg = 0x%08x, Result of IContextMenu3::HandleMenuMsg2() = 0x%08lx\n"), message, hr);
			return true;
		}
		break;
	default:
		break;
	}

	return __super::OnWndMsg(message, wParam, lParam, pResult);
}
#endif


void CFileView::OnMenuEmptyRecycleBin()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyF11EmptyRecycleBin();

}


void CFileView::OnMenuKeyB()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyBinaryEditFile();

}


void CFileView::OnKeyF8()
{
	// TODO: ɃR}h nh[ R[hǉ܂B

	CmdKeyF08();
}


void CFileView::OnCopyData(COPYDATASTRUCT* pCopyDataStruct)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	int sn = pCopyDataStruct->dwData;

	if (sn != 0x8020) return;

	CString sfn;
	sfn.Format(_T("%s"), pCopyDataStruct->lpData);

	CreateannsView(false, false, sfn);
	int n = GetNoUsedViewNo() - 1;
	if (n < 0) n = 0;
	m_pViewFrame[n]->SetForegroundWindow();


//	return CView::OnCopyData(pWnd, pCopyDataStruct);
}


