// DriveTabWnd.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "FileView.h"
#include "DriveTabWnd.h"

// #ifndef _DIRECT_WRITE

// #define DRAWTABOFSETX 30

// #endif

// #ifdef _DIRECT_WRITE

// #define DRAWTABOFSETX 0

// #endif


#define ID_KEY_C2 1
#define ID_REMOVE_MEDIA 2
#define ID_REMOVE_DRIVE 3


// CDriveTabWnd

IMPLEMENT_DYNAMIC(CDriveTabWnd, CView)

CDriveTabWnd::CDriveTabWnd()
{
//	m_pScrollBar = new CScrollBar;
	m_pDriveList = new CString[MAXDRIVE];
	m_pDriveType = new int[MAXDRIVE];
	m_pTabPoint = new int[MAXDRIVE];
	m_CurrentTabNo = 0;
	m_StartTabNo = 0;
	m_CurPos = -1;
	m_OldCurPos = -1;

	m_nCloseNo = -1;

//	if (m_pFmParam->m_bSystemDirectWrite) {
//		CoInitialize(NULL);
//	}

#ifndef _WINVER_XP

	g_pDWriteFactory = NULL;
	g_pD2DFactory = NULL;
	g_pTextFormat = NULL;

	g_pRenderTarget = NULL;
	g_pBackBrush = NULL;

	g_pTabBackBrush = NULL;
	g_pTextBrush = NULL;
	g_pActiveBrush = NULL;
	g_pNoActiveBrush = NULL;

	g_pFrameBrush = NULL;
	g_pActiveFrameBrush = NULL;

	g_pOnMouseBrush = NULL;

	g_pRemovableBrush = NULL;
	g_pCdromBrush = NULL;
	g_pRemoteBrush = NULL;
#endif

/*

	if (m_pFmParam->m_bSystemDirectWrite) {
		m_nDrawTabOffsetX = 0;
	}
	else {
		m_nDrawTabOffsetX = 30;
	}
*/

}

CDriveTabWnd::~CDriveTabWnd()
{
	delete []m_pDriveList;
	delete []m_pDriveType;
//	delete m_pScrollBar;
	delete m_pTabPoint;

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		DiscardD2d1Resources();
#endif

	}

}


BEGIN_MESSAGE_MAP(CDriveTabWnd, CWnd)
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_HSCROLL()
	ON_WM_KEYDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
ON_WM_MOUSEMOVE()
//ON_WM_MOUSELEAVE()
ON_WM_TIMER()
ON_WM_RBUTTONDOWN()

ON_COMMAND(ID_SHIFT_KEY_C, &CDriveTabWnd::OnShiftKeyC)
ON_COMMAND(ID_KEY_C2, &CDriveTabWnd::OnShiftKeyC2)
ON_COMMAND(ID_KEY_H, &CDriveTabWnd::OnKeyH)
ON_COMMAND(ID_SHIFT_KEY_Z, &CDriveTabWnd::OnShiftKeyZ)
ON_COMMAND(ID_REMOVE_MEDIA, &CDriveTabWnd::OnRemoveMedia)
ON_COMMAND(ID_REMOVE_DRIVE, &CDriveTabWnd::OnRemoveDrive)
ON_COMMAND(ID_SHIFT_KEY_P, &CDriveTabWnd::OnShiftKeyP)


END_MESSAGE_MAP()

#ifndef _WINVER_XP

void CDriveTabWnd::CreateD2d1Resources()
{
	CreateDeviceIndependentResources();
	CreateTextFormat();
	CreateDeviceResources();
}

void CDriveTabWnd::DiscardD2d1Resources()
{
	DiscardDeviceIndependentResources();
	DiscardTextFormat();
	DiscardDeviceResources();

}

HRESULT CDriveTabWnd::CreateDeviceIndependentResources()
{
	HRESULT result = S_OK;

	D2D1CreateFactory(
		D2D1_FACTORY_TYPE_SINGLE_THREADED,
		&g_pD2DFactory);

	DWriteCreateFactory(
		DWRITE_FACTORY_TYPE_SHARED,
		__uuidof(g_pDWriteFactory),
		(IUnknown **)(&g_pDWriteFactory));


	return result;
}

void CDriveTabWnd::DiscardDeviceIndependentResources()
{

	if (g_pDWriteFactory != NULL) {
		g_pDWriteFactory->Release();
		g_pDWriteFactory = NULL;

	}

	if (g_pD2DFactory != NULL) {
		g_pD2DFactory->Release();
		g_pD2DFactory = NULL;

	}


}

void CDriveTabWnd::CreateTextFormat()
{

	if (g_pDWriteFactory == NULL) return;

	if (g_pTextFormat != NULL) return;

	CClientDC dcc(this);
	int fw, fh;
//	TEXTMETRIC tm;

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontDriveTab));
	CFont* pOldFont = dcc.SelectObject(&font);

//	GetTextMetrics(dcc, &tm);
//	fh = tm.tmHeight;
//	fw = tm.tmAveCharWidth;
//	m_FontWidth = fw;

	CString ss;
	ss = "M";
	CSize size = dcc.GetTextExtent(ss);
	fw = m_FontWidth = size.cx;
	fh = size.cy;

	m_FontWidth = fw;
	m_FontHeight = fh;

	dcc.SelectObject(&pOldFont);

	CClientDC dc(AfxGetMainWnd());
	int logpix = dc.GetDeviceCaps(LOGPIXELSY);

	CString fontname = m_pFmParam->m_logfontDriveTab.lfFaceName;
	int nPoint = -::MulDiv(m_pFmParam->m_logfontDriveTab.lfHeight, 72, logpix);

	FLOAT fs = logpix * (FLOAT)nPoint / 72;
	int ifs = (INT)(fs + 1.99) / 2;
	FLOAT dip = (FLOAT)(ifs * 2);

	g_pDWriteFactory->CreateTextFormat(
		//		L"Verdana",
		fontname,
		NULL,
		DWRITE_FONT_WEIGHT_NORMAL,
		DWRITE_FONT_STYLE_NORMAL,
		DWRITE_FONT_STRETCH_NORMAL,
		//		50,	// tHgTCY
		dip,
		L"", //locale
		&g_pTextFormat);

	g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_LEADING);
	// g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_CENTER);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_NEAR);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_CENTER);

	m_FontHeight = (int)(g_pTextFormat->GetFontSize());

}

void CDriveTabWnd::DiscardTextFormat()
{
	if (g_pTextFormat == NULL) return;

	g_pTextFormat->Release();
	g_pTextFormat = NULL;

}


HRESULT CDriveTabWnd::CreateDeviceResources(void)
{
	HRESULT hr = S_OK;

	if (g_pRenderTarget != NULL) {
		return hr;
	}

	RECT rc;
	GetClientRect(&rc);

	D2D1_SIZE_U size = D2D1::SizeU(
		rc.right - rc.left,
		rc.bottom - rc.top
		);

	// Create a Direct2D render target.
	g_pD2DFactory->CreateHwndRenderTarget(
		D2D1::RenderTargetProperties(),
		D2D1::HwndRenderTargetProperties(m_hWnd, size),
		&g_pRenderTarget
		);

	COLORREF colBack = m_pFmParam->m_colBack;
	COLORREF colTabBack = m_pFmParam->m_colTabBack;

	COLORREF colFrame = m_pFmParam->m_colTabFrame;
	COLORREF colActiveFrame = m_pFmParam->m_colActiveTabFrame;

	COLORREF colActive = m_pFmParam->m_colActiveTab;
	COLORREF colNoActive = m_pFmParam->m_colNoActiveTab;

	COLORREF colText = m_pFmParam->m_colTabText;
	COLORREF colOnMouse = m_pFmParam->m_colTabOnMouse;
	COLORREF colRemovable = m_pFmParam->m_colTabRemovable;
	COLORREF colCdrom = m_pFmParam->m_colTabCdrom;
	COLORREF colRemote = m_pFmParam->m_colTabRemote;

	// Create a back brush.
	BYTE r, g, b;
	r = colBack & 0xff;
	g = (colBack >> 8) & 0xff;
	b = (colBack >> 16) & 0xff;

	UINT32 rgb;
	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pBackBrush
		);

	m_D2DcolBack = rgb;


	r = colTabBack & 0xff;
	g = (colTabBack >> 8) & 0xff;
	b = (colTabBack >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pTabBackBrush
		);

	m_D2DcolTabBack = rgb;

	r = colFrame & 0xff;
	g = (colFrame >> 8) & 0xff;
	b = (colFrame >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pFrameBrush
		);


	r = colActiveFrame & 0xff;
	g = (colActiveFrame >> 8) & 0xff;
	b = (colActiveFrame >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pActiveFrameBrush
		);


	r = colActive & 0xff;
	g = (colActive >> 8) & 0xff;
	b = (colActive >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pActiveBrush
		);


	r = colNoActive & 0xff;
	g = (colNoActive >> 8) & 0xff;
	b = (colNoActive >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pNoActiveBrush
		);


	r = colText & 0xff;
	g = (colText >> 8) & 0xff;
	b = (colText >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pTextBrush
		);



	r = colOnMouse & 0xff;
	g = (colOnMouse >> 8) & 0xff;
	b = (colOnMouse >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pOnMouseBrush
		);


	r = colRemovable & 0xff;
	g = (colRemovable >> 8) & 0xff;
	b = (colRemovable >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pRemovableBrush
		);


	r = colCdrom & 0xff;
	g = (colCdrom >> 8) & 0xff;
	b = (colCdrom >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pCdromBrush
		);


	r = colRemote & 0xff;
	g = (colRemote >> 8) & 0xff;
	b = (colRemote >> 16) & 0xff;

	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pRemoteBrush
		);

	return hr;
}

void CDriveTabWnd::DiscardDeviceResources()
{
	if (g_pRenderTarget != NULL) {
		g_pRenderTarget->Release();
		g_pRenderTarget = NULL;

	}

	if (g_pBackBrush != NULL) {
		g_pBackBrush->Release();
		g_pBackBrush = NULL;
	}

	if (g_pTabBackBrush != NULL) {
		g_pTabBackBrush->Release();
		g_pTabBackBrush = NULL;
	}

	if (g_pTextBrush != NULL) {
		g_pTextBrush->Release();
		g_pTextBrush = NULL;
	}
	if (g_pActiveBrush != NULL) {
		g_pActiveBrush->Release();
		g_pActiveBrush = NULL;
	}
	if (g_pNoActiveBrush != NULL) {
		g_pNoActiveBrush->Release();
		g_pNoActiveBrush = NULL;
	}
	if (g_pFrameBrush != NULL) {
		g_pFrameBrush->Release();
		g_pFrameBrush = NULL;
	}
	if (g_pActiveFrameBrush != NULL) {
		g_pActiveFrameBrush->Release();
		g_pActiveFrameBrush = NULL;
	}
	if (g_pOnMouseBrush != NULL) {
		g_pOnMouseBrush->Release();
		g_pOnMouseBrush = NULL;
	}
	if (g_pRemovableBrush != NULL) {
		g_pRemovableBrush->Release();
		g_pRemovableBrush = NULL;
	}
	if (g_pCdromBrush != NULL) {
		g_pCdromBrush->Release();
		g_pCdromBrush = NULL;
	}
	if (g_pRemoteBrush != NULL) {
		g_pRemoteBrush->Release();
		g_pRemoteBrush = NULL;
	}

}

void CDriveTabWnd::d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = CA2W(strA);

	int len = sText.GetLength();
	int glen = strA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		//		D2D1::RectF(fX, fY, (FLOAT)rc.right, fY + lh),
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

}

void CDriveTabWnd::d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = strW;

	CStringA sA;
	sA = CW2A(strW);

	int len = sText.GetLength();
	int glen = sA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + (glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

}

#endif



// CDriveTabWnd bZ[W nh


BOOL CDriveTabWnd::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

// #ifndef _DIRECT_WRITE

	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		CBrush brush(m_pFmParam->m_colTabBack);
		// VuVw(̃uV̕ۑ)
		CBrush* pOldBrush = pDC->SelectObject(&brush);

		// hԂ̈擾
		CRect rect;
		//    pDC->GetClipBox(&rect);
		GetClientRect(rect);

		//	CPen pen(PS_SOLID, 0, m_pFmParam->m_colTabFrame);
		//	CPen* pOldPen = pDC->SelectObject(&pen);

		// hԂ
		//    pDC->PatBlt(rect.left + FRAMEOFSET - 2, rect.top, rect.Width() - (FRAMEOFSET * 2 - 4), rect.Height(), PATCOPY);
		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

		//	pDC->Rectangle(&rect);

		// uVɖ߂
		pDC->SelectObject(pOldBrush);
		//	pDC->SelectObject(pOldPen);
	}

// #endif


	return TRUE;

//	return CWnd::OnEraseBkgnd(pDC);
}

void CDriveTabWnd::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B

//	if (m_pFmParam->m_bSystemDirectWrite) {
//		m_nDrawTabOffsetX = 0;
//	}
//	else {
//		m_nDrawTabOffsetX = 30;
//	}

//	CRect rc;
//	GetClientRect(&rc);
//	rc.top += 3;
//	rc.right = m_nDrawTabOffsetX - 2;
//	rc.left += 1;
//	rc.bottom -= 1;
//	m_pScrollBar->MoveWindow(&rc);


}

void CDriveTabWnd::DrawAllTab(void)
{
// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		DrawAllTabDirectWrite();
#endif

		return;
	}

// #endif

	CClientDC dc(this);

	CBrush brb(m_pFmParam->m_colTabBack);
	CBrush* pOldBrush = dc.SelectObject(&brb);

	// hԂ̈擾
	CRect rect;
	GetClientRect(rect);

//	if (m_pFmParam->m_bSystemDirectWrite) {
		m_nDrawTabOffsetX = 0;
//	}
//	else {
//		m_nDrawTabOffsetX = 30;
//	}

	rect.left = m_nDrawTabOffsetX;
	dc.FillRect(&rect, &brb);

	dc.SelectObject(pOldBrush);

	CBrush brushb(m_pFmParam->m_colBack);
	pOldBrush = dc.SelectObject(&brushb);

	// hԂ̈擾
	GetClientRect(rect);

	rect.bottom = rect.top + 2;
	dc.FillRect(&rect, &brushb);

	dc.SelectObject(pOldBrush);


	CBrush brush(m_pFmParam->m_colActiveTab);
	// VuVw(̃uV̕ۑ)
	pOldBrush = dc.SelectObject(&brush);

	GetClientRect(&rect);
	m_LastPoint = rect.right;

	CPen pen(PS_SOLID, 0, m_pFmParam->m_colActiveTabFrame);
	CPen* pOldPen = dc.SelectObject(&pen);

	//	int of = FRAMEOFSET- 2;
	int of = 0;
	dc.MoveTo(of + 2, 2);
	//	dc.LineTo(rect.right - FRAMEOFSET + 2, 2);
	dc.LineTo(rect.right - 2, 2);

	//	dc.Rectangle(of, 0, rect.right, 3);

	//	dc.Rectangle(of, 0, rect.right, 2);
	//	dc.Rectangle(of, 0, FRAMEOFSET - 2, 2);
	//	dc.Rectangle(rect.right - FRAMEOFSET + 2, 0, rect.right, 2);

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontDriveTab));
	CFont* pOldFont = dc.SelectObject(&font);


	// uVɖ߂
	dc.SelectObject(pOldBrush);
	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);

	int i;
	int j = 0;
	bool r;

//	if (m_pFmParam->m_bSystemDirectWrite) {
		m_nDrawTabOffsetX = 0;
//	}
//	else {
//		m_nDrawTabOffsetX = 30;
//	}

	m_NextTabPoint = m_nDrawTabOffsetX;
	for (i = 0; i < MAXDRIVE; i++) {
		m_pTabPoint[i] = 0;
		if ((i >= m_StartTabNo) && (i < m_MaxTab)) {
			m_pTabPoint[i] = m_NextTabPoint;
			r = DrawTab(i, 0);
		}
		if (i == m_MaxTab) m_pTabPoint[i] = m_NextTabPoint;
	}

}

bool CDriveTabWnd::DrawTab(int TabNo, int type)
{
// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		DrawTabDirectWrite(TabNo, type);
#endif

		return true;
	}

// #endif

	CClientDC dc(this);
	int hh, normalh, selecth, w, of, ys;

	CPen pen1(PS_SOLID, 0, m_pFmParam->m_colActiveTabFrame);
	CPen pen2(PS_SOLID, 0, m_pFmParam->m_colTabFrame);

	CPen* pOldPen;
	if( TabNo == m_CurrentTabNo ) pOldPen = dc.SelectObject(&pen1);
	else pOldPen = dc.SelectObject(&pen2);


	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontDriveTab));
	CFont* pOldFont = dc.SelectObject(&font);

	int fw, fh;
//	TEXTMETRIC tm;

//	GetTextMetrics(dc, &tm);
//	fh = tm.tmHeight;
//	fw = tm.tmAveCharWidth + 1;

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);
	fw = size.cx;
	fh = size.cy;

	selecth = m_pFmParam->m_DriveTabHeight - 2;
	normalh = selecth - 2;
	hh = normalh *10 / 15;

	CSize sizew;

	CString stt, tmp;
	int max = m_pFmParam->m_DriveTabMaxWidth;
	stt = m_pDriveList[TabNo];
	if ( stt.GetLength() > max ) {
		stt = m_pDriveList[TabNo].Left(3);
		stt += _T("...");
		tmp = m_pDriveList[TabNo].Right(max - 6);
		stt += tmp;
	}
	sizew = dc.GetTextExtent(stt);

	w = sizew.cx + fw * 2;
	of = m_NextTabPoint;
	ys = 3;	// ^u\Jnʒu(Jg^uȊO1hbgĕ`)
	if( TabNo == m_CurrentTabNo ) {
		ys = 2;	// Jg^u
	}

	int mouseX = m_pointMouse.x;
	CBrush brush(m_pFmParam->m_colNoActiveTab);
	CBrush sbrush(m_pFmParam->m_colActiveTab);
	CBrush brushM(m_pFmParam->m_colTabOnMouse);
	CBrush brushR(m_pFmParam->m_colTabRemovable);
	CBrush brushC(m_pFmParam->m_colTabCdrom);
	CBrush brushN(m_pFmParam->m_colTabRemote);

	// VuVw(̃uV̕ۑ)
    CBrush* pOldBrush;
	if( TabNo == m_CurrentTabNo ) pOldBrush = dc.SelectObject(&sbrush);
	else {
		if ( TabNo == m_CurPos ) {
			pOldBrush = dc.SelectObject(&brushM);
		} else {
			if ( m_pDriveType[TabNo] == DRIVE_REMOVABLE ) pOldBrush = dc.SelectObject(&brushR);
			else {
				if ( m_pDriveType[TabNo] == DRIVE_CDROM ) pOldBrush = dc.SelectObject(&brushC);
				else {
					if ( m_pDriveType[TabNo] == DRIVE_REMOTE ) pOldBrush = dc.SelectObject(&brushN);
					else pOldBrush = dc.SelectObject(&brush);
				}
			}
		}
	}


	POINT pt[7];
	pt[0].x = of;
	pt[0].y = ys;
	pt[1].x = of + w - 1;
	if( TabNo == m_CurrentTabNo ) {
		pt[1].x += FRAMEOFSET;
		if ( TabNo == 0 ) pt[1].x -= 4;
	}
	if( TabNo == (m_CurrentTabNo + 1) ) {
		pt[1].x -= 2;
		hh += (hh / 3);
	}
	pt[1].y = ys;
	pt[2].x = pt[1].x;
	pt[2].y = normalh - 2;
	if( TabNo == m_CurrentTabNo ) pt[2].y = selecth - 2;
	pt[3].x = pt[2].x - 2;
	pt[3].y = normalh;
	if( TabNo == m_CurrentTabNo ) pt[3].y = selecth;

	pt[4].x = of + normalh - hh;
	pt[4].y = pt[3].y;
	pt[5].x = of;
	pt[5].y = hh;
	pt[6].x = of;
	pt[6].y = ys;

	m_NextTabPoint = pt[1].x;
	if( TabNo == m_CurrentTabNo ) m_NextTabPoint++;

	int tof;
	tof = of + fw + (fw / 2);
	if( TabNo == (m_CurrentTabNo + 1) ) tof -= 2 ;
	dc.Polygon((const POINT*)&pt, 7);
	dc.SetTextColor(m_pFmParam->m_colTabText);
	if( TabNo == m_CurrentTabNo ) dc.SetBkColor(m_pFmParam->m_colActiveTab);
	else {
		COLORREF bkc = m_pFmParam->m_colNoActiveTab;
		if ( TabNo == m_CurPos ) bkc = m_pFmParam->m_colTabOnMouse;
		else {
			if ( m_pDriveType[TabNo] == DRIVE_REMOVABLE ) bkc = m_pFmParam->m_colTabRemovable;
			if ( m_pDriveType[TabNo] == DRIVE_CDROM ) bkc = m_pFmParam->m_colTabCdrom;
			if ( m_pDriveType[TabNo] == DRIVE_REMOTE ) bkc = m_pFmParam->m_colTabRemote;
		}
		dc.SetBkColor(bkc);
	}
	dc.TextOut(tof, normalh / 4, stt);

	// uVɖ߂
    dc.SelectObject(pOldBrush);
	dc.SelectObject(pOldPen);
	dc.SelectObject(pOldFont);


	if( TabNo == m_CurrentTabNo ) {
		CPen spen(PS_SOLID, 0, m_pFmParam->m_colActiveTab);
		dc.SelectObject(spen);
		dc.MoveTo(pt[0].x + 1, pt[0].y);
		dc.LineTo(pt[1].x, pt[1].y);

		dc.SelectObject(pOldPen);
	}

	return true;
}

#ifndef _WINVER_XP

void CDriveTabWnd::DrawAllTabDirectWrite(void)
{
	CreateTextFormat();
	CreateDeviceResources();

	if (!g_pRenderTarget) return;

	g_pRenderTarget->BeginDraw();



	CClientDC dc(this);

	// hԂ̈擾
	CRect rect;
	GetClientRect(rect);

	g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolTabBack));

	// hԂ̈擾
	GetClientRect(rect);

	rect.bottom = rect.top + 2;

	D2D1_RECT_F d2d1Rect;
	d2d1Rect.top = (FLOAT)rect.top;
	d2d1Rect.bottom = (FLOAT)rect.bottom;
	d2d1Rect.left = (FLOAT)rect.left;
	d2d1Rect.right = (FLOAT)rect.right;

	g_pRenderTarget->FillRectangle(&d2d1Rect, g_pBackBrush);

	GetClientRect(&rect);
	m_LastPoint = rect.right;

	D2D1_POINT_2F p1, p2;
	p1.x = 0;
	p1.y = 2;
	p2.x = (FLOAT)rect.right;
	p2.y = 2;

	g_pRenderTarget->DrawLine(p1, p2, g_pActiveFrameBrush, 2.0F);

	int i;
	int j = 0;
	bool r;

//	if (m_pFmParam->m_bSystemDirectWrite) {
		m_nDrawTabOffsetX = 0;
//	}
//	else {
//		m_nDrawTabOffsetX = 30;
//	}

	m_NextTabPoint = m_nDrawTabOffsetX;
	for (i = 0; i < MAXDRIVE; i++) {
		m_pTabPoint[i] = 0;
		if ((i >= m_StartTabNo) && (i < m_MaxTab)) {
			m_pTabPoint[i] = m_NextTabPoint;
			r = DrawTabDirectWrite(i, 0);
		}
		if (i == m_MaxTab) m_pTabPoint[i] = m_NextTabPoint;
	}


	g_pRenderTarget->EndDraw();

}

template <class T> void SafeRelease(T **ppT)
{
	if (*ppT)
	{
		(*ppT)->Release();
		*ppT = NULL;
	}
}


bool CDriveTabWnd::DrawTabDirectWrite(int TabNo, int type)
{

	ID2D1SolidColorBrush *pFrameBrush = g_pFrameBrush;

	if (TabNo == m_CurrentTabNo) pFrameBrush = g_pActiveFrameBrush;

	ID2D1SolidColorBrush *pTabBrush;

	if (TabNo == m_CurrentTabNo) pTabBrush = g_pActiveBrush;
	else {
		if (TabNo == m_CurPos) {
			pTabBrush = g_pOnMouseBrush;
		}
		else {
			if (m_pDriveType[TabNo] == DRIVE_REMOVABLE) pTabBrush = g_pRemovableBrush;
			else {
				if (m_pDriveType[TabNo] == DRIVE_CDROM) pTabBrush = g_pCdromBrush;
				else {
					if (m_pDriveType[TabNo] == DRIVE_REMOTE) pTabBrush = g_pRemoteBrush;
					else pTabBrush = g_pNoActiveBrush;
				}
			}
		}
	}

	CClientDC dc(this);
	int hh, normalh, selecth, w, of, ys;


	selecth = m_pFmParam->m_DriveTabHeight - 2;
	normalh = selecth - 2;
	hh = normalh * 10 / 15;

	CSize sizew;

	CString stt, tmp;
	int max = m_pFmParam->m_DriveTabMaxWidth;
	stt = m_pDriveList[TabNo];
	if (stt.GetLength() > max) {
		stt = m_pDriveList[TabNo].Left(3);
		stt += _T("...");
		tmp = m_pDriveList[TabNo].Right(max - 6);
		stt += tmp;
	}

	CStringA sA;
	sA = CW2A(stt);

	int len = sA.GetLength() * m_FontWidth;

	w = len + m_FontWidth * 2 + 2;

	of = m_NextTabPoint;
	ys = 3;	// ^u\Jnʒu(Jg^uȊO1hbgĕ`)
	if (TabNo == m_CurrentTabNo) {
		ys = 2;	// Jg^u
	}

	int mouseX = m_pointMouse.x;

	POINT pt[7];
	pt[0].x = of;
	pt[0].y = ys;
	pt[1].x = of + w - 1;
	if (TabNo == m_CurrentTabNo) {
		pt[1].x += FRAMEOFSET;
		if (TabNo == 0) pt[1].x -= 4;
	}
	if (TabNo == (m_CurrentTabNo + 1)) {
		pt[1].x -= 2;
		hh += (hh / 3);
	}
	pt[1].y = ys;
	pt[2].x = pt[1].x;
	pt[2].y = normalh - 2;
	if (TabNo == m_CurrentTabNo) pt[2].y = selecth - 2;
	pt[3].x = pt[2].x - 2;
	pt[3].y = normalh;
	if (TabNo == m_CurrentTabNo) pt[3].y = selecth;

	pt[4].x = of + normalh - hh;
	pt[4].y = pt[3].y;
	pt[5].x = of;
	pt[5].y = hh;
	pt[6].x = of;
	pt[6].y = ys;

	m_NextTabPoint = pt[1].x;
	if (TabNo == m_CurrentTabNo) m_NextTabPoint++;

	ID2D1PathGeometry *pTabGeometry;

	HRESULT hr = g_pD2DFactory->CreatePathGeometry(&pTabGeometry);
	if (SUCCEEDED(hr))
	{
		ID2D1GeometrySink *pSink = NULL;

		hr = pTabGeometry->Open(&pSink);
		if (SUCCEEDED(hr))
		{
			pSink->SetFillMode(D2D1_FILL_MODE_WINDING);

			pSink->BeginFigure(
				D2D1::Point2F((FLOAT)pt[0].x, (FLOAT)pt[0].y),
				D2D1_FIGURE_BEGIN_FILLED
				);
			D2D1_POINT_2F points[] = {
				D2D1::Point2F((FLOAT)pt[1].x, (FLOAT)pt[1].y),
				D2D1::Point2F((FLOAT)pt[2].x, (FLOAT)pt[2].y),
				D2D1::Point2F((FLOAT)pt[3].x, (FLOAT)pt[3].y),
				D2D1::Point2F((FLOAT)pt[4].x, (FLOAT)pt[4].y),
				D2D1::Point2F((FLOAT)pt[5].x, (FLOAT)pt[5].y),
				D2D1::Point2F((FLOAT)pt[6].x, (FLOAT)pt[6].y),
			};
			pSink->AddLines(points, ARRAYSIZE(points));
			pSink->EndFigure(D2D1_FIGURE_END_CLOSED);
		}
		hr = pSink->Close();

		SafeRelease(&pSink);
	}

	g_pRenderTarget->FillGeometry(pTabGeometry, pTabBrush);
	g_pRenderTarget->DrawGeometry(pTabGeometry, pFrameBrush);


	int tof;
	tof = of + m_FontWidth + (m_FontWidth / 2);
	if (TabNo == (m_CurrentTabNo + 1)) tof -= 2;


	ID2D1SolidColorBrush *pTextbackBrush;

	if (TabNo == m_CurrentTabNo) {
		pTextbackBrush = g_pActiveBrush;
	}
	else {
		pTextbackBrush = g_pNoActiveBrush;
		if (TabNo == m_CurPos) pTextbackBrush = g_pOnMouseBrush;
		else {
			if (m_pDriveType[TabNo] == DRIVE_REMOVABLE) pTextbackBrush = g_pRemovableBrush;
			if (m_pDriveType[TabNo] == DRIVE_CDROM) pTextbackBrush = g_pCdromBrush;
			if (m_pDriveType[TabNo] == DRIVE_REMOTE) pTextbackBrush = g_pRemoteBrush;
		}
	}
	d2d1DrawTextW(tof, normalh / 4, stt, g_pTextBrush, pTextbackBrush);

	if (TabNo == m_CurrentTabNo) {

		D2D1_POINT_2F p1, p2;
		p1.x = (FLOAT)pt[0].x + 1;
		p1.y = (FLOAT)pt[0].y;
		p2.x = (FLOAT)pt[1].x - 1;
		p2.y = (FLOAT)pt[1].y;

		g_pRenderTarget->DrawLine(p1, p2, g_pActiveBrush, 2.0F);


	}


	return true;
}

#endif

void CDriveTabWnd::OnDraw(CDC* pDC)
{
	DrawAllTab();
}


int CDriveTabWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;


//	if (m_pFmParam->m_bSystemDirectWrite) {
		m_nDrawTabOffsetX = 0;

#ifndef _WINVER_XP
		CreateDeviceIndependentResources();
#endif

//	}
//	else {
//		m_nDrawTabOffsetX = 30;
//	}


	// TODO:  ɓȍ쐬R[hǉĂB
//	m_pScrollBar->Create(SB_HORZ | WS_CHILD | WS_VISIBLE, CRect(0, 0, 0, 0), this, 104);
//	m_pScrollBar->SetScrollRange(0, 1);
//	m_pScrollBar->EnableScrollBar(ESB_DISABLE_LTUP);

	DragAcceptFiles();
	BOOL b = m_DropTarget.Register(this);

	m_nScanTime = m_pFmParam->m_DriveScanTime;
	SetTimer(1, 100, NULL);


	CClientDC dc(this);
	int fw, fh;
//	TEXTMETRIC tm;

	CFont font;
	font.CreateFontIndirect(&(m_pFmParam->m_logfontDriveTab));
	CFont* pOldFont = dc.SelectObject(&font);

//	GetTextMetrics(dc, &tm);
//	fh = tm.tmHeight;
//	fw = tm.tmAveCharWidth;
//	m_FontWidth = fw;

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);
	fw = m_FontWidth = size.cx;
	fh = size.cy;
	m_FontWidth = fw;

	dc.SelectObject(&pOldFont);

	return 0;
}

void CDriveTabWnd::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	/*
	switch(nSBCode) {
	case SB_LINELEFT:
	if ( m_StartTabNo > 0 ) m_StartTabNo--;
	DrawAllTab();
	break;

	case SB_LINERIGHT:
	if ( m_StartTabNo < m_MaxTab ) m_StartTabNo++;
	DrawAllTab();
	break;

	}
	m_pScrollBar->EnableScrollBar(ESB_ENABLE_BOTH);
	if ( m_StartTabNo == 0 ) m_pScrollBar->EnableScrollBar(ESB_DISABLE_LTUP);
	if ( m_StartTabNo == (m_MaxTab - 1) ) m_pScrollBar->EnableScrollBar(ESB_DISABLE_RTDN);
	*/


//	CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

// DriveParamA-ZhCuAڑĂhCüꗗ쐬
int CDriveTabWnd::CreateDriveList(void)
{
	int i, j;
	j = 0;
	for( i = 0; i < MAXDRIVE; i++ ) {
		if (m_pFmParam->m_pDriveParam->m_pExist[i]) {
			if ( m_pFmParam->m_CurrentDriveNo == i ) m_CurrentTabNo = j;
			m_pDriveList[j] = m_pFmParam->m_pDriveParam->m_pCurrentPath[i];
			m_pDriveType[j] = m_pFmParam->m_pDriveParam->m_pType[i];
			j++;
		}
	}

	return j;
}

void CDriveTabWnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CDriveTabWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	int i;
	UINT j;
	bool r = false;

	for (i = 0; i < (MAXDRIVE - 1); i++ ) {
		if ( (point.x >= m_pTabPoint[i]) && (point.x < m_pTabPoint[i + 1]) ) {
			r = true;
			break;
		}
	}

	for( j = 0; j < MAXDRIVE; j++ ) {
		if ( j < 26 ) {
			if ( m_pDriveList[i].GetAt(0) == m_pFmParam->m_pDriveParam->m_pCurrentPath[j].GetAt(0) ) {
				break;
			}
		} else {
			if ( m_pDriveList[i] == m_pFmParam->m_pDriveParam->m_pCurrentPath[j] ) {
				break;
			}
		}
	}

	if ( r ) {
		m_pFmParam->ClearMark();
		m_pFileView->ChangeDirectory(j);
	}

	m_pFileView->SetFindNotify();

	CWnd::OnLButtonDown(nFlags, point);
}

void CDriveTabWnd::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CWnd::OnLButtonUp(nFlags, point);
}

DROPEFFECT CDriveTabWnd::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	DROPEFFECT dwDropEffect = DROPEFFECT_NONE;

	if( pDataObject->IsDataAvailable(CF_TEXT) ) {
//		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	} else {
//		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;
	}

//	m_dwKeyState = dwKeyState;
	dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;

	return dwDropEffect;

//	return CView::OnDragEnter(pDataObject, dwKeyState, point);
}

DROPEFFECT CDriveTabWnd::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	DROPEFFECT dwDropEffect = DROPEFFECT_NONE;

	if( pDataObject->IsDataAvailable(CF_TEXT) ) {
//		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
	} else {
//		m_dwKeyState = dwKeyState;
		dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;
	}

//	m_dwKeyState = dwKeyState;
	dwDropEffect = (dwKeyState & MK_CONTROL) ? DROPEFFECT_MOVE : DROPEFFECT_COPY;

	OnMouseMove(0, point);
			
	return dwDropEffect;

//	return CView::OnDragOver(pDataObject, dwKeyState, point);
}

BOOL CDriveTabWnd::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	if ( pDataObject->IsDataAvailable( CF_HDROP ) )
	{
		HDROP hDrop = (HDROP)pDataObject->GetGlobalData( CF_HDROP );
		if ( hDrop )
		{
			UINT nFiles = ::DragQueryFile( hDrop, 0xFFFFFFFF, NULL, 0 );
			if ( nFiles )
			{
				int i;
				UINT j;
				bool r = false;

				for (i = 0; i < (MAXDRIVE - 1); i++ ) {
					if ( (point.x >= m_pTabPoint[i]) && (point.x < m_pTabPoint[i + 1]) ) {
						r = true;
						break;
					}
				}

				for( j = 0; j < MAXDRIVE; j++ ) {
					if ( m_pDriveList[i].GetAt(0) == m_pFmParam->m_pDriveParam->m_pCurrentPath[j].GetAt(0) ) {
						break;
					}
				}

				if ( r ) {
					CString cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[j];

					m_pFileView->m_saDropFilesArray.SetSize( nFiles );
					LPTSTR lpFileName = new TCHAR [MAX_PATH];
					UINT nDropFile = 0;

					for ( UINT i = 0 ; i < nFiles ; i ++ )
					{
						if ( ::DragQueryFile( hDrop, i, lpFileName, MAX_PATH ) )
							m_pFileView->m_saDropFilesArray.SetAt( nDropFile++, lpFileName );
					}

					::DragFinish( hDrop );
					delete [] lpFileName;


					if ( nDropFile )
					{
						if ( nDropFile != nFiles ) m_pFileView->m_saDropFilesArray.SetSize( nDropFile );
						m_pFileView->DropFilesCopy(dropEffect, cpath);

						CString s = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
						m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
						int max = m_pFmParam->m_FileNum - 1;
						if ( m_pFileView->m_CurrentFileNo > max ) m_pFileView->m_CurrentFileNo = max;
						m_pFmParam->ClearMark();
						m_pFileView->Invalidate();
					}

				}
			}
		}
	}
	
	return CView::OnDrop(pDataObject, dropEffect, point);
}

void CDriveTabWnd::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	m_pointMouse = point;


	int i;
	bool r = false;

	for (i = 0; i < (MAXDRIVE - 1); i++ ) {
		if ( (point.x >= m_pTabPoint[i]) && (point.x < m_pTabPoint[i + 1]) ) {
			r = true;
			break;
		}
	}

	if ( i != m_CurPos ) {
		m_OldCurPos = m_CurPos;
		m_CurPos = i;

//		if (m_pFmParam->m_bSystemDirectWrite) {
			m_nDrawTabOffsetX = 0;
//		}
//		else {
//			m_nDrawTabOffsetX = 30;
//		}

		m_NextTabPoint = m_nDrawTabOffsetX;
		for(i = 0; i < MAXDRIVE; i++) {
			m_pTabPoint[i] = 0;
			if ( (i >= m_StartTabNo) && (i < m_MaxTab) ) {
				m_pTabPoint[i] = m_NextTabPoint;

// #ifndef _DIRECT_WRITE
				if (!(m_pFmParam->m_bSystemDirectWrite)) {
					r = DrawTab(i, 0);
				}

// #endif

// #ifdef _DIRECT_WRITE

				if (m_pFmParam->m_bSystemDirectWrite) {
					Invalidate();
				}

// #endif
			}
			if ( i == m_MaxTab ) m_pTabPoint[i] = m_NextTabPoint;
		}
	}

	CView::OnMouseMove(nFlags, point);
}


void CDriveTabWnd::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	m_nScanTime--;
	int st = m_pFmParam->m_DriveScanTime;
	if ( m_nScanTime == 0 && st != 0 ) {
		m_nScanTime = st;
		OnShiftKeyZ();
	}

	CRect rc;
	GetWindowRect(&rc);

	POINT pos;
	GetCursorPos(&pos);

	if ( m_CurPos != -1 ) {
		if ( pos.x < rc.left || pos.x > rc.right || pos.y < rc.top || pos.y > rc.bottom ) {
			m_CurPos = -1;
			m_OldCurPos = -1;
			Invalidate();
		}
	}

	CView::OnTimer(nIDEvent);
}

void CDriveTabWnd::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	int i;
	UINT j;
	bool r = false;
	bool r2;

	for (i = 0; i < (MAXDRIVE - 1); i++ ) {
		if ( (point.x >= m_pTabPoint[i]) && (point.x < m_pTabPoint[i + 1]) ) {
			r = true;
			break;
		}
	}

	m_nClickDriveNo = i;

	m_nCloseNo = -1;
	r = false;
	r2 = false;
//	m_cMediaDrive = _T('');
	m_cMediaDrive = 0;

	bool bRemovable = false;

	if ( m_pDriveType[i] == DRIVE_REMOVABLE && m_pDriveType[i] != DRIVE_CDROM && m_pDriveList[i].GetAt(0) != _T('A') ) {
		bRemovable = true;
		m_cMediaDrive = m_pDriveList[i].GetAt(0);
	}

	bool bCdrom = false;
	if ( m_pDriveType[i] == DRIVE_CDROM ) {
		bCdrom = true;
		m_cMediaDrive = m_pDriveList[i].GetAt(0);
	}

	for( j = 0; j < MAXDRIVE; j++ ) {
		if ( m_pDriveList[i] == _T("") || m_pFmParam->m_pDriveParam->m_pCurrentPath[j] == _T("") ) continue;
		if ( j < 26 ) {
			if ( m_pDriveList[i].GetAt(0) == m_pFmParam->m_pDriveParam->m_pCurrentPath[j].GetAt(0) ) {
				if ( m_pDriveType[i] == DRIVE_REMOTE ) {
					r2 = true;
					m_nCloseNo = j;
				}
				break;
			}
		} else {
			if ( m_pDriveList[i] == m_pFmParam->m_pDriveParam->m_pCurrentPath[j] ) {
				r = true;
				m_nCloseNo = j;
				break;
			}
		}
	}

	CMenu pRmenu;
	pRmenu.CreatePopupMenu();

	if ( r ) {
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_SHIFT_KEY_C ,_T("̃^u(&C)"));
	}

	if ( r2 ) {
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_KEY_C2 ,_T("hCu̐ؒf(&D)"));
	}

	pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_KEY_H ,_T("JgtH_̕ύX(&H)"));
	pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_SHIFT_KEY_Z, _T("hCu̍XV(&Z)"));
	pRmenu.AppendMenu(MF_STRING | MF_ENABLED, ID_SHIFT_KEY_P, _T("hCũvpeB(&P)"));

	if ( bRemovable || bCdrom) {
		pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_REMOVE_MEDIA ,_T("fBA̎o(&M)"));
		if ( !bCdrom ) {
			pRmenu.AppendMenu(MF_STRING|MF_ENABLED,ID_REMOVE_DRIVE ,_T("n[hEFÄSȎO(&R)"));
		}
	}

	ClientToScreen(&point);
	pRmenu.TrackPopupMenu(
		TPM_LEFTALIGN  |	//NbNXWj[̍ӂɂ
		TPM_RIGHTBUTTON,	//ENbNŃj[I\Ƃ
		point.x,point.y,	//j[̕\ʒu
		this            	//̃j[LEBhE
	);
	pRmenu.DestroyMenu();

	m_pFileView->SetFindNotify();

	CView::OnRButtonDown(nFlags, point);
}

void CDriveTabWnd::OnShiftKeyC(void)
{
	if ( m_nCloseNo == -1 ) return;
	m_pFmParam->m_pDriveParam->m_pExist[m_nCloseNo] = FALSE;

	int i = 0;
	for( i = m_nCloseNo; i > 0; i-- ) {
		if ( m_pFmParam->m_pDriveParam->m_pExist[i] ) {
			break;
		}
	}

	bool bch = false;
	if ( m_pFmParam->m_CurrentDriveNo == m_nCloseNo ) {
		bch = true;
		m_pFmParam->m_CurrentDriveNo = i;
	}
	m_MaxTab = CreateDriveList();

	if ( bch ) {
		m_pFmParam->ClearMark();
		m_pFileView->ChangeDirectory(m_pFmParam->m_CurrentDriveNo);
	}
	Invalidate();
}

void CDriveTabWnd::OnShiftKeyC2(void)
{
	if ( m_nCloseNo == -1 ) return;

	CString sdrive;
	sdrive = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_nCloseNo].Left(2);

	// ؒf
	DWORD ret = WNetCancelConnection2( sdrive, CONNECT_UPDATE_PROFILE, TRUE );
	CreateDriveList();

	int dno = sdrive[0] - 'A';
	m_pFmParam->m_pDriveParam->SetDriveParam(dno, -1);

	if ( m_pFmParam->m_CurrentDriveNo == m_nCloseNo ) {
		int ci = m_pFmParam->m_CurrentDriveNo - 1;
		for ( int i = ci; i > 0; i-- ) {
			if ( m_pFmParam->m_pDriveParam->m_pExist[i] ) {
				m_pFmParam->m_CurrentDriveNo = i;
				break;
			}
		}
	}

	m_MaxTab = CreateDriveList();

	m_pFileView->OnMenuShiftKeyZ();

}

void CDriveTabWnd::OnKeyH(void)
{
	m_pFileView->OnMenuKeyH();
}

void CDriveTabWnd::OnShiftKeyZ(void)
{
	m_pFileView->OnMenuShiftKeyZ();
}

void CDriveTabWnd::OnRemoveMedia(void)
{
//	if (m_cMediaDrive == _T('')) return;
	if (m_cMediaDrive == 0) return;

	m_pFmParam->EjectVolume(m_cMediaDrive);
	MessageBox(m_pFmParam->m_sDeviceError);

	m_MaxTab = CreateDriveList();
	m_pFileView->OnMenuShiftKeyZ();

}

void CDriveTabWnd::OnRemoveDrive(void)
{
//	if (m_cMediaDrive == _T('')) return;
	if (m_cMediaDrive == 0) return;


	bool r = m_pFmParam->RemoveUSB(m_cMediaDrive);

	CString s;
	if ( r ) {
		s.Format(_T("hCu %c: ܂ރn[hEFA͈SɎO܂B"), m_cMediaDrive);
		MessageBox(s);
	} else {
		s.Format(_T("hCu %c: ܂ރn[hEFA̎OɎs܂B"), m_cMediaDrive);
		MessageBox(s);
	}

	m_MaxTab = CreateDriveList();
	m_pFileView->OnMenuShiftKeyZ();

}

void CDriveTabWnd::OnShiftKeyP(void)
{

	CString tmp = _T("properties");
	
	CString sdrive = m_pDriveList[m_nClickDriveNo];


	SHELLEXECUTEINFO sei;

	sei.cbSize = sizeof(sei);
	sei.fMask = SEE_MASK_NOCLOSEPROCESS | SEE_MASK_INVOKEIDLIST | SEE_MASK_FLAG_NO_UI;
	sei.lpVerb = tmp;
	sei.hwnd = this->m_hWnd;
	sei.lpParameters = NULL;
	sei.lpDirectory = NULL;
	sei.lpIDList = NULL;
	sei.lpFile = sdrive;

	ShellExecuteEx(&sei);

}
