#include "StdAfx.h"
#include "DriveParam.h"
#include "FmParam.h"
#include "windows.h"


CDriveParam::CDriveParam(void)
{
	m_pType = new int[MAXDRIVE];
	m_pExist = new bool[MAXDRIVE];
	m_pCurrentPath = new CString[MAXDRIVE];
	m_pUncRootPath = new CString[MAXDRIVE];
}

CDriveParam::~CDriveParam(void)
{
	delete []m_pType;
	delete []m_pExist;
	delete []m_pCurrentPath;
	delete []m_pUncRootPath;
}

int CDriveParam::GetDriveParam(bool clear)
{
	int i;
	CString sf;
	sf = "%c:\\";

	for(i = 0; i <MAXDRIVE; i++) {
		CString srDrive;
		srDrive.Format(sf, ('A' + i));


		if ( i > 25 ) {
			if ( clear ) {
				m_pType[i] = NULL;
				m_pExist[i] = FALSE;
				m_pUncRootPath[i] = _T("");
			} else {
				if ( !m_pExist[i] ) {
					m_pType[i] = NULL;
					m_pCurrentPath[i] = _T("");
					m_pUncRootPath[i] = _T("");
				}
			}
		} else {
			if ( clear ) m_pCurrentPath[i] = srDrive;
			m_pExist[i] = TRUE;
			m_pType[i] = ::GetDriveType(srDrive);

			switch(m_pType[i]) {
				case DRIVE_REMOVABLE:
				break;

				case DRIVE_FIXED:
				break;

				case DRIVE_REMOTE:
				break;

				case DRIVE_CDROM:
				break;

				case DRIVE_RAMDISK:
				break;

				default:
					m_pCurrentPath[i] = srDrive;
					m_pType[i] = NULL;
					m_pExist[i] = FALSE;

			}
		}


	}
	return 0;
}

void CDriveParam::SetDriveParam(int dno, int dtype)
{
	if ( dtype != -1 ) {
		m_pExist[dno] = TRUE;
		m_pType[dno] = dtype;
	} else {
		m_pExist[dno] = FALSE;
		m_pType[dno] = NULL;
	}
}
