// CopyFileDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "CopyFileDialog.h"
#include "FmParam.h"
#include "SelectJumpFolderDialog.h"
#include "TreeFrameWindow.h"
#include "JumpFrame.h"


// CCopyFileDialog _CAO

IMPLEMENT_DYNAMIC(CCopyFileDialog, CDialog)

CCopyFileDialog::CCopyFileDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CCopyFileDialog::IDD, pParent)
	, m_DestPath(_T(""))
	, m_Filename(_T(""))
	, m_DpathStatic(_T(""))
{

}

CCopyFileDialog::~CCopyFileDialog()
{
//	CoUninitialize();
}

void CCopyFileDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBString(pDX, IDC_DEST_PATH, m_DestPath);
	DDX_Text(pDX, IDC_FILENAME, m_Filename);
	DDX_Text(pDX, IDC_DPATH_STATIC, m_DpathStatic);
	DDX_Control(pDX, IDC_DEST_PATH, m_pDestPathCombo);
	DDX_Control(pDX, IDC_AFM_LIST, m_ctrlAFMList);
}


BEGIN_MESSAGE_MAP(CCopyFileDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CCopyFileDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BROWSE_BUTTON, &CCopyFileDialog::OnBnClickedBrowseButton)
	ON_BN_CLICKED(IDC_JUMPFOLDER_BUTTON, &CCopyFileDialog::OnBnClickedJumpfolderButton)

	ON_COMMAND(ID_TREE_MESSAGE, &CCopyFileDialog::OnTreeMessage)
	ON_COMMAND(ID_JUMP_MESSAGE, &CCopyFileDialog::OnJumpMessage)
	ON_BN_CLICKED(IDC_BROWSE_WIN, &CCopyFileDialog::OnBnClickedBrowseWin)
	ON_CBN_SELCHANGE(IDC_DEST_PATH, &CCopyFileDialog::OnCbnSelchangeDestPath)
	ON_WM_SETFOCUS()
	ON_LBN_SELCHANGE(IDC_AFM_LIST, &CCopyFileDialog::OnLbnSelchangeAfmList)
	ON_LBN_SETFOCUS(IDC_AFM_LIST, &CCopyFileDialog::OnLbnSetfocusAfmList)
	ON_CBN_EDITCHANGE(IDC_DEST_PATH, &CCopyFileDialog::OnCbnEditchangeDestPath)
END_MESSAGE_MAP()


// CCopyFileDialog bZ[W nh


BOOL CCopyFileDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	CString s, s2;
	s = _T("t@C");
	s2 = m_DpathStatic.Left(2);
	s += s2;
	SetWindowText(s);

	CString fext;
	fext = _T(".hid");

	if (m_pFmParam->m_bSettingsUseCurrentHistory) {
		m_pDestPathCombo.ResetContent();
		int nMax = m_pFmParam->m_nHistMaxFolderData;

		if (nMax > -1) {
			int n = nMax;
			int cn = 100;

			while (cn > 0) {
				n--;
				cn--;
				if (n < 0) {
					if (m_pFmParam->m_bFdFull) {
						n = MAX_FOLDER_DATA - 1;
					}
					else {
						break;
					}
				}
				m_pDestPathCombo.AddString(m_pFmParam->m_pHistFolderData[n].sDirName);
			}
			
		}

	}
	else {
		m_pFmParam->ReadHistoryFile(fext, &m_pDestPathCombo);
	}


	for ( int i = 0; i < MAXANNSFMNO; i++ ) {
		m_ctrlAFMList.DeleteString(i);
	}

	int end = m_NumannsFM;
	int is = 0;
	if ( end > 1 ) is = 1;
	for ( int i = is; i < end; i++ ) {
		m_ctrlAFMList.AddString(m_sCdirannsFM[i]);
	}
	if ( end > 1 ) {
		m_ctrlAFMList.AddString(m_sCdirannsFM[0]);
	}
	m_ctrlAFMList.SetCurSel(0);

//	CoInitialize(NULL);
	CEdit *pEdit = (CEdit *)m_pDestPathCombo.GetWindow(GW_CHILD);

	if (m_pFmParam->m_bSettingsAutocomplete) {
		::SHAutoComplete(pEdit->m_hWnd, SHACF_FILESYSTEM);
	}

	if (m_pFmParam->m_bSettingsSetDialogFont) {
		m_font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_pDestPathCombo.SetFont(&m_font);

	}



	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CCopyFileDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	CString s;
	m_pDestPathCombo.GetWindowTextW(m_DestPath);

	if ( m_DestPath == _T("") ) {
		OnBnClickedBrowseButton();
		return;
	}

	OnOK();
}

void CCopyFileDialog::OnBnClickedBrowseButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	if ( m_pFmParam->m_bEnableTreeWindow ) {
		m_pTreeFrameWindow->SetFocus();
		return;
	}

	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();


}

void CCopyFileDialog::OnBnClickedJumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_pJumpFrameWindow = new CJumpFrame;
	m_pJumpFrameWindow->m_pFmParam = m_pFmParam;
	m_pJumpFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrameWindow->LoadFrame(IDR_JUMPVIEWFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrameWindow->ShowWindow(SW_SHOW);
	m_pJumpFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pJumpFrameWindow->UpdateWindow();

/*
	CSelectJumpFolderDialog dlg;
	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r = IDOK ) {
		m_DestPath = dlg.m_sSelectedFolder;
		m_pDestPathCombo.SetWindowTextW(m_DestPath);
		m_pDestPathCombo.SetFocus();
	}
*/

}

void CCopyFileDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

	SetFocus();
	m_DestPath = path;
	m_pDestPathCombo.SetWindowTextW(path);
	m_pDestPathCombo.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CCopyFileDialog::OnJumpMessage()
{
	CString path = m_pFmParam->m_sSelectedJumpPath;

	SetFocus();
	m_DestPath = path;
	m_pDestPathCombo.SetWindowTextW(path);
	m_pDestPathCombo.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CCopyFileDialog::OnBnClickedBrowseWin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	CString sDestPath;
	m_pDestPathCombo.GetWindowTextW(sDestPath);

	CString cpath;

	if ( sDestPath == _T("") ) {

		cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
		cpath = cpath.Left(cpath.GetLength() - 1);
	} else {
		if ( sDestPath == _T("\\") ) {
			cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			sDestPath = cpath.Left(3);
		}
		cpath = sDestPath;
	}

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS;	//\tOłB
	stBInfo.lpfn = &BrowseCallbackProc;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = (LPARAM)((LPCTSTR)cpath);	//vV[Wɑp[^[łB
//	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
//	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_DestPath = chPutFolder;
			if ( m_DestPath.GetAt(m_DestPath.GetLength() - 1) != '\\' )
				m_DestPath += STR_YEN;
			m_pDestPathCombo.SetWindowTextW(m_DestPath);
//			m_pDestPathCombo.SetWindowTextW(chPutFolder);
			m_pDestPathCombo.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}
}

void CCopyFileDialog::OnCbnSelchangeDestPath()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

}

int CALLBACK CCopyFileDialog::BrowseCallbackProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg==BFFM_INITIALIZED){
		::SendMessage(hwnd,BFFM_SETSELECTION,(WPARAM)TRUE,lpData);
    }
    return 0;
}


void CCopyFileDialog::OnLbnSelchangeAfmList()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	CString s;
	int n = m_ctrlAFMList.GetCurSel();
	m_ctrlAFMList.GetText(n, s);
	m_pDestPathCombo.SetWindowTextW(s);

}

void CCopyFileDialog::OnLbnSetfocusAfmList()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CString s;
	int n = m_ctrlAFMList.GetCurSel();
	m_ctrlAFMList.GetText(n, s);
	m_pDestPathCombo.SetWindowTextW(s);
}

void CCopyFileDialog::OnCbnEditchangeDestPath()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CString s;
	m_pDestPathCombo.GetWindowTextW(s);

	if ( s.GetAt(0) == _T('/') ) {
		OnLbnSelchangeAfmList();
	}

}
