#include "stdafx.h"
#include "ContextMenu.h"
// #include "CmDataObject.h"



CContextMenu::CContextMenu(IContextMenu *pContextMenu, HWND hwnd)
{
	m_cRef = 1;
	m_pContextMenu = NULL;
	m_pContextMenu2 = NULL;
	m_pContextMenu3 = NULL;
	m_hwnd = hwnd;

	if (pContextMenu) {
		if SUCCEEDED(pContextMenu->QueryInterface(IID_PPV_ARGS(&m_pContextMenu))) {
			pContextMenu->QueryInterface(IID_PPV_ARGS(&m_pContextMenu2));
			pContextMenu->QueryInterface(IID_PPV_ARGS(&m_pContextMenu3));
		}
	}

	g_bsInvoke = NULL;

	g_uTimerId = 0;
	g_uTimerId2 = 0;

}


CContextMenu::~CContextMenu()
{
	if (m_pContextMenu3) {
		m_pContextMenu3->Release();
	}
	if (m_pContextMenu2) {
		m_pContextMenu2->Release();
	}
	if (m_pContextMenu) {
		m_pContextMenu->Release();
	}
	g_uTimerId = SetTimer(m_hwnd, TCMT_CLOSE, 1000, NULL);
}



STDMETHODIMP CContextMenu::QueryInterface(REFIID riid, void **ppvObject)
{
	*ppvObject = NULL;

	if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IContextMenu)) {
		*ppvObject = (IContextMenu *)(this);
	}
	else if (IsEqualIID(riid, IID_IContextMenu2)) {
		return m_pContextMenu->QueryInterface(IID_IContextMenu2, ppvObject);
	}
	else if (IsEqualIID(riid, IID_IContextMenu3)) {
		return m_pContextMenu->QueryInterface(IID_IContextMenu3, ppvObject);
	}
	else {
		return E_NOINTERFACE;
	}
	AddRef();

	return S_OK;
}

STDMETHODIMP_(ULONG) CContextMenu::AddRef()
{
	return InterlockedIncrement(&m_cRef);
}

STDMETHODIMP_(ULONG) CContextMenu::Release()
{
	if (InterlockedDecrement(&m_cRef) == 0) {
		delete this;
		return 0;
	}

	return m_cRef;
}

STDMETHODIMP CContextMenu::QueryContextMenu(HMENU hmenu, UINT indexMenu, UINT idCmdFirst, UINT idCmdLast, UINT uFlags)
{
	return m_pContextMenu->QueryContextMenu(hmenu, indexMenu, idCmdFirst, idCmdLast, uFlags);
}

STDMETHODIMP CContextMenu::GetCommandString(UINT_PTR idCmd, UINT uFlags, UINT *pwReserved, LPSTR pszName, UINT cchMax)
{
	return m_pContextMenu->GetCommandString(idCmd, uFlags, pwReserved, pszName, cchMax);
}

STDMETHODIMP CContextMenu::InvokeCommand(LPCMINVOKECOMMANDINFO pici)
{
	return m_pContextMenu->InvokeCommand(pici);
}


int CContextMenu::TCMFindVerb(HMENU hMenu)
{
	MENUITEMINFO mii;
	::ZeroMemory(&mii, sizeof(MENUITEMINFO));
	mii.cbSize = sizeof(MENUITEMINFO);

	int nCount = GetMenuItemCount(hMenu);
	for (int i = 0; i < nCount; i++) {
		mii.dwTypeData = NULL;
		mii.fMask = MIIM_STRING | MIIM_SUBMENU;
		GetMenuItemInfo(hMenu, i, TRUE, &mii);
		if (mii.hSubMenu) {
			TCMFindVerb(mii.hSubMenu);
			DestroyMenu(mii.hSubMenu);
		}
		else if (mii.cch) {
			LPWSTR dwTypeData = new WCHAR[++mii.cch + 1];
			mii.dwTypeData = dwTypeData;
			mii.fMask = MIIM_STRING | MIIM_ID;
			GetMenuItemInfo(hMenu, i, TRUE, &mii);
			dwTypeData[mii.cch] = NULL;
			BOOL bMatch = PathMatchSpec(dwTypeData, g_bsInvoke);
			delete[] dwTypeData;
			if (bMatch) {
				return mii.wID;
			}
		}
	}
	return 0;
}
