// ConnectNetworkDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "ConnectNetworkDialog.h"
#include "FmParam.h"
#include "FileView.h"
#include "DriveTabWnd.h"
#include "SelectJumpFolderDialog.h"
#include "TreeFrameWindow.h"
#include "JumpFrame.h"

#include <Shlobj.h>

// CConnectNetworkDialog _CAO

IMPLEMENT_DYNAMIC(CConnectNetworkDialog, CDialog)

CConnectNetworkDialog::CConnectNetworkDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CConnectNetworkDialog::IDD, pParent)
	, m_sNetDriveCombo(_T(""))
	, m_sUser(_T(""))
	, m_sPassword(_T(""))
	, m_bReconnect(false)
	, m_nDrive(0)
	, m_sDrive(_T(""))
	, m_nNetDrive(0)
{

}

CConnectNetworkDialog::~CConnectNetworkDialog()
{
}

void CConnectNetworkDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DRIVE_COMBO, m_ctrlDriveCombo);
	DDX_Control(pDX, IDC_NET_DRIVE_COMBO, m_ctrlNetDriveCombo);
	DDX_Control(pDX, IDC_USER_EDIT, m_ctrlUser);
	DDX_Control(pDX, IDC_PASSWORD_EDIT, m_ctrlPassword);
	DDX_Control(pDX, IDC_CHECK1, m_ctrlReconnect);
}


BEGIN_MESSAGE_MAP(CConnectNetworkDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CConnectNetworkDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDDISCONECT, &CConnectNetworkDialog::OnBnClickedDisconect)
	ON_BN_CLICKED(IDBROWSE, &CConnectNetworkDialog::OnBnClickedBrowse)
	ON_BN_CLICKED(IDCANCEL, &CConnectNetworkDialog::OnBnClickedCancel)
	ON_BN_CLICKED(IDC_JUMPFOLDER_BUTTON, &CConnectNetworkDialog::OnBnClickedJumpfolderButton)

	ON_COMMAND(ID_TREE_MESSAGE, &CConnectNetworkDialog::OnTreeMessage)
	ON_COMMAND(ID_JUMP_MESSAGE, &CConnectNetworkDialog::OnJumpMessage)
	ON_CBN_SELCHANGE(IDC_NET_DRIVE_COMBO, &CConnectNetworkDialog::OnCbnSelchangeNetDriveCombo)
	ON_CBN_SELCHANGE(IDC_DRIVE_COMBO, &CConnectNetworkDialog::OnCbnSelchangeDriveCombo)
END_MESSAGE_MAP()


// CConnectNetworkDialog bZ[W nh

void CConnectNetworkDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_nDrive = m_ctrlDriveCombo.GetCurSel();
	m_ctrlDriveCombo.GetLBText(m_nDrive, m_sDrive);
	m_ctrlNetDriveCombo.GetWindowTextW(m_sNetDriveCombo);
	m_ctrlUser.GetWindowTextW(m_sUser);
	m_ctrlPassword.GetWindowTextW(m_sPassword);

	if ( m_sNetDriveCombo == _T("") ) {
		OnBnClickedBrowse();
		return;
	}

	int len = m_sNetDriveCombo.GetLength() - 1;
	if ( m_sNetDriveCombo.GetAt(len) == _T('\\') ) {
		m_sNetDriveCombo = m_sNetDriveCombo.Left(len);
	}

	CString sdrive = m_sDrive.Left(2);

	DWORD ret = NO_ERROR;

	if ( m_sDrive.GetLength() > 4 ) {
		CString s;
		s.Format(_T("[ %s ]\n͊Ɋ蓖ĂĂ܂B\nύXĂ낵łH"), m_sDrive);
		int nm = MessageBox(s, _T("ڑmF"), MB_OKCANCEL);
		if ( nm != IDOK ) return;
		OnBnClickedDisconect();
	}


	if ( m_sUser == _T("") ) {
		// ڑ
		ret = WNetAddConnection( m_sNetDriveCombo, NULL, sdrive );
	} else {

		NETRESOURCE nr;
		
		nr.dwScope = RESOURCE_GLOBALNET;
		nr.dwType = RESOURCETYPE_DISK;
		nr.dwDisplayType= RESOURCEDISPLAYTYPE_SERVER;
		nr.dwUsage = RESOURCEUSAGE_CONNECTABLE;
		nr.lpLocalName = sdrive.GetBuffer(); //ڑhCu
		nr.lpRemoteName = m_sNetDriveCombo.GetBuffer(); //pX
		nr.lpComment = NULL;
		nr.lpProvider = NULL;

		UINT r = IsDlgButtonChecked( IDC_CHECK1 );
		DWORD df = ( r ) ? CONNECT_UPDATE_PROFILE : 0;
		// ڑ
		ret = WNetAddConnection2(&nr, m_sPassword, m_sUser, df);
	}
	if ( ret != NO_ERROR ) {
		CString s;
		s.Format(_T("[ %s ]\nڑɎs܂B"), sdrive);
		MessageBox(s, _T("ڑG["));
	} else {

		int dno = sdrive[0] - 'A';
		m_pFileView->m_pFmParam->m_pDriveParam->SetDriveParam(dno, DRIVE_REMOTE);
		m_pFileView->m_pDriveTabWnd->m_MaxTab = m_pFileView->m_pDriveTabWnd->CreateDriveList();
		m_pFileView->m_pDriveTabWnd->Invalidate();

		CreateDriveList();
		m_ctrlDriveCombo.SetCurSel(m_nDrive);

		CString s;
		m_ctrlNetDriveCombo.GetWindowTextW(s);

		CString fext;
		fext = _T(".hid");
		m_pFmParam->WriteHistoryFile(fext, s);
		m_pFmParam->ReadHistoryFile(fext, &m_ctrlNetDriveCombo);
	}


//	OnOK();
}

void CConnectNetworkDialog::OnBnClickedDisconect()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_nDrive = m_ctrlDriveCombo.GetCurSel();
	m_ctrlDriveCombo.GetLBText(m_nDrive, m_sDrive);
	CString sdrive = m_sDrive.Left(2);

	// ؒf
	DWORD ret = WNetCancelConnection2( sdrive, CONNECT_UPDATE_PROFILE, TRUE );
	CreateDriveList();
	m_ctrlDriveCombo.SetCurSel(m_nDrive);

	int dno = sdrive[0] - 'A';
	m_pFileView->m_pFmParam->m_pDriveParam->SetDriveParam(dno, -1);
	m_pFileView->m_pDriveTabWnd->m_MaxTab = m_pFileView->m_pDriveTabWnd->CreateDriveList();
	m_pFileView->m_pDriveTabWnd->Invalidate();
}

void CConnectNetworkDialog::OnBnClickedBrowse()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
/*
	m_pTreeFrameWindow = new CTreeFrameWindow;
	m_pTreeFrameWindow->m_pFmParam = m_pFmParam;
	m_pTreeFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pTreeFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pTreeFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pTreeFrameWindow->ShowWindow(SW_SHOW);
	m_pTreeFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pTreeFrameWindow->UpdateWindow();
*/

	BOOL		bRes;
	wchar_t		chPutFolder[MAX_PATH];
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO	stBInfo;
//	CString		cRetStr;
	CString sCaption = _T("");

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = this->m_hWnd;	//\_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = chPutFolder;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = sCaption;	//̕
	stBInfo.ulFlags = 0;	//\tOłB
	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );

	//@pidlRetFolderɂ͂̃tH_\ACehcXgւ̃|C^
	//@Ă܂BchPutFolderɂ͑IꂽtH_itpXj
	//@ĂȂ̂ŁÃ|C^𗘗p܂B

	if( pidlRetFolder != NULL )
	{
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, chPutFolder );
		if( bRes != FALSE ) {
			m_sNetDriveCombo = chPutFolder;
			m_ctrlNetDriveCombo.SetWindowTextW(chPutFolder);
			m_ctrlNetDriveCombo.SetFocus();
		}

		::CoTaskMemFree( pidlRetFolder );
	}


}

void CConnectNetworkDialog::OnBnClickedCancel()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	OnCancel();
}

int CConnectNetworkDialog::GetDriveParam(void)
{
	int i, dtype, j;
	int nMax = 26;
	CString sd, sf, sUnc;
	sf = "%c:\\ ";
	DWORD len = 1000;
	wchar_t* wcbuf;
	wcbuf = new wchar_t[len];
	j= 0;

	for(i = 0; i < nMax; i++) {
		sd.Format(sf, ('A' + i));

		dtype = ::GetDriveType(sd);
		sUnc = _T("");
		m_saDriveList[j] = sd;

		if ( dtype == DRIVE_REMOTE) {
			DWORD ret = NO_ERROR;
			ret = WNetGetConnection(sd.Left(2), wcbuf, &len);
			if ( ret == NO_ERROR ) {
				sUnc = wcbuf;
			}
			m_saDriveList[j] += sUnc;
			j++;
		} else {
			switch(dtype) {
				case DRIVE_REMOVABLE:
				case DRIVE_FIXED:
				case DRIVE_CDROM:
				case DRIVE_RAMDISK:
				break;

				default:
					j++;

			}

		}
	}
	delete []wcbuf;
	return j;

}

BOOL CConnectNetworkDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	CreateDriveList();
	m_ctrlDriveCombo.SetCurSel(0);

	CString fext;
	fext = _T(".hid");

	m_pFmParam->ReadHistoryFile(fext, &m_ctrlNetDriveCombo);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CConnectNetworkDialog::CreateDriveList(void)
{
	INT_PTR n = 26;
	m_saDriveList.RemoveAll();
	m_saDriveList.SetSize(n);
	m_nExistDrive = GetDriveParam();

	m_ctrlDriveCombo.ResetContent();
	for ( int i = 0; i < m_nExistDrive; i++ ) {
		m_ctrlDriveCombo.AddString(m_saDriveList.GetAt(i));
	}
}

void CConnectNetworkDialog::OnBnClickedJumpfolderButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	m_pJumpFrameWindow = new CJumpFrame;
	m_pJumpFrameWindow->m_pFmParam = m_pFmParam;
	m_pJumpFrameWindow->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pJumpFrameWindow->m_pwndParent = (CWnd*)this;

	BOOL br = m_pJumpFrameWindow->LoadFrame(IDR_TREEFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, this,
		NULL);

	m_pJumpFrameWindow->ShowWindow(SW_SHOW);
	m_pJumpFrameWindow->SetWindowText(_T("annsFMTree"));
	m_pJumpFrameWindow->UpdateWindow();

/*
	CSelectJumpFolderDialog dlg;
	dlg.m_pFmParam = m_pFmParam;

	int r = dlg.DoModal();

	if ( r = IDOK ) {
		m_sNetDriveCombo = dlg.m_sSelectedFolder;
		m_ctrlNetDriveCombo.SetWindowTextW(m_sNetDriveCombo);
		m_ctrlNetDriveCombo.SetFocus();
	}
*/

}

void CConnectNetworkDialog::OnTreeMessage()
{
	CString path = m_pFmParam->m_sSelectedTreePath;

	SetFocus();
	m_sNetDriveCombo = path;
	m_ctrlNetDriveCombo.SetWindowTextW(path);
	m_ctrlNetDriveCombo.SetFocus();
	m_pTreeFrameWindow = NULL;

}

void CConnectNetworkDialog::OnJumpMessage()
{
	CString path = m_pFmParam->m_sSelectedJumpPath;

	SetFocus();
	m_sNetDriveCombo = path;
	m_ctrlNetDriveCombo.SetWindowTextW(path);
	m_ctrlNetDriveCombo.SetFocus();
	m_pJumpFrameWindow = NULL;

}

void CConnectNetworkDialog::OnCbnSelchangeNetDriveCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlNetDriveCombo.ShowDropDown();
}

void CConnectNetworkDialog::OnCbnSelchangeDriveCombo()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
//	m_ctrlDriveCombo.ShowDropDown();
}
