// ChildView.cpp : CChildView NX̎
//

#include "stdafx.h"
#include "annsFM.h"
#include "ChildView.h"
#include "MciDialog.h"
#include "FmParam.h"
#include "Langage.h"

#include "io.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#ifndef _WINVER_XP


void CChildView::CreateD2d1Resources()
{
	CreateDeviceIndependentResources();
	CreateTextFormat();
	CreateDeviceResources();
}

void CChildView::DiscardD2d1Resources()
{
	DiscardDeviceIndependentResources();
	DiscardTextFormat();
	DiscardDeviceResources();

}

HRESULT CChildView::CreateDeviceIndependentResources()
{
	HRESULT result = S_OK;

	D2D1CreateFactory(
		D2D1_FACTORY_TYPE_SINGLE_THREADED,
		&g_pD2DFactory);

	DWriteCreateFactory(
		DWRITE_FACTORY_TYPE_SHARED,
		__uuidof(g_pDWriteFactory),
		(IUnknown **)(&g_pDWriteFactory));


	return result;
}

void CChildView::DiscardDeviceIndependentResources()
{

	if (g_pDWriteFactory != NULL) {
		g_pDWriteFactory->Release();
		g_pDWriteFactory = NULL;

	}

	if (g_pD2DFactory != NULL) {
		g_pD2DFactory->Release();
		g_pD2DFactory = NULL;

	}


}

void CChildView::CreateTextFormat()
{

	if (g_pDWriteFactory == NULL) return;

	if (g_pTextFormat != NULL) return;

	CClientDC dc(AfxGetMainWnd());
	int logpix = dc.GetDeviceCaps(LOGPIXELSY);

	CString fontname = m_pFmParam->m_logfontFile.lfFaceName;
	int nPoint = -::MulDiv(m_pFmParam->m_logfontFile.lfHeight, 72, logpix);

	FLOAT fs = logpix * (FLOAT)nPoint / 72;
	int ifs = (INT)(fs + 1.99) / 2;
	FLOAT dip = (FLOAT)(ifs * 2);

	g_pDWriteFactory->CreateTextFormat(
		//		L"Verdana",
		fontname,
		NULL,
		DWRITE_FONT_WEIGHT_NORMAL,
		DWRITE_FONT_STYLE_NORMAL,
		DWRITE_FONT_STRETCH_NORMAL,
		//		50,	// tHgTCY
		dip,
		L"", //locale
		&g_pTextFormat);

	g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_LEADING);
	// g_pTextFormat->SetTextAlignment(DWRITE_TEXT_ALIGNMENT_CENTER);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_NEAR);
	//	g_pTextFormat->SetParagraphAlignment(DWRITE_PARAGRAPH_ALIGNMENT_CENTER);

	m_FontHeight = (int)(g_pTextFormat->GetFontSize());

}

void CChildView::DiscardTextFormat()
{
	if (g_pTextFormat == NULL) return;

	g_pTextFormat->Release();
	g_pTextFormat = NULL;

}


HRESULT CChildView::CreateDeviceResources(void)
{
	HRESULT hr = S_OK;

	if (g_pRenderTarget != NULL) {
		return hr;
	}

	RECT rc;
	GetClientRect(&rc);

	D2D1_SIZE_U size = D2D1::SizeU(
		rc.right - rc.left,
		rc.bottom - rc.top
		);

	// Create a Direct2D render target.
	g_pD2DFactory->CreateHwndRenderTarget(
		D2D1::RenderTargetProperties(),
		D2D1::HwndRenderTargetProperties(m_hWnd, size),
		&g_pRenderTarget
		);

	COLORREF colBack = m_pFmParam->m_colBack;

	COLORREF colListNormal = m_pFmParam->m_colListNormal;	// ʏt@C\F
	COLORREF colListSystem = m_pFmParam->m_colListSystem;	// VXet@C\F
	COLORREF colListReadonly = m_pFmParam->m_colListReadonly;	// [hI[t@C\F
	COLORREF colListHide = m_pFmParam->m_colListHide;		// Bt@C\F
	COLORREF colListDir = m_pFmParam->m_colListDir;		// tH_\F

	COLORREF colFrame = m_pFmParam->m_colFrame;


	// Create a back brush.
	BYTE r, g, b;
	r = colBack & 0xff;
	g = (colBack >> 8) & 0xff;
	b = (colBack >> 16) & 0xff;

	UINT32 rgb;
	rgb = b + (g << 8) + (r << 16);

	g_pRenderTarget->CreateSolidColorBrush(
		D2D1::ColorF(rgb),
		&g_pBackBrush
		);

	m_D2DcolBack = rgb;



	return hr;
}

void CChildView::DiscardDeviceResources()
{
	if (g_pRenderTarget != NULL) {
		g_pRenderTarget->Release();
		g_pRenderTarget = NULL;

	}

	if (g_pBackBrush != NULL) {
		g_pBackBrush->Release();
		g_pBackBrush = NULL;
	}

}

void CChildView::d2d1DrawTextA(int x, int y, CStringA strA, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = CA2W(strA);

	int len = sText.GetLength();
	int glen = strA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		//		D2D1::RectF(fX, fY, (FLOAT)rc.right, fY + lh),
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

}

void CChildView::d2d1DrawTextW(int x, int y, CString strW, ID2D1SolidColorBrush *brush, ID2D1SolidColorBrush *backbrush)
{
	CString sText;
	sText = strW;

	CStringA sA;
	sA = CW2A(strW);

	int len = sText.GetLength();
	int glen = sA.GetLength();
	FLOAT fX = (FLOAT)x;
	FLOAT fY = (FLOAT)y;
	//	FLOAT lh = FLOAT(m_FontY + m_pFmParam->m_nViewLineSpace);
	FLOAT lh = FLOAT(m_FontHeight);

	CRect rc;
	GetClientRect(&rc);

	g_pRenderTarget->FillRectangle(D2D1::RectF(fX, fY, fX + (glen * m_FontWidth), fY + lh), backbrush);

	g_pRenderTarget->DrawText(
		sText,
		len,
		g_pTextFormat,
		D2D1::RectF(fX, fY, fX + FLOAT(glen * m_FontWidth), fY + lh),
		brush
		);

}
#endif



// CChildView

CChildView::CChildView()
{
/*
	m_pFileView = new CFileView;
	m_pInfoWnd = new CInfoWnd;
	m_pDriveTabWnd = new CDriveTabWnd;
	m_pMciDialog = new CMciDialog(this);

	m_nScrollBarHeight = SCROLLBARHEIGHT;
	m_pScrollBar = new CScrollBar;

	m_psbDriveTab = new CScrollBar;

	CoInitialize(NULL);
*/

#ifndef _WINVER_XP

	g_pDWriteFactory = NULL;
	g_pD2DFactory = NULL;
	g_pTextFormat = NULL;

	g_pRenderTarget = NULL;
	g_pBackBrush = NULL;

#endif

}

CChildView::~CChildView()
{
//	delete m_pFileView;
	delete m_pInfoWnd;
//	delete m_pDriveTabWnd;
	delete m_pMciDialog;

	delete m_pScrollBar;
	delete m_psbDriveTab;


#ifndef _WINVER_XP
		DiscardD2d1Resources();
#endif

		CoUninitialize();
}


BEGIN_MESSAGE_MAP(CChildView, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_MOVE()
	ON_WM_HSCROLL()
END_MESSAGE_MAP()



// CChildView bZ[W nh

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), reinterpret_cast<HBRUSH>(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // `̃foCX ReLXg
	
	// TODO: ɃbZ[W nh R[hǉ܂B
	
	// bZ[W̕`̂߂ CWnd::OnPaint() ĂяoȂłB

// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {
#ifndef _WINVER_XP
		m_pFileView->OnDrawDirectWrite();
#endif
		m_pInfoWnd->Invalidate();
	}

// #endif

	m_pDriveTabWnd->Invalidate();


}


int CChildView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB


	m_pFileView = new CFileView;
	m_pInfoWnd = new CInfoWnd;
	m_pDriveTabWnd = new CDriveTabWnd;
	m_pMciDialog = new CMciDialog(this);

	m_psbDriveTab = new CScrollBar;

	m_pFileView->m_pChildView = this;

	m_pFileView->m_pFmParam = m_pFmParam;
	m_pInfoWnd->m_pFmParam = m_pFmParam;
	m_pInfoWnd->m_pFileView = m_pFileView;
	m_pDriveTabWnd->m_pFmParam = m_pFmParam;


	m_nScrollBarHeight = SCROLLBARHEIGHT;
	m_pScrollBar = new CScrollBar;



	m_pScrollBar->Create(SBS_HORZ | WS_CHILD, CRect(0, 0, 0, 0), this, 100);
	m_psbDriveTab->Create(SBS_HORZ | WS_CHILD, CRect(0, 0, 0, 0), this, 101);

	CoInitialize(NULL);

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP

		CreateDeviceIndependentResources();

#endif
	}

	if (!m_pInfoWnd->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
		CRect(0, 0, 0, 0), this, 1, NULL))
	{
		TRACE0("CtH[V EBhE쐬ł܂łB\n");
		return -1;
	}

	if (!m_pFileView->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
		CRect(0, 0, 0, 0), this, 2, NULL))
	{
		TRACE0("t@CXg EBhE쐬ł܂łB\n");
		return -1;
	}

	if (!m_pDriveTabWnd->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
		CRect(0, 0, 0, 0), this, 3, NULL))
	{
		TRACE0("hCu^u EBhE쐬ł܂łB\n");
		return -1;
	}


	m_pFmParam->m_pDriveParam->GetDriveParam(true);


	int i;
	CString s, initCdir, cd;

	initCdir = m_pFmParam->GetEnvStr(m_pFmParam->m_sInitCurrentDir);

	if ( m_pFmParam->m_bBootLastPath ) {
		CWinApp *pApp = AfxGetApp();
		CString sSection, sEntry, tmp;

		sSection = INISECTION_SETTINGS;
		sEntry = INIENTRY_SETTINGS_LAST_FOLDER;
		initCdir = pApp->GetProfileString(sSection, sEntry, _T(""));
	}

	CWinApp *pApp = AfxGetApp();
	CString sCmdLine = pApp->m_lpCmdLine;
	if (sCmdLine != _T("")) {
		CString tmp = pApp->m_lpCmdLine;
		
		initCdir = _T("");
		initCdir += tmp.Left(1);
		initCdir.MakeUpper();

		initCdir += tmp.Right(tmp.GetLength() - 1);
	}

	if (initCdir == _T("")) initCdir = m_pFmParam->m_sSystemDrive;
	else {
		CFileStatus rStatus;
		if ( !(CFile::GetStatus(initCdir, rStatus)) ) { // tH_݂Ȃ
			initCdir = m_pFmParam->m_sSystemDrive;
		}
		else {
			if ((rStatus.m_attribute & 0x10) == 0) {
				initCdir = m_pFmParam->m_sSystemDrive;
			}
		}
	}

	CString cdir = _T("");
	if (initCdir.Find(_T("\\")) == 0) {
		cdir = initCdir;
		initCdir = m_pFmParam->m_sSystemDrive;

	}

	if ( initCdir.GetAt(initCdir.GetLength() - 1) != CHAR_YEN ) initCdir += STR_YEN;
	cd = initCdir.Left(3);
	cd.MakeUpper();

	for (i = 0; i < 26 ; i++) {
		s = m_pFmParam->m_pDriveParam->m_pCurrentPath[i].Left(3);
		if ( s == cd ) {
			m_pFmParam->m_pDriveParam->m_pCurrentPath[i] = initCdir;
			break;
		}
	}
	if ( i > 25 ) i = initCdir[0] - 0x30;
	m_pFmParam->m_CurrentDriveNo = i;
	m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();

	s = m_pFmParam->m_pDriveParam->m_pCurrentPath[i];
	SetCurrentDirectory(s);

	m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(s);
//	m_pFmParam->SortFileList(m_pFmParam->m_InitSortMode);
//	m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_pFileView->m_CurrentFileNo].name);


	m_pFileView->m_pDriveTabWnd = m_pDriveTabWnd;
	m_pDriveTabWnd->m_pFileView = m_pFileView;
	m_pFileView->m_pInfoWnd = m_pInfoWnd;



	m_pMciDialog->Create(IDD_MCI_DIALOG, this);
	m_pMciDialog->ShowWindow(SW_HIDE);

	m_pFileView->m_pMciDialog = m_pMciDialog;

	if ( m_pFmParam->m_bInitReadKeyMap ) m_pFmParam->ReadKeyMap();

	int err = m_pFmParam->ReadExtentionMapFile();
	m_pFileView->m_nExtMapFileErrorNo = err;

	if ( err != 0 ) {
		CString s, s2;
		s2 = _T("");
		switch(err) {

			case 1 :
				s2 = _T("/̈ʒusK؂łB邢́AvŐLq܂B");
				break;

			case 2 :
				s2 = _T("gqAŋLqĂ܂B");
				break;

			case 3 :
				s2 = _T("gqLqĂ܂B");
				break;
		}
		s.Format(_T("gq̑Ήt@C̓ǂݍ݂Ɏs܂B\nLqɌ肪܂B\nLine %d\n%s"), 
				m_pFmParam->m_nExtMapErrLineNo + 1, s2);
		MessageBox(s);
		m_pFmParam->m_nMaxExtMapNum = 0;
	}


	if (cdir != _T("")) {
		CString path;
		m_pFmParam->MakeFullPath(cdir);
		path = m_pFmParam->m_FullPath;
		if (path.GetAt(path.GetLength() - 1) != CHAR_YEN) path += STR_YEN;

		CFileStatus rStatus;
		if (!(CFile::GetStatus(path, rStatus)) || ((rStatus.m_attribute & _A_SUBDIR) == 0)) {	// tH_݂Ȃ܂̓tH_łȂ
			return 0;
		}
		else {

			CString parentPath;
			m_pFileView->GetParentDir(path, parentPath);

			int drive;
			CString sd;
			sd = path.Left(2);
			sd.MakeUpper();

//			m_pFmParam->SetFolderData(m_pFmParam->m_pw64FindData[m_pFileView->m_CurrentFileNo].name);

			if (sd.GetAt(0) <= _T('Z')) {
				drive = sd.GetAt(0) - 0x41;
				m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
			}
			else {
				drive = -1;
				for (int i = 26; i < MAXDRIVE; i++) {
					BOOL b;
					b = m_pFmParam->m_pDriveParam->m_pExist[i];
					if (b == FALSE) {
						drive = i;
						break;
					}
				}
				if (drive == -1) drive = MAXDRIVE - 1;
				m_pFmParam->m_pDriveParam->m_pCurrentPath[drive] = path;
				m_pFmParam->m_pDriveParam->m_pUncRootPath[drive] = path;
				m_pFmParam->m_pDriveParam->m_pExist[drive] = TRUE;
				m_pFmParam->m_pDriveParam->m_pType[drive] = DRIVE_REMOTE;
				m_pDriveTabWnd->m_MaxTab = m_pDriveTabWnd->CreateDriveList();
			}
			CString path;
			bool ex;
			ex = m_pFmParam->m_pDriveParam->m_pExist[drive];
			if (!ex) return false;

			m_pFmParam->m_SelectFileName = _T("");

			m_pFmParam->m_CurrentDriveNo = drive;
			path = m_pFmParam->m_pDriveParam->m_pCurrentPath[drive];
			m_pFileView->m_CurrentFileNo = 0;

			m_pFmParam->m_FileNum = m_pFmParam->GetAllFileList(path);

			if (m_pFmParam->m_SelectFileNo != 0) m_pFileView->m_CurrentFileNo = m_pFmParam->m_SelectFileNo;
			m_pFileView->m_CurrentPage = 0;
			Invalidate();
			m_pFileView->SetScrollData();
			m_pDriveTabWnd->CreateDriveList();
			m_pDriveTabWnd->Invalidate();

//			m_pFileView->SetFindNotify();

			CString cpath;
			cpath = m_pFmParam->m_pDriveParam->m_pCurrentPath[m_pFmParam->m_CurrentDriveNo];
			SetCurrentDirectory(cpath);
		}

	}

	CLangage lg;
	lg.SetEnumCodePage();

	return 0;
}

void CChildView::ResizeWindow(void)
{


	CRect rc, inforc, filerc, tabrc, sbrc;
	GetClientRect(&rc);

	CFont font, font2;
	CString cs;
//	CSize size;
	CClientDC dc(this);
	CFont* pOldFont;
	int fw, fh, sp;
	TEXTMETRIC tm;

	font.CreateFontIndirect(&(m_pFmParam->m_logfontInfo));
	pOldFont = dc.SelectObject(&font);

//	GetTextMetrics(dc, &tm);
//	fh = tm.tmHeight;
//	fw = tm.tmAveCharWidth + 1;

	CString ss;
	ss = "M";
	CSize size = dc.GetTextExtent(ss);
	fw = size.cx;
	fh = size.cy;

	dc.SelectObject(pOldFont);


	inforc = rc;
//	inforc.top += FRAMEOFSET;
	inforc.top += 2;
	sp = (m_pFmParam->m_InfoHeight + m_pFmParam->m_bEnableKeyGuid) * fh - (fh / 4);
	inforc.bottom = sp;
	inforc.left += FRAMEOFSET;
	inforc.right -= FRAMEOFSET;
	m_pInfoWnd->MoveWindow(&inforc);

	font2.CreateFontIndirect(&(m_pFmParam->m_logfontDriveTab));
	pOldFont = dc.SelectObject(&font2);
	GetTextMetrics(dc, &tm);
	fh = tm.tmHeight;
	fw = tm.tmAveCharWidth + 1;
	dc.SelectObject(pOldFont);

	m_pFmParam->m_DriveTabHeight = fh * 17 / 10;
//	fh += m_pFmParam->m_nLineSpace;

	filerc = rc;
	filerc.top = sp;
	filerc.top += FRAMEOFSET;
	if ( !m_pFmParam->m_bHideDriveTab ) filerc.bottom -= m_pFmParam->m_DriveTabHeight;
//	filerc.bottom -= TABWNDHEIGHT;
	filerc.left += FRAMEOFSET;
	filerc.right -= FRAMEOFSET;


	tabrc = rc;
	tabrc.top = filerc.bottom + 1;

	filerc.bottom -= m_nScrollBarHeight;

	sbrc = filerc;
	sbrc.top = filerc.bottom;
	sbrc.bottom = sbrc.top + m_nScrollBarHeight;

	m_pScrollBar->MoveWindow(&sbrc);
	m_pScrollBar->ShowScrollBar();


	CRect sbDrvrc;
	sbDrvrc.left = 1;
	sbDrvrc.right = DRAWTABOFSETX2 - 1;
	sbDrvrc.top = tabrc.top + 1;
	sbDrvrc.bottom = tabrc.bottom - 1;

	m_psbDriveTab->MoveWindow(&sbDrvrc);
	m_psbDriveTab->ShowScrollBar();


	tabrc.left += DRAWTABOFSETX2;

	m_pFileView->MoveWindow(&filerc);

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP
		m_pInfoWnd->DiscardDeviceResources();
		m_pInfoWnd->DrawInfoDirectWrite();
		m_pDriveTabWnd->DiscardDeviceResources();
#endif

	}

	m_pDriveTabWnd->MoveWindow(&tabrc);

	MoveMciWindow();
}

void CChildView::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B

	ResizeWindow();
}

BOOL CChildView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
// #ifdef _DIRECT_WRITE

	if (m_pFmParam->m_bSystemDirectWrite) {

#ifndef _WINVER_XP

		CreateTextFormat();
		CreateDeviceResources();

		g_pRenderTarget->BeginDraw();

		g_pRenderTarget->Clear(D2D1::ColorF(m_D2DcolBack));

		g_pRenderTarget->EndDraw();

#endif

	}

// #endif

// #ifndef _DIRECT_WRITE

	if (!(m_pFmParam->m_bSystemDirectWrite)) {
		CBrush brush(m_pFmParam->m_colBack);
		// VuVw(̃uV̕ۑ)
		CBrush* pOldBrush = pDC->SelectObject(&brush);

		// hԂ̈擾
		CRect rect;
		GetClientRect(&rect);

		CPen pen(PS_SOLID, 0, m_pFmParam->m_colFrame);
		CPen* pOldPen = pDC->SelectObject(&pen);

		// hԂ
		pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);

		// uVɖ߂
		pDC->SelectObject(pOldBrush);
		pDC->SelectObject(pOldPen);
	}

// #endif

	return TRUE;

//	return CWnd::OnEraseBkgnd(pDC);
}

void CChildView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CChildView::MoveMciWindow(void)
{

	CWinApp *pApp = AfxGetApp();
	CString sSection, sEntry;
	CRect rc;
	GetWindowRect(&rc);

	sSection = INISECTION_MCIWINDOW;
	sEntry = INIENTRY_WINDOW_TOP;
	rc.top = pApp->GetProfileInt(sSection, sEntry, -1);
	sEntry = INIENTRY_WINDOW_LEFT;
	rc.left = pApp->GetProfileInt(sSection, sEntry, 0);
	sEntry = INIENTRY_WINDOW_RIGHT;
	rc.right = pApp->GetProfileInt(sSection, sEntry, 0);
	sEntry = INIENTRY_WINDOW_BOTTOM;
	rc.bottom = pApp->GetProfileInt(sSection, sEntry, 0);

	if ( rc.top == -1 ) {
		CRect rc, mrc;
		m_pInfoWnd->DrawInfo();
		m_pInfoWnd->GetWindowRect(&rc);
		rc.left += m_pInfoWnd->m_MciWindowPosX;
		rc.left += 18;

		m_pMciDialog->GetWindowRect(&mrc);
		int xw = mrc.right - mrc.left;
		int yw = mrc.bottom - mrc.top;

		mrc.left = rc.left;
		mrc.right = mrc.left + xw;
		mrc.top = rc.top - 36;
		mrc.bottom = mrc.top + yw;

		m_pMciDialog->MoveWindow(&mrc);
	} else {
		m_pMciDialog->MoveWindow(&rc);
	}
}

void CChildView::OnMove(int x, int y)
{
	CWnd::OnMove(x, y);

	MoveMciWindow();
	ResizeWindow();


	// TODO: ɃbZ[W nh R[hǉ܂B
}


void CChildView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: ɃbZ[W nh[ R[hǉ邩ȀĂяo܂B

	SCROLLINFO info;
	info.cbSize = sizeof(SCROLLINFO);
	info.fMask = SIF_TRACKPOS;

	int nSb = 0;

	if (pScrollBar == m_pScrollBar) {	// FileView
		nSb = 0;
		m_pScrollBar->GetScrollInfo(&info);
		nPos = info.nTrackPos;
	}

	if (pScrollBar == m_psbDriveTab) {	// TabWnd
		nSb = 1;
		m_psbDriveTab->GetScrollInfo(&info);
		nPos = info.nTrackPos;
	}


	switch (nSBCode) {
	case SB_LINELEFT:	// XN[{bNX̍NbNꍇ
		if (nSb == 0)
			m_pFileView->CmdKeyPageUp();

		if (nSb == 1) {
			if (m_pDriveTabWnd->m_StartTabNo > 0) m_pDriveTabWnd->m_StartTabNo--;
			m_pDriveTabWnd->DrawAllTab();

		}

		break;

	case SB_LINERIGHT:	// XN[{bNX̉ENbNꍇ
		if (nSb == 0)
			m_pFileView->CmdKeyPageDown();

		if (nSb == 1) {
			if (m_pDriveTabWnd->m_StartTabNo < (m_pDriveTabWnd->m_MaxTab - 1)) m_pDriveTabWnd->m_StartTabNo++;
			m_pDriveTabWnd->DrawAllTab();

		}
		break;

	case SB_PAGELEFT:		// XN[{bNX̍NbNꍇi܂PageUpL[j
		if (nSb == 0)
			m_pFileView->CmdKeyPageUp();
		break;

	case SB_PAGERIGHT:		// XN[{bNX̉ENbNꍇi܂PageDownL[j
		if (nSb == 0)
			m_pFileView->CmdKeyPageDown();
		break;

	case SB_THUMBPOSITION:		// XN[{bNXΈړꍇ
		break;

	case SB_THUMBTRACK:		// XN[{bNXhbOړꍇ
		if (nSb == 0) {
			if (m_pFileView->m_CurrentPage != nPos) {
				m_pFileView->m_CurrentPage = nPos;
				m_pFileView->m_CurrentFileNo = m_pFileView->m_CurrentPage * m_pFileView->m_PageFileNum;
				m_pFileView->Invalidate();
			}

		}
		break;

	}


//	CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}
