// ChangeNameDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "ChangeNameDialog.h"
#include "FmParam.h"


// CChangeNameDialog _CAO

IMPLEMENT_DYNAMIC(CChangeNameDialog, CDialog)

CChangeNameDialog::CChangeNameDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CChangeNameDialog::IDD, pParent)
	, m_bNameOnlyCheck(false)
{
	m_Message = _T("ʂ܂͈ړt@CύXĂB");
	m_EnableSkipButton = false;
	m_Skip = false;
	m_Title = _T("t@C̕ύX");
	m_bDir = false;
	m_bSetNameOnlyCheck = false;

}

CChangeNameDialog::~CChangeNameDialog()
{
}

void CChangeNameDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_FILENAME, m_FileName);
	DDX_Text(pDX, IDC_MESSAGE, m_Message);
	DDX_Control(pDX, IDC_SKIP, m_ctrlSkipButton);
	DDX_Control(pDX, IDC_NAMEONLY_CHECK, m_ctrlNameOnlyCheck);
	DDX_Control(pDX, IDC_FILENAME, m_ctrlFileName);
}


BEGIN_MESSAGE_MAP(CChangeNameDialog, CDialog)
	ON_BN_CLICKED(IDC_SKIP, &CChangeNameDialog::OnBnClickedSkip)
	ON_BN_CLICKED(IDC_NAMEONLY_CHECK, &CChangeNameDialog::OnBnClickedNameonlyCheck)
	ON_BN_CLICKED(IDOK, &CChangeNameDialog::OnBnClickedOk)
END_MESSAGE_MAP()


// CChangeNameDialog bZ[W nh

BOOL CChangeNameDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	if ( m_EnableSkipButton ) {
		m_ctrlSkipButton.ShowWindow(SW_SHOW);
	}

	if (!m_bDir) {
		CWinApp *pApp = AfxGetApp();
		CString sSection, sEntry;

		sSection = INISECTION_SETTINGS;
		sEntry = INIENTRY_SETTINGS_CHANGE_NEMEONLY;

		int b = pApp->GetProfileInt(sSection, sEntry, BST_CHECKED);

		m_sOrgFileName = m_FileName;
		m_sName = m_FileName;
		m_sExt = _T("");

		if (m_bSetNameOnlyCheck) b = BST_CHECKED;
		m_ctrlNameOnlyCheck.SetCheck(b);
		if (b == BST_CHECKED) {
			m_bNameOnlyCheck = true;

			if (!m_bDir) {
				int nf = m_FileName.ReverseFind(_T('.'));
				int len = m_FileName.GetLength();
				if (nf > 0) {
					m_sName = m_FileName.Left(nf);
					m_sExt = m_FileName.Right(len - nf);
				}
			}
		}

		m_FileName = m_sName;

	}
	else {
		GetDlgItem(IDC_NAMEONLY_CHECK)->EnableWindow(FALSE);

	}

	m_ctrlFileName.SetWindowTextW(m_FileName);

	SetWindowText(m_Title);

	if (m_pFmParam->m_bSettingsSetDialogFont) {
		m_font.CreateFontIndirect(&(m_pFmParam->m_logfontFile));
		m_ctrlFileName.SetFont(&m_font);

	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CChangeNameDialog::OnBnClickedSkip()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_Skip = true;
	EndDialog(-1);
}


void CChangeNameDialog::OnBnClickedNameonlyCheck()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	m_sName = m_sOrgFileName;
	m_sExt = _T("");

	if (m_bNameOnlyCheck) {
		m_bNameOnlyCheck = false;
		m_ctrlNameOnlyCheck.SetCheck(BST_UNCHECKED);

	}
	else {
		m_bNameOnlyCheck = true;
		m_ctrlNameOnlyCheck.SetCheck(BST_CHECKED);

		if (!m_bDir) {
			int nf = m_FileName.ReverseFind(_T('.'));
			int len = m_FileName.GetLength();
			if (nf > 0) {
				m_sName = m_FileName.Left(nf);
				m_sExt = m_FileName.Right(len - nf);
			}
		}


	}
	m_FileName = m_sName;
	m_ctrlFileName.SetWindowTextW(m_FileName);
	m_ctrlFileName.SetSel(0, -1);
	m_ctrlFileName.SetFocus();
	m_ctrlFileName.UpdateWindow();

}


void CChangeNameDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B

	if (!m_bSetNameOnlyCheck && !m_bDir) {
		CWinApp *pApp = AfxGetApp();
		CString sSection, sEntry;

		sSection = INISECTION_SETTINGS;
		sEntry = INIENTRY_SETTINGS_CHANGE_NEMEONLY;

		int b = m_ctrlNameOnlyCheck.GetCheck();

		pApp->WriteProfileInt(sSection, sEntry, b);

	}
	else {

	}


	m_ctrlFileName.GetWindowTextW(m_FileName);
	m_FileName += m_sExt;

	m_ctrlFileName.SetWindowTextW(m_FileName);
	m_ctrlFileName.UpdateWindow();

	CDialog::OnOK();
}
