// ChangeFileTimeDialog.cpp : t@C
//

#include "stdafx.h"
#include "annsFM.h"
#include "ChangeFileTimeDialog.h"
#include  <time.h>

// CChangeFileTimeDialog _CAO

IMPLEMENT_DYNAMIC(CChangeFileTimeDialog, CDialog)

CChangeFileTimeDialog::CChangeFileTimeDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CChangeFileTimeDialog::IDD, pParent)
{
	m_nChangeCheck = BST_CHECKED;
	m_nNoChangeRadio = BST_CHECKED;
	m_nSameRadio = BST_UNCHECKED;
	m_nSetRadio = BST_UNCHECKED;

}

CChangeFileTimeDialog::~CChangeFileTimeDialog()
{
}

void CChangeFileTimeDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_FILENAME, m_ctrlsFileName);
	DDX_Control(pDX, IDC_PATHNAME, m_ctrlsPathName);
	DDX_Control(pDX, IDC_CHANGE_CHECK, m_ctrlChangeCheck);
	DDX_Control(pDX, IDC_NEW_DATEPICKER, m_ctrlNewDatePicker);
	DDX_Control(pDX, IDC_NEW_TIMEPICKER, m_ctrlNewTimePicker);
	DDX_Control(pDX, IDC_CREATE_DATEPICKER, m_ctrlCreateDatePicker);
	DDX_Control(pDX, IDC_CREATE_TIMEPICKER, m_ctrlCreateTimePicker);
	DDX_Control(pDX, IDC_NOCHANGE_RADIO, m_ctrlNoChangeRadio);
	DDX_Control(pDX, IDC_SAME_RADIO, m_ctrlSameRadio);
	DDX_Control(pDX, IDC_SET_RADIO, m_ctrlSetRadio);
	DDX_Control(pDX, IDC_CHANGE_ALLFILE_CHECK, m_ctrlChangeAllFileCheck);
	DDX_Control(pDX, IDC_CHANGE_ALLDIR_CHECK, m_ctrlChangeAllDirCheck);
}


BEGIN_MESSAGE_MAP(CChangeFileTimeDialog, CDialog)
	ON_BN_CLICKED(IDC_TODAY_BUTTON, &CChangeFileTimeDialog::OnBnClickedTodayButton)
	ON_BN_CLICKED(IDC_NOW_BUTTON, &CChangeFileTimeDialog::OnBnClickedNowButton)
	ON_BN_CLICKED(IDC_NOCHANGE_RADIO, &CChangeFileTimeDialog::OnBnClickedNochangeRadio)
	ON_BN_CLICKED(IDC_SAME_RADIO, &CChangeFileTimeDialog::OnBnClickedSameRadio)
	ON_BN_CLICKED(IDC_SET_RADIO, &CChangeFileTimeDialog::OnBnClickedSetRadio)
	ON_BN_CLICKED(IDOK, &CChangeFileTimeDialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_CHANGE_CHECK, &CChangeFileTimeDialog::OnBnClickedChangeCheck)
END_MESSAGE_MAP()


// CChangeFileTimeDialog bZ[W nh

void CChangeFileTimeDialog::OnBnClickedTodayButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	__time64_t time;
	_time64( &time );

	CTime ct(time);

	m_ctrlNewDatePicker.SetTime(&ct);
}

void CChangeFileTimeDialog::OnBnClickedNowButton()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	__time64_t time;
	_time64( &time );

	CTime ct(time);

	m_ctrlNewTimePicker.SetTime(&ct);
}

void CChangeFileTimeDialog::OnBnClickedNochangeRadio()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	m_nNoChangeRadio = m_ctrlNoChangeRadio.GetCheck();

	int nc = BST_CHECKED;
	int nu = BST_UNCHECKED;
	bool b = FALSE;

	if ( m_nNoChangeRadio == nu ) {
		m_nNoChangeRadio = nc;
		m_nSameRadio = nu;
		m_nSetRadio = nu;
	}

	m_ctrlCreateDatePicker.EnableWindow(b);
	m_ctrlCreateTimePicker.EnableWindow(b);

	m_ctrlNoChangeRadio.SetCheck(m_nNoChangeRadio);
	m_ctrlSameRadio.SetCheck(m_nSameRadio);
	m_ctrlSetRadio.SetCheck(m_nSetRadio);
}

void CChangeFileTimeDialog::OnBnClickedSameRadio()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int nc = BST_CHECKED;
	int nu = BST_UNCHECKED;
	bool b = FALSE;

	if ( m_nSameRadio == nu ) {
		m_nNoChangeRadio = nu;
		m_nSameRadio = nc;
		m_nSetRadio = nu;
	}

	m_ctrlCreateDatePicker.EnableWindow(b);
	m_ctrlCreateTimePicker.EnableWindow(b);

	m_ctrlNoChangeRadio.SetCheck(m_nNoChangeRadio);
	m_ctrlSameRadio.SetCheck(m_nSameRadio);
	m_ctrlSetRadio.SetCheck(m_nSetRadio);
}

void CChangeFileTimeDialog::OnBnClickedSetRadio()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int nc = BST_CHECKED;
	int nu = BST_UNCHECKED;
	bool b = TRUE;

	if ( m_nSetRadio == nu ) {
		m_nNoChangeRadio = nu;
		m_nSameRadio = nu;
		m_nSetRadio = nc;
	}

	m_ctrlCreateDatePicker.EnableWindow(b);
	m_ctrlCreateTimePicker.EnableWindow(b);

	m_ctrlNoChangeRadio.SetCheck(m_nNoChangeRadio);
	m_ctrlSameRadio.SetCheck(m_nSameRadio);
	m_ctrlSetRadio.SetCheck(m_nSetRadio);
}

void CChangeFileTimeDialog::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CTime ct, ctc, dct;
	struct tm tim;

	m_ctrlNewDatePicker.GetTime(ct);
	m_ctrlNewTimePicker.GetTime(dct);

	tim.tm_year = ct.GetYear() - 1900;
	tim.tm_mon = ct.GetMonth() - 1;
	tim.tm_mday = ct.GetDay();
	tim.tm_hour = dct.GetHour();
	tim.tm_min = dct.GetMinute();
	tim.tm_sec = dct.GetSecond();

	m_timeNewDate = mktime(&tim);

	
	m_ctrlCreateDatePicker.GetTime(ct);
	m_ctrlCreateTimePicker.GetTime(dct);

	tim.tm_year = ct.GetYear() - 1900;
	tim.tm_mon = ct.GetMonth() - 1;
	tim.tm_mday = ct.GetDay();
	tim.tm_hour = dct.GetHour();
	tim.tm_min = dct.GetMinute();
	tim.tm_sec = dct.GetSecond();

	m_timeCreateDate = mktime(&tim);

	m_nChangeCheck = m_ctrlChangeCheck.GetCheck();
	m_nChangeAllFileCheck = m_ctrlChangeAllFileCheck.GetCheck();
	m_nChangeAllDirCheck = m_ctrlChangeAllDirCheck.GetCheck();

	OnOK();
}

BOOL CChangeFileTimeDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	m_ctrlChangeCheck.SetCheck(m_nChangeCheck);
	m_ctrlNoChangeRadio.SetCheck(m_nNoChangeRadio);

	CTime ct(m_timeNewDate);

	m_ctrlNewDatePicker.SetTime(&ct);
	m_ctrlNewTimePicker.SetTime(&ct);

	CTime ctc(m_timeCreateDate);

	m_ctrlCreateDatePicker.SetTime(&ctc);
	m_ctrlCreateTimePicker.SetTime(&ctc);

	m_ctrlsFileName.SetWindowTextW(m_sFileName);
	m_ctrlsPathName.SetWindowTextW(m_sPathName);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CChangeFileTimeDialog::OnBnClickedChangeCheck()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	int n = m_ctrlChangeCheck.GetCheck();

	if ( n == BST_UNCHECKED ) {
		m_nChangeCheck = n;
		m_ctrlNewDatePicker.EnableWindow(FALSE);
		m_ctrlNewTimePicker.EnableWindow(FALSE);
	} else {
		m_nChangeCheck = BST_CHECKED;
		m_ctrlNewDatePicker.EnableWindow();
		m_ctrlNewTimePicker.EnableWindow();
	}
	m_ctrlChangeCheck.SetCheck(m_nChangeCheck);
}
