// setwp.cpp		ver.0.00
//copyright 2009 Beer[Tsutsumi Hiroyuki]

#define	VER		"ver.0.00"
#define	DATE	"2009. 1. 4"

#include	<Be.h>
#include	<be_apps/Tracker/Background.h>

struct ws_inf{
	uchar	f;
	char	fn[256];
	char	mode;
	BPoint	point;
	bool	erase;
	rgb_color	col;
};

class setwp:public BApplication
{
	public:
		setwp();
		~setwp();
		void	get_wallpaper(ws_inf *wsi);
		void	set_wallpaper(ws_inf *wsi);
	private:
		BNode	n;
};


void usage()
{
	printf("setwp "VER"\nusage :\n\tsetwp [ ws_num [ -iimg_fn | -ppos | -eflag | -ccol ] ]*n\n");
	exit(1);
}

int main(int argc,char **argv)
{
	if(argc<2)usage();

	setwp	*app=new setwp();
	ws_inf	wsi[32];
	app->get_wallpaper(wsi);

	uint32	wsf=0x0001;				//default(workspace_1 only)
	for(int i=1;i<argc;i++){
		char	*sp=argv[i];
		if((*sp>='0')&&(*sp<='9')){	//select workspace
			wsf=0;
			while(*sp){
				int	s=0;while((*sp>='0')&&(*sp<='9'))s=s*10+(*(sp++)-'0');
				int	e=s;if(*sp=='-'){sp++;while((*sp>='0')&&(*sp<='9'))e=e*10+(*(sp++)-'0');}
				if((s==0)||(e==0)){s=1;e=count_workspaces();}
				for(int j=s;j<=e;j++)wsf|=1<<(j-1);
			}
			for(int j=0;j<32;j++)if(wsf&(1<<j))wsi[j].f=1;
		}else if(!strncmp(sp,"-i",2)){
			for(int j=0;j<32;j++)if(wsf&(1<<j))strcpy(wsi[j].fn,sp+2);
		}else if(!strncmp(sp,"-p",2)){
			int	m=B_BACKGROUND_MODE_CENTERED;
			sp+=2;
			if(*sp=='s')m=B_BACKGROUND_MODE_SCALED;
			if(*sp=='c')m=B_BACKGROUND_MODE_CENTERED;
			if(*sp=='o')m=B_BACKGROUND_MODE_USE_ORIGIN;
			if(*sp=='t')m=B_BACKGROUND_MODE_TILED;
			sp++;
			int	x=0;while((*sp>='0')&&(*sp<='9'))x=x*10+(*(sp++)-'0');
			sp++;
			int	y=0;while((*sp>='0')&&(*sp<='9'))y=y*10+(*(sp++)-'0');
			for(int j=0;j<32;j++)if(wsf&(1<<j)){wsi[j].mode=m;wsi[j].point=BPoint(x,y);}
		}else if(!strncmp(sp,"-e",2)){
			bool	f=*(sp+2)!='0';
			for(int j=0;j<32;j++)if(wsf&(1<<j))wsi[j].erase=f;
		}else if(!strncmp(sp,"-c",2)){
			uint32	x;
			sscanf(sp+2,"%x",&x);
			rgb_color	rgb;
			rgb.red=x>>16;rgb.green=x>>8;rgb.blue=x;
			for(int j=0;j<32;j++)if(wsf&(1<<j))wsi[j].col=rgb;
		}else usage();
	}
	
	app->set_wallpaper(wsi);
	delete app;
	return(0);
}
//------------------------------------------------
setwp::setwp():BApplication("application/x-vnd.Beer-setwp")
{
	n.SetTo("/boot/home/Desktop");
}

setwp::~setwp()
{
	n.Unset();
}

void setwp::get_wallpaper(ws_inf *wsi)
{
	for(int i=0;i<count_workspaces();i++){
		wsi[i].f=0;
		*(wsi[i].fn)=0;
		wsi[i].mode=B_BACKGROUND_MODE_CENTERED;
		wsi[i].point=BPoint(0,0);
		wsi[i].erase=true;
		wsi[i].col=BScreen().DesktopColor(i);
	}

	attr_info	inf;
	n.GetAttrInfo(B_BACKGROUND_INFO,&inf);
	char	*buf=new char[inf.size];
	n.ReadAttr(B_BACKGROUND_INFO,B_MESSAGE_TYPE,0,buf,inf.size);
	BMessage	m;
	m.Unflatten(buf);
	delete buf;
//m.PrintToStream();
	for(int i=0;;i++){
		int32	wsno=0;
		int32	i32;
		bool	b;
		BPoint	p;
		const char	*s;
		if(!m.FindInt32(B_BACKGROUND_WORKSPACES,i,&i32)){while(i32>>=1)wsno++;wsi[wsno].f=1;}else break;
		if(!m.FindString(B_BACKGROUND_IMAGE,i,&s))strcpy(wsi[wsno].fn,s);
		if(!m.FindInt32(B_BACKGROUND_MODE,i,&i32))wsi[wsno].mode=i32;
		if(!m.FindPoint(B_BACKGROUND_ORIGIN,i,&p))wsi[wsno].point=p;
		if(!m.FindBool(B_BACKGROUND_ERASE_TEXT,i,&b))wsi[wsno].erase=b;
	}
}

void setwp::set_wallpaper(ws_inf *wsi)
{
	BMessage	m;
	for(int i=0;i<count_workspaces();i++){
		if(!wsi[i].f)continue;
		BScreen().SetDesktopColor(wsi[i].col,i,true);
		m.AddInt32(B_BACKGROUND_WORKSPACES,1<<i);
		m.AddString(B_BACKGROUND_IMAGE,wsi[i].fn);
		m.AddInt32(B_BACKGROUND_MODE,wsi[i].mode);
		m.AddPoint(B_BACKGROUND_ORIGIN,wsi[i].point);
		m.AddBool(B_BACKGROUND_ERASE_TEXT,wsi[i].erase);
	}
	int		size=m.FlattenedSize();
	char	*buf=new char[size];
	m.Flatten(buf,size);
//m.PrintToStream();
	n.WriteAttr(B_BACKGROUND_INFO,B_MESSAGE_TYPE,0,buf,size);
	delete buf;
	BMessenger("application/x-vnd.Be-TRAK").SendMessage(B_RESTORE_BACKGROUND_IMAGE);
}
