//bdf2ttf ver.0.02
// bdf(unix) > ttf(with bitmap)
#include	<Be.h>

#define	MAXBTC	6

struct GLYPH{
	uint16	o;	//unicode(output)
	uint32	p;	//glyph offset(input)
	uint32	l;	//glyph length
	uint16	w,h;
};
struct point{
	int		tag,x,y;
}points[2000];
struct G{
	uint16	uni;
	int16	xmin,ymin,xmax,ymax;
	uint16	noc;
	uint16	ilen;
	uint16	dxl,dyl;
	uint16	epoc[50];			//len=noc
	uchar	inst[1];			//len=ilen=0
	uchar	flag[2000];			//len=epoc[noc-1]+1
	uchar	dx[2000],dy[2000];	//len=dxl,dyl
	
	uint16	pt,mpt,mct;		//points,maxpoints,maxcontours
	int		bx,by;			//before point
	char	pro;			//0.tohaba  1.proportional
}glyf;
enum tags{	STPOINT,DRPOINT,CVPOINT	};	/*start,draw,curve*/

int		bmp2glf(uchar w,uchar h,uchar *bmp,uchar *glf);	//return=glflen
void	set_glf_point(int x,int y,int p);
void	point2glyf(int p);
int		outputglyf(uchar *wb);
uchar	readbdf(int fc,char **fn,uchar *rb);
uint16	setxfertbl(char *fn,uint16 *xtbl);
uint32	unicode(uint cs,uint16 c);
int		hz(uint16 uc);
void	sort_glyph(GLYPH *g,int s,int e);
uint32	sumB32(uint32 *p,int len);
void	quit(char *p);

int		tbls;
uint32	tblname[13];
uint16	j2u[2*94*94];
uchar	pt[MAXBTC];		//bitmap-pt-number
//uint32	bad[MAXBTC+1];	//bitmap-data-adr
uint16	bchrs[MAXBTC];
int16	uni2bno[MAXBTC][65536];

main(int ac,char **ag)
{
	if(ac<3)quit("bdf2ttf  ver.0.02\nusage:\tbdf2ttf [-n] info-file bdf...");
	char	ofn[256];
	FILE	*tfp,*ofp;
	struct{
		uint32	tag,sum,off,len;
	}tblhd[13];
	int		chrs;			//count of glyf for output
	int		weight;			//1..thin  5..medium  9..heavy
	uint32	vendid;
	char	nts[8*4][256];	//name table strings
	uint16	mpt,mct;		//maxPoints,maxContours
	GLYPH	*g=NULL;
	char	s[256];
	bool	ebf=true;
	int		agn=1;

	while(ag[agn][0]=='-'){
		if(!strcmp(ag[agn],"-n"))ebf=false;
		agn++;
	}
	tbls=0;
	if(ebf){	tblname[tbls++]='EBDT';	tblname[tbls++]='EBLC';	}
	tblname[tbls++]='OS/2';	tblname[tbls++]='cmap';	tblname[tbls++]='gasp';
	tblname[tbls++]='glyf';	tblname[tbls++]='head';	tblname[tbls++]='hhea';
	tblname[tbls++]='hmtx';	tblname[tbls++]='loca';	tblname[tbls++]='maxp';
	tblname[tbls++]='name';	tblname[tbls++]='post';
	if((tfp=fopen(ag[agn++],"r"))==NULL)quit("cannot open info-file");
	fgets(s,255,tfp);
	sscanf(s,"%s",ofn);	strcat(ofn,".ttf");
printf("output= [%s]\n",ofn);
	fgets(s,255,tfp);	sscanf(s,"%d",&weight);
	fgets(s,255,tfp);	sscanf(s,"%c%c%c%c",(char*)&vendid,(char*)&vendid+1,(char*)&vendid+2,(char*)&vendid+3);
printf("vendid=%c%c%c%c\n",*(char*)&vendid,*((char*)&vendid+1),*((char*)&vendid+2),*((char*)&vendid+3));
	vendid=B_BENDIAN_TO_HOST_INT32(vendid);
	for(int i=0;i<8*4;i++){
		fgets(nts[i],255,tfp);
		nts[i][strlen(nts[i])-1]=0;
//		fgets(s,255,tfp);
//		sscanf(s,"%s",nts[i]);
	}
	fclose(tfp);


	int	achrs=setxfertbl("jis_uni.txt",j2u);	//count(xfer-tbl),set xfer-tbl
printf("%d chrs(xfer-table)\n",achrs);

//set GLYPH(unicode),count(output-chr)
	for(int i=0;i<MAXBTC;i++)bchrs[i]=0;
	for(int i=0;i<MAXBTC;i++)for(int j=0;j<65536;j++)uni2bno[i][j]=-1;
	uchar	*rb=new uchar[0x200000*MAXBTC];	//2MB
	uchar	btc=readbdf(ac-agn,ag+agn,rb);;				//btc=bitmap-table-count
printf("%d bitmap-tables\n",btc);
printf("set g\n");
	uint16	gc=0;
	for(int i=0;i<btc;i++)gc+=bchrs[i]+1;
	g=new GLYPH[gc];
	g[0].o=0;
	g[0].p=0;	g[0].l=0;	g[0].w=1000;	g[0].h=1000;	chrs=1;
	for(int i=0;i<65536;i++){
		uchar	ucf=0;
		for(int j=0;j<btc;j++)if(uni2bno[j][i]!=-1)ucf++;
		if(ucf){
//printf("%04x\n",i);
//if(i==0)printf("err! bno=%d %d %d %d\n",uni2bno[0][i],uni2bno[1][i],uni2bno[2][i],uni2bno[3][i]);
			g[chrs].o=i;
			g[chrs].p=0;
			g[chrs].l=0x1c;		//for test2
			g[chrs].w=1000;
			g[chrs].h=1000;
			chrs++;
		}
	}
	printf("xfer %d chrs\n",chrs);
//sort(unicode)
printf("sort\n");
	sort_glyph(g,0,chrs-1);		//sort GLYPHstruct



printf("open for output\n");
	if((ofp=fopen(ofn,"wb"))==NULL)quit("cannot output");
	uint32	wp=12+16*tbls;
	fseek(ofp,wp,0);
	for(int i=0;i<tbls;i++){
printf("table no.%2d   ...   ",i);
		tblhd[i].tag=tblname[i];
		if(tblname[i]=='head'){
printf("head\n");
			*(uint32*)(s)=B_HOST_TO_BENDIAN_INT32(0x10000);			//tableVersionNumber
			*(uint32*)(s+4)=B_HOST_TO_BENDIAN_INT32(0);				//fontRevision
			*(uint32*)(s+8)=0;										//checkSumAdjustment
			*(uint32*)(s+12)=B_HOST_TO_BENDIAN_INT32(0x5f0f3cf5);	//magicNumber
			*(uint16*)(s+16)=B_HOST_TO_BENDIAN_INT16(0x01);			//flags
			*(uint16*)(s+18)=B_HOST_TO_BENDIAN_INT16(1000);			//unitsPerEm
			*(uint32*)(s+20)=B_HOST_TO_BENDIAN_INT32(0);			//created
			*(uint32*)(s+24)=B_HOST_TO_BENDIAN_INT32(0);			//created
			*(uint32*)(s+28)=B_HOST_TO_BENDIAN_INT32(0);			//modified
			*(uint32*)(s+32)=B_HOST_TO_BENDIAN_INT32(0);			//modified
			*(uint16*)(s+36)=B_HOST_TO_BENDIAN_INT16(0);			//xMin
			*(uint16*)(s+38)=B_HOST_TO_BENDIAN_INT16(-140);			//yMin
			*(uint16*)(s+40)=B_HOST_TO_BENDIAN_INT16(999);			//xMax
			*(uint16*)(s+42)=B_HOST_TO_BENDIAN_INT16(859);			//yMax
			*(uint16*)(s+44)=B_HOST_TO_BENDIAN_INT16(0);			//macStyle
			*(uint16*)(s+46)=B_HOST_TO_BENDIAN_INT16(6);			//lowestRecPPEM
			*(uint16*)(s+48)=B_HOST_TO_BENDIAN_INT16(1);			//fontDirectionHint
			*(uint16*)(s+50)=B_HOST_TO_BENDIAN_INT16(1);			//indexToLocFormat
			*(uint16*)(s+52)=B_HOST_TO_BENDIAN_INT16(0);			//glyphDataFormat
																s[54]=s[55]=0;
			tblhd[i].sum=sumB32((uint32*)s,56);
			tblhd[i].len=56;
			fwrite(s,1,56,ofp);
		}else if(tblname[i]=='name'){
printf("name\n");
			char	nstr[32][256];
			int32	nstrl[32],nstt;
			for(int j=0;j<8;j++){
				int32	ntsl;
				strcpy(nstr[j],nts[j]);nstrl[j]=strlen(nts[j]);
				ntsl=strlen(nts[8+j]);nstrl[8+j]=255;
				convert_from_utf8(B_SJIS_CONVERSION,nts[8+j],&ntsl,nstr[8+j],&(nstrl[8+j]),&nstt);
if(nstt)printf("textconv_err : stt=%x\n",nstt);
				ntsl=strlen(nts[16+j]);nstrl[16+j]=255;
				convert_from_utf8(B_UNICODE_CONVERSION,nts[16+j],&ntsl,nstr[16+j],&(nstrl[16+j]),&nstt);
if(nstt)printf("textconv_err : stt=%x\n",nstt);
				ntsl=strlen(nts[24+j]);nstrl[24+j]=255;
				convert_from_utf8(B_UNICODE_CONVERSION,nts[24+j],&ntsl,nstr[24+j],&(nstrl[24+j]),&nstt);
if(nstt)printf("textconv_err : stt=%x\n",nstt);
			}
			const int	ntc=4;
			const struct{
				uint16	pid,eid,lid;
			}nt[ntc]={
				{1,0,0},		/*mac*/
				{1,1,0xb},		/*mac-japanese(sjis)*/
				{3,1,0x409},	/*ms(unicode)*/
				{3,1,0x411}		/*ms-japanese(unicode)*/
			};
			uint	nal=6;
			for(int j=0;j<ntc*8;j++)nal+=12+nstrl[j];
																while(nal&3)nal++;
			uchar	*na=new uchar[nal];
			*(uint16*)(na)=B_HOST_TO_BENDIAN_INT16(0);				//formatSelector
			*(uint16*)(na+2)=B_HOST_TO_BENDIAN_INT16(ntc*8);		//numOfNameRecords
			*(uint16*)(na+4)=B_HOST_TO_BENDIAN_INT16(6+12*(ntc*8));	//offsetToStartOfStringStorage
			uint	nap=6;
			uint16	off=0;
			for(int j=0;j<ntc;j++)for(int k=0;k<8;k++){
				uint16	len=nstrl[j*8+k];
				*(uint16*)(na+nap)=B_HOST_TO_BENDIAN_INT16(nt[j].pid);		//plathomeID
				*(uint16*)(na+nap+2)=B_HOST_TO_BENDIAN_INT16(nt[j].eid);	//encodingID
				*(uint16*)(na+nap+4)=B_HOST_TO_BENDIAN_INT16(nt[j].lid);	//languageID
				*(uint16*)(na+nap+6)=B_HOST_TO_BENDIAN_INT16(k);			//nameID
				*(uint16*)(na+nap+8)=B_HOST_TO_BENDIAN_INT16(len);			//stringLength
				*(uint16*)(na+nap+10)=B_HOST_TO_BENDIAN_INT16(off);			//stringOffset
				off+=len;
				nap+=12;
			}
			for(int j=0;j<ntc*8;j++)for(int k=0;k<nstrl[j];k++)na[nap++]=nstr[j][k];
																while(nap&3)na[nap++]=0;
			tblhd[i].sum=sumB32((uint32*)na,nal);
			tblhd[i].len=nal;
			fwrite(na,1,nal,ofp);
			delete	na;
		}else if(tblname[i]=='hhea'){
printf("hhea\n");
			*(uint32*)(s)=B_HOST_TO_BENDIAN_INT32(0x10000);			//tableVersionNumber
			*(uint16*)(s+4)=B_HOST_TO_BENDIAN_INT16(860);			//Ascender
			*(uint16*)(s+6)=B_HOST_TO_BENDIAN_INT16(-140);			//Descender
			*(uint16*)(s+8)=B_HOST_TO_BENDIAN_INT16(0);				//LineGap
			*(uint16*)(s+10)=B_HOST_TO_BENDIAN_INT16(1000);			//advanceWidthMax
			*(uint16*)(s+12)=B_HOST_TO_BENDIAN_INT16(0);			//minLeftSideBearing
			*(uint16*)(s+14)=B_HOST_TO_BENDIAN_INT16(0);			//minRightSideBearing
			*(uint16*)(s+16)=B_HOST_TO_BENDIAN_INT16(1000);			//xMaxExtent
			*(uint16*)(s+18)=B_HOST_TO_BENDIAN_INT16(1);			//caretSlopeRise
			*(uint16*)(s+20)=B_HOST_TO_BENDIAN_INT16(0);			//caretSlopeRun
			*(uint16*)(s+22)=B_HOST_TO_BENDIAN_INT16(0);			//reserved
			*(uint16*)(s+24)=B_HOST_TO_BENDIAN_INT16(0);			//reserved
			*(uint16*)(s+26)=B_HOST_TO_BENDIAN_INT16(0);			//reserved
			*(uint16*)(s+28)=B_HOST_TO_BENDIAN_INT16(0);			//reserved
			*(uint16*)(s+30)=B_HOST_TO_BENDIAN_INT16(0);			//reserved
			*(uint16*)(s+32)=B_HOST_TO_BENDIAN_INT16(0);			//metricDataFormat
			*(uint16*)(s+34)=B_HOST_TO_BENDIAN_INT16(chrs);			//numberOfHMetrics
			tblhd[i].sum=sumB32((uint32*)s,36);
			tblhd[i].len=36;
			fwrite(s,1,36,ofp);
		}else if(tblname[i]=='hmtx'){
printf("hmtx\n");
			uint	hml=chrs*4;
			uchar	*hm=new uchar[hml];
			uint32	*hmp=(uint32*)hm;
			for(int j=0;j<chrs;j++){
				*(hmp++)=B_HOST_TO_BENDIAN_INT32((1000/hz(g[j].o))<<16);
			}
			tblhd[i].sum=sumB32((uint32*)hm,hml);
			tblhd[i].len=hml;
			fwrite(hm,1,hml,ofp);
			delete	hm;
		}else if(tblname[i]=='maxp'){
printf("maxp\n");
			*(uint32*)(s)=B_HOST_TO_BENDIAN_INT32(0x10000);			//tableVersionNumber
			*(uint16*)(s+4)=B_HOST_TO_BENDIAN_INT16(chrs);			//numGlyphs
			*(uint16*)(s+6)=B_HOST_TO_BENDIAN_INT16(mpt);			//maxPoints
			*(uint16*)(s+8)=B_HOST_TO_BENDIAN_INT16(mct);			//maxContours
			*(uint16*)(s+10)=B_HOST_TO_BENDIAN_INT16(0);			//maxCompositePoints
			*(uint16*)(s+12)=B_HOST_TO_BENDIAN_INT16(0);			//maxCompositeContours
			*(uint16*)(s+14)=B_HOST_TO_BENDIAN_INT16(1);			//maxZones
			*(uint16*)(s+16)=B_HOST_TO_BENDIAN_INT16(0);			//maxTwilightPoints
			*(uint16*)(s+18)=B_HOST_TO_BENDIAN_INT16(0);			//maxStorage
			*(uint16*)(s+20)=B_HOST_TO_BENDIAN_INT16(0);			//maxFunctionDefs
			*(uint16*)(s+22)=B_HOST_TO_BENDIAN_INT16(0);			//maxInstructionDefs
			*(uint16*)(s+24)=B_HOST_TO_BENDIAN_INT16(0);			//maxStackElements
			*(uint16*)(s+26)=B_HOST_TO_BENDIAN_INT16(0);			//maxSizeOfInstructions
			*(uint16*)(s+28)=B_HOST_TO_BENDIAN_INT16(0);			//maxComponentElements
			*(uint16*)(s+30)=B_HOST_TO_BENDIAN_INT16(0);			//maxComponentDepth
			tblhd[i].sum=sumB32((uint32*)s,32);
			tblhd[i].len=32;
			fwrite(s,1,32,ofp);
		}else if(tblname[i]=='cmap'){
printf("cmap\n");
			uint	sc,sr,es;
			sc=1;sr=1;es=-1;
			for(int j=1;j<chrs;j++)if(g[j].o-g[j-1].o!=1)sc++;
			while(sr<sc){sr<<=1;es++;}
			uint	cml=4+8*2+(6+256)+(sc*8+18);
			uchar	*cm=new uchar[cml];
			*(uint16*)cm=B_HOST_TO_BENDIAN_INT16(0);			//version
			*(uint16*)(cm+2)=B_HOST_TO_BENDIAN_INT16(2);		//tables=2
			*(uint16*)(cm+4)=B_HOST_TO_BENDIAN_INT16(1);		//tbl-1 P-ID=1
			*(uint16*)(cm+6)=B_HOST_TO_BENDIAN_INT16(0);		//      E-ID=0(symbol)
			*(uint32*)(cm+8)=B_HOST_TO_BENDIAN_INT32(20);		//  	offset
			*(uint16*)(cm+12)=B_HOST_TO_BENDIAN_INT16(3);		//tbl-2 P-ID=3
			*(uint16*)(cm+14)=B_HOST_TO_BENDIAN_INT16(1);		//      E-ID=1(unicode)
			*(uint32*)(cm+16)=B_HOST_TO_BENDIAN_INT32(282);		//  	offset
															//table-1
			*(uint16*)(cm+20)=B_HOST_TO_BENDIAN_INT16(0);		//format=0(Byte encoding)
			*(uint16*)(cm+22)=B_HOST_TO_BENDIAN_INT16(262);		//length
			*(uint16*)(cm+24)=B_HOST_TO_BENDIAN_INT16(0);		//version

			for(int j=0;j<256;j++)*(cm+26+j)=0;
			for(int j=1;g[j].o<256;j++)*(cm+26+g[j].o)=j;
															//table-2
			*(uint16*)(cm+282)=B_HOST_TO_BENDIAN_INT16(4);		//format=4(Segment mapping)
			*(uint16*)(cm+284)=B_HOST_TO_BENDIAN_INT16(sc*8+18);//length
			*(uint16*)(cm+286)=B_HOST_TO_BENDIAN_INT16(0);		//version
			*(uint16*)(cm+288)=B_HOST_TO_BENDIAN_INT16(sc*2);	//segCountX2
			*(uint16*)(cm+290)=B_HOST_TO_BENDIAN_INT16(sr);		//searchRange
			*(uint16*)(cm+292)=B_HOST_TO_BENDIAN_INT16(es);		//entrySelector
			*(uint16*)(cm+294)=B_HOST_TO_BENDIAN_INT16(sc*2-sr);//rangeShift
			uint16	*ecp=(uint16*)(cm+296);						//endCode
			*(uint16*)(cm+296+sc*2)=B_HOST_TO_BENDIAN_INT16(0);	//reserved
			uint16	*scp=(uint16*)(cm+298+sc*2);				//startCode
			uint16	*idp=(uint16*)(cm+298+sc*4);				//idDelta
			uint16	*irp=(uint16*)(cm+298+sc*6);				//idRangeOffset
			*(uint16*)(cm+298+sc*8)=B_HOST_TO_BENDIAN_INT16(0);	//(dummy)glyphIdArray[]
			uint	d=1;
			*(scp++)=B_HOST_TO_BENDIAN_INT16(g[1].o);
			*(idp++)=B_HOST_TO_BENDIAN_INT16(d-g[1].o);
			*(irp++)=B_HOST_TO_BENDIAN_INT16(0);
			for(int j=2;j<chrs;j++){
				d++;
				if(g[j].o-g[j-1].o!=1){
					*(ecp++)=B_HOST_TO_BENDIAN_INT16(g[j-1].o);
					*(scp++)=B_HOST_TO_BENDIAN_INT16(g[d].o);
					*(idp++)=B_HOST_TO_BENDIAN_INT16(d-g[d].o);
					*(irp++)=B_HOST_TO_BENDIAN_INT16(0);
				}
			}
			*(ecp++)=B_HOST_TO_BENDIAN_INT16(g[chrs-1].o);
			*(scp++)=B_HOST_TO_BENDIAN_INT16(0xffff);
			*(idp++)=B_HOST_TO_BENDIAN_INT16(1);
			*(irp++)=B_HOST_TO_BENDIAN_INT16(0);
			*(ecp++)=B_HOST_TO_BENDIAN_INT16(0xffff);
			tblhd[i].sum=sumB32((uint32*)cm,cml);
			tblhd[i].len=cml;
			fwrite(cm,1,cml,ofp);
			delete	cm;
		}else if(tblname[i]=='loca'){
printf("loca\n");
			uint32	*lc=new uint32[chrs+1];
			uint32	p=0;
			for(int j=0;j<chrs;j++){
				lc[j]=B_HOST_TO_BENDIAN_INT32(p);
				p+=g[j].l;
			}
			lc[chrs]=B_HOST_TO_BENDIAN_INT32(p);
			tblhd[i].sum=sumB32(lc,(chrs+1)*4);
			tblhd[i].len=(chrs+1)*4;
			fwrite(lc,1,(chrs+1)*4,ofp);
			delete	lc;
		}else if(tblname[i]=='glyf'){
printf("glyf\n");
			uint32	gfl=0;
			uchar	*gf=new uchar[0x1000000];	//16MB
if(gf)printf("malloc ok\n");
else printf("cannot malloc");
			uchar	*gfp=gf;
			mpt=1;mct=1;
			for(int j=1;j<chrs;j++){
				int	k;
				for(k=0;k<btc;k++){
					if(uni2bno[k][g[j].o]==-1)continue;
//printf("no=%04x unicode=%04x pt=%d\n",j,g[j].o,pt[k]);
					uint	bml=pt[k]*pt[k];	bml=(bml+7)/8;
					uchar	*dp=rb+0x200000*k+bml*uni2bno[k][g[j].o];//rb+bad[k]+bml*uni2bno[k][g[j].o];
					g[j].l=bmp2glf(pt[k]/hz(g[j].o),pt[k],dp,gfp);
					break;
				}
				if(k==btc)g[j].l=0;
				gfp+=g[j].l;
				if(mpt<glyf.mpt)mpt=glyf.mpt;
				if(mct<glyf.mct)mct=glyf.mct;
			}
			gfl=gfp-gf;
printf("glyf size=%08lx\n",gfl);
			tblhd[i].sum=sumB32((uint32*)gf,gfl);
			tblhd[i].len=gfl;
			fwrite(gf,1,gfl,ofp);
			delete	gf;
		}else if(tblname[i]=='post'){
printf("post\n");
			*(uint32*)(s)=B_HOST_TO_BENDIAN_INT32(0x30000);			//FormatType
			*(uint32*)(s+4)=B_HOST_TO_BENDIAN_INT32(0x140000);		//italicAngle
			*(uint16*)(s+8)=B_HOST_TO_BENDIAN_INT16(-100);			//underlinePosition
			*(uint16*)(s+10)=B_HOST_TO_BENDIAN_INT16(30);			//underlineThickness
			*(uint32*)(s+12)=B_HOST_TO_BENDIAN_INT32(0);			//isFixedPitch
			*(uint32*)(s+16)=B_HOST_TO_BENDIAN_INT32(0);			//minMemType42
			*(uint32*)(s+20)=B_HOST_TO_BENDIAN_INT32(0);			//maxMemType42
			*(uint32*)(s+24)=B_HOST_TO_BENDIAN_INT32(0);			//minMemType1
			*(uint32*)(s+28)=B_HOST_TO_BENDIAN_INT32(0);			//maxMemType1
			tblhd[i].sum=sumB32((uint32*)s,32);
			tblhd[i].len=32;
			fwrite(s,1,32,ofp);
		}else if(tblname[i]=='OS/2'){
printf("OS/2\n");
			*(uint16*)(s)=B_HOST_TO_BENDIAN_INT16(0x0001);			//version
			*(uint16*)(s+2)=B_HOST_TO_BENDIAN_INT16(500);			//xAvgCharWidth
			*(uint16*)(s+4)=B_HOST_TO_BENDIAN_INT16(weight*100);	//usWeightClass
			*(uint16*)(s+6)=B_HOST_TO_BENDIAN_INT16(5);				//usWidthClass
			*(uint16*)(s+8)=B_HOST_TO_BENDIAN_INT16(4);				//fsType
			*(uint16*)(s+10)=B_HOST_TO_BENDIAN_INT16(500);			//ySubscriptXSize
			*(uint16*)(s+12)=B_HOST_TO_BENDIAN_INT16(500);			//ySubscriptYSize
			*(uint16*)(s+14)=B_HOST_TO_BENDIAN_INT16(0);			//ySubscriptXOffset
			*(uint16*)(s+16)=B_HOST_TO_BENDIAN_INT16(360);			//ySubscriptYOffset
			*(uint16*)(s+18)=B_HOST_TO_BENDIAN_INT16(500);			//ySuperscriptXSize
			*(uint16*)(s+20)=B_HOST_TO_BENDIAN_INT16(500);			//ySuperscriptYSize
			*(uint16*)(s+22)=B_HOST_TO_BENDIAN_INT16(0);			//ySuperscriptXOffset
			*(uint16*)(s+24)=B_HOST_TO_BENDIAN_INT16(430);			//ySuperscriptYOffset
			*(uint16*)(s+26)=B_HOST_TO_BENDIAN_INT16(50);			//yStrikeoutSize
			*(uint16*)(s+28)=B_HOST_TO_BENDIAN_INT16(400);			//yStrikeoutPosition
			*(uint16*)(s+30)=B_HOST_TO_BENDIAN_INT16(0);			//sFamilyClass
			*(uchar*)(s+32)=0x02;				//panose(FamilyKind)
			*(uchar*)(s+33)=0x00;				//panose(SerifStyle)
			*(uchar*)(s+34)=weight+1;			//panose(Weight)
			*(uchar*)(s+35)=0x09;				//panose(Proportion)
			*(uchar*)(s+36)=0x00;				//panose(Contrast)
			*(uchar*)(s+37)=0x00;				//panose(StrokeVariation)
			*(uchar*)(s+38)=0x00;				//panose(ArmStyle)
			*(uchar*)(s+39)=0x00;				//panose(Letterform)
			*(uchar*)(s+40)=0x00;				//panose(Midline)
			*(uchar*)(s+41)=0x00;				//panose(X-height)
			*(uint32*)(s+42)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange1
			*(uint32*)(s+46)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange2
			*(uint32*)(s+50)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange3
			*(uint32*)(s+54)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulUnicodeRange4
			*(uint32*)(s+58)=B_HOST_TO_BENDIAN_INT32(vendid);		//achVendID
			*(uint16*)(s+62)=B_HOST_TO_BENDIAN_INT16(0x40);			//fsSelection
			*(uint16*)(s+64)=B_HOST_TO_BENDIAN_INT16(0x0001);		//usFirstCharIndex
			*(uint16*)(s+66)=B_HOST_TO_BENDIAN_INT16(0xfffe);		//usLastCharIndex
			*(uint16*)(s+68)=B_HOST_TO_BENDIAN_INT16(860);			//sTypoAscender
			*(uint16*)(s+70)=B_HOST_TO_BENDIAN_INT16(-140);			//sTypoDescender
			*(uint16*)(s+72)=B_HOST_TO_BENDIAN_INT16(0);			//sTypoLineGap
			*(uint16*)(s+74)=B_HOST_TO_BENDIAN_INT16(860);			//usWinAscent
			*(uint16*)(s+76)=B_HOST_TO_BENDIAN_INT16(140);			//usWinDescent
			*(uint32*)(s+78)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulCodePageRange1
			*(uint32*)(s+82)=B_HOST_TO_BENDIAN_INT32(0xffffffff);	//ulCodePageRange2
																s[86]=s[87]=0;
			tblhd[i].sum=sumB32((uint32*)s,88);
			tblhd[i].len=88;
			fwrite(s,1,88,ofp);
		}else if(tblname[i]=='EBDT'){
printf("EBDT\n");
			uint32	ebl=4;
			int	bmzl,bmhl;
			for(int j=0;j<btc;j++){
				bmzl=pt[j]*pt[j];	bmzl=(bmzl+7)/8;
				ebl+=bmzl*bchrs[j];
			}
																ebl=(ebl+3)&-4;
			uchar	*eb=new uchar[ebl];
			*(uint32*)eb=B_HOST_TO_BENDIAN_INT32(0x20000);			//tableVersionNumber
			uchar	*ebp=eb+4;
			for(int j=0;j<btc;j++){
				uchar	*bp=rb+0x200000*j;//rb+bad[j];
				bmzl=pt[j]*pt[j];	bmzl=(bmzl+7)/8;
				bmhl=pt[j]*pt[j]/2;	bmhl=(bmhl+7)/8;
				for(int k=1;k<chrs;k++){
					int	bno=uni2bno[j][g[k].o];
					if(bno<0)continue;
					int	bml=(hz(g[k].o)==1)?bmzl:bmhl;
					memcpy((void*)ebp,(void*)(bp+bno*bmzl),bml);
					ebp+=bml;
				}
			}
			ebl=ebp-eb;
																while(ebl&3)eb[ebl++]=0;
			tblhd[i].sum=sumB32((uint32*)eb,ebl);
			tblhd[i].len=ebl;
			fwrite(eb,1,ebl,ofp);
			delete eb;
		}else if(tblname[i]=='EBLC'){
printf("EBLC\n");
			uint32	ebl=8;							

			uint	blc[MAXBTC];
			for(int j=0;j<btc;j++){
				blc[j]=0;
				for(int k=1;k<chrs;k++){
//printf("uni2bno[%d][%04x]=%04x\n",j,k,uni2bno[j][g[k].o]);
					if(uni2bno[j][g[k].o]==-1)continue;
					if((uni2bno[j][g[k-1].o]==-1)||(hz(g[k-1].o)!=hz(g[k].o)))blc[j]++;
				}
//printf("blc[%d]=%d\n",j,blc[j]);
				ebl+=48+28*blc[j];
			}

			uchar	*eb=new uchar[ebl];
			uint	bmp=4;
			*(uint32*)(eb)=B_HOST_TO_BENDIAN_INT32(0x20000);		//tableVersionNumber
			*(uint32*)(eb+4)=B_HOST_TO_BENDIAN_INT32(btc);			//numSizes
			uchar	*ebp=eb+8;
			uint32	istao=8+48*btc;
			for(int j=0;j<btc;j++){
				*(uint32*)(ebp)=B_HOST_TO_BENDIAN_INT32(istao);		//indexSubTableArrayOffset
				*(uint32*)(ebp+4)=B_HOST_TO_BENDIAN_INT32(28);		//indexTableSize
				*(uint32*)(ebp+8)=B_HOST_TO_BENDIAN_INT32(blc[j]);	//numberOfIndexSubTables
				*(uint32*)(ebp+12)=B_HOST_TO_BENDIAN_INT32(0);		//colorRef
				*(uchar*)(ebp+16)=pt[j]-1;							//h-ascender
				*(uchar*)(ebp+17)=1;								//h-descender
				*(uchar*)(ebp+18)=pt[j];							//h-widthMax
				*(uchar*)(ebp+19)=0;								//h-caretSlopeNumerator
				*(uchar*)(ebp+20)=0;								//h-caretSlopeDenominator
				*(uchar*)(ebp+21)=0;								//h-caretOffset
				*(uchar*)(ebp+22)=0;								//h-minOriginSB
				*(uchar*)(ebp+23)=0;								//h-minAdvanceSB
				*(uchar*)(ebp+24)=pt[j];							//h-maxBeforeBL
				*(uchar*)(ebp+25)=0;								//h-minAfterBL
				*(uchar*)(ebp+26)=0;								//h-pad1
				*(uchar*)(ebp+27)=0;								//h-pad2
				*(uchar*)(ebp+28)=pt[j]-1;							//v-ascender
				*(uchar*)(ebp+29)=1;								//v-descender
				*(uchar*)(ebp+30)=pt[j];							//v-widthMax
				*(uchar*)(ebp+31)=0;								//v-caretSlopeNumerator
				*(uchar*)(ebp+32)=0;								//v-caretSlopeDenominator
				*(uchar*)(ebp+33)=0;								//v-caretOffset
				*(uchar*)(ebp+34)=0;								//v-minOriginSB
				*(uchar*)(ebp+35)=0;								//v-minAdvanceSB
				*(uchar*)(ebp+36)=pt[j];							//v-maxBeforeBL
				*(uchar*)(ebp+37)=0;								//v-minAfterBL
				*(uchar*)(ebp+38)=0;								//v-pad1
				*(uchar*)(ebp+39)=0;								//v-pad2
				*(uint16*)(ebp+40)=B_HOST_TO_BENDIAN_INT16(1);		//startGlyphIndex
				*(uint16*)(ebp+42)=B_HOST_TO_BENDIAN_INT16(chrs-1);	//endGlyphIndex
				*(uchar*)(ebp+44)=pt[j];							//ppemX
				*(uchar*)(ebp+45)=pt[j];							//ppemY
				*(uchar*)(ebp+46)=1;								//bitDepth
				*(uchar*)(ebp+47)=1;								//flags
				ebp+=48;
				istao+=blc[j]*28;
			}
			
			for(int j=0;j<btc;j++){
				int	k=0;
				for(int fg=1;fg<chrs;fg++){
if(uni2bno[j][g[fg].o]==-1)printf("skip j=%d no=%04x  code=%04x\n",j,fg,g[fg].o);
					if(uni2bno[j][g[fg].o]==-1)continue;
					int16	lg=fg;
					for(;lg<chrs-1;lg++){
						if(uni2bno[j][g[lg+1].o]==-1)break;
						if(hz(g[lg].o)!=hz(g[lg+1].o))break;
					}

					uchar	*pp=ebp+k*8;
					int		poff=blc[j]*8+k*20;
					*(uint16*)(pp)=B_HOST_TO_BENDIAN_INT16(fg);		//firstGlyphIndex
					*(uint16*)(pp+2)=B_HOST_TO_BENDIAN_INT16(lg);	//lastGlyphIndex
					*(uint32*)(pp+4)=B_HOST_TO_BENDIAN_INT32(poff);	//additionalOffsetToIndexSubtable

					uint	bml=pt[j]*pt[j]/hz(g[fg].o);	bml=(bml+7)/8;
					pp=ebp+poff;
					*(uint16*)(pp)=B_HOST_TO_BENDIAN_INT16(2);		//indexFormat
					*(uint16*)(pp+2)=B_HOST_TO_BENDIAN_INT16(5);	//imageFormat
					*(uint32*)(pp+4)=B_HOST_TO_BENDIAN_INT32(bmp);	//imageDataOffset
					*(uint32*)(pp+8)=B_HOST_TO_BENDIAN_INT32(bml);	//imageSize
					*(uchar*)(pp+12)=pt[j];							//height
					*(uchar*)(pp+13)=pt[j]/hz(g[fg].o);				//width
					*(uchar*)(pp+14)=0;								//horiBearingX
					*(uchar*)(pp+15)=pt[j]-2;						//horiBearingY
					*(uchar*)(pp+16)=pt[j]/hz(g[fg].o);				//horiAdvance
					*(uchar*)(pp+17)=0;								//vertBearingX
					*(uchar*)(pp+18)=0;								//vertBearingY
					*(uchar*)(pp+19)=pt[j]/hz(g[fg].o);				//vertAdvance
					bmp+=bml*(lg-fg+1);

					fg=lg;
					k++;
				}
				ebp+=blc[j]*28;
			}

			tblhd[i].sum=sumB32((uint32*)eb,ebl);
			tblhd[i].len=ebl;
			fwrite(eb,1,ebl,ofp);
			delete eb;
		}else if(tblname[i]=='gasp'){
printf("gasp\n");
			*(uint16*)(s)=B_HOST_TO_BENDIAN_INT16(0);				//version
			*(uint16*)(s+2)=B_HOST_TO_BENDIAN_INT16(3);				//numRanges
			*(uint16*)(s+4)=B_HOST_TO_BENDIAN_INT16(pt[0]*2);		//rangeMaxPPEM[0]
			*(uint16*)(s+6)=B_HOST_TO_BENDIAN_INT16(0x02);			//rengeGaspBehavior[0]DOGRAY
			*(uint16*)(s+8)=B_HOST_TO_BENDIAN_INT16(pt[0]*3);		//rangeMaxPPEM[1]
			*(uint16*)(s+10)=B_HOST_TO_BENDIAN_INT16(0x01);			//rengeGaspBehavior[1]GRIDFIT
			*(uint16*)(s+12)=B_HOST_TO_BENDIAN_INT16(0xffff);		//rangeMaxPPEM[2]
			*(uint16*)(s+14)=B_HOST_TO_BENDIAN_INT16(0x03);			//rengeGaspBehavior[2]GRIDFIT|DOGRAY
			tblhd[i].sum=sumB32((uint32*)s,16);
			tblhd[i].len=16;
			fwrite(s,1,16,ofp);
		}else{
printf("error\n");
			tblhd[i].len=0;
			tblhd[i].sum=0;
		}
	}
	
	delete rb;
	
printf("create table-index\n");
	uint16	hdl=12+16*tbls;
	uchar	*hd=new uchar[hdl];
	uint16	es,sr;
	es=0;	sr=1;
	while(sr*2<=tbls){sr*=2;es++;}
	sr*=16;
	*(uint32*)(hd)=B_HOST_TO_BENDIAN_INT32(0x10000);			//sfntVersion
	*(uint16*)(hd+4)=B_HOST_TO_BENDIAN_INT16(tbls);				//numTables
	*(uint16*)(hd+6)=B_HOST_TO_BENDIAN_INT16(sr);				//searchRange
	*(uint16*)(hd+8)=B_HOST_TO_BENDIAN_INT16(es);				//entrySelector
	*(uint16*)(hd+10)=B_HOST_TO_BENDIAN_INT16(tbls*16-sr);		//rangeShift
	uint32	*hdp=(uint32*)(hd+12);
	uint32	off=hdl;
	uint32	sump;
	for(int i=0;i<tbls;i++){
		tblhd[i].off=off;
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tblhd[i].tag);
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tblhd[i].sum);
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tblhd[i].off);
		*(hdp++)=B_HOST_TO_BENDIAN_INT32(tblhd[i].len);
		if(tblhd[i].tag=='head')sump=tblhd[i].off+8;
		off+=tblhd[i].len;
	}
	fseek(ofp,0,0);
	fwrite(hd,1,hdl,ofp);

printf("sum\n");
	uint32	sum=0;
	while((uchar*)hdp>=hd)sum+=B_BENDIAN_TO_HOST_INT32(*(hdp--));
	for(int i=0;i<tbls;i++)sum+=tblhd[i].sum;
	sum=0xb1b0afba-sum;
	fseek(ofp,sump,0);
	*(uint32*)s=B_HOST_TO_BENDIAN_INT32(sum);	//sum adj. in 'head'
	fwrite(s,1,4,ofp);
	delete	hd;
	fclose(ofp);

printf("set MIME\n");
	BFile	wf(ofn,B_WRITE_ONLY);
	BAppFileInfo	wfi(&wf);
	wfi.SetType("application/x-truetype");
	quit("");
}

int bmp2glf(uchar w,uchar h,uchar *bmp,uchar *glf)
{
	glyf.pro=0;
	int	glen=0;
	int	pt=h;
	uchar	*p,b;
	uchar	*t1=new uchar[(w+2)*(h*2)];
	for(int i=0;i<(w+2)*(h*2);i++)t1[i]=0;
	p=bmp;b=0x80;
	for(int ih=0;ih<h;ih++)for(int iw=0;iw<w;iw++){
		if(*p&b)t1[(ih+1)*(w+2)+(iw+1)]=1;
		b>>=1;if(b==0){b=0x80;p++;}
	}
	int	t2l=w*h*2+w*3+h*3+4;
	uchar	*t2=new uchar[t2l];
	for(int i=0;i<t2l;i++)t2[i]=0;
	for(int ix=0;ix<w;ix++)for(int iy=0;iy<=h;iy++){
		t2[(w*2+3)*iy+(w+2+ix)]=t1[iy*(w+2)+(ix+1)]^t1[(iy+1)*(w+2)+(ix+1)];
	}
	for(int iy=0;iy<h;iy++)for(int ix=0;ix<=w;ix++){
		t2[(w*2+3)*(iy+1)+ix]=t1[(iy+1)*(w+2)+ix]^t1[(iy+1)*(w+2)+(ix+1)];
	}

	static uchar	dd[12]={	11,1,6,8,4,9,2,7,3,5,10,0	};
	int	ddd[12];
	ddd[0]=-w-1;ddd[1]=1;ddd[2]=w+2;ddd[3]=w+1;ddd[4]=-1;ddd[5]=-w-2;
	ddd[6]=w+2;ddd[7]=w*2+3;ddd[8]=w+1;ddd[9]=-w-2;ddd[10]=-w*2-3;ddd[11]=-w-1;
	int	ptc;
	
	glyf.xmin=glyf.ymin=9999;
	glyf.xmax=glyf.ymax=-9999;
	glyf.noc=0;
	glyf.ilen=0;
	glyf.dxl=glyf.dyl=0;
	
	glyf.bx=0;	glyf.by=0;	//before point
	glyf.pt=0;				//points

	for(int i=0;i<t2l;i++){
		if(t2[i]==0)continue;
		ptc=0;
		int	y=(i-w-1)/(w*2+3);
		int	x=(i-w-1)-y*(w*2+3)-1;
		uchar	d=t1[(y+1)*(w+2)+(x+1)]?1:4;
		for(int j=i;;j+=ddd[d]){
			y=(j-w-1)/(w*2+3);
			x=(j-w-1)-y*(w*2+3)-1;
			if(d<6){
				//setpoint(x+0.5,y)
				set_glf_point(((float)x+0.5)*1000/pt,999-((float)y+1)*990/pt,ptc++);
			}else{
				x-=w+1;
				//setpoint(x,y+0.5)
				set_glf_point((float)x*1000/pt,999-((float)y+1.5)*990/pt,ptc++);
			}
			t2[j]=0;
			d/=3;
			if(t2[j+ddd[dd[d*3]]])d=dd[d*3];
			else if(t2[j+ddd[dd[d*3+1]]])d=dd[d*3+1];
			else if(t2[j+ddd[dd[d*3+2]]])d=dd[d*3+2];
			else break;
		}
		//set-end
		point2glyf(ptc);
	}
	
	glen=outputglyf(glf);

	delete t1;delete t2;
	return(glen);
}

void set_glf_point(int x,int y,int p)
{
//printf("(%d,%d)-",x,y);
	points[p].tag=CVPOINT;
	points[p].x=x;
	points[p++].y=y;
}

void point2glyf(int p)
{
	int	epoc=(glyf.noc>0)?glyf.epoc[glyf.noc-1]:-1;
	if((points[0].x==points[p-1].x)&&(points[0].y==points[p-1].y))points[0].tag=points[--p].tag;
	glyf.pt+=p;
	for(int i=0;i<p;i++){
		points[i].y-=100;		//baseline=100
		if(points[i].x<glyf.xmin)glyf.xmin=points[i].x;
		if(points[i].x>glyf.xmax)glyf.xmax=points[i].x;
		if(points[i].y<glyf.ymin)glyf.ymin=points[i].y;
		if(points[i].y>glyf.ymax)glyf.ymax=points[i].y;
		int16	dx=points[i].x-glyf.bx;	int16	dy=points[i].y-glyf.by;
		uchar	f=(points[i].tag==CVPOINT)?0:1;	//0=curve 1=straight
		if(f==1){
			if(i==0){
				if((points[p-1].tag==CVPOINT)&&(points[i+1].tag==CVPOINT))f=0;
			}else if(i==p-1){
				if((points[i-1].tag==CVPOINT)&&(points[0].tag==CVPOINT))f=0;
			}else{
				if((points[i-1].tag==CVPOINT)&&(points[i+1].tag==CVPOINT))f=0;
			}
		}
		if(dx==0){
			f|=0x10;
		}else if((dx<0)&&(dx>-256)){
			f|=0x02;
			glyf.dx[glyf.dxl++]=-dx;
		}else if((dx>0)&&(dx<256)){
			f|=0x12;
			glyf.dx[glyf.dxl++]=dx;
		}else{
			glyf.dx[glyf.dxl++]=dx>>8;
			glyf.dx[glyf.dxl++]=dx&255;
		}
		if(dy==0){
			f|=0x20;
		}else if((dy<0)&&(dy>-256)){
			f|=0x04;
			glyf.dy[glyf.dyl++]=-dy;
		}else if((dy>0)&&(dy<256)){
			f|=0x24;
			glyf.dy[glyf.dyl++]=dy;
		}else{
			glyf.dy[glyf.dyl++]=dy>>8;
			glyf.dy[glyf.dyl++]=dy&255;
		}
		glyf.bx=points[i].x;		glyf.by=points[i].y;
		glyf.flag[++epoc]=f;
	}
	glyf.epoc[glyf.noc++]=epoc;
}

int outputglyf(uchar *wb)
{
	if(glyf.noc==0)return(0);
	if((glyf.pro==0)||(glyf.noc==0)){glyf.xmin=0;glyf.ymin=-140;glyf.xmax=999;glyf.ymax=859;}	//space or tohaba
	if(glyf.noc>glyf.mct)glyf.mct=glyf.noc;
	if(glyf.pt>glyf.mpt)glyf.mpt=glyf.pt;
	int		wbl=0;
//printf("xmin,ymin,xmax,ymax=%d %d %d %d\n",glyf.xmin,glyf.ymin,glyf.xmax,glyf.ymax);
	wb[wbl++]=glyf.noc>>8;	wb[wbl++]=glyf.noc&255;
	wb[wbl++]=glyf.xmin>>8;	wb[wbl++]=glyf.xmin&255;
	wb[wbl++]=glyf.ymin>>8;	wb[wbl++]=glyf.ymin&255;
	wb[wbl++]=glyf.xmax>>8;	wb[wbl++]=glyf.xmax&255;
	wb[wbl++]=glyf.ymax>>8;	wb[wbl++]=glyf.ymax&255;
	if(glyf.noc>0){
		for(int i=0;i<glyf.noc;i++){
			wb[wbl++]=glyf.epoc[i]>>8;	wb[wbl++]=glyf.epoc[i]&255;
		}
		wb[wbl++]=glyf.ilen>>8;	wb[wbl++]=glyf.ilen&255;
		for(int i=0;i<glyf.ilen;i++){
			wb[wbl++]=glyf.inst[i]>>8;	wb[wbl++]=glyf.inst[i]&255;
		}
		for(int i=0;i<=glyf.epoc[glyf.noc-1];i++)wb[wbl++]=glyf.flag[i];
		for(int i=0;i<glyf.dxl;i++)wb[wbl++]=glyf.dx[i];
		for(int i=0;i<glyf.dyl;i++)wb[wbl++]=glyf.dy[i];
	}
	while(wbl&3)wb[wbl++]=0;
	return(wbl);
}

void sort_glyph(GLYPH *g,int s,int e)
{
	GLYPH	d;
	for(int	i=s;i<=e;i++){
		int	m=i;
		for(int j=i+1;j<=e;j++){
			if(g[m].o>g[j].o)m=j;
		}
		if(m!=i){
			memcpy((void*)&d,(void*)(g+m),sizeof(GLYPH));
			memcpy((void*)(g+m),(void*)(g+i),sizeof(GLYPH));
			memcpy((void*)(g+i),(void*)&d,sizeof(GLYPH));
		}
	}
}

uint32 sumB32(uint32 *p,int len)
{
	uint32	sum=0;
	len=len/4;
	while(len--)sum+=B_BENDIAN_TO_HOST_INT32(*(p++));
	return(sum);
}

uchar readbdf(int fc,char **fn,uchar *rb)
{
	FILE	*ifp;
	char	*ifn;
	uchar	btc=0;		//bitmap-table-count
	char	s[256];
	char	cs;

//	bad[0]=0;
	for(int i=0;i<fc;i++){
		ifn=fn[i];
printf("%s\n",ifn);
		if((ifp=fopen(ifn,"r"))==NULL)quit("cannot open bdf-file");
		int	pxl,fbbw,fbbh,xoff,yoff;
		int	btn,bml;
		pxl=0;cs=0;btn=-1;
		while(fgets(s,255,ifp)){
			if(!strncmp(s,"CHARSET_REGISTRY",16)){
				char	f=0;
				char	*sp=s+17;
				while(*sp<=' ')sp++;
				if((!strncmp(sp+1,"JISX0201",8))||(!strncmp(sp+1,"jisx0201",8)))f=1;
				if((!strncmp(sp+1,"JISX0208",8))||(!strncmp(sp+1,"jisx0208",8)))f=2;
				if((!strncmp(sp+1,"JISX0212",8))||(!strncmp(sp+1,"jisx0212",8)))f=3;
				if((!strncmp(sp+1,"JISX0213",8))||(!strncmp(sp+1,"jisx0213",8)))f=4;
				if(f==0)quit("not supported charset");
			}
			if(!strncmp(s,"CHARSET_ENCODING",16)){
				char	*sp=s+17;
				while(*sp<=' ')sp++;
				if(!strncmp(sp,"\"0\"",3))cs=1;
				if(!strncmp(sp,"\"1\"",3))cs=2;
				if(!strncmp(sp,"\"2\"",3))cs=3;
				if(cs==0)quit("not supported encoding");
			}
			if(!strncmp(s,"PIXEL_SIZE",10)){
				sscanf(s+11,"%d",&pxl);
				for(btn=0;btn<btc;btn++)if(pt[btn]==pxl)break;
				if(btn==btc)pt[btc++]=pxl;
				bml=pxl*pxl;	bml=(bml+7)/8;
//printf("%d pt : tblno.=%d\n",pxl,btn);
			}
			if(!strncmp(s,"FONTBOUNDINGBOX",15)){
				sscanf(s+16,"%d %d %d %d",&fbbw,&fbbh,&xoff,&yoff);
			}
			if(!strncmp(s,"ENDPROPERTIES",13))break;
		}
		if((cs==0)||(pxl==0))quit("readbdf\n");
		while(fgets(s,255,ifp)){
			if(!strncmp(s,"ENCODING",8)){
				int	c,cc;
				sscanf(s+9,"%d",&cc);
//printf("jiscode=%04x\n",c);
				c=unicode(cs,cc);
				if(c==0)printf("undefined code : cs=%d c=%04x\n",cs,cc);
//printf("unicode=%04x\n",c);
				if((c)&&(uni2bno[btn][c]==-1)){	//xfer
//printf("xfer\n");
					while(fgets(s,255,ifp)){
						int	bbw,bbh,bbxoff,bbyoff;
						if(!strncmp(s,"BBX",3)){
							sscanf(s+4,"%d %d %d %d",&bbw,&bbh,&bbxoff,&bbyoff);
						}
						if(!strncmp(s,"BITMAP",6)){
							uint32	rp=0x200000*btn+bml*bchrs[btn];//bad[btn]+bml*bchrs[btn];
							for(int j=0;j<bml;j++)rb[rp+j]=0;//bad[btn+1]+=bml;
							uchar	b=0x80;
							for(int iy=0;iy<pxl;iy++){
								if(iy<bbh)fgets(s,256,ifp);else strcpy(s,"0000000000000000");
								for(int ix=0;ix<pxl/hz(c);ix++){
									uchar	hex=0;
									if(ix<bbw)hex=s[ix/4]<'A'?s[ix/4]-'0':(s[ix/4]&0xdf)-'A'+10;
									if(hex&(8>>(ix%4)))rb[rp]|=b;
									b>>=1;if(b==0){b=0x80;rp++;}
								}
							}
							uni2bno[btn][c]=bchrs[btn]++;
						}
						if(!strncmp(s,"ENDCHAR",7))break;
					}
				}
			}
			if(!strncmp(s,"ENDFONT",7))break;
		}
		fclose(ifp);
	}
	return(btc);
}

uint16 setxfertbl(char *fn,uint16 *xtbl)
{
	uint16	xchrs=0;
	for(int i=0;i<2*94*94;i++)xtbl[i]=0;
	FILE	*tfp;
	int		chrs;
	char	s[256];
	if((tfp=fopen(fn,"r"))==NULL)quit("cannot open < jis_uni.txt >");
	fgets(s,255,tfp);	sscanf(s,"%d",&chrs);
	printf("jis-uni xfer-table : %d chrs\n",chrs);
	while(fgets(s,255,tfp)){
		int		jis,uni;
		sscanf(s,"%x %x",&jis,&uni);
		xtbl[(jis>>16)*94*94+(((jis>>8)&255)-0x21)*94+((jis&255)-0x21)]=uni;
		xchrs++;
	}
	fclose(tfp);
	return(xchrs);
}

uint32 unicode(uint cs,uint16 c)
{
	uint32	uc=0;
	if(cs==1){
		if((c>=0x20)&&(c<=0x7e))uc=c;
		if((c>=0xa1)&&(c<=0xdf))uc=c+0xfec0;
		if(c>0xff)uc=j2u[(((c>>8)&255)-0x21)*94+((c&255)-0x21)];
	}
	if(cs==2){
		if((c>=0x20)&&(c<=0x7e))uc=c;
		if((c>=0xa1)&&(c<=0xdf))uc=c+0xfec0;
		if(c>0xff)uc=j2u[(((c>>8)&255)-0x21)*94+((c&255)-0x21)];
	}
	if(cs==3){
		if((c>=0x20)&&(c<=0x7e))uc=c;
		if((c>=0xa1)&&(c<=0xdf))uc=c+0xfec0;
		if(c>0xff)uc=j2u[94*94+(((c>>8)&255)-0x21)*94+((c&255)-0x21)];
	}
	return(uc);
}

int hz(uint16 uc)
{
	int		hz;
	if((uc<0x0080)||((uc>0xff60)&&(uc<0xffe0))){	//half width
		hz=2;
	}else{											//full width
		hz=1;
	}
	return(hz);
}

void quit(char *p)
{
	if(*p)printf("error : %s\n",p);
	else printf("complete\n");
	exit(0);
}
